/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.awt.graphics;

import com.kitfox.svg.SVGCache;
import com.kitfox.svg.SVGDiagram;
import com.kitfox.svg.SVGUniverse;
import com.kitfox.svg.app.beans.SVGIcon;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.mapsforge.core.graphics.GraphicUtils;
import org.mapsforge.map.awt.graphics.AwtResourceBitmap;

public class AwtSvgBitmap
extends AwtResourceBitmap {
    public static float DEFAULT_SIZE = 400.0f;

    public static BufferedImage getResourceBitmap(InputStream inputStream, String name, float scaleFactor, float defaultSize, int width, int height, int percent) throws IOException {
        try {
            URI uri = SVGCache.getSVGUniverse().loadSVG(inputStream, name);
            SVGDiagram diagram = SVGCache.getSVGUniverse().getDiagram(uri);
            double scale = (double)scaleFactor / Math.sqrt(diagram.getHeight() * diagram.getWidth() / defaultSize);
            float[] bmpSize = GraphicUtils.imageSize((float)diagram.getWidth(), (float)diagram.getHeight(), (float)((float)scale), (int)width, (int)height, (int)percent);
            SVGIcon icon = new SVGIcon();
            icon.setAntiAlias(true);
            icon.setAutosize(4);
            icon.setPreferredSize(new Dimension((int)bmpSize[0], (int)bmpSize[1]));
            icon.setSvgURI(uri);
            BufferedImage bufferedImage = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
            icon.paintIcon(null, (Graphics)bufferedImage.createGraphics(), 0, 0);
            return bufferedImage;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BufferedImage getResourceBitmapImpl(InputStream inputStream, int hash, float scaleFactor, int width, int height, int percent) throws IOException {
        SVGUniverse sVGUniverse = SVGCache.getSVGUniverse();
        synchronized (sVGUniverse) {
            return AwtSvgBitmap.getResourceBitmap(inputStream, Integer.toString(hash), scaleFactor, DEFAULT_SIZE, width, height, percent);
        }
    }

    public AwtSvgBitmap(InputStream inputStream, int hash, float scaleFactor, int width, int height, int percent) throws IOException {
        super(AwtSvgBitmap.getResourceBitmapImpl(inputStream, hash, scaleFactor, width, height, percent));
    }
}

