/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.awt.graphics;

import java.awt.Composite;
import java.awt.CompositeContext;
import java.awt.RenderingHints;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;

public class AwtLuminanceShadingComposite
implements Composite {
    private final float magnitude;

    public AwtLuminanceShadingComposite(float magnitude) {
        this.magnitude = Math.max(0.0f, Math.min(magnitude, 1.0f));
    }

    @Override
    public CompositeContext createContext(ColorModel srcColorModel, ColorModel dstColorModel, RenderingHints hints) {
        return new CompositeContext(){
            int[] srcBytes = new int[4];
            float[] inFloats = new float[4];
            float[] outFloats = new float[4];

            @Override
            public void dispose() {
            }

            @Override
            public void compose(Raster src, Raster dstIn, WritableRaster dstOut) {
                int width = src.getWidth();
                int height = src.getHeight();
                float magnitudeRest = 1.0f - AwtLuminanceShadingComposite.this.magnitude;
                for (int x = 0; x < width; ++x) {
                    for (int y = 0; y < height; ++y) {
                        src.getPixel(x, y, this.srcBytes);
                        int shadeVal = this.srcBytes[0];
                        float add = (float)shadeVal * AwtLuminanceShadingComposite.this.magnitude;
                        dstIn.getPixel(x, y, this.inFloats);
                        float inV = Math.max(this.inFloats[0], Math.max(this.inFloats[1], this.inFloats[2]));
                        float vScaled = inV * magnitudeRest;
                        float vSum = vScaled + add;
                        if (inV == 0.0f) {
                            this.outFloats[0] = vSum;
                            this.outFloats[1] = vSum;
                            this.outFloats[2] = vSum;
                        } else {
                            float factor = vSum / inV;
                            this.outFloats[0] = factor * this.inFloats[0];
                            this.outFloats[1] = factor * this.inFloats[1];
                            this.outFloats[2] = factor * this.inFloats[2];
                        }
                        dstOut.setPixel(x, y, this.outFloats);
                    }
                }
            }
        };
    }
}

