/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.awt.input;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import javax.swing.SwingUtilities;
import org.mapsforge.core.model.LatLong;
import org.mapsforge.core.model.Point;
import org.mapsforge.map.awt.view.MapView;
import org.mapsforge.map.layer.Layer;

public class MouseEventListener
extends MouseAdapter {
    private final MapView mapView;
    private java.awt.Point lastDragPoint;

    public MouseEventListener(MapView mapView) {
        this.mapView = mapView;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        LatLong tapLatLong;
        if (SwingUtilities.isLeftMouseButton(e) && (tapLatLong = this.mapView.getMapViewProjection().fromPixels((double)e.getX(), (double)e.getY())) != null) {
            Point layerXY;
            Layer layer;
            Point tapXY = new Point((double)e.getX(), (double)e.getY());
            for (int i = this.mapView.getLayerManager().getLayers().size() - 1; i >= 0 && !(layer = this.mapView.getLayerManager().getLayers().get(i)).onTap(tapLatLong, layerXY = this.mapView.getMapViewProjection().toPixels(layer.getPosition()), tapXY); --i) {
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (SwingUtilities.isLeftMouseButton(e)) {
            java.awt.Point point = e.getPoint();
            if (this.lastDragPoint != null) {
                this.mapView.onMoveEvent();
                int moveHorizontal = point.x - this.lastDragPoint.x;
                int moveVertical = point.y - this.lastDragPoint.y;
                this.mapView.getModel().mapViewPosition.moveCenter((double)moveHorizontal, (double)moveVertical);
            }
            this.lastDragPoint = point;
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (SwingUtilities.isLeftMouseButton(e)) {
            this.lastDragPoint = e.getPoint();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.lastDragPoint = null;
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        this.mapView.onZoomEvent();
        byte zoomLevelDiff = (byte)(-e.getWheelRotation());
        this.mapView.getModel().mapViewPosition.zoom(zoomLevelDiff);
    }
}

