/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.awt.graphics;

import com.kitfox.svg.SVGCache;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.InputStream;
import org.mapsforge.core.graphics.Bitmap;
import org.mapsforge.core.graphics.Canvas;
import org.mapsforge.core.graphics.Display;
import org.mapsforge.core.graphics.GraphicContext;
import org.mapsforge.core.graphics.GraphicFactory;
import org.mapsforge.core.graphics.Matrix;
import org.mapsforge.core.graphics.Paint;
import org.mapsforge.core.graphics.Path;
import org.mapsforge.core.graphics.Position;
import org.mapsforge.core.graphics.ResourceBitmap;
import org.mapsforge.core.graphics.TileBitmap;
import org.mapsforge.core.mapelements.PointTextContainer;
import org.mapsforge.core.mapelements.SymbolContainer;
import org.mapsforge.core.model.BoundingBox;
import org.mapsforge.core.model.Point;
import org.mapsforge.map.awt.graphics.AwtBitmap;
import org.mapsforge.map.awt.graphics.AwtCanvas;
import org.mapsforge.map.awt.graphics.AwtHillshadingBitmap;
import org.mapsforge.map.awt.graphics.AwtMatrix;
import org.mapsforge.map.awt.graphics.AwtPaint;
import org.mapsforge.map.awt.graphics.AwtPath;
import org.mapsforge.map.awt.graphics.AwtPointTextContainer;
import org.mapsforge.map.awt.graphics.AwtResourceBitmap;
import org.mapsforge.map.awt.graphics.AwtSvgBitmap;
import org.mapsforge.map.awt.graphics.AwtTileBitmap;

public class AwtGraphicFactory
implements GraphicFactory {
    public static final GraphicFactory INSTANCE = new AwtGraphicFactory();
    private static final Color TRANSPARENT = new Color(0, 0, 0, 0);
    private static final ColorModel monoColorModel;

    public static GraphicContext createGraphicContext(Graphics graphics) {
        return new AwtCanvas((Graphics2D)graphics);
    }

    static AffineTransform getAffineTransform(Matrix matrix) {
        return ((AwtMatrix)matrix).affineTransform;
    }

    public static Graphics2D getGraphics(Canvas canvas) {
        return ((AwtCanvas)canvas).getGraphicObject();
    }

    public static AwtPaint getPaint(Paint paint) {
        return (AwtPaint)paint;
    }

    static AwtPath getPath(Path path) {
        return (AwtPath)path;
    }

    static Color getColor(org.mapsforge.core.graphics.Color color) {
        switch (color) {
            case BLACK: {
                return Color.BLACK;
            }
            case BLUE: {
                return Color.BLUE;
            }
            case GREEN: {
                return Color.GREEN;
            }
            case RED: {
                return Color.RED;
            }
            case TRANSPARENT: {
                return TRANSPARENT;
            }
            case WHITE: {
                return Color.WHITE;
            }
        }
        throw new IllegalArgumentException("unknown color: " + color);
    }

    public static void clearResourceFileCache() {
    }

    public static void clearResourceMemoryCache() {
        SVGCache.getSVGUniverse().clear();
    }

    public Bitmap createBitmap(int width, int height) {
        return new AwtBitmap(width, height);
    }

    public Bitmap createBitmap(int width, int height, boolean isTransparent) {
        if (isTransparent) {
            throw new UnsupportedOperationException("No transparencies in AWT implementation");
        }
        return new AwtBitmap(width, height);
    }

    public static BufferedImage getBitmap(Bitmap bitmap) {
        return ((AwtBitmap)bitmap).bufferedImage;
    }

    public Canvas createCanvas() {
        return new AwtCanvas();
    }

    public int createColor(org.mapsforge.core.graphics.Color color) {
        return AwtGraphicFactory.getColor(color).getRGB();
    }

    public int createColor(int alpha, int red, int green, int blue) {
        return new Color(red, green, blue, alpha).getRGB();
    }

    public Matrix createMatrix() {
        return new AwtMatrix();
    }

    public AwtHillshadingBitmap createMonoBitmap(int width, int height, byte[] buffer, int padding, BoundingBox area) {
        DataBufferByte dataBuffer = new DataBufferByte(buffer, buffer.length);
        SampleModel singleByteSampleModel = monoColorModel.createCompatibleSampleModel(width + 2 * padding, height + 2 * padding);
        WritableRaster writableRaster = Raster.createWritableRaster(singleByteSampleModel, dataBuffer, null);
        BufferedImage bufferedImage = new BufferedImage(monoColorModel, writableRaster, false, null);
        return new AwtHillshadingBitmap(bufferedImage, padding, area);
    }

    public Paint createPaint() {
        return new AwtPaint();
    }

    public Paint createPaint(Paint paint) {
        return new AwtPaint(paint);
    }

    public Path createPath() {
        return new AwtPath();
    }

    public PointTextContainer createPointTextContainer(Point xy, Display display, int priority, String text, Paint paintFront, Paint paintBack, SymbolContainer symbolContainer, Position position, int maxTextWidth) {
        return new AwtPointTextContainer(xy, display, priority, text, paintFront, paintBack, symbolContainer, position, maxTextWidth);
    }

    public ResourceBitmap createResourceBitmap(InputStream inputStream, float scaleFactor, int width, int height, int percent, int hash) throws IOException {
        return new AwtResourceBitmap(inputStream, scaleFactor, width, height, percent);
    }

    public TileBitmap createTileBitmap(InputStream inputStream, int tileSize, boolean hasAlpha) throws IOException {
        return new AwtTileBitmap(inputStream);
    }

    public TileBitmap createTileBitmap(int tileSize, boolean hasAlpha) {
        return new AwtTileBitmap(tileSize, hasAlpha);
    }

    public InputStream platformSpecificSources(String relativePathPrefix, String src) throws IOException {
        return null;
    }

    public ResourceBitmap renderSvg(InputStream inputStream, float scaleFactor, int width, int height, int percent, int hash) throws IOException {
        return new AwtSvgBitmap(inputStream, hash, scaleFactor, width, height, percent);
    }

    static {
        byte[] linear = new byte[256];
        for (int i = 0; i < 256; ++i) {
            linear[i] = (byte)(255 - i);
        }
        monoColorModel = new IndexColorModel(8, 256, linear, linear, linear);
    }
}

