/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb;

import java.io.DataInput;
import java.io.IOError;
import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.locks.Lock;
import org.mapdb.CC;
import org.mapdb.DBException;
import org.mapdb.DataIO;
import org.mapdb.Fun;
import org.mapdb.Serializer;
import org.mapdb.Store;
import org.mapdb.StoreCached;
import org.mapdb.StoreDirect;
import org.mapdb.Volume;
import org.mapdb.WriteAheadLog;

public class StoreWAL
extends StoreCached {
    protected static final int FULL_REPLAY_AFTER_N_TX = 16;
    protected final Store.LongLongMap[] committedIndexTable;
    protected final Store.LongLongMap[] uncommittedIndexTable;
    protected final Store.LongLongMap[] committedDataLongs;
    protected final Store.LongLongMap[] uncommittedDataLongs;
    protected final Store.LongLongMap committedPageLongStack = new Store.LongLongMap();
    protected byte[] headVolBackup;
    protected long[] indexPagesBackup;
    protected Volume realVol;
    protected volatile boolean $_TEST_HACK_COMPACT_PRE_COMMIT_WAIT = false;
    protected volatile boolean $_TEST_HACK_COMPACT_POST_COMMIT_WAIT = false;
    protected final WriteAheadLog wal;

    public StoreWAL(String fileName) {
        this(fileName, fileName == null ? CC.DEFAULT_MEMORY_VOLUME_FACTORY : CC.DEFAULT_FILE_VOLUME_FACTORY, null, 16, 0, false, false, null, false, false, false, null, null, 0L, 0L, false, 0L, 0);
    }

    public StoreWAL(String fileName, Volume.VolumeFactory volumeFactory, Store.Cache cache, int lockScale, int lockingStrategy, boolean checksum, boolean compress, byte[] password, boolean readonly, boolean snapshotEnable, boolean fileLockDisable, DataIO.HeartbeatFileLock fileLockHeartbeat, ScheduledExecutorService executor, long startSize, long sizeIncrement, boolean recidReuseDisable, long executorScheduledRate, int writeQueueSize) {
        super(fileName, volumeFactory, cache, lockScale, lockingStrategy, checksum, compress, password, readonly, snapshotEnable, fileLockDisable, fileLockHeartbeat, executor, startSize, sizeIncrement, recidReuseDisable, executorScheduledRate, writeQueueSize);
        this.wal = new WriteAheadLog(fileName, volumeFactory, this.makeFeaturesBitmap());
        this.committedIndexTable = new Store.LongLongMap[this.lockScale];
        this.uncommittedIndexTable = new Store.LongLongMap[this.lockScale];
        this.committedDataLongs = new Store.LongLongMap[this.lockScale];
        this.uncommittedDataLongs = new Store.LongLongMap[this.lockScale];
        for (int i = 0; i < this.committedIndexTable.length; ++i) {
            this.committedIndexTable[i] = new Store.LongLongMap();
            this.uncommittedIndexTable[i] = new Store.LongLongMap();
            this.committedDataLongs[i] = new Store.LongLongMap();
            this.uncommittedDataLongs[i] = new Store.LongLongMap();
        }
    }

    @Override
    protected void initCreate() {
        super.initCreate();
        this.indexPagesBackup = (long[])this.indexPages.clone();
        this.realVol = this.vol;
        this.vol = new Volume.ReadOnly(this.vol);
    }

    @Override
    public void initOpen() {
        this.realVol = this.vol;
        if (this.readonly && !Volume.isEmptyFile(this.fileName + ".wal.0")) {
            throw new DBException.WrongConfig("There is dirty WAL file, but storage is read-only. Can not replay file");
        }
        this.wal.open(new WriteAheadLog.WALReplay(){

            @Override
            public void beforeReplayStart() {
            }

            @Override
            public void writeLong(long offset, long value) {
                StoreWAL.this.realVol.ensureAvailable(Fun.roundUp(offset + 8L, 0x100000L));
                StoreWAL.this.realVol.putLong(offset, value);
            }

            @Override
            public void writeRecord(long recid, long walId, Volume vol, long volOffset, int length) {
                throw new DBException.DataCorruption();
            }

            @Override
            public void writeByteArray(long offset, long walId, Volume vol, long volOffset, int length) {
                StoreWAL.this.realVol.ensureAvailable(Fun.roundUp(offset + (long)length, 0x100000L));
                vol.transferInto(volOffset, StoreWAL.this.realVol, offset, length);
            }

            @Override
            public void beforeDestroyWAL() {
            }

            @Override
            public void commit() {
            }

            @Override
            public void rollback() {
                throw new DBException.DataCorruption();
            }

            @Override
            public void writeTombstone(long recid) {
                throw new DBException.DataCorruption();
            }

            @Override
            public void writePreallocate(long recid) {
                throw new DBException.DataCorruption();
            }
        });
        this.realVol.sync();
        this.wal.destroyWalFiles();
        this.initOpenPost();
    }

    @Override
    protected void initFailedCloseFiles() {
        this.wal.initFailedCloseFiles();
    }

    protected void initOpenPost() {
        super.initOpen();
        this.indexPagesBackup = (long[])this.indexPages.clone();
        this.vol = new Volume.ReadOnly(this.vol);
    }

    @Override
    protected void initHeadVol() {
        super.initHeadVol();
        this.headVolBackup = new byte[32856];
        this.headVol.getData(0L, this.headVolBackup, 0, this.headVolBackup.length);
    }

    @Override
    protected void putDataSingleWithLink(int segment, long offset, long link, byte[] buf, int bufPos, int size) {
        byte[] buf2 = new byte[size + 8];
        DataIO.putLong(buf2, 0, link);
        System.arraycopy(buf, bufPos, buf2, 8, size);
        this.putDataSingleWithoutLink(segment, offset, buf2, 0, buf2.length);
    }

    @Override
    protected void putDataSingleWithoutLink(int segment, long offset, byte[] buf, int bufPos, int size) {
        if (size > 65535) {
            throw new DBException.DataCorruption("wrong length");
        }
        long val = this.wal.walPutByteArray(offset, buf, bufPos, size);
        this.uncommittedDataLongs[segment].put(offset, val);
    }

    protected DataInput walGetData(long offset, int segment) {
        long longval = this.uncommittedDataLongs[segment].get(offset);
        if (longval == 0L) {
            longval = this.committedDataLongs[segment].get(offset);
        }
        if (longval == 0L) {
            return null;
        }
        return this.wal.walGetByteArray(longval);
    }

    @Override
    protected long indexValGet(long recid) {
        long offset;
        int segment = this.lockPos(recid);
        long ret = this.uncommittedIndexTable[segment].get(offset = this.recidToOffset(recid));
        if (ret != 0L) {
            return ret;
        }
        ret = this.committedIndexTable[segment].get(offset);
        if (ret != 0L) {
            return ret;
        }
        return super.indexValGet(recid);
    }

    @Override
    protected long indexValGetRaw(long recid) {
        long offset;
        int segment = this.lockPos(recid);
        long ret = this.uncommittedIndexTable[segment].get(offset = this.recidToOffset(recid));
        if (ret != 0L) {
            return ret;
        }
        ret = this.committedIndexTable[segment].get(offset);
        if (ret != 0L) {
            return ret;
        }
        return super.indexValGetRaw(recid);
    }

    @Override
    protected void indexValPut(long recid, int size, long offset, boolean linked, boolean unused) {
        long newVal = StoreWAL.composeIndexVal(size, offset, linked, unused, true);
        this.uncommittedIndexTable[this.lockPos(recid)].put(this.recidToOffset(recid), newVal);
    }

    @Override
    protected void indexLongPut(long offset, long val) {
        this.wal.walPutLong(offset, val);
    }

    @Override
    protected long pageAllocate() {
        long storeSize = this.storeSizeGet();
        this.storeSizeSet(storeSize + 0x100000L);
        return storeSize;
    }

    @Override
    protected byte[] loadLongStackPage(long pageOffset, boolean willBeModified) {
        byte[] page = (byte[])this.uncommittedStackPages.get(pageOffset);
        if (page != null) {
            return page;
        }
        long walval = this.committedPageLongStack.get(pageOffset);
        if (walval != 0L) {
            byte[] b = this.wal.walGetByteArray2(walval);
            if (willBeModified) {
                this.uncommittedStackPages.put(pageOffset, b);
            }
            return b;
        }
        int pageSize = (int)(DataIO.parity4Get(this.vol.getLong(pageOffset)) >>> 48);
        page = new byte[pageSize];
        this.vol.getData(pageOffset, page, 0, pageSize);
        if (willBeModified) {
            this.uncommittedStackPages.put(pageOffset, page);
        }
        return page;
    }

    @Override
    protected long[] offsetsGet(int segment, long indexVal) {
        if (indexVal >>> 48 == 0L) {
            return (indexVal & 8L) != 0L ? null : StoreDirect.EMPTY_LONGS;
        }
        long[] ret = new long[]{indexVal};
        while ((ret[ret.length - 1] & 8L) != 0L) {
            long oldLink = (ret = Arrays.copyOf(ret, ret.length + 1))[ret.length - 2] & 0xFFFFFFFFFFF0L;
            long val = this.uncommittedDataLongs[segment].get(oldLink);
            if (val == 0L) {
                val = this.committedDataLongs[segment].get(oldLink);
            }
            if (val != 0L) {
                try {
                    val = this.wal.walGetByteArray(val).readLong();
                }
                catch (IOException e) {
                    throw new DBException.VolumeIOError(e);
                }
            } else {
                val = this.vol.getLong(oldLink);
            }
            ret[ret.length - 1] = DataIO.parity3Get(val);
        }
        return ret;
    }

    @Override
    protected <A> A get2(long recid, Serializer<A> serializer) {
        int segment = this.lockPos(recid);
        Object cached = this.writeCache[segment].get1(recid);
        if (cached != null) {
            if (cached == TOMBSTONE2) {
                return null;
            }
            return (A)cached;
        }
        long walval = this.uncommittedIndexTable[segment].get(this.recidToOffset(recid));
        if (walval == 0L) {
            walval = this.committedIndexTable[segment].get(this.recidToOffset(recid));
        }
        if (walval != 0L) {
            boolean linked = (walval & 8L) != 0L;
            int size = (int)(walval >>> 48);
            if (linked && size == 0) {
                return null;
            }
            if (size == 0) {
                return this.deserialize(serializer, 0, new DataIO.DataInputByteArray(new byte[0]));
            }
            if (linked) {
                try {
                    int chunkSize;
                    DataInput in2;
                    int totalSize = 0;
                    byte[] in = new byte[100];
                    long link = walval;
                    while ((link & 8L) != 0L) {
                        in2 = this.walGetData(link & 0xFFFFFFFFFFF0L, segment);
                        chunkSize = (int)(link >>> 48);
                        link = in2.readLong();
                        if (in.length < totalSize + chunkSize - 8) {
                            in = Arrays.copyOf(in, Math.max(in.length * 2, totalSize + chunkSize - 8));
                        }
                        in2.readFully(in, totalSize, chunkSize - 8);
                        totalSize += chunkSize - 8;
                    }
                    in2 = this.walGetData(link & 0xFFFFFFFFFFF0L, segment);
                    chunkSize = (int)(link >>> 48);
                    if (in.length < totalSize + chunkSize) {
                        in = Arrays.copyOf(in, Math.max(in.length * 2, totalSize + chunkSize));
                    }
                    in2.readFully(in, totalSize, chunkSize);
                    return this.deserialize(serializer, totalSize += chunkSize, new DataIO.DataInputByteArray(in, 0));
                }
                catch (IOException e) {
                    throw new IOError(e);
                }
            }
            DataInput in = this.walGetData(walval & 0xFFFFFFFFFFF0L, segment);
            return this.deserialize(serializer, (int)(walval >>> 48), in);
        }
        long[] offsets = this.offsetsGet(this.lockPos(recid), this.indexValGet(recid));
        if (offsets == null) {
            return null;
        }
        if (offsets.length == 0) {
            return this.deserialize(serializer, 0, new DataIO.DataInputByteArray(new byte[0]));
        }
        if (offsets.length == 1) {
            int size = (int)(offsets[0] >>> 48);
            long offset = offsets[0] & 0xFFFFFFFFFFF0L;
            DataInput in = this.vol.getDataInput(offset, size);
            return this.deserialize(serializer, size, in);
        }
        int totalSize = this.offsetsTotalSize(offsets);
        byte[] b = new byte[totalSize];
        int bpos = 0;
        for (int i = 0; i < offsets.length; ++i) {
            int plus = i == offsets.length - 1 ? 0 : 8;
            long size = (offsets[i] >>> 48) - (long)plus;
            long offset = offsets[i] & 0xFFFFFFFFFFF0L;
            this.vol.getData(offset + (long)plus, b, bpos, (int)size);
            bpos = (int)((long)bpos + size);
        }
        DataIO.DataInputByteArray in = new DataIO.DataInputByteArray(b);
        return this.deserialize(serializer, totalSize, in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback() throws UnsupportedOperationException {
        this.commitLock.lock();
        try {
            for (int segment = 0; segment < this.locks.length; ++segment) {
                Lock lock = this.locks[segment].writeLock();
                lock.lock();
                try {
                    this.writeCache[segment].clear();
                    if (this.caches != null) {
                        this.caches[segment].clear();
                    }
                    this.uncommittedDataLongs[segment].clear();
                    this.uncommittedIndexTable[segment].clear();
                    continue;
                }
                finally {
                    lock.unlock();
                }
            }
            this.structuralLock.lock();
            try {
                this.uncommittedStackPages.clear();
                this.headVol.putData(0L, this.headVolBackup, 0, this.headVolBackup.length);
                this.indexPages = (long[])this.indexPagesBackup.clone();
                this.wal.rollback();
                this.wal.sync();
            }
            finally {
                this.structuralLock.unlock();
            }
        }
        finally {
            this.commitLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() {
        this.commitLock.lock();
        try {
            this.flushWriteCache();
            for (int segment = 0; segment < this.locks.length; ++segment) {
                this.locks[segment].writeLock().lock();
                try {
                    long[] table = this.uncommittedIndexTable[segment].table;
                    int i = 0;
                    while (i < table.length) {
                        long offset = table[i++];
                        long val = table[i++];
                        if (offset == 0L) continue;
                        this.wal.walPutLong(offset, val);
                    }
                    this.moveAndClear(this.uncommittedIndexTable[segment], this.committedIndexTable[segment]);
                    this.moveAndClear(this.uncommittedDataLongs[segment], this.committedDataLongs[segment]);
                    continue;
                }
                finally {
                    this.locks[segment].writeLock().unlock();
                }
            }
            this.structuralLock.lock();
            try {
                long[] set = this.uncommittedStackPages.set;
                for (int i = 0; i < set.length; ++i) {
                    long offset = set[i];
                    if (offset == 0L) continue;
                    byte[] val = (byte[])this.uncommittedStackPages.values[i];
                    if (val == LONG_STACK_PAGE_TOMBSTONE) {
                        this.committedPageLongStack.put(offset, -1L);
                        continue;
                    }
                    long walPointer = this.wal.walPutByteArray(offset, val, 0, val.length);
                    this.committedPageLongStack.put(offset, walPointer);
                }
                this.uncommittedStackPages.clear();
                this.headVol.putInt(4L, this.headChecksum(this.headVol));
                this.headVol.getData(0L, this.headVolBackup, 0, this.headVolBackup.length);
                this.wal.walPutByteArray(0L, this.headVolBackup, 0, this.headVolBackup.length);
                this.wal.commit();
                this.wal.seal();
                this.replaySoft();
                this.realVol.sync();
                this.wal.destroyWalFiles();
            }
            finally {
                this.structuralLock.unlock();
            }
        }
        finally {
            this.commitLock.unlock();
        }
    }

    private void moveAndClear(Store.LongLongMap from, Store.LongLongMap to) {
        long[] table = from.table;
        int i = 0;
        while (i < table.length) {
            long key = table[i++];
            long val = table[i++];
            if (key == 0L) continue;
            to.put(key, val);
        }
        from.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void replaySoft() {
        Object written = null;
        for (int lockPos = 0; lockPos < this.locks.length; ++lockPos) {
            this.locks[lockPos].writeLock().lock();
            try {
                long[] table = this.committedIndexTable[lockPos].table;
                int pos = 0;
                while (pos < table.length) {
                    long recidOffset = table[pos++];
                    long val = table[pos++];
                    if (recidOffset == 0L || val == -1L) continue;
                    this.realVol.ensureAvailable(Fun.roundUp(recidOffset + 8L, 0x100000L));
                    this.realVol.putLong(recidOffset, val);
                }
                this.committedIndexTable[lockPos].clear();
                table = this.committedDataLongs[lockPos].table;
                pos = 0;
                while (pos < table.length) {
                    long volOffset = table[pos++];
                    long walPointer = table[pos++];
                    if (volOffset == 0L || walPointer == -1L) continue;
                    byte[] b = this.wal.walGetByteArray2(walPointer);
                    this.realVol.ensureAvailable(Fun.roundUp(volOffset + (long)b.length, 0x100000L));
                    this.realVol.putData(volOffset, b, 0, b.length);
                }
                this.committedDataLongs[lockPos].clear();
                continue;
            }
            finally {
                this.locks[lockPos].writeLock().unlock();
            }
        }
        this.structuralLock.lock();
        try {
            int pos = 0;
            while (pos < this.committedPageLongStack.table.length) {
                long volOffset = this.committedPageLongStack.table[pos++];
                long walPointer = this.committedPageLongStack.table[pos++];
                if (volOffset == 0L || walPointer == -1L) continue;
                byte[] b = this.wal.walGetByteArray2(walPointer);
                this.realVol.ensureAvailable(Fun.roundUp(volOffset + (long)b.length, 0x100000L));
                this.realVol.putData(volOffset, b, 0, b.length);
            }
            this.committedPageLongStack.clear();
            this.realVol.putData(0L, this.headVolBackup, 0, this.headVolBackup.length);
        }
        finally {
            this.structuralLock.unlock();
        }
    }

    private void assertRecord(long volOffset, byte[] b) {
    }

    @Override
    public boolean canRollback() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.commitLock.lock();
        try {
            if (this.closed) {
                return;
            }
            if (this.hasUncommitedData()) {
                LOG.warning("Closing storage with uncommited data, this data will be discarded.");
            }
            this.headVol.putData(0L, this.headVolBackup, 0, this.headVolBackup.length);
            if (!this.readonly) {
                this.replaySoft();
                this.wal.destroyWalFiles();
            }
            this.wal.close();
            this.vol.close();
            this.vol = null;
            this.headVol.close();
            this.headVol = null;
            this.headVolBackup = null;
            this.uncommittedStackPages.clear();
            if (this.caches != null) {
                for (Store.Cache c : this.caches) {
                    c.close();
                }
                Arrays.fill(this.caches, null);
            }
            if (this.fileLockHeartbeat != null) {
                this.fileLockHeartbeat.unlock();
                this.fileLockHeartbeat = null;
            }
            this.closed = true;
        }
        finally {
            this.commitLock.unlock();
        }
    }

    @Override
    public void compact() {
        LOG.warning("Compaction not yet implemented with StoreWAL, disable transactions to compact this store");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean hasUncommitedData() {
        for (int i = 0; i < this.locks.length; ++i) {
            Lock lock = this.locks[i].readLock();
            lock.lock();
            try {
                if (this.uncommittedIndexTable[i].size() == 0 && this.uncommittedDataLongs[i].size() == 0 && this.writeCache[i].size == 0) continue;
                boolean bl = true;
                return bl;
            }
            finally {
                lock.unlock();
            }
        }
        return false;
    }

    @Override
    protected void freeDataPut(int segment, long offset, int size) {
        if (segment >= 0) {
            this.uncommittedDataLongs[segment].put(offset, -1L);
        }
        super.freeDataPut(segment, offset, size);
    }
}

