/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import org.mapdb.CC;
import org.mapdb.DBException;
import org.mapdb.DataIO;
import org.mapdb.Engine;
import org.mapdb.Fun;
import org.mapdb.Serializer;
import org.mapdb.Store;
import org.mapdb.Volume;
import org.mapdb.WriteAheadLog;

public class StoreAppend
extends Store {
    protected static final int STORE_VERSION = 100;
    protected static final int HEADER = -1422065564;
    protected static final long headerSize = 16L;
    protected static final StoreAppend[] STORE_APPENDS_ZERO_ARRAY = new StoreAppend[0];
    protected WriteAheadLog wal;
    protected Volume headVol;
    protected Volume indexTable;
    protected final AtomicLong highestRecid = new AtomicLong(0L);
    protected final boolean tx;
    protected final Store.LongLongMap[] modified;
    protected final ScheduledExecutorService compactionExecutor;
    protected final Set<StoreAppend> snapshots;
    protected final boolean isSnapshot;
    protected final long startSize;
    protected final long sizeIncrement;
    protected final int sliceShift;

    protected StoreAppend(String fileName, Volume.VolumeFactory volumeFactory, Store.Cache cache, int lockScale, int lockingStrategy, boolean checksum, boolean compress, byte[] password, boolean readonly, boolean snapshotEnable, boolean fileLockDisable, DataIO.HeartbeatFileLock fileLockHeartbeat, boolean txDisabled, ScheduledExecutorService compactionExecutor, long startSize, long sizeIncrement) {
        super(fileName, volumeFactory, cache, lockScale, lockingStrategy, checksum, compress, password, readonly, snapshotEnable, fileLockDisable, fileLockHeartbeat);
        boolean bl = this.tx = !txDisabled;
        if (this.tx) {
            this.modified = new Store.LongLongMap[this.lockScale];
            for (int i = 0; i < this.modified.length; ++i) {
                this.modified[i] = new Store.LongLongMap();
            }
        } else {
            this.modified = null;
        }
        this.compactionExecutor = compactionExecutor;
        this.snapshots = Collections.synchronizedSet(new HashSet());
        this.isSnapshot = false;
        this.sizeIncrement = Math.max(0x100000L, DataIO.nextPowTwo(sizeIncrement));
        this.startSize = Fun.roundUp(Math.max(0x100000L, startSize), this.sizeIncrement);
        this.sliceShift = Volume.sliceShiftFromSize(this.sizeIncrement);
    }

    public StoreAppend(String fileName) {
        this(fileName, fileName == null ? CC.DEFAULT_MEMORY_VOLUME_FACTORY : CC.DEFAULT_FILE_VOLUME_FACTORY, null, 16, 0, false, false, null, false, false, false, null, false, null, 0L, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StoreAppend(StoreAppend host, Store.LongLongMap[] uncommitedData) {
        super(null, null, null, host.lockScale, 2, host.checksum, host.compress, null, true, false, false, null);
        int i;
        this.indexTable = host.indexTable;
        this.wal = host.wal;
        for (i = 0; i < this.locks.length; ++i) {
            this.locks[i] = host.locks[i];
        }
        this.tx = true;
        this.modified = new Store.LongLongMap[this.lockScale];
        if (uncommitedData == null) {
            for (i = 0; i < this.modified.length; ++i) {
                this.modified[i] = new Store.LongLongMap();
            }
        } else {
            for (i = 0; i < this.modified.length; ++i) {
                Lock lock = this.locks[i].writeLock();
                lock.lock();
                try {
                    this.modified[i] = uncommitedData[i].clone();
                    continue;
                }
                finally {
                    lock.unlock();
                }
            }
        }
        this.compactionExecutor = null;
        this.snapshots = host.snapshots;
        this.isSnapshot = true;
        host.snapshots.add(this);
        this.startSize = host.startSize;
        this.sizeIncrement = host.sizeIncrement;
        this.sliceShift = host.sliceShift;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init() {
        super.init();
        this.structuralLock.lock();
        try {
            boolean empty = Volume.isEmptyFile(this.fileName + ".wal.0");
            this.wal = new WriteAheadLog(this.fileName, this.volumeFactory, this.makeFeaturesBitmap());
            this.indexTable = new Volume.ByteArrayVol(20, 0L);
            this.indexTable.ensureAvailable(56L);
            int i = 0;
            while ((long)i <= 7L) {
                this.indexTable.ensureAvailable(i * 8);
                this.indexTable.putLong(i * 8, -3L);
                ++i;
            }
            if (empty) {
                this.initCreate();
            } else {
                this.initOpen();
            }
        }
        finally {
            this.structuralLock.unlock();
        }
    }

    protected void initCreate() {
        this.headVol = this.volumeFactory.makeVolume(this.fileName, false, true);
        this.headVol.ensureAvailable(16L);
        this.headVol.putInt(0L, -1422065564);
        this.headVol.putLong(8L, this.makeFeaturesBitmap());
        this.headVol.sync();
        this.wal.open(WriteAheadLog.NOREPLAY);
        for (long recid = 1L; recid <= 7L; ++recid) {
            this.wal.walPutPreallocate(recid);
        }
        this.wal.commit();
        this.highestRecid.set(7L);
    }

    protected void initOpen() {
        this.headVol = this.volumeFactory.makeVolume(this.fileName, false, true);
        if (this.headVol.getInt(0L) != -1422065564) {
            throw new DBException.DataCorruption("Wrong header at:" + this.fileName);
        }
        long featuresBitMap = this.headVol.getLong(8L);
        this.checkFeaturesBitmap(featuresBitMap);
        final AtomicLong highestRecid2 = new AtomicLong(7L);
        WriteAheadLog.WALReplay replay = new WriteAheadLog.WALReplay(){

            @Override
            public void beforeReplayStart() {
            }

            @Override
            public void writeLong(long offset, long value) {
                throw new DBException.DataCorruption();
            }

            @Override
            public void writeByteArray(long offset, long walId, Volume vol, long volOffset, int length) {
                throw new DBException.DataCorruption();
            }

            @Override
            public void writeRecord(long recid, long walId, Volume vol, long volOffset, int length) {
                highestRecid2.set(Math.max(highestRecid2.get(), recid));
                long recidOffset = recid * 8L;
                StoreAppend.this.indexTable.ensureAvailable(recidOffset + 8L);
                StoreAppend.this.indexTable.putLong(recidOffset, walId);
            }

            @Override
            public void beforeDestroyWAL() {
            }

            @Override
            public void commit() {
            }

            @Override
            public void rollback() {
                throw new DBException.DataCorruption();
            }

            @Override
            public void writeTombstone(long recid) {
                StoreAppend.this.indexTable.ensureAvailable(recid * 8L + 8L);
                StoreAppend.this.indexTable.putLong(recid * 8L, -1L);
            }

            @Override
            public void writePreallocate(long recid) {
                StoreAppend.this.indexTable.ensureAvailable(recid * 8L + 8L);
                StoreAppend.this.indexTable.putLong(recid * 8L, -3L);
            }
        };
        this.wal.open(replay);
        this.highestRecid.set(highestRecid2.get());
    }

    @Override
    protected <A> A get2(long recid, Serializer<A> serializer) {
        long walId;
        long l = walId = this.tx ? this.modified[this.lockPos(recid)].get(recid) : 0L;
        if (walId == 0L) {
            try {
                walId = this.indexTable.getLong(recid * 8L);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new DBException.EngineGetVoid();
            }
        }
        if (walId == 0L) {
            throw new DBException.EngineGetVoid();
        }
        if (walId == -1L || walId == -3L) {
            return null;
        }
        byte[] b = this.wal.walGetRecord(walId, recid);
        if (b == null) {
            return null;
        }
        DataIO.DataInputByteArray input = new DataIO.DataInputByteArray(b);
        return this.deserialize(serializer, b.length, input);
    }

    @Override
    protected void update2(long recid, DataIO.DataOutputByteArray out) {
        this.insertOrUpdate(recid, out, false);
    }

    private void insertOrUpdate(long recid, DataIO.DataOutputByteArray out, boolean isInsert) {
        long walId = this.wal.walPutRecord(recid, out == null ? null : out.buf, 0, out == null ? 0 : out.pos);
        this.indexTablePut(recid, walId);
    }

    @Override
    protected <A> void delete2(long recid, Serializer<A> serializer) {
        this.wal.walPutTombstone(recid);
        this.indexTablePut(recid, -1L);
    }

    @Override
    public long getCurrSize() {
        return 0L;
    }

    @Override
    public long getFreeSize() {
        return 0L;
    }

    @Override
    public boolean fileLoad() {
        return this.wal.fileLoad();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long preallocate() {
        long recid = this.highestRecid.incrementAndGet();
        Lock lock = this.locks[this.lockPos(recid)].writeLock();
        lock.lock();
        try {
            this.wal.walPutPreallocate(recid);
            this.indexTablePut(recid, -3L);
        }
        finally {
            lock.unlock();
        }
        return recid;
    }

    protected void indexTablePut(long recid, long walId) {
        if (this.tx) {
            this.modified[this.lockPos(recid)].put(recid, walId);
        } else {
            this.indexTable.ensureAvailable(recid * 8L + 8L);
            this.indexTable.putLong(recid * 8L, walId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A> long put(A value, Serializer<A> serializer) {
        DataIO.DataOutputByteArray out = this.serialize(value, serializer);
        long recid = this.highestRecid.incrementAndGet();
        int lockPos = this.lockPos(recid);
        Store.Cache cache = this.caches == null ? null : this.caches[lockPos];
        Lock lock = this.locks[lockPos].writeLock();
        lock.lock();
        try {
            if (cache != null) {
                cache.put(recid, value);
            }
            this.insertOrUpdate(recid, out, true);
        }
        finally {
            lock.unlock();
        }
        return recid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.commitLock.lock();
        try {
            if (this.closed) {
                return;
            }
            if (this.isSnapshot) {
                this.snapshots.remove(this);
                return;
            }
            if (!this.readonly) {
                if (this.tx) {
                    this.wal.rollback();
                }
                this.wal.seal();
            }
            this.wal.close();
            this.indexTable.close();
            this.headVol.close();
            if (this.caches != null) {
                for (Store.Cache c : this.caches) {
                    c.close();
                }
                Arrays.fill(this.caches, null);
            }
            if (this.fileLockHeartbeat != null) {
                this.fileLockHeartbeat.unlock();
                this.fileLockHeartbeat = null;
            }
            this.closed = true;
        }
        finally {
            this.commitLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() {
        if (this.isSnapshot) {
            return;
        }
        if (!this.tx) {
            this.wal.commit();
            return;
        }
        this.commitLock.lock();
        try {
            StoreAppend[] snaps = this.snapshots == null ? STORE_APPENDS_ZERO_ARRAY : this.snapshots.toArray(STORE_APPENDS_ZERO_ARRAY);
            for (int i = 0; i < this.locks.length; ++i) {
                Lock lock = this.locks[i].writeLock();
                lock.lock();
                try {
                    long[] m = this.modified[i].table;
                    for (int j = 0; j < m.length; j += 2) {
                        long recid = m[j];
                        long recidOffset = recid * 8L;
                        if (recidOffset == 0L) continue;
                        this.indexTable.ensureAvailable(recidOffset + 8L);
                        long oldVal = this.indexTable.getLong(recidOffset);
                        this.indexTable.putLong(recidOffset, m[j + 1]);
                        for (StoreAppend snap : snaps) {
                            Store.LongLongMap m2 = snap.modified[i];
                            if (m2.get(recid) != 0L) continue;
                            m2.put(recid, oldVal);
                        }
                    }
                    this.modified[i].clear();
                    continue;
                }
                finally {
                    lock.unlock();
                }
            }
            this.wal.commit();
        }
        finally {
            this.commitLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback() throws UnsupportedOperationException {
        if (!this.tx || this.readonly || this.isSnapshot) {
            throw new UnsupportedOperationException();
        }
        this.commitLock.lock();
        try {
            for (int i = 0; i < this.locks.length; ++i) {
                Lock lock = this.locks[i].writeLock();
                lock.lock();
                try {
                    this.modified[i].clear();
                    continue;
                }
                finally {
                    lock.unlock();
                }
            }
            this.wal.rollback();
        }
        finally {
            this.commitLock.unlock();
        }
    }

    @Override
    public boolean canRollback() {
        return this.tx;
    }

    @Override
    public boolean canSnapshot() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Engine snapshot() throws UnsupportedOperationException {
        this.commitLock.lock();
        try {
            StoreAppend storeAppend = new StoreAppend(this, this.modified);
            return storeAppend;
        }
        finally {
            this.commitLock.unlock();
        }
    }

    @Override
    public void compact() {
        if (this.isSnapshot) {
            return;
        }
    }

    @Override
    public void backup(OutputStream out, boolean incremental) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public void backupRestore(InputStream[] in) {
        throw new UnsupportedOperationException("not yet implemented");
    }
}

