/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb;

import java.io.File;
import java.io.IOError;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.logging.Logger;
import org.mapdb.BTreeMap;
import org.mapdb.CC;
import org.mapdb.DB;
import org.mapdb.DBException;
import org.mapdb.DataIO;
import org.mapdb.Engine;
import org.mapdb.Fun;
import org.mapdb.HTreeMap;
import org.mapdb.Serializer;
import org.mapdb.SerializerPojo;
import org.mapdb.Store;
import org.mapdb.StoreAppend;
import org.mapdb.StoreArchive;
import org.mapdb.StoreCached;
import org.mapdb.StoreDirect;
import org.mapdb.StoreHeap;
import org.mapdb.StoreWAL;
import org.mapdb.TxEngine;
import org.mapdb.TxMaker;
import org.mapdb.Volume;

public final class DBMaker {
    protected static final Logger LOG = Logger.getLogger(DBMaker.class.getName());
    protected static final String TRUE = "true";

    public static Maker heapDB() {
        return new Maker()._newHeapDB();
    }

    public static Maker newHeapDB() {
        return DBMaker.heapDB();
    }

    public static Maker memoryDB() {
        return new Maker()._newMemoryDB();
    }

    public static Maker newMemoryDB() {
        return DBMaker.memoryDB();
    }

    public static Maker memoryDirectDB() {
        return new Maker()._newMemoryDirectDB();
    }

    public static Maker newMemoryDirectDB() {
        return DBMaker.memoryDirectDB();
    }

    public static Maker memoryUnsafeDB() {
        return new Maker()._newMemoryUnsafeDB();
    }

    public static Maker newMemoryUnsafeDB() {
        return DBMaker.memoryUnsafeDB();
    }

    public static Maker appendFileDB(File file) {
        return new Maker()._newAppendFileDB(file);
    }

    public static Maker archiveFileDB(File file) {
        return new Maker()._newArchiveFileDB(file);
    }

    public static Maker newAppendFileDB(File file) {
        return DBMaker.appendFileDB(file);
    }

    public static <K, V> BTreeMap<K, V> tempTreeMap() {
        return DBMaker.newTempFileDB().deleteFilesAfterClose().closeOnJvmShutdown().transactionDisable().make().treeMapCreate("temp").closeEngine().make();
    }

    public static <K, V> BTreeMap<K, V> newTempTreeMap() {
        return DBMaker.tempTreeMap();
    }

    public static <K, V> HTreeMap<K, V> tempHashMap() {
        return DBMaker.newTempFileDB().deleteFilesAfterClose().closeOnJvmShutdown().transactionDisable().make().hashMapCreate("temp").closeEngine().make();
    }

    public static <K, V> HTreeMap<K, V> newTempHashMap() {
        return DBMaker.tempHashMap();
    }

    public static <K> NavigableSet<K> tempTreeSet() {
        return DBMaker.newTempFileDB().deleteFilesAfterClose().closeOnJvmShutdown().transactionDisable().make().treeSetCreate("temp").standalone().make();
    }

    public static <K> NavigableSet<K> newTempTreeSet() {
        return DBMaker.tempTreeSet();
    }

    public static <K> Set<K> tempHashSet() {
        return DBMaker.newTempFileDB().deleteFilesAfterClose().closeOnJvmShutdown().transactionDisable().make().hashSetCreate("temp").closeEngine().make();
    }

    public static <K> Set<K> newTempHashSet() {
        return DBMaker.tempHashSet();
    }

    public static Maker tempFileDB() {
        try {
            return DBMaker.newFileDB(File.createTempFile("mapdb-temp", "db"));
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    public static Maker newTempFileDB() {
        return DBMaker.tempFileDB();
    }

    public static <K, V> HTreeMap<K, V> newCacheDirect(double size) {
        return DBMaker.memoryDirectDB().transactionDisable().make().hashMapCreate("cache").expireStoreSize(size).counterEnable().make();
    }

    public static <K, V> HTreeMap<K, V> newCache(double size) {
        return DBMaker.memoryDB().transactionDisable().make().hashMapCreate("cache").expireStoreSize(size).counterEnable().make();
    }

    public static Maker fileDB(File file) {
        return new Maker(file);
    }

    public static Maker newFileDB(File file) {
        return DBMaker.fileDB(file);
    }

    public static DB.HTreeMapMaker hashMapSegmented(Maker maker) {
        maker = maker.lockScale(1).lockDisable().transactionDisable();
        DB db = maker.make();
        Engine[] engines = new Engine[16];
        engines[0] = db.engine;
        for (int i = 1; i < 16; ++i) {
            engines[i] = maker.makeEngine();
        }
        return new DB.HTreeMapMaker(db, "hashMapSegmented", engines).closeEngine();
    }

    public static DB.HTreeMapMaker hashMapSegmentedMemory() {
        return DBMaker.hashMapSegmented(DBMaker.memoryDB());
    }

    public static DB.HTreeMapMaker hashMapSegmentedMemoryDirect() {
        return DBMaker.hashMapSegmented(DBMaker.memoryDirectDB());
    }

    public static Map<String, Object> CC() throws IllegalAccessException {
        TreeMap<String, Object> ret = new TreeMap<String, Object>();
        for (Field f : CC.class.getDeclaredFields()) {
            f.setAccessible(true);
            Object value = f.get(null);
            ret.put(f.getName(), value);
        }
        return ret;
    }

    public static final class Maker {
        protected Fun.RecordCondition cacheCondition;
        protected ScheduledExecutorService executor;
        protected ScheduledExecutorService metricsExecutor;
        protected ScheduledExecutorService cacheExecutor;
        protected ScheduledExecutorService storeExecutor;
        protected ClassLoader serializerClassLoader;
        protected Map<String, ClassLoader> serializerClassLoaderRegistry;
        protected Properties props = new Properties();

        protected Maker() {
        }

        protected Maker(File file) {
            this.props.setProperty("file", file.getPath());
        }

        public Maker _newHeapDB() {
            this.props.setProperty("store", "heap");
            return this;
        }

        public Maker _newMemoryDB() {
            this.props.setProperty("volume", "byteBuffer");
            return this;
        }

        public Maker _newMemoryDirectDB() {
            this.props.setProperty("volume", "directByteBuffer");
            return this;
        }

        public Maker _newMemoryUnsafeDB() {
            this.props.setProperty("volume", "unsafe");
            return this;
        }

        public Maker _newAppendFileDB(File file) {
            this.props.setProperty("file", file.getPath());
            this.props.setProperty("store", "append");
            return this;
        }

        public Maker _newArchiveFileDB(File file) {
            this.props.setProperty("file", file.getPath());
            this.props.setProperty("store", "archive");
            return this;
        }

        public Maker _newFileDB(File file) {
            this.props.setProperty("file", file.getPath());
            return this;
        }

        public Maker executorEnable() {
            this.executor = Executors.newScheduledThreadPool(4);
            return this;
        }

        public Maker transactionDisable() {
            this.props.put("transactionDisable", DBMaker.TRUE);
            return this;
        }

        public Maker metricsEnable() {
            return this.metricsEnable(10000L);
        }

        public Maker metricsEnable(long metricsLogPeriod) {
            this.props.put("metrics", DBMaker.TRUE);
            this.props.put("metricsLogInterval", "" + metricsLogPeriod);
            return this;
        }

        public Maker metricsExecutorEnable() {
            return this.metricsExecutorEnable(Executors.newSingleThreadScheduledExecutor());
        }

        public Maker metricsExecutorEnable(ScheduledExecutorService metricsExecutor) {
            this.metricsExecutor = metricsExecutor;
            return this;
        }

        public Maker cacheExecutorEnable() {
            return this.cacheExecutorEnable(Executors.newSingleThreadScheduledExecutor());
        }

        public Maker cacheExecutorEnable(ScheduledExecutorService metricsExecutor) {
            this.cacheExecutor = metricsExecutor;
            return this;
        }

        public Maker cacheExecutorPeriod(long period) {
            this.props.put("cacheExecutorPeriod", "" + period);
            return this;
        }

        public Maker storeExecutorEnable() {
            return this.storeExecutorEnable(Executors.newScheduledThreadPool(4));
        }

        public Maker storeExecutorEnable(ScheduledExecutorService metricsExecutor) {
            this.storeExecutor = metricsExecutor;
            return this;
        }

        public Maker storeExecutorPeriod(long period) {
            this.props.put("storeExecutorPeriod", "" + period);
            return this;
        }

        public Maker cacheCondition(Fun.RecordCondition cacheCondition) {
            this.cacheCondition = cacheCondition;
            return this;
        }

        public Maker cacheDisable() {
            this.props.put("cache", "disable");
            return this;
        }

        public Maker cacheHardRefEnable() {
            this.props.put("cache", "hardRef");
            return this;
        }

        public Maker cacheSize(int cacheSize) {
            this.props.setProperty("cacheSize", "" + cacheSize);
            return this;
        }

        public Maker cacheHashTableEnable() {
            this.props.put("cache", "hashTable");
            return this;
        }

        public Maker cacheHashTableEnable(int cacheSize) {
            this.props.put("cache", "hashTable");
            this.props.setProperty("cacheSize", "" + cacheSize);
            return this;
        }

        public Maker cacheWeakRefEnable() {
            this.props.put("cache", "weakRef");
            return this;
        }

        public Maker cacheSoftRefEnable() {
            this.props.put("cache", "softRef");
            return this;
        }

        public Maker cacheLRUEnable() {
            this.props.put("cache", "lru");
            return this;
        }

        public Maker lockDisable() {
            this.props.put("lock", "threadUnsafe");
            return this;
        }

        public Maker lockSingleEnable() {
            this.props.put("lock", "single");
            return this;
        }

        public Maker lockScale(int scale) {
            this.props.put("lockScale", "" + scale);
            return this;
        }

        public Maker mmapFileEnable() {
            return this.fileMmapEnable();
        }

        public Maker fileMmapEnable() {
            this.assertNotInMemoryVolume();
            this.props.setProperty("volume", "mmapf");
            return this;
        }

        public Maker fileMmapCleanerHackEnable() {
            this.props.setProperty("fileMmapCleanerHack", DBMaker.TRUE);
            return this;
        }

        public Maker fileLockDisable() {
            this.props.setProperty("fileLockDisable", DBMaker.TRUE);
            return this;
        }

        public Maker fileLockHeartbeatEnable() {
            this.props.setProperty("fileLockHeartbeatEnable", DBMaker.TRUE);
            return this;
        }

        private void assertNotInMemoryVolume() {
            if ("byteBuffer".equals(this.props.getProperty("volume")) || "directByteBuffer".equals(this.props.getProperty("volume"))) {
                throw new IllegalArgumentException("Can not enable mmap file for in-memory store");
            }
        }

        public Maker mmapFileEnablePartial() {
            return this;
        }

        public Maker mmapFileEnableIfSupported() {
            return this.fileMmapEnableIfSupported();
        }

        public Maker fileMmapEnableIfSupported() {
            this.assertNotInMemoryVolume();
            this.props.setProperty("volume", "mmapfIfSupported");
            return this;
        }

        public Maker fileChannelEnable() {
            this.assertNotInMemoryVolume();
            this.props.setProperty("volume", "fileChannel");
            return this;
        }

        public Maker snapshotEnable() {
            this.props.setProperty("snapshots", DBMaker.TRUE);
            return this;
        }

        public Maker asyncWriteEnable() {
            this.props.setProperty("asyncWrite", DBMaker.TRUE);
            return this;
        }

        public Maker asyncWriteFlushDelay(int delay) {
            this.props.setProperty("asyncWriteFlushDelay", "" + delay);
            return this;
        }

        public Maker asyncWriteQueueSize(int queueSize) {
            this.props.setProperty("asyncWriteQueueSize", "" + queueSize);
            return this;
        }

        public Maker deleteFilesAfterClose() {
            this.props.setProperty("deleteFilesAfterClose", DBMaker.TRUE);
            return this;
        }

        public Maker closeOnJvmShutdown() {
            this.props.setProperty("closeOnJvmShutdown", DBMaker.TRUE);
            return this;
        }

        public Maker compressionEnable() {
            this.props.setProperty("compression", "lzf");
            return this;
        }

        public Maker encryptionEnable(String password) {
            return this.encryptionEnable(password.getBytes(Charset.forName("UTF8")));
        }

        public Maker encryptionEnable(byte[] password) {
            this.props.setProperty("encryption", "xtea");
            this.props.setProperty("encryptionKey", DataIO.toHexa(password));
            return this;
        }

        public Maker checksumEnable() {
            this.props.setProperty("checksum", DBMaker.TRUE);
            return this;
        }

        public Maker strictDBGet() {
            this.props.setProperty("strictDBGet", DBMaker.TRUE);
            return this;
        }

        public Maker readOnly() {
            this.props.setProperty("readOnly", DBMaker.TRUE);
            return this;
        }

        public Maker sizeLimit(double maxSize) {
            return this;
        }

        public Maker freeSpaceReclaimQ(int q) {
            if (q < 0 || q > 10) {
                throw new IllegalArgumentException("wrong Q");
            }
            this.props.setProperty("freeSpaceReclaimQ", "" + q);
            return this;
        }

        public Maker commitFileSyncDisable() {
            this.props.setProperty("commitFileSyncDisable", DBMaker.TRUE);
            return this;
        }

        public Maker allocateStartSize(long size) {
            this.props.setProperty("allocateStartSize", "" + size);
            return this;
        }

        public Maker allocateIncrement(long sizeIncrement) {
            this.props.setProperty("allocateIncrement", "" + sizeIncrement);
            return this;
        }

        public Maker serializerClassLoader(ClassLoader classLoader) {
            this.serializerClassLoader = classLoader;
            return this;
        }

        public Maker serializerRegisterClass(String className, ClassLoader classLoader) {
            if (this.serializerClassLoaderRegistry == null) {
                this.serializerClassLoaderRegistry = new HashMap<String, ClassLoader>();
            }
            this.serializerClassLoaderRegistry.put(className, classLoader);
            return this;
        }

        public Maker serializerRegisterClass(Class ... classes) {
            if (this.serializerClassLoaderRegistry == null) {
                this.serializerClassLoaderRegistry = new HashMap<String, ClassLoader>();
            }
            for (Class clazz : classes) {
                this.serializerClassLoaderRegistry.put(clazz.getName(), clazz.getClassLoader());
            }
            return this;
        }

        public Maker allocateRecidReuseDisable() {
            this.props.setProperty("allocateRecidReuseDisable", DBMaker.TRUE);
            return this;
        }

        public Maker allocateRecidReuseEnable() {
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public DB make() {
            boolean strictGet = this.propsGetBool("strictDBGet");
            boolean deleteFilesAfterClose = this.propsGetBool("deleteFilesAfterClose");
            Engine engine = this.makeEngine();
            boolean dbCreated = false;
            boolean metricsLog = this.propsGetBool("metrics");
            long metricsLogInterval = this.propsGetLong("metricsLogInterval", metricsLog ? 10000L : 0L);
            ScheduledExecutorService metricsExec2 = metricsLog ? (this.metricsExecutor == null ? this.executor : this.metricsExecutor) : null;
            try {
                DB db = new DB(engine, strictGet, deleteFilesAfterClose, this.executor, false, metricsExec2, metricsLogInterval, this.storeExecutor, this.cacheExecutor, this.makeClassLoader());
                dbCreated = true;
                DB dB = db;
                return dB;
            }
            finally {
                if (!dbCreated) {
                    engine.close();
                }
            }
        }

        protected Fun.Function1<Class, String> makeClassLoader() {
            if (this.serializerClassLoader == null && (this.serializerClassLoaderRegistry == null || this.serializerClassLoaderRegistry.isEmpty())) {
                return null;
            }
            final ClassLoader serializerClassLoader2 = this.serializerClassLoader;
            final HashMap<String, ClassLoader> serializerClassLoaderRegistry2 = new HashMap<String, ClassLoader>();
            if (this.serializerClassLoaderRegistry != null) {
                serializerClassLoaderRegistry2.putAll(this.serializerClassLoaderRegistry);
            }
            return new Fun.Function1<Class, String>(){

                @Override
                public Class run(String className) {
                    ClassLoader loader = (ClassLoader)serializerClassLoaderRegistry2.get(className);
                    if (loader == null) {
                        loader = serializerClassLoader2;
                    }
                    if (loader == null) {
                        loader = Thread.currentThread().getContextClassLoader();
                    }
                    return SerializerPojo.classForName(className, loader);
                }
            };
        }

        public TxMaker makeTxMaker() {
            this.props.setProperty("fullTx", DBMaker.TRUE);
            if (this.props.containsKey("cache")) {
                this.props.remove("cache");
                LOG.warning("Cache setting was disabled. Instance Cache can not be used together with TxMaker");
            }
            this.snapshotEnable();
            Engine e = this.makeEngine();
            DB db = new DB(e);
            db.commit();
            return new TxMaker(e, this.propsGetBool("strictDBGet"), this.executor, this.makeClassLoader());
        }

        public Engine makeEngine() {
            Volume.VolumeFactory volFac;
            Engine engine;
            if (this.storeExecutor == null) {
                this.storeExecutor = this.executor;
            }
            boolean readOnly = this.propsGetBool("readOnly");
            boolean fileLockDisable = this.propsGetBool("fileLockDisable") || this.propsGetBool("fileLockHeartbeatEnable");
            String file = this.props.containsKey("file") ? this.props.getProperty("file") : "";
            String volume = this.props.getProperty("volume");
            String store = this.props.getProperty("store");
            if (readOnly && file.isEmpty()) {
                throw new UnsupportedOperationException("Can not open in-memory DB in read-only mode.");
            }
            if (readOnly && !new File(file).exists() && !"append".equals(store)) {
                throw new UnsupportedOperationException("Can not open non-existing file in read-only mode.");
            }
            DataIO.HeartbeatFileLock heartbeatFileLock = null;
            if (this.propsGetBool("fileLockHeartbeatEnable") && file != null && file.length() > 0 && !readOnly) {
                File lockFile = new File(file + ".lock");
                heartbeatFileLock = new DataIO.HeartbeatFileLock(lockFile, 1000);
                heartbeatFileLock.lock();
            }
            int lockingStrategy = 0;
            String lockingStrategyStr = this.props.getProperty("lock", "readWrite");
            if ("single".equals(lockingStrategyStr)) {
                lockingStrategy = 1;
            } else if ("threadUnsafe".equals(lockingStrategyStr)) {
                lockingStrategy = 2;
            }
            int lockScale = DataIO.nextPowTwo(this.propsGetInt("lockScale", 16));
            long allocateStartSize = this.propsGetLong("allocateStartSize", 0L);
            long allocateIncrement = this.propsGetLong("allocateIncrement", 0L);
            boolean allocateRecidReuseDisable = this.propsGetBool("allocateRecidReuseDisable");
            boolean cacheLockDisable = lockingStrategy != 0;
            byte[] encKey = this.propsGetXteaEncKey();
            boolean snapshotEnabled = this.propsGetBool("snapshots");
            if ("heap".equals(store)) {
                engine = new StoreHeap(this.propsGetBool("transactionDisable"), lockScale, lockingStrategy, snapshotEnabled);
            } else if ("archive".equals(store)) {
                volFac = this.extendStoreVolumeFactory(false);
                engine = new StoreArchive(file, volFac, true);
            } else if ("append".equals(store)) {
                if ("byteBuffer".equals(volume) || "directByteBuffer".equals(volume)) {
                    throw new UnsupportedOperationException("Append Storage format is not supported with in-memory dbs");
                }
                volFac = this.extendStoreVolumeFactory(false);
                engine = new StoreAppend(file, volFac, this.createCache(cacheLockDisable, lockScale), lockScale, lockingStrategy, this.propsGetBool("checksum"), "lzf".equals(this.props.getProperty("compression")), encKey, this.propsGetBool("readOnly"), snapshotEnabled, fileLockDisable, heartbeatFileLock, this.propsGetBool("transactionDisable"), this.storeExecutor, allocateStartSize, allocateIncrement);
            } else {
                volFac = this.extendStoreVolumeFactory(false);
                boolean compressionEnabled = "lzf".equals(this.props.getProperty("compression"));
                boolean asyncWrite = this.propsGetBool("asyncWrite") && !readOnly;
                boolean txDisable = this.propsGetBool("transactionDisable");
                engine = !txDisable ? new StoreWAL(file, volFac, this.createCache(cacheLockDisable, lockScale), lockScale, lockingStrategy, this.propsGetBool("checksum"), compressionEnabled, encKey, this.propsGetBool("readOnly"), snapshotEnabled, fileLockDisable, heartbeatFileLock, this.storeExecutor, allocateStartSize, allocateIncrement, allocateRecidReuseDisable, 1000L, this.propsGetInt("asyncWriteQueueSize", 1024)) : (asyncWrite ? new StoreCached(file, volFac, this.createCache(cacheLockDisable, lockScale), lockScale, lockingStrategy, this.propsGetBool("checksum"), compressionEnabled, encKey, this.propsGetBool("readOnly"), snapshotEnabled, fileLockDisable, heartbeatFileLock, this.storeExecutor, allocateStartSize, allocateIncrement, allocateRecidReuseDisable, 1000L, this.propsGetInt("asyncWriteQueueSize", 1024)) : new StoreDirect(file, volFac, this.createCache(cacheLockDisable, lockScale), lockScale, lockingStrategy, this.propsGetBool("checksum"), compressionEnabled, encKey, this.propsGetBool("readOnly"), snapshotEnabled, fileLockDisable, heartbeatFileLock, this.storeExecutor, allocateStartSize, allocateIncrement, allocateRecidReuseDisable));
            }
            if (engine instanceof Store) {
                ((Store)engine).init();
            }
            if (this.propsGetBool("fullTx")) {
                engine = this.extendSnapshotEngine(engine, lockScale);
            }
            engine = this.extendWrapSnapshotEngine(engine);
            if (readOnly) {
                engine = new Engine.ReadOnlyWrapper(engine);
            }
            if (this.propsGetBool("closeOnJvmShutdown")) {
                engine = new Engine.CloseOnJVMShutdown(engine);
            }
            Fun.Pair<Integer, byte[]> check = null;
            try {
                check = (Fun.Pair<Integer, byte[]>)engine.get(3L, Serializer.BASIC);
                if (check != null && (Integer)check.a != Arrays.hashCode((byte[])check.b)) {
                    throw new RuntimeException("invalid checksum");
                }
            }
            catch (Throwable e) {
                throw new DBException.WrongConfig("Error while opening store. Make sure you have right password, compression or encryption is well configured.", e);
            }
            if (check == null && !engine.isReadOnly()) {
                byte[] b = new byte[127];
                if (encKey != null) {
                    new SecureRandom().nextBytes(b);
                } else {
                    new Random().nextBytes(b);
                }
                check = new Fun.Pair<Integer, byte[]>(Arrays.hashCode(b), b);
                engine.update(3L, check, Serializer.BASIC);
                engine.commit();
            }
            return engine;
        }

        protected Store.Cache createCache(boolean disableLocks, int lockScale) {
            String cache = this.props.getProperty("cache", "disable");
            if (this.cacheExecutor == null) {
                this.cacheExecutor = this.executor;
            }
            long executorPeriod = this.propsGetLong("cacheExecutorPeriod", 1000L);
            if ("disable".equals(cache)) {
                return null;
            }
            if ("hashTable".equals(cache)) {
                int cacheSize = this.propsGetInt("cacheSize", 2048) / lockScale;
                return new Store.Cache.HashTable(cacheSize, disableLocks);
            }
            if ("hardRef".equals(cache)) {
                int cacheSize = this.propsGetInt("cacheSize", 2048) / lockScale;
                return new Store.Cache.HardRef(cacheSize, disableLocks, this.cacheExecutor, executorPeriod);
            }
            if ("weakRef".equals(cache)) {
                return new Store.Cache.WeakSoftRef(true, disableLocks, this.cacheExecutor, executorPeriod);
            }
            if ("softRef".equals(cache)) {
                return new Store.Cache.WeakSoftRef(false, disableLocks, this.cacheExecutor, executorPeriod);
            }
            if ("lru".equals(cache)) {
                int cacheSize = this.propsGetInt("cacheSize", 2048) / lockScale;
                return new Store.Cache.LRU(cacheSize, disableLocks);
            }
            throw new IllegalArgumentException("unknown cache type: " + cache);
        }

        protected int propsGetInt(String key, int defValue) {
            String ret = this.props.getProperty(key);
            if (ret == null) {
                return defValue;
            }
            return Integer.valueOf(ret);
        }

        protected long propsGetLong(String key, long defValue) {
            String ret = this.props.getProperty(key);
            if (ret == null) {
                return defValue;
            }
            return Long.valueOf(ret);
        }

        protected boolean propsGetBool(String key) {
            String ret = this.props.getProperty(key);
            return ret != null && ret.equals(DBMaker.TRUE);
        }

        protected byte[] propsGetXteaEncKey() {
            if (!"xtea".equals(this.props.getProperty("encryption"))) {
                return null;
            }
            return DataIO.fromHexa(this.props.getProperty("encryptionKey"));
        }

        protected static boolean JVMSupportsLargeMappedFiles() {
            String prop = System.getProperty("os.arch");
            if (prop != null && prop.contains("64")) {
                String os = System.getProperty("os.name");
                if (os == null) {
                    return false;
                }
                return !(os = os.toLowerCase()).startsWith("windows");
            }
            return false;
        }

        protected int propsGetRafMode() {
            String volume = this.props.getProperty("volume");
            if (volume == null || "raf".equals(volume)) {
                return 2;
            }
            if ("mmapfIfSupported".equals(volume)) {
                return Maker.JVMSupportsLargeMappedFiles() ? 0 : 2;
            }
            if ("fileChannel".equals(volume)) {
                return 3;
            }
            if ("mmapf".equals(volume)) {
                return 0;
            }
            return 2;
        }

        protected Engine extendSnapshotEngine(Engine engine, int lockScale) {
            return new TxEngine(engine, this.propsGetBool("fullTx"), lockScale);
        }

        protected Engine extendWrapSnapshotEngine(Engine engine) {
            return engine;
        }

        protected Volume.VolumeFactory extendStoreVolumeFactory(boolean index) {
            boolean raf;
            String volume = this.props.getProperty("volume");
            boolean cleanerHackEnabled = this.propsGetBool("fileMmapCleanerHack");
            if ("byteBuffer".equals(volume)) {
                return Volume.ByteArrayVol.FACTORY;
            }
            if ("directByteBuffer".equals(volume)) {
                return cleanerHackEnabled ? Volume.MemoryVol.FACTORY_WITH_CLEANER_HACK : Volume.MemoryVol.FACTORY;
            }
            if ("unsafe".equals(volume)) {
                return Volume.UNSAFE_VOL_FACTORY;
            }
            int rafMode = this.propsGetRafMode();
            if (rafMode == 3) {
                return Volume.FileChannelVol.FACTORY;
            }
            boolean bl = raf = rafMode != 0;
            if (raf && index && rafMode == 1) {
                raf = false;
            }
            return raf ? Volume.RandomAccessFileVol.FACTORY : (cleanerHackEnabled ? Volume.MappedFileVol.FACTORY_WITH_CLEANER_HACK : Volume.MappedFileVol.FACTORY);
        }
    }

    protected static interface Keys {
        public static final String cache = "cache";
        public static final String cacheSize = "cacheSize";
        public static final String cache_disable = "disable";
        public static final String cache_hashTable = "hashTable";
        public static final String cache_hardRef = "hardRef";
        public static final String cache_softRef = "softRef";
        public static final String cache_weakRef = "weakRef";
        public static final String cache_lru = "lru";
        public static final String cacheExecutorPeriod = "cacheExecutorPeriod";
        public static final String file = "file";
        public static final String metrics = "metrics";
        public static final String metricsLogInterval = "metricsLogInterval";
        public static final String volume = "volume";
        public static final String volume_fileChannel = "fileChannel";
        public static final String volume_raf = "raf";
        public static final String volume_mmapfIfSupported = "mmapfIfSupported";
        public static final String volume_mmapf = "mmapf";
        public static final String volume_byteBuffer = "byteBuffer";
        public static final String volume_directByteBuffer = "directByteBuffer";
        public static final String volume_unsafe = "unsafe";
        public static final String fileMmapCleanerHack = "fileMmapCleanerHack";
        public static final String fileLockDisable = "fileLockDisable";
        public static final String fileLockHeartbeatEnable = "fileLockHeartbeatEnable";
        public static final String lockScale = "lockScale";
        public static final String lock = "lock";
        public static final String lock_readWrite = "readWrite";
        public static final String lock_single = "single";
        public static final String lock_threadUnsafe = "threadUnsafe";
        public static final String store = "store";
        public static final String store_direct = "direct";
        public static final String store_wal = "wal";
        public static final String store_append = "append";
        public static final String store_heap = "heap";
        public static final String store_archive = "archive";
        public static final String storeExecutorPeriod = "storeExecutorPeriod";
        public static final String transactionDisable = "transactionDisable";
        public static final String asyncWrite = "asyncWrite";
        public static final String asyncWriteFlushDelay = "asyncWriteFlushDelay";
        public static final String asyncWriteQueueSize = "asyncWriteQueueSize";
        public static final String deleteFilesAfterClose = "deleteFilesAfterClose";
        public static final String closeOnJvmShutdown = "closeOnJvmShutdown";
        public static final String readOnly = "readOnly";
        public static final String compression = "compression";
        public static final String compression_lzf = "lzf";
        public static final String encryptionKey = "encryptionKey";
        public static final String encryption = "encryption";
        public static final String encryption_xtea = "xtea";
        public static final String checksum = "checksum";
        public static final String freeSpaceReclaimQ = "freeSpaceReclaimQ";
        public static final String commitFileSyncDisable = "commitFileSyncDisable";
        public static final String snapshots = "snapshots";
        public static final String strictDBGet = "strictDBGet";
        public static final String fullTx = "fullTx";
        public static final String allocateStartSize = "allocateStartSize";
        public static final String allocateIncrement = "allocateIncrement";
        public static final String allocateRecidReuseDisable = "allocateRecidReuseDisable";
    }
}

