/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb;

import java.io.Closeable;
import java.io.DataInput;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.Arrays;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mapdb.DBException;
import org.mapdb.DataIO;
import org.mapdb.Fun;
import org.mapdb.SerializerPojo;

public abstract class Volume
implements Closeable {
    private static final byte[] CLEAR = new byte[1024];
    protected static final Logger LOG = Logger.getLogger(Volume.class.getName());
    public static final VolumeFactory UNSAFE_VOL_FACTORY = new VolumeFactory(){

        @Override
        public Volume makeVolume(String file, boolean readOnly, boolean fileLockDisabled, int sliceShift, long initSize, boolean fixedSize) {
            Class<?> clazz;
            String packageName = Volume.class.getPackage().getName();
            try {
                clazz = Class.forName(packageName + ".UnsafeStuff$UnsafeVolume");
            }
            catch (ClassNotFoundException e) {
                clazz = null;
            }
            if (clazz != null) {
                try {
                    return (Volume)clazz.getConstructor(Long.TYPE, Integer.TYPE, Long.TYPE).newInstance(0L, sliceShift, initSize);
                }
                catch (Exception e) {
                    LOG.log(Level.WARNING, "Could not invoke UnsafeVolume constructor. Falling back to DirectByteBuffer", e);
                }
            }
            return MemoryVol.FACTORY.makeVolume(file, readOnly, fileLockDisabled, sliceShift, initSize, fixedSize);
        }
    };
    protected volatile boolean closed;

    static int sliceShiftFromSize(long sizeIncrement) {
        sizeIncrement = DataIO.nextPowTwo(sizeIncrement);
        for (int i = 0; i < 32; ++i) {
            if (1L << i != sizeIncrement) continue;
            return i;
        }
        throw new AssertionError((Object)"Could not find sliceShift");
    }

    static boolean isEmptyFile(String fileName) {
        if (fileName == null || fileName.length() == 0) {
            return true;
        }
        File f = new File(fileName);
        return !f.exists() || f.length() == 0L;
    }

    public boolean fileLoad() {
        return false;
    }

    public void assertZeroes(long startOffset, long endOffset) throws DBException.DataCorruption {
        for (long offset = startOffset; offset < endOffset; ++offset) {
            if (this.getUnsignedByte(offset) == 0) continue;
            throw new DBException.DataCorruption("Not zero at offset: " + offset);
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    protected void finalize() {
    }

    public abstract void ensureAvailable(long var1);

    public abstract void truncate(long var1);

    public abstract void putLong(long var1, long var3);

    public abstract void putInt(long var1, int var3);

    public abstract void putByte(long var1, byte var3);

    public abstract void putData(long var1, byte[] var3, int var4, int var5);

    public abstract void putData(long var1, ByteBuffer var3);

    public void putDataOverlap(long offset, byte[] src, int srcPos, int srcSize) {
        this.putData(offset, src, srcPos, srcSize);
    }

    public abstract long getLong(long var1);

    public abstract int getInt(long var1);

    public abstract byte getByte(long var1);

    public abstract DataInput getDataInput(long var1, int var3);

    public DataInput getDataInputOverlap(long offset, int size) {
        return this.getDataInput(offset, size);
    }

    public abstract void getData(long var1, byte[] var3, int var4, int var5);

    @Override
    public abstract void close();

    public abstract void sync();

    public abstract int sliceSize();

    public void deleteFile() {
        File f = this.getFile();
        if (f != null && f.isFile() && !f.delete()) {
            LOG.warning("Could not delete file: " + f);
        }
    }

    public abstract boolean isSliced();

    public abstract long length();

    public void putUnsignedShort(long offset, int value) {
        this.putByte(offset, (byte)(value >> 8));
        this.putByte(offset + 1L, (byte)value);
    }

    public int getUnsignedShort(long offset) {
        return (this.getByte(offset) & 0xFF) << 8 | this.getByte(offset + 1L) & 0xFF;
    }

    public int getUnsignedByte(long offset) {
        return this.getByte(offset) & 0xFF;
    }

    public void putUnsignedByte(long offset, int b) {
        this.putByte(offset, (byte)(b & 0xFF));
    }

    public int putLongPackBidi(long offset, long value) {
        long origOffset = offset;
        int shift = 63 - Long.numberOfLeadingZeros(value);
        shift -= shift % 7;
        while (shift != 0) {
            this.putByte(offset++, (byte)(value >>> shift & 0x7FL));
            shift -= 7;
        }
        this.putByte(offset++, (byte)(value & 0x7FL | 0x80L));
        return (int)(offset - origOffset);
    }

    public long getLongPackBidi(long offset) {
        byte v;
        long ret = 0L;
        int pos2 = 0;
        do {
            v = this.getByte(offset + (long)pos2++);
            ret = ret << 7 | (long)(v & 0x7F);
        } while (v >= 0);
        return (long)pos2 << 60 | ret;
    }

    public long getLongPackBidiReverse(long offset, long limitOffset) {
        long offset2;
        for (offset2 = offset - 2L; offset2 >= limitOffset && (this.getByte(offset2) & 0x80) == 0; --offset2) {
        }
        return this.getLongPackBidi(++offset2);
    }

    public long getSixLong(long pos) {
        return (long)(this.getByte(pos++) & 0xFF) << 40 | (long)(this.getByte(pos++) & 0xFF) << 32 | (long)(this.getByte(pos++) & 0xFF) << 24 | (long)(this.getByte(pos++) & 0xFF) << 16 | (long)(this.getByte(pos++) & 0xFF) << 8 | (long)(this.getByte(pos) & 0xFF);
    }

    public void putSixLong(long pos, long value) {
        this.putByte(pos++, (byte)(0xFFL & value >> 40));
        this.putByte(pos++, (byte)(0xFFL & value >> 32));
        this.putByte(pos++, (byte)(0xFFL & value >> 24));
        this.putByte(pos++, (byte)(0xFFL & value >> 16));
        this.putByte(pos++, (byte)(0xFFL & value >> 8));
        this.putByte(pos, (byte)(0xFFL & value));
    }

    public int putPackedLong(long pos, long value) {
        int ret = 0;
        int shift = 63 - Long.numberOfLeadingZeros(value);
        shift -= shift % 7;
        while (shift != 0) {
            this.putByte(pos + (long)ret++, (byte)(value >>> shift & 0x7FL | 0x80L));
            shift -= 7;
        }
        this.putByte(pos + (long)ret++, (byte)(value & 0x7FL));
        return ret;
    }

    public long getPackedLong(long position) {
        byte v;
        long ret = 0L;
        long pos2 = 0L;
        do {
            v = this.getByte(position + pos2++);
            ret = ret << 7 | (long)(v & 0x7F);
        } while (v < 0);
        return pos2 << 60 | ret;
    }

    public abstract File getFile();

    public abstract boolean getFileLocked();

    public void transferInto(long inputOffset, Volume target, long targetOffset, long size) {
        byte[] data = new byte[(int)size];
        try {
            this.getDataInput(inputOffset, (int)size).readFully(data);
        }
        catch (IOException e) {
            throw new DBException.VolumeIOError(e);
        }
        target.putData(targetOffset, data, 0, (int)size);
    }

    public abstract void clear(long var1, long var3);

    public void copyEntireVolumeTo(Volume to) {
        long volSize = this.length();
        long bufSize = 0x100000L;
        to.ensureAvailable(volSize);
        for (long offset = 0L; offset < volSize; offset += 0x100000L) {
            long size = Math.min(volSize, offset + 0x100000L) - offset;
            this.transferInto(offset, to, offset, size);
        }
    }

    public long hash(long off, long len, long seed) {
        long h64;
        if (len < 0L) {
            throw new IllegalArgumentException("lengths must be >= 0");
        }
        if (len == 0L) {
            return seed;
        }
        long bufLen = this.length();
        if (off < 0L || off >= bufLen || off + len < 0L || off + len > bufLen) {
            throw new IndexOutOfBoundsException();
        }
        while ((off & 7L) != 0L && len > 0L) {
            seed = seed << 8 | (long)this.getUnsignedByte(off);
            ++off;
            --len;
        }
        long end = off + len;
        if (len >= 32L) {
            long limit = end - 32L;
            long v1 = seed + -7046029288634856825L + -4417276706812531889L;
            long v2 = seed + -4417276706812531889L;
            long v3 = seed + 0L;
            long v4 = seed - -7046029288634856825L;
            do {
                v1 += Long.reverseBytes(this.getLong(off)) * -4417276706812531889L;
                v1 = Long.rotateLeft(v1, 31);
                v1 *= -7046029288634856825L;
                v2 += Long.reverseBytes(this.getLong(off += 8L)) * -4417276706812531889L;
                v2 = Long.rotateLeft(v2, 31);
                v2 *= -7046029288634856825L;
                v3 += Long.reverseBytes(this.getLong(off += 8L)) * -4417276706812531889L;
                v3 = Long.rotateLeft(v3, 31);
                v3 *= -7046029288634856825L;
                v4 += Long.reverseBytes(this.getLong(off += 8L)) * -4417276706812531889L;
                v4 = Long.rotateLeft(v4, 31);
                v4 *= -7046029288634856825L;
            } while ((off += 8L) <= limit);
            h64 = Long.rotateLeft(v1, 1) + Long.rotateLeft(v2, 7) + Long.rotateLeft(v3, 12) + Long.rotateLeft(v4, 18);
            v1 *= -4417276706812531889L;
            v1 = Long.rotateLeft(v1, 31);
            h64 ^= (v1 *= -7046029288634856825L);
            h64 = h64 * -7046029288634856825L + -8796714831421723037L;
            v2 *= -4417276706812531889L;
            v2 = Long.rotateLeft(v2, 31);
            h64 ^= (v2 *= -7046029288634856825L);
            h64 = h64 * -7046029288634856825L + -8796714831421723037L;
            v3 *= -4417276706812531889L;
            v3 = Long.rotateLeft(v3, 31);
            h64 ^= (v3 *= -7046029288634856825L);
            h64 = h64 * -7046029288634856825L + -8796714831421723037L;
            v4 *= -4417276706812531889L;
            v4 = Long.rotateLeft(v4, 31);
            h64 ^= (v4 *= -7046029288634856825L);
            h64 = h64 * -7046029288634856825L + -8796714831421723037L;
        } else {
            h64 = seed + 2870177450012600261L;
        }
        h64 += len;
        while (off <= end - 8L) {
            long k1 = Long.reverseBytes(this.getLong(off));
            k1 *= -4417276706812531889L;
            k1 = Long.rotateLeft(k1, 31);
            h64 ^= (k1 *= -7046029288634856825L);
            h64 = Long.rotateLeft(h64, 27) * -7046029288634856825L + -8796714831421723037L;
            off += 8L;
        }
        if (off <= end - 4L) {
            h64 ^= ((long)Integer.reverseBytes(this.getInt(off)) & 0xFFFFFFFFL) * -7046029288634856825L;
            h64 = Long.rotateLeft(h64, 23) * -4417276706812531889L + 1609587929392839161L;
            off += 4L;
        }
        while (off < end) {
            h64 ^= (long)(this.getByte(off) & 0xFF) * 2870177450012600261L;
            h64 = Long.rotateLeft(h64, 11) * -7046029288634856825L;
            ++off;
        }
        h64 ^= h64 >>> 33;
        h64 *= -4417276706812531889L;
        h64 ^= h64 >>> 29;
        h64 *= 1609587929392839161L;
        h64 ^= h64 >>> 32;
        return h64;
    }

    public static void volumeTransfer(long size, Volume from, Volume to) {
        int bufSize = Math.min(from.sliceSize(), to.sliceSize());
        if (bufSize < 0 || bufSize > 0x8000000) {
            bufSize = 65536;
        }
        to.ensureAvailable(size);
        for (long offset = 0L; offset < size; offset += (long)bufSize) {
            int bb = (int)Math.min((long)bufSize, size - offset);
            from.transferInto(offset, to, offset, bb);
        }
    }

    private static FileLock lockFile(File file, RandomAccessFile raf, boolean readOnly, boolean fileLockDisable) {
        if (fileLockDisable || readOnly) {
            return null;
        }
        try {
            return raf.getChannel().lock();
        }
        catch (Exception e) {
            throw new DBException.FileLocked("Can not lock file, perhaps other DB is already using it. File: " + file, e);
        }
    }

    public static final class RandomAccessFileVol
    extends Volume {
        public static final VolumeFactory FACTORY = new VolumeFactory(){

            @Override
            public Volume makeVolume(String file, boolean readOnly, boolean fileLockDisable, int sliceShift, long initSize, boolean fixedSize) {
                return new RandomAccessFileVol(new File(file), readOnly, fileLockDisable, initSize);
            }
        };
        protected final File file;
        protected final RandomAccessFile raf;
        protected final FileLock fileLock;

        public RandomAccessFileVol(File file, boolean readOnly, boolean fileLockDisable, long initSize) {
            this.file = file;
            try {
                this.raf = new RandomAccessFile(file, readOnly ? "r" : "rw");
                this.fileLock = Volume.lockFile(file, this.raf, readOnly, fileLockDisable);
                if (initSize != 0L && !readOnly) {
                    long oldLen = this.raf.length();
                    if (initSize > this.raf.length()) {
                        this.raf.setLength(initSize);
                        this.clear(oldLen, initSize);
                    }
                }
            }
            catch (IOException e) {
                throw new DBException.VolumeIOError(e);
            }
        }

        @Override
        public synchronized void ensureAvailable(long offset) {
            try {
                if (this.raf.length() < offset) {
                    this.raf.setLength(offset);
                }
            }
            catch (IOException e) {
                throw new DBException.VolumeIOError(e);
            }
        }

        @Override
        public synchronized void truncate(long size) {
            try {
                this.raf.setLength(size);
            }
            catch (IOException e) {
                throw new DBException.VolumeIOError(e);
            }
        }

        @Override
        public synchronized void putLong(long offset, long value) {
            try {
                this.raf.seek(offset);
                this.raf.writeLong(value);
            }
            catch (IOException e) {
                throw new DBException.VolumeIOError(e);
            }
        }

        @Override
        public synchronized void putInt(long offset, int value) {
            try {
                this.raf.seek(offset);
                this.raf.writeInt(value);
            }
            catch (IOException e) {
                throw new DBException.VolumeIOError(e);
            }
        }

        @Override
        public synchronized void putByte(long offset, byte value) {
            try {
                this.raf.seek(offset);
                this.raf.writeByte(value);
            }
            catch (IOException e) {
                throw new DBException.VolumeIOError(e);
            }
        }

        @Override
        public synchronized void putData(long offset, byte[] src, int srcPos, int srcSize) {
            try {
                this.raf.seek(offset);
                this.raf.write(src, srcPos, srcSize);
            }
            catch (IOException e) {
                throw new DBException.VolumeIOError(e);
            }
        }

        @Override
        public synchronized void putData(long offset, ByteBuffer buf) {
            byte[] bb = buf.array();
            int pos = buf.position();
            int size = buf.limit() - pos;
            if (bb == null) {
                bb = new byte[size];
                buf.get(bb);
                pos = 0;
            }
            this.putData(offset, bb, pos, size);
        }

        @Override
        public synchronized long getLong(long offset) {
            try {
                this.raf.seek(offset);
                return this.raf.readLong();
            }
            catch (IOException e) {
                throw new DBException.VolumeIOError(e);
            }
        }

        @Override
        public synchronized int getInt(long offset) {
            try {
                this.raf.seek(offset);
                return this.raf.readInt();
            }
            catch (IOException e) {
                throw new DBException.VolumeIOError(e);
            }
        }

        @Override
        public synchronized byte getByte(long offset) {
            try {
                this.raf.seek(offset);
                return this.raf.readByte();
            }
            catch (IOException e) {
                throw new DBException.VolumeIOError(e);
            }
        }

        @Override
        public synchronized DataInput getDataInput(long offset, int size) {
            try {
                this.raf.seek(offset);
                byte[] b = new byte[size];
                this.raf.readFully(b);
                return new DataIO.DataInputByteArray(b);
            }
            catch (IOException e) {
                throw new DBException.VolumeIOError(e);
            }
        }

        @Override
        public synchronized void getData(long offset, byte[] bytes, int bytesPos, int size) {
            try {
                this.raf.seek(offset);
                this.raf.readFully(bytes, bytesPos, size);
            }
            catch (IOException e) {
                throw new DBException.VolumeIOError(e);
            }
        }

        @Override
        public synchronized void close() {
            if (this.closed) {
                return;
            }
            this.closed = true;
            try {
                if (this.fileLock != null && this.fileLock.isValid()) {
                    this.fileLock.release();
                }
                this.raf.close();
            }
            catch (IOException e) {
                throw new DBException.VolumeIOError(e);
            }
        }

        @Override
        public synchronized void sync() {
            try {
                this.raf.getFD().sync();
            }
            catch (IOException e) {
                throw new DBException.VolumeIOError(e);
            }
        }

        @Override
        public int sliceSize() {
            return 0;
        }

        @Override
        public boolean isSliced() {
            return false;
        }

        @Override
        public synchronized long length() {
            try {
                return this.raf.length();
            }
            catch (IOException e) {
                throw new DBException.VolumeIOError(e);
            }
        }

        @Override
        public File getFile() {
            return this.file;
        }

        @Override
        public synchronized boolean getFileLocked() {
            return this.fileLock != null && this.fileLock.isValid();
        }

        @Override
        public synchronized void clear(long startOffset, long endOffset) {
            try {
                RandomAccessFileVol.clearRAF(this.raf, startOffset, endOffset);
            }
            catch (IOException e) {
                throw new DBException.VolumeIOError(e);
            }
        }

        protected static void clearRAF(RandomAccessFile raf, long startOffset, long endOffset) throws IOException {
            raf.seek(startOffset);
            while (startOffset < endOffset) {
                long remaining = Math.min((long)CLEAR.length, endOffset - startOffset);
                raf.write(CLEAR, 0, (int)remaining);
                startOffset += (long)CLEAR.length;
            }
        }

        @Override
        public synchronized void putUnsignedShort(long offset, int value) {
            try {
                this.raf.seek(offset);
                this.raf.write(value >> 8);
                this.raf.write(value);
            }
            catch (IOException e) {
                throw new DBException.VolumeIOError(e);
            }
        }

        @Override
        public synchronized int getUnsignedShort(long offset) {
            try {
                this.raf.seek(offset);
                return this.raf.readUnsignedByte() << 8 | this.raf.readUnsignedByte();
            }
            catch (IOException e) {
                throw new DBException.VolumeIOError(e);
            }
        }

        @Override
        public synchronized long getSixLong(long offset) {
            try {
                this.raf.seek(offset);
                return (long)this.raf.readUnsignedByte() << 40 | (long)this.raf.readUnsignedByte() << 32 | (long)this.raf.readUnsignedByte() << 24 | (long)(this.raf.readUnsignedByte() << 16) | (long)(this.raf.readUnsignedByte() << 8) | (long)this.raf.readUnsignedByte();
            }
            catch (IOException e) {
                throw new DBException.VolumeIOError(e);
            }
        }

        @Override
        public synchronized void putSixLong(long pos, long value) {
            try {
                this.raf.seek(pos);
                this.raf.write((int)(value >>> 40));
                this.raf.write((int)(value >>> 32));
                this.raf.write((int)(value >>> 24));
                this.raf.write((int)(value >>> 16));
                this.raf.write((int)(value >>> 8));
                this.raf.write((int)value);
            }
            catch (IOException e) {
                throw new DBException.VolumeIOError(e);
            }
        }

        @Override
        public int putPackedLong(long pos, long value) {
            try {
                this.raf.seek(pos);
                int ret = 1;
                int shift = 63 - Long.numberOfLeadingZeros(value);
                shift -= shift % 7;
                while (shift != 0) {
                    ++ret;
                    this.raf.write((int)(value >>> shift & 0x7FL | 0x80L));
                    shift -= 7;
                }
                this.raf.write((int)(value & 0x7FL));
                return ret;
            }
            catch (IOException e) {
                throw new DBException.VolumeIOError(e);
            }
        }

        @Override
        public long getPackedLong(long pos) {
            try {
                byte v;
                this.raf.seek(pos);
                long ret = 0L;
                long pos2 = 0L;
                do {
                    ++pos2;
                    v = this.raf.readByte();
                    ret = ret << 7 | (long)(v & 0x7F);
                } while (v < 0);
                return pos2 << 60 | ret;
            }
            catch (IOException e) {
                throw new DBException.VolumeIOError(e);
            }
        }

        @Override
        public synchronized long hash(long off, long len, long seed) {
            if (len < 0L) {
                throw new IllegalArgumentException("lengths must be >= 0");
            }
            if (len == 0L) {
                return seed;
            }
            long bufLen = this.length();
            if (off < 0L || off >= bufLen || off + len < 0L || off + len > bufLen) {
                throw new IndexOutOfBoundsException();
            }
            try {
                long h64;
                this.raf.seek(off);
                while ((off & 7L) != 0L && len > 0L) {
                    seed = seed << 8 | (long)this.raf.readUnsignedByte();
                    ++off;
                    --len;
                }
                long end = off + len;
                if (len >= 32L) {
                    long limit = end - 32L;
                    long v1 = seed + -7046029288634856825L + -4417276706812531889L;
                    long v2 = seed + -4417276706812531889L;
                    long v3 = seed + 0L;
                    long v4 = seed - -7046029288634856825L;
                    byte[] buf = new byte[32];
                    do {
                        this.raf.readFully(buf);
                        v1 += Long.reverseBytes(DataIO.getLong(buf, 0)) * -4417276706812531889L;
                        v1 = Long.rotateLeft(v1, 31);
                        v1 *= -7046029288634856825L;
                        off += 8L;
                        v2 += Long.reverseBytes(DataIO.getLong(buf, 8)) * -4417276706812531889L;
                        v2 = Long.rotateLeft(v2, 31);
                        v2 *= -7046029288634856825L;
                        off += 8L;
                        v3 += Long.reverseBytes(DataIO.getLong(buf, 16)) * -4417276706812531889L;
                        v3 = Long.rotateLeft(v3, 31);
                        v3 *= -7046029288634856825L;
                        off += 8L;
                        v4 += Long.reverseBytes(DataIO.getLong(buf, 24)) * -4417276706812531889L;
                        v4 = Long.rotateLeft(v4, 31);
                        v4 *= -7046029288634856825L;
                    } while ((off += 8L) <= limit);
                    h64 = Long.rotateLeft(v1, 1) + Long.rotateLeft(v2, 7) + Long.rotateLeft(v3, 12) + Long.rotateLeft(v4, 18);
                    v1 *= -4417276706812531889L;
                    v1 = Long.rotateLeft(v1, 31);
                    h64 ^= (v1 *= -7046029288634856825L);
                    h64 = h64 * -7046029288634856825L + -8796714831421723037L;
                    v2 *= -4417276706812531889L;
                    v2 = Long.rotateLeft(v2, 31);
                    h64 ^= (v2 *= -7046029288634856825L);
                    h64 = h64 * -7046029288634856825L + -8796714831421723037L;
                    v3 *= -4417276706812531889L;
                    v3 = Long.rotateLeft(v3, 31);
                    h64 ^= (v3 *= -7046029288634856825L);
                    h64 = h64 * -7046029288634856825L + -8796714831421723037L;
                    v4 *= -4417276706812531889L;
                    v4 = Long.rotateLeft(v4, 31);
                    h64 ^= (v4 *= -7046029288634856825L);
                    h64 = h64 * -7046029288634856825L + -8796714831421723037L;
                } else {
                    h64 = seed + 2870177450012600261L;
                }
                h64 += len;
                while (off <= end - 8L) {
                    long k1 = Long.reverseBytes(this.raf.readLong());
                    k1 *= -4417276706812531889L;
                    k1 = Long.rotateLeft(k1, 31);
                    h64 ^= (k1 *= -7046029288634856825L);
                    h64 = Long.rotateLeft(h64, 27) * -7046029288634856825L + -8796714831421723037L;
                    off += 8L;
                }
                if (off <= end - 4L) {
                    h64 ^= ((long)Integer.reverseBytes(this.raf.readInt()) & 0xFFFFFFFFL) * -7046029288634856825L;
                    h64 = Long.rotateLeft(h64, 23) * -4417276706812531889L + 1609587929392839161L;
                    off += 4L;
                }
                while (off < end) {
                    h64 ^= (long)(this.raf.readByte() & 0xFF) * 2870177450012600261L;
                    h64 = Long.rotateLeft(h64, 11) * -7046029288634856825L;
                    ++off;
                }
                h64 ^= h64 >>> 33;
                h64 *= -4417276706812531889L;
                h64 ^= h64 >>> 29;
                h64 *= 1609587929392839161L;
                h64 ^= h64 >>> 32;
                return h64;
            }
            catch (IOException e) {
                throw new DBException.VolumeIOError(e);
            }
        }
    }

    public static final class ReadOnly
    extends Volume {
        protected final Volume vol;

        public ReadOnly(Volume vol) {
            this.vol = vol;
        }

        @Override
        public void ensureAvailable(long offset) {
        }

        @Override
        public void truncate(long size) {
            throw new IllegalAccessError("read-only");
        }

        @Override
        public void putLong(long offset, long value) {
            throw new IllegalAccessError("read-only");
        }

        @Override
        public void putInt(long offset, int value) {
            throw new IllegalAccessError("read-only");
        }

        @Override
        public void putByte(long offset, byte value) {
            throw new IllegalAccessError("read-only");
        }

        @Override
        public void putData(long offset, byte[] src, int srcPos, int srcSize) {
            throw new IllegalAccessError("read-only");
        }

        @Override
        public void putData(long offset, ByteBuffer buf) {
            throw new IllegalAccessError("read-only");
        }

        @Override
        public void putDataOverlap(long offset, byte[] src, int srcPos, int srcSize) {
            throw new IllegalAccessError("read-only");
        }

        @Override
        public long getLong(long offset) {
            return this.vol.getLong(offset);
        }

        @Override
        public int getInt(long offset) {
            return this.vol.getInt(offset);
        }

        @Override
        public byte getByte(long offset) {
            return this.vol.getByte(offset);
        }

        @Override
        public DataInput getDataInput(long offset, int size) {
            return this.vol.getDataInput(offset, size);
        }

        @Override
        public DataInput getDataInputOverlap(long offset, int size) {
            return this.vol.getDataInputOverlap(offset, size);
        }

        @Override
        public void getData(long offset, byte[] bytes, int bytesPos, int size) {
            this.vol.getData(offset, bytes, bytesPos, size);
        }

        @Override
        public void close() {
            this.closed = true;
            this.vol.close();
        }

        @Override
        public void sync() {
            this.vol.sync();
        }

        @Override
        public int sliceSize() {
            return this.vol.sliceSize();
        }

        @Override
        public void deleteFile() {
            throw new IllegalAccessError("read-only");
        }

        @Override
        public boolean isSliced() {
            return this.vol.isSliced();
        }

        @Override
        public long length() {
            return this.vol.length();
        }

        @Override
        public void putUnsignedShort(long offset, int value) {
            throw new IllegalAccessError("read-only");
        }

        @Override
        public int getUnsignedShort(long offset) {
            return this.vol.getUnsignedShort(offset);
        }

        @Override
        public int getUnsignedByte(long offset) {
            return this.vol.getUnsignedByte(offset);
        }

        @Override
        public void putUnsignedByte(long offset, int b) {
            throw new IllegalAccessError("read-only");
        }

        @Override
        public int putLongPackBidi(long offset, long value) {
            throw new IllegalAccessError("read-only");
        }

        @Override
        public long getLongPackBidi(long offset) {
            return this.vol.getLongPackBidi(offset);
        }

        @Override
        public long getLongPackBidiReverse(long offset, long limitOffset) {
            return this.vol.getLongPackBidiReverse(offset, limitOffset);
        }

        @Override
        public long getSixLong(long pos) {
            return this.vol.getSixLong(pos);
        }

        @Override
        public void putSixLong(long pos, long value) {
            throw new IllegalAccessError("read-only");
        }

        @Override
        public File getFile() {
            return this.vol.getFile();
        }

        @Override
        public boolean getFileLocked() {
            return this.vol.getFileLocked();
        }

        @Override
        public void transferInto(long inputOffset, Volume target, long targetOffset, long size) {
            this.vol.transferInto(inputOffset, target, targetOffset, size);
        }

        @Override
        public void clear(long startOffset, long endOffset) {
            throw new IllegalAccessError("read-only");
        }
    }

    public static final class SingleByteArrayVol
    extends Volume {
        protected static final VolumeFactory FACTORY = new VolumeFactory(){

            @Override
            public Volume makeVolume(String file, boolean readOnly, boolean fileLockDisabled, int sliceShift, long initSize, boolean fixedSize) {
                if (initSize > Integer.MAX_VALUE) {
                    throw new IllegalArgumentException("startSize larger 2GB");
                }
                return new SingleByteArrayVol((int)initSize);
            }
        };
        protected final byte[] data;

        public SingleByteArrayVol(int size) {
            this(new byte[size]);
        }

        public SingleByteArrayVol(byte[] data) {
            this.data = data;
        }

        @Override
        public void ensureAvailable(long offset) {
            if (offset >= (long)this.data.length) {
                throw new DBException.VolumeMaxSizeExceeded(this.data.length, offset);
            }
        }

        @Override
        public void truncate(long size) {
        }

        @Override
        public void putLong(long offset, long v) {
            DataIO.putLong(this.data, (int)offset, v);
        }

        @Override
        public void putInt(long offset, int value) {
            int pos = (int)offset;
            this.data[pos++] = (byte)(0xFF & value >> 24);
            this.data[pos++] = (byte)(0xFF & value >> 16);
            this.data[pos++] = (byte)(0xFF & value >> 8);
            this.data[pos++] = (byte)(0xFF & value);
        }

        @Override
        public void putByte(long offset, byte value) {
            this.data[(int)offset] = value;
        }

        @Override
        public void putData(long offset, byte[] src, int srcPos, int srcSize) {
            System.arraycopy(src, srcPos, this.data, (int)offset, srcSize);
        }

        @Override
        public void putData(long offset, ByteBuffer buf) {
            buf.get(this.data, (int)offset, buf.remaining());
        }

        @Override
        public void transferInto(long inputOffset, Volume target, long targetOffset, long size) {
            target.putData(targetOffset, this.data, (int)inputOffset, (int)size);
        }

        @Override
        public void clear(long startOffset, long endOffset) {
            int start = (int)startOffset;
            int end = (int)endOffset;
            for (int pos = start; pos < end; pos += CLEAR.length) {
                System.arraycopy(CLEAR, 0, this.data, pos, Math.min(CLEAR.length, end - pos));
            }
        }

        @Override
        public long getLong(long offset) {
            return DataIO.getLong(this.data, (int)offset);
        }

        @Override
        public int getInt(long offset) {
            int pos;
            int end = pos + 4;
            int ret = 0;
            for (pos = (int)offset; pos < end; ++pos) {
                ret = ret << 8 | this.data[pos] & 0xFF;
            }
            return ret;
        }

        @Override
        public byte getByte(long offset) {
            return this.data[(int)offset];
        }

        @Override
        public DataInput getDataInput(long offset, int size) {
            return new DataIO.DataInputByteArray(this.data, (int)offset);
        }

        @Override
        public void getData(long offset, byte[] bytes, int bytesPos, int length) {
            System.arraycopy(this.data, (int)offset, bytes, bytesPos, length);
        }

        @Override
        public void close() {
            this.closed = true;
        }

        @Override
        public void sync() {
        }

        @Override
        public int sliceSize() {
            return -1;
        }

        @Override
        public boolean isSliced() {
            return false;
        }

        @Override
        public long length() {
            return this.data.length;
        }

        @Override
        public File getFile() {
            return null;
        }

        @Override
        public boolean getFileLocked() {
            return false;
        }
    }

    public static final class ByteArrayVol
    extends Volume {
        public static final VolumeFactory FACTORY = new VolumeFactory(){

            @Override
            public Volume makeVolume(String file, boolean readOnly, boolean fileLockDisable, int sliceShift, long initSize, boolean fixedSize) {
                return new ByteArrayVol(sliceShift, initSize);
            }
        };
        protected final ReentrantLock growLock = new ReentrantLock(false);
        protected final int sliceShift;
        protected final int sliceSizeModMask;
        protected final int sliceSize;
        protected volatile byte[][] slices = new byte[0][];

        protected ByteArrayVol() {
            this(20, 0L);
        }

        protected ByteArrayVol(int sliceShift, long initSize) {
            this.sliceShift = sliceShift;
            this.sliceSize = 1 << sliceShift;
            this.sliceSizeModMask = this.sliceSize - 1;
            if (initSize != 0L) {
                this.ensureAvailable(initSize);
            }
        }

        protected final byte[] getSlice(long offset) {
            int pos = (int)(offset >>> this.sliceShift);
            byte[][] slices = this.slices;
            if (pos >= slices.length) {
                throw new DBException.VolumeEOF();
            }
            return slices[pos];
        }

        @Override
        public final void ensureAvailable(long offset) {
            int slicePos = (int)((offset = Fun.roundUp(offset, 1L << this.sliceShift)) >>> this.sliceShift);
            if (slicePos < this.slices.length) {
                return;
            }
            this.growLock.lock();
            try {
                if (slicePos <= this.slices.length) {
                    return;
                }
                int oldSize = this.slices.length;
                byte[][] slices2 = this.slices;
                slices2 = (byte[][])Arrays.copyOf(slices2, slicePos);
                for (int pos = oldSize; pos < slices2.length; ++pos) {
                    slices2[pos] = new byte[this.sliceSize];
                }
                this.slices = slices2;
            }
            catch (OutOfMemoryError e) {
                throw new DBException.OutOfMemory(e);
            }
            finally {
                this.growLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void truncate(long size) {
            int maxSize = 1 + (int)(size >>> this.sliceShift);
            if (maxSize == this.slices.length) {
                return;
            }
            if (maxSize > this.slices.length) {
                this.ensureAvailable(size);
                return;
            }
            this.growLock.lock();
            try {
                if (maxSize >= this.slices.length) {
                    return;
                }
                this.slices = (byte[][])Arrays.copyOf(this.slices, maxSize);
            }
            finally {
                this.growLock.unlock();
            }
        }

        @Override
        public void putLong(long offset, long v) {
            int pos = (int)(offset & (long)this.sliceSizeModMask);
            byte[] buf = this.getSlice(offset);
            DataIO.putLong(buf, pos, v);
        }

        @Override
        public void putInt(long offset, int value) {
            int pos = (int)(offset & (long)this.sliceSizeModMask);
            byte[] buf = this.getSlice(offset);
            buf[pos++] = (byte)(0xFF & value >> 24);
            buf[pos++] = (byte)(0xFF & value >> 16);
            buf[pos++] = (byte)(0xFF & value >> 8);
            buf[pos++] = (byte)(0xFF & value);
        }

        @Override
        public void putByte(long offset, byte value) {
            byte[] b = this.getSlice(offset);
            b[(int)(offset & (long)this.sliceSizeModMask)] = value;
        }

        @Override
        public void putData(long offset, byte[] src, int srcPos, int srcSize) {
            int pos = (int)(offset & (long)this.sliceSizeModMask);
            byte[] buf = this.getSlice(offset);
            System.arraycopy(src, srcPos, buf, pos, srcSize);
        }

        @Override
        public void putData(long offset, ByteBuffer buf) {
            int pos = (int)(offset & (long)this.sliceSizeModMask);
            byte[] dst = this.getSlice(offset);
            buf.get(dst, pos, buf.remaining());
        }

        @Override
        public void transferInto(long inputOffset, Volume target, long targetOffset, long size) {
            int pos = (int)(inputOffset & (long)this.sliceSizeModMask);
            byte[] buf = this.getSlice(inputOffset);
            target.putData(targetOffset, buf, pos, (int)size);
        }

        @Override
        public void putDataOverlap(long offset, byte[] data, int pos, int len) {
            boolean overlap;
            boolean bl = overlap = offset >>> this.sliceShift != offset + (long)len >>> this.sliceShift;
            if (overlap) {
                while (len > 0) {
                    byte[] b = this.getSlice(offset);
                    int pos2 = (int)(offset & (long)this.sliceSizeModMask);
                    int toPut = Math.min(len, this.sliceSize - pos2);
                    System.arraycopy(data, pos, b, pos2, toPut);
                    pos += toPut;
                    len -= toPut;
                    offset += (long)toPut;
                }
            } else {
                this.putData(offset, data, pos, len);
            }
        }

        @Override
        public DataInput getDataInputOverlap(long offset, int size) {
            boolean overlap;
            boolean bl = overlap = offset >>> this.sliceShift != offset + (long)size >>> this.sliceShift;
            if (overlap) {
                byte[] bb = new byte[size];
                int origLen = size;
                while (size > 0) {
                    byte[] b = this.getSlice(offset);
                    int pos = (int)(offset & (long)this.sliceSizeModMask);
                    int toPut = Math.min(size, this.sliceSize - pos);
                    System.arraycopy(b, pos, bb, origLen - size, toPut);
                    size -= toPut;
                    offset += (long)toPut;
                }
                return new DataIO.DataInputByteArray(bb);
            }
            return this.getDataInput(offset, size);
        }

        @Override
        public void clear(long startOffset, long endOffset) {
            byte[] buf = this.getSlice(startOffset);
            int start = (int)(startOffset & (long)this.sliceSizeModMask);
            int end = (int)((long)start + (endOffset - startOffset));
            for (int pos = start; pos < end; pos += CLEAR.length) {
                System.arraycopy(CLEAR, 0, buf, pos, Math.min(CLEAR.length, end - pos));
            }
        }

        @Override
        public long getLong(long offset) {
            int pos = (int)(offset & (long)this.sliceSizeModMask);
            byte[] buf = this.getSlice(offset);
            return DataIO.getLong(buf, pos);
        }

        @Override
        public int getInt(long offset) {
            int pos;
            byte[] buf = this.getSlice(offset);
            int end = pos + 4;
            int ret = 0;
            for (pos = (int)(offset & (long)this.sliceSizeModMask); pos < end; ++pos) {
                ret = ret << 8 | buf[pos] & 0xFF;
            }
            return ret;
        }

        @Override
        public byte getByte(long offset) {
            byte[] b = this.getSlice(offset);
            return b[(int)(offset & (long)this.sliceSizeModMask)];
        }

        @Override
        public DataInput getDataInput(long offset, int size) {
            int pos = (int)(offset & (long)this.sliceSizeModMask);
            byte[] buf = this.getSlice(offset);
            return new DataIO.DataInputByteArray(buf, pos);
        }

        @Override
        public void getData(long offset, byte[] bytes, int bytesPos, int length) {
            int pos = (int)(offset & (long)this.sliceSizeModMask);
            byte[] buf = this.getSlice(offset);
            System.arraycopy(buf, pos, bytes, bytesPos, length);
        }

        @Override
        public void close() {
            this.closed = true;
            this.slices = null;
        }

        @Override
        public void sync() {
        }

        @Override
        public int sliceSize() {
            return this.sliceSize;
        }

        @Override
        public boolean isSliced() {
            return true;
        }

        @Override
        public long length() {
            return (long)this.slices.length * (long)this.sliceSize;
        }

        @Override
        public File getFile() {
            return null;
        }

        @Override
        public boolean getFileLocked() {
            return false;
        }
    }

    public static final class FileChannelVol
    extends Volume {
        public static final VolumeFactory FACTORY = new VolumeFactory(){

            @Override
            public Volume makeVolume(String file, boolean readOnly, boolean fileLockDisabled, int sliceShift, long initSize, boolean fixedSize) {
                return new FileChannelVol(new File(file), readOnly, fileLockDisabled, sliceShift, initSize);
            }
        };
        protected final File file;
        protected final int sliceSize;
        protected RandomAccessFile raf;
        protected FileChannel channel;
        protected final boolean readOnly;
        protected final FileLock fileLock;
        protected volatile long size;
        protected final Lock growLock = new ReentrantLock(false);

        public FileChannelVol(File file, boolean readOnly, boolean fileLockDisabled, int sliceShift, long initSize) {
            this.file = file;
            this.readOnly = readOnly;
            this.sliceSize = 1 << sliceShift;
            try {
                long oldSize;
                FileChannelVol.checkFolder(file, readOnly);
                if (readOnly && !file.exists()) {
                    this.raf = null;
                    this.channel = null;
                    this.size = 0L;
                } else {
                    this.raf = new RandomAccessFile(file, readOnly ? "r" : "rw");
                    this.channel = this.raf.getChannel();
                    this.size = this.channel.size();
                }
                this.fileLock = Volume.lockFile(file, this.raf, readOnly, fileLockDisabled);
                if (initSize != 0L && !readOnly && initSize > (oldSize = this.channel.size())) {
                    this.raf.setLength(initSize);
                    this.clear(oldSize, initSize);
                }
            }
            catch (ClosedByInterruptException e) {
                throw new DBException.VolumeClosedByInterrupt(e);
            }
            catch (ClosedChannelException e) {
                throw new DBException.VolumeClosed(e);
            }
            catch (IOException e) {
                throw new DBException.VolumeIOError(e);
            }
        }

        public FileChannelVol(File file) {
            this(file, false, false, 20, 0L);
        }

        protected static void checkFolder(File file, boolean readOnly) throws IOException {
            File parent = file.getParentFile();
            if (parent == null) {
                parent = file.getCanonicalFile().getParentFile();
            }
            if (parent == null) {
                throw new IOException("Parent folder could not be determined for: " + file);
            }
            if (!parent.exists() || !parent.isDirectory()) {
                throw new IOException("Parent folder does not exist: " + file);
            }
            if (!parent.canRead()) {
                throw new IOException("Parent folder is not readable: " + file);
            }
            if (!readOnly && !parent.canWrite()) {
                throw new IOException("Parent folder is not writable: " + file);
            }
        }

        @Override
        public void ensureAvailable(long offset) {
            if ((offset = Fun.roundUp(offset, this.sliceSize)) > this.size) {
                this.growLock.lock();
                try {
                    this.raf.setLength(offset);
                    this.size = offset;
                }
                catch (IOException e) {
                    throw new DBException.VolumeIOError(e);
                }
                finally {
                    this.growLock.unlock();
                }
            }
        }

        @Override
        public void truncate(long size) {
            this.growLock.lock();
            try {
                this.size = size;
                this.channel.truncate(size);
            }
            catch (ClosedByInterruptException e) {
                throw new DBException.VolumeClosedByInterrupt(e);
            }
            catch (ClosedChannelException e) {
                throw new DBException.VolumeClosed(e);
            }
            catch (IOException e) {
                throw new DBException.VolumeIOError(e);
            }
            finally {
                this.growLock.unlock();
            }
        }

        protected void writeFully(long offset, ByteBuffer buf) {
            try {
                int write;
                for (int remaining = buf.limit() - buf.position(); remaining > 0; remaining -= write) {
                    write = this.channel.write(buf, offset);
                    if (write >= 0) continue;
                    throw new EOFException();
                }
            }
            catch (ClosedByInterruptException e) {
                throw new DBException.VolumeClosedByInterrupt(e);
            }
            catch (ClosedChannelException e) {
                throw new DBException.VolumeClosed(e);
            }
            catch (IOException e) {
                throw new DBException.VolumeIOError(e);
            }
        }

        @Override
        public void putLong(long offset, long value) {
            ByteBuffer buf = ByteBuffer.allocate(8);
            buf.putLong(0, value);
            this.writeFully(offset, buf);
        }

        @Override
        public void putInt(long offset, int value) {
            ByteBuffer buf = ByteBuffer.allocate(4);
            buf.putInt(0, value);
            this.writeFully(offset, buf);
        }

        @Override
        public void putByte(long offset, byte value) {
            ByteBuffer buf = ByteBuffer.allocate(1);
            buf.put(0, value);
            this.writeFully(offset, buf);
        }

        @Override
        public void putData(long offset, byte[] src, int srcPos, int srcSize) {
            ByteBuffer buf = ByteBuffer.wrap(src, srcPos, srcSize);
            this.writeFully(offset, buf);
        }

        @Override
        public void putData(long offset, ByteBuffer buf) {
            this.writeFully(offset, buf);
        }

        protected void readFully(long offset, ByteBuffer buf) {
            try {
                int read;
                for (int remaining = buf.limit() - buf.position(); remaining > 0; remaining -= read) {
                    read = this.channel.read(buf, offset);
                    if (read >= 0) continue;
                    throw new EOFException();
                }
            }
            catch (ClosedByInterruptException e) {
                throw new DBException.VolumeClosedByInterrupt(e);
            }
            catch (ClosedChannelException e) {
                throw new DBException.VolumeClosed(e);
            }
            catch (IOException e) {
                throw new DBException.VolumeIOError(e);
            }
        }

        @Override
        public long getLong(long offset) {
            ByteBuffer buf = ByteBuffer.allocate(8);
            this.readFully(offset, buf);
            return buf.getLong(0);
        }

        @Override
        public int getInt(long offset) {
            ByteBuffer buf = ByteBuffer.allocate(4);
            this.readFully(offset, buf);
            return buf.getInt(0);
        }

        @Override
        public byte getByte(long offset) {
            ByteBuffer buf = ByteBuffer.allocate(1);
            this.readFully(offset, buf);
            return buf.get(0);
        }

        @Override
        public DataIO.DataInputByteBuffer getDataInput(long offset, int size) {
            ByteBuffer buf = ByteBuffer.allocate(size);
            this.readFully(offset, buf);
            return new DataIO.DataInputByteBuffer(buf, 0);
        }

        @Override
        public void getData(long offset, byte[] bytes, int bytesPos, int size) {
            ByteBuffer buf = ByteBuffer.wrap(bytes, bytesPos, size);
            this.readFully(offset, buf);
        }

        @Override
        public synchronized void close() {
            try {
                if (this.closed) {
                    return;
                }
                this.closed = true;
                if (this.fileLock != null && this.fileLock.isValid()) {
                    this.fileLock.release();
                }
                if (this.channel != null) {
                    this.channel.close();
                }
                this.channel = null;
                if (this.raf != null) {
                    this.raf.close();
                }
                this.raf = null;
            }
            catch (ClosedByInterruptException e) {
                throw new DBException.VolumeClosedByInterrupt(e);
            }
            catch (ClosedChannelException e) {
                throw new DBException.VolumeClosed(e);
            }
            catch (IOException e) {
                throw new DBException.VolumeIOError(e);
            }
        }

        @Override
        public void sync() {
            try {
                this.channel.force(true);
            }
            catch (ClosedByInterruptException e) {
                throw new DBException.VolumeClosedByInterrupt(e);
            }
            catch (ClosedChannelException e) {
                throw new DBException.VolumeClosed(e);
            }
            catch (IOException e) {
                throw new DBException.VolumeIOError(e);
            }
        }

        @Override
        public int sliceSize() {
            return -1;
        }

        @Override
        public boolean isSliced() {
            return false;
        }

        @Override
        public long length() {
            try {
                return this.channel.size();
            }
            catch (IOException e) {
                throw new DBException.VolumeIOError(e);
            }
        }

        @Override
        public File getFile() {
            return this.file;
        }

        @Override
        public boolean getFileLocked() {
            return this.fileLock != null && this.fileLock.isValid();
        }

        @Override
        public void clear(long startOffset, long endOffset) {
            try {
                while (startOffset < endOffset) {
                    ByteBuffer b = ByteBuffer.wrap(CLEAR);
                    b.limit((int)Math.min((long)CLEAR.length, endOffset - startOffset));
                    this.channel.write(b, startOffset);
                    startOffset += (long)CLEAR.length;
                }
            }
            catch (IOException e) {
                throw new DBException.VolumeIOError(e);
            }
        }
    }

    public static final class MemoryVolSingle
    extends ByteBufferVolSingle {
        protected final boolean useDirectBuffer;

        public String toString() {
            return super.toString() + ",direct=" + this.useDirectBuffer;
        }

        public MemoryVolSingle(boolean useDirectBuffer, long maxSize, boolean cleanerHackEnabled) {
            super(false, maxSize, cleanerHackEnabled);
            this.useDirectBuffer = useDirectBuffer;
            this.buffer = useDirectBuffer ? ByteBuffer.allocateDirect((int)maxSize) : ByteBuffer.allocate((int)maxSize);
        }

        @Override
        public void truncate(long size) {
        }

        @Override
        public synchronized void close() {
            if (this.closed) {
                return;
            }
            if (this.cleanerHackEnabled && this.buffer instanceof MappedByteBuffer) {
                ByteBufferVol.unmap((MappedByteBuffer)this.buffer);
            }
            this.buffer = null;
            this.closed = true;
        }

        @Override
        public void sync() {
        }

        @Override
        public long length() {
            return this.maxSize;
        }

        @Override
        public File getFile() {
            return null;
        }

        @Override
        public boolean getFileLocked() {
            return false;
        }
    }

    public static final class MemoryVol
    extends ByteBufferVol {
        public static final VolumeFactory FACTORY = new VolumeFactory(){

            @Override
            public Volume makeVolume(String file, boolean readOnly, boolean fileLockDisabled, int sliceShift, long initSize, boolean fixedSize) {
                return new MemoryVol(true, sliceShift, false, initSize);
            }
        };
        public static final VolumeFactory FACTORY_WITH_CLEANER_HACK = new VolumeFactory(){

            @Override
            public Volume makeVolume(String file, boolean readOnly, boolean fileLockDisabled, int sliceShift, long initSize, boolean fixedSize) {
                return new MemoryVol(true, sliceShift, true, initSize);
            }
        };
        protected final boolean useDirectBuffer;

        public String toString() {
            return super.toString() + ",direct=" + this.useDirectBuffer;
        }

        public MemoryVol(boolean useDirectBuffer, int sliceShift, boolean cleanerHackEnabled, long initSize) {
            super(false, sliceShift, cleanerHackEnabled);
            this.useDirectBuffer = useDirectBuffer;
            if (initSize != 0L) {
                this.ensureAvailable(initSize);
            }
        }

        @Override
        public final void ensureAvailable(long offset) {
            int slicePos = (int)((offset = Fun.roundUp(offset, 1L << this.sliceShift)) >>> this.sliceShift);
            if (slicePos < this.slices.length) {
                return;
            }
            this.growLock.lock();
            try {
                if (slicePos <= this.slices.length) {
                    return;
                }
                int oldSize = this.slices.length;
                ByteBuffer[] slices2 = this.slices;
                slices2 = Arrays.copyOf(slices2, slicePos);
                for (int pos = oldSize; pos < slices2.length; ++pos) {
                    ByteBuffer b;
                    slices2[pos] = b = this.useDirectBuffer ? ByteBuffer.allocateDirect(this.sliceSize) : ByteBuffer.allocate(this.sliceSize);
                }
                this.slices = slices2;
            }
            catch (OutOfMemoryError e) {
                throw new DBException.OutOfMemory(e);
            }
            finally {
                this.growLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void truncate(long size) {
            int maxSize = 1 + (int)(size >>> this.sliceShift);
            if (maxSize == this.slices.length) {
                return;
            }
            if (maxSize > this.slices.length) {
                this.ensureAvailable(size);
                return;
            }
            this.growLock.lock();
            try {
                if (maxSize >= this.slices.length) {
                    return;
                }
                ByteBuffer[] old = this.slices;
                this.slices = Arrays.copyOf(this.slices, maxSize);
                for (int i = maxSize; i < old.length; ++i) {
                    if (this.cleanerHackEnabled && old[i] instanceof MappedByteBuffer) {
                        MemoryVol.unmap((MappedByteBuffer)old[i]);
                    }
                    old[i] = null;
                }
            }
            finally {
                this.growLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            this.growLock.lock();
            try {
                this.closed = true;
                if (this.cleanerHackEnabled) {
                    for (ByteBuffer b : this.slices) {
                        if (b == null || !(b instanceof MappedByteBuffer)) continue;
                        MemoryVol.unmap((MappedByteBuffer)b);
                    }
                }
                Arrays.fill(this.slices, null);
                this.slices = null;
            }
            finally {
                this.growLock.unlock();
            }
        }

        @Override
        public void sync() {
        }

        @Override
        public long length() {
            return (long)this.slices.length * (long)this.sliceSize;
        }

        @Override
        public File getFile() {
            return null;
        }

        @Override
        public boolean getFileLocked() {
            return false;
        }
    }

    public static final class MappedFileVolSingle
    extends ByteBufferVolSingle {
        protected static final VolumeFactory FACTORY = new VolumeFactory(){

            @Override
            public Volume makeVolume(String file, boolean readOnly, boolean fileLockDisabled, int sliceShift, long initSize, boolean fixedSize) {
                if (initSize > Integer.MAX_VALUE) {
                    throw new IllegalArgumentException("startSize larger 2GB");
                }
                return new MappedFileVolSingle(new File(file), readOnly, fileLockDisabled, initSize, false);
            }
        };
        protected static final VolumeFactory FACTORY_WITH_CLEANER_HACK = new VolumeFactory(){

            @Override
            public Volume makeVolume(String file, boolean readOnly, boolean fileLockDisabled, int sliceShift, long initSize, boolean fixedSize) {
                if (initSize > Integer.MAX_VALUE) {
                    throw new IllegalArgumentException("startSize larger 2GB");
                }
                return new MappedFileVolSingle(new File(file), readOnly, fileLockDisabled, initSize, true);
            }
        };
        protected final File file;
        protected final FileChannel.MapMode mapMode;
        protected final RandomAccessFile raf;
        protected final FileLock fileLock;

        public MappedFileVolSingle(File file, boolean readOnly, boolean fileLockDisabled, long maxSize, boolean cleanerHackEnabled) {
            super(readOnly, maxSize, cleanerHackEnabled);
            this.file = file;
            this.mapMode = readOnly ? FileChannel.MapMode.READ_ONLY : FileChannel.MapMode.READ_WRITE;
            try {
                FileChannelVol.checkFolder(file, readOnly);
                this.raf = new RandomAccessFile(file, readOnly ? "r" : "rw");
                this.fileLock = Volume.lockFile(file, this.raf, readOnly, fileLockDisabled);
                long fileSize = this.raf.length();
                if (readOnly) {
                    maxSize = Math.min(maxSize, fileSize);
                } else if (fileSize < maxSize) {
                    this.raf.seek(fileSize);
                    long offset = fileSize;
                    do {
                        this.raf.write(CLEAR, 0, (int)Math.min((long)CLEAR.length, maxSize - offset));
                    } while ((offset += (long)CLEAR.length) < maxSize);
                }
                this.buffer = this.raf.getChannel().map(this.mapMode, 0L, maxSize);
                if (readOnly) {
                    this.buffer = this.buffer.asReadOnlyBuffer();
                }
            }
            catch (IOException e) {
                throw new DBException.VolumeIOError(e);
            }
        }

        @Override
        public synchronized void close() {
            if (this.closed) {
                return;
            }
            this.closed = true;
            try {
                if (this.fileLock != null && this.fileLock.isValid()) {
                    this.fileLock.release();
                }
                this.raf.close();
            }
            catch (IOException e) {
                throw new DBException.VolumeIOError(e);
            }
            if (this.cleanerHackEnabled && this.buffer != null && this.buffer instanceof MappedByteBuffer) {
                ByteBufferVol.unmap((MappedByteBuffer)this.buffer);
            }
            this.buffer = null;
        }

        @Override
        public synchronized void sync() {
            if (this.readOnly) {
                return;
            }
            if (this.buffer instanceof MappedByteBuffer) {
                ((MappedByteBuffer)this.buffer).force();
            }
        }

        @Override
        public long length() {
            return this.file.length();
        }

        @Override
        public File getFile() {
            return this.file;
        }

        @Override
        public boolean getFileLocked() {
            return this.fileLock != null && this.fileLock.isValid();
        }

        @Override
        public void truncate(long size) {
        }

        @Override
        public boolean fileLoad() {
            ((MappedByteBuffer)this.buffer).load();
            return true;
        }
    }

    public static final class MappedFileVol
    extends ByteBufferVol {
        public static final VolumeFactory FACTORY = new VolumeFactory(){

            @Override
            public Volume makeVolume(String file, boolean readOnly, boolean fileLockDisabled, int sliceShift, long initSize, boolean fixedSize) {
                return MappedFileVol.factory(file, readOnly, fileLockDisabled, sliceShift, false, initSize);
            }
        };
        public static final VolumeFactory FACTORY_WITH_CLEANER_HACK = new VolumeFactory(){

            @Override
            public Volume makeVolume(String file, boolean readOnly, boolean fileLockDisabled, int sliceShift, long initSize, boolean fixedSize) {
                return MappedFileVol.factory(file, readOnly, fileLockDisabled, sliceShift, true, initSize);
            }
        };
        protected final File file;
        protected final FileChannel fileChannel;
        protected final FileChannel.MapMode mapMode;
        protected final RandomAccessFile raf;
        protected final FileLock fileLock;

        private static Volume factory(String file, boolean readOnly, boolean fileLockDisabled, int sliceShift, boolean cleanerHackEnabled, long initSize) {
            long flen;
            File f = new File(file);
            if (readOnly && (flen = f.length()) <= Integer.MAX_VALUE) {
                return new MappedFileVolSingle(f, readOnly, fileLockDisabled, Math.max(flen, initSize), cleanerHackEnabled);
            }
            return new MappedFileVol(f, readOnly, fileLockDisabled, sliceShift, cleanerHackEnabled, initSize);
        }

        public MappedFileVol(File file, boolean readOnly, boolean fileLockDisable, int sliceShift, boolean cleanerHackEnabled, long initSize) {
            super(readOnly, sliceShift, cleanerHackEnabled);
            this.file = file;
            this.mapMode = readOnly ? FileChannel.MapMode.READ_ONLY : FileChannel.MapMode.READ_WRITE;
            try {
                long fileSize;
                FileChannelVol.checkFolder(file, readOnly);
                this.raf = new RandomAccessFile(file, readOnly ? "r" : "rw");
                this.fileChannel = this.raf.getChannel();
                this.fileLock = Volume.lockFile(file, this.raf, readOnly, fileLockDisable);
                long endSize = fileSize = this.fileChannel.size();
                if (initSize > fileSize && !readOnly) {
                    endSize = initSize;
                }
                if (endSize > 0L) {
                    int chunksSize = (int)(Fun.roundUp(endSize, this.sliceSize) >>> sliceShift);
                    if (endSize > fileSize && !readOnly) {
                        RandomAccessFileVol.clearRAF(this.raf, fileSize, endSize);
                        this.raf.getFD().sync();
                    }
                    this.slices = new ByteBuffer[chunksSize];
                    for (int i = 0; i < this.slices.length; ++i) {
                        MappedByteBuffer b = this.fileChannel.map(this.mapMode, 1L * (long)this.sliceSize * (long)i, this.sliceSize);
                        this.slices[i] = b;
                    }
                } else {
                    this.slices = new ByteBuffer[0];
                }
            }
            catch (IOException e) {
                throw new DBException.VolumeIOError(e);
            }
        }

        @Override
        public final void ensureAvailable(long offset) {
            int slicePos = (int)((offset = Fun.roundUp(offset, 1L << this.sliceShift)) >>> this.sliceShift);
            if (slicePos < this.slices.length) {
                return;
            }
            this.growLock.lock();
            try {
                if (slicePos <= this.slices.length) {
                    return;
                }
                int oldSize = this.slices.length;
                RandomAccessFileVol.clearRAF(this.raf, 1L * (long)oldSize * (long)this.sliceSize, offset);
                this.raf.getFD().sync();
                ByteBuffer[] slices2 = this.slices;
                slices2 = Arrays.copyOf(slices2, slicePos);
                for (int pos = oldSize; pos < slices2.length; ++pos) {
                    MappedByteBuffer b = this.fileChannel.map(this.mapMode, 1L * (long)this.sliceSize * (long)pos, this.sliceSize);
                    slices2[pos] = b;
                }
                this.slices = slices2;
            }
            catch (IOException e) {
                throw new DBException.VolumeIOError(e);
            }
            finally {
                this.growLock.unlock();
            }
        }

        @Override
        public void close() {
            this.growLock.lock();
            try {
                if (this.closed) {
                    return;
                }
                this.closed = true;
                if (this.fileLock != null && this.fileLock.isValid()) {
                    this.fileLock.release();
                }
                this.fileChannel.close();
                this.raf.close();
                if (this.cleanerHackEnabled) {
                    for (ByteBuffer b : this.slices) {
                        if (b == null || !(b instanceof MappedByteBuffer)) continue;
                        MappedFileVol.unmap((MappedByteBuffer)b);
                    }
                }
                Arrays.fill(this.slices, null);
                this.slices = null;
            }
            catch (IOException e) {
                throw new DBException.VolumeIOError(e);
            }
            finally {
                this.growLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sync() {
            if (this.readOnly) {
                return;
            }
            this.growLock.lock();
            try {
                ByteBuffer[] slices = this.slices;
                if (slices == null) {
                    return;
                }
                for (int i = slices.length - 1; i >= 0; --i) {
                    ByteBuffer b = slices[i];
                    if (b == null || !(b instanceof MappedByteBuffer)) continue;
                    MappedByteBuffer bb = (MappedByteBuffer)b;
                    bb.force();
                }
            }
            finally {
                this.growLock.unlock();
            }
        }

        @Override
        public long length() {
            return this.file.length();
        }

        @Override
        public File getFile() {
            return this.file;
        }

        @Override
        public boolean getFileLocked() {
            return this.fileLock != null && this.fileLock.isValid();
        }

        @Override
        public void truncate(long size) {
            int maxSize = 1 + (int)(size >>> this.sliceShift);
            if (maxSize == this.slices.length) {
                return;
            }
            if (maxSize > this.slices.length) {
                this.ensureAvailable(size);
                return;
            }
            this.growLock.lock();
            try {
                int i;
                if (maxSize >= this.slices.length) {
                    return;
                }
                ByteBuffer[] old = this.slices;
                this.slices = Arrays.copyOf(this.slices, maxSize);
                for (i = maxSize; i < old.length; ++i) {
                    if (this.cleanerHackEnabled) {
                        MappedFileVol.unmap((MappedByteBuffer)old[i]);
                    }
                    old[i] = null;
                }
                if (ByteBufferVol.windowsWorkaround) {
                    for (i = 0; i < maxSize; ++i) {
                        if (this.cleanerHackEnabled) {
                            MappedFileVol.unmap((MappedByteBuffer)old[i]);
                        }
                        old[i] = null;
                    }
                }
                try {
                    this.fileChannel.truncate(1L * (long)this.sliceSize * (long)maxSize);
                }
                catch (IOException e) {
                    throw new DBException.VolumeIOError(e);
                }
                if (ByteBufferVol.windowsWorkaround) {
                    for (int pos = 0; pos < maxSize; ++pos) {
                        MappedByteBuffer b = this.fileChannel.map(this.mapMode, 1L * (long)this.sliceSize * (long)pos, this.sliceSize);
                        this.slices[pos] = b;
                    }
                }
            }
            catch (IOException e) {
                throw new DBException.VolumeIOError(e);
            }
            finally {
                this.growLock.unlock();
            }
        }

        @Override
        public boolean fileLoad() {
            ByteBuffer[] slices;
            for (ByteBuffer b : slices = this.slices) {
                if (!(b instanceof MappedByteBuffer)) continue;
                ((MappedByteBuffer)b).load();
            }
            return true;
        }
    }

    public static abstract class ByteBufferVolSingle
    extends Volume {
        protected final boolean cleanerHackEnabled;
        protected ByteBuffer buffer;
        protected final boolean readOnly;
        protected final long maxSize;

        protected ByteBufferVolSingle(boolean readOnly, long maxSize, boolean cleanerHackEnabled) {
            this.readOnly = readOnly;
            this.maxSize = maxSize;
            this.cleanerHackEnabled = cleanerHackEnabled;
        }

        @Override
        public void ensureAvailable(long offset) {
        }

        @Override
        public final void putLong(long offset, long value) {
            this.buffer.putLong((int)offset, value);
        }

        @Override
        public final void putInt(long offset, int value) {
            this.buffer.putInt((int)offset, value);
        }

        @Override
        public final void putByte(long offset, byte value) {
            this.buffer.put((int)offset, value);
        }

        @Override
        public void putData(long offset, byte[] src, int srcPos, int srcSize) {
            ByteBuffer b1 = this.buffer.duplicate();
            int bufPos = (int)offset;
            b1.position(bufPos);
            b1.put(src, srcPos, srcSize);
        }

        @Override
        public final void putData(long offset, ByteBuffer buf) {
            ByteBuffer b1 = this.buffer.duplicate();
            int bufPos = (int)offset;
            b1.position(bufPos);
            b1.put(buf);
        }

        @Override
        public void transferInto(long inputOffset, Volume target, long targetOffset, long size) {
            ByteBuffer b1 = this.buffer.duplicate();
            int bufPos = (int)inputOffset;
            b1.position(bufPos);
            b1.limit((int)((long)bufPos + size));
            target.putData(targetOffset, b1);
        }

        @Override
        public void getData(long offset, byte[] src, int srcPos, int srcSize) {
            ByteBuffer b1 = this.buffer.duplicate();
            int bufPos = (int)offset;
            b1.position(bufPos);
            b1.get(src, srcPos, srcSize);
        }

        @Override
        public final long getLong(long offset) {
            return this.buffer.getLong((int)offset);
        }

        @Override
        public final int getInt(long offset) {
            return this.buffer.getInt((int)offset);
        }

        @Override
        public final byte getByte(long offset) {
            return this.buffer.get((int)offset);
        }

        @Override
        public final DataIO.DataInputByteBuffer getDataInput(long offset, int size) {
            return new DataIO.DataInputByteBuffer(this.buffer, (int)offset);
        }

        @Override
        public void putDataOverlap(long offset, byte[] data, int pos, int len) {
            this.putData(offset, data, pos, len);
        }

        @Override
        public DataInput getDataInputOverlap(long offset, int size) {
            return this.getDataInput(offset, size);
        }

        @Override
        public void clear(long startOffset, long endOffset) {
            int start = (int)startOffset;
            int end = (int)endOffset;
            ByteBuffer buf = this.buffer;
            for (int pos = start; pos < end; pos += CLEAR.length) {
                buf = buf.duplicate();
                buf.position(pos);
                buf.put(CLEAR, 0, Math.min(CLEAR.length, end - pos));
            }
        }

        @Override
        public int sliceSize() {
            return -1;
        }

        @Override
        public boolean isSliced() {
            return false;
        }
    }

    public static abstract class ByteBufferVol
    extends Volume {
        protected final boolean cleanerHackEnabled;
        protected final ReentrantLock growLock = new ReentrantLock(false);
        protected final int sliceShift;
        protected final int sliceSizeModMask;
        protected final int sliceSize;
        protected volatile ByteBuffer[] slices = new ByteBuffer[0];
        protected final boolean readOnly;
        private static boolean unmapHackSupported = true;
        private static boolean windowsWorkaround;

        protected ByteBufferVol(boolean readOnly, int sliceShift, boolean cleanerHackEnabled) {
            this.readOnly = readOnly;
            this.sliceShift = sliceShift;
            this.cleanerHackEnabled = cleanerHackEnabled;
            this.sliceSize = 1 << sliceShift;
            this.sliceSizeModMask = this.sliceSize - 1;
        }

        protected final ByteBuffer getSlice(long offset) {
            int pos = (int)(offset >>> this.sliceShift);
            ByteBuffer[] slices = this.slices;
            if (pos >= slices.length) {
                throw new DBException.VolumeEOF("Get/Set beyong file size. Requested offset: " + offset + ", volume size: " + this.length());
            }
            return slices[pos];
        }

        @Override
        public final void putLong(long offset, long value) {
            this.getSlice(offset).putLong((int)(offset & (long)this.sliceSizeModMask), value);
        }

        @Override
        public final void putInt(long offset, int value) {
            this.getSlice(offset).putInt((int)(offset & (long)this.sliceSizeModMask), value);
        }

        @Override
        public final void putByte(long offset, byte value) {
            this.getSlice(offset).put((int)(offset & (long)this.sliceSizeModMask), value);
        }

        @Override
        public void putData(long offset, byte[] src, int srcPos, int srcSize) {
            ByteBuffer b1 = this.getSlice(offset).duplicate();
            int bufPos = (int)(offset & (long)this.sliceSizeModMask);
            b1.position(bufPos);
            b1.put(src, srcPos, srcSize);
        }

        @Override
        public final void putData(long offset, ByteBuffer buf) {
            ByteBuffer b1 = this.getSlice(offset).duplicate();
            int bufPos = (int)(offset & (long)this.sliceSizeModMask);
            b1.position(bufPos);
            b1.put(buf);
        }

        @Override
        public void transferInto(long inputOffset, Volume target, long targetOffset, long size) {
            ByteBuffer b1 = this.getSlice(inputOffset).duplicate();
            int bufPos = (int)(inputOffset & (long)this.sliceSizeModMask);
            b1.position(bufPos);
            b1.limit((int)((long)bufPos + size));
            target.putData(targetOffset, b1);
        }

        @Override
        public void getData(long offset, byte[] src, int srcPos, int srcSize) {
            ByteBuffer b1 = this.getSlice(offset).duplicate();
            int bufPos = (int)(offset & (long)this.sliceSizeModMask);
            b1.position(bufPos);
            b1.get(src, srcPos, srcSize);
        }

        @Override
        public final long getLong(long offset) {
            return this.getSlice(offset).getLong((int)(offset & (long)this.sliceSizeModMask));
        }

        @Override
        public final int getInt(long offset) {
            return this.getSlice(offset).getInt((int)(offset & (long)this.sliceSizeModMask));
        }

        @Override
        public final byte getByte(long offset) {
            return this.getSlice(offset).get((int)(offset & (long)this.sliceSizeModMask));
        }

        @Override
        public final DataIO.DataInputByteBuffer getDataInput(long offset, int size) {
            return new DataIO.DataInputByteBuffer(this.getSlice(offset), (int)(offset & (long)this.sliceSizeModMask));
        }

        @Override
        public void putDataOverlap(long offset, byte[] data, int pos, int len) {
            boolean overlap;
            boolean bl = overlap = offset >>> this.sliceShift != offset + (long)len >>> this.sliceShift;
            if (overlap) {
                while (len > 0) {
                    ByteBuffer b = this.getSlice(offset).duplicate();
                    b.position((int)(offset & (long)this.sliceSizeModMask));
                    int toPut = Math.min(len, this.sliceSize - b.position());
                    b.limit(b.position() + toPut);
                    b.put(data, pos, toPut);
                    pos += toPut;
                    len -= toPut;
                    offset += (long)toPut;
                }
            } else {
                this.putData(offset, data, pos, len);
            }
        }

        @Override
        public DataInput getDataInputOverlap(long offset, int size) {
            boolean overlap;
            boolean bl = overlap = offset >>> this.sliceShift != offset + (long)size >>> this.sliceShift;
            if (overlap) {
                byte[] bb = new byte[size];
                int origLen = size;
                while (size > 0) {
                    ByteBuffer b = this.getSlice(offset).duplicate();
                    b.position((int)(offset & (long)this.sliceSizeModMask));
                    int toPut = Math.min(size, this.sliceSize - b.position());
                    b.limit(b.position() + toPut);
                    b.get(bb, origLen - size, toPut);
                    size -= toPut;
                    offset += (long)toPut;
                }
                return new DataIO.DataInputByteArray(bb);
            }
            return this.getDataInput(offset, size);
        }

        @Override
        public void putUnsignedShort(long offset, int value) {
            ByteBuffer b = this.getSlice(offset);
            int bpos = (int)(offset & (long)this.sliceSizeModMask);
            b.put(bpos++, (byte)(value >> 8));
            b.put(bpos, (byte)value);
        }

        @Override
        public int getUnsignedShort(long offset) {
            ByteBuffer b = this.getSlice(offset);
            int bpos = (int)(offset & (long)this.sliceSizeModMask);
            return (b.get(bpos++) & 0xFF) << 8 | b.get(bpos) & 0xFF;
        }

        @Override
        public int getUnsignedByte(long offset) {
            ByteBuffer b = this.getSlice(offset);
            int bpos = (int)(offset & (long)this.sliceSizeModMask);
            return b.get(bpos) & 0xFF;
        }

        @Override
        public void putUnsignedByte(long offset, int byt) {
            ByteBuffer b = this.getSlice(offset);
            int bpos = (int)(offset & (long)this.sliceSizeModMask);
            b.put(bpos, ByteBufferVol.toByte(byt));
        }

        protected static byte toByte(int byt) {
            return (byte)(byt & 0xFF);
        }

        protected static byte toByte(long l) {
            return (byte)(l & 0xFFL);
        }

        @Override
        public long getSixLong(long pos) {
            ByteBuffer bb = this.getSlice(pos);
            int bpos = (int)(pos & (long)this.sliceSizeModMask);
            return (long)(bb.get(bpos++) & 0xFF) << 40 | (long)(bb.get(bpos++) & 0xFF) << 32 | (long)(bb.get(bpos++) & 0xFF) << 24 | (long)(bb.get(bpos++) & 0xFF) << 16 | (long)(bb.get(bpos++) & 0xFF) << 8 | (long)(bb.get(bpos) & 0xFF);
        }

        @Override
        public void putSixLong(long pos, long value) {
            ByteBuffer b = this.getSlice(pos);
            int bpos = (int)(pos & (long)this.sliceSizeModMask);
            b.put(bpos++, (byte)(0xFFL & value >> 40));
            b.put(bpos++, (byte)(0xFFL & value >> 32));
            b.put(bpos++, (byte)(0xFFL & value >> 24));
            b.put(bpos++, (byte)(0xFFL & value >> 16));
            b.put(bpos++, (byte)(0xFFL & value >> 8));
            b.put(bpos, (byte)(0xFFL & value));
        }

        @Override
        public int putPackedLong(long pos, long value) {
            ByteBuffer b = this.getSlice(pos);
            int bpos = (int)(pos & (long)this.sliceSizeModMask);
            int ret = 0;
            int shift = 63 - Long.numberOfLeadingZeros(value);
            shift -= shift % 7;
            while (shift != 0) {
                b.put(bpos + ret++, (byte)(value >>> shift & 0x7FL | 0x80L));
                shift -= 7;
            }
            b.put(bpos + ret++, (byte)(value & 0x7FL));
            return ret;
        }

        @Override
        public long getPackedLong(long position) {
            byte v;
            ByteBuffer b = this.getSlice(position);
            int bpos = (int)(position & (long)this.sliceSizeModMask);
            long ret = 0L;
            int pos2 = 0;
            do {
                v = b.get(bpos + pos2++);
                ret = ret << 7 | (long)(v & 0x7F);
            } while (v < 0);
            return (long)pos2 << 60 | ret;
        }

        @Override
        public void clear(long startOffset, long endOffset) {
            ByteBuffer buf = this.getSlice(startOffset);
            int start = (int)(startOffset & (long)this.sliceSizeModMask);
            int end = (int)((long)start + (endOffset - startOffset));
            for (int pos = start; pos < end; pos += CLEAR.length) {
                buf = buf.duplicate();
                buf.position(pos);
                buf.put(CLEAR, 0, Math.min(CLEAR.length, end - pos));
            }
        }

        @Override
        public boolean isSliced() {
            return true;
        }

        @Override
        public int sliceSize() {
            return this.sliceSize;
        }

        protected static boolean unmap(MappedByteBuffer b) {
            block4: {
                try {
                    if (!unmapHackSupported) break block4;
                    Method cleanerMethod = b.getClass().getMethod("cleaner", new Class[0]);
                    cleanerMethod.setAccessible(true);
                    if (cleanerMethod == null) break block4;
                    Object cleaner = cleanerMethod.invoke((Object)b, new Object[0]);
                    if (cleaner != null) {
                        Method clearMethod = cleaner.getClass().getMethod("clean", new Class[0]);
                        if (clearMethod != null) {
                            clearMethod.invoke(cleaner, new Object[0]);
                            return true;
                        }
                        break block4;
                    }
                    Method attMethod = b.getClass().getMethod("attachment", new Class[0]);
                    attMethod.setAccessible(true);
                    Object att = attMethod.invoke((Object)b, new Object[0]);
                    return att instanceof MappedByteBuffer && ByteBufferVol.unmap((MappedByteBuffer)att);
                }
                catch (Exception e) {
                    unmapHackSupported = false;
                    LOG.log(Level.WARNING, "Unmap failed", e);
                }
            }
            return false;
        }

        static {
            try {
                unmapHackSupported = SerializerPojo.DEFAULT_CLASS_LOADER.run("sun.nio.ch.DirectBuffer") != null;
            }
            catch (Exception e) {
                unmapHackSupported = false;
            }
            windowsWorkaround = System.getProperty("os.name").toLowerCase().startsWith("win");
        }
    }

    public static abstract class VolumeFactory {
        public abstract Volume makeVolume(String var1, boolean var2, boolean var3, int var4, long var5, boolean var7);

        public Volume makeVolume(String file, boolean readOnly) {
            return this.makeVolume(file, readOnly, false);
        }

        public Volume makeVolume(String file, boolean readOnly, boolean fileLockDisable) {
            return this.makeVolume(file, readOnly, fileLockDisable, 20, 0L, false);
        }
    }
}

