/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Objects;
import org.mandas.docker.Nullable;
import org.mandas.docker.client.messages.PortBinding;

final class ImmutablePortBinding
implements PortBinding {
    @Nullable
    private final String hostIp;
    private final String hostPort;

    private ImmutablePortBinding(@Nullable String hostIp, String hostPort) {
        this.hostIp = hostIp;
        this.hostPort = hostPort;
    }

    @Override
    @JsonProperty(value="HostIp")
    @Nullable
    public String hostIp() {
        return this.hostIp;
    }

    @Override
    @JsonProperty(value="HostPort")
    public String hostPort() {
        return this.hostPort;
    }

    public final ImmutablePortBinding withHostIp(@Nullable String value) {
        if (Objects.equals(this.hostIp, value)) {
            return this;
        }
        return new ImmutablePortBinding(value, this.hostPort);
    }

    public final ImmutablePortBinding withHostPort(String value) {
        String newValue = Objects.requireNonNull(value, "hostPort");
        if (this.hostPort.equals(newValue)) {
            return this;
        }
        return new ImmutablePortBinding(this.hostIp, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePortBinding && this.equalTo(0, (ImmutablePortBinding)another);
    }

    private boolean equalTo(int synthetic, ImmutablePortBinding another) {
        return Objects.equals(this.hostIp, another.hostIp) && this.hostPort.equals(another.hostPort);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.hostIp);
        h += (h << 5) + this.hostPort.hashCode();
        return h;
    }

    public String toString() {
        return "PortBinding{hostIp=" + this.hostIp + ", hostPort=" + this.hostPort + "}";
    }

    public static ImmutablePortBinding copyOf(PortBinding instance) {
        if (instance instanceof ImmutablePortBinding) {
            return (ImmutablePortBinding)instance;
        }
        return ImmutablePortBinding.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    static final class Builder {
        private static final long INIT_BIT_HOST_PORT = 1L;
        private long initBits = 1L;
        private String hostIp;
        private String hostPort;

        private Builder() {
        }

        public final Builder from(PortBinding instance) {
            Objects.requireNonNull(instance, "instance");
            String hostIpValue = instance.hostIp();
            if (hostIpValue != null) {
                this.hostIp(hostIpValue);
            }
            this.hostPort(instance.hostPort());
            return this;
        }

        @JsonProperty(value="HostIp")
        public final Builder hostIp(@Nullable String hostIp) {
            this.hostIp = hostIp;
            return this;
        }

        @JsonProperty(value="HostPort")
        public final Builder hostPort(String hostPort) {
            this.hostPort = Objects.requireNonNull(hostPort, "hostPort");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutablePortBinding build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePortBinding(this.hostIp, this.hostPort);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("hostPort");
            }
            return "Cannot build PortBinding, some of required attributes are not set " + attributes;
        }
    }
}

