/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.mandas.docker.Nullable;
import org.mandas.docker.client.messages.ImageHistory;

final class ImmutableImageHistory
implements ImageHistory {
    private final String id;
    private final Long created;
    private final String createdBy;
    @Nullable
    private final List<String> tags;
    private final Long size;
    @Nullable
    private final String comment;

    private ImmutableImageHistory(String id, Long created, String createdBy, @Nullable List<String> tags, Long size, @Nullable String comment) {
        this.id = id;
        this.created = created;
        this.createdBy = createdBy;
        this.tags = tags;
        this.size = size;
        this.comment = comment;
    }

    @Override
    @JsonProperty(value="Id")
    public String id() {
        return this.id;
    }

    @Override
    @JsonProperty(value="Created")
    public Long created() {
        return this.created;
    }

    @Override
    @JsonProperty(value="CreatedBy")
    public String createdBy() {
        return this.createdBy;
    }

    @Override
    @JsonProperty(value="Tags")
    @Nullable
    public List<String> tags() {
        return this.tags;
    }

    @Override
    @JsonProperty(value="Size")
    public Long size() {
        return this.size;
    }

    @Override
    @JsonProperty(value="Comment")
    @Nullable
    public String comment() {
        return this.comment;
    }

    public final ImmutableImageHistory withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new ImmutableImageHistory(newValue, this.created, this.createdBy, this.tags, this.size, this.comment);
    }

    public final ImmutableImageHistory withCreated(Long value) {
        Long newValue = Objects.requireNonNull(value, "created");
        if (this.created.equals(newValue)) {
            return this;
        }
        return new ImmutableImageHistory(this.id, newValue, this.createdBy, this.tags, this.size, this.comment);
    }

    public final ImmutableImageHistory withCreatedBy(String value) {
        String newValue = Objects.requireNonNull(value, "createdBy");
        if (this.createdBy.equals(newValue)) {
            return this;
        }
        return new ImmutableImageHistory(this.id, this.created, newValue, this.tags, this.size, this.comment);
    }

    public final ImmutableImageHistory withTags(String ... elements) {
        if (elements == null) {
            return new ImmutableImageHistory(this.id, this.created, this.createdBy, null, this.size, this.comment);
        }
        List<String> newValue = Arrays.asList(elements) == null ? null : ImmutableImageHistory.createUnmodifiableList(false, ImmutableImageHistory.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableImageHistory(this.id, this.created, this.createdBy, newValue, this.size, this.comment);
    }

    public final ImmutableImageHistory withTags(@Nullable Iterable<String> elements) {
        if (this.tags == elements) {
            return this;
        }
        List<String> newValue = elements == null ? null : ImmutableImageHistory.createUnmodifiableList(false, ImmutableImageHistory.createSafeList(elements, true, false));
        return new ImmutableImageHistory(this.id, this.created, this.createdBy, newValue, this.size, this.comment);
    }

    public final ImmutableImageHistory withSize(Long value) {
        Long newValue = Objects.requireNonNull(value, "size");
        if (this.size.equals(newValue)) {
            return this;
        }
        return new ImmutableImageHistory(this.id, this.created, this.createdBy, this.tags, newValue, this.comment);
    }

    public final ImmutableImageHistory withComment(@Nullable String value) {
        if (Objects.equals(this.comment, value)) {
            return this;
        }
        return new ImmutableImageHistory(this.id, this.created, this.createdBy, this.tags, this.size, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableImageHistory && this.equalTo(0, (ImmutableImageHistory)another);
    }

    private boolean equalTo(int synthetic, ImmutableImageHistory another) {
        return this.id.equals(another.id) && this.created.equals(another.created) && this.createdBy.equals(another.createdBy) && Objects.equals(this.tags, another.tags) && this.size.equals(another.size) && Objects.equals(this.comment, another.comment);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.created.hashCode();
        h += (h << 5) + this.createdBy.hashCode();
        h += (h << 5) + Objects.hashCode(this.tags);
        h += (h << 5) + this.size.hashCode();
        h += (h << 5) + Objects.hashCode(this.comment);
        return h;
    }

    public String toString() {
        return "ImageHistory{id=" + this.id + ", created=" + this.created + ", createdBy=" + this.createdBy + ", tags=" + this.tags + ", size=" + this.size + ", comment=" + this.comment + "}";
    }

    public static ImmutableImageHistory copyOf(ImageHistory instance) {
        if (instance instanceof ImmutableImageHistory) {
            return (ImmutableImageHistory)instance;
        }
        return ImmutableImageHistory.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_CREATED = 2L;
        private static final long INIT_BIT_CREATED_BY = 4L;
        private static final long INIT_BIT_SIZE = 8L;
        private long initBits = 15L;
        private String id;
        private Long created;
        private String createdBy;
        private List<String> tags = null;
        private Long size;
        private String comment;

        private Builder() {
        }

        public final Builder from(ImageHistory instance) {
            Objects.requireNonNull(instance, "instance");
            this.id(instance.id());
            this.created(instance.created());
            this.createdBy(instance.createdBy());
            List<String> tagsValue = instance.tags();
            if (tagsValue != null) {
                this.addAllTags(tagsValue);
            }
            this.size(instance.size());
            String commentValue = instance.comment();
            if (commentValue != null) {
                this.comment(commentValue);
            }
            return this;
        }

        @JsonProperty(value="Id")
        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="Created")
        public final Builder created(Long created) {
            this.created = Objects.requireNonNull(created, "created");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="CreatedBy")
        public final Builder createdBy(String createdBy) {
            this.createdBy = Objects.requireNonNull(createdBy, "createdBy");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder tag(String element) {
            if (this.tags == null) {
                this.tags = new ArrayList<String>();
            }
            this.tags.add(Objects.requireNonNull(element, "tags element"));
            return this;
        }

        public final Builder tags(String ... elements) {
            if (this.tags == null) {
                this.tags = new ArrayList<String>();
            }
            for (String element : elements) {
                this.tags.add(Objects.requireNonNull(element, "tags element"));
            }
            return this;
        }

        @JsonProperty(value="Tags")
        public final Builder tags(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.tags = null;
                return this;
            }
            this.tags = new ArrayList<String>();
            return this.addAllTags(elements);
        }

        public final Builder addAllTags(Iterable<String> elements) {
            Objects.requireNonNull(elements, "tags element");
            if (this.tags == null) {
                this.tags = new ArrayList<String>();
            }
            for (String element : elements) {
                this.tags.add(Objects.requireNonNull(element, "tags element"));
            }
            return this;
        }

        @JsonProperty(value="Size")
        public final Builder size(Long size) {
            this.size = Objects.requireNonNull(size, "size");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="Comment")
        public final Builder comment(@Nullable String comment) {
            this.comment = comment;
            return this;
        }

        public ImmutableImageHistory build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableImageHistory(this.id, this.created, this.createdBy, this.tags == null ? null : ImmutableImageHistory.createUnmodifiableList(true, this.tags), this.size, this.comment);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("created");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("createdBy");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("size");
            }
            return "Cannot build ImageHistory, some of required attributes are not set " + attributes;
        }
    }
}

