package org.mandas.docker.client.messages.swarm;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

/**
 * Immutable implementation of {@link JobStatus}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableJobStatus.builder()}.
 */
@SuppressWarnings({"all"})
final class ImmutableJobStatus implements JobStatus {
  private final Version jobIteration;
  private final Date lastExecution;

  private ImmutableJobStatus(Version jobIteration, Date lastExecution) {
    this.jobIteration = jobIteration;
    this.lastExecution = lastExecution;
  }

  /**
   * @return The value of the {@code jobIteration} attribute
   */
  @JsonProperty("JobIteration")
  @Override
  public Version jobIteration() {
    return jobIteration;
  }

  /**
   * @return The value of the {@code lastExecution} attribute
   */
  @JsonProperty("LastExecution")
  @Override
  public Date lastExecution() {
    return lastExecution;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link JobStatus#jobIteration() jobIteration} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for jobIteration
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableJobStatus withJobIteration(Version value) {
    if (this.jobIteration == value) return this;
    Version newValue = Objects.requireNonNull(value, "jobIteration");
    return new ImmutableJobStatus(newValue, this.lastExecution);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link JobStatus#lastExecution() lastExecution} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for lastExecution
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableJobStatus withLastExecution(Date value) {
    if (this.lastExecution == value) return this;
    Date newValue = Objects.requireNonNull(value, "lastExecution");
    return new ImmutableJobStatus(this.jobIteration, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableJobStatus} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableJobStatus
        && equalTo(0, (ImmutableJobStatus) another);
  }

  private boolean equalTo(int synthetic, ImmutableJobStatus another) {
    return jobIteration.equals(another.jobIteration)
        && lastExecution.equals(another.lastExecution);
  }

  /**
   * Computes a hash code from attributes: {@code jobIteration}, {@code lastExecution}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + jobIteration.hashCode();
    h += (h << 5) + lastExecution.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code JobStatus} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "JobStatus{"
        + "jobIteration=" + jobIteration
        + ", lastExecution=" + lastExecution
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link JobStatus} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable JobStatus instance
   */
  public static ImmutableJobStatus copyOf(JobStatus instance) {
    if (instance instanceof ImmutableJobStatus) {
      return (ImmutableJobStatus) instance;
    }
    return ImmutableJobStatus.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableJobStatus ImmutableJobStatus}.
   * <pre>
   * ImmutableJobStatus.builder()
   *    .jobIteration(org.mandas.docker.client.messages.swarm.Version) // required {@link JobStatus#jobIteration() jobIteration}
   *    .lastExecution(Date) // required {@link JobStatus#lastExecution() lastExecution}
   *    .build();
   * </pre>
   * @return A new ImmutableJobStatus builder
   */
  public static ImmutableJobStatus.Builder builder() {
    return new ImmutableJobStatus.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableJobStatus ImmutableJobStatus}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  static final class Builder implements JobStatus.Builder {
    private static final long INIT_BIT_JOB_ITERATION = 0x1L;
    private static final long INIT_BIT_LAST_EXECUTION = 0x2L;
    private long initBits = 0x3L;

    private Version jobIteration;
    private Date lastExecution;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code JobStatus} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(JobStatus instance) {
      Objects.requireNonNull(instance, "instance");
      jobIteration(instance.jobIteration());
      lastExecution(instance.lastExecution());
      return this;
    }

    /**
     * Initializes the value for the {@link JobStatus#jobIteration() jobIteration} attribute.
     * @param jobIteration The value for jobIteration 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("JobIteration")
    public final Builder jobIteration(Version jobIteration) {
      this.jobIteration = Objects.requireNonNull(jobIteration, "jobIteration");
      initBits &= ~INIT_BIT_JOB_ITERATION;
      return this;
    }

    /**
     * Initializes the value for the {@link JobStatus#lastExecution() lastExecution} attribute.
     * @param lastExecution The value for lastExecution 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("LastExecution")
    public final Builder lastExecution(Date lastExecution) {
      this.lastExecution = Objects.requireNonNull(lastExecution, "lastExecution");
      initBits &= ~INIT_BIT_LAST_EXECUTION;
      return this;
    }

    /**
     * Builds a new {@link ImmutableJobStatus ImmutableJobStatus}.
     * @return An immutable instance of JobStatus
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableJobStatus build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableJobStatus(jobIteration, lastExecution);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_JOB_ITERATION) != 0) attributes.add("jobIteration");
      if ((initBits & INIT_BIT_LAST_EXECUTION) != 0) attributes.add("lastExecution");
      return "Cannot build JobStatus, some of required attributes are not set " + attributes;
    }
  }
}
