package org.mandas.docker.client.messages;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.mandas.docker.Nullable;

/**
 * Immutable implementation of {@link PortBinding}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutablePortBinding.builder()}.
 */
@SuppressWarnings({"all"})
final class ImmutablePortBinding implements PortBinding {
  private final @Nullable String hostIp;
  private final String hostPort;

  private ImmutablePortBinding(@Nullable String hostIp, String hostPort) {
    this.hostIp = hostIp;
    this.hostPort = hostPort;
  }

  /**
   * @return The value of the {@code hostIp} attribute
   */
  @JsonProperty("HostIp")
  @Override
  public @Nullable String hostIp() {
    return hostIp;
  }

  /**
   * @return The value of the {@code hostPort} attribute
   */
  @JsonProperty("HostPort")
  @Override
  public String hostPort() {
    return hostPort;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PortBinding#hostIp() hostIp} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for hostIp (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePortBinding withHostIp(@Nullable String value) {
    if (Objects.equals(this.hostIp, value)) return this;
    return new ImmutablePortBinding(value, this.hostPort);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PortBinding#hostPort() hostPort} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for hostPort
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePortBinding withHostPort(String value) {
    String newValue = Objects.requireNonNull(value, "hostPort");
    if (this.hostPort.equals(newValue)) return this;
    return new ImmutablePortBinding(this.hostIp, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutablePortBinding} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutablePortBinding
        && equalTo(0, (ImmutablePortBinding) another);
  }

  private boolean equalTo(int synthetic, ImmutablePortBinding another) {
    return Objects.equals(hostIp, another.hostIp)
        && hostPort.equals(another.hostPort);
  }

  /**
   * Computes a hash code from attributes: {@code hostIp}, {@code hostPort}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(hostIp);
    h += (h << 5) + hostPort.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code PortBinding} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "PortBinding{"
        + "hostIp=" + hostIp
        + ", hostPort=" + hostPort
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link PortBinding} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable PortBinding instance
   */
  public static ImmutablePortBinding copyOf(PortBinding instance) {
    if (instance instanceof ImmutablePortBinding) {
      return (ImmutablePortBinding) instance;
    }
    return ImmutablePortBinding.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutablePortBinding ImmutablePortBinding}.
   * <pre>
   * ImmutablePortBinding.builder()
   *    .hostIp(String | null) // nullable {@link PortBinding#hostIp() hostIp}
   *    .hostPort(String) // required {@link PortBinding#hostPort() hostPort}
   *    .build();
   * </pre>
   * @return A new ImmutablePortBinding builder
   */
  public static ImmutablePortBinding.Builder builder() {
    return new ImmutablePortBinding.Builder();
  }

  /**
   * Builds instances of type {@link ImmutablePortBinding ImmutablePortBinding}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  static final class Builder {
    private static final long INIT_BIT_HOST_PORT = 0x1L;
    private long initBits = 0x1L;

    private String hostIp;
    private String hostPort;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code PortBinding} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(PortBinding instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable String hostIpValue = instance.hostIp();
      if (hostIpValue != null) {
        hostIp(hostIpValue);
      }
      hostPort(instance.hostPort());
      return this;
    }

    /**
     * Initializes the value for the {@link PortBinding#hostIp() hostIp} attribute.
     * @param hostIp The value for hostIp (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("HostIp")
    public final Builder hostIp(@Nullable String hostIp) {
      this.hostIp = hostIp;
      return this;
    }

    /**
     * Initializes the value for the {@link PortBinding#hostPort() hostPort} attribute.
     * @param hostPort The value for hostPort 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("HostPort")
    public final Builder hostPort(String hostPort) {
      this.hostPort = Objects.requireNonNull(hostPort, "hostPort");
      initBits &= ~INIT_BIT_HOST_PORT;
      return this;
    }

    /**
     * Builds a new {@link ImmutablePortBinding ImmutablePortBinding}.
     * @return An immutable instance of PortBinding
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutablePortBinding build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutablePortBinding(hostIp, hostPort);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_HOST_PORT) != 0) attributes.add("hostPort");
      return "Cannot build PortBinding, some of required attributes are not set " + attributes;
    }
  }
}
