package org.mandas.docker.client.messages;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.mandas.docker.Nullable;

/**
 * Immutable implementation of {@link EndpointConfig}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableEndpointConfig.builder()}.
 */
@SuppressWarnings({"all"})
final class ImmutableEndpointConfig implements EndpointConfig {
  private final @Nullable EndpointConfig.EndpointIpamConfig ipamConfig;
  private final @Nullable List<String> links;
  private final @Nullable List<String> aliases;
  private final @Nullable String gateway;
  private final @Nullable String ipAddress;
  private final @Nullable Integer ipPrefixLen;
  private final @Nullable String ipv6Gateway;
  private final @Nullable String globalIPv6Address;
  private final @Nullable Integer globalIPv6PrefixLen;
  private final @Nullable String macAddress;

  private ImmutableEndpointConfig(
      @Nullable EndpointConfig.EndpointIpamConfig ipamConfig,
      @Nullable List<String> links,
      @Nullable List<String> aliases,
      @Nullable String gateway,
      @Nullable String ipAddress,
      @Nullable Integer ipPrefixLen,
      @Nullable String ipv6Gateway,
      @Nullable String globalIPv6Address,
      @Nullable Integer globalIPv6PrefixLen,
      @Nullable String macAddress) {
    this.ipamConfig = ipamConfig;
    this.links = links;
    this.aliases = aliases;
    this.gateway = gateway;
    this.ipAddress = ipAddress;
    this.ipPrefixLen = ipPrefixLen;
    this.ipv6Gateway = ipv6Gateway;
    this.globalIPv6Address = globalIPv6Address;
    this.globalIPv6PrefixLen = globalIPv6PrefixLen;
    this.macAddress = macAddress;
  }

  /**
   * @return The value of the {@code ipamConfig} attribute
   */
  @JsonProperty("IPAMConfig")
  @Override
  public @Nullable EndpointConfig.EndpointIpamConfig ipamConfig() {
    return ipamConfig;
  }

  /**
   * @return The value of the {@code links} attribute
   */
  @JsonProperty("Links")
  @Override
  public @Nullable List<String> links() {
    return links;
  }

  /**
   * @return The value of the {@code aliases} attribute
   */
  @JsonProperty("Aliases")
  @Override
  public @Nullable List<String> aliases() {
    return aliases;
  }

  /**
   * @return The value of the {@code gateway} attribute
   */
  @JsonProperty("Gateway")
  @Override
  public @Nullable String gateway() {
    return gateway;
  }

  /**
   * @return The value of the {@code ipAddress} attribute
   */
  @JsonProperty("IPAddress")
  @Override
  public @Nullable String ipAddress() {
    return ipAddress;
  }

  /**
   * @return The value of the {@code ipPrefixLen} attribute
   */
  @JsonProperty("IPPrefixLen")
  @Override
  public @Nullable Integer ipPrefixLen() {
    return ipPrefixLen;
  }

  /**
   * @return The value of the {@code ipv6Gateway} attribute
   */
  @JsonProperty("IPv6Gateway")
  @Override
  public @Nullable String ipv6Gateway() {
    return ipv6Gateway;
  }

  /**
   * @return The value of the {@code globalIPv6Address} attribute
   */
  @JsonProperty("GlobalIPv6Address")
  @Override
  public @Nullable String globalIPv6Address() {
    return globalIPv6Address;
  }

  /**
   * @return The value of the {@code globalIPv6PrefixLen} attribute
   */
  @JsonProperty("GlobalIPv6PrefixLen")
  @Override
  public @Nullable Integer globalIPv6PrefixLen() {
    return globalIPv6PrefixLen;
  }

  /**
   * @return The value of the {@code macAddress} attribute
   */
  @JsonProperty("MacAddress")
  @Override
  public @Nullable String macAddress() {
    return macAddress;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link EndpointConfig#ipamConfig() ipamConfig} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for ipamConfig (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableEndpointConfig withIpamConfig(@Nullable EndpointConfig.EndpointIpamConfig value) {
    if (this.ipamConfig == value) return this;
    return new ImmutableEndpointConfig(
        value,
        this.links,
        this.aliases,
        this.gateway,
        this.ipAddress,
        this.ipPrefixLen,
        this.ipv6Gateway,
        this.globalIPv6Address,
        this.globalIPv6PrefixLen,
        this.macAddress);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link EndpointConfig#links() links}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableEndpointConfig withLinks(@Nullable String... elements) {
    if (elements == null) {
      return new ImmutableEndpointConfig(
          this.ipamConfig,
          null,
          this.aliases,
          this.gateway,
          this.ipAddress,
          this.ipPrefixLen,
          this.ipv6Gateway,
          this.globalIPv6Address,
          this.globalIPv6PrefixLen,
          this.macAddress);
    }
    @Nullable List<String> newValue = Arrays.asList(elements) == null ? null : createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableEndpointConfig(
        this.ipamConfig,
        newValue,
        this.aliases,
        this.gateway,
        this.ipAddress,
        this.ipPrefixLen,
        this.ipv6Gateway,
        this.globalIPv6Address,
        this.globalIPv6PrefixLen,
        this.macAddress);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link EndpointConfig#links() links}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of links elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableEndpointConfig withLinks(@Nullable Iterable<String> elements) {
    if (this.links == elements) return this;
    @Nullable List<String> newValue = elements == null ? null : createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableEndpointConfig(
        this.ipamConfig,
        newValue,
        this.aliases,
        this.gateway,
        this.ipAddress,
        this.ipPrefixLen,
        this.ipv6Gateway,
        this.globalIPv6Address,
        this.globalIPv6PrefixLen,
        this.macAddress);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link EndpointConfig#aliases() aliases}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableEndpointConfig withAliases(@Nullable String... elements) {
    if (elements == null) {
      return new ImmutableEndpointConfig(
          this.ipamConfig,
          this.links,
          null,
          this.gateway,
          this.ipAddress,
          this.ipPrefixLen,
          this.ipv6Gateway,
          this.globalIPv6Address,
          this.globalIPv6PrefixLen,
          this.macAddress);
    }
    @Nullable List<String> newValue = Arrays.asList(elements) == null ? null : createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableEndpointConfig(
        this.ipamConfig,
        this.links,
        newValue,
        this.gateway,
        this.ipAddress,
        this.ipPrefixLen,
        this.ipv6Gateway,
        this.globalIPv6Address,
        this.globalIPv6PrefixLen,
        this.macAddress);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link EndpointConfig#aliases() aliases}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of aliases elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableEndpointConfig withAliases(@Nullable Iterable<String> elements) {
    if (this.aliases == elements) return this;
    @Nullable List<String> newValue = elements == null ? null : createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableEndpointConfig(
        this.ipamConfig,
        this.links,
        newValue,
        this.gateway,
        this.ipAddress,
        this.ipPrefixLen,
        this.ipv6Gateway,
        this.globalIPv6Address,
        this.globalIPv6PrefixLen,
        this.macAddress);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link EndpointConfig#gateway() gateway} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for gateway (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableEndpointConfig withGateway(@Nullable String value) {
    if (Objects.equals(this.gateway, value)) return this;
    return new ImmutableEndpointConfig(
        this.ipamConfig,
        this.links,
        this.aliases,
        value,
        this.ipAddress,
        this.ipPrefixLen,
        this.ipv6Gateway,
        this.globalIPv6Address,
        this.globalIPv6PrefixLen,
        this.macAddress);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link EndpointConfig#ipAddress() ipAddress} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for ipAddress (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableEndpointConfig withIpAddress(@Nullable String value) {
    if (Objects.equals(this.ipAddress, value)) return this;
    return new ImmutableEndpointConfig(
        this.ipamConfig,
        this.links,
        this.aliases,
        this.gateway,
        value,
        this.ipPrefixLen,
        this.ipv6Gateway,
        this.globalIPv6Address,
        this.globalIPv6PrefixLen,
        this.macAddress);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link EndpointConfig#ipPrefixLen() ipPrefixLen} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for ipPrefixLen (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableEndpointConfig withIpPrefixLen(@Nullable Integer value) {
    if (Objects.equals(this.ipPrefixLen, value)) return this;
    return new ImmutableEndpointConfig(
        this.ipamConfig,
        this.links,
        this.aliases,
        this.gateway,
        this.ipAddress,
        value,
        this.ipv6Gateway,
        this.globalIPv6Address,
        this.globalIPv6PrefixLen,
        this.macAddress);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link EndpointConfig#ipv6Gateway() ipv6Gateway} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for ipv6Gateway (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableEndpointConfig withIpv6Gateway(@Nullable String value) {
    if (Objects.equals(this.ipv6Gateway, value)) return this;
    return new ImmutableEndpointConfig(
        this.ipamConfig,
        this.links,
        this.aliases,
        this.gateway,
        this.ipAddress,
        this.ipPrefixLen,
        value,
        this.globalIPv6Address,
        this.globalIPv6PrefixLen,
        this.macAddress);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link EndpointConfig#globalIPv6Address() globalIPv6Address} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for globalIPv6Address (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableEndpointConfig withGlobalIPv6Address(@Nullable String value) {
    if (Objects.equals(this.globalIPv6Address, value)) return this;
    return new ImmutableEndpointConfig(
        this.ipamConfig,
        this.links,
        this.aliases,
        this.gateway,
        this.ipAddress,
        this.ipPrefixLen,
        this.ipv6Gateway,
        value,
        this.globalIPv6PrefixLen,
        this.macAddress);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link EndpointConfig#globalIPv6PrefixLen() globalIPv6PrefixLen} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for globalIPv6PrefixLen (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableEndpointConfig withGlobalIPv6PrefixLen(@Nullable Integer value) {
    if (Objects.equals(this.globalIPv6PrefixLen, value)) return this;
    return new ImmutableEndpointConfig(
        this.ipamConfig,
        this.links,
        this.aliases,
        this.gateway,
        this.ipAddress,
        this.ipPrefixLen,
        this.ipv6Gateway,
        this.globalIPv6Address,
        value,
        this.macAddress);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link EndpointConfig#macAddress() macAddress} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for macAddress (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableEndpointConfig withMacAddress(@Nullable String value) {
    if (Objects.equals(this.macAddress, value)) return this;
    return new ImmutableEndpointConfig(
        this.ipamConfig,
        this.links,
        this.aliases,
        this.gateway,
        this.ipAddress,
        this.ipPrefixLen,
        this.ipv6Gateway,
        this.globalIPv6Address,
        this.globalIPv6PrefixLen,
        value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableEndpointConfig} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableEndpointConfig
        && equalTo(0, (ImmutableEndpointConfig) another);
  }

  private boolean equalTo(int synthetic, ImmutableEndpointConfig another) {
    return Objects.equals(ipamConfig, another.ipamConfig)
        && Objects.equals(links, another.links)
        && Objects.equals(aliases, another.aliases)
        && Objects.equals(gateway, another.gateway)
        && Objects.equals(ipAddress, another.ipAddress)
        && Objects.equals(ipPrefixLen, another.ipPrefixLen)
        && Objects.equals(ipv6Gateway, another.ipv6Gateway)
        && Objects.equals(globalIPv6Address, another.globalIPv6Address)
        && Objects.equals(globalIPv6PrefixLen, another.globalIPv6PrefixLen)
        && Objects.equals(macAddress, another.macAddress);
  }

  /**
   * Computes a hash code from attributes: {@code ipamConfig}, {@code links}, {@code aliases}, {@code gateway}, {@code ipAddress}, {@code ipPrefixLen}, {@code ipv6Gateway}, {@code globalIPv6Address}, {@code globalIPv6PrefixLen}, {@code macAddress}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(ipamConfig);
    h += (h << 5) + Objects.hashCode(links);
    h += (h << 5) + Objects.hashCode(aliases);
    h += (h << 5) + Objects.hashCode(gateway);
    h += (h << 5) + Objects.hashCode(ipAddress);
    h += (h << 5) + Objects.hashCode(ipPrefixLen);
    h += (h << 5) + Objects.hashCode(ipv6Gateway);
    h += (h << 5) + Objects.hashCode(globalIPv6Address);
    h += (h << 5) + Objects.hashCode(globalIPv6PrefixLen);
    h += (h << 5) + Objects.hashCode(macAddress);
    return h;
  }

  /**
   * Prints the immutable value {@code EndpointConfig} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "EndpointConfig{"
        + "ipamConfig=" + ipamConfig
        + ", links=" + links
        + ", aliases=" + aliases
        + ", gateway=" + gateway
        + ", ipAddress=" + ipAddress
        + ", ipPrefixLen=" + ipPrefixLen
        + ", ipv6Gateway=" + ipv6Gateway
        + ", globalIPv6Address=" + globalIPv6Address
        + ", globalIPv6PrefixLen=" + globalIPv6PrefixLen
        + ", macAddress=" + macAddress
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link EndpointConfig} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable EndpointConfig instance
   */
  public static ImmutableEndpointConfig copyOf(EndpointConfig instance) {
    if (instance instanceof ImmutableEndpointConfig) {
      return (ImmutableEndpointConfig) instance;
    }
    return ImmutableEndpointConfig.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableEndpointConfig ImmutableEndpointConfig}.
   * <pre>
   * ImmutableEndpointConfig.builder()
   *    .ipamConfig(org.mandas.docker.client.messages.EndpointConfig.EndpointIpamConfig | null) // nullable {@link EndpointConfig#ipamConfig() ipamConfig}
   *    .links(List&amp;lt;String&amp;gt; | null) // nullable {@link EndpointConfig#links() links}
   *    .aliases(List&amp;lt;String&amp;gt; | null) // nullable {@link EndpointConfig#aliases() aliases}
   *    .gateway(String | null) // nullable {@link EndpointConfig#gateway() gateway}
   *    .ipAddress(String | null) // nullable {@link EndpointConfig#ipAddress() ipAddress}
   *    .ipPrefixLen(Integer | null) // nullable {@link EndpointConfig#ipPrefixLen() ipPrefixLen}
   *    .ipv6Gateway(String | null) // nullable {@link EndpointConfig#ipv6Gateway() ipv6Gateway}
   *    .globalIPv6Address(String | null) // nullable {@link EndpointConfig#globalIPv6Address() globalIPv6Address}
   *    .globalIPv6PrefixLen(Integer | null) // nullable {@link EndpointConfig#globalIPv6PrefixLen() globalIPv6PrefixLen}
   *    .macAddress(String | null) // nullable {@link EndpointConfig#macAddress() macAddress}
   *    .build();
   * </pre>
   * @return A new ImmutableEndpointConfig builder
   */
  public static ImmutableEndpointConfig.Builder builder() {
    return new ImmutableEndpointConfig.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableEndpointConfig ImmutableEndpointConfig}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  static final class Builder implements EndpointConfig.Builder {
    private EndpointConfig.EndpointIpamConfig ipamConfig;
    private List<String> links = null;
    private List<String> aliases = null;
    private String gateway;
    private String ipAddress;
    private Integer ipPrefixLen;
    private String ipv6Gateway;
    private String globalIPv6Address;
    private Integer globalIPv6PrefixLen;
    private String macAddress;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code EndpointConfig} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(EndpointConfig instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable EndpointConfig.EndpointIpamConfig ipamConfigValue = instance.ipamConfig();
      if (ipamConfigValue != null) {
        ipamConfig(ipamConfigValue);
      }
      @Nullable List<String> linksValue = instance.links();
      if (linksValue != null) {
        addAllLinks(linksValue);
      }
      @Nullable List<String> aliasesValue = instance.aliases();
      if (aliasesValue != null) {
        addAllAliases(aliasesValue);
      }
      @Nullable String gatewayValue = instance.gateway();
      if (gatewayValue != null) {
        gateway(gatewayValue);
      }
      @Nullable String ipAddressValue = instance.ipAddress();
      if (ipAddressValue != null) {
        ipAddress(ipAddressValue);
      }
      @Nullable Integer ipPrefixLenValue = instance.ipPrefixLen();
      if (ipPrefixLenValue != null) {
        ipPrefixLen(ipPrefixLenValue);
      }
      @Nullable String ipv6GatewayValue = instance.ipv6Gateway();
      if (ipv6GatewayValue != null) {
        ipv6Gateway(ipv6GatewayValue);
      }
      @Nullable String globalIPv6AddressValue = instance.globalIPv6Address();
      if (globalIPv6AddressValue != null) {
        globalIPv6Address(globalIPv6AddressValue);
      }
      @Nullable Integer globalIPv6PrefixLenValue = instance.globalIPv6PrefixLen();
      if (globalIPv6PrefixLenValue != null) {
        globalIPv6PrefixLen(globalIPv6PrefixLenValue);
      }
      @Nullable String macAddressValue = instance.macAddress();
      if (macAddressValue != null) {
        macAddress(macAddressValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link EndpointConfig#ipamConfig() ipamConfig} attribute.
     * @param ipamConfig The value for ipamConfig (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("IPAMConfig")
    public final Builder ipamConfig(@Nullable EndpointConfig.EndpointIpamConfig ipamConfig) {
      this.ipamConfig = ipamConfig;
      return this;
    }

    /**
     * Adds one element to {@link EndpointConfig#links() links} list.
     * @param element A links element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder link(String element) {
      if (this.links == null) {
        this.links = new ArrayList<String>();
      }
      this.links.add(Objects.requireNonNull(element, "links element"));
      return this;
    }

    /**
     * Adds elements to {@link EndpointConfig#links() links} list.
     * @param elements An array of links elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder links(String... elements) {
      if (this.links == null) {
        this.links = new ArrayList<String>();
      }
      for (String element : elements) {
        this.links.add(Objects.requireNonNull(element, "links element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link EndpointConfig#links() links} list.
     * @param elements An iterable of links elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("Links")
    public final Builder links(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.links = null;
        return this;
      }
      this.links = new ArrayList<String>();
      return addAllLinks(elements);
    }

    /**
     * Adds elements to {@link EndpointConfig#links() links} list.
     * @param elements An iterable of links elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllLinks(Iterable<String> elements) {
      Objects.requireNonNull(elements, "links element");
      if (this.links == null) {
        this.links = new ArrayList<String>();
      }
      for (String element : elements) {
        this.links.add(Objects.requireNonNull(element, "links element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link EndpointConfig#aliases() aliases} list.
     * @param element A aliases element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder aliase(String element) {
      if (this.aliases == null) {
        this.aliases = new ArrayList<String>();
      }
      this.aliases.add(Objects.requireNonNull(element, "aliases element"));
      return this;
    }

    /**
     * Adds elements to {@link EndpointConfig#aliases() aliases} list.
     * @param elements An array of aliases elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder aliases(String... elements) {
      if (this.aliases == null) {
        this.aliases = new ArrayList<String>();
      }
      for (String element : elements) {
        this.aliases.add(Objects.requireNonNull(element, "aliases element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link EndpointConfig#aliases() aliases} list.
     * @param elements An iterable of aliases elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("Aliases")
    public final Builder aliases(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.aliases = null;
        return this;
      }
      this.aliases = new ArrayList<String>();
      return addAllAliases(elements);
    }

    /**
     * Adds elements to {@link EndpointConfig#aliases() aliases} list.
     * @param elements An iterable of aliases elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllAliases(Iterable<String> elements) {
      Objects.requireNonNull(elements, "aliases element");
      if (this.aliases == null) {
        this.aliases = new ArrayList<String>();
      }
      for (String element : elements) {
        this.aliases.add(Objects.requireNonNull(element, "aliases element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link EndpointConfig#gateway() gateway} attribute.
     * @param gateway The value for gateway (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("Gateway")
    public final Builder gateway(@Nullable String gateway) {
      this.gateway = gateway;
      return this;
    }

    /**
     * Initializes the value for the {@link EndpointConfig#ipAddress() ipAddress} attribute.
     * @param ipAddress The value for ipAddress (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("IPAddress")
    public final Builder ipAddress(@Nullable String ipAddress) {
      this.ipAddress = ipAddress;
      return this;
    }

    /**
     * Initializes the value for the {@link EndpointConfig#ipPrefixLen() ipPrefixLen} attribute.
     * @param ipPrefixLen The value for ipPrefixLen (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("IPPrefixLen")
    public final Builder ipPrefixLen(@Nullable Integer ipPrefixLen) {
      this.ipPrefixLen = ipPrefixLen;
      return this;
    }

    /**
     * Initializes the value for the {@link EndpointConfig#ipv6Gateway() ipv6Gateway} attribute.
     * @param ipv6Gateway The value for ipv6Gateway (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("IPv6Gateway")
    public final Builder ipv6Gateway(@Nullable String ipv6Gateway) {
      this.ipv6Gateway = ipv6Gateway;
      return this;
    }

    /**
     * Initializes the value for the {@link EndpointConfig#globalIPv6Address() globalIPv6Address} attribute.
     * @param globalIPv6Address The value for globalIPv6Address (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("GlobalIPv6Address")
    public final Builder globalIPv6Address(@Nullable String globalIPv6Address) {
      this.globalIPv6Address = globalIPv6Address;
      return this;
    }

    /**
     * Initializes the value for the {@link EndpointConfig#globalIPv6PrefixLen() globalIPv6PrefixLen} attribute.
     * @param globalIPv6PrefixLen The value for globalIPv6PrefixLen (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("GlobalIPv6PrefixLen")
    public final Builder globalIPv6PrefixLen(@Nullable Integer globalIPv6PrefixLen) {
      this.globalIPv6PrefixLen = globalIPv6PrefixLen;
      return this;
    }

    /**
     * Initializes the value for the {@link EndpointConfig#macAddress() macAddress} attribute.
     * @param macAddress The value for macAddress (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("MacAddress")
    public final Builder macAddress(@Nullable String macAddress) {
      this.macAddress = macAddress;
      return this;
    }

    /**
     * Builds a new {@link ImmutableEndpointConfig ImmutableEndpointConfig}.
     * @return An immutable instance of EndpointConfig
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableEndpointConfig build() {
      return new ImmutableEndpointConfig(
          ipamConfig,
          links == null ? null : createUnmodifiableList(true, links),
          aliases == null ? null : createUnmodifiableList(true, aliases),
          gateway,
          ipAddress,
          ipPrefixLen,
          ipv6Gateway,
          globalIPv6Address,
          globalIPv6PrefixLen,
          macAddress);
    }
  }

  /**
   * Immutable implementation of {@link EndpointConfig.EndpointIpamConfig}.
   * <p>
   * Use the builder to create immutable instances:
   * {@code ImmutableEndpointConfig.EndpointIpamConfig.builder()}.
   */
  static final class EndpointIpamConfig
      implements EndpointConfig.EndpointIpamConfig {
    private final @Nullable String ipv4Address;
    private final @Nullable String ipv6Address;
    private final @Nullable List<String> linkLocalIPs;

    private EndpointIpamConfig(
        @Nullable String ipv4Address,
        @Nullable String ipv6Address,
        @Nullable List<String> linkLocalIPs) {
      this.ipv4Address = ipv4Address;
      this.ipv6Address = ipv6Address;
      this.linkLocalIPs = linkLocalIPs;
    }

    /**
     * @return The value of the {@code ipv4Address} attribute
     */
    @JsonProperty("IPv4Address")
    @Override
    public @Nullable String ipv4Address() {
      return ipv4Address;
    }

    /**
     * @return The value of the {@code ipv6Address} attribute
     */
    @JsonProperty("IPv6Address")
    @Override
    public @Nullable String ipv6Address() {
      return ipv6Address;
    }

    /**
     * @return The value of the {@code linkLocalIPs} attribute
     */
    @JsonProperty("LinkLocalIPs")
    @Override
    public @Nullable List<String> linkLocalIPs() {
      return linkLocalIPs;
    }

    /**
     * Copy the current immutable object by setting a value for the {@link EndpointConfig.EndpointIpamConfig#ipv4Address() ipv4Address} attribute.
     * An equals check used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for ipv4Address (can be {@code null})
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableEndpointConfig.EndpointIpamConfig withIpv4Address(@Nullable String value) {
      if (Objects.equals(this.ipv4Address, value)) return this;
      return new ImmutableEndpointConfig.EndpointIpamConfig(value, this.ipv6Address, this.linkLocalIPs);
    }

    /**
     * Copy the current immutable object by setting a value for the {@link EndpointConfig.EndpointIpamConfig#ipv6Address() ipv6Address} attribute.
     * An equals check used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for ipv6Address (can be {@code null})
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableEndpointConfig.EndpointIpamConfig withIpv6Address(@Nullable String value) {
      if (Objects.equals(this.ipv6Address, value)) return this;
      return new ImmutableEndpointConfig.EndpointIpamConfig(this.ipv4Address, value, this.linkLocalIPs);
    }

    /**
     * Copy the current immutable object with elements that replace the content of {@link EndpointConfig.EndpointIpamConfig#linkLocalIPs() linkLocalIPs}.
     * @param elements The elements to set
     * @return A modified copy of {@code this} object
     */
    public final ImmutableEndpointConfig.EndpointIpamConfig withLinkLocalIPs(@Nullable String... elements) {
      if (elements == null) {
        return new ImmutableEndpointConfig.EndpointIpamConfig(this.ipv4Address, this.ipv6Address, null);
      }
      @Nullable List<String> newValue = Arrays.asList(elements) == null ? null : createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
      return new ImmutableEndpointConfig.EndpointIpamConfig(this.ipv4Address, this.ipv6Address, newValue);
    }

    /**
     * Copy the current immutable object with elements that replace the content of {@link EndpointConfig.EndpointIpamConfig#linkLocalIPs() linkLocalIPs}.
     * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param elements An iterable of linkLocalIPs elements to set
     * @return A modified copy of {@code this} object
     */
    public final ImmutableEndpointConfig.EndpointIpamConfig withLinkLocalIPs(@Nullable Iterable<String> elements) {
      if (this.linkLocalIPs == elements) return this;
      @Nullable List<String> newValue = elements == null ? null : createUnmodifiableList(false, createSafeList(elements, true, false));
      return new ImmutableEndpointConfig.EndpointIpamConfig(this.ipv4Address, this.ipv6Address, newValue);
    }

    /**
     * This instance is equal to all instances of {@code EndpointIpamConfig} that have equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(Object another) {
      if (this == another) return true;
      return another instanceof ImmutableEndpointConfig.EndpointIpamConfig
          && equalTo(0, (ImmutableEndpointConfig.EndpointIpamConfig) another);
    }

    private boolean equalTo(int synthetic, ImmutableEndpointConfig.EndpointIpamConfig another) {
      return Objects.equals(ipv4Address, another.ipv4Address)
          && Objects.equals(ipv6Address, another.ipv6Address)
          && Objects.equals(linkLocalIPs, another.linkLocalIPs);
    }

    /**
     * Computes a hash code from attributes: {@code ipv4Address}, {@code ipv6Address}, {@code linkLocalIPs}.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      int h = 5381;
      h += (h << 5) + Objects.hashCode(ipv4Address);
      h += (h << 5) + Objects.hashCode(ipv6Address);
      h += (h << 5) + Objects.hashCode(linkLocalIPs);
      return h;
    }

    /**
     * Prints the immutable value {@code EndpointIpamConfig} with attribute values.
     * @return A string representation of the value
     */
    @Override
    public String toString() {
      return "EndpointIpamConfig{"
          + "ipv4Address=" + ipv4Address
          + ", ipv6Address=" + ipv6Address
          + ", linkLocalIPs=" + linkLocalIPs
          + "}";
    }

    /**
     * Creates an immutable copy of a {@link EndpointConfig.EndpointIpamConfig} value.
     * Uses accessors to get values to initialize the new immutable instance.
     * If an instance is already immutable, it is returned as is.
     * @param instance The instance to copy
     * @return A copied immutable EndpointIpamConfig instance
     */
    public static ImmutableEndpointConfig.EndpointIpamConfig copyOf(EndpointConfig.EndpointIpamConfig instance) {
      if (instance instanceof ImmutableEndpointConfig.EndpointIpamConfig) {
        return (ImmutableEndpointConfig.EndpointIpamConfig) instance;
      }
      return ImmutableEndpointConfig.EndpointIpamConfig.builder()
          .from(instance)
          .build();
    }

    /**
     * Creates a builder for {@link ImmutableEndpointConfig.EndpointIpamConfig EndpointIpamConfig}.
     * <pre>
     * ImmutableEndpointConfig.EndpointIpamConfig.builder()
     *    .ipv4Address(String | null) // nullable {@link EndpointConfig.EndpointIpamConfig#ipv4Address() ipv4Address}
     *    .ipv6Address(String | null) // nullable {@link EndpointConfig.EndpointIpamConfig#ipv6Address() ipv6Address}
     *    .linkLocalIPs(List&amp;lt;String&amp;gt; | null) // nullable {@link EndpointConfig.EndpointIpamConfig#linkLocalIPs() linkLocalIPs}
     *    .build();
     * </pre>
     * @return A new EndpointIpamConfig builder
     */
    public static ImmutableEndpointConfig.EndpointIpamConfig.Builder builder() {
      return new ImmutableEndpointConfig.EndpointIpamConfig.Builder();
    }

    /**
     * Builds instances of type {@link ImmutableEndpointConfig.EndpointIpamConfig EndpointIpamConfig}.
     * Initialize attributes and then invoke the {@link #build()} method to create an
     * immutable instance.
     * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
     * but instead used immediately to create instances.</em>
     */
    static final class Builder implements EndpointConfig.EndpointIpamConfig.Builder {
      private String ipv4Address;
      private String ipv6Address;
      private List<String> linkLocalIPs = null;

      private Builder() {
      }

      /**
       * Fill a builder with attribute values from the provided {@code EndpointIpamConfig} instance.
       * Regular attribute values will be replaced with those from the given instance.
       * Absent optional values will not replace present values.
       * Collection elements and entries will be added, not replaced.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder from(EndpointConfig.EndpointIpamConfig instance) {
        Objects.requireNonNull(instance, "instance");
        @Nullable String ipv4AddressValue = instance.ipv4Address();
        if (ipv4AddressValue != null) {
          ipv4Address(ipv4AddressValue);
        }
        @Nullable String ipv6AddressValue = instance.ipv6Address();
        if (ipv6AddressValue != null) {
          ipv6Address(ipv6AddressValue);
        }
        @Nullable List<String> linkLocalIPsValue = instance.linkLocalIPs();
        if (linkLocalIPsValue != null) {
          addAllLinkLocalIPs(linkLocalIPsValue);
        }
        return this;
      }

      /**
       * Initializes the value for the {@link EndpointConfig.EndpointIpamConfig#ipv4Address() ipv4Address} attribute.
       * @param ipv4Address The value for ipv4Address (can be {@code null})
       * @return {@code this} builder for use in a chained invocation
       */
      @JsonProperty("IPv4Address")
      public final Builder ipv4Address(@Nullable String ipv4Address) {
        this.ipv4Address = ipv4Address;
        return this;
      }

      /**
       * Initializes the value for the {@link EndpointConfig.EndpointIpamConfig#ipv6Address() ipv6Address} attribute.
       * @param ipv6Address The value for ipv6Address (can be {@code null})
       * @return {@code this} builder for use in a chained invocation
       */
      @JsonProperty("IPv6Address")
      public final Builder ipv6Address(@Nullable String ipv6Address) {
        this.ipv6Address = ipv6Address;
        return this;
      }

      /**
       * Adds one element to {@link EndpointConfig.EndpointIpamConfig#linkLocalIPs() linkLocalIPs} list.
       * @param element A linkLocalIPs element
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder linkLocalIP(String element) {
        if (this.linkLocalIPs == null) {
          this.linkLocalIPs = new ArrayList<String>();
        }
        this.linkLocalIPs.add(Objects.requireNonNull(element, "linkLocalIPs element"));
        return this;
      }

      /**
       * Adds elements to {@link EndpointConfig.EndpointIpamConfig#linkLocalIPs() linkLocalIPs} list.
       * @param elements An array of linkLocalIPs elements
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder linkLocalIPs(String... elements) {
        if (this.linkLocalIPs == null) {
          this.linkLocalIPs = new ArrayList<String>();
        }
        for (String element : elements) {
          this.linkLocalIPs.add(Objects.requireNonNull(element, "linkLocalIPs element"));
        }
        return this;
      }


      /**
       * Sets or replaces all elements for {@link EndpointConfig.EndpointIpamConfig#linkLocalIPs() linkLocalIPs} list.
       * @param elements An iterable of linkLocalIPs elements
       * @return {@code this} builder for use in a chained invocation
       */
      @JsonProperty("LinkLocalIPs")
      public final Builder linkLocalIPs(@Nullable Iterable<String> elements) {
        if (elements == null) {
          this.linkLocalIPs = null;
          return this;
        }
        this.linkLocalIPs = new ArrayList<String>();
        return addAllLinkLocalIPs(elements);
      }

      /**
       * Adds elements to {@link EndpointConfig.EndpointIpamConfig#linkLocalIPs() linkLocalIPs} list.
       * @param elements An iterable of linkLocalIPs elements
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder addAllLinkLocalIPs(Iterable<String> elements) {
        Objects.requireNonNull(elements, "linkLocalIPs element");
        if (this.linkLocalIPs == null) {
          this.linkLocalIPs = new ArrayList<String>();
        }
        for (String element : elements) {
          this.linkLocalIPs.add(Objects.requireNonNull(element, "linkLocalIPs element"));
        }
        return this;
      }

      /**
       * Builds a new {@link ImmutableEndpointConfig.EndpointIpamConfig EndpointIpamConfig}.
       * @return An immutable instance of EndpointIpamConfig
       * @throws java.lang.IllegalStateException if any required attributes are missing
       */
      public ImmutableEndpointConfig.EndpointIpamConfig build() {
        return new ImmutableEndpointConfig.EndpointIpamConfig(
            ipv4Address,
            ipv6Address,
            linkLocalIPs == null ? null : createUnmodifiableList(true, linkLocalIPs));
      }
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
