/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages.swarm;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Date;
import java.util.Objects;
import org.mandas.docker.client.messages.swarm.JobStatus;
import org.mandas.docker.client.messages.swarm.Version;

final class ImmutableJobStatus
implements JobStatus {
    private final Version jobIteration;
    private final Date lastExecution;

    private ImmutableJobStatus(Version jobIteration, Date lastExecution) {
        this.jobIteration = jobIteration;
        this.lastExecution = lastExecution;
    }

    @Override
    @JsonProperty(value="JobIteration")
    public Version jobIteration() {
        return this.jobIteration;
    }

    @Override
    @JsonProperty(value="LastExecution")
    public Date lastExecution() {
        return this.lastExecution;
    }

    public final ImmutableJobStatus withJobIteration(Version value) {
        if (this.jobIteration == value) {
            return this;
        }
        Version newValue = Objects.requireNonNull(value, "jobIteration");
        return new ImmutableJobStatus(newValue, this.lastExecution);
    }

    public final ImmutableJobStatus withLastExecution(Date value) {
        if (this.lastExecution == value) {
            return this;
        }
        Date newValue = Objects.requireNonNull(value, "lastExecution");
        return new ImmutableJobStatus(this.jobIteration, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableJobStatus && this.equalTo(0, (ImmutableJobStatus)another);
    }

    private boolean equalTo(int synthetic, ImmutableJobStatus another) {
        return this.jobIteration.equals(another.jobIteration) && this.lastExecution.equals(another.lastExecution);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.jobIteration.hashCode();
        h += (h << 5) + this.lastExecution.hashCode();
        return h;
    }

    public String toString() {
        return "JobStatus{jobIteration=" + this.jobIteration + ", lastExecution=" + this.lastExecution + "}";
    }

    public static ImmutableJobStatus copyOf(JobStatus instance) {
        if (instance instanceof ImmutableJobStatus) {
            return (ImmutableJobStatus)instance;
        }
        return ImmutableJobStatus.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    static final class Builder
    implements JobStatus.Builder {
        private static final long INIT_BIT_JOB_ITERATION = 1L;
        private static final long INIT_BIT_LAST_EXECUTION = 2L;
        private long initBits = 3L;
        private Version jobIteration;
        private Date lastExecution;

        private Builder() {
        }

        public final Builder from(JobStatus instance) {
            Objects.requireNonNull(instance, "instance");
            this.jobIteration(instance.jobIteration());
            this.lastExecution(instance.lastExecution());
            return this;
        }

        @Override
        @JsonProperty(value="JobIteration")
        public final Builder jobIteration(Version jobIteration) {
            this.jobIteration = Objects.requireNonNull(jobIteration, "jobIteration");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @Override
        @JsonProperty(value="LastExecution")
        public final Builder lastExecution(Date lastExecution) {
            this.lastExecution = Objects.requireNonNull(lastExecution, "lastExecution");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @Override
        public ImmutableJobStatus build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableJobStatus(this.jobIteration, this.lastExecution);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("jobIteration");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("lastExecution");
            }
            return "Cannot build JobStatus, some of required attributes are not set " + attributes;
        }
    }
}

