/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages.swarm;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.mandas.docker.client.messages.swarm.ExternalCa;

final class ImmutableExternalCa
implements ExternalCa {
    private final String protocol;
    private final String url;
    private final Map<String, String> options;

    private ImmutableExternalCa(String protocol, String url, Map<String, String> options) {
        this.protocol = protocol;
        this.url = url;
        this.options = options;
    }

    @Override
    @JsonProperty(value="Protocol")
    public String protocol() {
        return this.protocol;
    }

    @Override
    @JsonProperty(value="URL")
    public String url() {
        return this.url;
    }

    @Override
    @JsonProperty(value="Options")
    public Map<String, String> options() {
        return this.options;
    }

    public final ImmutableExternalCa withProtocol(String value) {
        String newValue = Objects.requireNonNull(value, "protocol");
        if (this.protocol.equals(newValue)) {
            return this;
        }
        return new ImmutableExternalCa(newValue, this.url, this.options);
    }

    public final ImmutableExternalCa withUrl(String value) {
        String newValue = Objects.requireNonNull(value, "url");
        if (this.url.equals(newValue)) {
            return this;
        }
        return new ImmutableExternalCa(this.protocol, newValue, this.options);
    }

    public final ImmutableExternalCa withOptions(Map<String, ? extends String> entries) {
        if (this.options == entries) {
            return this;
        }
        Map<String, String> newValue = ImmutableExternalCa.createUnmodifiableMap(true, false, entries);
        return new ImmutableExternalCa(this.protocol, this.url, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableExternalCa && this.equalTo(0, (ImmutableExternalCa)another);
    }

    private boolean equalTo(int synthetic, ImmutableExternalCa another) {
        return this.protocol.equals(another.protocol) && this.url.equals(another.url) && this.options.equals(another.options);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.protocol.hashCode();
        h += (h << 5) + this.url.hashCode();
        h += (h << 5) + this.options.hashCode();
        return h;
    }

    public String toString() {
        return "ExternalCa{protocol=" + this.protocol + ", url=" + this.url + ", options=" + this.options + "}";
    }

    public static ImmutableExternalCa copyOf(ExternalCa instance) {
        if (instance instanceof ImmutableExternalCa) {
            return (ImmutableExternalCa)instance;
        }
        return ImmutableExternalCa.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    if (v == null) {
                        Objects.requireNonNull(v, "value for key: " + k);
                    }
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    if (v == null) {
                        Objects.requireNonNull(v, "value for key: " + k);
                    }
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    static final class Builder {
        private static final long INIT_BIT_PROTOCOL = 1L;
        private static final long INIT_BIT_URL = 2L;
        private long initBits = 3L;
        private String protocol;
        private String url;
        private Map<String, String> options = new LinkedHashMap<String, String>();

        private Builder() {
        }

        public final Builder from(ExternalCa instance) {
            Objects.requireNonNull(instance, "instance");
            this.protocol(instance.protocol());
            this.url(instance.url());
            this.putAllOptions(instance.options());
            return this;
        }

        @JsonProperty(value="Protocol")
        public final Builder protocol(String protocol) {
            this.protocol = Objects.requireNonNull(protocol, "protocol");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="URL")
        public final Builder url(String url) {
            this.url = Objects.requireNonNull(url, "url");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder addOption(String key, String value) {
            this.options.put(Objects.requireNonNull(key, "options key"), value == null ? Objects.requireNonNull(value, "options value for key: " + key) : value);
            return this;
        }

        public final Builder addOption(Map.Entry<String, ? extends String> entry) {
            String v;
            String k = entry.getKey();
            this.options.put(Objects.requireNonNull(k, "options key"), (v = entry.getValue()) == null ? Objects.requireNonNull(v, "options value for key: " + k) : v);
            return this;
        }

        @JsonProperty(value="Options")
        public final Builder options(Map<String, ? extends String> entries) {
            this.options.clear();
            return this.putAllOptions(entries);
        }

        public final Builder putAllOptions(Map<String, ? extends String> entries) {
            for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
                String v;
                String k = e.getKey();
                this.options.put(Objects.requireNonNull(k, "options key"), (v = e.getValue()) == null ? Objects.requireNonNull(v, "options value for key: " + k) : v);
            }
            return this;
        }

        public ImmutableExternalCa build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableExternalCa(this.protocol, this.url, ImmutableExternalCa.createUnmodifiableMap(false, false, this.options));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("protocol");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("url");
            }
            return "Cannot build ExternalCa, some of required attributes are not set " + attributes;
        }
    }
}

