/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages.swarm;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.mandas.docker.Nullable;
import org.mandas.docker.client.messages.ContainerConfig;
import org.mandas.docker.client.messages.mount.Mount;
import org.mandas.docker.client.messages.swarm.ConfigBind;
import org.mandas.docker.client.messages.swarm.ContainerSpec;
import org.mandas.docker.client.messages.swarm.DnsConfig;
import org.mandas.docker.client.messages.swarm.SecretBind;

final class ImmutableContainerSpec
implements ContainerSpec {
    private final String image;
    @Nullable
    private final String hostname;
    private final Map<String, String> labels;
    @Nullable
    private final List<String> command;
    @Nullable
    private final List<String> args;
    @Nullable
    private final List<String> env;
    @Nullable
    private final String dir;
    @Nullable
    private final String user;
    @Nullable
    private final List<String> groups;
    @Nullable
    private final Boolean tty;
    @Nullable
    private final List<Mount> mounts;
    @Nullable
    private final Long stopGracePeriod;
    @Nullable
    private final ContainerConfig.Healthcheck healthcheck;
    @Nullable
    private final List<String> hosts;
    @Nullable
    private final List<SecretBind> secrets;
    @Nullable
    private final List<ConfigBind> configs;
    @Nullable
    private final DnsConfig dnsConfig;
    private final Map<String, String> sysctls;
    @Nullable
    private final Boolean init;

    private ImmutableContainerSpec(String image, @Nullable String hostname, Map<String, String> labels, @Nullable List<String> command, @Nullable List<String> args, @Nullable List<String> env, @Nullable String dir, @Nullable String user, @Nullable List<String> groups, @Nullable Boolean tty, @Nullable List<Mount> mounts, @Nullable Long stopGracePeriod, @Nullable ContainerConfig.Healthcheck healthcheck, @Nullable List<String> hosts, @Nullable List<SecretBind> secrets, @Nullable List<ConfigBind> configs, @Nullable DnsConfig dnsConfig, Map<String, String> sysctls, @Nullable Boolean init) {
        this.image = image;
        this.hostname = hostname;
        this.labels = labels;
        this.command = command;
        this.args = args;
        this.env = env;
        this.dir = dir;
        this.user = user;
        this.groups = groups;
        this.tty = tty;
        this.mounts = mounts;
        this.stopGracePeriod = stopGracePeriod;
        this.healthcheck = healthcheck;
        this.hosts = hosts;
        this.secrets = secrets;
        this.configs = configs;
        this.dnsConfig = dnsConfig;
        this.sysctls = sysctls;
        this.init = init;
    }

    @Override
    @JsonProperty(value="Image")
    public String image() {
        return this.image;
    }

    @Override
    @JsonProperty(value="Hostname")
    @Nullable
    public String hostname() {
        return this.hostname;
    }

    @Override
    @JsonProperty(value="Labels")
    public Map<String, String> labels() {
        return this.labels;
    }

    @Override
    @JsonProperty(value="Command")
    @Nullable
    public List<String> command() {
        return this.command;
    }

    @Override
    @JsonProperty(value="Args")
    @Nullable
    public List<String> args() {
        return this.args;
    }

    @Override
    @JsonProperty(value="Env")
    @Nullable
    public List<String> env() {
        return this.env;
    }

    @Override
    @JsonProperty(value="Dir")
    @Nullable
    public String dir() {
        return this.dir;
    }

    @Override
    @JsonProperty(value="User")
    @Nullable
    public String user() {
        return this.user;
    }

    @Override
    @JsonProperty(value="Groups")
    @Nullable
    public List<String> groups() {
        return this.groups;
    }

    @Override
    @JsonProperty(value="TTY")
    @Nullable
    public Boolean tty() {
        return this.tty;
    }

    @Override
    @JsonProperty(value="Mounts")
    @Nullable
    public List<Mount> mounts() {
        return this.mounts;
    }

    @Override
    @JsonProperty(value="StopGracePeriod")
    @Nullable
    public Long stopGracePeriod() {
        return this.stopGracePeriod;
    }

    @Override
    @JsonProperty(value="Healthcheck")
    @Nullable
    public ContainerConfig.Healthcheck healthcheck() {
        return this.healthcheck;
    }

    @Override
    @JsonProperty(value="Hosts")
    @Nullable
    public List<String> hosts() {
        return this.hosts;
    }

    @Override
    @JsonProperty(value="Secrets")
    @Nullable
    public List<SecretBind> secrets() {
        return this.secrets;
    }

    @Override
    @JsonProperty(value="Configs")
    @Nullable
    public List<ConfigBind> configs() {
        return this.configs;
    }

    @Override
    @JsonProperty(value="DNSConfig")
    @Nullable
    public DnsConfig dnsConfig() {
        return this.dnsConfig;
    }

    @Override
    @JsonProperty(value="Sysctls")
    public Map<String, String> sysctls() {
        return this.sysctls;
    }

    @Override
    @JsonProperty(value="Init")
    @Nullable
    public Boolean init() {
        return this.init;
    }

    public final ImmutableContainerSpec withImage(String value) {
        String newValue = Objects.requireNonNull(value, "image");
        if (this.image.equals(newValue)) {
            return this;
        }
        return new ImmutableContainerSpec(newValue, this.hostname, this.labels, this.command, this.args, this.env, this.dir, this.user, this.groups, this.tty, this.mounts, this.stopGracePeriod, this.healthcheck, this.hosts, this.secrets, this.configs, this.dnsConfig, this.sysctls, this.init);
    }

    public final ImmutableContainerSpec withHostname(@Nullable String value) {
        if (Objects.equals(this.hostname, value)) {
            return this;
        }
        return new ImmutableContainerSpec(this.image, value, this.labels, this.command, this.args, this.env, this.dir, this.user, this.groups, this.tty, this.mounts, this.stopGracePeriod, this.healthcheck, this.hosts, this.secrets, this.configs, this.dnsConfig, this.sysctls, this.init);
    }

    public final ImmutableContainerSpec withLabels(Map<String, ? extends String> entries) {
        if (this.labels == entries) {
            return this;
        }
        Map<String, String> newValue = ImmutableContainerSpec.createUnmodifiableMap(true, false, entries);
        return new ImmutableContainerSpec(this.image, this.hostname, newValue, this.command, this.args, this.env, this.dir, this.user, this.groups, this.tty, this.mounts, this.stopGracePeriod, this.healthcheck, this.hosts, this.secrets, this.configs, this.dnsConfig, this.sysctls, this.init);
    }

    public final ImmutableContainerSpec withCommand(String ... elements) {
        if (elements == null) {
            return new ImmutableContainerSpec(this.image, this.hostname, this.labels, null, this.args, this.env, this.dir, this.user, this.groups, this.tty, this.mounts, this.stopGracePeriod, this.healthcheck, this.hosts, this.secrets, this.configs, this.dnsConfig, this.sysctls, this.init);
        }
        List<String> newValue = Arrays.asList(elements) == null ? null : ImmutableContainerSpec.createUnmodifiableList(false, ImmutableContainerSpec.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableContainerSpec(this.image, this.hostname, this.labels, newValue, this.args, this.env, this.dir, this.user, this.groups, this.tty, this.mounts, this.stopGracePeriod, this.healthcheck, this.hosts, this.secrets, this.configs, this.dnsConfig, this.sysctls, this.init);
    }

    public final ImmutableContainerSpec withCommand(@Nullable Iterable<String> elements) {
        if (this.command == elements) {
            return this;
        }
        List<String> newValue = elements == null ? null : ImmutableContainerSpec.createUnmodifiableList(false, ImmutableContainerSpec.createSafeList(elements, true, false));
        return new ImmutableContainerSpec(this.image, this.hostname, this.labels, newValue, this.args, this.env, this.dir, this.user, this.groups, this.tty, this.mounts, this.stopGracePeriod, this.healthcheck, this.hosts, this.secrets, this.configs, this.dnsConfig, this.sysctls, this.init);
    }

    public final ImmutableContainerSpec withArgs(String ... elements) {
        if (elements == null) {
            return new ImmutableContainerSpec(this.image, this.hostname, this.labels, this.command, null, this.env, this.dir, this.user, this.groups, this.tty, this.mounts, this.stopGracePeriod, this.healthcheck, this.hosts, this.secrets, this.configs, this.dnsConfig, this.sysctls, this.init);
        }
        List<String> newValue = Arrays.asList(elements) == null ? null : ImmutableContainerSpec.createUnmodifiableList(false, ImmutableContainerSpec.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableContainerSpec(this.image, this.hostname, this.labels, this.command, newValue, this.env, this.dir, this.user, this.groups, this.tty, this.mounts, this.stopGracePeriod, this.healthcheck, this.hosts, this.secrets, this.configs, this.dnsConfig, this.sysctls, this.init);
    }

    public final ImmutableContainerSpec withArgs(@Nullable Iterable<String> elements) {
        if (this.args == elements) {
            return this;
        }
        List<String> newValue = elements == null ? null : ImmutableContainerSpec.createUnmodifiableList(false, ImmutableContainerSpec.createSafeList(elements, true, false));
        return new ImmutableContainerSpec(this.image, this.hostname, this.labels, this.command, newValue, this.env, this.dir, this.user, this.groups, this.tty, this.mounts, this.stopGracePeriod, this.healthcheck, this.hosts, this.secrets, this.configs, this.dnsConfig, this.sysctls, this.init);
    }

    public final ImmutableContainerSpec withEnv(String ... elements) {
        if (elements == null) {
            return new ImmutableContainerSpec(this.image, this.hostname, this.labels, this.command, this.args, null, this.dir, this.user, this.groups, this.tty, this.mounts, this.stopGracePeriod, this.healthcheck, this.hosts, this.secrets, this.configs, this.dnsConfig, this.sysctls, this.init);
        }
        List<String> newValue = Arrays.asList(elements) == null ? null : ImmutableContainerSpec.createUnmodifiableList(false, ImmutableContainerSpec.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableContainerSpec(this.image, this.hostname, this.labels, this.command, this.args, newValue, this.dir, this.user, this.groups, this.tty, this.mounts, this.stopGracePeriod, this.healthcheck, this.hosts, this.secrets, this.configs, this.dnsConfig, this.sysctls, this.init);
    }

    public final ImmutableContainerSpec withEnv(@Nullable Iterable<String> elements) {
        if (this.env == elements) {
            return this;
        }
        List<String> newValue = elements == null ? null : ImmutableContainerSpec.createUnmodifiableList(false, ImmutableContainerSpec.createSafeList(elements, true, false));
        return new ImmutableContainerSpec(this.image, this.hostname, this.labels, this.command, this.args, newValue, this.dir, this.user, this.groups, this.tty, this.mounts, this.stopGracePeriod, this.healthcheck, this.hosts, this.secrets, this.configs, this.dnsConfig, this.sysctls, this.init);
    }

    public final ImmutableContainerSpec withDir(@Nullable String value) {
        if (Objects.equals(this.dir, value)) {
            return this;
        }
        return new ImmutableContainerSpec(this.image, this.hostname, this.labels, this.command, this.args, this.env, value, this.user, this.groups, this.tty, this.mounts, this.stopGracePeriod, this.healthcheck, this.hosts, this.secrets, this.configs, this.dnsConfig, this.sysctls, this.init);
    }

    public final ImmutableContainerSpec withUser(@Nullable String value) {
        if (Objects.equals(this.user, value)) {
            return this;
        }
        return new ImmutableContainerSpec(this.image, this.hostname, this.labels, this.command, this.args, this.env, this.dir, value, this.groups, this.tty, this.mounts, this.stopGracePeriod, this.healthcheck, this.hosts, this.secrets, this.configs, this.dnsConfig, this.sysctls, this.init);
    }

    public final ImmutableContainerSpec withGroups(String ... elements) {
        if (elements == null) {
            return new ImmutableContainerSpec(this.image, this.hostname, this.labels, this.command, this.args, this.env, this.dir, this.user, null, this.tty, this.mounts, this.stopGracePeriod, this.healthcheck, this.hosts, this.secrets, this.configs, this.dnsConfig, this.sysctls, this.init);
        }
        List<String> newValue = Arrays.asList(elements) == null ? null : ImmutableContainerSpec.createUnmodifiableList(false, ImmutableContainerSpec.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableContainerSpec(this.image, this.hostname, this.labels, this.command, this.args, this.env, this.dir, this.user, newValue, this.tty, this.mounts, this.stopGracePeriod, this.healthcheck, this.hosts, this.secrets, this.configs, this.dnsConfig, this.sysctls, this.init);
    }

    public final ImmutableContainerSpec withGroups(@Nullable Iterable<String> elements) {
        if (this.groups == elements) {
            return this;
        }
        List<String> newValue = elements == null ? null : ImmutableContainerSpec.createUnmodifiableList(false, ImmutableContainerSpec.createSafeList(elements, true, false));
        return new ImmutableContainerSpec(this.image, this.hostname, this.labels, this.command, this.args, this.env, this.dir, this.user, newValue, this.tty, this.mounts, this.stopGracePeriod, this.healthcheck, this.hosts, this.secrets, this.configs, this.dnsConfig, this.sysctls, this.init);
    }

    public final ImmutableContainerSpec withTty(@Nullable Boolean value) {
        if (Objects.equals(this.tty, value)) {
            return this;
        }
        return new ImmutableContainerSpec(this.image, this.hostname, this.labels, this.command, this.args, this.env, this.dir, this.user, this.groups, value, this.mounts, this.stopGracePeriod, this.healthcheck, this.hosts, this.secrets, this.configs, this.dnsConfig, this.sysctls, this.init);
    }

    public final ImmutableContainerSpec withMounts(Mount ... elements) {
        if (elements == null) {
            return new ImmutableContainerSpec(this.image, this.hostname, this.labels, this.command, this.args, this.env, this.dir, this.user, this.groups, this.tty, null, this.stopGracePeriod, this.healthcheck, this.hosts, this.secrets, this.configs, this.dnsConfig, this.sysctls, this.init);
        }
        List<Mount> newValue = Arrays.asList(elements) == null ? null : ImmutableContainerSpec.createUnmodifiableList(false, ImmutableContainerSpec.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableContainerSpec(this.image, this.hostname, this.labels, this.command, this.args, this.env, this.dir, this.user, this.groups, this.tty, newValue, this.stopGracePeriod, this.healthcheck, this.hosts, this.secrets, this.configs, this.dnsConfig, this.sysctls, this.init);
    }

    public final ImmutableContainerSpec withMounts(@Nullable Iterable<? extends Mount> elements) {
        if (this.mounts == elements) {
            return this;
        }
        List<Mount> newValue = elements == null ? null : ImmutableContainerSpec.createUnmodifiableList(false, ImmutableContainerSpec.createSafeList(elements, true, false));
        return new ImmutableContainerSpec(this.image, this.hostname, this.labels, this.command, this.args, this.env, this.dir, this.user, this.groups, this.tty, newValue, this.stopGracePeriod, this.healthcheck, this.hosts, this.secrets, this.configs, this.dnsConfig, this.sysctls, this.init);
    }

    public final ImmutableContainerSpec withStopGracePeriod(@Nullable Long value) {
        if (Objects.equals(this.stopGracePeriod, value)) {
            return this;
        }
        return new ImmutableContainerSpec(this.image, this.hostname, this.labels, this.command, this.args, this.env, this.dir, this.user, this.groups, this.tty, this.mounts, value, this.healthcheck, this.hosts, this.secrets, this.configs, this.dnsConfig, this.sysctls, this.init);
    }

    public final ImmutableContainerSpec withHealthcheck(@Nullable ContainerConfig.Healthcheck value) {
        if (this.healthcheck == value) {
            return this;
        }
        return new ImmutableContainerSpec(this.image, this.hostname, this.labels, this.command, this.args, this.env, this.dir, this.user, this.groups, this.tty, this.mounts, this.stopGracePeriod, value, this.hosts, this.secrets, this.configs, this.dnsConfig, this.sysctls, this.init);
    }

    public final ImmutableContainerSpec withHosts(String ... elements) {
        if (elements == null) {
            return new ImmutableContainerSpec(this.image, this.hostname, this.labels, this.command, this.args, this.env, this.dir, this.user, this.groups, this.tty, this.mounts, this.stopGracePeriod, this.healthcheck, null, this.secrets, this.configs, this.dnsConfig, this.sysctls, this.init);
        }
        List<String> newValue = Arrays.asList(elements) == null ? null : ImmutableContainerSpec.createUnmodifiableList(false, ImmutableContainerSpec.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableContainerSpec(this.image, this.hostname, this.labels, this.command, this.args, this.env, this.dir, this.user, this.groups, this.tty, this.mounts, this.stopGracePeriod, this.healthcheck, newValue, this.secrets, this.configs, this.dnsConfig, this.sysctls, this.init);
    }

    public final ImmutableContainerSpec withHosts(@Nullable Iterable<String> elements) {
        if (this.hosts == elements) {
            return this;
        }
        List<String> newValue = elements == null ? null : ImmutableContainerSpec.createUnmodifiableList(false, ImmutableContainerSpec.createSafeList(elements, true, false));
        return new ImmutableContainerSpec(this.image, this.hostname, this.labels, this.command, this.args, this.env, this.dir, this.user, this.groups, this.tty, this.mounts, this.stopGracePeriod, this.healthcheck, newValue, this.secrets, this.configs, this.dnsConfig, this.sysctls, this.init);
    }

    public final ImmutableContainerSpec withSecrets(SecretBind ... elements) {
        if (elements == null) {
            return new ImmutableContainerSpec(this.image, this.hostname, this.labels, this.command, this.args, this.env, this.dir, this.user, this.groups, this.tty, this.mounts, this.stopGracePeriod, this.healthcheck, this.hosts, null, this.configs, this.dnsConfig, this.sysctls, this.init);
        }
        List<SecretBind> newValue = Arrays.asList(elements) == null ? null : ImmutableContainerSpec.createUnmodifiableList(false, ImmutableContainerSpec.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableContainerSpec(this.image, this.hostname, this.labels, this.command, this.args, this.env, this.dir, this.user, this.groups, this.tty, this.mounts, this.stopGracePeriod, this.healthcheck, this.hosts, newValue, this.configs, this.dnsConfig, this.sysctls, this.init);
    }

    public final ImmutableContainerSpec withSecrets(@Nullable Iterable<? extends SecretBind> elements) {
        if (this.secrets == elements) {
            return this;
        }
        List<SecretBind> newValue = elements == null ? null : ImmutableContainerSpec.createUnmodifiableList(false, ImmutableContainerSpec.createSafeList(elements, true, false));
        return new ImmutableContainerSpec(this.image, this.hostname, this.labels, this.command, this.args, this.env, this.dir, this.user, this.groups, this.tty, this.mounts, this.stopGracePeriod, this.healthcheck, this.hosts, newValue, this.configs, this.dnsConfig, this.sysctls, this.init);
    }

    public final ImmutableContainerSpec withConfigs(ConfigBind ... elements) {
        if (elements == null) {
            return new ImmutableContainerSpec(this.image, this.hostname, this.labels, this.command, this.args, this.env, this.dir, this.user, this.groups, this.tty, this.mounts, this.stopGracePeriod, this.healthcheck, this.hosts, this.secrets, null, this.dnsConfig, this.sysctls, this.init);
        }
        List<ConfigBind> newValue = Arrays.asList(elements) == null ? null : ImmutableContainerSpec.createUnmodifiableList(false, ImmutableContainerSpec.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableContainerSpec(this.image, this.hostname, this.labels, this.command, this.args, this.env, this.dir, this.user, this.groups, this.tty, this.mounts, this.stopGracePeriod, this.healthcheck, this.hosts, this.secrets, newValue, this.dnsConfig, this.sysctls, this.init);
    }

    public final ImmutableContainerSpec withConfigs(@Nullable Iterable<? extends ConfigBind> elements) {
        if (this.configs == elements) {
            return this;
        }
        List<ConfigBind> newValue = elements == null ? null : ImmutableContainerSpec.createUnmodifiableList(false, ImmutableContainerSpec.createSafeList(elements, true, false));
        return new ImmutableContainerSpec(this.image, this.hostname, this.labels, this.command, this.args, this.env, this.dir, this.user, this.groups, this.tty, this.mounts, this.stopGracePeriod, this.healthcheck, this.hosts, this.secrets, newValue, this.dnsConfig, this.sysctls, this.init);
    }

    public final ImmutableContainerSpec withDnsConfig(@Nullable DnsConfig value) {
        if (this.dnsConfig == value) {
            return this;
        }
        return new ImmutableContainerSpec(this.image, this.hostname, this.labels, this.command, this.args, this.env, this.dir, this.user, this.groups, this.tty, this.mounts, this.stopGracePeriod, this.healthcheck, this.hosts, this.secrets, this.configs, value, this.sysctls, this.init);
    }

    public final ImmutableContainerSpec withSysctls(Map<String, ? extends String> entries) {
        if (this.sysctls == entries) {
            return this;
        }
        Map<String, String> newValue = ImmutableContainerSpec.createUnmodifiableMap(true, false, entries);
        return new ImmutableContainerSpec(this.image, this.hostname, this.labels, this.command, this.args, this.env, this.dir, this.user, this.groups, this.tty, this.mounts, this.stopGracePeriod, this.healthcheck, this.hosts, this.secrets, this.configs, this.dnsConfig, newValue, this.init);
    }

    public final ImmutableContainerSpec withInit(@Nullable Boolean value) {
        if (Objects.equals(this.init, value)) {
            return this;
        }
        return new ImmutableContainerSpec(this.image, this.hostname, this.labels, this.command, this.args, this.env, this.dir, this.user, this.groups, this.tty, this.mounts, this.stopGracePeriod, this.healthcheck, this.hosts, this.secrets, this.configs, this.dnsConfig, this.sysctls, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableContainerSpec && this.equalTo(0, (ImmutableContainerSpec)another);
    }

    private boolean equalTo(int synthetic, ImmutableContainerSpec another) {
        return this.image.equals(another.image) && Objects.equals(this.hostname, another.hostname) && this.labels.equals(another.labels) && Objects.equals(this.command, another.command) && Objects.equals(this.args, another.args) && Objects.equals(this.env, another.env) && Objects.equals(this.dir, another.dir) && Objects.equals(this.user, another.user) && Objects.equals(this.groups, another.groups) && Objects.equals(this.tty, another.tty) && Objects.equals(this.mounts, another.mounts) && Objects.equals(this.stopGracePeriod, another.stopGracePeriod) && Objects.equals(this.healthcheck, another.healthcheck) && Objects.equals(this.hosts, another.hosts) && Objects.equals(this.secrets, another.secrets) && Objects.equals(this.configs, another.configs) && Objects.equals(this.dnsConfig, another.dnsConfig) && this.sysctls.equals(another.sysctls) && Objects.equals(this.init, another.init);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.image.hashCode();
        h += (h << 5) + Objects.hashCode(this.hostname);
        h += (h << 5) + this.labels.hashCode();
        h += (h << 5) + Objects.hashCode(this.command);
        h += (h << 5) + Objects.hashCode(this.args);
        h += (h << 5) + Objects.hashCode(this.env);
        h += (h << 5) + Objects.hashCode(this.dir);
        h += (h << 5) + Objects.hashCode(this.user);
        h += (h << 5) + Objects.hashCode(this.groups);
        h += (h << 5) + Objects.hashCode(this.tty);
        h += (h << 5) + Objects.hashCode(this.mounts);
        h += (h << 5) + Objects.hashCode(this.stopGracePeriod);
        h += (h << 5) + Objects.hashCode(this.healthcheck);
        h += (h << 5) + Objects.hashCode(this.hosts);
        h += (h << 5) + Objects.hashCode(this.secrets);
        h += (h << 5) + Objects.hashCode(this.configs);
        h += (h << 5) + Objects.hashCode(this.dnsConfig);
        h += (h << 5) + this.sysctls.hashCode();
        h += (h << 5) + Objects.hashCode(this.init);
        return h;
    }

    public String toString() {
        return "ContainerSpec{image=" + this.image + ", hostname=" + this.hostname + ", labels=" + this.labels + ", command=" + this.command + ", args=" + this.args + ", env=" + this.env + ", dir=" + this.dir + ", user=" + this.user + ", groups=" + this.groups + ", tty=" + this.tty + ", mounts=" + this.mounts + ", stopGracePeriod=" + this.stopGracePeriod + ", healthcheck=" + this.healthcheck + ", hosts=" + this.hosts + ", secrets=" + this.secrets + ", configs=" + this.configs + ", dnsConfig=" + this.dnsConfig + ", sysctls=" + this.sysctls + ", init=" + this.init + "}";
    }

    public static ImmutableContainerSpec copyOf(ContainerSpec instance) {
        if (instance instanceof ImmutableContainerSpec) {
            return (ImmutableContainerSpec)instance;
        }
        return ImmutableContainerSpec.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    if (v == null) {
                        Objects.requireNonNull(v, "value for key: " + k);
                    }
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    if (v == null) {
                        Objects.requireNonNull(v, "value for key: " + k);
                    }
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    static final class Builder
    implements ContainerSpec.Builder {
        private static final long INIT_BIT_IMAGE = 1L;
        private long initBits = 1L;
        private String image;
        private String hostname;
        private Map<String, String> labels = new LinkedHashMap<String, String>();
        private List<String> command = null;
        private List<String> args = null;
        private List<String> env = null;
        private String dir;
        private String user;
        private List<String> groups = null;
        private Boolean tty;
        private List<Mount> mounts = null;
        private Long stopGracePeriod;
        private ContainerConfig.Healthcheck healthcheck;
        private List<String> hosts = null;
        private List<SecretBind> secrets = null;
        private List<ConfigBind> configs = null;
        private DnsConfig dnsConfig;
        private Map<String, String> sysctls = new LinkedHashMap<String, String>();
        private Boolean init;

        private Builder() {
        }

        public final Builder from(ContainerSpec instance) {
            DnsConfig dnsConfigValue;
            List<ConfigBind> configsValue;
            List<SecretBind> secretsValue;
            List<String> hostsValue;
            ContainerConfig.Healthcheck healthcheckValue;
            Long stopGracePeriodValue;
            List<Mount> mountsValue;
            Boolean ttyValue;
            List<String> groupsValue;
            String userValue;
            String dirValue;
            List<String> envValue;
            List<String> argsValue;
            Objects.requireNonNull(instance, "instance");
            this.image(instance.image());
            String hostnameValue = instance.hostname();
            if (hostnameValue != null) {
                this.hostname(hostnameValue);
            }
            this.putAllLabels(instance.labels());
            List<String> commandValue = instance.command();
            if (commandValue != null) {
                this.addAllCommand(commandValue);
            }
            if ((argsValue = instance.args()) != null) {
                this.addAllArgs(argsValue);
            }
            if ((envValue = instance.env()) != null) {
                this.addAllEnv(envValue);
            }
            if ((dirValue = instance.dir()) != null) {
                this.dir(dirValue);
            }
            if ((userValue = instance.user()) != null) {
                this.user(userValue);
            }
            if ((groupsValue = instance.groups()) != null) {
                this.addAllGroups(groupsValue);
            }
            if ((ttyValue = instance.tty()) != null) {
                this.tty(ttyValue);
            }
            if ((mountsValue = instance.mounts()) != null) {
                this.addAllMounts(mountsValue);
            }
            if ((stopGracePeriodValue = instance.stopGracePeriod()) != null) {
                this.stopGracePeriod(stopGracePeriodValue);
            }
            if ((healthcheckValue = instance.healthcheck()) != null) {
                this.healthcheck(healthcheckValue);
            }
            if ((hostsValue = instance.hosts()) != null) {
                this.addAllHosts(hostsValue);
            }
            if ((secretsValue = instance.secrets()) != null) {
                this.addAllSecrets(secretsValue);
            }
            if ((configsValue = instance.configs()) != null) {
                this.addAllConfigs(configsValue);
            }
            if ((dnsConfigValue = instance.dnsConfig()) != null) {
                this.dnsConfig(dnsConfigValue);
            }
            this.putAllSysctls(instance.sysctls());
            Boolean initValue = instance.init();
            if (initValue != null) {
                this.init(initValue);
            }
            return this;
        }

        @Override
        @JsonProperty(value="Image")
        public final Builder image(String image) {
            this.image = Objects.requireNonNull(image, "image");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @Override
        @JsonProperty(value="Hostname")
        public final Builder hostname(@Nullable String hostname) {
            this.hostname = hostname;
            return this;
        }

        @Override
        public final Builder addLabel(String key, String value) {
            this.labels.put(Objects.requireNonNull(key, "labels key"), value == null ? Objects.requireNonNull(value, "labels value for key: " + key) : value);
            return this;
        }

        public final Builder addLabel(Map.Entry<String, ? extends String> entry) {
            String v;
            String k = entry.getKey();
            this.labels.put(Objects.requireNonNull(k, "labels key"), (v = entry.getValue()) == null ? Objects.requireNonNull(v, "labels value for key: " + k) : v);
            return this;
        }

        @Override
        @JsonProperty(value="Labels")
        public final Builder labels(Map<String, ? extends String> entries) {
            this.labels.clear();
            return this.putAllLabels(entries);
        }

        public final Builder putAllLabels(Map<String, ? extends String> entries) {
            for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
                String v;
                String k = e.getKey();
                this.labels.put(Objects.requireNonNull(k, "labels key"), (v = e.getValue()) == null ? Objects.requireNonNull(v, "labels value for key: " + k) : v);
            }
            return this;
        }

        public final Builder command(String element) {
            if (this.command == null) {
                this.command = new ArrayList<String>();
            }
            this.command.add(Objects.requireNonNull(element, "command element"));
            return this;
        }

        @Override
        public final Builder command(String ... elements) {
            if (this.command == null) {
                this.command = new ArrayList<String>();
            }
            for (String element : elements) {
                this.command.add(Objects.requireNonNull(element, "command element"));
            }
            return this;
        }

        @Override
        @JsonProperty(value="Command")
        public final Builder command(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.command = null;
                return this;
            }
            this.command = new ArrayList<String>();
            return this.addAllCommand(elements);
        }

        public final Builder addAllCommand(Iterable<String> elements) {
            Objects.requireNonNull(elements, "command element");
            if (this.command == null) {
                this.command = new ArrayList<String>();
            }
            for (String element : elements) {
                this.command.add(Objects.requireNonNull(element, "command element"));
            }
            return this;
        }

        public final Builder arg(String element) {
            if (this.args == null) {
                this.args = new ArrayList<String>();
            }
            this.args.add(Objects.requireNonNull(element, "args element"));
            return this;
        }

        @Override
        public final Builder args(String ... elements) {
            if (this.args == null) {
                this.args = new ArrayList<String>();
            }
            for (String element : elements) {
                this.args.add(Objects.requireNonNull(element, "args element"));
            }
            return this;
        }

        @Override
        @JsonProperty(value="Args")
        public final Builder args(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.args = null;
                return this;
            }
            this.args = new ArrayList<String>();
            return this.addAllArgs(elements);
        }

        public final Builder addAllArgs(Iterable<String> elements) {
            Objects.requireNonNull(elements, "args element");
            if (this.args == null) {
                this.args = new ArrayList<String>();
            }
            for (String element : elements) {
                this.args.add(Objects.requireNonNull(element, "args element"));
            }
            return this;
        }

        public final Builder env(String element) {
            if (this.env == null) {
                this.env = new ArrayList<String>();
            }
            this.env.add(Objects.requireNonNull(element, "env element"));
            return this;
        }

        @Override
        public final Builder env(String ... elements) {
            if (this.env == null) {
                this.env = new ArrayList<String>();
            }
            for (String element : elements) {
                this.env.add(Objects.requireNonNull(element, "env element"));
            }
            return this;
        }

        @Override
        @JsonProperty(value="Env")
        public final Builder env(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.env = null;
                return this;
            }
            this.env = new ArrayList<String>();
            return this.addAllEnv(elements);
        }

        public final Builder addAllEnv(Iterable<String> elements) {
            Objects.requireNonNull(elements, "env element");
            if (this.env == null) {
                this.env = new ArrayList<String>();
            }
            for (String element : elements) {
                this.env.add(Objects.requireNonNull(element, "env element"));
            }
            return this;
        }

        @Override
        @JsonProperty(value="Dir")
        public final Builder dir(@Nullable String dir) {
            this.dir = dir;
            return this;
        }

        @Override
        @JsonProperty(value="User")
        public final Builder user(@Nullable String user) {
            this.user = user;
            return this;
        }

        public final Builder group(String element) {
            if (this.groups == null) {
                this.groups = new ArrayList<String>();
            }
            this.groups.add(Objects.requireNonNull(element, "groups element"));
            return this;
        }

        @Override
        public final Builder groups(String ... elements) {
            if (this.groups == null) {
                this.groups = new ArrayList<String>();
            }
            for (String element : elements) {
                this.groups.add(Objects.requireNonNull(element, "groups element"));
            }
            return this;
        }

        @Override
        @JsonProperty(value="Groups")
        public final Builder groups(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.groups = null;
                return this;
            }
            this.groups = new ArrayList<String>();
            return this.addAllGroups(elements);
        }

        public final Builder addAllGroups(Iterable<String> elements) {
            Objects.requireNonNull(elements, "groups element");
            if (this.groups == null) {
                this.groups = new ArrayList<String>();
            }
            for (String element : elements) {
                this.groups.add(Objects.requireNonNull(element, "groups element"));
            }
            return this;
        }

        @Override
        @JsonProperty(value="TTY")
        public final Builder tty(@Nullable Boolean tty) {
            this.tty = tty;
            return this;
        }

        public final Builder mount(Mount element) {
            if (this.mounts == null) {
                this.mounts = new ArrayList<Mount>();
            }
            this.mounts.add(Objects.requireNonNull(element, "mounts element"));
            return this;
        }

        @Override
        public final Builder mounts(Mount ... elements) {
            if (this.mounts == null) {
                this.mounts = new ArrayList<Mount>();
            }
            for (Mount element : elements) {
                this.mounts.add(Objects.requireNonNull(element, "mounts element"));
            }
            return this;
        }

        @Override
        @JsonProperty(value="Mounts")
        public final Builder mounts(@Nullable Iterable<? extends Mount> elements) {
            if (elements == null) {
                this.mounts = null;
                return this;
            }
            this.mounts = new ArrayList<Mount>();
            return this.addAllMounts(elements);
        }

        public final Builder addAllMounts(Iterable<? extends Mount> elements) {
            Objects.requireNonNull(elements, "mounts element");
            if (this.mounts == null) {
                this.mounts = new ArrayList<Mount>();
            }
            for (Mount mount : elements) {
                this.mounts.add(Objects.requireNonNull(mount, "mounts element"));
            }
            return this;
        }

        @Override
        @JsonProperty(value="StopGracePeriod")
        public final Builder stopGracePeriod(@Nullable Long stopGracePeriod) {
            this.stopGracePeriod = stopGracePeriod;
            return this;
        }

        @Override
        @JsonProperty(value="Healthcheck")
        public final Builder healthcheck(@Nullable ContainerConfig.Healthcheck healthcheck) {
            this.healthcheck = healthcheck;
            return this;
        }

        public final Builder host(String element) {
            if (this.hosts == null) {
                this.hosts = new ArrayList<String>();
            }
            this.hosts.add(Objects.requireNonNull(element, "hosts element"));
            return this;
        }

        public final Builder hosts(String ... elements) {
            if (this.hosts == null) {
                this.hosts = new ArrayList<String>();
            }
            for (String element : elements) {
                this.hosts.add(Objects.requireNonNull(element, "hosts element"));
            }
            return this;
        }

        @Override
        @JsonProperty(value="Hosts")
        public final Builder hosts(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.hosts = null;
                return this;
            }
            this.hosts = new ArrayList<String>();
            return this.addAllHosts(elements);
        }

        public final Builder addAllHosts(Iterable<String> elements) {
            Objects.requireNonNull(elements, "hosts element");
            if (this.hosts == null) {
                this.hosts = new ArrayList<String>();
            }
            for (String element : elements) {
                this.hosts.add(Objects.requireNonNull(element, "hosts element"));
            }
            return this;
        }

        public final Builder secret(SecretBind element) {
            if (this.secrets == null) {
                this.secrets = new ArrayList<SecretBind>();
            }
            this.secrets.add(Objects.requireNonNull(element, "secrets element"));
            return this;
        }

        public final Builder secrets(SecretBind ... elements) {
            if (this.secrets == null) {
                this.secrets = new ArrayList<SecretBind>();
            }
            for (SecretBind element : elements) {
                this.secrets.add(Objects.requireNonNull(element, "secrets element"));
            }
            return this;
        }

        @Override
        @JsonProperty(value="Secrets")
        public final Builder secrets(@Nullable Iterable<? extends SecretBind> elements) {
            if (elements == null) {
                this.secrets = null;
                return this;
            }
            this.secrets = new ArrayList<SecretBind>();
            return this.addAllSecrets(elements);
        }

        public final Builder addAllSecrets(Iterable<? extends SecretBind> elements) {
            Objects.requireNonNull(elements, "secrets element");
            if (this.secrets == null) {
                this.secrets = new ArrayList<SecretBind>();
            }
            for (SecretBind secretBind : elements) {
                this.secrets.add(Objects.requireNonNull(secretBind, "secrets element"));
            }
            return this;
        }

        public final Builder config(ConfigBind element) {
            if (this.configs == null) {
                this.configs = new ArrayList<ConfigBind>();
            }
            this.configs.add(Objects.requireNonNull(element, "configs element"));
            return this;
        }

        public final Builder configs(ConfigBind ... elements) {
            if (this.configs == null) {
                this.configs = new ArrayList<ConfigBind>();
            }
            for (ConfigBind element : elements) {
                this.configs.add(Objects.requireNonNull(element, "configs element"));
            }
            return this;
        }

        @Override
        @JsonProperty(value="Configs")
        public final Builder configs(@Nullable Iterable<? extends ConfigBind> elements) {
            if (elements == null) {
                this.configs = null;
                return this;
            }
            this.configs = new ArrayList<ConfigBind>();
            return this.addAllConfigs(elements);
        }

        public final Builder addAllConfigs(Iterable<? extends ConfigBind> elements) {
            Objects.requireNonNull(elements, "configs element");
            if (this.configs == null) {
                this.configs = new ArrayList<ConfigBind>();
            }
            for (ConfigBind configBind : elements) {
                this.configs.add(Objects.requireNonNull(configBind, "configs element"));
            }
            return this;
        }

        @Override
        @JsonProperty(value="DNSConfig")
        public final Builder dnsConfig(@Nullable DnsConfig dnsConfig) {
            this.dnsConfig = dnsConfig;
            return this;
        }

        @Override
        public final Builder addSysctl(String key, String value) {
            this.sysctls.put(Objects.requireNonNull(key, "sysctls key"), value == null ? Objects.requireNonNull(value, "sysctls value for key: " + key) : value);
            return this;
        }

        public final Builder addSysctl(Map.Entry<String, ? extends String> entry) {
            String v;
            String k = entry.getKey();
            this.sysctls.put(Objects.requireNonNull(k, "sysctls key"), (v = entry.getValue()) == null ? Objects.requireNonNull(v, "sysctls value for key: " + k) : v);
            return this;
        }

        @Override
        @JsonProperty(value="Sysctls")
        public final Builder sysctls(Map<String, ? extends String> entries) {
            this.sysctls.clear();
            return this.putAllSysctls(entries);
        }

        public final Builder putAllSysctls(Map<String, ? extends String> entries) {
            for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
                String v;
                String k = e.getKey();
                this.sysctls.put(Objects.requireNonNull(k, "sysctls key"), (v = e.getValue()) == null ? Objects.requireNonNull(v, "sysctls value for key: " + k) : v);
            }
            return this;
        }

        @Override
        @JsonProperty(value="Init")
        public final Builder init(@Nullable Boolean init) {
            this.init = init;
            return this;
        }

        @Override
        public ImmutableContainerSpec build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableContainerSpec(this.image, this.hostname, ImmutableContainerSpec.createUnmodifiableMap(false, false, this.labels), this.command == null ? null : ImmutableContainerSpec.createUnmodifiableList(true, this.command), this.args == null ? null : ImmutableContainerSpec.createUnmodifiableList(true, this.args), this.env == null ? null : ImmutableContainerSpec.createUnmodifiableList(true, this.env), this.dir, this.user, this.groups == null ? null : ImmutableContainerSpec.createUnmodifiableList(true, this.groups), this.tty, this.mounts == null ? null : ImmutableContainerSpec.createUnmodifiableList(true, this.mounts), this.stopGracePeriod, this.healthcheck, this.hosts == null ? null : ImmutableContainerSpec.createUnmodifiableList(true, this.hosts), this.secrets == null ? null : ImmutableContainerSpec.createUnmodifiableList(true, this.secrets), this.configs == null ? null : ImmutableContainerSpec.createUnmodifiableList(true, this.configs), this.dnsConfig, ImmutableContainerSpec.createUnmodifiableMap(false, false, this.sysctls), this.init);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("image");
            }
            return "Cannot build ContainerSpec, some of required attributes are not set " + attributes;
        }
    }
}

