/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Date;
import java.util.Objects;
import org.mandas.docker.Nullable;
import org.mandas.docker.client.messages.ContainerConfig;
import org.mandas.docker.client.messages.ImageInfo;
import org.mandas.docker.client.messages.RootFs;

final class ImmutableImageInfo
implements ImageInfo {
    private final String id;
    private final String parent;
    private final String comment;
    private final Date created;
    private final String container;
    private final ContainerConfig containerConfig;
    private final String dockerVersion;
    private final String author;
    private final ContainerConfig config;
    private final String architecture;
    private final String os;
    private final Long size;
    private final Long virtualSize;
    @Nullable
    private final RootFs rootFs;

    private ImmutableImageInfo(String id, String parent, String comment, Date created, String container, ContainerConfig containerConfig, String dockerVersion, String author, ContainerConfig config, String architecture, String os, Long size, Long virtualSize, @Nullable RootFs rootFs) {
        this.id = id;
        this.parent = parent;
        this.comment = comment;
        this.created = created;
        this.container = container;
        this.containerConfig = containerConfig;
        this.dockerVersion = dockerVersion;
        this.author = author;
        this.config = config;
        this.architecture = architecture;
        this.os = os;
        this.size = size;
        this.virtualSize = virtualSize;
        this.rootFs = rootFs;
    }

    @Override
    @JsonProperty(value="Id")
    public String id() {
        return this.id;
    }

    @Override
    @JsonProperty(value="Parent")
    public String parent() {
        return this.parent;
    }

    @Override
    @JsonProperty(value="Comment")
    public String comment() {
        return this.comment;
    }

    @Override
    @JsonProperty(value="Created")
    public Date created() {
        return this.created;
    }

    @Override
    @JsonProperty(value="Container")
    public String container() {
        return this.container;
    }

    @Override
    @JsonProperty(value="ContainerConfig")
    public ContainerConfig containerConfig() {
        return this.containerConfig;
    }

    @Override
    @JsonProperty(value="DockerVersion")
    public String dockerVersion() {
        return this.dockerVersion;
    }

    @Override
    @JsonProperty(value="Author")
    public String author() {
        return this.author;
    }

    @Override
    @JsonProperty(value="Config")
    public ContainerConfig config() {
        return this.config;
    }

    @Override
    @JsonProperty(value="Architecture")
    public String architecture() {
        return this.architecture;
    }

    @Override
    @JsonProperty(value="Os")
    public String os() {
        return this.os;
    }

    @Override
    @JsonProperty(value="Size")
    public Long size() {
        return this.size;
    }

    @Override
    @JsonProperty(value="VirtualSize")
    public Long virtualSize() {
        return this.virtualSize;
    }

    @Override
    @JsonProperty(value="RootFS")
    @Nullable
    public RootFs rootFs() {
        return this.rootFs;
    }

    public final ImmutableImageInfo withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new ImmutableImageInfo(newValue, this.parent, this.comment, this.created, this.container, this.containerConfig, this.dockerVersion, this.author, this.config, this.architecture, this.os, this.size, this.virtualSize, this.rootFs);
    }

    public final ImmutableImageInfo withParent(String value) {
        String newValue = Objects.requireNonNull(value, "parent");
        if (this.parent.equals(newValue)) {
            return this;
        }
        return new ImmutableImageInfo(this.id, newValue, this.comment, this.created, this.container, this.containerConfig, this.dockerVersion, this.author, this.config, this.architecture, this.os, this.size, this.virtualSize, this.rootFs);
    }

    public final ImmutableImageInfo withComment(String value) {
        String newValue = Objects.requireNonNull(value, "comment");
        if (this.comment.equals(newValue)) {
            return this;
        }
        return new ImmutableImageInfo(this.id, this.parent, newValue, this.created, this.container, this.containerConfig, this.dockerVersion, this.author, this.config, this.architecture, this.os, this.size, this.virtualSize, this.rootFs);
    }

    public final ImmutableImageInfo withCreated(Date value) {
        if (this.created == value) {
            return this;
        }
        Date newValue = Objects.requireNonNull(value, "created");
        return new ImmutableImageInfo(this.id, this.parent, this.comment, newValue, this.container, this.containerConfig, this.dockerVersion, this.author, this.config, this.architecture, this.os, this.size, this.virtualSize, this.rootFs);
    }

    public final ImmutableImageInfo withContainer(String value) {
        String newValue = Objects.requireNonNull(value, "container");
        if (this.container.equals(newValue)) {
            return this;
        }
        return new ImmutableImageInfo(this.id, this.parent, this.comment, this.created, newValue, this.containerConfig, this.dockerVersion, this.author, this.config, this.architecture, this.os, this.size, this.virtualSize, this.rootFs);
    }

    public final ImmutableImageInfo withContainerConfig(ContainerConfig value) {
        if (this.containerConfig == value) {
            return this;
        }
        ContainerConfig newValue = Objects.requireNonNull(value, "containerConfig");
        return new ImmutableImageInfo(this.id, this.parent, this.comment, this.created, this.container, newValue, this.dockerVersion, this.author, this.config, this.architecture, this.os, this.size, this.virtualSize, this.rootFs);
    }

    public final ImmutableImageInfo withDockerVersion(String value) {
        String newValue = Objects.requireNonNull(value, "dockerVersion");
        if (this.dockerVersion.equals(newValue)) {
            return this;
        }
        return new ImmutableImageInfo(this.id, this.parent, this.comment, this.created, this.container, this.containerConfig, newValue, this.author, this.config, this.architecture, this.os, this.size, this.virtualSize, this.rootFs);
    }

    public final ImmutableImageInfo withAuthor(String value) {
        String newValue = Objects.requireNonNull(value, "author");
        if (this.author.equals(newValue)) {
            return this;
        }
        return new ImmutableImageInfo(this.id, this.parent, this.comment, this.created, this.container, this.containerConfig, this.dockerVersion, newValue, this.config, this.architecture, this.os, this.size, this.virtualSize, this.rootFs);
    }

    public final ImmutableImageInfo withConfig(ContainerConfig value) {
        if (this.config == value) {
            return this;
        }
        ContainerConfig newValue = Objects.requireNonNull(value, "config");
        return new ImmutableImageInfo(this.id, this.parent, this.comment, this.created, this.container, this.containerConfig, this.dockerVersion, this.author, newValue, this.architecture, this.os, this.size, this.virtualSize, this.rootFs);
    }

    public final ImmutableImageInfo withArchitecture(String value) {
        String newValue = Objects.requireNonNull(value, "architecture");
        if (this.architecture.equals(newValue)) {
            return this;
        }
        return new ImmutableImageInfo(this.id, this.parent, this.comment, this.created, this.container, this.containerConfig, this.dockerVersion, this.author, this.config, newValue, this.os, this.size, this.virtualSize, this.rootFs);
    }

    public final ImmutableImageInfo withOs(String value) {
        String newValue = Objects.requireNonNull(value, "os");
        if (this.os.equals(newValue)) {
            return this;
        }
        return new ImmutableImageInfo(this.id, this.parent, this.comment, this.created, this.container, this.containerConfig, this.dockerVersion, this.author, this.config, this.architecture, newValue, this.size, this.virtualSize, this.rootFs);
    }

    public final ImmutableImageInfo withSize(Long value) {
        Long newValue = Objects.requireNonNull(value, "size");
        if (this.size.equals(newValue)) {
            return this;
        }
        return new ImmutableImageInfo(this.id, this.parent, this.comment, this.created, this.container, this.containerConfig, this.dockerVersion, this.author, this.config, this.architecture, this.os, newValue, this.virtualSize, this.rootFs);
    }

    public final ImmutableImageInfo withVirtualSize(Long value) {
        Long newValue = Objects.requireNonNull(value, "virtualSize");
        if (this.virtualSize.equals(newValue)) {
            return this;
        }
        return new ImmutableImageInfo(this.id, this.parent, this.comment, this.created, this.container, this.containerConfig, this.dockerVersion, this.author, this.config, this.architecture, this.os, this.size, newValue, this.rootFs);
    }

    public final ImmutableImageInfo withRootFs(@Nullable RootFs value) {
        if (this.rootFs == value) {
            return this;
        }
        return new ImmutableImageInfo(this.id, this.parent, this.comment, this.created, this.container, this.containerConfig, this.dockerVersion, this.author, this.config, this.architecture, this.os, this.size, this.virtualSize, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableImageInfo && this.equalTo(0, (ImmutableImageInfo)another);
    }

    private boolean equalTo(int synthetic, ImmutableImageInfo another) {
        return this.id.equals(another.id) && this.parent.equals(another.parent) && this.comment.equals(another.comment) && this.created.equals(another.created) && this.container.equals(another.container) && this.containerConfig.equals(another.containerConfig) && this.dockerVersion.equals(another.dockerVersion) && this.author.equals(another.author) && this.config.equals(another.config) && this.architecture.equals(another.architecture) && this.os.equals(another.os) && this.size.equals(another.size) && this.virtualSize.equals(another.virtualSize) && Objects.equals(this.rootFs, another.rootFs);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.parent.hashCode();
        h += (h << 5) + this.comment.hashCode();
        h += (h << 5) + this.created.hashCode();
        h += (h << 5) + this.container.hashCode();
        h += (h << 5) + this.containerConfig.hashCode();
        h += (h << 5) + this.dockerVersion.hashCode();
        h += (h << 5) + this.author.hashCode();
        h += (h << 5) + this.config.hashCode();
        h += (h << 5) + this.architecture.hashCode();
        h += (h << 5) + this.os.hashCode();
        h += (h << 5) + this.size.hashCode();
        h += (h << 5) + this.virtualSize.hashCode();
        h += (h << 5) + Objects.hashCode(this.rootFs);
        return h;
    }

    public String toString() {
        return "ImageInfo{id=" + this.id + ", parent=" + this.parent + ", comment=" + this.comment + ", created=" + this.created + ", container=" + this.container + ", containerConfig=" + this.containerConfig + ", dockerVersion=" + this.dockerVersion + ", author=" + this.author + ", config=" + this.config + ", architecture=" + this.architecture + ", os=" + this.os + ", size=" + this.size + ", virtualSize=" + this.virtualSize + ", rootFs=" + this.rootFs + "}";
    }

    public static ImmutableImageInfo copyOf(ImageInfo instance) {
        if (instance instanceof ImmutableImageInfo) {
            return (ImmutableImageInfo)instance;
        }
        return ImmutableImageInfo.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_PARENT = 2L;
        private static final long INIT_BIT_COMMENT = 4L;
        private static final long INIT_BIT_CREATED = 8L;
        private static final long INIT_BIT_CONTAINER = 16L;
        private static final long INIT_BIT_CONTAINER_CONFIG = 32L;
        private static final long INIT_BIT_DOCKER_VERSION = 64L;
        private static final long INIT_BIT_AUTHOR = 128L;
        private static final long INIT_BIT_CONFIG = 256L;
        private static final long INIT_BIT_ARCHITECTURE = 512L;
        private static final long INIT_BIT_OS = 1024L;
        private static final long INIT_BIT_SIZE = 2048L;
        private static final long INIT_BIT_VIRTUAL_SIZE = 4096L;
        private long initBits = 8191L;
        private String id;
        private String parent;
        private String comment;
        private Date created;
        private String container;
        private ContainerConfig containerConfig;
        private String dockerVersion;
        private String author;
        private ContainerConfig config;
        private String architecture;
        private String os;
        private Long size;
        private Long virtualSize;
        private RootFs rootFs;

        private Builder() {
        }

        public final Builder from(ImageInfo instance) {
            Objects.requireNonNull(instance, "instance");
            this.id(instance.id());
            this.parent(instance.parent());
            this.comment(instance.comment());
            this.created(instance.created());
            this.container(instance.container());
            this.containerConfig(instance.containerConfig());
            this.dockerVersion(instance.dockerVersion());
            this.author(instance.author());
            this.config(instance.config());
            this.architecture(instance.architecture());
            this.os(instance.os());
            this.size(instance.size());
            this.virtualSize(instance.virtualSize());
            RootFs rootFsValue = instance.rootFs();
            if (rootFsValue != null) {
                this.rootFs(rootFsValue);
            }
            return this;
        }

        @JsonProperty(value="Id")
        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="Parent")
        public final Builder parent(String parent) {
            this.parent = Objects.requireNonNull(parent, "parent");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="Comment")
        public final Builder comment(String comment) {
            this.comment = Objects.requireNonNull(comment, "comment");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="Created")
        public final Builder created(Date created) {
            this.created = Objects.requireNonNull(created, "created");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="Container")
        public final Builder container(String container) {
            this.container = Objects.requireNonNull(container, "container");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @JsonProperty(value="ContainerConfig")
        public final Builder containerConfig(ContainerConfig containerConfig) {
            this.containerConfig = Objects.requireNonNull(containerConfig, "containerConfig");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        @JsonProperty(value="DockerVersion")
        public final Builder dockerVersion(String dockerVersion) {
            this.dockerVersion = Objects.requireNonNull(dockerVersion, "dockerVersion");
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        @JsonProperty(value="Author")
        public final Builder author(String author) {
            this.author = Objects.requireNonNull(author, "author");
            this.initBits &= 0xFFFFFFFFFFFFFF7FL;
            return this;
        }

        @JsonProperty(value="Config")
        public final Builder config(ContainerConfig config) {
            this.config = Objects.requireNonNull(config, "config");
            this.initBits &= 0xFFFFFFFFFFFFFEFFL;
            return this;
        }

        @JsonProperty(value="Architecture")
        public final Builder architecture(String architecture) {
            this.architecture = Objects.requireNonNull(architecture, "architecture");
            this.initBits &= 0xFFFFFFFFFFFFFDFFL;
            return this;
        }

        @JsonProperty(value="Os")
        public final Builder os(String os) {
            this.os = Objects.requireNonNull(os, "os");
            this.initBits &= 0xFFFFFFFFFFFFFBFFL;
            return this;
        }

        @JsonProperty(value="Size")
        public final Builder size(Long size) {
            this.size = Objects.requireNonNull(size, "size");
            this.initBits &= 0xFFFFFFFFFFFFF7FFL;
            return this;
        }

        @JsonProperty(value="VirtualSize")
        public final Builder virtualSize(Long virtualSize) {
            this.virtualSize = Objects.requireNonNull(virtualSize, "virtualSize");
            this.initBits &= 0xFFFFFFFFFFFFEFFFL;
            return this;
        }

        @JsonProperty(value="RootFS")
        public final Builder rootFs(@Nullable RootFs rootFs) {
            this.rootFs = rootFs;
            return this;
        }

        public ImmutableImageInfo build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableImageInfo(this.id, this.parent, this.comment, this.created, this.container, this.containerConfig, this.dockerVersion, this.author, this.config, this.architecture, this.os, this.size, this.virtualSize, this.rootFs);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("parent");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("comment");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("created");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("container");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("containerConfig");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("dockerVersion");
            }
            if ((this.initBits & 0x80L) != 0L) {
                attributes.add("author");
            }
            if ((this.initBits & 0x100L) != 0L) {
                attributes.add("config");
            }
            if ((this.initBits & 0x200L) != 0L) {
                attributes.add("architecture");
            }
            if ((this.initBits & 0x400L) != 0L) {
                attributes.add("os");
            }
            if ((this.initBits & 0x800L) != 0L) {
                attributes.add("size");
            }
            if ((this.initBits & 0x1000L) != 0L) {
                attributes.add("virtualSize");
            }
            return "Cannot build ImageInfo, some of required attributes are not set " + attributes;
        }
    }
}

