/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.mandas.docker.Nullable;
import org.mandas.docker.client.messages.Image;

final class ImmutableImage
implements Image {
    private final String created;
    private final String id;
    private final String parentId;
    @Nullable
    private final List<String> repoTags;
    @Nullable
    private final List<String> repoDigests;
    private final Long size;
    private final Long virtualSize;
    @Nullable
    private final Map<String, String> labels;

    private ImmutableImage(String created, String id, String parentId, @Nullable List<String> repoTags, @Nullable List<String> repoDigests, Long size, Long virtualSize, @Nullable Map<String, String> labels) {
        this.created = created;
        this.id = id;
        this.parentId = parentId;
        this.repoTags = repoTags;
        this.repoDigests = repoDigests;
        this.size = size;
        this.virtualSize = virtualSize;
        this.labels = labels;
    }

    @Override
    @JsonProperty(value="Created")
    public String created() {
        return this.created;
    }

    @Override
    @JsonProperty(value="Id")
    public String id() {
        return this.id;
    }

    @Override
    @JsonProperty(value="ParentId")
    public String parentId() {
        return this.parentId;
    }

    @Override
    @JsonProperty(value="RepoTags")
    @Nullable
    public List<String> repoTags() {
        return this.repoTags;
    }

    @Override
    @JsonProperty(value="RepoDigests")
    @Nullable
    public List<String> repoDigests() {
        return this.repoDigests;
    }

    @Override
    @JsonProperty(value="Size")
    public Long size() {
        return this.size;
    }

    @Override
    @JsonProperty(value="VirtualSize")
    public Long virtualSize() {
        return this.virtualSize;
    }

    @Override
    @JsonProperty(value="Labels")
    @Nullable
    public Map<String, String> labels() {
        return this.labels;
    }

    public final ImmutableImage withCreated(String value) {
        String newValue = Objects.requireNonNull(value, "created");
        if (this.created.equals(newValue)) {
            return this;
        }
        return new ImmutableImage(newValue, this.id, this.parentId, this.repoTags, this.repoDigests, this.size, this.virtualSize, this.labels);
    }

    public final ImmutableImage withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new ImmutableImage(this.created, newValue, this.parentId, this.repoTags, this.repoDigests, this.size, this.virtualSize, this.labels);
    }

    public final ImmutableImage withParentId(String value) {
        String newValue = Objects.requireNonNull(value, "parentId");
        if (this.parentId.equals(newValue)) {
            return this;
        }
        return new ImmutableImage(this.created, this.id, newValue, this.repoTags, this.repoDigests, this.size, this.virtualSize, this.labels);
    }

    public final ImmutableImage withRepoTags(String ... elements) {
        if (elements == null) {
            return new ImmutableImage(this.created, this.id, this.parentId, null, this.repoDigests, this.size, this.virtualSize, this.labels);
        }
        List<String> newValue = Arrays.asList(elements) == null ? null : ImmutableImage.createUnmodifiableList(false, ImmutableImage.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableImage(this.created, this.id, this.parentId, newValue, this.repoDigests, this.size, this.virtualSize, this.labels);
    }

    public final ImmutableImage withRepoTags(@Nullable Iterable<String> elements) {
        if (this.repoTags == elements) {
            return this;
        }
        List<String> newValue = elements == null ? null : ImmutableImage.createUnmodifiableList(false, ImmutableImage.createSafeList(elements, true, false));
        return new ImmutableImage(this.created, this.id, this.parentId, newValue, this.repoDigests, this.size, this.virtualSize, this.labels);
    }

    public final ImmutableImage withRepoDigests(String ... elements) {
        if (elements == null) {
            return new ImmutableImage(this.created, this.id, this.parentId, this.repoTags, null, this.size, this.virtualSize, this.labels);
        }
        List<String> newValue = Arrays.asList(elements) == null ? null : ImmutableImage.createUnmodifiableList(false, ImmutableImage.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableImage(this.created, this.id, this.parentId, this.repoTags, newValue, this.size, this.virtualSize, this.labels);
    }

    public final ImmutableImage withRepoDigests(@Nullable Iterable<String> elements) {
        if (this.repoDigests == elements) {
            return this;
        }
        List<String> newValue = elements == null ? null : ImmutableImage.createUnmodifiableList(false, ImmutableImage.createSafeList(elements, true, false));
        return new ImmutableImage(this.created, this.id, this.parentId, this.repoTags, newValue, this.size, this.virtualSize, this.labels);
    }

    public final ImmutableImage withSize(Long value) {
        Long newValue = Objects.requireNonNull(value, "size");
        if (this.size.equals(newValue)) {
            return this;
        }
        return new ImmutableImage(this.created, this.id, this.parentId, this.repoTags, this.repoDigests, newValue, this.virtualSize, this.labels);
    }

    public final ImmutableImage withVirtualSize(Long value) {
        Long newValue = Objects.requireNonNull(value, "virtualSize");
        if (this.virtualSize.equals(newValue)) {
            return this;
        }
        return new ImmutableImage(this.created, this.id, this.parentId, this.repoTags, this.repoDigests, this.size, newValue, this.labels);
    }

    public final ImmutableImage withLabels(@Nullable Map<String, ? extends String> entries) {
        if (this.labels == entries) {
            return this;
        }
        Map<String, String> newValue = entries == null ? null : ImmutableImage.createUnmodifiableMap(true, false, entries);
        return new ImmutableImage(this.created, this.id, this.parentId, this.repoTags, this.repoDigests, this.size, this.virtualSize, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableImage && this.equalTo(0, (ImmutableImage)another);
    }

    private boolean equalTo(int synthetic, ImmutableImage another) {
        return this.created.equals(another.created) && this.id.equals(another.id) && this.parentId.equals(another.parentId) && Objects.equals(this.repoTags, another.repoTags) && Objects.equals(this.repoDigests, another.repoDigests) && this.size.equals(another.size) && this.virtualSize.equals(another.virtualSize) && Objects.equals(this.labels, another.labels);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.created.hashCode();
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.parentId.hashCode();
        h += (h << 5) + Objects.hashCode(this.repoTags);
        h += (h << 5) + Objects.hashCode(this.repoDigests);
        h += (h << 5) + this.size.hashCode();
        h += (h << 5) + this.virtualSize.hashCode();
        h += (h << 5) + Objects.hashCode(this.labels);
        return h;
    }

    public String toString() {
        return "Image{created=" + this.created + ", id=" + this.id + ", parentId=" + this.parentId + ", repoTags=" + this.repoTags + ", repoDigests=" + this.repoDigests + ", size=" + this.size + ", virtualSize=" + this.virtualSize + ", labels=" + this.labels + "}";
    }

    public static ImmutableImage copyOf(Image instance) {
        if (instance instanceof ImmutableImage) {
            return (ImmutableImage)instance;
        }
        return ImmutableImage.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    if (v == null) {
                        Objects.requireNonNull(v, "value for key: " + k);
                    }
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    if (v == null) {
                        Objects.requireNonNull(v, "value for key: " + k);
                    }
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    static final class Builder {
        private static final long INIT_BIT_CREATED = 1L;
        private static final long INIT_BIT_ID = 2L;
        private static final long INIT_BIT_PARENT_ID = 4L;
        private static final long INIT_BIT_SIZE = 8L;
        private static final long INIT_BIT_VIRTUAL_SIZE = 16L;
        private long initBits = 31L;
        private String created;
        private String id;
        private String parentId;
        private List<String> repoTags = null;
        private List<String> repoDigests = null;
        private Long size;
        private Long virtualSize;
        private Map<String, String> labels = null;

        private Builder() {
        }

        public final Builder from(Image instance) {
            List<String> repoDigestsValue;
            Objects.requireNonNull(instance, "instance");
            this.created(instance.created());
            this.id(instance.id());
            this.parentId(instance.parentId());
            List<String> repoTagsValue = instance.repoTags();
            if (repoTagsValue != null) {
                this.addAllRepoTags(repoTagsValue);
            }
            if ((repoDigestsValue = instance.repoDigests()) != null) {
                this.addAllRepoDigests(repoDigestsValue);
            }
            this.size(instance.size());
            this.virtualSize(instance.virtualSize());
            Map<String, String> labelsValue = instance.labels();
            if (labelsValue != null) {
                this.putAllLabels(labelsValue);
            }
            return this;
        }

        @JsonProperty(value="Created")
        public final Builder created(String created) {
            this.created = Objects.requireNonNull(created, "created");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="Id")
        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="ParentId")
        public final Builder parentId(String parentId) {
            this.parentId = Objects.requireNonNull(parentId, "parentId");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder repoTag(String element) {
            if (this.repoTags == null) {
                this.repoTags = new ArrayList<String>();
            }
            this.repoTags.add(Objects.requireNonNull(element, "repoTags element"));
            return this;
        }

        public final Builder repoTags(String ... elements) {
            if (this.repoTags == null) {
                this.repoTags = new ArrayList<String>();
            }
            for (String element : elements) {
                this.repoTags.add(Objects.requireNonNull(element, "repoTags element"));
            }
            return this;
        }

        @JsonProperty(value="RepoTags")
        public final Builder repoTags(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.repoTags = null;
                return this;
            }
            this.repoTags = new ArrayList<String>();
            return this.addAllRepoTags(elements);
        }

        public final Builder addAllRepoTags(Iterable<String> elements) {
            Objects.requireNonNull(elements, "repoTags element");
            if (this.repoTags == null) {
                this.repoTags = new ArrayList<String>();
            }
            for (String element : elements) {
                this.repoTags.add(Objects.requireNonNull(element, "repoTags element"));
            }
            return this;
        }

        public final Builder repoDigest(String element) {
            if (this.repoDigests == null) {
                this.repoDigests = new ArrayList<String>();
            }
            this.repoDigests.add(Objects.requireNonNull(element, "repoDigests element"));
            return this;
        }

        public final Builder repoDigests(String ... elements) {
            if (this.repoDigests == null) {
                this.repoDigests = new ArrayList<String>();
            }
            for (String element : elements) {
                this.repoDigests.add(Objects.requireNonNull(element, "repoDigests element"));
            }
            return this;
        }

        @JsonProperty(value="RepoDigests")
        public final Builder repoDigests(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.repoDigests = null;
                return this;
            }
            this.repoDigests = new ArrayList<String>();
            return this.addAllRepoDigests(elements);
        }

        public final Builder addAllRepoDigests(Iterable<String> elements) {
            Objects.requireNonNull(elements, "repoDigests element");
            if (this.repoDigests == null) {
                this.repoDigests = new ArrayList<String>();
            }
            for (String element : elements) {
                this.repoDigests.add(Objects.requireNonNull(element, "repoDigests element"));
            }
            return this;
        }

        @JsonProperty(value="Size")
        public final Builder size(Long size) {
            this.size = Objects.requireNonNull(size, "size");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="VirtualSize")
        public final Builder virtualSize(Long virtualSize) {
            this.virtualSize = Objects.requireNonNull(virtualSize, "virtualSize");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder addLabel(String key, String value) {
            if (this.labels == null) {
                this.labels = new LinkedHashMap<String, String>();
            }
            this.labels.put(Objects.requireNonNull(key, "labels key"), value == null ? Objects.requireNonNull(value, "labels value for key: " + key) : value);
            return this;
        }

        public final Builder addLabel(Map.Entry<String, ? extends String> entry) {
            String v;
            if (this.labels == null) {
                this.labels = new LinkedHashMap<String, String>();
            }
            String k = entry.getKey();
            this.labels.put(Objects.requireNonNull(k, "labels key"), (v = entry.getValue()) == null ? Objects.requireNonNull(v, "labels value for key: " + k) : v);
            return this;
        }

        @JsonProperty(value="Labels")
        public final Builder labels(@Nullable Map<String, ? extends String> entries) {
            if (entries == null) {
                this.labels = null;
                return this;
            }
            this.labels = new LinkedHashMap<String, String>();
            return this.putAllLabels(entries);
        }

        public final Builder putAllLabels(Map<String, ? extends String> entries) {
            if (this.labels == null) {
                this.labels = new LinkedHashMap<String, String>();
            }
            for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
                String v;
                String k = e.getKey();
                this.labels.put(Objects.requireNonNull(k, "labels key"), (v = e.getValue()) == null ? Objects.requireNonNull(v, "labels value for key: " + k) : v);
            }
            return this;
        }

        public ImmutableImage build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableImage(this.created, this.id, this.parentId, this.repoTags == null ? null : ImmutableImage.createUnmodifiableList(true, this.repoTags), this.repoDigests == null ? null : ImmutableImage.createUnmodifiableList(true, this.repoDigests), this.size, this.virtualSize, this.labels == null ? null : ImmutableImage.createUnmodifiableMap(false, false, this.labels));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("created");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("parentId");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("size");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("virtualSize");
            }
            return "Cannot build Image, some of required attributes are not set " + attributes;
        }
    }
}

