/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.mandas.docker.Nullable;
import org.mandas.docker.client.messages.Descriptor;
import org.mandas.docker.client.messages.Distribution;
import org.mandas.docker.client.messages.Platform;

final class ImmutableDistribution
implements Distribution {
    private final Descriptor descriptor;
    @Nullable
    private final List<Platform> platforms;

    private ImmutableDistribution(Descriptor descriptor, @Nullable List<Platform> platforms) {
        this.descriptor = descriptor;
        this.platforms = platforms;
    }

    @Override
    @JsonProperty(value="Descriptor")
    public Descriptor descriptor() {
        return this.descriptor;
    }

    @Override
    @JsonProperty(value="Platforms")
    @Nullable
    public List<Platform> platforms() {
        return this.platforms;
    }

    public final ImmutableDistribution withDescriptor(Descriptor value) {
        if (this.descriptor == value) {
            return this;
        }
        Descriptor newValue = Objects.requireNonNull(value, "descriptor");
        return new ImmutableDistribution(newValue, this.platforms);
    }

    public final ImmutableDistribution withPlatforms(Platform ... elements) {
        if (elements == null) {
            return new ImmutableDistribution(this.descriptor, null);
        }
        List<Platform> newValue = Arrays.asList(elements) == null ? null : ImmutableDistribution.createUnmodifiableList(false, ImmutableDistribution.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableDistribution(this.descriptor, newValue);
    }

    public final ImmutableDistribution withPlatforms(@Nullable Iterable<? extends Platform> elements) {
        if (this.platforms == elements) {
            return this;
        }
        List<Platform> newValue = elements == null ? null : ImmutableDistribution.createUnmodifiableList(false, ImmutableDistribution.createSafeList(elements, true, false));
        return new ImmutableDistribution(this.descriptor, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDistribution && this.equalTo(0, (ImmutableDistribution)another);
    }

    private boolean equalTo(int synthetic, ImmutableDistribution another) {
        return this.descriptor.equals(another.descriptor) && Objects.equals(this.platforms, another.platforms);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.descriptor.hashCode();
        h += (h << 5) + Objects.hashCode(this.platforms);
        return h;
    }

    public String toString() {
        return "Distribution{descriptor=" + this.descriptor + ", platforms=" + this.platforms + "}";
    }

    public static ImmutableDistribution copyOf(Distribution instance) {
        if (instance instanceof ImmutableDistribution) {
            return (ImmutableDistribution)instance;
        }
        return ImmutableDistribution.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    static final class Builder
    implements Distribution.Builder {
        private static final long INIT_BIT_DESCRIPTOR = 1L;
        private long initBits = 1L;
        private Descriptor descriptor;
        private List<Platform> platforms = null;

        private Builder() {
        }

        public final Builder from(Distribution instance) {
            Objects.requireNonNull(instance, "instance");
            this.descriptor(instance.descriptor());
            List<Platform> platformsValue = instance.platforms();
            if (platformsValue != null) {
                this.addAllPlatforms(platformsValue);
            }
            return this;
        }

        @Override
        @JsonProperty(value="Descriptor")
        public final Builder descriptor(Descriptor descriptor) {
            this.descriptor = Objects.requireNonNull(descriptor, "descriptor");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder platform(Platform element) {
            if (this.platforms == null) {
                this.platforms = new ArrayList<Platform>();
            }
            this.platforms.add(Objects.requireNonNull(element, "platforms element"));
            return this;
        }

        public final Builder platforms(Platform ... elements) {
            if (this.platforms == null) {
                this.platforms = new ArrayList<Platform>();
            }
            for (Platform element : elements) {
                this.platforms.add(Objects.requireNonNull(element, "platforms element"));
            }
            return this;
        }

        @Override
        @JsonProperty(value="Platforms")
        public final Builder platforms(@Nullable Iterable<? extends Platform> elements) {
            if (elements == null) {
                this.platforms = null;
                return this;
            }
            this.platforms = new ArrayList<Platform>();
            return this.addAllPlatforms(elements);
        }

        public final Builder addAllPlatforms(Iterable<? extends Platform> elements) {
            Objects.requireNonNull(elements, "platforms element");
            if (this.platforms == null) {
                this.platforms = new ArrayList<Platform>();
            }
            for (Platform platform : elements) {
                this.platforms.add(Objects.requireNonNull(platform, "platforms element"));
            }
            return this;
        }

        @Override
        public ImmutableDistribution build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableDistribution(this.descriptor, this.platforms == null ? null : ImmutableDistribution.createUnmodifiableList(true, this.platforms));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("descriptor");
            }
            return "Cannot build Distribution, some of required attributes are not set " + attributes;
        }
    }
}

