/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.mandas.docker.Nullable;
import org.mandas.docker.client.messages.ContainerState;

final class ImmutableContainerState
implements ContainerState {
    @Nullable
    private final String status;
    private final boolean running;
    private final boolean paused;
    @Nullable
    private final Boolean restarting;
    private final Integer pid;
    private final Long exitCode;
    private final Date startedAt;
    private final Date finishedAt;
    @Nullable
    private final String error;
    @Nullable
    private final Boolean oomKilled;
    @Nullable
    private final ContainerState.Health health;

    private ImmutableContainerState(@Nullable String status, boolean running, boolean paused, @Nullable Boolean restarting, Integer pid, Long exitCode, Date startedAt, Date finishedAt, @Nullable String error, @Nullable Boolean oomKilled, @Nullable ContainerState.Health health) {
        this.status = status;
        this.running = running;
        this.paused = paused;
        this.restarting = restarting;
        this.pid = pid;
        this.exitCode = exitCode;
        this.startedAt = startedAt;
        this.finishedAt = finishedAt;
        this.error = error;
        this.oomKilled = oomKilled;
        this.health = health;
    }

    @Override
    @JsonProperty(value="Status")
    @Nullable
    public String status() {
        return this.status;
    }

    @Override
    @JsonProperty(value="Running")
    public boolean running() {
        return this.running;
    }

    @Override
    @JsonProperty(value="Paused")
    public boolean paused() {
        return this.paused;
    }

    @Override
    @JsonProperty(value="Restarting")
    @Nullable
    public Boolean restarting() {
        return this.restarting;
    }

    @Override
    @JsonProperty(value="Pid")
    public Integer pid() {
        return this.pid;
    }

    @Override
    @JsonProperty(value="ExitCode")
    public Long exitCode() {
        return this.exitCode;
    }

    @Override
    @JsonProperty(value="StartedAt")
    public Date startedAt() {
        return this.startedAt;
    }

    @Override
    @JsonProperty(value="FinishedAt")
    public Date finishedAt() {
        return this.finishedAt;
    }

    @Override
    @JsonProperty(value="Error")
    @Nullable
    public String error() {
        return this.error;
    }

    @Override
    @JsonProperty(value="OOMKilled")
    @Nullable
    public Boolean oomKilled() {
        return this.oomKilled;
    }

    @Override
    @JsonProperty(value="Health")
    @Nullable
    public ContainerState.Health health() {
        return this.health;
    }

    public final ImmutableContainerState withStatus(@Nullable String value) {
        if (Objects.equals(this.status, value)) {
            return this;
        }
        return new ImmutableContainerState(value, this.running, this.paused, this.restarting, this.pid, this.exitCode, this.startedAt, this.finishedAt, this.error, this.oomKilled, this.health);
    }

    public final ImmutableContainerState withRunning(boolean value) {
        if (this.running == value) {
            return this;
        }
        return new ImmutableContainerState(this.status, value, this.paused, this.restarting, this.pid, this.exitCode, this.startedAt, this.finishedAt, this.error, this.oomKilled, this.health);
    }

    public final ImmutableContainerState withPaused(boolean value) {
        if (this.paused == value) {
            return this;
        }
        return new ImmutableContainerState(this.status, this.running, value, this.restarting, this.pid, this.exitCode, this.startedAt, this.finishedAt, this.error, this.oomKilled, this.health);
    }

    public final ImmutableContainerState withRestarting(@Nullable Boolean value) {
        if (Objects.equals(this.restarting, value)) {
            return this;
        }
        return new ImmutableContainerState(this.status, this.running, this.paused, value, this.pid, this.exitCode, this.startedAt, this.finishedAt, this.error, this.oomKilled, this.health);
    }

    public final ImmutableContainerState withPid(Integer value) {
        Integer newValue = Objects.requireNonNull(value, "pid");
        if (this.pid.equals(newValue)) {
            return this;
        }
        return new ImmutableContainerState(this.status, this.running, this.paused, this.restarting, newValue, this.exitCode, this.startedAt, this.finishedAt, this.error, this.oomKilled, this.health);
    }

    public final ImmutableContainerState withExitCode(Long value) {
        Long newValue = Objects.requireNonNull(value, "exitCode");
        if (this.exitCode.equals(newValue)) {
            return this;
        }
        return new ImmutableContainerState(this.status, this.running, this.paused, this.restarting, this.pid, newValue, this.startedAt, this.finishedAt, this.error, this.oomKilled, this.health);
    }

    public final ImmutableContainerState withStartedAt(Date value) {
        if (this.startedAt == value) {
            return this;
        }
        Date newValue = Objects.requireNonNull(value, "startedAt");
        return new ImmutableContainerState(this.status, this.running, this.paused, this.restarting, this.pid, this.exitCode, newValue, this.finishedAt, this.error, this.oomKilled, this.health);
    }

    public final ImmutableContainerState withFinishedAt(Date value) {
        if (this.finishedAt == value) {
            return this;
        }
        Date newValue = Objects.requireNonNull(value, "finishedAt");
        return new ImmutableContainerState(this.status, this.running, this.paused, this.restarting, this.pid, this.exitCode, this.startedAt, newValue, this.error, this.oomKilled, this.health);
    }

    public final ImmutableContainerState withError(@Nullable String value) {
        if (Objects.equals(this.error, value)) {
            return this;
        }
        return new ImmutableContainerState(this.status, this.running, this.paused, this.restarting, this.pid, this.exitCode, this.startedAt, this.finishedAt, value, this.oomKilled, this.health);
    }

    public final ImmutableContainerState withOomKilled(@Nullable Boolean value) {
        if (Objects.equals(this.oomKilled, value)) {
            return this;
        }
        return new ImmutableContainerState(this.status, this.running, this.paused, this.restarting, this.pid, this.exitCode, this.startedAt, this.finishedAt, this.error, value, this.health);
    }

    public final ImmutableContainerState withHealth(@Nullable ContainerState.Health value) {
        if (this.health == value) {
            return this;
        }
        return new ImmutableContainerState(this.status, this.running, this.paused, this.restarting, this.pid, this.exitCode, this.startedAt, this.finishedAt, this.error, this.oomKilled, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableContainerState && this.equalTo(0, (ImmutableContainerState)another);
    }

    private boolean equalTo(int synthetic, ImmutableContainerState another) {
        return Objects.equals(this.status, another.status) && this.running == another.running && this.paused == another.paused && Objects.equals(this.restarting, another.restarting) && this.pid.equals(another.pid) && this.exitCode.equals(another.exitCode) && this.startedAt.equals(another.startedAt) && this.finishedAt.equals(another.finishedAt) && Objects.equals(this.error, another.error) && Objects.equals(this.oomKilled, another.oomKilled) && Objects.equals(this.health, another.health);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.status);
        h += (h << 5) + Boolean.hashCode(this.running);
        h += (h << 5) + Boolean.hashCode(this.paused);
        h += (h << 5) + Objects.hashCode(this.restarting);
        h += (h << 5) + this.pid.hashCode();
        h += (h << 5) + this.exitCode.hashCode();
        h += (h << 5) + this.startedAt.hashCode();
        h += (h << 5) + this.finishedAt.hashCode();
        h += (h << 5) + Objects.hashCode(this.error);
        h += (h << 5) + Objects.hashCode(this.oomKilled);
        h += (h << 5) + Objects.hashCode(this.health);
        return h;
    }

    public String toString() {
        return "ContainerState{status=" + this.status + ", running=" + this.running + ", paused=" + this.paused + ", restarting=" + this.restarting + ", pid=" + this.pid + ", exitCode=" + this.exitCode + ", startedAt=" + this.startedAt + ", finishedAt=" + this.finishedAt + ", error=" + this.error + ", oomKilled=" + this.oomKilled + ", health=" + this.health + "}";
    }

    public static ImmutableContainerState copyOf(ContainerState instance) {
        if (instance instanceof ImmutableContainerState) {
            return (ImmutableContainerState)instance;
        }
        return ImmutableContainerState.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    static final class Builder {
        private static final long INIT_BIT_RUNNING = 1L;
        private static final long INIT_BIT_PAUSED = 2L;
        private static final long INIT_BIT_PID = 4L;
        private static final long INIT_BIT_EXIT_CODE = 8L;
        private static final long INIT_BIT_STARTED_AT = 16L;
        private static final long INIT_BIT_FINISHED_AT = 32L;
        private long initBits = 63L;
        private String status;
        private boolean running;
        private boolean paused;
        private Boolean restarting;
        private Integer pid;
        private Long exitCode;
        private Date startedAt;
        private Date finishedAt;
        private String error;
        private Boolean oomKilled;
        private ContainerState.Health health;

        private Builder() {
        }

        public final Builder from(ContainerState instance) {
            ContainerState.Health healthValue;
            Boolean oomKilledValue;
            Objects.requireNonNull(instance, "instance");
            String statusValue = instance.status();
            if (statusValue != null) {
                this.status(statusValue);
            }
            this.running(instance.running());
            this.paused(instance.paused());
            Boolean restartingValue = instance.restarting();
            if (restartingValue != null) {
                this.restarting(restartingValue);
            }
            this.pid(instance.pid());
            this.exitCode(instance.exitCode());
            this.startedAt(instance.startedAt());
            this.finishedAt(instance.finishedAt());
            String errorValue = instance.error();
            if (errorValue != null) {
                this.error(errorValue);
            }
            if ((oomKilledValue = instance.oomKilled()) != null) {
                this.oomKilled(oomKilledValue);
            }
            if ((healthValue = instance.health()) != null) {
                this.health(healthValue);
            }
            return this;
        }

        @JsonProperty(value="Status")
        public final Builder status(@Nullable String status) {
            this.status = status;
            return this;
        }

        @JsonProperty(value="Running")
        public final Builder running(boolean running) {
            this.running = running;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="Paused")
        public final Builder paused(boolean paused) {
            this.paused = paused;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="Restarting")
        public final Builder restarting(@Nullable Boolean restarting) {
            this.restarting = restarting;
            return this;
        }

        @JsonProperty(value="Pid")
        public final Builder pid(Integer pid) {
            this.pid = Objects.requireNonNull(pid, "pid");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="ExitCode")
        public final Builder exitCode(Long exitCode) {
            this.exitCode = Objects.requireNonNull(exitCode, "exitCode");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="StartedAt")
        public final Builder startedAt(Date startedAt) {
            this.startedAt = Objects.requireNonNull(startedAt, "startedAt");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @JsonProperty(value="FinishedAt")
        public final Builder finishedAt(Date finishedAt) {
            this.finishedAt = Objects.requireNonNull(finishedAt, "finishedAt");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        @JsonProperty(value="Error")
        public final Builder error(@Nullable String error) {
            this.error = error;
            return this;
        }

        @JsonProperty(value="OOMKilled")
        public final Builder oomKilled(@Nullable Boolean oomKilled) {
            this.oomKilled = oomKilled;
            return this;
        }

        @JsonProperty(value="Health")
        public final Builder health(@Nullable ContainerState.Health health) {
            this.health = health;
            return this;
        }

        public ImmutableContainerState build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableContainerState(this.status, this.running, this.paused, this.restarting, this.pid, this.exitCode, this.startedAt, this.finishedAt, this.error, this.oomKilled, this.health);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("running");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("paused");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("pid");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("exitCode");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("startedAt");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("finishedAt");
            }
            return "Cannot build ContainerState, some of required attributes are not set " + attributes;
        }
    }

    static final class Health
    implements ContainerState.Health {
        private final String status;
        private final Integer failingStreak;
        private final List<ContainerState.HealthLog> log;

        private Health(String status, Integer failingStreak, List<ContainerState.HealthLog> log) {
            this.status = status;
            this.failingStreak = failingStreak;
            this.log = log;
        }

        @Override
        @JsonProperty(value="Status")
        public String status() {
            return this.status;
        }

        @Override
        @JsonProperty(value="FailingStreak")
        public Integer failingStreak() {
            return this.failingStreak;
        }

        @Override
        @JsonProperty(value="Log")
        public List<ContainerState.HealthLog> log() {
            return this.log;
        }

        public final Health withStatus(String value) {
            String newValue = Objects.requireNonNull(value, "status");
            if (this.status.equals(newValue)) {
                return this;
            }
            return new Health(newValue, this.failingStreak, this.log);
        }

        public final Health withFailingStreak(Integer value) {
            Integer newValue = Objects.requireNonNull(value, "failingStreak");
            if (this.failingStreak.equals(newValue)) {
                return this;
            }
            return new Health(this.status, newValue, this.log);
        }

        public final Health withLog(ContainerState.HealthLog ... elements) {
            List<ContainerState.HealthLog> newValue = ImmutableContainerState.createUnmodifiableList(false, ImmutableContainerState.createSafeList(Arrays.asList(elements), true, false));
            return new Health(this.status, this.failingStreak, newValue);
        }

        public final Health withLog(Iterable<? extends ContainerState.HealthLog> elements) {
            if (this.log == elements) {
                return this;
            }
            List<ContainerState.HealthLog> newValue = ImmutableContainerState.createUnmodifiableList(false, ImmutableContainerState.createSafeList(elements, true, false));
            return new Health(this.status, this.failingStreak, newValue);
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof Health && this.equalTo(0, (Health)another);
        }

        private boolean equalTo(int synthetic, Health another) {
            return this.status.equals(another.status) && this.failingStreak.equals(another.failingStreak) && this.log.equals(another.log);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.status.hashCode();
            h += (h << 5) + this.failingStreak.hashCode();
            h += (h << 5) + this.log.hashCode();
            return h;
        }

        public String toString() {
            return "Health{status=" + this.status + ", failingStreak=" + this.failingStreak + ", log=" + this.log + "}";
        }

        public static Health copyOf(ContainerState.Health instance) {
            if (instance instanceof Health) {
                return (Health)instance;
            }
            return Health.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        static final class Builder {
            private static final long INIT_BIT_STATUS = 1L;
            private static final long INIT_BIT_FAILING_STREAK = 2L;
            private long initBits = 3L;
            private String status;
            private Integer failingStreak;
            private List<ContainerState.HealthLog> log = new ArrayList<ContainerState.HealthLog>();

            private Builder() {
            }

            public final Builder from(ContainerState.Health instance) {
                Objects.requireNonNull(instance, "instance");
                this.status(instance.status());
                this.failingStreak(instance.failingStreak());
                this.addAllLog(instance.log());
                return this;
            }

            @JsonProperty(value="Status")
            public final Builder status(String status) {
                this.status = Objects.requireNonNull(status, "status");
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            @JsonProperty(value="FailingStreak")
            public final Builder failingStreak(Integer failingStreak) {
                this.failingStreak = Objects.requireNonNull(failingStreak, "failingStreak");
                this.initBits &= 0xFFFFFFFFFFFFFFFDL;
                return this;
            }

            public final Builder log(ContainerState.HealthLog element) {
                this.log.add(Objects.requireNonNull(element, "log element"));
                return this;
            }

            public final Builder log(ContainerState.HealthLog ... elements) {
                for (ContainerState.HealthLog element : elements) {
                    this.log.add(Objects.requireNonNull(element, "log element"));
                }
                return this;
            }

            @JsonProperty(value="Log")
            public final Builder log(Iterable<? extends ContainerState.HealthLog> elements) {
                this.log.clear();
                return this.addAllLog(elements);
            }

            public final Builder addAllLog(Iterable<? extends ContainerState.HealthLog> elements) {
                for (ContainerState.HealthLog healthLog : elements) {
                    this.log.add(Objects.requireNonNull(healthLog, "log element"));
                }
                return this;
            }

            public Health build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new Health(this.status, this.failingStreak, ImmutableContainerState.createUnmodifiableList(true, this.log));
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("status");
                }
                if ((this.initBits & 2L) != 0L) {
                    attributes.add("failingStreak");
                }
                return "Cannot build Health, some of required attributes are not set " + attributes;
            }
        }
    }

    static final class HealthLog
    implements ContainerState.HealthLog {
        private final Date start;
        private final Date end;
        private final Long exitCode;
        private final String output;

        private HealthLog(Date start, Date end, Long exitCode, String output) {
            this.start = start;
            this.end = end;
            this.exitCode = exitCode;
            this.output = output;
        }

        @Override
        @JsonProperty(value="Start")
        public Date start() {
            return this.start;
        }

        @Override
        @JsonProperty(value="End")
        public Date end() {
            return this.end;
        }

        @Override
        @JsonProperty(value="ExitCode")
        public Long exitCode() {
            return this.exitCode;
        }

        @Override
        @JsonProperty(value="Output")
        public String output() {
            return this.output;
        }

        public final HealthLog withStart(Date value) {
            if (this.start == value) {
                return this;
            }
            Date newValue = Objects.requireNonNull(value, "start");
            return new HealthLog(newValue, this.end, this.exitCode, this.output);
        }

        public final HealthLog withEnd(Date value) {
            if (this.end == value) {
                return this;
            }
            Date newValue = Objects.requireNonNull(value, "end");
            return new HealthLog(this.start, newValue, this.exitCode, this.output);
        }

        public final HealthLog withExitCode(Long value) {
            Long newValue = Objects.requireNonNull(value, "exitCode");
            if (this.exitCode.equals(newValue)) {
                return this;
            }
            return new HealthLog(this.start, this.end, newValue, this.output);
        }

        public final HealthLog withOutput(String value) {
            String newValue = Objects.requireNonNull(value, "output");
            if (this.output.equals(newValue)) {
                return this;
            }
            return new HealthLog(this.start, this.end, this.exitCode, newValue);
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof HealthLog && this.equalTo(0, (HealthLog)another);
        }

        private boolean equalTo(int synthetic, HealthLog another) {
            return this.start.equals(another.start) && this.end.equals(another.end) && this.exitCode.equals(another.exitCode) && this.output.equals(another.output);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.start.hashCode();
            h += (h << 5) + this.end.hashCode();
            h += (h << 5) + this.exitCode.hashCode();
            h += (h << 5) + this.output.hashCode();
            return h;
        }

        public String toString() {
            return "HealthLog{start=" + this.start + ", end=" + this.end + ", exitCode=" + this.exitCode + ", output=" + this.output + "}";
        }

        public static HealthLog copyOf(ContainerState.HealthLog instance) {
            if (instance instanceof HealthLog) {
                return (HealthLog)instance;
            }
            return HealthLog.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        static final class Builder {
            private static final long INIT_BIT_START = 1L;
            private static final long INIT_BIT_END = 2L;
            private static final long INIT_BIT_EXIT_CODE = 4L;
            private static final long INIT_BIT_OUTPUT = 8L;
            private long initBits = 15L;
            private Date start;
            private Date end;
            private Long exitCode;
            private String output;

            private Builder() {
            }

            public final Builder from(ContainerState.HealthLog instance) {
                Objects.requireNonNull(instance, "instance");
                this.start(instance.start());
                this.end(instance.end());
                this.exitCode(instance.exitCode());
                this.output(instance.output());
                return this;
            }

            @JsonProperty(value="Start")
            public final Builder start(Date start) {
                this.start = Objects.requireNonNull(start, "start");
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            @JsonProperty(value="End")
            public final Builder end(Date end) {
                this.end = Objects.requireNonNull(end, "end");
                this.initBits &= 0xFFFFFFFFFFFFFFFDL;
                return this;
            }

            @JsonProperty(value="ExitCode")
            public final Builder exitCode(Long exitCode) {
                this.exitCode = Objects.requireNonNull(exitCode, "exitCode");
                this.initBits &= 0xFFFFFFFFFFFFFFFBL;
                return this;
            }

            @JsonProperty(value="Output")
            public final Builder output(String output) {
                this.output = Objects.requireNonNull(output, "output");
                this.initBits &= 0xFFFFFFFFFFFFFFF7L;
                return this;
            }

            public HealthLog build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new HealthLog(this.start, this.end, this.exitCode, this.output);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("start");
                }
                if ((this.initBits & 2L) != 0L) {
                    attributes.add("end");
                }
                if ((this.initBits & 4L) != 0L) {
                    attributes.add("exitCode");
                }
                if ((this.initBits & 8L) != 0L) {
                    attributes.add("output");
                }
                return "Cannot build HealthLog, some of required attributes are not set " + attributes;
            }
        }
    }
}

