package org.mandas.docker.client.messages.swarm;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * Immutable implementation of {@link RemoteManager}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableRemoteManager.builder()}.
 */
@SuppressWarnings({"all"})
final class ImmutableRemoteManager implements RemoteManager {
  private final String addr;
  private final String nodeId;

  private ImmutableRemoteManager(String addr, String nodeId) {
    this.addr = addr;
    this.nodeId = nodeId;
  }

  /**
   * @return The value of the {@code addr} attribute
   */
  @JsonProperty("Addr")
  @Override
  public String addr() {
    return addr;
  }

  /**
   * @return The value of the {@code nodeId} attribute
   */
  @JsonProperty("NodeID")
  @Override
  public String nodeId() {
    return nodeId;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RemoteManager#addr() addr} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for addr
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRemoteManager withAddr(String value) {
    String newValue = Objects.requireNonNull(value, "addr");
    if (this.addr.equals(newValue)) return this;
    return new ImmutableRemoteManager(newValue, this.nodeId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RemoteManager#nodeId() nodeId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for nodeId
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRemoteManager withNodeId(String value) {
    String newValue = Objects.requireNonNull(value, "nodeId");
    if (this.nodeId.equals(newValue)) return this;
    return new ImmutableRemoteManager(this.addr, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableRemoteManager} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableRemoteManager
        && equalTo(0, (ImmutableRemoteManager) another);
  }

  private boolean equalTo(int synthetic, ImmutableRemoteManager another) {
    return addr.equals(another.addr)
        && nodeId.equals(another.nodeId);
  }

  /**
   * Computes a hash code from attributes: {@code addr}, {@code nodeId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + addr.hashCode();
    h += (h << 5) + nodeId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code RemoteManager} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "RemoteManager{"
        + "addr=" + addr
        + ", nodeId=" + nodeId
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link RemoteManager} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable RemoteManager instance
   */
  public static ImmutableRemoteManager copyOf(RemoteManager instance) {
    if (instance instanceof ImmutableRemoteManager) {
      return (ImmutableRemoteManager) instance;
    }
    return ImmutableRemoteManager.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableRemoteManager ImmutableRemoteManager}.
   * <pre>
   * ImmutableRemoteManager.builder()
   *    .addr(String) // required {@link RemoteManager#addr() addr}
   *    .nodeId(String) // required {@link RemoteManager#nodeId() nodeId}
   *    .build();
   * </pre>
   * @return A new ImmutableRemoteManager builder
   */
  public static ImmutableRemoteManager.Builder builder() {
    return new ImmutableRemoteManager.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableRemoteManager ImmutableRemoteManager}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  static final class Builder {
    private static final long INIT_BIT_ADDR = 0x1L;
    private static final long INIT_BIT_NODE_ID = 0x2L;
    private long initBits = 0x3L;

    private String addr;
    private String nodeId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code RemoteManager} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(RemoteManager instance) {
      Objects.requireNonNull(instance, "instance");
      addr(instance.addr());
      nodeId(instance.nodeId());
      return this;
    }

    /**
     * Initializes the value for the {@link RemoteManager#addr() addr} attribute.
     * @param addr The value for addr 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("Addr")
    public final Builder addr(String addr) {
      this.addr = Objects.requireNonNull(addr, "addr");
      initBits &= ~INIT_BIT_ADDR;
      return this;
    }

    /**
     * Initializes the value for the {@link RemoteManager#nodeId() nodeId} attribute.
     * @param nodeId The value for nodeId 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("NodeID")
    public final Builder nodeId(String nodeId) {
      this.nodeId = Objects.requireNonNull(nodeId, "nodeId");
      initBits &= ~INIT_BIT_NODE_ID;
      return this;
    }

    /**
     * Builds a new {@link ImmutableRemoteManager ImmutableRemoteManager}.
     * @return An immutable instance of RemoteManager
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableRemoteManager build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableRemoteManager(addr, nodeId);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ADDR) != 0) attributes.add("addr");
      if ((initBits & INIT_BIT_NODE_ID) != 0) attributes.add("nodeId");
      return "Cannot build RemoteManager, some of required attributes are not set " + attributes;
    }
  }
}
