package org.mandas.docker.client.messages;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.mandas.docker.Nullable;

/**
 * Immutable implementation of {@link ContainerInfo}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableContainerInfo.builder()}.
 */
@SuppressWarnings({"all"})
final class ImmutableContainerInfo implements ContainerInfo {
  private final @Nullable String id;
  private final Date created;
  private final String path;
  private final List<String> args;
  private final ContainerConfig config;
  private final @Nullable HostConfig hostConfig;
  private final ContainerState state;
  private final String image;
  private final NetworkSettings networkSettings;
  private final String resolvConfPath;
  private final String hostnamePath;
  private final String hostsPath;
  private final String name;
  private final String driver;
  private final @Nullable String execDriver;
  private final String processLabel;
  private final String mountLabel;
  private final String appArmorProfile;
  private final @Nullable List<String> execIds;
  private final String logPath;
  private final Long restartCount;
  private final @Nullable List<ContainerMount> mounts;
  private final @Nullable ContainerInfo.Node node;

  private ImmutableContainerInfo(
      @Nullable String id,
      Date created,
      String path,
      List<String> args,
      ContainerConfig config,
      @Nullable HostConfig hostConfig,
      ContainerState state,
      String image,
      NetworkSettings networkSettings,
      String resolvConfPath,
      String hostnamePath,
      String hostsPath,
      String name,
      String driver,
      @Nullable String execDriver,
      String processLabel,
      String mountLabel,
      String appArmorProfile,
      @Nullable List<String> execIds,
      String logPath,
      Long restartCount,
      @Nullable List<ContainerMount> mounts,
      @Nullable ContainerInfo.Node node) {
    this.id = id;
    this.created = created;
    this.path = path;
    this.args = args;
    this.config = config;
    this.hostConfig = hostConfig;
    this.state = state;
    this.image = image;
    this.networkSettings = networkSettings;
    this.resolvConfPath = resolvConfPath;
    this.hostnamePath = hostnamePath;
    this.hostsPath = hostsPath;
    this.name = name;
    this.driver = driver;
    this.execDriver = execDriver;
    this.processLabel = processLabel;
    this.mountLabel = mountLabel;
    this.appArmorProfile = appArmorProfile;
    this.execIds = execIds;
    this.logPath = logPath;
    this.restartCount = restartCount;
    this.mounts = mounts;
    this.node = node;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty("Id")
  @Override
  public @Nullable String id() {
    return id;
  }

  /**
   * @return The value of the {@code created} attribute
   */
  @JsonProperty("Created")
  @Override
  public Date created() {
    return created;
  }

  /**
   * @return The value of the {@code path} attribute
   */
  @JsonProperty("Path")
  @Override
  public String path() {
    return path;
  }

  /**
   * @return The value of the {@code args} attribute
   */
  @JsonProperty("Args")
  @Override
  public List<String> args() {
    return args;
  }

  /**
   * @return The value of the {@code config} attribute
   */
  @JsonProperty("Config")
  @Override
  public ContainerConfig config() {
    return config;
  }

  /**
   * @return The value of the {@code hostConfig} attribute
   */
  @JsonProperty("HostConfig")
  @Override
  public @Nullable HostConfig hostConfig() {
    return hostConfig;
  }

  /**
   * @return The value of the {@code state} attribute
   */
  @JsonProperty("State")
  @Override
  public ContainerState state() {
    return state;
  }

  /**
   * @return The value of the {@code image} attribute
   */
  @JsonProperty("Image")
  @Override
  public String image() {
    return image;
  }

  /**
   * @return The value of the {@code networkSettings} attribute
   */
  @JsonProperty("NetworkSettings")
  @Override
  public NetworkSettings networkSettings() {
    return networkSettings;
  }

  /**
   * @return The value of the {@code resolvConfPath} attribute
   */
  @JsonProperty("ResolvConfPath")
  @Override
  public String resolvConfPath() {
    return resolvConfPath;
  }

  /**
   * @return The value of the {@code hostnamePath} attribute
   */
  @JsonProperty("HostnamePath")
  @Override
  public String hostnamePath() {
    return hostnamePath;
  }

  /**
   * @return The value of the {@code hostsPath} attribute
   */
  @JsonProperty("HostsPath")
  @Override
  public String hostsPath() {
    return hostsPath;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty("Name")
  @Override
  public String name() {
    return name;
  }

  /**
   * @return The value of the {@code driver} attribute
   */
  @JsonProperty("Driver")
  @Override
  public String driver() {
    return driver;
  }

  /**
   * @return The value of the {@code execDriver} attribute
   */
  @JsonProperty("ExecDriver")
  @Override
  public @Nullable String execDriver() {
    return execDriver;
  }

  /**
   * @return The value of the {@code processLabel} attribute
   */
  @JsonProperty("ProcessLabel")
  @Override
  public String processLabel() {
    return processLabel;
  }

  /**
   * @return The value of the {@code mountLabel} attribute
   */
  @JsonProperty("MountLabel")
  @Override
  public String mountLabel() {
    return mountLabel;
  }

  /**
   * @return The value of the {@code appArmorProfile} attribute
   */
  @JsonProperty("AppArmorProfile")
  @Override
  public String appArmorProfile() {
    return appArmorProfile;
  }

  /**
   * @return The value of the {@code execIds} attribute
   */
  @JsonProperty("ExecIDs")
  @Override
  public @Nullable List<String> execIds() {
    return execIds;
  }

  /**
   * @return The value of the {@code logPath} attribute
   */
  @JsonProperty("LogPath")
  @Override
  public String logPath() {
    return logPath;
  }

  /**
   * @return The value of the {@code restartCount} attribute
   */
  @JsonProperty("RestartCount")
  @Override
  public Long restartCount() {
    return restartCount;
  }

  /**
   * @return The value of the {@code mounts} attribute
   */
  @JsonProperty("Mounts")
  @Override
  public @Nullable List<ContainerMount> mounts() {
    return mounts;
  }

  /**
   * @return The value of the {@code node} attribute
   */
  @JsonProperty("Node")
  @Override
  public @Nullable ContainerInfo.Node node() {
    return node;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ContainerInfo#id() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableContainerInfo withId(@Nullable String value) {
    if (Objects.equals(this.id, value)) return this;
    return new ImmutableContainerInfo(
        value,
        this.created,
        this.path,
        this.args,
        this.config,
        this.hostConfig,
        this.state,
        this.image,
        this.networkSettings,
        this.resolvConfPath,
        this.hostnamePath,
        this.hostsPath,
        this.name,
        this.driver,
        this.execDriver,
        this.processLabel,
        this.mountLabel,
        this.appArmorProfile,
        this.execIds,
        this.logPath,
        this.restartCount,
        this.mounts,
        this.node);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ContainerInfo#created() created} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for created
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableContainerInfo withCreated(Date value) {
    if (this.created == value) return this;
    Date newValue = Objects.requireNonNull(value, "created");
    return new ImmutableContainerInfo(
        this.id,
        newValue,
        this.path,
        this.args,
        this.config,
        this.hostConfig,
        this.state,
        this.image,
        this.networkSettings,
        this.resolvConfPath,
        this.hostnamePath,
        this.hostsPath,
        this.name,
        this.driver,
        this.execDriver,
        this.processLabel,
        this.mountLabel,
        this.appArmorProfile,
        this.execIds,
        this.logPath,
        this.restartCount,
        this.mounts,
        this.node);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ContainerInfo#path() path} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for path
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableContainerInfo withPath(String value) {
    String newValue = Objects.requireNonNull(value, "path");
    if (this.path.equals(newValue)) return this;
    return new ImmutableContainerInfo(
        this.id,
        this.created,
        newValue,
        this.args,
        this.config,
        this.hostConfig,
        this.state,
        this.image,
        this.networkSettings,
        this.resolvConfPath,
        this.hostnamePath,
        this.hostsPath,
        this.name,
        this.driver,
        this.execDriver,
        this.processLabel,
        this.mountLabel,
        this.appArmorProfile,
        this.execIds,
        this.logPath,
        this.restartCount,
        this.mounts,
        this.node);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ContainerInfo#args() args}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableContainerInfo withArgs(String... elements) {
    List<String> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableContainerInfo(
        this.id,
        this.created,
        this.path,
        newValue,
        this.config,
        this.hostConfig,
        this.state,
        this.image,
        this.networkSettings,
        this.resolvConfPath,
        this.hostnamePath,
        this.hostsPath,
        this.name,
        this.driver,
        this.execDriver,
        this.processLabel,
        this.mountLabel,
        this.appArmorProfile,
        this.execIds,
        this.logPath,
        this.restartCount,
        this.mounts,
        this.node);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ContainerInfo#args() args}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of args elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableContainerInfo withArgs(Iterable<String> elements) {
    if (this.args == elements) return this;
    List<String> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableContainerInfo(
        this.id,
        this.created,
        this.path,
        newValue,
        this.config,
        this.hostConfig,
        this.state,
        this.image,
        this.networkSettings,
        this.resolvConfPath,
        this.hostnamePath,
        this.hostsPath,
        this.name,
        this.driver,
        this.execDriver,
        this.processLabel,
        this.mountLabel,
        this.appArmorProfile,
        this.execIds,
        this.logPath,
        this.restartCount,
        this.mounts,
        this.node);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ContainerInfo#config() config} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for config
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableContainerInfo withConfig(ContainerConfig value) {
    if (this.config == value) return this;
    ContainerConfig newValue = Objects.requireNonNull(value, "config");
    return new ImmutableContainerInfo(
        this.id,
        this.created,
        this.path,
        this.args,
        newValue,
        this.hostConfig,
        this.state,
        this.image,
        this.networkSettings,
        this.resolvConfPath,
        this.hostnamePath,
        this.hostsPath,
        this.name,
        this.driver,
        this.execDriver,
        this.processLabel,
        this.mountLabel,
        this.appArmorProfile,
        this.execIds,
        this.logPath,
        this.restartCount,
        this.mounts,
        this.node);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ContainerInfo#hostConfig() hostConfig} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for hostConfig (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableContainerInfo withHostConfig(@Nullable HostConfig value) {
    if (this.hostConfig == value) return this;
    return new ImmutableContainerInfo(
        this.id,
        this.created,
        this.path,
        this.args,
        this.config,
        value,
        this.state,
        this.image,
        this.networkSettings,
        this.resolvConfPath,
        this.hostnamePath,
        this.hostsPath,
        this.name,
        this.driver,
        this.execDriver,
        this.processLabel,
        this.mountLabel,
        this.appArmorProfile,
        this.execIds,
        this.logPath,
        this.restartCount,
        this.mounts,
        this.node);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ContainerInfo#state() state} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for state
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableContainerInfo withState(ContainerState value) {
    if (this.state == value) return this;
    ContainerState newValue = Objects.requireNonNull(value, "state");
    return new ImmutableContainerInfo(
        this.id,
        this.created,
        this.path,
        this.args,
        this.config,
        this.hostConfig,
        newValue,
        this.image,
        this.networkSettings,
        this.resolvConfPath,
        this.hostnamePath,
        this.hostsPath,
        this.name,
        this.driver,
        this.execDriver,
        this.processLabel,
        this.mountLabel,
        this.appArmorProfile,
        this.execIds,
        this.logPath,
        this.restartCount,
        this.mounts,
        this.node);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ContainerInfo#image() image} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for image
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableContainerInfo withImage(String value) {
    String newValue = Objects.requireNonNull(value, "image");
    if (this.image.equals(newValue)) return this;
    return new ImmutableContainerInfo(
        this.id,
        this.created,
        this.path,
        this.args,
        this.config,
        this.hostConfig,
        this.state,
        newValue,
        this.networkSettings,
        this.resolvConfPath,
        this.hostnamePath,
        this.hostsPath,
        this.name,
        this.driver,
        this.execDriver,
        this.processLabel,
        this.mountLabel,
        this.appArmorProfile,
        this.execIds,
        this.logPath,
        this.restartCount,
        this.mounts,
        this.node);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ContainerInfo#networkSettings() networkSettings} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for networkSettings
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableContainerInfo withNetworkSettings(NetworkSettings value) {
    if (this.networkSettings == value) return this;
    NetworkSettings newValue = Objects.requireNonNull(value, "networkSettings");
    return new ImmutableContainerInfo(
        this.id,
        this.created,
        this.path,
        this.args,
        this.config,
        this.hostConfig,
        this.state,
        this.image,
        newValue,
        this.resolvConfPath,
        this.hostnamePath,
        this.hostsPath,
        this.name,
        this.driver,
        this.execDriver,
        this.processLabel,
        this.mountLabel,
        this.appArmorProfile,
        this.execIds,
        this.logPath,
        this.restartCount,
        this.mounts,
        this.node);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ContainerInfo#resolvConfPath() resolvConfPath} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for resolvConfPath
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableContainerInfo withResolvConfPath(String value) {
    String newValue = Objects.requireNonNull(value, "resolvConfPath");
    if (this.resolvConfPath.equals(newValue)) return this;
    return new ImmutableContainerInfo(
        this.id,
        this.created,
        this.path,
        this.args,
        this.config,
        this.hostConfig,
        this.state,
        this.image,
        this.networkSettings,
        newValue,
        this.hostnamePath,
        this.hostsPath,
        this.name,
        this.driver,
        this.execDriver,
        this.processLabel,
        this.mountLabel,
        this.appArmorProfile,
        this.execIds,
        this.logPath,
        this.restartCount,
        this.mounts,
        this.node);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ContainerInfo#hostnamePath() hostnamePath} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for hostnamePath
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableContainerInfo withHostnamePath(String value) {
    String newValue = Objects.requireNonNull(value, "hostnamePath");
    if (this.hostnamePath.equals(newValue)) return this;
    return new ImmutableContainerInfo(
        this.id,
        this.created,
        this.path,
        this.args,
        this.config,
        this.hostConfig,
        this.state,
        this.image,
        this.networkSettings,
        this.resolvConfPath,
        newValue,
        this.hostsPath,
        this.name,
        this.driver,
        this.execDriver,
        this.processLabel,
        this.mountLabel,
        this.appArmorProfile,
        this.execIds,
        this.logPath,
        this.restartCount,
        this.mounts,
        this.node);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ContainerInfo#hostsPath() hostsPath} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for hostsPath
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableContainerInfo withHostsPath(String value) {
    String newValue = Objects.requireNonNull(value, "hostsPath");
    if (this.hostsPath.equals(newValue)) return this;
    return new ImmutableContainerInfo(
        this.id,
        this.created,
        this.path,
        this.args,
        this.config,
        this.hostConfig,
        this.state,
        this.image,
        this.networkSettings,
        this.resolvConfPath,
        this.hostnamePath,
        newValue,
        this.name,
        this.driver,
        this.execDriver,
        this.processLabel,
        this.mountLabel,
        this.appArmorProfile,
        this.execIds,
        this.logPath,
        this.restartCount,
        this.mounts,
        this.node);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ContainerInfo#name() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableContainerInfo withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new ImmutableContainerInfo(
        this.id,
        this.created,
        this.path,
        this.args,
        this.config,
        this.hostConfig,
        this.state,
        this.image,
        this.networkSettings,
        this.resolvConfPath,
        this.hostnamePath,
        this.hostsPath,
        newValue,
        this.driver,
        this.execDriver,
        this.processLabel,
        this.mountLabel,
        this.appArmorProfile,
        this.execIds,
        this.logPath,
        this.restartCount,
        this.mounts,
        this.node);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ContainerInfo#driver() driver} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for driver
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableContainerInfo withDriver(String value) {
    String newValue = Objects.requireNonNull(value, "driver");
    if (this.driver.equals(newValue)) return this;
    return new ImmutableContainerInfo(
        this.id,
        this.created,
        this.path,
        this.args,
        this.config,
        this.hostConfig,
        this.state,
        this.image,
        this.networkSettings,
        this.resolvConfPath,
        this.hostnamePath,
        this.hostsPath,
        this.name,
        newValue,
        this.execDriver,
        this.processLabel,
        this.mountLabel,
        this.appArmorProfile,
        this.execIds,
        this.logPath,
        this.restartCount,
        this.mounts,
        this.node);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ContainerInfo#execDriver() execDriver} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for execDriver (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableContainerInfo withExecDriver(@Nullable String value) {
    if (Objects.equals(this.execDriver, value)) return this;
    return new ImmutableContainerInfo(
        this.id,
        this.created,
        this.path,
        this.args,
        this.config,
        this.hostConfig,
        this.state,
        this.image,
        this.networkSettings,
        this.resolvConfPath,
        this.hostnamePath,
        this.hostsPath,
        this.name,
        this.driver,
        value,
        this.processLabel,
        this.mountLabel,
        this.appArmorProfile,
        this.execIds,
        this.logPath,
        this.restartCount,
        this.mounts,
        this.node);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ContainerInfo#processLabel() processLabel} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for processLabel
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableContainerInfo withProcessLabel(String value) {
    String newValue = Objects.requireNonNull(value, "processLabel");
    if (this.processLabel.equals(newValue)) return this;
    return new ImmutableContainerInfo(
        this.id,
        this.created,
        this.path,
        this.args,
        this.config,
        this.hostConfig,
        this.state,
        this.image,
        this.networkSettings,
        this.resolvConfPath,
        this.hostnamePath,
        this.hostsPath,
        this.name,
        this.driver,
        this.execDriver,
        newValue,
        this.mountLabel,
        this.appArmorProfile,
        this.execIds,
        this.logPath,
        this.restartCount,
        this.mounts,
        this.node);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ContainerInfo#mountLabel() mountLabel} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for mountLabel
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableContainerInfo withMountLabel(String value) {
    String newValue = Objects.requireNonNull(value, "mountLabel");
    if (this.mountLabel.equals(newValue)) return this;
    return new ImmutableContainerInfo(
        this.id,
        this.created,
        this.path,
        this.args,
        this.config,
        this.hostConfig,
        this.state,
        this.image,
        this.networkSettings,
        this.resolvConfPath,
        this.hostnamePath,
        this.hostsPath,
        this.name,
        this.driver,
        this.execDriver,
        this.processLabel,
        newValue,
        this.appArmorProfile,
        this.execIds,
        this.logPath,
        this.restartCount,
        this.mounts,
        this.node);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ContainerInfo#appArmorProfile() appArmorProfile} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for appArmorProfile
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableContainerInfo withAppArmorProfile(String value) {
    String newValue = Objects.requireNonNull(value, "appArmorProfile");
    if (this.appArmorProfile.equals(newValue)) return this;
    return new ImmutableContainerInfo(
        this.id,
        this.created,
        this.path,
        this.args,
        this.config,
        this.hostConfig,
        this.state,
        this.image,
        this.networkSettings,
        this.resolvConfPath,
        this.hostnamePath,
        this.hostsPath,
        this.name,
        this.driver,
        this.execDriver,
        this.processLabel,
        this.mountLabel,
        newValue,
        this.execIds,
        this.logPath,
        this.restartCount,
        this.mounts,
        this.node);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ContainerInfo#execIds() execIds}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableContainerInfo withExecIds(@Nullable String... elements) {
    if (elements == null) {
      return new ImmutableContainerInfo(
          this.id,
          this.created,
          this.path,
          this.args,
          this.config,
          this.hostConfig,
          this.state,
          this.image,
          this.networkSettings,
          this.resolvConfPath,
          this.hostnamePath,
          this.hostsPath,
          this.name,
          this.driver,
          this.execDriver,
          this.processLabel,
          this.mountLabel,
          this.appArmorProfile,
          null,
          this.logPath,
          this.restartCount,
          this.mounts,
          this.node);
    }
    @Nullable List<String> newValue = Arrays.asList(elements) == null ? null : createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableContainerInfo(
        this.id,
        this.created,
        this.path,
        this.args,
        this.config,
        this.hostConfig,
        this.state,
        this.image,
        this.networkSettings,
        this.resolvConfPath,
        this.hostnamePath,
        this.hostsPath,
        this.name,
        this.driver,
        this.execDriver,
        this.processLabel,
        this.mountLabel,
        this.appArmorProfile,
        newValue,
        this.logPath,
        this.restartCount,
        this.mounts,
        this.node);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ContainerInfo#execIds() execIds}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of execIds elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableContainerInfo withExecIds(@Nullable Iterable<String> elements) {
    if (this.execIds == elements) return this;
    @Nullable List<String> newValue = elements == null ? null : createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableContainerInfo(
        this.id,
        this.created,
        this.path,
        this.args,
        this.config,
        this.hostConfig,
        this.state,
        this.image,
        this.networkSettings,
        this.resolvConfPath,
        this.hostnamePath,
        this.hostsPath,
        this.name,
        this.driver,
        this.execDriver,
        this.processLabel,
        this.mountLabel,
        this.appArmorProfile,
        newValue,
        this.logPath,
        this.restartCount,
        this.mounts,
        this.node);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ContainerInfo#logPath() logPath} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for logPath
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableContainerInfo withLogPath(String value) {
    String newValue = Objects.requireNonNull(value, "logPath");
    if (this.logPath.equals(newValue)) return this;
    return new ImmutableContainerInfo(
        this.id,
        this.created,
        this.path,
        this.args,
        this.config,
        this.hostConfig,
        this.state,
        this.image,
        this.networkSettings,
        this.resolvConfPath,
        this.hostnamePath,
        this.hostsPath,
        this.name,
        this.driver,
        this.execDriver,
        this.processLabel,
        this.mountLabel,
        this.appArmorProfile,
        this.execIds,
        newValue,
        this.restartCount,
        this.mounts,
        this.node);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ContainerInfo#restartCount() restartCount} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for restartCount
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableContainerInfo withRestartCount(Long value) {
    Long newValue = Objects.requireNonNull(value, "restartCount");
    if (this.restartCount.equals(newValue)) return this;
    return new ImmutableContainerInfo(
        this.id,
        this.created,
        this.path,
        this.args,
        this.config,
        this.hostConfig,
        this.state,
        this.image,
        this.networkSettings,
        this.resolvConfPath,
        this.hostnamePath,
        this.hostsPath,
        this.name,
        this.driver,
        this.execDriver,
        this.processLabel,
        this.mountLabel,
        this.appArmorProfile,
        this.execIds,
        this.logPath,
        newValue,
        this.mounts,
        this.node);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ContainerInfo#mounts() mounts}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableContainerInfo withMounts(@Nullable ContainerMount... elements) {
    if (elements == null) {
      return new ImmutableContainerInfo(
          this.id,
          this.created,
          this.path,
          this.args,
          this.config,
          this.hostConfig,
          this.state,
          this.image,
          this.networkSettings,
          this.resolvConfPath,
          this.hostnamePath,
          this.hostsPath,
          this.name,
          this.driver,
          this.execDriver,
          this.processLabel,
          this.mountLabel,
          this.appArmorProfile,
          this.execIds,
          this.logPath,
          this.restartCount,
          null,
          this.node);
    }
    @Nullable List<ContainerMount> newValue = Arrays.asList(elements) == null ? null : createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableContainerInfo(
        this.id,
        this.created,
        this.path,
        this.args,
        this.config,
        this.hostConfig,
        this.state,
        this.image,
        this.networkSettings,
        this.resolvConfPath,
        this.hostnamePath,
        this.hostsPath,
        this.name,
        this.driver,
        this.execDriver,
        this.processLabel,
        this.mountLabel,
        this.appArmorProfile,
        this.execIds,
        this.logPath,
        this.restartCount,
        newValue,
        this.node);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ContainerInfo#mounts() mounts}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of mounts elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableContainerInfo withMounts(@Nullable Iterable<? extends ContainerMount> elements) {
    if (this.mounts == elements) return this;
    @Nullable List<ContainerMount> newValue = elements == null ? null : createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableContainerInfo(
        this.id,
        this.created,
        this.path,
        this.args,
        this.config,
        this.hostConfig,
        this.state,
        this.image,
        this.networkSettings,
        this.resolvConfPath,
        this.hostnamePath,
        this.hostsPath,
        this.name,
        this.driver,
        this.execDriver,
        this.processLabel,
        this.mountLabel,
        this.appArmorProfile,
        this.execIds,
        this.logPath,
        this.restartCount,
        newValue,
        this.node);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ContainerInfo#node() node} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for node (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableContainerInfo withNode(@Nullable ContainerInfo.Node value) {
    if (this.node == value) return this;
    return new ImmutableContainerInfo(
        this.id,
        this.created,
        this.path,
        this.args,
        this.config,
        this.hostConfig,
        this.state,
        this.image,
        this.networkSettings,
        this.resolvConfPath,
        this.hostnamePath,
        this.hostsPath,
        this.name,
        this.driver,
        this.execDriver,
        this.processLabel,
        this.mountLabel,
        this.appArmorProfile,
        this.execIds,
        this.logPath,
        this.restartCount,
        this.mounts,
        value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableContainerInfo} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableContainerInfo
        && equalTo(0, (ImmutableContainerInfo) another);
  }

  private boolean equalTo(int synthetic, ImmutableContainerInfo another) {
    return Objects.equals(id, another.id)
        && created.equals(another.created)
        && path.equals(another.path)
        && args.equals(another.args)
        && config.equals(another.config)
        && Objects.equals(hostConfig, another.hostConfig)
        && state.equals(another.state)
        && image.equals(another.image)
        && networkSettings.equals(another.networkSettings)
        && resolvConfPath.equals(another.resolvConfPath)
        && hostnamePath.equals(another.hostnamePath)
        && hostsPath.equals(another.hostsPath)
        && name.equals(another.name)
        && driver.equals(another.driver)
        && Objects.equals(execDriver, another.execDriver)
        && processLabel.equals(another.processLabel)
        && mountLabel.equals(another.mountLabel)
        && appArmorProfile.equals(another.appArmorProfile)
        && Objects.equals(execIds, another.execIds)
        && logPath.equals(another.logPath)
        && restartCount.equals(another.restartCount)
        && Objects.equals(mounts, another.mounts)
        && Objects.equals(node, another.node);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code created}, {@code path}, {@code args}, {@code config}, {@code hostConfig}, {@code state}, {@code image}, {@code networkSettings}, {@code resolvConfPath}, {@code hostnamePath}, {@code hostsPath}, {@code name}, {@code driver}, {@code execDriver}, {@code processLabel}, {@code mountLabel}, {@code appArmorProfile}, {@code execIds}, {@code logPath}, {@code restartCount}, {@code mounts}, {@code node}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(id);
    h += (h << 5) + created.hashCode();
    h += (h << 5) + path.hashCode();
    h += (h << 5) + args.hashCode();
    h += (h << 5) + config.hashCode();
    h += (h << 5) + Objects.hashCode(hostConfig);
    h += (h << 5) + state.hashCode();
    h += (h << 5) + image.hashCode();
    h += (h << 5) + networkSettings.hashCode();
    h += (h << 5) + resolvConfPath.hashCode();
    h += (h << 5) + hostnamePath.hashCode();
    h += (h << 5) + hostsPath.hashCode();
    h += (h << 5) + name.hashCode();
    h += (h << 5) + driver.hashCode();
    h += (h << 5) + Objects.hashCode(execDriver);
    h += (h << 5) + processLabel.hashCode();
    h += (h << 5) + mountLabel.hashCode();
    h += (h << 5) + appArmorProfile.hashCode();
    h += (h << 5) + Objects.hashCode(execIds);
    h += (h << 5) + logPath.hashCode();
    h += (h << 5) + restartCount.hashCode();
    h += (h << 5) + Objects.hashCode(mounts);
    h += (h << 5) + Objects.hashCode(node);
    return h;
  }

  /**
   * Prints the immutable value {@code ContainerInfo} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ContainerInfo{"
        + "id=" + id
        + ", created=" + created
        + ", path=" + path
        + ", args=" + args
        + ", config=" + config
        + ", hostConfig=" + hostConfig
        + ", state=" + state
        + ", image=" + image
        + ", networkSettings=" + networkSettings
        + ", resolvConfPath=" + resolvConfPath
        + ", hostnamePath=" + hostnamePath
        + ", hostsPath=" + hostsPath
        + ", name=" + name
        + ", driver=" + driver
        + ", execDriver=" + execDriver
        + ", processLabel=" + processLabel
        + ", mountLabel=" + mountLabel
        + ", appArmorProfile=" + appArmorProfile
        + ", execIds=" + execIds
        + ", logPath=" + logPath
        + ", restartCount=" + restartCount
        + ", mounts=" + mounts
        + ", node=" + node
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link ContainerInfo} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ContainerInfo instance
   */
  public static ImmutableContainerInfo copyOf(ContainerInfo instance) {
    if (instance instanceof ImmutableContainerInfo) {
      return (ImmutableContainerInfo) instance;
    }
    return ImmutableContainerInfo.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableContainerInfo ImmutableContainerInfo}.
   * <pre>
   * ImmutableContainerInfo.builder()
   *    .id(String | null) // nullable {@link ContainerInfo#id() id}
   *    .created(Date) // required {@link ContainerInfo#created() created}
   *    .path(String) // required {@link ContainerInfo#path() path}
   *    .arg|addAllArgs(String) // {@link ContainerInfo#args() args} elements
   *    .config(org.mandas.docker.client.messages.ContainerConfig) // required {@link ContainerInfo#config() config}
   *    .hostConfig(org.mandas.docker.client.messages.HostConfig | null) // nullable {@link ContainerInfo#hostConfig() hostConfig}
   *    .state(org.mandas.docker.client.messages.ContainerState) // required {@link ContainerInfo#state() state}
   *    .image(String) // required {@link ContainerInfo#image() image}
   *    .networkSettings(org.mandas.docker.client.messages.NetworkSettings) // required {@link ContainerInfo#networkSettings() networkSettings}
   *    .resolvConfPath(String) // required {@link ContainerInfo#resolvConfPath() resolvConfPath}
   *    .hostnamePath(String) // required {@link ContainerInfo#hostnamePath() hostnamePath}
   *    .hostsPath(String) // required {@link ContainerInfo#hostsPath() hostsPath}
   *    .name(String) // required {@link ContainerInfo#name() name}
   *    .driver(String) // required {@link ContainerInfo#driver() driver}
   *    .execDriver(String | null) // nullable {@link ContainerInfo#execDriver() execDriver}
   *    .processLabel(String) // required {@link ContainerInfo#processLabel() processLabel}
   *    .mountLabel(String) // required {@link ContainerInfo#mountLabel() mountLabel}
   *    .appArmorProfile(String) // required {@link ContainerInfo#appArmorProfile() appArmorProfile}
   *    .execIds(List&amp;lt;String&amp;gt; | null) // nullable {@link ContainerInfo#execIds() execIds}
   *    .logPath(String) // required {@link ContainerInfo#logPath() logPath}
   *    .restartCount(Long) // required {@link ContainerInfo#restartCount() restartCount}
   *    .mounts(List&amp;lt;org.mandas.docker.client.messages.ContainerMount&amp;gt; | null) // nullable {@link ContainerInfo#mounts() mounts}
   *    .node(org.mandas.docker.client.messages.ContainerInfo.Node | null) // nullable {@link ContainerInfo#node() node}
   *    .build();
   * </pre>
   * @return A new ImmutableContainerInfo builder
   */
  public static ImmutableContainerInfo.Builder builder() {
    return new ImmutableContainerInfo.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableContainerInfo ImmutableContainerInfo}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  static final class Builder {
    private static final long INIT_BIT_CREATED = 0x1L;
    private static final long INIT_BIT_PATH = 0x2L;
    private static final long INIT_BIT_CONFIG = 0x4L;
    private static final long INIT_BIT_STATE = 0x8L;
    private static final long INIT_BIT_IMAGE = 0x10L;
    private static final long INIT_BIT_NETWORK_SETTINGS = 0x20L;
    private static final long INIT_BIT_RESOLV_CONF_PATH = 0x40L;
    private static final long INIT_BIT_HOSTNAME_PATH = 0x80L;
    private static final long INIT_BIT_HOSTS_PATH = 0x100L;
    private static final long INIT_BIT_NAME = 0x200L;
    private static final long INIT_BIT_DRIVER = 0x400L;
    private static final long INIT_BIT_PROCESS_LABEL = 0x800L;
    private static final long INIT_BIT_MOUNT_LABEL = 0x1000L;
    private static final long INIT_BIT_APP_ARMOR_PROFILE = 0x2000L;
    private static final long INIT_BIT_LOG_PATH = 0x4000L;
    private static final long INIT_BIT_RESTART_COUNT = 0x8000L;
    private long initBits = 0xffffL;

    private String id;
    private Date created;
    private String path;
    private List<String> args = new ArrayList<String>();
    private ContainerConfig config;
    private HostConfig hostConfig;
    private ContainerState state;
    private String image;
    private NetworkSettings networkSettings;
    private String resolvConfPath;
    private String hostnamePath;
    private String hostsPath;
    private String name;
    private String driver;
    private String execDriver;
    private String processLabel;
    private String mountLabel;
    private String appArmorProfile;
    private List<String> execIds = null;
    private String logPath;
    private Long restartCount;
    private List<ContainerMount> mounts = null;
    private ContainerInfo.Node node;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ContainerInfo} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ContainerInfo instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable String idValue = instance.id();
      if (idValue != null) {
        id(idValue);
      }
      created(instance.created());
      path(instance.path());
      addAllArgs(instance.args());
      config(instance.config());
      @Nullable HostConfig hostConfigValue = instance.hostConfig();
      if (hostConfigValue != null) {
        hostConfig(hostConfigValue);
      }
      state(instance.state());
      image(instance.image());
      networkSettings(instance.networkSettings());
      resolvConfPath(instance.resolvConfPath());
      hostnamePath(instance.hostnamePath());
      hostsPath(instance.hostsPath());
      name(instance.name());
      driver(instance.driver());
      @Nullable String execDriverValue = instance.execDriver();
      if (execDriverValue != null) {
        execDriver(execDriverValue);
      }
      processLabel(instance.processLabel());
      mountLabel(instance.mountLabel());
      appArmorProfile(instance.appArmorProfile());
      @Nullable List<String> execIdsValue = instance.execIds();
      if (execIdsValue != null) {
        addAllExecIds(execIdsValue);
      }
      logPath(instance.logPath());
      restartCount(instance.restartCount());
      @Nullable List<ContainerMount> mountsValue = instance.mounts();
      if (mountsValue != null) {
        addAllMounts(mountsValue);
      }
      @Nullable ContainerInfo.Node nodeValue = instance.node();
      if (nodeValue != null) {
        node(nodeValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ContainerInfo#id() id} attribute.
     * @param id The value for id (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("Id")
    public final Builder id(@Nullable String id) {
      this.id = id;
      return this;
    }

    /**
     * Initializes the value for the {@link ContainerInfo#created() created} attribute.
     * @param created The value for created 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("Created")
    public final Builder created(Date created) {
      this.created = Objects.requireNonNull(created, "created");
      initBits &= ~INIT_BIT_CREATED;
      return this;
    }

    /**
     * Initializes the value for the {@link ContainerInfo#path() path} attribute.
     * @param path The value for path 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("Path")
    public final Builder path(String path) {
      this.path = Objects.requireNonNull(path, "path");
      initBits &= ~INIT_BIT_PATH;
      return this;
    }

    /**
     * Adds one element to {@link ContainerInfo#args() args} list.
     * @param element A args element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder arg(String element) {
      this.args.add(Objects.requireNonNull(element, "args element"));
      return this;
    }

    /**
     * Adds elements to {@link ContainerInfo#args() args} list.
     * @param elements An array of args elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder args(String... elements) {
      for (String element : elements) {
        this.args.add(Objects.requireNonNull(element, "args element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ContainerInfo#args() args} list.
     * @param elements An iterable of args elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("Args")
    public final Builder args(Iterable<String> elements) {
      this.args.clear();
      return addAllArgs(elements);
    }

    /**
     * Adds elements to {@link ContainerInfo#args() args} list.
     * @param elements An iterable of args elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllArgs(Iterable<String> elements) {
      for (String element : elements) {
        this.args.add(Objects.requireNonNull(element, "args element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ContainerInfo#config() config} attribute.
     * @param config The value for config 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("Config")
    public final Builder config(ContainerConfig config) {
      this.config = Objects.requireNonNull(config, "config");
      initBits &= ~INIT_BIT_CONFIG;
      return this;
    }

    /**
     * Initializes the value for the {@link ContainerInfo#hostConfig() hostConfig} attribute.
     * @param hostConfig The value for hostConfig (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("HostConfig")
    public final Builder hostConfig(@Nullable HostConfig hostConfig) {
      this.hostConfig = hostConfig;
      return this;
    }

    /**
     * Initializes the value for the {@link ContainerInfo#state() state} attribute.
     * @param state The value for state 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("State")
    public final Builder state(ContainerState state) {
      this.state = Objects.requireNonNull(state, "state");
      initBits &= ~INIT_BIT_STATE;
      return this;
    }

    /**
     * Initializes the value for the {@link ContainerInfo#image() image} attribute.
     * @param image The value for image 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("Image")
    public final Builder image(String image) {
      this.image = Objects.requireNonNull(image, "image");
      initBits &= ~INIT_BIT_IMAGE;
      return this;
    }

    /**
     * Initializes the value for the {@link ContainerInfo#networkSettings() networkSettings} attribute.
     * @param networkSettings The value for networkSettings 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("NetworkSettings")
    public final Builder networkSettings(NetworkSettings networkSettings) {
      this.networkSettings = Objects.requireNonNull(networkSettings, "networkSettings");
      initBits &= ~INIT_BIT_NETWORK_SETTINGS;
      return this;
    }

    /**
     * Initializes the value for the {@link ContainerInfo#resolvConfPath() resolvConfPath} attribute.
     * @param resolvConfPath The value for resolvConfPath 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("ResolvConfPath")
    public final Builder resolvConfPath(String resolvConfPath) {
      this.resolvConfPath = Objects.requireNonNull(resolvConfPath, "resolvConfPath");
      initBits &= ~INIT_BIT_RESOLV_CONF_PATH;
      return this;
    }

    /**
     * Initializes the value for the {@link ContainerInfo#hostnamePath() hostnamePath} attribute.
     * @param hostnamePath The value for hostnamePath 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("HostnamePath")
    public final Builder hostnamePath(String hostnamePath) {
      this.hostnamePath = Objects.requireNonNull(hostnamePath, "hostnamePath");
      initBits &= ~INIT_BIT_HOSTNAME_PATH;
      return this;
    }

    /**
     * Initializes the value for the {@link ContainerInfo#hostsPath() hostsPath} attribute.
     * @param hostsPath The value for hostsPath 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("HostsPath")
    public final Builder hostsPath(String hostsPath) {
      this.hostsPath = Objects.requireNonNull(hostsPath, "hostsPath");
      initBits &= ~INIT_BIT_HOSTS_PATH;
      return this;
    }

    /**
     * Initializes the value for the {@link ContainerInfo#name() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("Name")
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link ContainerInfo#driver() driver} attribute.
     * @param driver The value for driver 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("Driver")
    public final Builder driver(String driver) {
      this.driver = Objects.requireNonNull(driver, "driver");
      initBits &= ~INIT_BIT_DRIVER;
      return this;
    }

    /**
     * Initializes the value for the {@link ContainerInfo#execDriver() execDriver} attribute.
     * @param execDriver The value for execDriver (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("ExecDriver")
    public final Builder execDriver(@Nullable String execDriver) {
      this.execDriver = execDriver;
      return this;
    }

    /**
     * Initializes the value for the {@link ContainerInfo#processLabel() processLabel} attribute.
     * @param processLabel The value for processLabel 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("ProcessLabel")
    public final Builder processLabel(String processLabel) {
      this.processLabel = Objects.requireNonNull(processLabel, "processLabel");
      initBits &= ~INIT_BIT_PROCESS_LABEL;
      return this;
    }

    /**
     * Initializes the value for the {@link ContainerInfo#mountLabel() mountLabel} attribute.
     * @param mountLabel The value for mountLabel 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("MountLabel")
    public final Builder mountLabel(String mountLabel) {
      this.mountLabel = Objects.requireNonNull(mountLabel, "mountLabel");
      initBits &= ~INIT_BIT_MOUNT_LABEL;
      return this;
    }

    /**
     * Initializes the value for the {@link ContainerInfo#appArmorProfile() appArmorProfile} attribute.
     * @param appArmorProfile The value for appArmorProfile 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("AppArmorProfile")
    public final Builder appArmorProfile(String appArmorProfile) {
      this.appArmorProfile = Objects.requireNonNull(appArmorProfile, "appArmorProfile");
      initBits &= ~INIT_BIT_APP_ARMOR_PROFILE;
      return this;
    }

    /**
     * Adds one element to {@link ContainerInfo#execIds() execIds} list.
     * @param element A execIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder execId(String element) {
      if (this.execIds == null) {
        this.execIds = new ArrayList<String>();
      }
      this.execIds.add(Objects.requireNonNull(element, "execIds element"));
      return this;
    }

    /**
     * Adds elements to {@link ContainerInfo#execIds() execIds} list.
     * @param elements An array of execIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder execIds(String... elements) {
      if (this.execIds == null) {
        this.execIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.execIds.add(Objects.requireNonNull(element, "execIds element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ContainerInfo#execIds() execIds} list.
     * @param elements An iterable of execIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("ExecIDs")
    public final Builder execIds(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.execIds = null;
        return this;
      }
      this.execIds = new ArrayList<String>();
      return addAllExecIds(elements);
    }

    /**
     * Adds elements to {@link ContainerInfo#execIds() execIds} list.
     * @param elements An iterable of execIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllExecIds(Iterable<String> elements) {
      Objects.requireNonNull(elements, "execIds element");
      if (this.execIds == null) {
        this.execIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.execIds.add(Objects.requireNonNull(element, "execIds element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ContainerInfo#logPath() logPath} attribute.
     * @param logPath The value for logPath 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("LogPath")
    public final Builder logPath(String logPath) {
      this.logPath = Objects.requireNonNull(logPath, "logPath");
      initBits &= ~INIT_BIT_LOG_PATH;
      return this;
    }

    /**
     * Initializes the value for the {@link ContainerInfo#restartCount() restartCount} attribute.
     * @param restartCount The value for restartCount 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("RestartCount")
    public final Builder restartCount(Long restartCount) {
      this.restartCount = Objects.requireNonNull(restartCount, "restartCount");
      initBits &= ~INIT_BIT_RESTART_COUNT;
      return this;
    }

    /**
     * Adds one element to {@link ContainerInfo#mounts() mounts} list.
     * @param element A mounts element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder mount(ContainerMount element) {
      if (this.mounts == null) {
        this.mounts = new ArrayList<ContainerMount>();
      }
      this.mounts.add(Objects.requireNonNull(element, "mounts element"));
      return this;
    }

    /**
     * Adds elements to {@link ContainerInfo#mounts() mounts} list.
     * @param elements An array of mounts elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder mounts(ContainerMount... elements) {
      if (this.mounts == null) {
        this.mounts = new ArrayList<ContainerMount>();
      }
      for (ContainerMount element : elements) {
        this.mounts.add(Objects.requireNonNull(element, "mounts element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ContainerInfo#mounts() mounts} list.
     * @param elements An iterable of mounts elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("Mounts")
    public final Builder mounts(@Nullable Iterable<? extends ContainerMount> elements) {
      if (elements == null) {
        this.mounts = null;
        return this;
      }
      this.mounts = new ArrayList<ContainerMount>();
      return addAllMounts(elements);
    }

    /**
     * Adds elements to {@link ContainerInfo#mounts() mounts} list.
     * @param elements An iterable of mounts elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllMounts(Iterable<? extends ContainerMount> elements) {
      Objects.requireNonNull(elements, "mounts element");
      if (this.mounts == null) {
        this.mounts = new ArrayList<ContainerMount>();
      }
      for (ContainerMount element : elements) {
        this.mounts.add(Objects.requireNonNull(element, "mounts element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ContainerInfo#node() node} attribute.
     * @param node The value for node (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("Node")
    public final Builder node(@Nullable ContainerInfo.Node node) {
      this.node = node;
      return this;
    }

    /**
     * Builds a new {@link ImmutableContainerInfo ImmutableContainerInfo}.
     * @return An immutable instance of ContainerInfo
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableContainerInfo build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableContainerInfo(
          id,
          created,
          path,
          createUnmodifiableList(true, args),
          config,
          hostConfig,
          state,
          image,
          networkSettings,
          resolvConfPath,
          hostnamePath,
          hostsPath,
          name,
          driver,
          execDriver,
          processLabel,
          mountLabel,
          appArmorProfile,
          execIds == null ? null : createUnmodifiableList(true, execIds),
          logPath,
          restartCount,
          mounts == null ? null : createUnmodifiableList(true, mounts),
          node);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_CREATED) != 0) attributes.add("created");
      if ((initBits & INIT_BIT_PATH) != 0) attributes.add("path");
      if ((initBits & INIT_BIT_CONFIG) != 0) attributes.add("config");
      if ((initBits & INIT_BIT_STATE) != 0) attributes.add("state");
      if ((initBits & INIT_BIT_IMAGE) != 0) attributes.add("image");
      if ((initBits & INIT_BIT_NETWORK_SETTINGS) != 0) attributes.add("networkSettings");
      if ((initBits & INIT_BIT_RESOLV_CONF_PATH) != 0) attributes.add("resolvConfPath");
      if ((initBits & INIT_BIT_HOSTNAME_PATH) != 0) attributes.add("hostnamePath");
      if ((initBits & INIT_BIT_HOSTS_PATH) != 0) attributes.add("hostsPath");
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_DRIVER) != 0) attributes.add("driver");
      if ((initBits & INIT_BIT_PROCESS_LABEL) != 0) attributes.add("processLabel");
      if ((initBits & INIT_BIT_MOUNT_LABEL) != 0) attributes.add("mountLabel");
      if ((initBits & INIT_BIT_APP_ARMOR_PROFILE) != 0) attributes.add("appArmorProfile");
      if ((initBits & INIT_BIT_LOG_PATH) != 0) attributes.add("logPath");
      if ((initBits & INIT_BIT_RESTART_COUNT) != 0) attributes.add("restartCount");
      return "Cannot build ContainerInfo, some of required attributes are not set " + attributes;
    }
  }

  /**
   * Immutable implementation of {@link ContainerInfo.Node}.
   * <p>
   * Use the builder to create immutable instances:
   * {@code ImmutableContainerInfo.Node.builder()}.
   */
  static final class Node implements ContainerInfo.Node {
    private final String id;
    private final String ip;
    private final String addr;
    private final String name;

    private Node(String id, String ip, String addr, String name) {
      this.id = id;
      this.ip = ip;
      this.addr = addr;
      this.name = name;
    }

    /**
     * @return The value of the {@code id} attribute
     */
    @JsonProperty("ID")
    @Override
    public String id() {
      return id;
    }

    /**
     * @return The value of the {@code ip} attribute
     */
    @JsonProperty("IP")
    @Override
    public String ip() {
      return ip;
    }

    /**
     * @return The value of the {@code addr} attribute
     */
    @JsonProperty("Addr")
    @Override
    public String addr() {
      return addr;
    }

    /**
     * @return The value of the {@code name} attribute
     */
    @JsonProperty("Name")
    @Override
    public String name() {
      return name;
    }

    /**
     * Copy the current immutable object by setting a value for the {@link ContainerInfo.Node#id() id} attribute.
     * An equals check used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for id
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableContainerInfo.Node withId(String value) {
      String newValue = Objects.requireNonNull(value, "id");
      if (this.id.equals(newValue)) return this;
      return new ImmutableContainerInfo.Node(newValue, this.ip, this.addr, this.name);
    }

    /**
     * Copy the current immutable object by setting a value for the {@link ContainerInfo.Node#ip() ip} attribute.
     * An equals check used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for ip
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableContainerInfo.Node withIp(String value) {
      String newValue = Objects.requireNonNull(value, "ip");
      if (this.ip.equals(newValue)) return this;
      return new ImmutableContainerInfo.Node(this.id, newValue, this.addr, this.name);
    }

    /**
     * Copy the current immutable object by setting a value for the {@link ContainerInfo.Node#addr() addr} attribute.
     * An equals check used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for addr
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableContainerInfo.Node withAddr(String value) {
      String newValue = Objects.requireNonNull(value, "addr");
      if (this.addr.equals(newValue)) return this;
      return new ImmutableContainerInfo.Node(this.id, this.ip, newValue, this.name);
    }

    /**
     * Copy the current immutable object by setting a value for the {@link ContainerInfo.Node#name() name} attribute.
     * An equals check used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for name
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableContainerInfo.Node withName(String value) {
      String newValue = Objects.requireNonNull(value, "name");
      if (this.name.equals(newValue)) return this;
      return new ImmutableContainerInfo.Node(this.id, this.ip, this.addr, newValue);
    }

    /**
     * This instance is equal to all instances of {@code Node} that have equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(Object another) {
      if (this == another) return true;
      return another instanceof ImmutableContainerInfo.Node
          && equalTo(0, (ImmutableContainerInfo.Node) another);
    }

    private boolean equalTo(int synthetic, ImmutableContainerInfo.Node another) {
      return id.equals(another.id)
          && ip.equals(another.ip)
          && addr.equals(another.addr)
          && name.equals(another.name);
    }

    /**
     * Computes a hash code from attributes: {@code id}, {@code ip}, {@code addr}, {@code name}.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      int h = 5381;
      h += (h << 5) + id.hashCode();
      h += (h << 5) + ip.hashCode();
      h += (h << 5) + addr.hashCode();
      h += (h << 5) + name.hashCode();
      return h;
    }

    /**
     * Prints the immutable value {@code Node} with attribute values.
     * @return A string representation of the value
     */
    @Override
    public String toString() {
      return "Node{"
          + "id=" + id
          + ", ip=" + ip
          + ", addr=" + addr
          + ", name=" + name
          + "}";
    }

    /**
     * Creates an immutable copy of a {@link ContainerInfo.Node} value.
     * Uses accessors to get values to initialize the new immutable instance.
     * If an instance is already immutable, it is returned as is.
     * @param instance The instance to copy
     * @return A copied immutable Node instance
     */
    public static ImmutableContainerInfo.Node copyOf(ContainerInfo.Node instance) {
      if (instance instanceof ImmutableContainerInfo.Node) {
        return (ImmutableContainerInfo.Node) instance;
      }
      return ImmutableContainerInfo.Node.builder()
          .from(instance)
          .build();
    }

    /**
     * Creates a builder for {@link ImmutableContainerInfo.Node Node}.
     * <pre>
     * ImmutableContainerInfo.Node.builder()
     *    .id(String) // required {@link ContainerInfo.Node#id() id}
     *    .ip(String) // required {@link ContainerInfo.Node#ip() ip}
     *    .addr(String) // required {@link ContainerInfo.Node#addr() addr}
     *    .name(String) // required {@link ContainerInfo.Node#name() name}
     *    .build();
     * </pre>
     * @return A new Node builder
     */
    public static ImmutableContainerInfo.Node.Builder builder() {
      return new ImmutableContainerInfo.Node.Builder();
    }

    /**
     * Builds instances of type {@link ImmutableContainerInfo.Node Node}.
     * Initialize attributes and then invoke the {@link #build()} method to create an
     * immutable instance.
     * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
     * but instead used immediately to create instances.</em>
     */
    static final class Builder {
      private static final long INIT_BIT_ID = 0x1L;
      private static final long INIT_BIT_IP = 0x2L;
      private static final long INIT_BIT_ADDR = 0x4L;
      private static final long INIT_BIT_NAME = 0x8L;
      private long initBits = 0xfL;

      private String id;
      private String ip;
      private String addr;
      private String name;

      private Builder() {
      }

      /**
       * Fill a builder with attribute values from the provided {@code Node} instance.
       * Regular attribute values will be replaced with those from the given instance.
       * Absent optional values will not replace present values.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder from(ContainerInfo.Node instance) {
        Objects.requireNonNull(instance, "instance");
        id(instance.id());
        ip(instance.ip());
        addr(instance.addr());
        name(instance.name());
        return this;
      }

      /**
       * Initializes the value for the {@link ContainerInfo.Node#id() id} attribute.
       * @param id The value for id 
       * @return {@code this} builder for use in a chained invocation
       */
      @JsonProperty("ID")
      public final Builder id(String id) {
        this.id = Objects.requireNonNull(id, "id");
        initBits &= ~INIT_BIT_ID;
        return this;
      }

      /**
       * Initializes the value for the {@link ContainerInfo.Node#ip() ip} attribute.
       * @param ip The value for ip 
       * @return {@code this} builder for use in a chained invocation
       */
      @JsonProperty("IP")
      public final Builder ip(String ip) {
        this.ip = Objects.requireNonNull(ip, "ip");
        initBits &= ~INIT_BIT_IP;
        return this;
      }

      /**
       * Initializes the value for the {@link ContainerInfo.Node#addr() addr} attribute.
       * @param addr The value for addr 
       * @return {@code this} builder for use in a chained invocation
       */
      @JsonProperty("Addr")
      public final Builder addr(String addr) {
        this.addr = Objects.requireNonNull(addr, "addr");
        initBits &= ~INIT_BIT_ADDR;
        return this;
      }

      /**
       * Initializes the value for the {@link ContainerInfo.Node#name() name} attribute.
       * @param name The value for name 
       * @return {@code this} builder for use in a chained invocation
       */
      @JsonProperty("Name")
      public final Builder name(String name) {
        this.name = Objects.requireNonNull(name, "name");
        initBits &= ~INIT_BIT_NAME;
        return this;
      }

      /**
       * Builds a new {@link ImmutableContainerInfo.Node Node}.
       * @return An immutable instance of Node
       * @throws java.lang.IllegalStateException if any required attributes are missing
       */
      public ImmutableContainerInfo.Node build() {
        if (initBits != 0) {
          throw new IllegalStateException(formatRequiredAttributesMessage());
        }
        return new ImmutableContainerInfo.Node(id, ip, addr, name);
      }

      private String formatRequiredAttributesMessage() {
        List<String> attributes = new ArrayList<>();
        if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
        if ((initBits & INIT_BIT_IP) != 0) attributes.add("ip");
        if ((initBits & INIT_BIT_ADDR) != 0) attributes.add("addr");
        if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
        return "Cannot build Node, some of required attributes are not set " + attributes;
      }
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
