package org.mandas.docker.client;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.mandas.docker.Nullable;
import org.mandas.docker.client.messages.RegistryAuth;

/**
 * Immutable implementation of {@link DockerConfig}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableDockerConfig.builder()}.
 */
@SuppressWarnings({"all"})
final class ImmutableDockerConfig implements DockerConfig {
  private final Map<String, String> credHelpers;
  private final Map<String, RegistryAuth> auths;
  private final Map<String, String> httpHeaders;
  private final @Nullable String credsStore;
  private final @Nullable String detachKeys;
  private final @Nullable String stackOrchestrator;
  private final @Nullable String psFormat;
  private final @Nullable String imagesFormat;

  private ImmutableDockerConfig(
      Map<String, String> credHelpers,
      Map<String, RegistryAuth> auths,
      Map<String, String> httpHeaders,
      @Nullable String credsStore,
      @Nullable String detachKeys,
      @Nullable String stackOrchestrator,
      @Nullable String psFormat,
      @Nullable String imagesFormat) {
    this.credHelpers = credHelpers;
    this.auths = auths;
    this.httpHeaders = httpHeaders;
    this.credsStore = credsStore;
    this.detachKeys = detachKeys;
    this.stackOrchestrator = stackOrchestrator;
    this.psFormat = psFormat;
    this.imagesFormat = imagesFormat;
  }

  /**
   * @return The value of the {@code credHelpers} attribute
   */
  @JsonProperty("credHelpers")
  @Override
  public Map<String, String> credHelpers() {
    return credHelpers;
  }

  /**
   * @return The value of the {@code auths} attribute
   */
  @JsonProperty("auths")
  @Override
  public Map<String, RegistryAuth> auths() {
    return auths;
  }

  /**
   * @return The value of the {@code httpHeaders} attribute
   */
  @JsonProperty("HttpHeaders")
  @Override
  public Map<String, String> httpHeaders() {
    return httpHeaders;
  }

  /**
   * @return The value of the {@code credsStore} attribute
   */
  @JsonProperty("credsStore")
  @Override
  public @Nullable String credsStore() {
    return credsStore;
  }

  /**
   * @return The value of the {@code detachKeys} attribute
   */
  @JsonProperty("detachKeys")
  @Override
  public @Nullable String detachKeys() {
    return detachKeys;
  }

  /**
   * @return The value of the {@code stackOrchestrator} attribute
   */
  @JsonProperty("stackOrchestrator")
  @Override
  public @Nullable String stackOrchestrator() {
    return stackOrchestrator;
  }

  /**
   * @return The value of the {@code psFormat} attribute
   */
  @JsonProperty("psFormat")
  @Override
  public @Nullable String psFormat() {
    return psFormat;
  }

  /**
   * @return The value of the {@code imagesFormat} attribute
   */
  @JsonProperty("imagesFormat")
  @Override
  public @Nullable String imagesFormat() {
    return imagesFormat;
  }

  /**
   * Copy the current immutable object by replacing the {@link DockerConfig#credHelpers() credHelpers} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the credHelpers map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDockerConfig withCredHelpers(Map<String, ? extends String> entries) {
    if (this.credHelpers == entries) return this;
    Map<String, String> newValue = createUnmodifiableMap(true, false, entries);
    return new ImmutableDockerConfig(
        newValue,
        this.auths,
        this.httpHeaders,
        this.credsStore,
        this.detachKeys,
        this.stackOrchestrator,
        this.psFormat,
        this.imagesFormat);
  }

  /**
   * Copy the current immutable object by replacing the {@link DockerConfig#auths() auths} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the auths map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDockerConfig withAuths(Map<String, ? extends RegistryAuth> entries) {
    if (this.auths == entries) return this;
    Map<String, RegistryAuth> newValue = createUnmodifiableMap(true, false, entries);
    return new ImmutableDockerConfig(
        this.credHelpers,
        newValue,
        this.httpHeaders,
        this.credsStore,
        this.detachKeys,
        this.stackOrchestrator,
        this.psFormat,
        this.imagesFormat);
  }

  /**
   * Copy the current immutable object by replacing the {@link DockerConfig#httpHeaders() httpHeaders} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the httpHeaders map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDockerConfig withHttpHeaders(Map<String, ? extends String> entries) {
    if (this.httpHeaders == entries) return this;
    Map<String, String> newValue = createUnmodifiableMap(true, false, entries);
    return new ImmutableDockerConfig(
        this.credHelpers,
        this.auths,
        newValue,
        this.credsStore,
        this.detachKeys,
        this.stackOrchestrator,
        this.psFormat,
        this.imagesFormat);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DockerConfig#credsStore() credsStore} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for credsStore (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDockerConfig withCredsStore(@Nullable String value) {
    if (Objects.equals(this.credsStore, value)) return this;
    return new ImmutableDockerConfig(
        this.credHelpers,
        this.auths,
        this.httpHeaders,
        value,
        this.detachKeys,
        this.stackOrchestrator,
        this.psFormat,
        this.imagesFormat);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DockerConfig#detachKeys() detachKeys} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for detachKeys (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDockerConfig withDetachKeys(@Nullable String value) {
    if (Objects.equals(this.detachKeys, value)) return this;
    return new ImmutableDockerConfig(
        this.credHelpers,
        this.auths,
        this.httpHeaders,
        this.credsStore,
        value,
        this.stackOrchestrator,
        this.psFormat,
        this.imagesFormat);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DockerConfig#stackOrchestrator() stackOrchestrator} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for stackOrchestrator (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDockerConfig withStackOrchestrator(@Nullable String value) {
    if (Objects.equals(this.stackOrchestrator, value)) return this;
    return new ImmutableDockerConfig(
        this.credHelpers,
        this.auths,
        this.httpHeaders,
        this.credsStore,
        this.detachKeys,
        value,
        this.psFormat,
        this.imagesFormat);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DockerConfig#psFormat() psFormat} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for psFormat (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDockerConfig withPsFormat(@Nullable String value) {
    if (Objects.equals(this.psFormat, value)) return this;
    return new ImmutableDockerConfig(
        this.credHelpers,
        this.auths,
        this.httpHeaders,
        this.credsStore,
        this.detachKeys,
        this.stackOrchestrator,
        value,
        this.imagesFormat);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DockerConfig#imagesFormat() imagesFormat} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for imagesFormat (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDockerConfig withImagesFormat(@Nullable String value) {
    if (Objects.equals(this.imagesFormat, value)) return this;
    return new ImmutableDockerConfig(
        this.credHelpers,
        this.auths,
        this.httpHeaders,
        this.credsStore,
        this.detachKeys,
        this.stackOrchestrator,
        this.psFormat,
        value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableDockerConfig} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableDockerConfig
        && equalTo(0, (ImmutableDockerConfig) another);
  }

  private boolean equalTo(int synthetic, ImmutableDockerConfig another) {
    return credHelpers.equals(another.credHelpers)
        && auths.equals(another.auths)
        && httpHeaders.equals(another.httpHeaders)
        && Objects.equals(credsStore, another.credsStore)
        && Objects.equals(detachKeys, another.detachKeys)
        && Objects.equals(stackOrchestrator, another.stackOrchestrator)
        && Objects.equals(psFormat, another.psFormat)
        && Objects.equals(imagesFormat, another.imagesFormat);
  }

  /**
   * Computes a hash code from attributes: {@code credHelpers}, {@code auths}, {@code httpHeaders}, {@code credsStore}, {@code detachKeys}, {@code stackOrchestrator}, {@code psFormat}, {@code imagesFormat}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + credHelpers.hashCode();
    h += (h << 5) + auths.hashCode();
    h += (h << 5) + httpHeaders.hashCode();
    h += (h << 5) + Objects.hashCode(credsStore);
    h += (h << 5) + Objects.hashCode(detachKeys);
    h += (h << 5) + Objects.hashCode(stackOrchestrator);
    h += (h << 5) + Objects.hashCode(psFormat);
    h += (h << 5) + Objects.hashCode(imagesFormat);
    return h;
  }

  /**
   * Prints the immutable value {@code DockerConfig} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "DockerConfig{"
        + "credHelpers=" + credHelpers
        + ", auths=" + auths
        + ", httpHeaders=" + httpHeaders
        + ", credsStore=" + credsStore
        + ", detachKeys=" + detachKeys
        + ", stackOrchestrator=" + stackOrchestrator
        + ", psFormat=" + psFormat
        + ", imagesFormat=" + imagesFormat
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link DockerConfig} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable DockerConfig instance
   */
  public static ImmutableDockerConfig copyOf(DockerConfig instance) {
    if (instance instanceof ImmutableDockerConfig) {
      return (ImmutableDockerConfig) instance;
    }
    return ImmutableDockerConfig.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableDockerConfig ImmutableDockerConfig}.
   * <pre>
   * ImmutableDockerConfig.builder()
   *    .addCredHelper|putAllCredHelpers(String =&gt; String) // {@link DockerConfig#credHelpers() credHelpers} mappings
   *    .addAuth|putAllAuths(String =&gt; org.mandas.docker.client.messages.RegistryAuth) // {@link DockerConfig#auths() auths} mappings
   *    .addHttpHeader|putAllHttpHeaders(String =&gt; String) // {@link DockerConfig#httpHeaders() httpHeaders} mappings
   *    .credsStore(String | null) // nullable {@link DockerConfig#credsStore() credsStore}
   *    .detachKeys(String | null) // nullable {@link DockerConfig#detachKeys() detachKeys}
   *    .stackOrchestrator(String | null) // nullable {@link DockerConfig#stackOrchestrator() stackOrchestrator}
   *    .psFormat(String | null) // nullable {@link DockerConfig#psFormat() psFormat}
   *    .imagesFormat(String | null) // nullable {@link DockerConfig#imagesFormat() imagesFormat}
   *    .build();
   * </pre>
   * @return A new ImmutableDockerConfig builder
   */
  public static ImmutableDockerConfig.Builder builder() {
    return new ImmutableDockerConfig.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableDockerConfig ImmutableDockerConfig}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  static final class Builder {
    private Map<String, String> credHelpers = new LinkedHashMap<String, String>();
    private Map<String, RegistryAuth> auths = new LinkedHashMap<String, RegistryAuth>();
    private Map<String, String> httpHeaders = new LinkedHashMap<String, String>();
    private String credsStore;
    private String detachKeys;
    private String stackOrchestrator;
    private String psFormat;
    private String imagesFormat;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code DockerConfig} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(DockerConfig instance) {
      Objects.requireNonNull(instance, "instance");
      putAllCredHelpers(instance.credHelpers());
      putAllAuths(instance.auths());
      putAllHttpHeaders(instance.httpHeaders());
      @Nullable String credsStoreValue = instance.credsStore();
      if (credsStoreValue != null) {
        credsStore(credsStoreValue);
      }
      @Nullable String detachKeysValue = instance.detachKeys();
      if (detachKeysValue != null) {
        detachKeys(detachKeysValue);
      }
      @Nullable String stackOrchestratorValue = instance.stackOrchestrator();
      if (stackOrchestratorValue != null) {
        stackOrchestrator(stackOrchestratorValue);
      }
      @Nullable String psFormatValue = instance.psFormat();
      if (psFormatValue != null) {
        psFormat(psFormatValue);
      }
      @Nullable String imagesFormatValue = instance.imagesFormat();
      if (imagesFormatValue != null) {
        imagesFormat(imagesFormatValue);
      }
      return this;
    }

    /**
     * Put one entry to the {@link DockerConfig#credHelpers() credHelpers} map.
     * @param key The key in the credHelpers map
     * @param value The associated value in the credHelpers map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addCredHelper(String key, String value) {
      this.credHelpers.put(
          Objects.requireNonNull(key, "credHelpers key"),
          value == null ? Objects.requireNonNull(value, "credHelpers value for key: " + key) : value);
      return this;
    }

    /**
     * Put one entry to the {@link DockerConfig#credHelpers() credHelpers} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addCredHelper(Map.Entry<String, ? extends String> entry) {
      String k = entry.getKey();
      String v = entry.getValue();
      this.credHelpers.put(
          Objects.requireNonNull(k, "credHelpers key"),
          v == null ? Objects.requireNonNull(v, "credHelpers value for key: " + k) : v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link DockerConfig#credHelpers() credHelpers} map. Nulls are not permitted
     * @param entries The entries that will be added to the credHelpers map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("credHelpers")
    public final Builder credHelpers(Map<String, ? extends String> entries) {
      this.credHelpers.clear();
      return putAllCredHelpers(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link DockerConfig#credHelpers() credHelpers} map. Nulls are not permitted
     * @param entries The entries that will be added to the credHelpers map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllCredHelpers(Map<String, ? extends String> entries) {
      for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
        String k = e.getKey();
        String v = e.getValue();
        this.credHelpers.put(
            Objects.requireNonNull(k, "credHelpers key"),
            v == null ? Objects.requireNonNull(v, "credHelpers value for key: " + k) : v);
      }
      return this;
    }

    /**
     * Put one entry to the {@link DockerConfig#auths() auths} map.
     * @param key The key in the auths map
     * @param value The associated value in the auths map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAuth(String key, RegistryAuth value) {
      this.auths.put(
          Objects.requireNonNull(key, "auths key"),
          value == null ? Objects.requireNonNull(value, "auths value for key: " + key) : value);
      return this;
    }

    /**
     * Put one entry to the {@link DockerConfig#auths() auths} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAuth(Map.Entry<String, ? extends RegistryAuth> entry) {
      String k = entry.getKey();
      RegistryAuth v = entry.getValue();
      this.auths.put(
          Objects.requireNonNull(k, "auths key"),
          v == null ? Objects.requireNonNull(v, "auths value for key: " + k) : v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link DockerConfig#auths() auths} map. Nulls are not permitted
     * @param entries The entries that will be added to the auths map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("auths")
    public final Builder auths(Map<String, ? extends RegistryAuth> entries) {
      this.auths.clear();
      return putAllAuths(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link DockerConfig#auths() auths} map. Nulls are not permitted
     * @param entries The entries that will be added to the auths map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllAuths(Map<String, ? extends RegistryAuth> entries) {
      for (Map.Entry<String, ? extends RegistryAuth> e : entries.entrySet()) {
        String k = e.getKey();
        RegistryAuth v = e.getValue();
        this.auths.put(
            Objects.requireNonNull(k, "auths key"),
            v == null ? Objects.requireNonNull(v, "auths value for key: " + k) : v);
      }
      return this;
    }

    /**
     * Put one entry to the {@link DockerConfig#httpHeaders() httpHeaders} map.
     * @param key The key in the httpHeaders map
     * @param value The associated value in the httpHeaders map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addHttpHeader(String key, String value) {
      this.httpHeaders.put(
          Objects.requireNonNull(key, "httpHeaders key"),
          value == null ? Objects.requireNonNull(value, "httpHeaders value for key: " + key) : value);
      return this;
    }

    /**
     * Put one entry to the {@link DockerConfig#httpHeaders() httpHeaders} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addHttpHeader(Map.Entry<String, ? extends String> entry) {
      String k = entry.getKey();
      String v = entry.getValue();
      this.httpHeaders.put(
          Objects.requireNonNull(k, "httpHeaders key"),
          v == null ? Objects.requireNonNull(v, "httpHeaders value for key: " + k) : v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link DockerConfig#httpHeaders() httpHeaders} map. Nulls are not permitted
     * @param entries The entries that will be added to the httpHeaders map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("HttpHeaders")
    public final Builder httpHeaders(Map<String, ? extends String> entries) {
      this.httpHeaders.clear();
      return putAllHttpHeaders(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link DockerConfig#httpHeaders() httpHeaders} map. Nulls are not permitted
     * @param entries The entries that will be added to the httpHeaders map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllHttpHeaders(Map<String, ? extends String> entries) {
      for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
        String k = e.getKey();
        String v = e.getValue();
        this.httpHeaders.put(
            Objects.requireNonNull(k, "httpHeaders key"),
            v == null ? Objects.requireNonNull(v, "httpHeaders value for key: " + k) : v);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link DockerConfig#credsStore() credsStore} attribute.
     * @param credsStore The value for credsStore (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("credsStore")
    public final Builder credsStore(@Nullable String credsStore) {
      this.credsStore = credsStore;
      return this;
    }

    /**
     * Initializes the value for the {@link DockerConfig#detachKeys() detachKeys} attribute.
     * @param detachKeys The value for detachKeys (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("detachKeys")
    public final Builder detachKeys(@Nullable String detachKeys) {
      this.detachKeys = detachKeys;
      return this;
    }

    /**
     * Initializes the value for the {@link DockerConfig#stackOrchestrator() stackOrchestrator} attribute.
     * @param stackOrchestrator The value for stackOrchestrator (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("stackOrchestrator")
    public final Builder stackOrchestrator(@Nullable String stackOrchestrator) {
      this.stackOrchestrator = stackOrchestrator;
      return this;
    }

    /**
     * Initializes the value for the {@link DockerConfig#psFormat() psFormat} attribute.
     * @param psFormat The value for psFormat (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("psFormat")
    public final Builder psFormat(@Nullable String psFormat) {
      this.psFormat = psFormat;
      return this;
    }

    /**
     * Initializes the value for the {@link DockerConfig#imagesFormat() imagesFormat} attribute.
     * @param imagesFormat The value for imagesFormat (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("imagesFormat")
    public final Builder imagesFormat(@Nullable String imagesFormat) {
      this.imagesFormat = imagesFormat;
      return this;
    }

    /**
     * Builds a new {@link ImmutableDockerConfig ImmutableDockerConfig}.
     * @return An immutable instance of DockerConfig
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableDockerConfig build() {
      return new ImmutableDockerConfig(
          createUnmodifiableMap(false, false, credHelpers),
          createUnmodifiableMap(false, false, auths),
          createUnmodifiableMap(false, false, httpHeaders),
          credsStore,
          detachKeys,
          stackOrchestrator,
          psFormat,
          imagesFormat);
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        if (v == null) Objects.requireNonNull(v, "value for key: " + k);
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            if (v == null) Objects.requireNonNull(v, "value for key: " + k);
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
