/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages.swarm;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Objects;
import org.mandas.docker.client.messages.swarm.Spread;

final class ImmutableSpread
implements Spread {
    private final String spreadDescriptor;

    private ImmutableSpread(String spreadDescriptor) {
        this.spreadDescriptor = spreadDescriptor;
    }

    @Override
    @JsonProperty(value="SpreadDescriptor")
    public String spreadDescriptor() {
        return this.spreadDescriptor;
    }

    public final ImmutableSpread withSpreadDescriptor(String value) {
        String newValue = Objects.requireNonNull(value, "spreadDescriptor");
        if (this.spreadDescriptor.equals(newValue)) {
            return this;
        }
        return new ImmutableSpread(newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSpread && this.equalTo(0, (ImmutableSpread)another);
    }

    private boolean equalTo(int synthetic, ImmutableSpread another) {
        return this.spreadDescriptor.equals(another.spreadDescriptor);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.spreadDescriptor.hashCode();
        return h;
    }

    public String toString() {
        return "Spread{spreadDescriptor=" + this.spreadDescriptor + "}";
    }

    public static ImmutableSpread copyOf(Spread instance) {
        if (instance instanceof ImmutableSpread) {
            return (ImmutableSpread)instance;
        }
        return ImmutableSpread.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    static final class Builder {
        private static final long INIT_BIT_SPREAD_DESCRIPTOR = 1L;
        private long initBits = 1L;
        private String spreadDescriptor;

        private Builder() {
        }

        public final Builder from(Spread instance) {
            Objects.requireNonNull(instance, "instance");
            this.spreadDescriptor(instance.spreadDescriptor());
            return this;
        }

        @JsonProperty(value="SpreadDescriptor")
        public final Builder spreadDescriptor(String spreadDescriptor) {
            this.spreadDescriptor = Objects.requireNonNull(spreadDescriptor, "spreadDescriptor");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableSpread build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSpread(this.spreadDescriptor);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("spreadDescriptor");
            }
            return "Cannot build Spread, some of required attributes are not set " + attributes;
        }
    }
}

