/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages.swarm;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Objects;
import org.mandas.docker.Nullable;
import org.mandas.docker.client.messages.swarm.ConfigFile;

final class ImmutableConfigFile
implements ConfigFile {
    private final String name;
    @Nullable
    private final String uid;
    @Nullable
    private final String gid;
    @Nullable
    private final Long mode;

    private ImmutableConfigFile(String name, @Nullable String uid, @Nullable String gid, @Nullable Long mode) {
        this.name = name;
        this.uid = uid;
        this.gid = gid;
        this.mode = mode;
    }

    @Override
    @JsonProperty(value="Name")
    public String name() {
        return this.name;
    }

    @Override
    @JsonProperty(value="UID")
    @Nullable
    public String uid() {
        return this.uid;
    }

    @Override
    @JsonProperty(value="GID")
    @Nullable
    public String gid() {
        return this.gid;
    }

    @Override
    @JsonProperty(value="Mode")
    @Nullable
    public Long mode() {
        return this.mode;
    }

    public final ImmutableConfigFile withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableConfigFile(newValue, this.uid, this.gid, this.mode);
    }

    public final ImmutableConfigFile withUid(@Nullable String value) {
        if (Objects.equals(this.uid, value)) {
            return this;
        }
        return new ImmutableConfigFile(this.name, value, this.gid, this.mode);
    }

    public final ImmutableConfigFile withGid(@Nullable String value) {
        if (Objects.equals(this.gid, value)) {
            return this;
        }
        return new ImmutableConfigFile(this.name, this.uid, value, this.mode);
    }

    public final ImmutableConfigFile withMode(@Nullable Long value) {
        if (Objects.equals(this.mode, value)) {
            return this;
        }
        return new ImmutableConfigFile(this.name, this.uid, this.gid, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableConfigFile && this.equalTo(0, (ImmutableConfigFile)another);
    }

    private boolean equalTo(int synthetic, ImmutableConfigFile another) {
        return this.name.equals(another.name) && Objects.equals(this.uid, another.uid) && Objects.equals(this.gid, another.gid) && Objects.equals(this.mode, another.mode);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + Objects.hashCode(this.uid);
        h += (h << 5) + Objects.hashCode(this.gid);
        h += (h << 5) + Objects.hashCode(this.mode);
        return h;
    }

    public String toString() {
        return "ConfigFile{name=" + this.name + ", uid=" + this.uid + ", gid=" + this.gid + ", mode=" + this.mode + "}";
    }

    public static ImmutableConfigFile copyOf(ConfigFile instance) {
        if (instance instanceof ImmutableConfigFile) {
            return (ImmutableConfigFile)instance;
        }
        return ImmutableConfigFile.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    static final class Builder
    implements ConfigFile.Builder {
        private static final long INIT_BIT_NAME = 1L;
        private long initBits = 1L;
        private String name;
        private String uid;
        private String gid;
        private Long mode;

        private Builder() {
        }

        public final Builder from(ConfigFile instance) {
            Long modeValue;
            String gidValue;
            Objects.requireNonNull(instance, "instance");
            this.name(instance.name());
            String uidValue = instance.uid();
            if (uidValue != null) {
                this.uid(uidValue);
            }
            if ((gidValue = instance.gid()) != null) {
                this.gid(gidValue);
            }
            if ((modeValue = instance.mode()) != null) {
                this.mode(modeValue);
            }
            return this;
        }

        @Override
        @JsonProperty(value="Name")
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @Override
        @JsonProperty(value="UID")
        public final Builder uid(@Nullable String uid) {
            this.uid = uid;
            return this;
        }

        @Override
        @JsonProperty(value="GID")
        public final Builder gid(@Nullable String gid) {
            this.gid = gid;
            return this;
        }

        @Override
        @JsonProperty(value="Mode")
        public final Builder mode(@Nullable Long mode) {
            this.mode = mode;
            return this;
        }

        @Override
        public ImmutableConfigFile build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableConfigFile(this.name, this.uid, this.gid, this.mode);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            return "Cannot build ConfigFile, some of required attributes are not set " + attributes;
        }
    }
}

