/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.mandas.docker.Nullable;
import org.mandas.docker.client.messages.ServiceCreateResponse;

final class ImmutableServiceCreateResponse
implements ServiceCreateResponse {
    private final String id;
    @Nullable
    private final List<String> warnings;

    private ImmutableServiceCreateResponse(String id, @Nullable List<String> warnings) {
        this.id = id;
        this.warnings = warnings;
    }

    @Override
    @JsonProperty(value="ID")
    public String id() {
        return this.id;
    }

    @Override
    @JsonProperty(value="Warnings")
    @Nullable
    public List<String> warnings() {
        return this.warnings;
    }

    public final ImmutableServiceCreateResponse withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new ImmutableServiceCreateResponse(newValue, this.warnings);
    }

    public final ImmutableServiceCreateResponse withWarnings(String ... elements) {
        if (elements == null) {
            return new ImmutableServiceCreateResponse(this.id, null);
        }
        List<String> newValue = Arrays.asList(elements) == null ? null : ImmutableServiceCreateResponse.createUnmodifiableList(false, ImmutableServiceCreateResponse.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableServiceCreateResponse(this.id, newValue);
    }

    public final ImmutableServiceCreateResponse withWarnings(@Nullable Iterable<String> elements) {
        if (this.warnings == elements) {
            return this;
        }
        List<String> newValue = elements == null ? null : ImmutableServiceCreateResponse.createUnmodifiableList(false, ImmutableServiceCreateResponse.createSafeList(elements, true, false));
        return new ImmutableServiceCreateResponse(this.id, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableServiceCreateResponse && this.equalTo(0, (ImmutableServiceCreateResponse)another);
    }

    private boolean equalTo(int synthetic, ImmutableServiceCreateResponse another) {
        return this.id.equals(another.id) && Objects.equals(this.warnings, another.warnings);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + Objects.hashCode(this.warnings);
        return h;
    }

    public String toString() {
        return "ServiceCreateResponse{id=" + this.id + ", warnings=" + this.warnings + "}";
    }

    public static ImmutableServiceCreateResponse copyOf(ServiceCreateResponse instance) {
        if (instance instanceof ImmutableServiceCreateResponse) {
            return (ImmutableServiceCreateResponse)instance;
        }
        return ImmutableServiceCreateResponse.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private long initBits = 1L;
        private String id;
        private List<String> warnings = null;

        private Builder() {
        }

        public final Builder from(ServiceCreateResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.id(instance.id());
            List<String> warningsValue = instance.warnings();
            if (warningsValue != null) {
                this.addAllWarnings(warningsValue);
            }
            return this;
        }

        @JsonProperty(value="ID")
        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder warning(String element) {
            if (this.warnings == null) {
                this.warnings = new ArrayList<String>();
            }
            this.warnings.add(Objects.requireNonNull(element, "warnings element"));
            return this;
        }

        public final Builder warnings(String ... elements) {
            if (this.warnings == null) {
                this.warnings = new ArrayList<String>();
            }
            for (String element : elements) {
                this.warnings.add(Objects.requireNonNull(element, "warnings element"));
            }
            return this;
        }

        @JsonProperty(value="Warnings")
        public final Builder warnings(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.warnings = null;
                return this;
            }
            this.warnings = new ArrayList<String>();
            return this.addAllWarnings(elements);
        }

        public final Builder addAllWarnings(Iterable<String> elements) {
            Objects.requireNonNull(elements, "warnings element");
            if (this.warnings == null) {
                this.warnings = new ArrayList<String>();
            }
            for (String element : elements) {
                this.warnings.add(Objects.requireNonNull(element, "warnings element"));
            }
            return this;
        }

        public ImmutableServiceCreateResponse build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableServiceCreateResponse(this.id, this.warnings == null ? null : ImmutableServiceCreateResponse.createUnmodifiableList(true, this.warnings));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            return "Cannot build ServiceCreateResponse, some of required attributes are not set " + attributes;
        }
    }
}

