/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.mandas.docker.Nullable;
import org.mandas.docker.client.messages.BlockIoStats;
import org.mandas.docker.client.messages.ContainerStats;
import org.mandas.docker.client.messages.CpuStats;
import org.mandas.docker.client.messages.MemoryStats;
import org.mandas.docker.client.messages.NetworkStats;

final class ImmutableContainerStats
implements ContainerStats {
    private final Date read;
    @Nullable
    private final NetworkStats network;
    @Nullable
    private final Map<String, NetworkStats> networks;
    private final MemoryStats memoryStats;
    private final BlockIoStats blockIoStats;
    private final CpuStats cpuStats;
    private final CpuStats precpuStats;

    private ImmutableContainerStats(Date read, @Nullable NetworkStats network, @Nullable Map<String, NetworkStats> networks, MemoryStats memoryStats, BlockIoStats blockIoStats, CpuStats cpuStats, CpuStats precpuStats) {
        this.read = read;
        this.network = network;
        this.networks = networks;
        this.memoryStats = memoryStats;
        this.blockIoStats = blockIoStats;
        this.cpuStats = cpuStats;
        this.precpuStats = precpuStats;
    }

    @Override
    @JsonProperty(value="read")
    public Date read() {
        return this.read;
    }

    @Override
    @JsonProperty(value="network")
    @Nullable
    public NetworkStats network() {
        return this.network;
    }

    @Override
    @JsonProperty(value="networks")
    @Nullable
    public Map<String, NetworkStats> networks() {
        return this.networks;
    }

    @Override
    @JsonProperty(value="memory_stats")
    public MemoryStats memoryStats() {
        return this.memoryStats;
    }

    @Override
    @JsonProperty(value="blkio_stats")
    public BlockIoStats blockIoStats() {
        return this.blockIoStats;
    }

    @Override
    @JsonProperty(value="cpu_stats")
    public CpuStats cpuStats() {
        return this.cpuStats;
    }

    @Override
    @JsonProperty(value="precpu_stats")
    public CpuStats precpuStats() {
        return this.precpuStats;
    }

    public final ImmutableContainerStats withRead(Date value) {
        if (this.read == value) {
            return this;
        }
        Date newValue = Objects.requireNonNull(value, "read");
        return new ImmutableContainerStats(newValue, this.network, this.networks, this.memoryStats, this.blockIoStats, this.cpuStats, this.precpuStats);
    }

    public final ImmutableContainerStats withNetwork(@Nullable NetworkStats value) {
        if (this.network == value) {
            return this;
        }
        return new ImmutableContainerStats(this.read, value, this.networks, this.memoryStats, this.blockIoStats, this.cpuStats, this.precpuStats);
    }

    public final ImmutableContainerStats withNetworks(@Nullable Map<String, ? extends NetworkStats> entries) {
        if (this.networks == entries) {
            return this;
        }
        Map<String, NetworkStats> newValue = entries == null ? null : ImmutableContainerStats.createUnmodifiableMap(true, false, entries);
        return new ImmutableContainerStats(this.read, this.network, newValue, this.memoryStats, this.blockIoStats, this.cpuStats, this.precpuStats);
    }

    public final ImmutableContainerStats withMemoryStats(MemoryStats value) {
        if (this.memoryStats == value) {
            return this;
        }
        MemoryStats newValue = Objects.requireNonNull(value, "memoryStats");
        return new ImmutableContainerStats(this.read, this.network, this.networks, newValue, this.blockIoStats, this.cpuStats, this.precpuStats);
    }

    public final ImmutableContainerStats withBlockIoStats(BlockIoStats value) {
        if (this.blockIoStats == value) {
            return this;
        }
        BlockIoStats newValue = Objects.requireNonNull(value, "blockIoStats");
        return new ImmutableContainerStats(this.read, this.network, this.networks, this.memoryStats, newValue, this.cpuStats, this.precpuStats);
    }

    public final ImmutableContainerStats withCpuStats(CpuStats value) {
        if (this.cpuStats == value) {
            return this;
        }
        CpuStats newValue = Objects.requireNonNull(value, "cpuStats");
        return new ImmutableContainerStats(this.read, this.network, this.networks, this.memoryStats, this.blockIoStats, newValue, this.precpuStats);
    }

    public final ImmutableContainerStats withPrecpuStats(CpuStats value) {
        if (this.precpuStats == value) {
            return this;
        }
        CpuStats newValue = Objects.requireNonNull(value, "precpuStats");
        return new ImmutableContainerStats(this.read, this.network, this.networks, this.memoryStats, this.blockIoStats, this.cpuStats, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableContainerStats && this.equalTo(0, (ImmutableContainerStats)another);
    }

    private boolean equalTo(int synthetic, ImmutableContainerStats another) {
        return this.read.equals(another.read) && Objects.equals(this.network, another.network) && Objects.equals(this.networks, another.networks) && this.memoryStats.equals(another.memoryStats) && this.blockIoStats.equals(another.blockIoStats) && this.cpuStats.equals(another.cpuStats) && this.precpuStats.equals(another.precpuStats);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.read.hashCode();
        h += (h << 5) + Objects.hashCode(this.network);
        h += (h << 5) + Objects.hashCode(this.networks);
        h += (h << 5) + this.memoryStats.hashCode();
        h += (h << 5) + this.blockIoStats.hashCode();
        h += (h << 5) + this.cpuStats.hashCode();
        h += (h << 5) + this.precpuStats.hashCode();
        return h;
    }

    public String toString() {
        return "ContainerStats{read=" + this.read + ", network=" + this.network + ", networks=" + this.networks + ", memoryStats=" + this.memoryStats + ", blockIoStats=" + this.blockIoStats + ", cpuStats=" + this.cpuStats + ", precpuStats=" + this.precpuStats + "}";
    }

    public static ImmutableContainerStats copyOf(ContainerStats instance) {
        if (instance instanceof ImmutableContainerStats) {
            return (ImmutableContainerStats)instance;
        }
        return ImmutableContainerStats.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    if (v == null) {
                        Objects.requireNonNull(v, "value for key: " + k);
                    }
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    if (v == null) {
                        Objects.requireNonNull(v, "value for key: " + k);
                    }
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    static final class Builder {
        private static final long INIT_BIT_READ = 1L;
        private static final long INIT_BIT_MEMORY_STATS = 2L;
        private static final long INIT_BIT_BLOCK_IO_STATS = 4L;
        private static final long INIT_BIT_CPU_STATS = 8L;
        private static final long INIT_BIT_PRECPU_STATS = 16L;
        private long initBits = 31L;
        private Date read;
        private NetworkStats network;
        private Map<String, NetworkStats> networks = null;
        private MemoryStats memoryStats;
        private BlockIoStats blockIoStats;
        private CpuStats cpuStats;
        private CpuStats precpuStats;

        private Builder() {
        }

        public final Builder from(ContainerStats instance) {
            Map<String, NetworkStats> networksValue;
            Objects.requireNonNull(instance, "instance");
            this.read(instance.read());
            NetworkStats networkValue = instance.network();
            if (networkValue != null) {
                this.network(networkValue);
            }
            if ((networksValue = instance.networks()) != null) {
                this.putAllNetworks(networksValue);
            }
            this.memoryStats(instance.memoryStats());
            this.blockIoStats(instance.blockIoStats());
            this.cpuStats(instance.cpuStats());
            this.precpuStats(instance.precpuStats());
            return this;
        }

        @JsonProperty(value="read")
        public final Builder read(Date read) {
            this.read = Objects.requireNonNull(read, "read");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="network")
        public final Builder network(@Nullable NetworkStats network) {
            this.network = network;
            return this;
        }

        public final Builder addNetwork(String key, NetworkStats value) {
            if (this.networks == null) {
                this.networks = new LinkedHashMap<String, NetworkStats>();
            }
            this.networks.put(Objects.requireNonNull(key, "networks key"), value == null ? Objects.requireNonNull(value, "networks value for key: " + key) : value);
            return this;
        }

        public final Builder addNetwork(Map.Entry<String, ? extends NetworkStats> entry) {
            NetworkStats v;
            if (this.networks == null) {
                this.networks = new LinkedHashMap<String, NetworkStats>();
            }
            String k = entry.getKey();
            this.networks.put(Objects.requireNonNull(k, "networks key"), (v = entry.getValue()) == null ? Objects.requireNonNull(v, "networks value for key: " + k) : v);
            return this;
        }

        @JsonProperty(value="networks")
        public final Builder networks(@Nullable Map<String, ? extends NetworkStats> entries) {
            if (entries == null) {
                this.networks = null;
                return this;
            }
            this.networks = new LinkedHashMap<String, NetworkStats>();
            return this.putAllNetworks(entries);
        }

        public final Builder putAllNetworks(Map<String, ? extends NetworkStats> entries) {
            if (this.networks == null) {
                this.networks = new LinkedHashMap<String, NetworkStats>();
            }
            for (Map.Entry<String, ? extends NetworkStats> e : entries.entrySet()) {
                NetworkStats v;
                String k = e.getKey();
                this.networks.put(Objects.requireNonNull(k, "networks key"), (v = e.getValue()) == null ? Objects.requireNonNull(v, "networks value for key: " + k) : v);
            }
            return this;
        }

        @JsonProperty(value="memory_stats")
        public final Builder memoryStats(MemoryStats memoryStats) {
            this.memoryStats = Objects.requireNonNull(memoryStats, "memoryStats");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="blkio_stats")
        public final Builder blockIoStats(BlockIoStats blockIoStats) {
            this.blockIoStats = Objects.requireNonNull(blockIoStats, "blockIoStats");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="cpu_stats")
        public final Builder cpuStats(CpuStats cpuStats) {
            this.cpuStats = Objects.requireNonNull(cpuStats, "cpuStats");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="precpu_stats")
        public final Builder precpuStats(CpuStats precpuStats) {
            this.precpuStats = Objects.requireNonNull(precpuStats, "precpuStats");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public ImmutableContainerStats build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableContainerStats(this.read, this.network, this.networks == null ? null : ImmutableContainerStats.createUnmodifiableMap(false, false, this.networks), this.memoryStats, this.blockIoStats, this.cpuStats, this.precpuStats);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("read");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("memoryStats");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("blockIoStats");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("cpuStats");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("precpuStats");
            }
            return "Cannot build ContainerStats, some of required attributes are not set " + attributes;
        }
    }
}

