/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.builder;

import jakarta.ws.rs.client.Client;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.conn.BasicHttpClientConnectionManager;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.mandas.docker.client.DefaultDockerClient;
import org.mandas.docker.client.DockerCertificates;
import org.mandas.docker.client.DockerCertificatesStore;
import org.mandas.docker.client.DockerHost;
import org.mandas.docker.client.ObjectMapperProvider;
import org.mandas.docker.client.UnixConnectionSocketFactory;
import org.mandas.docker.client.auth.ConfigFileRegistryAuthSupplier;
import org.mandas.docker.client.auth.RegistryAuthSupplier;
import org.mandas.docker.client.builder.DockerClientBuilder;
import org.mandas.docker.client.builder.ProxyConfiguration;
import org.mandas.docker.client.exceptions.DockerCertificateException;
import org.mandas.docker.client.npipe.NpipeConnectionSocketFactory;

public abstract class BaseDockerClientBuilder<B extends BaseDockerClientBuilder<B>>
implements DockerClientBuilder<B> {
    protected String UNIX_SCHEME = "unix";
    protected String NPIPE_SCHEME = "npipe";
    protected long DEFAULT_CONNECT_TIMEOUT_MILLIS = TimeUnit.SECONDS.toMillis(5L);
    protected long DEFAULT_READ_TIMEOUT_MILLIS = TimeUnit.SECONDS.toMillis(30L);
    protected int DEFAULT_CONNECTION_POOL_SIZE = 100;
    protected String ERROR_MESSAGE = "LOGIC ERROR: DefaultDockerClient does not support being built with both `registryAuth` and `registryAuthSupplier`. Please build with at most one of these options.";
    protected URI uri;
    protected String apiVersion;
    protected long connectTimeoutMillis = this.DEFAULT_CONNECT_TIMEOUT_MILLIS;
    protected long readTimeoutMillis = this.DEFAULT_READ_TIMEOUT_MILLIS;
    protected int connectionPoolSize = this.DEFAULT_CONNECTION_POOL_SIZE;
    protected DockerCertificatesStore dockerCertificatesStore;
    protected boolean useProxy = true;
    protected RegistryAuthSupplier registryAuthSupplier;
    protected Map<String, Object> headers = new HashMap<String, Object>();
    protected Client client;
    protected Client noTimeoutClient;
    protected DockerClientBuilder.EntityProcessing entityProcessing;

    private B self() {
        return (B)this;
    }

    @Override
    public B fromEnv() throws DockerCertificateException {
        String endpoint = DockerHost.endpointFromEnv();
        Path dockerCertPath = Paths.get(Arrays.asList(DockerHost.certPathFromEnv(), DockerHost.configPathFromEnv(), DockerHost.defaultCertPath()).stream().filter(cert -> cert != null).findFirst().orElseThrow(() -> new NoSuchElementException("Cannot find docker certificated path")), new String[0]);
        Optional<DockerCertificatesStore> certs = DockerCertificates.builder().dockerCertPath(dockerCertPath).build();
        if (endpoint.startsWith(this.UNIX_SCHEME + "://")) {
            this.uri(endpoint);
        } else if (endpoint.startsWith(this.NPIPE_SCHEME + "://")) {
            this.uri(endpoint);
        } else {
            String stripped = endpoint.replaceAll(".*://", "");
            String scheme = certs.isPresent() ? "https" : "http";
            URI initialUri = URI.create(scheme + "://" + stripped);
            if (initialUri.getPort() == -1 && initialUri.getHost() == null) {
                initialUri = URI.create(scheme + "://" + DockerHost.defaultAddress() + ":" + DockerHost.defaultPort());
            } else if (initialUri.getHost() == null) {
                initialUri = URI.create(scheme + "://" + DockerHost.defaultAddress() + ":" + initialUri.getPort());
            } else if (initialUri.getPort() == -1) {
                initialUri = URI.create(scheme + "://" + initialUri.getHost() + ":" + DockerHost.defaultPort());
            }
            this.uri(initialUri);
        }
        if (certs.isPresent()) {
            this.dockerCertificates(certs.get());
        }
        return this.self();
    }

    @Override
    public B uri(URI uri) {
        this.uri = uri;
        return this.self();
    }

    @Override
    public B uri(String uri) {
        return (B)this.uri(URI.create(uri));
    }

    @Override
    public B apiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this.self();
    }

    @Override
    public B connectTimeoutMillis(long connectTimeoutMillis) {
        this.connectTimeoutMillis = connectTimeoutMillis;
        return this.self();
    }

    @Override
    public B readTimeoutMillis(long readTimeoutMillis) {
        this.readTimeoutMillis = readTimeoutMillis;
        return this.self();
    }

    @Override
    public B dockerCertificates(DockerCertificatesStore dockerCertificatesStore) {
        this.dockerCertificatesStore = dockerCertificatesStore;
        return this.self();
    }

    @Override
    public B connectionPoolSize(int connectionPoolSize) {
        this.connectionPoolSize = connectionPoolSize;
        return this.self();
    }

    @Override
    public B useProxy(boolean useProxy) {
        this.useProxy = useProxy;
        return this.self();
    }

    @Override
    public B registryAuthSupplier(RegistryAuthSupplier registryAuthSupplier) {
        if (this.registryAuthSupplier != null) {
            throw new IllegalStateException(this.ERROR_MESSAGE);
        }
        this.registryAuthSupplier = registryAuthSupplier;
        return this.self();
    }

    @Override
    public B header(String name, Object value) {
        this.headers.put(name, value);
        return this.self();
    }

    @Override
    public URI uri() {
        return this.uri;
    }

    @Override
    public B entityProcessing(DockerClientBuilder.EntityProcessing entityProcessing) {
        this.entityProcessing = entityProcessing;
        return this.self();
    }

    private String toRegExp(String hostnameWithWildcards) {
        return hostnameWithWildcards.replace(".", "\\.").replace("*", ".*");
    }

    protected abstract Client createClient();

    protected abstract Client createNoTimeoutClient();

    protected ProxyConfiguration proxyFromEnv() {
        String proxyHost = System.getProperty("http.proxyHost");
        if (proxyHost == null) {
            return null;
        }
        String nonProxyHosts = System.getProperty("http.nonProxyHosts");
        if (nonProxyHosts != null) {
            String[] nonProxy = nonProxyHosts.replaceAll("^\\s*\"", "").replaceAll("\\s*\"$", "").split("\\|");
            String host = Optional.ofNullable(this.uri.getHost()).orElse("localhost");
            for (String h : nonProxy) {
                if (!host.matches(this.toRegExp(h))) continue;
                return null;
            }
        }
        return ProxyConfiguration.builder().host(proxyHost).port(System.getProperty("http.proxyPort")).username(System.getProperty("http.proxyUser")).password(System.getProperty("http.proxyPassword")).build();
    }

    @Override
    public DefaultDockerClient build() {
        Objects.requireNonNull(this.uri, "uri");
        Objects.requireNonNull(this.uri.getScheme(), "url has null scheme");
        if (this.dockerCertificatesStore != null && !this.uri.getScheme().equals("https")) {
            throw new IllegalArgumentException("An HTTPS URI for DOCKER_HOST must be provided to use Docker client certificates");
        }
        this.client = (Client)this.createClient().register(ObjectMapperProvider.class);
        this.noTimeoutClient = (Client)this.createNoTimeoutClient().register(ObjectMapperProvider.class);
        if (this.uri.getScheme().equals(this.UNIX_SCHEME)) {
            this.uri = UnixConnectionSocketFactory.sanitizeUri(this.uri);
        } else if (this.uri.getScheme().equals(this.NPIPE_SCHEME)) {
            this.uri = NpipeConnectionSocketFactory.sanitizeUri(this.uri);
        }
        if (this.registryAuthSupplier == null) {
            this.registryAuthSupplier(new ConfigFileRegistryAuthSupplier());
        }
        return new DefaultDockerClient(this.apiVersion, this.registryAuthSupplier, this.uri, this.client, this.noTimeoutClient, this.headers);
    }

    protected HttpClientConnectionManager getConnectionManager(URI uri, Registry<ConnectionSocketFactory> schemeRegistry, int connectionPoolSize) {
        if (uri.getScheme().equals(this.NPIPE_SCHEME)) {
            return new BasicHttpClientConnectionManager(schemeRegistry);
        }
        PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager(schemeRegistry);
        cm.setMaxTotal(connectionPoolSize);
        cm.setDefaultMaxPerRoute(cm.getMaxTotal());
        return cm;
    }

    protected Registry<ConnectionSocketFactory> getSchemeRegistry(URI uri, DockerCertificatesStore certificateStore) {
        SSLConnectionSocketFactory https = this.dockerCertificatesStore == null ? SSLConnectionSocketFactory.getSocketFactory() : new SSLConnectionSocketFactory(this.dockerCertificatesStore.sslContext(), this.dockerCertificatesStore.hostnameVerifier());
        RegistryBuilder registryBuilder = RegistryBuilder.create().register("https", (Object)https).register("http", (Object)PlainConnectionSocketFactory.getSocketFactory());
        if (uri.getScheme().equals(this.UNIX_SCHEME)) {
            registryBuilder.register(this.UNIX_SCHEME, (Object)new UnixConnectionSocketFactory(uri));
        }
        if (uri.getScheme().equals(this.NPIPE_SCHEME)) {
            registryBuilder.register(this.NPIPE_SCHEME, (Object)new NpipeConnectionSocketFactory(uri));
        }
        return registryBuilder.build();
    }
}

