package org.mandas.docker.client.messages;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.mandas.docker.Nullable;
import org.mandas.docker.client.messages.mount.Mount;

/**
 * Immutable implementation of {@link HostConfig}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableHostConfig.builder()}.
 */
@SuppressWarnings({"all", "deprecation", "removal"})
final class ImmutableHostConfig implements HostConfig {
  private final @Nullable List<String> binds;
  private final @Nullable Integer blkioWeight;
  private final @Nullable List<HostConfig.BlkioWeightDevice> blkioWeightDevice;
  private final @Nullable List<HostConfig.BlkioDeviceRate> blkioDeviceReadBps;
  private final @Nullable List<HostConfig.BlkioDeviceRate> blkioDeviceWriteBps;
  private final @Nullable List<HostConfig.BlkioDeviceRate> blkioDeviceReadIOps;
  private final @Nullable List<HostConfig.BlkioDeviceRate> blkioDeviceWriteIOps;
  private final @Nullable String containerIdFile;
  private final @Nullable List<HostConfig.LxcConfParameter> lxcConf;
  private final @Nullable Boolean privileged;
  private final @Nullable Map<String, List<PortBinding>> portBindings;
  private final @Nullable List<String> links;
  private final @Nullable Boolean publishAllPorts;
  private final @Nullable List<String> dns;
  private final @Nullable List<String> dnsOptions;
  private final @Nullable List<String> dnsSearch;
  private final @Nullable List<String> extraHosts;
  private final @Nullable List<String> groupAdd;
  private final @Nullable List<String> volumesFrom;
  private final @Nullable List<String> capAdd;
  private final @Nullable List<String> capDrop;
  private final @Nullable String networkMode;
  private final @Nullable List<String> securityOpt;
  private final @Nullable List<Device> devices;
  private final @Nullable Long memory;
  private final @Nullable Long memorySwap;
  private final @Nullable Long kernelMemory;
  private final @Nullable Integer memorySwappiness;
  private final @Nullable Long memoryReservation;
  private final @Nullable Long nanoCpus;
  private final @Nullable Long cpuPeriod;
  private final @Nullable Long cpuShares;
  private final @Nullable String cpusetCpus;
  private final @Nullable String cpusetMems;
  private final @Nullable Long cpuQuota;
  private final @Nullable String cgroupParent;
  private final @Nullable HostConfig.RestartPolicy restartPolicy;
  private final @Nullable LogConfig logConfig;
  private final @Nullable String ipcMode;
  private final @Nullable List<HostConfig.Ulimit> ulimits;
  private final @Nullable String pidMode;
  private final @Nullable Long shmSize;
  private final @Nullable Boolean oomKillDisable;
  private final @Nullable Integer oomScoreAdj;
  private final @Nullable Boolean autoRemove;
  private final @Nullable Integer pidsLimit;
  private final @Nullable Map<String, String> tmpfs;
  private final @Nullable Boolean readonlyRootfs;
  private final @Nullable Map<String, String> storageOpt;
  private final @Nullable String runtime;
  private final @Nullable List<Mount> mounts;
  private final @Nullable Boolean init;
  private final Map<String, String> sysctls;
  private final @Nullable List<HostConfig.DeviceRequest> deviceRequests;
  private transient final HostConfig.Builder toBuilder;

  private ImmutableHostConfig(
      @Nullable List<String> binds,
      @Nullable Integer blkioWeight,
      @Nullable List<HostConfig.BlkioWeightDevice> blkioWeightDevice,
      @Nullable List<HostConfig.BlkioDeviceRate> blkioDeviceReadBps,
      @Nullable List<HostConfig.BlkioDeviceRate> blkioDeviceWriteBps,
      @Nullable List<HostConfig.BlkioDeviceRate> blkioDeviceReadIOps,
      @Nullable List<HostConfig.BlkioDeviceRate> blkioDeviceWriteIOps,
      @Nullable String containerIdFile,
      @Nullable List<HostConfig.LxcConfParameter> lxcConf,
      @Nullable Boolean privileged,
      @Nullable Map<String, List<PortBinding>> portBindings,
      @Nullable List<String> links,
      @Nullable Boolean publishAllPorts,
      @Nullable List<String> dns,
      @Nullable List<String> dnsOptions,
      @Nullable List<String> dnsSearch,
      @Nullable List<String> extraHosts,
      @Nullable List<String> groupAdd,
      @Nullable List<String> volumesFrom,
      @Nullable List<String> capAdd,
      @Nullable List<String> capDrop,
      @Nullable String networkMode,
      @Nullable List<String> securityOpt,
      @Nullable List<Device> devices,
      @Nullable Long memory,
      @Nullable Long memorySwap,
      @Nullable Long kernelMemory,
      @Nullable Integer memorySwappiness,
      @Nullable Long memoryReservation,
      @Nullable Long nanoCpus,
      @Nullable Long cpuPeriod,
      @Nullable Long cpuShares,
      @Nullable String cpusetCpus,
      @Nullable String cpusetMems,
      @Nullable Long cpuQuota,
      @Nullable String cgroupParent,
      @Nullable HostConfig.RestartPolicy restartPolicy,
      @Nullable LogConfig logConfig,
      @Nullable String ipcMode,
      @Nullable List<HostConfig.Ulimit> ulimits,
      @Nullable String pidMode,
      @Nullable Long shmSize,
      @Nullable Boolean oomKillDisable,
      @Nullable Integer oomScoreAdj,
      @Nullable Boolean autoRemove,
      @Nullable Integer pidsLimit,
      @Nullable Map<String, String> tmpfs,
      @Nullable Boolean readonlyRootfs,
      @Nullable Map<String, String> storageOpt,
      @Nullable String runtime,
      @Nullable List<Mount> mounts,
      @Nullable Boolean init,
      Map<String, String> sysctls,
      @Nullable List<HostConfig.DeviceRequest> deviceRequests) {
    this.binds = binds;
    this.blkioWeight = blkioWeight;
    this.blkioWeightDevice = blkioWeightDevice;
    this.blkioDeviceReadBps = blkioDeviceReadBps;
    this.blkioDeviceWriteBps = blkioDeviceWriteBps;
    this.blkioDeviceReadIOps = blkioDeviceReadIOps;
    this.blkioDeviceWriteIOps = blkioDeviceWriteIOps;
    this.containerIdFile = containerIdFile;
    this.lxcConf = lxcConf;
    this.privileged = privileged;
    this.portBindings = portBindings;
    this.links = links;
    this.publishAllPorts = publishAllPorts;
    this.dns = dns;
    this.dnsOptions = dnsOptions;
    this.dnsSearch = dnsSearch;
    this.extraHosts = extraHosts;
    this.groupAdd = groupAdd;
    this.volumesFrom = volumesFrom;
    this.capAdd = capAdd;
    this.capDrop = capDrop;
    this.networkMode = networkMode;
    this.securityOpt = securityOpt;
    this.devices = devices;
    this.memory = memory;
    this.memorySwap = memorySwap;
    this.kernelMemory = kernelMemory;
    this.memorySwappiness = memorySwappiness;
    this.memoryReservation = memoryReservation;
    this.nanoCpus = nanoCpus;
    this.cpuPeriod = cpuPeriod;
    this.cpuShares = cpuShares;
    this.cpusetCpus = cpusetCpus;
    this.cpusetMems = cpusetMems;
    this.cpuQuota = cpuQuota;
    this.cgroupParent = cgroupParent;
    this.restartPolicy = restartPolicy;
    this.logConfig = logConfig;
    this.ipcMode = ipcMode;
    this.ulimits = ulimits;
    this.pidMode = pidMode;
    this.shmSize = shmSize;
    this.oomKillDisable = oomKillDisable;
    this.oomScoreAdj = oomScoreAdj;
    this.autoRemove = autoRemove;
    this.pidsLimit = pidsLimit;
    this.tmpfs = tmpfs;
    this.readonlyRootfs = readonlyRootfs;
    this.storageOpt = storageOpt;
    this.runtime = runtime;
    this.mounts = mounts;
    this.init = init;
    this.sysctls = sysctls;
    this.deviceRequests = deviceRequests;
    this.toBuilder = Objects.requireNonNull(HostConfig.super.toBuilder(), "toBuilder");
  }

  /**
   * @return The value of the {@code binds} attribute
   */
  @JsonProperty("Binds")
  @Override
  public @Nullable List<String> binds() {
    return binds;
  }

  /**
   * @return The value of the {@code blkioWeight} attribute
   */
  @JsonProperty("BlkioWeight")
  @Override
  public @Nullable Integer blkioWeight() {
    return blkioWeight;
  }

  /**
   * @return The value of the {@code blkioWeightDevice} attribute
   */
  @JsonProperty("BlkioWeightDevice")
  @Override
  public @Nullable List<HostConfig.BlkioWeightDevice> blkioWeightDevice() {
    return blkioWeightDevice;
  }

  /**
   * @return The value of the {@code blkioDeviceReadBps} attribute
   */
  @JsonProperty("BlkioDeviceReadBps")
  @Override
  public @Nullable List<HostConfig.BlkioDeviceRate> blkioDeviceReadBps() {
    return blkioDeviceReadBps;
  }

  /**
   * @return The value of the {@code blkioDeviceWriteBps} attribute
   */
  @JsonProperty("BlkioDeviceWriteBps")
  @Override
  public @Nullable List<HostConfig.BlkioDeviceRate> blkioDeviceWriteBps() {
    return blkioDeviceWriteBps;
  }

  /**
   * @return The value of the {@code blkioDeviceReadIOps} attribute
   */
  @JsonProperty("BlkioDeviceReadIOps")
  @Override
  public @Nullable List<HostConfig.BlkioDeviceRate> blkioDeviceReadIOps() {
    return blkioDeviceReadIOps;
  }

  /**
   * @return The value of the {@code blkioDeviceWriteIOps} attribute
   */
  @JsonProperty("BlkioDeviceWriteIOps")
  @Override
  public @Nullable List<HostConfig.BlkioDeviceRate> blkioDeviceWriteIOps() {
    return blkioDeviceWriteIOps;
  }

  /**
   * @return The value of the {@code containerIdFile} attribute
   */
  @JsonProperty("ContainerIDFile")
  @Override
  public @Nullable String containerIdFile() {
    return containerIdFile;
  }

  /**
   * @return The value of the {@code lxcConf} attribute
   */
  @JsonProperty("LxcConf")
  @Override
  public @Nullable List<HostConfig.LxcConfParameter> lxcConf() {
    return lxcConf;
  }

  /**
   * @return The value of the {@code privileged} attribute
   */
  @JsonProperty("Privileged")
  @Override
  public @Nullable Boolean privileged() {
    return privileged;
  }

  /**
   * @return The value of the {@code portBindings} attribute
   */
  @JsonProperty("PortBindings")
  @Override
  public @Nullable Map<String, List<PortBinding>> portBindings() {
    return portBindings;
  }

  /**
   * @return The value of the {@code links} attribute
   */
  @JsonProperty("Links")
  @Override
  public @Nullable List<String> links() {
    return links;
  }

  /**
   * @return The value of the {@code publishAllPorts} attribute
   */
  @JsonProperty("PublishAllPorts")
  @Override
  public @Nullable Boolean publishAllPorts() {
    return publishAllPorts;
  }

  /**
   * @return The value of the {@code dns} attribute
   */
  @JsonProperty("Dns")
  @Override
  public @Nullable List<String> dns() {
    return dns;
  }

  /**
   * @return The value of the {@code dnsOptions} attribute
   */
  @JsonProperty("DnsOptions")
  @Override
  public @Nullable List<String> dnsOptions() {
    return dnsOptions;
  }

  /**
   * @return The value of the {@code dnsSearch} attribute
   */
  @JsonProperty("DnsSearch")
  @Override
  public @Nullable List<String> dnsSearch() {
    return dnsSearch;
  }

  /**
   * @return The value of the {@code extraHosts} attribute
   */
  @JsonProperty("ExtraHosts")
  @Override
  public @Nullable List<String> extraHosts() {
    return extraHosts;
  }

  /**
   * @return The value of the {@code groupAdd} attribute
   */
  @JsonProperty("GroupAdd")
  @Override
  public @Nullable List<String> groupAdd() {
    return groupAdd;
  }

  /**
   * @return The value of the {@code volumesFrom} attribute
   */
  @JsonProperty("VolumesFrom")
  @Override
  public @Nullable List<String> volumesFrom() {
    return volumesFrom;
  }

  /**
   * @return The value of the {@code capAdd} attribute
   */
  @JsonProperty("CapAdd")
  @Override
  public @Nullable List<String> capAdd() {
    return capAdd;
  }

  /**
   * @return The value of the {@code capDrop} attribute
   */
  @JsonProperty("CapDrop")
  @Override
  public @Nullable List<String> capDrop() {
    return capDrop;
  }

  /**
   * @return The value of the {@code networkMode} attribute
   */
  @JsonProperty("NetworkMode")
  @Override
  public @Nullable String networkMode() {
    return networkMode;
  }

  /**
   * @return The value of the {@code securityOpt} attribute
   */
  @JsonProperty("SecurityOpt")
  @Override
  public @Nullable List<String> securityOpt() {
    return securityOpt;
  }

  /**
   * @return The value of the {@code devices} attribute
   */
  @JsonProperty("Devices")
  @Override
  public @Nullable List<Device> devices() {
    return devices;
  }

  /**
   * @return The value of the {@code memory} attribute
   */
  @JsonProperty("Memory")
  @Override
  public @Nullable Long memory() {
    return memory;
  }

  /**
   * @return The value of the {@code memorySwap} attribute
   */
  @JsonProperty("MemorySwap")
  @Override
  public @Nullable Long memorySwap() {
    return memorySwap;
  }

  /**
   * @return The value of the {@code kernelMemory} attribute
   */
  @JsonProperty("KernelMemory")
  @Deprecated
  @Override
  public @Nullable Long kernelMemory() {
    return kernelMemory;
  }

  /**
   * @return The value of the {@code memorySwappiness} attribute
   */
  @JsonProperty("MemorySwappiness")
  @Override
  public @Nullable Integer memorySwappiness() {
    return memorySwappiness;
  }

  /**
   * @return The value of the {@code memoryReservation} attribute
   */
  @JsonProperty("MemoryReservation")
  @Override
  public @Nullable Long memoryReservation() {
    return memoryReservation;
  }

  /**
   * @return The value of the {@code nanoCpus} attribute
   */
  @JsonProperty("NanoCpus")
  @Override
  public @Nullable Long nanoCpus() {
    return nanoCpus;
  }

  /**
   * @return The value of the {@code cpuPeriod} attribute
   */
  @JsonProperty("CpuPeriod")
  @Override
  public @Nullable Long cpuPeriod() {
    return cpuPeriod;
  }

  /**
   * @return The value of the {@code cpuShares} attribute
   */
  @JsonProperty("CpuShares")
  @Override
  public @Nullable Long cpuShares() {
    return cpuShares;
  }

  /**
   * @return The value of the {@code cpusetCpus} attribute
   */
  @JsonProperty("CpusetCpus")
  @Override
  public @Nullable String cpusetCpus() {
    return cpusetCpus;
  }

  /**
   * @return The value of the {@code cpusetMems} attribute
   */
  @JsonProperty("CpusetMems")
  @Override
  public @Nullable String cpusetMems() {
    return cpusetMems;
  }

  /**
   * @return The value of the {@code cpuQuota} attribute
   */
  @JsonProperty("CpuQuota")
  @Override
  public @Nullable Long cpuQuota() {
    return cpuQuota;
  }

  /**
   * @return The value of the {@code cgroupParent} attribute
   */
  @JsonProperty("CgroupParent")
  @Override
  public @Nullable String cgroupParent() {
    return cgroupParent;
  }

  /**
   * @return The value of the {@code restartPolicy} attribute
   */
  @JsonProperty("RestartPolicy")
  @Override
  public @Nullable HostConfig.RestartPolicy restartPolicy() {
    return restartPolicy;
  }

  /**
   * @return The value of the {@code logConfig} attribute
   */
  @JsonProperty("LogConfig")
  @Override
  public @Nullable LogConfig logConfig() {
    return logConfig;
  }

  /**
   * @return The value of the {@code ipcMode} attribute
   */
  @JsonProperty("IpcMode")
  @Override
  public @Nullable String ipcMode() {
    return ipcMode;
  }

  /**
   * @return The value of the {@code ulimits} attribute
   */
  @JsonProperty("Ulimits")
  @Override
  public @Nullable List<HostConfig.Ulimit> ulimits() {
    return ulimits;
  }

  /**
   * @return The value of the {@code pidMode} attribute
   */
  @JsonProperty("PidMode")
  @Override
  public @Nullable String pidMode() {
    return pidMode;
  }

  /**
   * @return The value of the {@code shmSize} attribute
   */
  @JsonProperty("ShmSize")
  @Override
  public @Nullable Long shmSize() {
    return shmSize;
  }

  /**
   * @return The value of the {@code oomKillDisable} attribute
   */
  @JsonProperty("OomKillDisable")
  @Override
  public @Nullable Boolean oomKillDisable() {
    return oomKillDisable;
  }

  /**
   * @return The value of the {@code oomScoreAdj} attribute
   */
  @JsonProperty("OomScoreAdj")
  @Override
  public @Nullable Integer oomScoreAdj() {
    return oomScoreAdj;
  }

  /**
   * @return The value of the {@code autoRemove} attribute
   */
  @JsonProperty("AutoRemove")
  @Override
  public @Nullable Boolean autoRemove() {
    return autoRemove;
  }

  /**
   * @return The value of the {@code pidsLimit} attribute
   */
  @JsonProperty("PidsLimit")
  @Override
  public @Nullable Integer pidsLimit() {
    return pidsLimit;
  }

  /**
   * @return The value of the {@code tmpfs} attribute
   */
  @JsonProperty("Tmpfs")
  @Override
  public @Nullable Map<String, String> tmpfs() {
    return tmpfs;
  }

  /**
   * @return The value of the {@code readonlyRootfs} attribute
   */
  @JsonProperty("ReadonlyRootfs")
  @Override
  public @Nullable Boolean readonlyRootfs() {
    return readonlyRootfs;
  }

  /**
   * @return The value of the {@code storageOpt} attribute
   */
  @JsonProperty("StorageOpt")
  @Override
  public @Nullable Map<String, String> storageOpt() {
    return storageOpt;
  }

  /**
   * @return The value of the {@code runtime} attribute
   */
  @JsonProperty("Runtime")
  @Override
  public @Nullable String runtime() {
    return runtime;
  }

  /**
   * @return The value of the {@code mounts} attribute
   */
  @JsonProperty("Mounts")
  @Override
  public @Nullable List<Mount> mounts() {
    return mounts;
  }

  /**
   * @return The value of the {@code init} attribute
   */
  @JsonProperty("Init")
  @Override
  public @Nullable Boolean init() {
    return init;
  }

  /**
   * @return The value of the {@code sysctls} attribute
   */
  @JsonProperty("Sysctls")
  @Override
  public Map<String, String> sysctls() {
    return sysctls;
  }

  /**
   * @return The value of the {@code deviceRequests} attribute
   */
  @JsonProperty("DeviceRequests")
  @Override
  public @Nullable List<HostConfig.DeviceRequest> deviceRequests() {
    return deviceRequests;
  }

  /**
   * @return The computed-at-construction value of the {@code toBuilder} attribute
   */
  @JsonProperty("toBuilder")
  @JsonIgnore
  @Override
  public HostConfig.Builder toBuilder() {
    return toBuilder;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link HostConfig#binds() binds}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableHostConfig withBinds(@Nullable String... elements) {
    if (elements == null) {
      return validate(new ImmutableHostConfig(
          null,
          this.blkioWeight,
          this.blkioWeightDevice,
          this.blkioDeviceReadBps,
          this.blkioDeviceWriteBps,
          this.blkioDeviceReadIOps,
          this.blkioDeviceWriteIOps,
          this.containerIdFile,
          this.lxcConf,
          this.privileged,
          this.portBindings,
          this.links,
          this.publishAllPorts,
          this.dns,
          this.dnsOptions,
          this.dnsSearch,
          this.extraHosts,
          this.groupAdd,
          this.volumesFrom,
          this.capAdd,
          this.capDrop,
          this.networkMode,
          this.securityOpt,
          this.devices,
          this.memory,
          this.memorySwap,
          this.kernelMemory,
          this.memorySwappiness,
          this.memoryReservation,
          this.nanoCpus,
          this.cpuPeriod,
          this.cpuShares,
          this.cpusetCpus,
          this.cpusetMems,
          this.cpuQuota,
          this.cgroupParent,
          this.restartPolicy,
          this.logConfig,
          this.ipcMode,
          this.ulimits,
          this.pidMode,
          this.shmSize,
          this.oomKillDisable,
          this.oomScoreAdj,
          this.autoRemove,
          this.pidsLimit,
          this.tmpfs,
          this.readonlyRootfs,
          this.storageOpt,
          this.runtime,
          this.mounts,
          this.init,
          this.sysctls,
          this.deviceRequests));
    }
    @Nullable List<String> newValue = Arrays.asList(elements) == null ? null : createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return validate(new ImmutableHostConfig(
        newValue,
        this.blkioWeight,
        this.blkioWeightDevice,
        this.blkioDeviceReadBps,
        this.blkioDeviceWriteBps,
        this.blkioDeviceReadIOps,
        this.blkioDeviceWriteIOps,
        this.containerIdFile,
        this.lxcConf,
        this.privileged,
        this.portBindings,
        this.links,
        this.publishAllPorts,
        this.dns,
        this.dnsOptions,
        this.dnsSearch,
        this.extraHosts,
        this.groupAdd,
        this.volumesFrom,
        this.capAdd,
        this.capDrop,
        this.networkMode,
        this.securityOpt,
        this.devices,
        this.memory,
        this.memorySwap,
        this.kernelMemory,
        this.memorySwappiness,
        this.memoryReservation,
        this.nanoCpus,
        this.cpuPeriod,
        this.cpuShares,
        this.cpusetCpus,
        this.cpusetMems,
        this.cpuQuota,
        this.cgroupParent,
        this.restartPolicy,
        this.logConfig,
        this.ipcMode,
        this.ulimits,
        this.pidMode,
        this.shmSize,
        this.oomKillDisable,
        this.oomScoreAdj,
        this.autoRemove,
        this.pidsLimit,
        this.tmpfs,
        this.readonlyRootfs,
        this.storageOpt,
        this.runtime,
        this.mounts,
        this.init,
        this.sysctls,
        this.deviceRequests));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link HostConfig#binds() binds}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of binds elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableHostConfig withBinds(@Nullable Iterable<String> elements) {
    if (this.binds == elements) return this;
    @Nullable List<String> newValue = elements == null ? null : createUnmodifiableList(false, createSafeList(elements, true, false));
    return validate(new ImmutableHostConfig(
        newValue,
        this.blkioWeight,
        this.blkioWeightDevice,
        this.blkioDeviceReadBps,
        this.blkioDeviceWriteBps,
        this.blkioDeviceReadIOps,
        this.blkioDeviceWriteIOps,
        this.containerIdFile,
        this.lxcConf,
        this.privileged,
        this.portBindings,
        this.links,
        this.publishAllPorts,
        this.dns,
        this.dnsOptions,
        this.dnsSearch,
        this.extraHosts,
        this.groupAdd,
        this.volumesFrom,
        this.capAdd,
        this.capDrop,
        this.networkMode,
        this.securityOpt,
        this.devices,
        this.memory,
        this.memorySwap,
        this.kernelMemory,
        this.memorySwappiness,
        this.memoryReservation,
        this.nanoCpus,
        this.cpuPeriod,
        this.cpuShares,
        this.cpusetCpus,
        this.cpusetMems,
        this.cpuQuota,
        this.cgroupParent,
        this.restartPolicy,
        this.logConfig,
        this.ipcMode,
        this.ulimits,
        this.pidMode,
        this.shmSize,
        this.oomKillDisable,
        this.oomScoreAdj,
        this.autoRemove,
        this.pidsLimit,
        this.tmpfs,
        this.readonlyRootfs,
        this.storageOpt,
        this.runtime,
        this.mounts,
        this.init,
        this.sysctls,
        this.deviceRequests));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link HostConfig#blkioWeight() blkioWeight} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for blkioWeight (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableHostConfig withBlkioWeight(@Nullable Integer value) {
    if (Objects.equals(this.blkioWeight, value)) return this;
    return validate(new ImmutableHostConfig(
        this.binds,
        value,
        this.blkioWeightDevice,
        this.blkioDeviceReadBps,
        this.blkioDeviceWriteBps,
        this.blkioDeviceReadIOps,
        this.blkioDeviceWriteIOps,
        this.containerIdFile,
        this.lxcConf,
        this.privileged,
        this.portBindings,
        this.links,
        this.publishAllPorts,
        this.dns,
        this.dnsOptions,
        this.dnsSearch,
        this.extraHosts,
        this.groupAdd,
        this.volumesFrom,
        this.capAdd,
        this.capDrop,
        this.networkMode,
        this.securityOpt,
        this.devices,
        this.memory,
        this.memorySwap,
        this.kernelMemory,
        this.memorySwappiness,
        this.memoryReservation,
        this.nanoCpus,
        this.cpuPeriod,
        this.cpuShares,
        this.cpusetCpus,
        this.cpusetMems,
        this.cpuQuota,
        this.cgroupParent,
        this.restartPolicy,
        this.logConfig,
        this.ipcMode,
        this.ulimits,
        this.pidMode,
        this.shmSize,
        this.oomKillDisable,
        this.oomScoreAdj,
        this.autoRemove,
        this.pidsLimit,
        this.tmpfs,
        this.readonlyRootfs,
        this.storageOpt,
        this.runtime,
        this.mounts,
        this.init,
        this.sysctls,
        this.deviceRequests));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link HostConfig#blkioWeightDevice() blkioWeightDevice}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableHostConfig withBlkioWeightDevice(@Nullable HostConfig.BlkioWeightDevice... elements) {
    if (elements == null) {
      return validate(new ImmutableHostConfig(
          this.binds,
          this.blkioWeight,
          null,
          this.blkioDeviceReadBps,
          this.blkioDeviceWriteBps,
          this.blkioDeviceReadIOps,
          this.blkioDeviceWriteIOps,
          this.containerIdFile,
          this.lxcConf,
          this.privileged,
          this.portBindings,
          this.links,
          this.publishAllPorts,
          this.dns,
          this.dnsOptions,
          this.dnsSearch,
          this.extraHosts,
          this.groupAdd,
          this.volumesFrom,
          this.capAdd,
          this.capDrop,
          this.networkMode,
          this.securityOpt,
          this.devices,
          this.memory,
          this.memorySwap,
          this.kernelMemory,
          this.memorySwappiness,
          this.memoryReservation,
          this.nanoCpus,
          this.cpuPeriod,
          this.cpuShares,
          this.cpusetCpus,
          this.cpusetMems,
          this.cpuQuota,
          this.cgroupParent,
          this.restartPolicy,
          this.logConfig,
          this.ipcMode,
          this.ulimits,
          this.pidMode,
          this.shmSize,
          this.oomKillDisable,
          this.oomScoreAdj,
          this.autoRemove,
          this.pidsLimit,
          this.tmpfs,
          this.readonlyRootfs,
          this.storageOpt,
          this.runtime,
          this.mounts,
          this.init,
          this.sysctls,
          this.deviceRequests));
    }
    @Nullable List<HostConfig.BlkioWeightDevice> newValue = Arrays.asList(elements) == null ? null : createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return validate(new ImmutableHostConfig(
        this.binds,
        this.blkioWeight,
        newValue,
        this.blkioDeviceReadBps,
        this.blkioDeviceWriteBps,
        this.blkioDeviceReadIOps,
        this.blkioDeviceWriteIOps,
        this.containerIdFile,
        this.lxcConf,
        this.privileged,
        this.portBindings,
        this.links,
        this.publishAllPorts,
        this.dns,
        this.dnsOptions,
        this.dnsSearch,
        this.extraHosts,
        this.groupAdd,
        this.volumesFrom,
        this.capAdd,
        this.capDrop,
        this.networkMode,
        this.securityOpt,
        this.devices,
        this.memory,
        this.memorySwap,
        this.kernelMemory,
        this.memorySwappiness,
        this.memoryReservation,
        this.nanoCpus,
        this.cpuPeriod,
        this.cpuShares,
        this.cpusetCpus,
        this.cpusetMems,
        this.cpuQuota,
        this.cgroupParent,
        this.restartPolicy,
        this.logConfig,
        this.ipcMode,
        this.ulimits,
        this.pidMode,
        this.shmSize,
        this.oomKillDisable,
        this.oomScoreAdj,
        this.autoRemove,
        this.pidsLimit,
        this.tmpfs,
        this.readonlyRootfs,
        this.storageOpt,
        this.runtime,
        this.mounts,
        this.init,
        this.sysctls,
        this.deviceRequests));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link HostConfig#blkioWeightDevice() blkioWeightDevice}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of blkioWeightDevice elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableHostConfig withBlkioWeightDevice(@Nullable Iterable<? extends HostConfig.BlkioWeightDevice> elements) {
    if (this.blkioWeightDevice == elements) return this;
    @Nullable List<HostConfig.BlkioWeightDevice> newValue = elements == null ? null : createUnmodifiableList(false, createSafeList(elements, true, false));
    return validate(new ImmutableHostConfig(
        this.binds,
        this.blkioWeight,
        newValue,
        this.blkioDeviceReadBps,
        this.blkioDeviceWriteBps,
        this.blkioDeviceReadIOps,
        this.blkioDeviceWriteIOps,
        this.containerIdFile,
        this.lxcConf,
        this.privileged,
        this.portBindings,
        this.links,
        this.publishAllPorts,
        this.dns,
        this.dnsOptions,
        this.dnsSearch,
        this.extraHosts,
        this.groupAdd,
        this.volumesFrom,
        this.capAdd,
        this.capDrop,
        this.networkMode,
        this.securityOpt,
        this.devices,
        this.memory,
        this.memorySwap,
        this.kernelMemory,
        this.memorySwappiness,
        this.memoryReservation,
        this.nanoCpus,
        this.cpuPeriod,
        this.cpuShares,
        this.cpusetCpus,
        this.cpusetMems,
        this.cpuQuota,
        this.cgroupParent,
        this.restartPolicy,
        this.logConfig,
        this.ipcMode,
        this.ulimits,
        this.pidMode,
        this.shmSize,
        this.oomKillDisable,
        this.oomScoreAdj,
        this.autoRemove,
        this.pidsLimit,
        this.tmpfs,
        this.readonlyRootfs,
        this.storageOpt,
        this.runtime,
        this.mounts,
        this.init,
        this.sysctls,
        this.deviceRequests));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link HostConfig#blkioDeviceReadBps() blkioDeviceReadBps}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableHostConfig withBlkioDeviceReadBps(@Nullable HostConfig.BlkioDeviceRate... elements) {
    if (elements == null) {
      return validate(new ImmutableHostConfig(
          this.binds,
          this.blkioWeight,
          this.blkioWeightDevice,
          null,
          this.blkioDeviceWriteBps,
          this.blkioDeviceReadIOps,
          this.blkioDeviceWriteIOps,
          this.containerIdFile,
          this.lxcConf,
          this.privileged,
          this.portBindings,
          this.links,
          this.publishAllPorts,
          this.dns,
          this.dnsOptions,
          this.dnsSearch,
          this.extraHosts,
          this.groupAdd,
          this.volumesFrom,
          this.capAdd,
          this.capDrop,
          this.networkMode,
          this.securityOpt,
          this.devices,
          this.memory,
          this.memorySwap,
          this.kernelMemory,
          this.memorySwappiness,
          this.memoryReservation,
          this.nanoCpus,
          this.cpuPeriod,
          this.cpuShares,
          this.cpusetCpus,
          this.cpusetMems,
          this.cpuQuota,
          this.cgroupParent,
          this.restartPolicy,
          this.logConfig,
          this.ipcMode,
          this.ulimits,
          this.pidMode,
          this.shmSize,
          this.oomKillDisable,
          this.oomScoreAdj,
          this.autoRemove,
          this.pidsLimit,
          this.tmpfs,
          this.readonlyRootfs,
          this.storageOpt,
          this.runtime,
          this.mounts,
          this.init,
          this.sysctls,
          this.deviceRequests));
    }
    @Nullable List<HostConfig.BlkioDeviceRate> newValue = Arrays.asList(elements) == null ? null : createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return validate(new ImmutableHostConfig(
        this.binds,
        this.blkioWeight,
        this.blkioWeightDevice,
        newValue,
        this.blkioDeviceWriteBps,
        this.blkioDeviceReadIOps,
        this.blkioDeviceWriteIOps,
        this.containerIdFile,
        this.lxcConf,
        this.privileged,
        this.portBindings,
        this.links,
        this.publishAllPorts,
        this.dns,
        this.dnsOptions,
        this.dnsSearch,
        this.extraHosts,
        this.groupAdd,
        this.volumesFrom,
        this.capAdd,
        this.capDrop,
        this.networkMode,
        this.securityOpt,
        this.devices,
        this.memory,
        this.memorySwap,
        this.kernelMemory,
        this.memorySwappiness,
        this.memoryReservation,
        this.nanoCpus,
        this.cpuPeriod,
        this.cpuShares,
        this.cpusetCpus,
        this.cpusetMems,
        this.cpuQuota,
        this.cgroupParent,
        this.restartPolicy,
        this.logConfig,
        this.ipcMode,
        this.ulimits,
        this.pidMode,
        this.shmSize,
        this.oomKillDisable,
        this.oomScoreAdj,
        this.autoRemove,
        this.pidsLimit,
        this.tmpfs,
        this.readonlyRootfs,
        this.storageOpt,
        this.runtime,
        this.mounts,
        this.init,
        this.sysctls,
        this.deviceRequests));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link HostConfig#blkioDeviceReadBps() blkioDeviceReadBps}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of blkioDeviceReadBps elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableHostConfig withBlkioDeviceReadBps(@Nullable Iterable<? extends HostConfig.BlkioDeviceRate> elements) {
    if (this.blkioDeviceReadBps == elements) return this;
    @Nullable List<HostConfig.BlkioDeviceRate> newValue = elements == null ? null : createUnmodifiableList(false, createSafeList(elements, true, false));
    return validate(new ImmutableHostConfig(
        this.binds,
        this.blkioWeight,
        this.blkioWeightDevice,
        newValue,
        this.blkioDeviceWriteBps,
        this.blkioDeviceReadIOps,
        this.blkioDeviceWriteIOps,
        this.containerIdFile,
        this.lxcConf,
        this.privileged,
        this.portBindings,
        this.links,
        this.publishAllPorts,
        this.dns,
        this.dnsOptions,
        this.dnsSearch,
        this.extraHosts,
        this.groupAdd,
        this.volumesFrom,
        this.capAdd,
        this.capDrop,
        this.networkMode,
        this.securityOpt,
        this.devices,
        this.memory,
        this.memorySwap,
        this.kernelMemory,
        this.memorySwappiness,
        this.memoryReservation,
        this.nanoCpus,
        this.cpuPeriod,
        this.cpuShares,
        this.cpusetCpus,
        this.cpusetMems,
        this.cpuQuota,
        this.cgroupParent,
        this.restartPolicy,
        this.logConfig,
        this.ipcMode,
        this.ulimits,
        this.pidMode,
        this.shmSize,
        this.oomKillDisable,
        this.oomScoreAdj,
        this.autoRemove,
        this.pidsLimit,
        this.tmpfs,
        this.readonlyRootfs,
        this.storageOpt,
        this.runtime,
        this.mounts,
        this.init,
        this.sysctls,
        this.deviceRequests));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link HostConfig#blkioDeviceWriteBps() blkioDeviceWriteBps}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableHostConfig withBlkioDeviceWriteBps(@Nullable HostConfig.BlkioDeviceRate... elements) {
    if (elements == null) {
      return validate(new ImmutableHostConfig(
          this.binds,
          this.blkioWeight,
          this.blkioWeightDevice,
          this.blkioDeviceReadBps,
          null,
          this.blkioDeviceReadIOps,
          this.blkioDeviceWriteIOps,
          this.containerIdFile,
          this.lxcConf,
          this.privileged,
          this.portBindings,
          this.links,
          this.publishAllPorts,
          this.dns,
          this.dnsOptions,
          this.dnsSearch,
          this.extraHosts,
          this.groupAdd,
          this.volumesFrom,
          this.capAdd,
          this.capDrop,
          this.networkMode,
          this.securityOpt,
          this.devices,
          this.memory,
          this.memorySwap,
          this.kernelMemory,
          this.memorySwappiness,
          this.memoryReservation,
          this.nanoCpus,
          this.cpuPeriod,
          this.cpuShares,
          this.cpusetCpus,
          this.cpusetMems,
          this.cpuQuota,
          this.cgroupParent,
          this.restartPolicy,
          this.logConfig,
          this.ipcMode,
          this.ulimits,
          this.pidMode,
          this.shmSize,
          this.oomKillDisable,
          this.oomScoreAdj,
          this.autoRemove,
          this.pidsLimit,
          this.tmpfs,
          this.readonlyRootfs,
          this.storageOpt,
          this.runtime,
          this.mounts,
          this.init,
          this.sysctls,
          this.deviceRequests));
    }
    @Nullable List<HostConfig.BlkioDeviceRate> newValue = Arrays.asList(elements) == null ? null : createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return validate(new ImmutableHostConfig(
        this.binds,
        this.blkioWeight,
        this.blkioWeightDevice,
        this.blkioDeviceReadBps,
        newValue,
        this.blkioDeviceReadIOps,
        this.blkioDeviceWriteIOps,
        this.containerIdFile,
        this.lxcConf,
        this.privileged,
        this.portBindings,
        this.links,
        this.publishAllPorts,
        this.dns,
        this.dnsOptions,
        this.dnsSearch,
        this.extraHosts,
        this.groupAdd,
        this.volumesFrom,
        this.capAdd,
        this.capDrop,
        this.networkMode,
        this.securityOpt,
        this.devices,
        this.memory,
        this.memorySwap,
        this.kernelMemory,
        this.memorySwappiness,
        this.memoryReservation,
        this.nanoCpus,
        this.cpuPeriod,
        this.cpuShares,
        this.cpusetCpus,
        this.cpusetMems,
        this.cpuQuota,
        this.cgroupParent,
        this.restartPolicy,
        this.logConfig,
        this.ipcMode,
        this.ulimits,
        this.pidMode,
        this.shmSize,
        this.oomKillDisable,
        this.oomScoreAdj,
        this.autoRemove,
        this.pidsLimit,
        this.tmpfs,
        this.readonlyRootfs,
        this.storageOpt,
        this.runtime,
        this.mounts,
        this.init,
        this.sysctls,
        this.deviceRequests));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link HostConfig#blkioDeviceWriteBps() blkioDeviceWriteBps}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of blkioDeviceWriteBps elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableHostConfig withBlkioDeviceWriteBps(@Nullable Iterable<? extends HostConfig.BlkioDeviceRate> elements) {
    if (this.blkioDeviceWriteBps == elements) return this;
    @Nullable List<HostConfig.BlkioDeviceRate> newValue = elements == null ? null : createUnmodifiableList(false, createSafeList(elements, true, false));
    return validate(new ImmutableHostConfig(
        this.binds,
        this.blkioWeight,
        this.blkioWeightDevice,
        this.blkioDeviceReadBps,
        newValue,
        this.blkioDeviceReadIOps,
        this.blkioDeviceWriteIOps,
        this.containerIdFile,
        this.lxcConf,
        this.privileged,
        this.portBindings,
        this.links,
        this.publishAllPorts,
        this.dns,
        this.dnsOptions,
        this.dnsSearch,
        this.extraHosts,
        this.groupAdd,
        this.volumesFrom,
        this.capAdd,
        this.capDrop,
        this.networkMode,
        this.securityOpt,
        this.devices,
        this.memory,
        this.memorySwap,
        this.kernelMemory,
        this.memorySwappiness,
        this.memoryReservation,
        this.nanoCpus,
        this.cpuPeriod,
        this.cpuShares,
        this.cpusetCpus,
        this.cpusetMems,
        this.cpuQuota,
        this.cgroupParent,
        this.restartPolicy,
        this.logConfig,
        this.ipcMode,
        this.ulimits,
        this.pidMode,
        this.shmSize,
        this.oomKillDisable,
        this.oomScoreAdj,
        this.autoRemove,
        this.pidsLimit,
        this.tmpfs,
        this.readonlyRootfs,
        this.storageOpt,
        this.runtime,
        this.mounts,
        this.init,
        this.sysctls,
        this.deviceRequests));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link HostConfig#blkioDeviceReadIOps() blkioDeviceReadIOps}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableHostConfig withBlkioDeviceReadIOps(@Nullable HostConfig.BlkioDeviceRate... elements) {
    if (elements == null) {
      return validate(new ImmutableHostConfig(
          this.binds,
          this.blkioWeight,
          this.blkioWeightDevice,
          this.blkioDeviceReadBps,
          this.blkioDeviceWriteBps,
          null,
          this.blkioDeviceWriteIOps,
          this.containerIdFile,
          this.lxcConf,
          this.privileged,
          this.portBindings,
          this.links,
          this.publishAllPorts,
          this.dns,
          this.dnsOptions,
          this.dnsSearch,
          this.extraHosts,
          this.groupAdd,
          this.volumesFrom,
          this.capAdd,
          this.capDrop,
          this.networkMode,
          this.securityOpt,
          this.devices,
          this.memory,
          this.memorySwap,
          this.kernelMemory,
          this.memorySwappiness,
          this.memoryReservation,
          this.nanoCpus,
          this.cpuPeriod,
          this.cpuShares,
          this.cpusetCpus,
          this.cpusetMems,
          this.cpuQuota,
          this.cgroupParent,
          this.restartPolicy,
          this.logConfig,
          this.ipcMode,
          this.ulimits,
          this.pidMode,
          this.shmSize,
          this.oomKillDisable,
          this.oomScoreAdj,
          this.autoRemove,
          this.pidsLimit,
          this.tmpfs,
          this.readonlyRootfs,
          this.storageOpt,
          this.runtime,
          this.mounts,
          this.init,
          this.sysctls,
          this.deviceRequests));
    }
    @Nullable List<HostConfig.BlkioDeviceRate> newValue = Arrays.asList(elements) == null ? null : createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return validate(new ImmutableHostConfig(
        this.binds,
        this.blkioWeight,
        this.blkioWeightDevice,
        this.blkioDeviceReadBps,
        this.blkioDeviceWriteBps,
        newValue,
        this.blkioDeviceWriteIOps,
        this.containerIdFile,
        this.lxcConf,
        this.privileged,
        this.portBindings,
        this.links,
        this.publishAllPorts,
        this.dns,
        this.dnsOptions,
        this.dnsSearch,
        this.extraHosts,
        this.groupAdd,
        this.volumesFrom,
        this.capAdd,
        this.capDrop,
        this.networkMode,
        this.securityOpt,
        this.devices,
        this.memory,
        this.memorySwap,
        this.kernelMemory,
        this.memorySwappiness,
        this.memoryReservation,
        this.nanoCpus,
        this.cpuPeriod,
        this.cpuShares,
        this.cpusetCpus,
        this.cpusetMems,
        this.cpuQuota,
        this.cgroupParent,
        this.restartPolicy,
        this.logConfig,
        this.ipcMode,
        this.ulimits,
        this.pidMode,
        this.shmSize,
        this.oomKillDisable,
        this.oomScoreAdj,
        this.autoRemove,
        this.pidsLimit,
        this.tmpfs,
        this.readonlyRootfs,
        this.storageOpt,
        this.runtime,
        this.mounts,
        this.init,
        this.sysctls,
        this.deviceRequests));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link HostConfig#blkioDeviceReadIOps() blkioDeviceReadIOps}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of blkioDeviceReadIOps elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableHostConfig withBlkioDeviceReadIOps(@Nullable Iterable<? extends HostConfig.BlkioDeviceRate> elements) {
    if (this.blkioDeviceReadIOps == elements) return this;
    @Nullable List<HostConfig.BlkioDeviceRate> newValue = elements == null ? null : createUnmodifiableList(false, createSafeList(elements, true, false));
    return validate(new ImmutableHostConfig(
        this.binds,
        this.blkioWeight,
        this.blkioWeightDevice,
        this.blkioDeviceReadBps,
        this.blkioDeviceWriteBps,
        newValue,
        this.blkioDeviceWriteIOps,
        this.containerIdFile,
        this.lxcConf,
        this.privileged,
        this.portBindings,
        this.links,
        this.publishAllPorts,
        this.dns,
        this.dnsOptions,
        this.dnsSearch,
        this.extraHosts,
        this.groupAdd,
        this.volumesFrom,
        this.capAdd,
        this.capDrop,
        this.networkMode,
        this.securityOpt,
        this.devices,
        this.memory,
        this.memorySwap,
        this.kernelMemory,
        this.memorySwappiness,
        this.memoryReservation,
        this.nanoCpus,
        this.cpuPeriod,
        this.cpuShares,
        this.cpusetCpus,
        this.cpusetMems,
        this.cpuQuota,
        this.cgroupParent,
        this.restartPolicy,
        this.logConfig,
        this.ipcMode,
        this.ulimits,
        this.pidMode,
        this.shmSize,
        this.oomKillDisable,
        this.oomScoreAdj,
        this.autoRemove,
        this.pidsLimit,
        this.tmpfs,
        this.readonlyRootfs,
        this.storageOpt,
        this.runtime,
        this.mounts,
        this.init,
        this.sysctls,
        this.deviceRequests));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link HostConfig#blkioDeviceWriteIOps() blkioDeviceWriteIOps}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableHostConfig withBlkioDeviceWriteIOps(@Nullable HostConfig.BlkioDeviceRate... elements) {
    if (elements == null) {
      return validate(new ImmutableHostConfig(
          this.binds,
          this.blkioWeight,
          this.blkioWeightDevice,
          this.blkioDeviceReadBps,
          this.blkioDeviceWriteBps,
          this.blkioDeviceReadIOps,
          null,
          this.containerIdFile,
          this.lxcConf,
          this.privileged,
          this.portBindings,
          this.links,
          this.publishAllPorts,
          this.dns,
          this.dnsOptions,
          this.dnsSearch,
          this.extraHosts,
          this.groupAdd,
          this.volumesFrom,
          this.capAdd,
          this.capDrop,
          this.networkMode,
          this.securityOpt,
          this.devices,
          this.memory,
          this.memorySwap,
          this.kernelMemory,
          this.memorySwappiness,
          this.memoryReservation,
          this.nanoCpus,
          this.cpuPeriod,
          this.cpuShares,
          this.cpusetCpus,
          this.cpusetMems,
          this.cpuQuota,
          this.cgroupParent,
          this.restartPolicy,
          this.logConfig,
          this.ipcMode,
          this.ulimits,
          this.pidMode,
          this.shmSize,
          this.oomKillDisable,
          this.oomScoreAdj,
          this.autoRemove,
          this.pidsLimit,
          this.tmpfs,
          this.readonlyRootfs,
          this.storageOpt,
          this.runtime,
          this.mounts,
          this.init,
          this.sysctls,
          this.deviceRequests));
    }
    @Nullable List<HostConfig.BlkioDeviceRate> newValue = Arrays.asList(elements) == null ? null : createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return validate(new ImmutableHostConfig(
        this.binds,
        this.blkioWeight,
        this.blkioWeightDevice,
        this.blkioDeviceReadBps,
        this.blkioDeviceWriteBps,
        this.blkioDeviceReadIOps,
        newValue,
        this.containerIdFile,
        this.lxcConf,
        this.privileged,
        this.portBindings,
        this.links,
        this.publishAllPorts,
        this.dns,
        this.dnsOptions,
        this.dnsSearch,
        this.extraHosts,
        this.groupAdd,
        this.volumesFrom,
        this.capAdd,
        this.capDrop,
        this.networkMode,
        this.securityOpt,
        this.devices,
        this.memory,
        this.memorySwap,
        this.kernelMemory,
        this.memorySwappiness,
        this.memoryReservation,
        this.nanoCpus,
        this.cpuPeriod,
        this.cpuShares,
        this.cpusetCpus,
        this.cpusetMems,
        this.cpuQuota,
        this.cgroupParent,
        this.restartPolicy,
        this.logConfig,
        this.ipcMode,
        this.ulimits,
        this.pidMode,
        this.shmSize,
        this.oomKillDisable,
        this.oomScoreAdj,
        this.autoRemove,
        this.pidsLimit,
        this.tmpfs,
        this.readonlyRootfs,
        this.storageOpt,
        this.runtime,
        this.mounts,
        this.init,
        this.sysctls,
        this.deviceRequests));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link HostConfig#blkioDeviceWriteIOps() blkioDeviceWriteIOps}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of blkioDeviceWriteIOps elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableHostConfig withBlkioDeviceWriteIOps(@Nullable Iterable<? extends HostConfig.BlkioDeviceRate> elements) {
    if (this.blkioDeviceWriteIOps == elements) return this;
    @Nullable List<HostConfig.BlkioDeviceRate> newValue = elements == null ? null : createUnmodifiableList(false, createSafeList(elements, true, false));
    return validate(new ImmutableHostConfig(
        this.binds,
        this.blkioWeight,
        this.blkioWeightDevice,
        this.blkioDeviceReadBps,
        this.blkioDeviceWriteBps,
        this.blkioDeviceReadIOps,
        newValue,
        this.containerIdFile,
        this.lxcConf,
        this.privileged,
        this.portBindings,
        this.links,
        this.publishAllPorts,
        this.dns,
        this.dnsOptions,
        this.dnsSearch,
        this.extraHosts,
        this.groupAdd,
        this.volumesFrom,
        this.capAdd,
        this.capDrop,
        this.networkMode,
        this.securityOpt,
        this.devices,
        this.memory,
        this.memorySwap,
        this.kernelMemory,
        this.memorySwappiness,
        this.memoryReservation,
        this.nanoCpus,
        this.cpuPeriod,
        this.cpuShares,
        this.cpusetCpus,
        this.cpusetMems,
        this.cpuQuota,
        this.cgroupParent,
        this.restartPolicy,
        this.logConfig,
        this.ipcMode,
        this.ulimits,
        this.pidMode,
        this.shmSize,
        this.oomKillDisable,
        this.oomScoreAdj,
        this.autoRemove,
        this.pidsLimit,
        this.tmpfs,
        this.readonlyRootfs,
        this.storageOpt,
        this.runtime,
        this.mounts,
        this.init,
        this.sysctls,
        this.deviceRequests));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link HostConfig#containerIdFile() containerIdFile} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for containerIdFile (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableHostConfig withContainerIdFile(@Nullable String value) {
    if (Objects.equals(this.containerIdFile, value)) return this;
    return validate(new ImmutableHostConfig(
        this.binds,
        this.blkioWeight,
        this.blkioWeightDevice,
        this.blkioDeviceReadBps,
        this.blkioDeviceWriteBps,
        this.blkioDeviceReadIOps,
        this.blkioDeviceWriteIOps,
        value,
        this.lxcConf,
        this.privileged,
        this.portBindings,
        this.links,
        this.publishAllPorts,
        this.dns,
        this.dnsOptions,
        this.dnsSearch,
        this.extraHosts,
        this.groupAdd,
        this.volumesFrom,
        this.capAdd,
        this.capDrop,
        this.networkMode,
        this.securityOpt,
        this.devices,
        this.memory,
        this.memorySwap,
        this.kernelMemory,
        this.memorySwappiness,
        this.memoryReservation,
        this.nanoCpus,
        this.cpuPeriod,
        this.cpuShares,
        this.cpusetCpus,
        this.cpusetMems,
        this.cpuQuota,
        this.cgroupParent,
        this.restartPolicy,
        this.logConfig,
        this.ipcMode,
        this.ulimits,
        this.pidMode,
        this.shmSize,
        this.oomKillDisable,
        this.oomScoreAdj,
        this.autoRemove,
        this.pidsLimit,
        this.tmpfs,
        this.readonlyRootfs,
        this.storageOpt,
        this.runtime,
        this.mounts,
        this.init,
        this.sysctls,
        this.deviceRequests));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link HostConfig#lxcConf() lxcConf}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableHostConfig withLxcConf(@Nullable HostConfig.LxcConfParameter... elements) {
    if (elements == null) {
      return validate(new ImmutableHostConfig(
          this.binds,
          this.blkioWeight,
          this.blkioWeightDevice,
          this.blkioDeviceReadBps,
          this.blkioDeviceWriteBps,
          this.blkioDeviceReadIOps,
          this.blkioDeviceWriteIOps,
          this.containerIdFile,
          null,
          this.privileged,
          this.portBindings,
          this.links,
          this.publishAllPorts,
          this.dns,
          this.dnsOptions,
          this.dnsSearch,
          this.extraHosts,
          this.groupAdd,
          this.volumesFrom,
          this.capAdd,
          this.capDrop,
          this.networkMode,
          this.securityOpt,
          this.devices,
          this.memory,
          this.memorySwap,
          this.kernelMemory,
          this.memorySwappiness,
          this.memoryReservation,
          this.nanoCpus,
          this.cpuPeriod,
          this.cpuShares,
          this.cpusetCpus,
          this.cpusetMems,
          this.cpuQuota,
          this.cgroupParent,
          this.restartPolicy,
          this.logConfig,
          this.ipcMode,
          this.ulimits,
          this.pidMode,
          this.shmSize,
          this.oomKillDisable,
          this.oomScoreAdj,
          this.autoRemove,
          this.pidsLimit,
          this.tmpfs,
          this.readonlyRootfs,
          this.storageOpt,
          this.runtime,
          this.mounts,
          this.init,
          this.sysctls,
          this.deviceRequests));
    }
    @Nullable List<HostConfig.LxcConfParameter> newValue = Arrays.asList(elements) == null ? null : createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return validate(new ImmutableHostConfig(
        this.binds,
        this.blkioWeight,
        this.blkioWeightDevice,
        this.blkioDeviceReadBps,
        this.blkioDeviceWriteBps,
        this.blkioDeviceReadIOps,
        this.blkioDeviceWriteIOps,
        this.containerIdFile,
        newValue,
        this.privileged,
        this.portBindings,
        this.links,
        this.publishAllPorts,
        this.dns,
        this.dnsOptions,
        this.dnsSearch,
        this.extraHosts,
        this.groupAdd,
        this.volumesFrom,
        this.capAdd,
        this.capDrop,
        this.networkMode,
        this.securityOpt,
        this.devices,
        this.memory,
        this.memorySwap,
        this.kernelMemory,
        this.memorySwappiness,
        this.memoryReservation,
        this.nanoCpus,
        this.cpuPeriod,
        this.cpuShares,
        this.cpusetCpus,
        this.cpusetMems,
        this.cpuQuota,
        this.cgroupParent,
        this.restartPolicy,
        this.logConfig,
        this.ipcMode,
        this.ulimits,
        this.pidMode,
        this.shmSize,
        this.oomKillDisable,
        this.oomScoreAdj,
        this.autoRemove,
        this.pidsLimit,
        this.tmpfs,
        this.readonlyRootfs,
        this.storageOpt,
        this.runtime,
        this.mounts,
        this.init,
        this.sysctls,
        this.deviceRequests));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link HostConfig#lxcConf() lxcConf}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of lxcConf elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableHostConfig withLxcConf(@Nullable Iterable<? extends HostConfig.LxcConfParameter> elements) {
    if (this.lxcConf == elements) return this;
    @Nullable List<HostConfig.LxcConfParameter> newValue = elements == null ? null : createUnmodifiableList(false, createSafeList(elements, true, false));
    return validate(new ImmutableHostConfig(
        this.binds,
        this.blkioWeight,
        this.blkioWeightDevice,
        this.blkioDeviceReadBps,
        this.blkioDeviceWriteBps,
        this.blkioDeviceReadIOps,
        this.blkioDeviceWriteIOps,
        this.containerIdFile,
        newValue,
        this.privileged,
        this.portBindings,
        this.links,
        this.publishAllPorts,
        this.dns,
        this.dnsOptions,
        this.dnsSearch,
        this.extraHosts,
        this.groupAdd,
        this.volumesFrom,
        this.capAdd,
        this.capDrop,
        this.networkMode,
        this.securityOpt,
        this.devices,
        this.memory,
        this.memorySwap,
        this.kernelMemory,
        this.memorySwappiness,
        this.memoryReservation,
        this.nanoCpus,
        this.cpuPeriod,
        this.cpuShares,
        this.cpusetCpus,
        this.cpusetMems,
        this.cpuQuota,
        this.cgroupParent,
        this.restartPolicy,
        this.logConfig,
        this.ipcMode,
        this.ulimits,
        this.pidMode,
        this.shmSize,
        this.oomKillDisable,
        this.oomScoreAdj,
        this.autoRemove,
        this.pidsLimit,
        this.tmpfs,
        this.readonlyRootfs,
        this.storageOpt,
        this.runtime,
        this.mounts,
        this.init,
        this.sysctls,
        this.deviceRequests));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link HostConfig#privileged() privileged} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for privileged (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableHostConfig withPrivileged(@Nullable Boolean value) {
    if (Objects.equals(this.privileged, value)) return this;
    return validate(new ImmutableHostConfig(
        this.binds,
        this.blkioWeight,
        this.blkioWeightDevice,
        this.blkioDeviceReadBps,
        this.blkioDeviceWriteBps,
        this.blkioDeviceReadIOps,
        this.blkioDeviceWriteIOps,
        this.containerIdFile,
        this.lxcConf,
        value,
        this.portBindings,
        this.links,
        this.publishAllPorts,
        this.dns,
        this.dnsOptions,
        this.dnsSearch,
        this.extraHosts,
        this.groupAdd,
        this.volumesFrom,
        this.capAdd,
        this.capDrop,
        this.networkMode,
        this.securityOpt,
        this.devices,
        this.memory,
        this.memorySwap,
        this.kernelMemory,
        this.memorySwappiness,
        this.memoryReservation,
        this.nanoCpus,
        this.cpuPeriod,
        this.cpuShares,
        this.cpusetCpus,
        this.cpusetMems,
        this.cpuQuota,
        this.cgroupParent,
        this.restartPolicy,
        this.logConfig,
        this.ipcMode,
        this.ulimits,
        this.pidMode,
        this.shmSize,
        this.oomKillDisable,
        this.oomScoreAdj,
        this.autoRemove,
        this.pidsLimit,
        this.tmpfs,
        this.readonlyRootfs,
        this.storageOpt,
        this.runtime,
        this.mounts,
        this.init,
        this.sysctls,
        this.deviceRequests));
  }

  /**
   * Copy the current immutable object by replacing the {@link HostConfig#portBindings() portBindings} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the portBindings map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableHostConfig withPortBindings(@Nullable Map<String, ? extends List<PortBinding>> entries) {
    if (this.portBindings == entries) return this;
    @Nullable Map<String, List<PortBinding>> newValue = entries == null ? null : createUnmodifiableMap(true, false, entries);
    return validate(new ImmutableHostConfig(
        this.binds,
        this.blkioWeight,
        this.blkioWeightDevice,
        this.blkioDeviceReadBps,
        this.blkioDeviceWriteBps,
        this.blkioDeviceReadIOps,
        this.blkioDeviceWriteIOps,
        this.containerIdFile,
        this.lxcConf,
        this.privileged,
        newValue,
        this.links,
        this.publishAllPorts,
        this.dns,
        this.dnsOptions,
        this.dnsSearch,
        this.extraHosts,
        this.groupAdd,
        this.volumesFrom,
        this.capAdd,
        this.capDrop,
        this.networkMode,
        this.securityOpt,
        this.devices,
        this.memory,
        this.memorySwap,
        this.kernelMemory,
        this.memorySwappiness,
        this.memoryReservation,
        this.nanoCpus,
        this.cpuPeriod,
        this.cpuShares,
        this.cpusetCpus,
        this.cpusetMems,
        this.cpuQuota,
        this.cgroupParent,
        this.restartPolicy,
        this.logConfig,
        this.ipcMode,
        this.ulimits,
        this.pidMode,
        this.shmSize,
        this.oomKillDisable,
        this.oomScoreAdj,
        this.autoRemove,
        this.pidsLimit,
        this.tmpfs,
        this.readonlyRootfs,
        this.storageOpt,
        this.runtime,
        this.mounts,
        this.init,
        this.sysctls,
        this.deviceRequests));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link HostConfig#links() links}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableHostConfig withLinks(@Nullable String... elements) {
    if (elements == null) {
      return validate(new ImmutableHostConfig(
          this.binds,
          this.blkioWeight,
          this.blkioWeightDevice,
          this.blkioDeviceReadBps,
          this.blkioDeviceWriteBps,
          this.blkioDeviceReadIOps,
          this.blkioDeviceWriteIOps,
          this.containerIdFile,
          this.lxcConf,
          this.privileged,
          this.portBindings,
          null,
          this.publishAllPorts,
          this.dns,
          this.dnsOptions,
          this.dnsSearch,
          this.extraHosts,
          this.groupAdd,
          this.volumesFrom,
          this.capAdd,
          this.capDrop,
          this.networkMode,
          this.securityOpt,
          this.devices,
          this.memory,
          this.memorySwap,
          this.kernelMemory,
          this.memorySwappiness,
          this.memoryReservation,
          this.nanoCpus,
          this.cpuPeriod,
          this.cpuShares,
          this.cpusetCpus,
          this.cpusetMems,
          this.cpuQuota,
          this.cgroupParent,
          this.restartPolicy,
          this.logConfig,
          this.ipcMode,
          this.ulimits,
          this.pidMode,
          this.shmSize,
          this.oomKillDisable,
          this.oomScoreAdj,
          this.autoRemove,
          this.pidsLimit,
          this.tmpfs,
          this.readonlyRootfs,
          this.storageOpt,
          this.runtime,
          this.mounts,
          this.init,
          this.sysctls,
          this.deviceRequests));
    }
    @Nullable List<String> newValue = Arrays.asList(elements) == null ? null : createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return validate(new ImmutableHostConfig(
        this.binds,
        this.blkioWeight,
        this.blkioWeightDevice,
        this.blkioDeviceReadBps,
        this.blkioDeviceWriteBps,
        this.blkioDeviceReadIOps,
        this.blkioDeviceWriteIOps,
        this.containerIdFile,
        this.lxcConf,
        this.privileged,
        this.portBindings,
        newValue,
        this.publishAllPorts,
        this.dns,
        this.dnsOptions,
        this.dnsSearch,
        this.extraHosts,
        this.groupAdd,
        this.volumesFrom,
        this.capAdd,
        this.capDrop,
        this.networkMode,
        this.securityOpt,
        this.devices,
        this.memory,
        this.memorySwap,
        this.kernelMemory,
        this.memorySwappiness,
        this.memoryReservation,
        this.nanoCpus,
        this.cpuPeriod,
        this.cpuShares,
        this.cpusetCpus,
        this.cpusetMems,
        this.cpuQuota,
        this.cgroupParent,
        this.restartPolicy,
        this.logConfig,
        this.ipcMode,
        this.ulimits,
        this.pidMode,
        this.shmSize,
        this.oomKillDisable,
        this.oomScoreAdj,
        this.autoRemove,
        this.pidsLimit,
        this.tmpfs,
        this.readonlyRootfs,
        this.storageOpt,
        this.runtime,
        this.mounts,
        this.init,
        this.sysctls,
        this.deviceRequests));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link HostConfig#links() links}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of links elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableHostConfig withLinks(@Nullable Iterable<String> elements) {
    if (this.links == elements) return this;
    @Nullable List<String> newValue = elements == null ? null : createUnmodifiableList(false, createSafeList(elements, true, false));
    return validate(new ImmutableHostConfig(
        this.binds,
        this.blkioWeight,
        this.blkioWeightDevice,
        this.blkioDeviceReadBps,
        this.blkioDeviceWriteBps,
        this.blkioDeviceReadIOps,
        this.blkioDeviceWriteIOps,
        this.containerIdFile,
        this.lxcConf,
        this.privileged,
        this.portBindings,
        newValue,
        this.publishAllPorts,
        this.dns,
        this.dnsOptions,
        this.dnsSearch,
        this.extraHosts,
        this.groupAdd,
        this.volumesFrom,
        this.capAdd,
        this.capDrop,
        this.networkMode,
        this.securityOpt,
        this.devices,
        this.memory,
        this.memorySwap,
        this.kernelMemory,
        this.memorySwappiness,
        this.memoryReservation,
        this.nanoCpus,
        this.cpuPeriod,
        this.cpuShares,
        this.cpusetCpus,
        this.cpusetMems,
        this.cpuQuota,
        this.cgroupParent,
        this.restartPolicy,
        this.logConfig,
        this.ipcMode,
        this.ulimits,
        this.pidMode,
        this.shmSize,
        this.oomKillDisable,
        this.oomScoreAdj,
        this.autoRemove,
        this.pidsLimit,
        this.tmpfs,
        this.readonlyRootfs,
        this.storageOpt,
        this.runtime,
        this.mounts,
        this.init,
        this.sysctls,
        this.deviceRequests));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link HostConfig#publishAllPorts() publishAllPorts} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for publishAllPorts (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableHostConfig withPublishAllPorts(@Nullable Boolean value) {
    if (Objects.equals(this.publishAllPorts, value)) return this;
    return validate(new ImmutableHostConfig(
        this.binds,
        this.blkioWeight,
        this.blkioWeightDevice,
        this.blkioDeviceReadBps,
        this.blkioDeviceWriteBps,
        this.blkioDeviceReadIOps,
        this.blkioDeviceWriteIOps,
        this.containerIdFile,
        this.lxcConf,
        this.privileged,
        this.portBindings,
        this.links,
        value,
        this.dns,
        this.dnsOptions,
        this.dnsSearch,
        this.extraHosts,
        this.groupAdd,
        this.volumesFrom,
        this.capAdd,
        this.capDrop,
        this.networkMode,
        this.securityOpt,
        this.devices,
        this.memory,
        this.memorySwap,
        this.kernelMemory,
        this.memorySwappiness,
        this.memoryReservation,
        this.nanoCpus,
        this.cpuPeriod,
        this.cpuShares,
        this.cpusetCpus,
        this.cpusetMems,
        this.cpuQuota,
        this.cgroupParent,
        this.restartPolicy,
        this.logConfig,
        this.ipcMode,
        this.ulimits,
        this.pidMode,
        this.shmSize,
        this.oomKillDisable,
        this.oomScoreAdj,
        this.autoRemove,
        this.pidsLimit,
        this.tmpfs,
        this.readonlyRootfs,
        this.storageOpt,
        this.runtime,
        this.mounts,
        this.init,
        this.sysctls,
        this.deviceRequests));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link HostConfig#dns() dns}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableHostConfig withDns(@Nullable String... elements) {
    if (elements == null) {
      return validate(new ImmutableHostConfig(
          this.binds,
          this.blkioWeight,
          this.blkioWeightDevice,
          this.blkioDeviceReadBps,
          this.blkioDeviceWriteBps,
          this.blkioDeviceReadIOps,
          this.blkioDeviceWriteIOps,
          this.containerIdFile,
          this.lxcConf,
          this.privileged,
          this.portBindings,
          this.links,
          this.publishAllPorts,
          null,
          this.dnsOptions,
          this.dnsSearch,
          this.extraHosts,
          this.groupAdd,
          this.volumesFrom,
          this.capAdd,
          this.capDrop,
          this.networkMode,
          this.securityOpt,
          this.devices,
          this.memory,
          this.memorySwap,
          this.kernelMemory,
          this.memorySwappiness,
          this.memoryReservation,
          this.nanoCpus,
          this.cpuPeriod,
          this.cpuShares,
          this.cpusetCpus,
          this.cpusetMems,
          this.cpuQuota,
          this.cgroupParent,
          this.restartPolicy,
          this.logConfig,
          this.ipcMode,
          this.ulimits,
          this.pidMode,
          this.shmSize,
          this.oomKillDisable,
          this.oomScoreAdj,
          this.autoRemove,
          this.pidsLimit,
          this.tmpfs,
          this.readonlyRootfs,
          this.storageOpt,
          this.runtime,
          this.mounts,
          this.init,
          this.sysctls,
          this.deviceRequests));
    }
    @Nullable List<String> newValue = Arrays.asList(elements) == null ? null : createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return validate(new ImmutableHostConfig(
        this.binds,
        this.blkioWeight,
        this.blkioWeightDevice,
        this.blkioDeviceReadBps,
        this.blkioDeviceWriteBps,
        this.blkioDeviceReadIOps,
        this.blkioDeviceWriteIOps,
        this.containerIdFile,
        this.lxcConf,
        this.privileged,
        this.portBindings,
        this.links,
        this.publishAllPorts,
        newValue,
        this.dnsOptions,
        this.dnsSearch,
        this.extraHosts,
        this.groupAdd,
        this.volumesFrom,
        this.capAdd,
        this.capDrop,
        this.networkMode,
        this.securityOpt,
        this.devices,
        this.memory,
        this.memorySwap,
        this.kernelMemory,
        this.memorySwappiness,
        this.memoryReservation,
        this.nanoCpus,
        this.cpuPeriod,
        this.cpuShares,
        this.cpusetCpus,
        this.cpusetMems,
        this.cpuQuota,
        this.cgroupParent,
        this.restartPolicy,
        this.logConfig,
        this.ipcMode,
        this.ulimits,
        this.pidMode,
        this.shmSize,
        this.oomKillDisable,
        this.oomScoreAdj,
        this.autoRemove,
        this.pidsLimit,
        this.tmpfs,
        this.readonlyRootfs,
        this.storageOpt,
        this.runtime,
        this.mounts,
        this.init,
        this.sysctls,
        this.deviceRequests));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link HostConfig#dns() dns}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of dns elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableHostConfig withDns(@Nullable Iterable<String> elements) {
    if (this.dns == elements) return this;
    @Nullable List<String> newValue = elements == null ? null : createUnmodifiableList(false, createSafeList(elements, true, false));
    return validate(new ImmutableHostConfig(
        this.binds,
        this.blkioWeight,
        this.blkioWeightDevice,
        this.blkioDeviceReadBps,
        this.blkioDeviceWriteBps,
        this.blkioDeviceReadIOps,
        this.blkioDeviceWriteIOps,
        this.containerIdFile,
        this.lxcConf,
        this.privileged,
        this.portBindings,
        this.links,
        this.publishAllPorts,
        newValue,
        this.dnsOptions,
        this.dnsSearch,
        this.extraHosts,
        this.groupAdd,
        this.volumesFrom,
        this.capAdd,
        this.capDrop,
        this.networkMode,
        this.securityOpt,
        this.devices,
        this.memory,
        this.memorySwap,
        this.kernelMemory,
        this.memorySwappiness,
        this.memoryReservation,
        this.nanoCpus,
        this.cpuPeriod,
        this.cpuShares,
        this.cpusetCpus,
        this.cpusetMems,
        this.cpuQuota,
        this.cgroupParent,
        this.restartPolicy,
        this.logConfig,
        this.ipcMode,
        this.ulimits,
        this.pidMode,
        this.shmSize,
        this.oomKillDisable,
        this.oomScoreAdj,
        this.autoRemove,
        this.pidsLimit,
        this.tmpfs,
        this.readonlyRootfs,
        this.storageOpt,
        this.runtime,
        this.mounts,
        this.init,
        this.sysctls,
        this.deviceRequests));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link HostConfig#dnsOptions() dnsOptions}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableHostConfig withDnsOptions(@Nullable String... elements) {
    if (elements == null) {
      return validate(new ImmutableHostConfig(
          this.binds,
          this.blkioWeight,
          this.blkioWeightDevice,
          this.blkioDeviceReadBps,
          this.blkioDeviceWriteBps,
          this.blkioDeviceReadIOps,
          this.blkioDeviceWriteIOps,
          this.containerIdFile,
          this.lxcConf,
          this.privileged,
          this.portBindings,
          this.links,
          this.publishAllPorts,
          this.dns,
          null,
          this.dnsSearch,
          this.extraHosts,
          this.groupAdd,
          this.volumesFrom,
          this.capAdd,
          this.capDrop,
          this.networkMode,
          this.securityOpt,
          this.devices,
          this.memory,
          this.memorySwap,
          this.kernelMemory,
          this.memorySwappiness,
          this.memoryReservation,
          this.nanoCpus,
          this.cpuPeriod,
          this.cpuShares,
          this.cpusetCpus,
          this.cpusetMems,
          this.cpuQuota,
          this.cgroupParent,
          this.restartPolicy,
          this.logConfig,
          this.ipcMode,
          this.ulimits,
          this.pidMode,
          this.shmSize,
          this.oomKillDisable,
          this.oomScoreAdj,
          this.autoRemove,
          this.pidsLimit,
          this.tmpfs,
          this.readonlyRootfs,
          this.storageOpt,
          this.runtime,
          this.mounts,
          this.init,
          this.sysctls,
          this.deviceRequests));
    }
    @Nullable List<String> newValue = Arrays.asList(elements) == null ? null : createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return validate(new ImmutableHostConfig(
        this.binds,
        this.blkioWeight,
        this.blkioWeightDevice,
        this.blkioDeviceReadBps,
        this.blkioDeviceWriteBps,
        this.blkioDeviceReadIOps,
        this.blkioDeviceWriteIOps,
        this.containerIdFile,
        this.lxcConf,
        this.privileged,
        this.portBindings,
        this.links,
        this.publishAllPorts,
        this.dns,
        newValue,
        this.dnsSearch,
        this.extraHosts,
        this.groupAdd,
        this.volumesFrom,
        this.capAdd,
        this.capDrop,
        this.networkMode,
        this.securityOpt,
        this.devices,
        this.memory,
        this.memorySwap,
        this.kernelMemory,
        this.memorySwappiness,
        this.memoryReservation,
        this.nanoCpus,
        this.cpuPeriod,
        this.cpuShares,
        this.cpusetCpus,
        this.cpusetMems,
        this.cpuQuota,
        this.cgroupParent,
        this.restartPolicy,
        this.logConfig,
        this.ipcMode,
        this.ulimits,
        this.pidMode,
        this.shmSize,
        this.oomKillDisable,
        this.oomScoreAdj,
        this.autoRemove,
        this.pidsLimit,
        this.tmpfs,
        this.readonlyRootfs,
        this.storageOpt,
        this.runtime,
        this.mounts,
        this.init,
        this.sysctls,
        this.deviceRequests));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link HostConfig#dnsOptions() dnsOptions}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of dnsOptions elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableHostConfig withDnsOptions(@Nullable Iterable<String> elements) {
    if (this.dnsOptions == elements) return this;
    @Nullable List<String> newValue = elements == null ? null : createUnmodifiableList(false, createSafeList(elements, true, false));
    return validate(new ImmutableHostConfig(
        this.binds,
        this.blkioWeight,
        this.blkioWeightDevice,
        this.blkioDeviceReadBps,
        this.blkioDeviceWriteBps,
        this.blkioDeviceReadIOps,
        this.blkioDeviceWriteIOps,
        this.containerIdFile,
        this.lxcConf,
        this.privileged,
        this.portBindings,
        this.links,
        this.publishAllPorts,
        this.dns,
        newValue,
        this.dnsSearch,
        this.extraHosts,
        this.groupAdd,
        this.volumesFrom,
        this.capAdd,
        this.capDrop,
        this.networkMode,
        this.securityOpt,
        this.devices,
        this.memory,
        this.memorySwap,
        this.kernelMemory,
        this.memorySwappiness,
        this.memoryReservation,
        this.nanoCpus,
        this.cpuPeriod,
        this.cpuShares,
        this.cpusetCpus,
        this.cpusetMems,
        this.cpuQuota,
        this.cgroupParent,
        this.restartPolicy,
        this.logConfig,
        this.ipcMode,
        this.ulimits,
        this.pidMode,
        this.shmSize,
        this.oomKillDisable,
        this.oomScoreAdj,
        this.autoRemove,
        this.pidsLimit,
        this.tmpfs,
        this.readonlyRootfs,
        this.storageOpt,
        this.runtime,
        this.mounts,
        this.init,
        this.sysctls,
        this.deviceRequests));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link HostConfig#dnsSearch() dnsSearch}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableHostConfig withDnsSearch(@Nullable String... elements) {
    if (elements == null) {
      return validate(new ImmutableHostConfig(
          this.binds,
          this.blkioWeight,
          this.blkioWeightDevice,
          this.blkioDeviceReadBps,
          this.blkioDeviceWriteBps,
          this.blkioDeviceReadIOps,
          this.blkioDeviceWriteIOps,
          this.containerIdFile,
          this.lxcConf,
          this.privileged,
          this.portBindings,
          this.links,
          this.publishAllPorts,
          this.dns,
          this.dnsOptions,
          null,
          this.extraHosts,
          this.groupAdd,
          this.volumesFrom,
          this.capAdd,
          this.capDrop,
          this.networkMode,
          this.securityOpt,
          this.devices,
          this.memory,
          this.memorySwap,
          this.kernelMemory,
          this.memorySwappiness,
          this.memoryReservation,
          this.nanoCpus,
          this.cpuPeriod,
          this.cpuShares,
          this.cpusetCpus,
          this.cpusetMems,
          this.cpuQuota,
          this.cgroupParent,
          this.restartPolicy,
          this.logConfig,
          this.ipcMode,
          this.ulimits,
          this.pidMode,
          this.shmSize,
          this.oomKillDisable,
          this.oomScoreAdj,
          this.autoRemove,
          this.pidsLimit,
          this.tmpfs,
          this.readonlyRootfs,
          this.storageOpt,
          this.runtime,
          this.mounts,
          this.init,
          this.sysctls,
          this.deviceRequests));
    }
    @Nullable List<String> newValue = Arrays.asList(elements) == null ? null : createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return validate(new ImmutableHostConfig(
        this.binds,
        this.blkioWeight,
        this.blkioWeightDevice,
        this.blkioDeviceReadBps,
        this.blkioDeviceWriteBps,
        this.blkioDeviceReadIOps,
        this.blkioDeviceWriteIOps,
        this.containerIdFile,
        this.lxcConf,
        this.privileged,
        this.portBindings,
        this.links,
        this.publishAllPorts,
        this.dns,
        this.dnsOptions,
        newValue,
        this.extraHosts,
        this.groupAdd,
        this.volumesFrom,
        this.capAdd,
        this.capDrop,
        this.networkMode,
        this.securityOpt,
        this.devices,
        this.memory,
        this.memorySwap,
        this.kernelMemory,
        this.memorySwappiness,
        this.memoryReservation,
        this.nanoCpus,
        this.cpuPeriod,
        this.cpuShares,
        this.cpusetCpus,
        this.cpusetMems,
        this.cpuQuota,
        this.cgroupParent,
        this.restartPolicy,
        this.logConfig,
        this.ipcMode,
        this.ulimits,
        this.pidMode,
        this.shmSize,
        this.oomKillDisable,
        this.oomScoreAdj,
        this.autoRemove,
        this.pidsLimit,
        this.tmpfs,
        this.readonlyRootfs,
        this.storageOpt,
        this.runtime,
        this.mounts,
        this.init,
        this.sysctls,
        this.deviceRequests));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link HostConfig#dnsSearch() dnsSearch}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of dnsSearch elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableHostConfig withDnsSearch(@Nullable Iterable<String> elements) {
    if (this.dnsSearch == elements) return this;
    @Nullable List<String> newValue = elements == null ? null : createUnmodifiableList(false, createSafeList(elements, true, false));
    return validate(new ImmutableHostConfig(
        this.binds,
        this.blkioWeight,
        this.blkioWeightDevice,
        this.blkioDeviceReadBps,
        this.blkioDeviceWriteBps,
        this.blkioDeviceReadIOps,
        this.blkioDeviceWriteIOps,
        this.containerIdFile,
        this.lxcConf,
        this.privileged,
        this.portBindings,
        this.links,
        this.publishAllPorts,
        this.dns,
        this.dnsOptions,
        newValue,
        this.extraHosts,
        this.groupAdd,
        this.volumesFrom,
        this.capAdd,
        this.capDrop,
        this.networkMode,
        this.securityOpt,
        this.devices,
        this.memory,
        this.memorySwap,
        this.kernelMemory,
        this.memorySwappiness,
        this.memoryReservation,
        this.nanoCpus,
        this.cpuPeriod,
        this.cpuShares,
        this.cpusetCpus,
        this.cpusetMems,
        this.cpuQuota,
        this.cgroupParent,
        this.restartPolicy,
        this.logConfig,
        this.ipcMode,
        this.ulimits,
        this.pidMode,
        this.shmSize,
        this.oomKillDisable,
        this.oomScoreAdj,
        this.autoRemove,
        this.pidsLimit,
        this.tmpfs,
        this.readonlyRootfs,
        this.storageOpt,
        this.runtime,
        this.mounts,
        this.init,
        this.sysctls,
        this.deviceRequests));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link HostConfig#extraHosts() extraHosts}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableHostConfig withExtraHosts(@Nullable String... elements) {
    if (elements == null) {
      return validate(new ImmutableHostConfig(
          this.binds,
          this.blkioWeight,
          this.blkioWeightDevice,
          this.blkioDeviceReadBps,
          this.blkioDeviceWriteBps,
          this.blkioDeviceReadIOps,
          this.blkioDeviceWriteIOps,
          this.containerIdFile,
          this.lxcConf,
          this.privileged,
          this.portBindings,
          this.links,
          this.publishAllPorts,
          this.dns,
          this.dnsOptions,
          this.dnsSearch,
          null,
          this.groupAdd,
          this.volumesFrom,
          this.capAdd,
          this.capDrop,
          this.networkMode,
          this.securityOpt,
          this.devices,
          this.memory,
          this.memorySwap,
          this.kernelMemory,
          this.memorySwappiness,
          this.memoryReservation,
          this.nanoCpus,
          this.cpuPeriod,
          this.cpuShares,
          this.cpusetCpus,
          this.cpusetMems,
          this.cpuQuota,
          this.cgroupParent,
          this.restartPolicy,
          this.logConfig,
          this.ipcMode,
          this.ulimits,
          this.pidMode,
          this.shmSize,
          this.oomKillDisable,
          this.oomScoreAdj,
          this.autoRemove,
          this.pidsLimit,
          this.tmpfs,
          this.readonlyRootfs,
          this.storageOpt,
          this.runtime,
          this.mounts,
          this.init,
          this.sysctls,
          this.deviceRequests));
    }
    @Nullable List<String> newValue = Arrays.asList(elements) == null ? null : createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return validate(new ImmutableHostConfig(
        this.binds,
        this.blkioWeight,
        this.blkioWeightDevice,
        this.blkioDeviceReadBps,
        this.blkioDeviceWriteBps,
        this.blkioDeviceReadIOps,
        this.blkioDeviceWriteIOps,
        this.containerIdFile,
        this.lxcConf,
        this.privileged,
        this.portBindings,
        this.links,
        this.publishAllPorts,
        this.dns,
        this.dnsOptions,
        this.dnsSearch,
        newValue,
        this.groupAdd,
        this.volumesFrom,
        this.capAdd,
        this.capDrop,
        this.networkMode,
        this.securityOpt,
        this.devices,
        this.memory,
        this.memorySwap,
        this.kernelMemory,
        this.memorySwappiness,
        this.memoryReservation,
        this.nanoCpus,
        this.cpuPeriod,
        this.cpuShares,
        this.cpusetCpus,
        this.cpusetMems,
        this.cpuQuota,
        this.cgroupParent,
        this.restartPolicy,
        this.logConfig,
        this.ipcMode,
        this.ulimits,
        this.pidMode,
        this.shmSize,
        this.oomKillDisable,
        this.oomScoreAdj,
        this.autoRemove,
        this.pidsLimit,
        this.tmpfs,
        this.readonlyRootfs,
        this.storageOpt,
        this.runtime,
        this.mounts,
        this.init,
        this.sysctls,
        this.deviceRequests));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link HostConfig#extraHosts() extraHosts}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of extraHosts elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableHostConfig withExtraHosts(@Nullable Iterable<String> elements) {
    if (this.extraHosts == elements) return this;
    @Nullable List<String> newValue = elements == null ? null : createUnmodifiableList(false, createSafeList(elements, true, false));
    return validate(new ImmutableHostConfig(
        this.binds,
        this.blkioWeight,
        this.blkioWeightDevice,
        this.blkioDeviceReadBps,
        this.blkioDeviceWriteBps,
        this.blkioDeviceReadIOps,
        this.blkioDeviceWriteIOps,
        this.containerIdFile,
        this.lxcConf,
        this.privileged,
        this.portBindings,
        this.links,
        this.publishAllPorts,
        this.dns,
        this.dnsOptions,
        this.dnsSearch,
        newValue,
        this.groupAdd,
        this.volumesFrom,
        this.capAdd,
        this.capDrop,
        this.networkMode,
        this.securityOpt,
        this.devices,
        this.memory,
        this.memorySwap,
        this.kernelMemory,
        this.memorySwappiness,
        this.memoryReservation,
        this.nanoCpus,
        this.cpuPeriod,
        this.cpuShares,
        this.cpusetCpus,
        this.cpusetMems,
        this.cpuQuota,
        this.cgroupParent,
        this.restartPolicy,
        this.logConfig,
        this.ipcMode,
        this.ulimits,
        this.pidMode,
        this.shmSize,
        this.oomKillDisable,
        this.oomScoreAdj,
        this.autoRemove,
        this.pidsLimit,
        this.tmpfs,
        this.readonlyRootfs,
        this.storageOpt,
        this.runtime,
        this.mounts,
        this.init,
        this.sysctls,
        this.deviceRequests));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link HostConfig#groupAdd() groupAdd}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableHostConfig withGroupAdd(@Nullable String... elements) {
    if (elements == null) {
      return validate(new ImmutableHostConfig(
          this.binds,
          this.blkioWeight,
          this.blkioWeightDevice,
          this.blkioDeviceReadBps,
          this.blkioDeviceWriteBps,
          this.blkioDeviceReadIOps,
          this.blkioDeviceWriteIOps,
          this.containerIdFile,
          this.lxcConf,
          this.privileged,
          this.portBindings,
          this.links,
          this.publishAllPorts,
          this.dns,
          this.dnsOptions,
          this.dnsSearch,
          this.extraHosts,
          null,
          this.volumesFrom,
          this.capAdd,
          this.capDrop,
          this.networkMode,
          this.securityOpt,
          this.devices,
          this.memory,
          this.memorySwap,
          this.kernelMemory,
          this.memorySwappiness,
          this.memoryReservation,
          this.nanoCpus,
          this.cpuPeriod,
          this.cpuShares,
          this.cpusetCpus,
          this.cpusetMems,
          this.cpuQuota,
          this.cgroupParent,
          this.restartPolicy,
          this.logConfig,
          this.ipcMode,
          this.ulimits,
          this.pidMode,
          this.shmSize,
          this.oomKillDisable,
          this.oomScoreAdj,
          this.autoRemove,
          this.pidsLimit,
          this.tmpfs,
          this.readonlyRootfs,
          this.storageOpt,
          this.runtime,
          this.mounts,
          this.init,
          this.sysctls,
          this.deviceRequests));
    }
    @Nullable List<String> newValue = Arrays.asList(elements) == null ? null : createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return validate(new ImmutableHostConfig(
        this.binds,
        this.blkioWeight,
        this.blkioWeightDevice,
        this.blkioDeviceReadBps,
        this.blkioDeviceWriteBps,
        this.blkioDeviceReadIOps,
        this.blkioDeviceWriteIOps,
        this.containerIdFile,
        this.lxcConf,
        this.privileged,
        this.portBindings,
        this.links,
        this.publishAllPorts,
        this.dns,
        this.dnsOptions,
        this.dnsSearch,
        this.extraHosts,
        newValue,
        this.volumesFrom,
        this.capAdd,
        this.capDrop,
        this.networkMode,
        this.securityOpt,
        this.devices,
        this.memory,
        this.memorySwap,
        this.kernelMemory,
        this.memorySwappiness,
        this.memoryReservation,
        this.nanoCpus,
        this.cpuPeriod,
        this.cpuShares,
        this.cpusetCpus,
        this.cpusetMems,
        this.cpuQuota,
        this.cgroupParent,
        this.restartPolicy,
        this.logConfig,
        this.ipcMode,
        this.ulimits,
        this.pidMode,
        this.shmSize,
        this.oomKillDisable,
        this.oomScoreAdj,
        this.autoRemove,
        this.pidsLimit,
        this.tmpfs,
        this.readonlyRootfs,
        this.storageOpt,
        this.runtime,
        this.mounts,
        this.init,
        this.sysctls,
        this.deviceRequests));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link HostConfig#groupAdd() groupAdd}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of groupAdd elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableHostConfig withGroupAdd(@Nullable Iterable<String> elements) {
    if (this.groupAdd == elements) return this;
    @Nullable List<String> newValue = elements == null ? null : createUnmodifiableList(false, createSafeList(elements, true, false));
    return validate(new ImmutableHostConfig(
        this.binds,
        this.blkioWeight,
        this.blkioWeightDevice,
        this.blkioDeviceReadBps,
        this.blkioDeviceWriteBps,
        this.blkioDeviceReadIOps,
        this.blkioDeviceWriteIOps,
        this.containerIdFile,
        this.lxcConf,
        this.privileged,
        this.portBindings,
        this.links,
        this.publishAllPorts,
        this.dns,
        this.dnsOptions,
        this.dnsSearch,
        this.extraHosts,
        newValue,
        this.volumesFrom,
        this.capAdd,
        this.capDrop,
        this.networkMode,
        this.securityOpt,
        this.devices,
        this.memory,
        this.memorySwap,
        this.kernelMemory,
        this.memorySwappiness,
        this.memoryReservation,
        this.nanoCpus,
        this.cpuPeriod,
        this.cpuShares,
        this.cpusetCpus,
        this.cpusetMems,
        this.cpuQuota,
        this.cgroupParent,
        this.restartPolicy,
        this.logConfig,
        this.ipcMode,
        this.ulimits,
        this.pidMode,
        this.shmSize,
        this.oomKillDisable,
        this.oomScoreAdj,
        this.autoRemove,
        this.pidsLimit,
        this.tmpfs,
        this.readonlyRootfs,
        this.storageOpt,
        this.runtime,
        this.mounts,
        this.init,
        this.sysctls,
        this.deviceRequests));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link HostConfig#volumesFrom() volumesFrom}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableHostConfig withVolumesFrom(@Nullable String... elements) {
    if (elements == null) {
      return validate(new ImmutableHostConfig(
          this.binds,
          this.blkioWeight,
          this.blkioWeightDevice,
          this.blkioDeviceReadBps,
          this.blkioDeviceWriteBps,
          this.blkioDeviceReadIOps,
          this.blkioDeviceWriteIOps,
          this.containerIdFile,
          this.lxcConf,
          this.privileged,
          this.portBindings,
          this.links,
          this.publishAllPorts,
          this.dns,
          this.dnsOptions,
          this.dnsSearch,
          this.extraHosts,
          this.groupAdd,
          null,
          this.capAdd,
          this.capDrop,
          this.networkMode,
          this.securityOpt,
          this.devices,
          this.memory,
          this.memorySwap,
          this.kernelMemory,
          this.memorySwappiness,
          this.memoryReservation,
          this.nanoCpus,
          this.cpuPeriod,
          this.cpuShares,
          this.cpusetCpus,
          this.cpusetMems,
          this.cpuQuota,
          this.cgroupParent,
          this.restartPolicy,
          this.logConfig,
          this.ipcMode,
          this.ulimits,
          this.pidMode,
          this.shmSize,
          this.oomKillDisable,
          this.oomScoreAdj,
          this.autoRemove,
          this.pidsLimit,
          this.tmpfs,
          this.readonlyRootfs,
          this.storageOpt,
          this.runtime,
          this.mounts,
          this.init,
          this.sysctls,
          this.deviceRequests));
    }
    @Nullable List<String> newValue = Arrays.asList(elements) == null ? null : createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return validate(new ImmutableHostConfig(
        this.binds,
        this.blkioWeight,
        this.blkioWeightDevice,
        this.blkioDeviceReadBps,
        this.blkioDeviceWriteBps,
        this.blkioDeviceReadIOps,
        this.blkioDeviceWriteIOps,
        this.containerIdFile,
        this.lxcConf,
        this.privileged,
        this.portBindings,
        this.links,
        this.publishAllPorts,
        this.dns,
        this.dnsOptions,
        this.dnsSearch,
        this.extraHosts,
        this.groupAdd,
        newValue,
        this.capAdd,
        this.capDrop,
        this.networkMode,
        this.securityOpt,
        this.devices,
        this.memory,
        this.memorySwap,
        this.kernelMemory,
        this.memorySwappiness,
        this.memoryReservation,
        this.nanoCpus,
        this.cpuPeriod,
        this.cpuShares,
        this.cpusetCpus,
        this.cpusetMems,
        this.cpuQuota,
        this.cgroupParent,
        this.restartPolicy,
        this.logConfig,
        this.ipcMode,
        this.ulimits,
        this.pidMode,
        this.shmSize,
        this.oomKillDisable,
        this.oomScoreAdj,
        this.autoRemove,
        this.pidsLimit,
        this.tmpfs,
        this.readonlyRootfs,
        this.storageOpt,
        this.runtime,
        this.mounts,
        this.init,
        this.sysctls,
        this.deviceRequests));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link HostConfig#volumesFrom() volumesFrom}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of volumesFrom elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableHostConfig withVolumesFrom(@Nullable Iterable<String> elements) {
    if (this.volumesFrom == elements) return this;
    @Nullable List<String> newValue = elements == null ? null : createUnmodifiableList(false, createSafeList(elements, true, false));
    return validate(new ImmutableHostConfig(
        this.binds,
        this.blkioWeight,
        this.blkioWeightDevice,
        this.blkioDeviceReadBps,
        this.blkioDeviceWriteBps,
        this.blkioDeviceReadIOps,
        this.blkioDeviceWriteIOps,
        this.containerIdFile,
        this.lxcConf,
        this.privileged,
        this.portBindings,
        this.links,
        this.publishAllPorts,
        this.dns,
        this.dnsOptions,
        this.dnsSearch,
        this.extraHosts,
        this.groupAdd,
        newValue,
        this.capAdd,
        this.capDrop,
        this.networkMode,
        this.securityOpt,
        this.devices,
        this.memory,
        this.memorySwap,
        this.kernelMemory,
        this.memorySwappiness,
        this.memoryReservation,
        this.nanoCpus,
        this.cpuPeriod,
        this.cpuShares,
        this.cpusetCpus,
        this.cpusetMems,
        this.cpuQuota,
        this.cgroupParent,
        this.restartPolicy,
        this.logConfig,
        this.ipcMode,
        this.ulimits,
        this.pidMode,
        this.shmSize,
        this.oomKillDisable,
        this.oomScoreAdj,
        this.autoRemove,
        this.pidsLimit,
        this.tmpfs,
        this.readonlyRootfs,
        this.storageOpt,
        this.runtime,
        this.mounts,
        this.init,
        this.sysctls,
        this.deviceRequests));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link HostConfig#capAdd() capAdd}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableHostConfig withCapAdd(@Nullable String... elements) {
    if (elements == null) {
      return validate(new ImmutableHostConfig(
          this.binds,
          this.blkioWeight,
          this.blkioWeightDevice,
          this.blkioDeviceReadBps,
          this.blkioDeviceWriteBps,
          this.blkioDeviceReadIOps,
          this.blkioDeviceWriteIOps,
          this.containerIdFile,
          this.lxcConf,
          this.privileged,
          this.portBindings,
          this.links,
          this.publishAllPorts,
          this.dns,
          this.dnsOptions,
          this.dnsSearch,
          this.extraHosts,
          this.groupAdd,
          this.volumesFrom,
          null,
          this.capDrop,
          this.networkMode,
          this.securityOpt,
          this.devices,
          this.memory,
          this.memorySwap,
          this.kernelMemory,
          this.memorySwappiness,
          this.memoryReservation,
          this.nanoCpus,
          this.cpuPeriod,
          this.cpuShares,
          this.cpusetCpus,
          this.cpusetMems,
          this.cpuQuota,
          this.cgroupParent,
          this.restartPolicy,
          this.logConfig,
          this.ipcMode,
          this.ulimits,
          this.pidMode,
          this.shmSize,
          this.oomKillDisable,
          this.oomScoreAdj,
          this.autoRemove,
          this.pidsLimit,
          this.tmpfs,
          this.readonlyRootfs,
          this.storageOpt,
          this.runtime,
          this.mounts,
          this.init,
          this.sysctls,
          this.deviceRequests));
    }
    @Nullable List<String> newValue = Arrays.asList(elements) == null ? null : createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return validate(new ImmutableHostConfig(
        this.binds,
        this.blkioWeight,
        this.blkioWeightDevice,
        this.blkioDeviceReadBps,
        this.blkioDeviceWriteBps,
        this.blkioDeviceReadIOps,
        this.blkioDeviceWriteIOps,
        this.containerIdFile,
        this.lxcConf,
        this.privileged,
        this.portBindings,
        this.links,
        this.publishAllPorts,
        this.dns,
        this.dnsOptions,
        this.dnsSearch,
        this.extraHosts,
        this.groupAdd,
        this.volumesFrom,
        newValue,
        this.capDrop,
        this.networkMode,
        this.securityOpt,
        this.devices,
        this.memory,
        this.memorySwap,
        this.kernelMemory,
        this.memorySwappiness,
        this.memoryReservation,
        this.nanoCpus,
        this.cpuPeriod,
        this.cpuShares,
        this.cpusetCpus,
        this.cpusetMems,
        this.cpuQuota,
        this.cgroupParent,
        this.restartPolicy,
        this.logConfig,
        this.ipcMode,
        this.ulimits,
        this.pidMode,
        this.shmSize,
        this.oomKillDisable,
        this.oomScoreAdj,
        this.autoRemove,
        this.pidsLimit,
        this.tmpfs,
        this.readonlyRootfs,
        this.storageOpt,
        this.runtime,
        this.mounts,
        this.init,
        this.sysctls,
        this.deviceRequests));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link HostConfig#capAdd() capAdd}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of capAdd elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableHostConfig withCapAdd(@Nullable Iterable<String> elements) {
    if (this.capAdd == elements) return this;
    @Nullable List<String> newValue = elements == null ? null : createUnmodifiableList(false, createSafeList(elements, true, false));
    return validate(new ImmutableHostConfig(
        this.binds,
        this.blkioWeight,
        this.blkioWeightDevice,
        this.blkioDeviceReadBps,
        this.blkioDeviceWriteBps,
        this.blkioDeviceReadIOps,
        this.blkioDeviceWriteIOps,
        this.containerIdFile,
        this.lxcConf,
        this.privileged,
        this.portBindings,
        this.links,
        this.publishAllPorts,
        this.dns,
        this.dnsOptions,
        this.dnsSearch,
        this.extraHosts,
        this.groupAdd,
        this.volumesFrom,
        newValue,
        this.capDrop,
        this.networkMode,
        this.securityOpt,
        this.devices,
        this.memory,
        this.memorySwap,
        this.kernelMemory,
        this.memorySwappiness,
        this.memoryReservation,
        this.nanoCpus,
        this.cpuPeriod,
        this.cpuShares,
        this.cpusetCpus,
        this.cpusetMems,
        this.cpuQuota,
        this.cgroupParent,
        this.restartPolicy,
        this.logConfig,
        this.ipcMode,
        this.ulimits,
        this.pidMode,
        this.shmSize,
        this.oomKillDisable,
        this.oomScoreAdj,
        this.autoRemove,
        this.pidsLimit,
        this.tmpfs,
        this.readonlyRootfs,
        this.storageOpt,
        this.runtime,
        this.mounts,
        this.init,
        this.sysctls,
        this.deviceRequests));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link HostConfig#capDrop() capDrop}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableHostConfig withCapDrop(@Nullable String... elements) {
    if (elements == null) {
      return validate(new ImmutableHostConfig(
          this.binds,
          this.blkioWeight,
          this.blkioWeightDevice,
          this.blkioDeviceReadBps,
          this.blkioDeviceWriteBps,
          this.blkioDeviceReadIOps,
          this.blkioDeviceWriteIOps,
          this.containerIdFile,
          this.lxcConf,
          this.privileged,
          this.portBindings,
          this.links,
          this.publishAllPorts,
          this.dns,
          this.dnsOptions,
          this.dnsSearch,
          this.extraHosts,
          this.groupAdd,
          this.volumesFrom,
          this.capAdd,
          null,
          this.networkMode,
          this.securityOpt,
          this.devices,
          this.memory,
          this.memorySwap,
          this.kernelMemory,
          this.memorySwappiness,
          this.memoryReservation,
          this.nanoCpus,
          this.cpuPeriod,
          this.cpuShares,
          this.cpusetCpus,
          this.cpusetMems,
          this.cpuQuota,
          this.cgroupParent,
          this.restartPolicy,
          this.logConfig,
          this.ipcMode,
          this.ulimits,
          this.pidMode,
          this.shmSize,
          this.oomKillDisable,
          this.oomScoreAdj,
          this.autoRemove,
          this.pidsLimit,
          this.tmpfs,
          this.readonlyRootfs,
          this.storageOpt,
          this.runtime,
          this.mounts,
          this.init,
          this.sysctls,
          this.deviceRequests));
    }
    @Nullable List<String> newValue = Arrays.asList(elements) == null ? null : createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return validate(new ImmutableHostConfig(
        this.binds,
        this.blkioWeight,
        this.blkioWeightDevice,
        this.blkioDeviceReadBps,
        this.blkioDeviceWriteBps,
        this.blkioDeviceReadIOps,
        this.blkioDeviceWriteIOps,
        this.containerIdFile,
        this.lxcConf,
        this.privileged,
        this.portBindings,
        this.links,
        this.publishAllPorts,
        this.dns,
        this.dnsOptions,
        this.dnsSearch,
        this.extraHosts,
        this.groupAdd,
        this.volumesFrom,
        this.capAdd,
        newValue,
        this.networkMode,
        this.securityOpt,
        this.devices,
        this.memory,
        this.memorySwap,
        this.kernelMemory,
        this.memorySwappiness,
        this.memoryReservation,
        this.nanoCpus,
        this.cpuPeriod,
        this.cpuShares,
        this.cpusetCpus,
        this.cpusetMems,
        this.cpuQuota,
        this.cgroupParent,
        this.restartPolicy,
        this.logConfig,
        this.ipcMode,
        this.ulimits,
        this.pidMode,
        this.shmSize,
        this.oomKillDisable,
        this.oomScoreAdj,
        this.autoRemove,
        this.pidsLimit,
        this.tmpfs,
        this.readonlyRootfs,
        this.storageOpt,
        this.runtime,
        this.mounts,
        this.init,
        this.sysctls,
        this.deviceRequests));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link HostConfig#capDrop() capDrop}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of capDrop elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableHostConfig withCapDrop(@Nullable Iterable<String> elements) {
    if (this.capDrop == elements) return this;
    @Nullable List<String> newValue = elements == null ? null : createUnmodifiableList(false, createSafeList(elements, true, false));
    return validate(new ImmutableHostConfig(
        this.binds,
        this.blkioWeight,
        this.blkioWeightDevice,
        this.blkioDeviceReadBps,
        this.blkioDeviceWriteBps,
        this.blkioDeviceReadIOps,
        this.blkioDeviceWriteIOps,
        this.containerIdFile,
        this.lxcConf,
        this.privileged,
        this.portBindings,
        this.links,
        this.publishAllPorts,
        this.dns,
        this.dnsOptions,
        this.dnsSearch,
        this.extraHosts,
        this.groupAdd,
        this.volumesFrom,
        this.capAdd,
        newValue,
        this.networkMode,
        this.securityOpt,
        this.devices,
        this.memory,
        this.memorySwap,
        this.kernelMemory,
        this.memorySwappiness,
        this.memoryReservation,
        this.nanoCpus,
        this.cpuPeriod,
        this.cpuShares,
        this.cpusetCpus,
        this.cpusetMems,
        this.cpuQuota,
        this.cgroupParent,
        this.restartPolicy,
        this.logConfig,
        this.ipcMode,
        this.ulimits,
        this.pidMode,
        this.shmSize,
        this.oomKillDisable,
        this.oomScoreAdj,
        this.autoRemove,
        this.pidsLimit,
        this.tmpfs,
        this.readonlyRootfs,
        this.storageOpt,
        this.runtime,
        this.mounts,
        this.init,
        this.sysctls,
        this.deviceRequests));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link HostConfig#networkMode() networkMode} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for networkMode (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableHostConfig withNetworkMode(@Nullable String value) {
    if (Objects.equals(this.networkMode, value)) return this;
    return validate(new ImmutableHostConfig(
        this.binds,
        this.blkioWeight,
        this.blkioWeightDevice,
        this.blkioDeviceReadBps,
        this.blkioDeviceWriteBps,
        this.blkioDeviceReadIOps,
        this.blkioDeviceWriteIOps,
        this.containerIdFile,
        this.lxcConf,
        this.privileged,
        this.portBindings,
        this.links,
        this.publishAllPorts,
        this.dns,
        this.dnsOptions,
        this.dnsSearch,
        this.extraHosts,
        this.groupAdd,
        this.volumesFrom,
        this.capAdd,
        this.capDrop,
        value,
        this.securityOpt,
        this.devices,
        this.memory,
        this.memorySwap,
        this.kernelMemory,
        this.memorySwappiness,
        this.memoryReservation,
        this.nanoCpus,
        this.cpuPeriod,
        this.cpuShares,
        this.cpusetCpus,
        this.cpusetMems,
        this.cpuQuota,
        this.cgroupParent,
        this.restartPolicy,
        this.logConfig,
        this.ipcMode,
        this.ulimits,
        this.pidMode,
        this.shmSize,
        this.oomKillDisable,
        this.oomScoreAdj,
        this.autoRemove,
        this.pidsLimit,
        this.tmpfs,
        this.readonlyRootfs,
        this.storageOpt,
        this.runtime,
        this.mounts,
        this.init,
        this.sysctls,
        this.deviceRequests));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link HostConfig#securityOpt() securityOpt}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableHostConfig withSecurityOpt(@Nullable String... elements) {
    if (elements == null) {
      return validate(new ImmutableHostConfig(
          this.binds,
          this.blkioWeight,
          this.blkioWeightDevice,
          this.blkioDeviceReadBps,
          this.blkioDeviceWriteBps,
          this.blkioDeviceReadIOps,
          this.blkioDeviceWriteIOps,
          this.containerIdFile,
          this.lxcConf,
          this.privileged,
          this.portBindings,
          this.links,
          this.publishAllPorts,
          this.dns,
          this.dnsOptions,
          this.dnsSearch,
          this.extraHosts,
          this.groupAdd,
          this.volumesFrom,
          this.capAdd,
          this.capDrop,
          this.networkMode,
          null,
          this.devices,
          this.memory,
          this.memorySwap,
          this.kernelMemory,
          this.memorySwappiness,
          this.memoryReservation,
          this.nanoCpus,
          this.cpuPeriod,
          this.cpuShares,
          this.cpusetCpus,
          this.cpusetMems,
          this.cpuQuota,
          this.cgroupParent,
          this.restartPolicy,
          this.logConfig,
          this.ipcMode,
          this.ulimits,
          this.pidMode,
          this.shmSize,
          this.oomKillDisable,
          this.oomScoreAdj,
          this.autoRemove,
          this.pidsLimit,
          this.tmpfs,
          this.readonlyRootfs,
          this.storageOpt,
          this.runtime,
          this.mounts,
          this.init,
          this.sysctls,
          this.deviceRequests));
    }
    @Nullable List<String> newValue = Arrays.asList(elements) == null ? null : createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return validate(new ImmutableHostConfig(
        this.binds,
        this.blkioWeight,
        this.blkioWeightDevice,
        this.blkioDeviceReadBps,
        this.blkioDeviceWriteBps,
        this.blkioDeviceReadIOps,
        this.blkioDeviceWriteIOps,
        this.containerIdFile,
        this.lxcConf,
        this.privileged,
        this.portBindings,
        this.links,
        this.publishAllPorts,
        this.dns,
        this.dnsOptions,
        this.dnsSearch,
        this.extraHosts,
        this.groupAdd,
        this.volumesFrom,
        this.capAdd,
        this.capDrop,
        this.networkMode,
        newValue,
        this.devices,
        this.memory,
        this.memorySwap,
        this.kernelMemory,
        this.memorySwappiness,
        this.memoryReservation,
        this.nanoCpus,
        this.cpuPeriod,
        this.cpuShares,
        this.cpusetCpus,
        this.cpusetMems,
        this.cpuQuota,
        this.cgroupParent,
        this.restartPolicy,
        this.logConfig,
        this.ipcMode,
        this.ulimits,
        this.pidMode,
        this.shmSize,
        this.oomKillDisable,
        this.oomScoreAdj,
        this.autoRemove,
        this.pidsLimit,
        this.tmpfs,
        this.readonlyRootfs,
        this.storageOpt,
        this.runtime,
        this.mounts,
        this.init,
        this.sysctls,
        this.deviceRequests));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link HostConfig#securityOpt() securityOpt}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of securityOpt elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableHostConfig withSecurityOpt(@Nullable Iterable<String> elements) {
    if (this.securityOpt == elements) return this;
    @Nullable List<String> newValue = elements == null ? null : createUnmodifiableList(false, createSafeList(elements, true, false));
    return validate(new ImmutableHostConfig(
        this.binds,
        this.blkioWeight,
        this.blkioWeightDevice,
        this.blkioDeviceReadBps,
        this.blkioDeviceWriteBps,
        this.blkioDeviceReadIOps,
        this.blkioDeviceWriteIOps,
        this.containerIdFile,
        this.lxcConf,
        this.privileged,
        this.portBindings,
        this.links,
        this.publishAllPorts,
        this.dns,
        this.dnsOptions,
        this.dnsSearch,
        this.extraHosts,
        this.groupAdd,
        this.volumesFrom,
        this.capAdd,
        this.capDrop,
        this.networkMode,
        newValue,
        this.devices,
        this.memory,
        this.memorySwap,
        this.kernelMemory,
        this.memorySwappiness,
        this.memoryReservation,
        this.nanoCpus,
        this.cpuPeriod,
        this.cpuShares,
        this.cpusetCpus,
        this.cpusetMems,
        this.cpuQuota,
        this.cgroupParent,
        this.restartPolicy,
        this.logConfig,
        this.ipcMode,
        this.ulimits,
        this.pidMode,
        this.shmSize,
        this.oomKillDisable,
        this.oomScoreAdj,
        this.autoRemove,
        this.pidsLimit,
        this.tmpfs,
        this.readonlyRootfs,
        this.storageOpt,
        this.runtime,
        this.mounts,
        this.init,
        this.sysctls,
        this.deviceRequests));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link HostConfig#devices() devices}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableHostConfig withDevices(@Nullable Device... elements) {
    if (elements == null) {
      return validate(new ImmutableHostConfig(
          this.binds,
          this.blkioWeight,
          this.blkioWeightDevice,
          this.blkioDeviceReadBps,
          this.blkioDeviceWriteBps,
          this.blkioDeviceReadIOps,
          this.blkioDeviceWriteIOps,
          this.containerIdFile,
          this.lxcConf,
          this.privileged,
          this.portBindings,
          this.links,
          this.publishAllPorts,
          this.dns,
          this.dnsOptions,
          this.dnsSearch,
          this.extraHosts,
          this.groupAdd,
          this.volumesFrom,
          this.capAdd,
          this.capDrop,
          this.networkMode,
          this.securityOpt,
          null,
          this.memory,
          this.memorySwap,
          this.kernelMemory,
          this.memorySwappiness,
          this.memoryReservation,
          this.nanoCpus,
          this.cpuPeriod,
          this.cpuShares,
          this.cpusetCpus,
          this.cpusetMems,
          this.cpuQuota,
          this.cgroupParent,
          this.restartPolicy,
          this.logConfig,
          this.ipcMode,
          this.ulimits,
          this.pidMode,
          this.shmSize,
          this.oomKillDisable,
          this.oomScoreAdj,
          this.autoRemove,
          this.pidsLimit,
          this.tmpfs,
          this.readonlyRootfs,
          this.storageOpt,
          this.runtime,
          this.mounts,
          this.init,
          this.sysctls,
          this.deviceRequests));
    }
    @Nullable List<Device> newValue = Arrays.asList(elements) == null ? null : createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return validate(new ImmutableHostConfig(
        this.binds,
        this.blkioWeight,
        this.blkioWeightDevice,
        this.blkioDeviceReadBps,
        this.blkioDeviceWriteBps,
        this.blkioDeviceReadIOps,
        this.blkioDeviceWriteIOps,
        this.containerIdFile,
        this.lxcConf,
        this.privileged,
        this.portBindings,
        this.links,
        this.publishAllPorts,
        this.dns,
        this.dnsOptions,
        this.dnsSearch,
        this.extraHosts,
        this.groupAdd,
        this.volumesFrom,
        this.capAdd,
        this.capDrop,
        this.networkMode,
        this.securityOpt,
        newValue,
        this.memory,
        this.memorySwap,
        this.kernelMemory,
        this.memorySwappiness,
        this.memoryReservation,
        this.nanoCpus,
        this.cpuPeriod,
        this.cpuShares,
        this.cpusetCpus,
        this.cpusetMems,
        this.cpuQuota,
        this.cgroupParent,
        this.restartPolicy,
        this.logConfig,
        this.ipcMode,
        this.ulimits,
        this.pidMode,
        this.shmSize,
        this.oomKillDisable,
        this.oomScoreAdj,
        this.autoRemove,
        this.pidsLimit,
        this.tmpfs,
        this.readonlyRootfs,
        this.storageOpt,
        this.runtime,
        this.mounts,
        this.init,
        this.sysctls,
        this.deviceRequests));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link HostConfig#devices() devices}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of devices elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableHostConfig withDevices(@Nullable Iterable<? extends Device> elements) {
    if (this.devices == elements) return this;
    @Nullable List<Device> newValue = elements == null ? null : createUnmodifiableList(false, createSafeList(elements, true, false));
    return validate(new ImmutableHostConfig(
        this.binds,
        this.blkioWeight,
        this.blkioWeightDevice,
        this.blkioDeviceReadBps,
        this.blkioDeviceWriteBps,
        this.blkioDeviceReadIOps,
        this.blkioDeviceWriteIOps,
        this.containerIdFile,
        this.lxcConf,
        this.privileged,
        this.portBindings,
        this.links,
        this.publishAllPorts,
        this.dns,
        this.dnsOptions,
        this.dnsSearch,
        this.extraHosts,
        this.groupAdd,
        this.volumesFrom,
        this.capAdd,
        this.capDrop,
        this.networkMode,
        this.securityOpt,
        newValue,
        this.memory,
        this.memorySwap,
        this.kernelMemory,
        this.memorySwappiness,
        this.memoryReservation,
        this.nanoCpus,
        this.cpuPeriod,
        this.cpuShares,
        this.cpusetCpus,
        this.cpusetMems,
        this.cpuQuota,
        this.cgroupParent,
        this.restartPolicy,
        this.logConfig,
        this.ipcMode,
        this.ulimits,
        this.pidMode,
        this.shmSize,
        this.oomKillDisable,
        this.oomScoreAdj,
        this.autoRemove,
        this.pidsLimit,
        this.tmpfs,
        this.readonlyRootfs,
        this.storageOpt,
        this.runtime,
        this.mounts,
        this.init,
        this.sysctls,
        this.deviceRequests));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link HostConfig#memory() memory} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for memory (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableHostConfig withMemory(@Nullable Long value) {
    if (Objects.equals(this.memory, value)) return this;
    return validate(new ImmutableHostConfig(
        this.binds,
        this.blkioWeight,
        this.blkioWeightDevice,
        this.blkioDeviceReadBps,
        this.blkioDeviceWriteBps,
        this.blkioDeviceReadIOps,
        this.blkioDeviceWriteIOps,
        this.containerIdFile,
        this.lxcConf,
        this.privileged,
        this.portBindings,
        this.links,
        this.publishAllPorts,
        this.dns,
        this.dnsOptions,
        this.dnsSearch,
        this.extraHosts,
        this.groupAdd,
        this.volumesFrom,
        this.capAdd,
        this.capDrop,
        this.networkMode,
        this.securityOpt,
        this.devices,
        value,
        this.memorySwap,
        this.kernelMemory,
        this.memorySwappiness,
        this.memoryReservation,
        this.nanoCpus,
        this.cpuPeriod,
        this.cpuShares,
        this.cpusetCpus,
        this.cpusetMems,
        this.cpuQuota,
        this.cgroupParent,
        this.restartPolicy,
        this.logConfig,
        this.ipcMode,
        this.ulimits,
        this.pidMode,
        this.shmSize,
        this.oomKillDisable,
        this.oomScoreAdj,
        this.autoRemove,
        this.pidsLimit,
        this.tmpfs,
        this.readonlyRootfs,
        this.storageOpt,
        this.runtime,
        this.mounts,
        this.init,
        this.sysctls,
        this.deviceRequests));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link HostConfig#memorySwap() memorySwap} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for memorySwap (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableHostConfig withMemorySwap(@Nullable Long value) {
    if (Objects.equals(this.memorySwap, value)) return this;
    return validate(new ImmutableHostConfig(
        this.binds,
        this.blkioWeight,
        this.blkioWeightDevice,
        this.blkioDeviceReadBps,
        this.blkioDeviceWriteBps,
        this.blkioDeviceReadIOps,
        this.blkioDeviceWriteIOps,
        this.containerIdFile,
        this.lxcConf,
        this.privileged,
        this.portBindings,
        this.links,
        this.publishAllPorts,
        this.dns,
        this.dnsOptions,
        this.dnsSearch,
        this.extraHosts,
        this.groupAdd,
        this.volumesFrom,
        this.capAdd,
        this.capDrop,
        this.networkMode,
        this.securityOpt,
        this.devices,
        this.memory,
        value,
        this.kernelMemory,
        this.memorySwappiness,
        this.memoryReservation,
        this.nanoCpus,
        this.cpuPeriod,
        this.cpuShares,
        this.cpusetCpus,
        this.cpusetMems,
        this.cpuQuota,
        this.cgroupParent,
        this.restartPolicy,
        this.logConfig,
        this.ipcMode,
        this.ulimits,
        this.pidMode,
        this.shmSize,
        this.oomKillDisable,
        this.oomScoreAdj,
        this.autoRemove,
        this.pidsLimit,
        this.tmpfs,
        this.readonlyRootfs,
        this.storageOpt,
        this.runtime,
        this.mounts,
        this.init,
        this.sysctls,
        this.deviceRequests));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link HostConfig#kernelMemory() kernelMemory} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for kernelMemory (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  @Deprecated
  public final ImmutableHostConfig withKernelMemory(@Nullable Long value) {
    if (Objects.equals(this.kernelMemory, value)) return this;
    return validate(new ImmutableHostConfig(
        this.binds,
        this.blkioWeight,
        this.blkioWeightDevice,
        this.blkioDeviceReadBps,
        this.blkioDeviceWriteBps,
        this.blkioDeviceReadIOps,
        this.blkioDeviceWriteIOps,
        this.containerIdFile,
        this.lxcConf,
        this.privileged,
        this.portBindings,
        this.links,
        this.publishAllPorts,
        this.dns,
        this.dnsOptions,
        this.dnsSearch,
        this.extraHosts,
        this.groupAdd,
        this.volumesFrom,
        this.capAdd,
        this.capDrop,
        this.networkMode,
        this.securityOpt,
        this.devices,
        this.memory,
        this.memorySwap,
        value,
        this.memorySwappiness,
        this.memoryReservation,
        this.nanoCpus,
        this.cpuPeriod,
        this.cpuShares,
        this.cpusetCpus,
        this.cpusetMems,
        this.cpuQuota,
        this.cgroupParent,
        this.restartPolicy,
        this.logConfig,
        this.ipcMode,
        this.ulimits,
        this.pidMode,
        this.shmSize,
        this.oomKillDisable,
        this.oomScoreAdj,
        this.autoRemove,
        this.pidsLimit,
        this.tmpfs,
        this.readonlyRootfs,
        this.storageOpt,
        this.runtime,
        this.mounts,
        this.init,
        this.sysctls,
        this.deviceRequests));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link HostConfig#memorySwappiness() memorySwappiness} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for memorySwappiness (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableHostConfig withMemorySwappiness(@Nullable Integer value) {
    if (Objects.equals(this.memorySwappiness, value)) return this;
    return validate(new ImmutableHostConfig(
        this.binds,
        this.blkioWeight,
        this.blkioWeightDevice,
        this.blkioDeviceReadBps,
        this.blkioDeviceWriteBps,
        this.blkioDeviceReadIOps,
        this.blkioDeviceWriteIOps,
        this.containerIdFile,
        this.lxcConf,
        this.privileged,
        this.portBindings,
        this.links,
        this.publishAllPorts,
        this.dns,
        this.dnsOptions,
        this.dnsSearch,
        this.extraHosts,
        this.groupAdd,
        this.volumesFrom,
        this.capAdd,
        this.capDrop,
        this.networkMode,
        this.securityOpt,
        this.devices,
        this.memory,
        this.memorySwap,
        this.kernelMemory,
        value,
        this.memoryReservation,
        this.nanoCpus,
        this.cpuPeriod,
        this.cpuShares,
        this.cpusetCpus,
        this.cpusetMems,
        this.cpuQuota,
        this.cgroupParent,
        this.restartPolicy,
        this.logConfig,
        this.ipcMode,
        this.ulimits,
        this.pidMode,
        this.shmSize,
        this.oomKillDisable,
        this.oomScoreAdj,
        this.autoRemove,
        this.pidsLimit,
        this.tmpfs,
        this.readonlyRootfs,
        this.storageOpt,
        this.runtime,
        this.mounts,
        this.init,
        this.sysctls,
        this.deviceRequests));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link HostConfig#memoryReservation() memoryReservation} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for memoryReservation (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableHostConfig withMemoryReservation(@Nullable Long value) {
    if (Objects.equals(this.memoryReservation, value)) return this;
    return validate(new ImmutableHostConfig(
        this.binds,
        this.blkioWeight,
        this.blkioWeightDevice,
        this.blkioDeviceReadBps,
        this.blkioDeviceWriteBps,
        this.blkioDeviceReadIOps,
        this.blkioDeviceWriteIOps,
        this.containerIdFile,
        this.lxcConf,
        this.privileged,
        this.portBindings,
        this.links,
        this.publishAllPorts,
        this.dns,
        this.dnsOptions,
        this.dnsSearch,
        this.extraHosts,
        this.groupAdd,
        this.volumesFrom,
        this.capAdd,
        this.capDrop,
        this.networkMode,
        this.securityOpt,
        this.devices,
        this.memory,
        this.memorySwap,
        this.kernelMemory,
        this.memorySwappiness,
        value,
        this.nanoCpus,
        this.cpuPeriod,
        this.cpuShares,
        this.cpusetCpus,
        this.cpusetMems,
        this.cpuQuota,
        this.cgroupParent,
        this.restartPolicy,
        this.logConfig,
        this.ipcMode,
        this.ulimits,
        this.pidMode,
        this.shmSize,
        this.oomKillDisable,
        this.oomScoreAdj,
        this.autoRemove,
        this.pidsLimit,
        this.tmpfs,
        this.readonlyRootfs,
        this.storageOpt,
        this.runtime,
        this.mounts,
        this.init,
        this.sysctls,
        this.deviceRequests));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link HostConfig#nanoCpus() nanoCpus} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for nanoCpus (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableHostConfig withNanoCpus(@Nullable Long value) {
    if (Objects.equals(this.nanoCpus, value)) return this;
    return validate(new ImmutableHostConfig(
        this.binds,
        this.blkioWeight,
        this.blkioWeightDevice,
        this.blkioDeviceReadBps,
        this.blkioDeviceWriteBps,
        this.blkioDeviceReadIOps,
        this.blkioDeviceWriteIOps,
        this.containerIdFile,
        this.lxcConf,
        this.privileged,
        this.portBindings,
        this.links,
        this.publishAllPorts,
        this.dns,
        this.dnsOptions,
        this.dnsSearch,
        this.extraHosts,
        this.groupAdd,
        this.volumesFrom,
        this.capAdd,
        this.capDrop,
        this.networkMode,
        this.securityOpt,
        this.devices,
        this.memory,
        this.memorySwap,
        this.kernelMemory,
        this.memorySwappiness,
        this.memoryReservation,
        value,
        this.cpuPeriod,
        this.cpuShares,
        this.cpusetCpus,
        this.cpusetMems,
        this.cpuQuota,
        this.cgroupParent,
        this.restartPolicy,
        this.logConfig,
        this.ipcMode,
        this.ulimits,
        this.pidMode,
        this.shmSize,
        this.oomKillDisable,
        this.oomScoreAdj,
        this.autoRemove,
        this.pidsLimit,
        this.tmpfs,
        this.readonlyRootfs,
        this.storageOpt,
        this.runtime,
        this.mounts,
        this.init,
        this.sysctls,
        this.deviceRequests));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link HostConfig#cpuPeriod() cpuPeriod} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for cpuPeriod (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableHostConfig withCpuPeriod(@Nullable Long value) {
    if (Objects.equals(this.cpuPeriod, value)) return this;
    return validate(new ImmutableHostConfig(
        this.binds,
        this.blkioWeight,
        this.blkioWeightDevice,
        this.blkioDeviceReadBps,
        this.blkioDeviceWriteBps,
        this.blkioDeviceReadIOps,
        this.blkioDeviceWriteIOps,
        this.containerIdFile,
        this.lxcConf,
        this.privileged,
        this.portBindings,
        this.links,
        this.publishAllPorts,
        this.dns,
        this.dnsOptions,
        this.dnsSearch,
        this.extraHosts,
        this.groupAdd,
        this.volumesFrom,
        this.capAdd,
        this.capDrop,
        this.networkMode,
        this.securityOpt,
        this.devices,
        this.memory,
        this.memorySwap,
        this.kernelMemory,
        this.memorySwappiness,
        this.memoryReservation,
        this.nanoCpus,
        value,
        this.cpuShares,
        this.cpusetCpus,
        this.cpusetMems,
        this.cpuQuota,
        this.cgroupParent,
        this.restartPolicy,
        this.logConfig,
        this.ipcMode,
        this.ulimits,
        this.pidMode,
        this.shmSize,
        this.oomKillDisable,
        this.oomScoreAdj,
        this.autoRemove,
        this.pidsLimit,
        this.tmpfs,
        this.readonlyRootfs,
        this.storageOpt,
        this.runtime,
        this.mounts,
        this.init,
        this.sysctls,
        this.deviceRequests));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link HostConfig#cpuShares() cpuShares} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for cpuShares (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableHostConfig withCpuShares(@Nullable Long value) {
    if (Objects.equals(this.cpuShares, value)) return this;
    return validate(new ImmutableHostConfig(
        this.binds,
        this.blkioWeight,
        this.blkioWeightDevice,
        this.blkioDeviceReadBps,
        this.blkioDeviceWriteBps,
        this.blkioDeviceReadIOps,
        this.blkioDeviceWriteIOps,
        this.containerIdFile,
        this.lxcConf,
        this.privileged,
        this.portBindings,
        this.links,
        this.publishAllPorts,
        this.dns,
        this.dnsOptions,
        this.dnsSearch,
        this.extraHosts,
        this.groupAdd,
        this.volumesFrom,
        this.capAdd,
        this.capDrop,
        this.networkMode,
        this.securityOpt,
        this.devices,
        this.memory,
        this.memorySwap,
        this.kernelMemory,
        this.memorySwappiness,
        this.memoryReservation,
        this.nanoCpus,
        this.cpuPeriod,
        value,
        this.cpusetCpus,
        this.cpusetMems,
        this.cpuQuota,
        this.cgroupParent,
        this.restartPolicy,
        this.logConfig,
        this.ipcMode,
        this.ulimits,
        this.pidMode,
        this.shmSize,
        this.oomKillDisable,
        this.oomScoreAdj,
        this.autoRemove,
        this.pidsLimit,
        this.tmpfs,
        this.readonlyRootfs,
        this.storageOpt,
        this.runtime,
        this.mounts,
        this.init,
        this.sysctls,
        this.deviceRequests));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link HostConfig#cpusetCpus() cpusetCpus} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for cpusetCpus (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableHostConfig withCpusetCpus(@Nullable String value) {
    if (Objects.equals(this.cpusetCpus, value)) return this;
    return validate(new ImmutableHostConfig(
        this.binds,
        this.blkioWeight,
        this.blkioWeightDevice,
        this.blkioDeviceReadBps,
        this.blkioDeviceWriteBps,
        this.blkioDeviceReadIOps,
        this.blkioDeviceWriteIOps,
        this.containerIdFile,
        this.lxcConf,
        this.privileged,
        this.portBindings,
        this.links,
        this.publishAllPorts,
        this.dns,
        this.dnsOptions,
        this.dnsSearch,
        this.extraHosts,
        this.groupAdd,
        this.volumesFrom,
        this.capAdd,
        this.capDrop,
        this.networkMode,
        this.securityOpt,
        this.devices,
        this.memory,
        this.memorySwap,
        this.kernelMemory,
        this.memorySwappiness,
        this.memoryReservation,
        this.nanoCpus,
        this.cpuPeriod,
        this.cpuShares,
        value,
        this.cpusetMems,
        this.cpuQuota,
        this.cgroupParent,
        this.restartPolicy,
        this.logConfig,
        this.ipcMode,
        this.ulimits,
        this.pidMode,
        this.shmSize,
        this.oomKillDisable,
        this.oomScoreAdj,
        this.autoRemove,
        this.pidsLimit,
        this.tmpfs,
        this.readonlyRootfs,
        this.storageOpt,
        this.runtime,
        this.mounts,
        this.init,
        this.sysctls,
        this.deviceRequests));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link HostConfig#cpusetMems() cpusetMems} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for cpusetMems (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableHostConfig withCpusetMems(@Nullable String value) {
    if (Objects.equals(this.cpusetMems, value)) return this;
    return validate(new ImmutableHostConfig(
        this.binds,
        this.blkioWeight,
        this.blkioWeightDevice,
        this.blkioDeviceReadBps,
        this.blkioDeviceWriteBps,
        this.blkioDeviceReadIOps,
        this.blkioDeviceWriteIOps,
        this.containerIdFile,
        this.lxcConf,
        this.privileged,
        this.portBindings,
        this.links,
        this.publishAllPorts,
        this.dns,
        this.dnsOptions,
        this.dnsSearch,
        this.extraHosts,
        this.groupAdd,
        this.volumesFrom,
        this.capAdd,
        this.capDrop,
        this.networkMode,
        this.securityOpt,
        this.devices,
        this.memory,
        this.memorySwap,
        this.kernelMemory,
        this.memorySwappiness,
        this.memoryReservation,
        this.nanoCpus,
        this.cpuPeriod,
        this.cpuShares,
        this.cpusetCpus,
        value,
        this.cpuQuota,
        this.cgroupParent,
        this.restartPolicy,
        this.logConfig,
        this.ipcMode,
        this.ulimits,
        this.pidMode,
        this.shmSize,
        this.oomKillDisable,
        this.oomScoreAdj,
        this.autoRemove,
        this.pidsLimit,
        this.tmpfs,
        this.readonlyRootfs,
        this.storageOpt,
        this.runtime,
        this.mounts,
        this.init,
        this.sysctls,
        this.deviceRequests));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link HostConfig#cpuQuota() cpuQuota} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for cpuQuota (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableHostConfig withCpuQuota(@Nullable Long value) {
    if (Objects.equals(this.cpuQuota, value)) return this;
    return validate(new ImmutableHostConfig(
        this.binds,
        this.blkioWeight,
        this.blkioWeightDevice,
        this.blkioDeviceReadBps,
        this.blkioDeviceWriteBps,
        this.blkioDeviceReadIOps,
        this.blkioDeviceWriteIOps,
        this.containerIdFile,
        this.lxcConf,
        this.privileged,
        this.portBindings,
        this.links,
        this.publishAllPorts,
        this.dns,
        this.dnsOptions,
        this.dnsSearch,
        this.extraHosts,
        this.groupAdd,
        this.volumesFrom,
        this.capAdd,
        this.capDrop,
        this.networkMode,
        this.securityOpt,
        this.devices,
        this.memory,
        this.memorySwap,
        this.kernelMemory,
        this.memorySwappiness,
        this.memoryReservation,
        this.nanoCpus,
        this.cpuPeriod,
        this.cpuShares,
        this.cpusetCpus,
        this.cpusetMems,
        value,
        this.cgroupParent,
        this.restartPolicy,
        this.logConfig,
        this.ipcMode,
        this.ulimits,
        this.pidMode,
        this.shmSize,
        this.oomKillDisable,
        this.oomScoreAdj,
        this.autoRemove,
        this.pidsLimit,
        this.tmpfs,
        this.readonlyRootfs,
        this.storageOpt,
        this.runtime,
        this.mounts,
        this.init,
        this.sysctls,
        this.deviceRequests));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link HostConfig#cgroupParent() cgroupParent} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for cgroupParent (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableHostConfig withCgroupParent(@Nullable String value) {
    if (Objects.equals(this.cgroupParent, value)) return this;
    return validate(new ImmutableHostConfig(
        this.binds,
        this.blkioWeight,
        this.blkioWeightDevice,
        this.blkioDeviceReadBps,
        this.blkioDeviceWriteBps,
        this.blkioDeviceReadIOps,
        this.blkioDeviceWriteIOps,
        this.containerIdFile,
        this.lxcConf,
        this.privileged,
        this.portBindings,
        this.links,
        this.publishAllPorts,
        this.dns,
        this.dnsOptions,
        this.dnsSearch,
        this.extraHosts,
        this.groupAdd,
        this.volumesFrom,
        this.capAdd,
        this.capDrop,
        this.networkMode,
        this.securityOpt,
        this.devices,
        this.memory,
        this.memorySwap,
        this.kernelMemory,
        this.memorySwappiness,
        this.memoryReservation,
        this.nanoCpus,
        this.cpuPeriod,
        this.cpuShares,
        this.cpusetCpus,
        this.cpusetMems,
        this.cpuQuota,
        value,
        this.restartPolicy,
        this.logConfig,
        this.ipcMode,
        this.ulimits,
        this.pidMode,
        this.shmSize,
        this.oomKillDisable,
        this.oomScoreAdj,
        this.autoRemove,
        this.pidsLimit,
        this.tmpfs,
        this.readonlyRootfs,
        this.storageOpt,
        this.runtime,
        this.mounts,
        this.init,
        this.sysctls,
        this.deviceRequests));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link HostConfig#restartPolicy() restartPolicy} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for restartPolicy (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableHostConfig withRestartPolicy(@Nullable HostConfig.RestartPolicy value) {
    if (this.restartPolicy == value) return this;
    return validate(new ImmutableHostConfig(
        this.binds,
        this.blkioWeight,
        this.blkioWeightDevice,
        this.blkioDeviceReadBps,
        this.blkioDeviceWriteBps,
        this.blkioDeviceReadIOps,
        this.blkioDeviceWriteIOps,
        this.containerIdFile,
        this.lxcConf,
        this.privileged,
        this.portBindings,
        this.links,
        this.publishAllPorts,
        this.dns,
        this.dnsOptions,
        this.dnsSearch,
        this.extraHosts,
        this.groupAdd,
        this.volumesFrom,
        this.capAdd,
        this.capDrop,
        this.networkMode,
        this.securityOpt,
        this.devices,
        this.memory,
        this.memorySwap,
        this.kernelMemory,
        this.memorySwappiness,
        this.memoryReservation,
        this.nanoCpus,
        this.cpuPeriod,
        this.cpuShares,
        this.cpusetCpus,
        this.cpusetMems,
        this.cpuQuota,
        this.cgroupParent,
        value,
        this.logConfig,
        this.ipcMode,
        this.ulimits,
        this.pidMode,
        this.shmSize,
        this.oomKillDisable,
        this.oomScoreAdj,
        this.autoRemove,
        this.pidsLimit,
        this.tmpfs,
        this.readonlyRootfs,
        this.storageOpt,
        this.runtime,
        this.mounts,
        this.init,
        this.sysctls,
        this.deviceRequests));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link HostConfig#logConfig() logConfig} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for logConfig (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableHostConfig withLogConfig(@Nullable LogConfig value) {
    if (this.logConfig == value) return this;
    return validate(new ImmutableHostConfig(
        this.binds,
        this.blkioWeight,
        this.blkioWeightDevice,
        this.blkioDeviceReadBps,
        this.blkioDeviceWriteBps,
        this.blkioDeviceReadIOps,
        this.blkioDeviceWriteIOps,
        this.containerIdFile,
        this.lxcConf,
        this.privileged,
        this.portBindings,
        this.links,
        this.publishAllPorts,
        this.dns,
        this.dnsOptions,
        this.dnsSearch,
        this.extraHosts,
        this.groupAdd,
        this.volumesFrom,
        this.capAdd,
        this.capDrop,
        this.networkMode,
        this.securityOpt,
        this.devices,
        this.memory,
        this.memorySwap,
        this.kernelMemory,
        this.memorySwappiness,
        this.memoryReservation,
        this.nanoCpus,
        this.cpuPeriod,
        this.cpuShares,
        this.cpusetCpus,
        this.cpusetMems,
        this.cpuQuota,
        this.cgroupParent,
        this.restartPolicy,
        value,
        this.ipcMode,
        this.ulimits,
        this.pidMode,
        this.shmSize,
        this.oomKillDisable,
        this.oomScoreAdj,
        this.autoRemove,
        this.pidsLimit,
        this.tmpfs,
        this.readonlyRootfs,
        this.storageOpt,
        this.runtime,
        this.mounts,
        this.init,
        this.sysctls,
        this.deviceRequests));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link HostConfig#ipcMode() ipcMode} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for ipcMode (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableHostConfig withIpcMode(@Nullable String value) {
    if (Objects.equals(this.ipcMode, value)) return this;
    return validate(new ImmutableHostConfig(
        this.binds,
        this.blkioWeight,
        this.blkioWeightDevice,
        this.blkioDeviceReadBps,
        this.blkioDeviceWriteBps,
        this.blkioDeviceReadIOps,
        this.blkioDeviceWriteIOps,
        this.containerIdFile,
        this.lxcConf,
        this.privileged,
        this.portBindings,
        this.links,
        this.publishAllPorts,
        this.dns,
        this.dnsOptions,
        this.dnsSearch,
        this.extraHosts,
        this.groupAdd,
        this.volumesFrom,
        this.capAdd,
        this.capDrop,
        this.networkMode,
        this.securityOpt,
        this.devices,
        this.memory,
        this.memorySwap,
        this.kernelMemory,
        this.memorySwappiness,
        this.memoryReservation,
        this.nanoCpus,
        this.cpuPeriod,
        this.cpuShares,
        this.cpusetCpus,
        this.cpusetMems,
        this.cpuQuota,
        this.cgroupParent,
        this.restartPolicy,
        this.logConfig,
        value,
        this.ulimits,
        this.pidMode,
        this.shmSize,
        this.oomKillDisable,
        this.oomScoreAdj,
        this.autoRemove,
        this.pidsLimit,
        this.tmpfs,
        this.readonlyRootfs,
        this.storageOpt,
        this.runtime,
        this.mounts,
        this.init,
        this.sysctls,
        this.deviceRequests));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link HostConfig#ulimits() ulimits}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableHostConfig withUlimits(@Nullable HostConfig.Ulimit... elements) {
    if (elements == null) {
      return validate(new ImmutableHostConfig(
          this.binds,
          this.blkioWeight,
          this.blkioWeightDevice,
          this.blkioDeviceReadBps,
          this.blkioDeviceWriteBps,
          this.blkioDeviceReadIOps,
          this.blkioDeviceWriteIOps,
          this.containerIdFile,
          this.lxcConf,
          this.privileged,
          this.portBindings,
          this.links,
          this.publishAllPorts,
          this.dns,
          this.dnsOptions,
          this.dnsSearch,
          this.extraHosts,
          this.groupAdd,
          this.volumesFrom,
          this.capAdd,
          this.capDrop,
          this.networkMode,
          this.securityOpt,
          this.devices,
          this.memory,
          this.memorySwap,
          this.kernelMemory,
          this.memorySwappiness,
          this.memoryReservation,
          this.nanoCpus,
          this.cpuPeriod,
          this.cpuShares,
          this.cpusetCpus,
          this.cpusetMems,
          this.cpuQuota,
          this.cgroupParent,
          this.restartPolicy,
          this.logConfig,
          this.ipcMode,
          null,
          this.pidMode,
          this.shmSize,
          this.oomKillDisable,
          this.oomScoreAdj,
          this.autoRemove,
          this.pidsLimit,
          this.tmpfs,
          this.readonlyRootfs,
          this.storageOpt,
          this.runtime,
          this.mounts,
          this.init,
          this.sysctls,
          this.deviceRequests));
    }
    @Nullable List<HostConfig.Ulimit> newValue = Arrays.asList(elements) == null ? null : createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return validate(new ImmutableHostConfig(
        this.binds,
        this.blkioWeight,
        this.blkioWeightDevice,
        this.blkioDeviceReadBps,
        this.blkioDeviceWriteBps,
        this.blkioDeviceReadIOps,
        this.blkioDeviceWriteIOps,
        this.containerIdFile,
        this.lxcConf,
        this.privileged,
        this.portBindings,
        this.links,
        this.publishAllPorts,
        this.dns,
        this.dnsOptions,
        this.dnsSearch,
        this.extraHosts,
        this.groupAdd,
        this.volumesFrom,
        this.capAdd,
        this.capDrop,
        this.networkMode,
        this.securityOpt,
        this.devices,
        this.memory,
        this.memorySwap,
        this.kernelMemory,
        this.memorySwappiness,
        this.memoryReservation,
        this.nanoCpus,
        this.cpuPeriod,
        this.cpuShares,
        this.cpusetCpus,
        this.cpusetMems,
        this.cpuQuota,
        this.cgroupParent,
        this.restartPolicy,
        this.logConfig,
        this.ipcMode,
        newValue,
        this.pidMode,
        this.shmSize,
        this.oomKillDisable,
        this.oomScoreAdj,
        this.autoRemove,
        this.pidsLimit,
        this.tmpfs,
        this.readonlyRootfs,
        this.storageOpt,
        this.runtime,
        this.mounts,
        this.init,
        this.sysctls,
        this.deviceRequests));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link HostConfig#ulimits() ulimits}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of ulimits elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableHostConfig withUlimits(@Nullable Iterable<? extends HostConfig.Ulimit> elements) {
    if (this.ulimits == elements) return this;
    @Nullable List<HostConfig.Ulimit> newValue = elements == null ? null : createUnmodifiableList(false, createSafeList(elements, true, false));
    return validate(new ImmutableHostConfig(
        this.binds,
        this.blkioWeight,
        this.blkioWeightDevice,
        this.blkioDeviceReadBps,
        this.blkioDeviceWriteBps,
        this.blkioDeviceReadIOps,
        this.blkioDeviceWriteIOps,
        this.containerIdFile,
        this.lxcConf,
        this.privileged,
        this.portBindings,
        this.links,
        this.publishAllPorts,
        this.dns,
        this.dnsOptions,
        this.dnsSearch,
        this.extraHosts,
        this.groupAdd,
        this.volumesFrom,
        this.capAdd,
        this.capDrop,
        this.networkMode,
        this.securityOpt,
        this.devices,
        this.memory,
        this.memorySwap,
        this.kernelMemory,
        this.memorySwappiness,
        this.memoryReservation,
        this.nanoCpus,
        this.cpuPeriod,
        this.cpuShares,
        this.cpusetCpus,
        this.cpusetMems,
        this.cpuQuota,
        this.cgroupParent,
        this.restartPolicy,
        this.logConfig,
        this.ipcMode,
        newValue,
        this.pidMode,
        this.shmSize,
        this.oomKillDisable,
        this.oomScoreAdj,
        this.autoRemove,
        this.pidsLimit,
        this.tmpfs,
        this.readonlyRootfs,
        this.storageOpt,
        this.runtime,
        this.mounts,
        this.init,
        this.sysctls,
        this.deviceRequests));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link HostConfig#pidMode() pidMode} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for pidMode (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableHostConfig withPidMode(@Nullable String value) {
    if (Objects.equals(this.pidMode, value)) return this;
    return validate(new ImmutableHostConfig(
        this.binds,
        this.blkioWeight,
        this.blkioWeightDevice,
        this.blkioDeviceReadBps,
        this.blkioDeviceWriteBps,
        this.blkioDeviceReadIOps,
        this.blkioDeviceWriteIOps,
        this.containerIdFile,
        this.lxcConf,
        this.privileged,
        this.portBindings,
        this.links,
        this.publishAllPorts,
        this.dns,
        this.dnsOptions,
        this.dnsSearch,
        this.extraHosts,
        this.groupAdd,
        this.volumesFrom,
        this.capAdd,
        this.capDrop,
        this.networkMode,
        this.securityOpt,
        this.devices,
        this.memory,
        this.memorySwap,
        this.kernelMemory,
        this.memorySwappiness,
        this.memoryReservation,
        this.nanoCpus,
        this.cpuPeriod,
        this.cpuShares,
        this.cpusetCpus,
        this.cpusetMems,
        this.cpuQuota,
        this.cgroupParent,
        this.restartPolicy,
        this.logConfig,
        this.ipcMode,
        this.ulimits,
        value,
        this.shmSize,
        this.oomKillDisable,
        this.oomScoreAdj,
        this.autoRemove,
        this.pidsLimit,
        this.tmpfs,
        this.readonlyRootfs,
        this.storageOpt,
        this.runtime,
        this.mounts,
        this.init,
        this.sysctls,
        this.deviceRequests));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link HostConfig#shmSize() shmSize} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for shmSize (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableHostConfig withShmSize(@Nullable Long value) {
    if (Objects.equals(this.shmSize, value)) return this;
    return validate(new ImmutableHostConfig(
        this.binds,
        this.blkioWeight,
        this.blkioWeightDevice,
        this.blkioDeviceReadBps,
        this.blkioDeviceWriteBps,
        this.blkioDeviceReadIOps,
        this.blkioDeviceWriteIOps,
        this.containerIdFile,
        this.lxcConf,
        this.privileged,
        this.portBindings,
        this.links,
        this.publishAllPorts,
        this.dns,
        this.dnsOptions,
        this.dnsSearch,
        this.extraHosts,
        this.groupAdd,
        this.volumesFrom,
        this.capAdd,
        this.capDrop,
        this.networkMode,
        this.securityOpt,
        this.devices,
        this.memory,
        this.memorySwap,
        this.kernelMemory,
        this.memorySwappiness,
        this.memoryReservation,
        this.nanoCpus,
        this.cpuPeriod,
        this.cpuShares,
        this.cpusetCpus,
        this.cpusetMems,
        this.cpuQuota,
        this.cgroupParent,
        this.restartPolicy,
        this.logConfig,
        this.ipcMode,
        this.ulimits,
        this.pidMode,
        value,
        this.oomKillDisable,
        this.oomScoreAdj,
        this.autoRemove,
        this.pidsLimit,
        this.tmpfs,
        this.readonlyRootfs,
        this.storageOpt,
        this.runtime,
        this.mounts,
        this.init,
        this.sysctls,
        this.deviceRequests));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link HostConfig#oomKillDisable() oomKillDisable} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for oomKillDisable (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableHostConfig withOomKillDisable(@Nullable Boolean value) {
    if (Objects.equals(this.oomKillDisable, value)) return this;
    return validate(new ImmutableHostConfig(
        this.binds,
        this.blkioWeight,
        this.blkioWeightDevice,
        this.blkioDeviceReadBps,
        this.blkioDeviceWriteBps,
        this.blkioDeviceReadIOps,
        this.blkioDeviceWriteIOps,
        this.containerIdFile,
        this.lxcConf,
        this.privileged,
        this.portBindings,
        this.links,
        this.publishAllPorts,
        this.dns,
        this.dnsOptions,
        this.dnsSearch,
        this.extraHosts,
        this.groupAdd,
        this.volumesFrom,
        this.capAdd,
        this.capDrop,
        this.networkMode,
        this.securityOpt,
        this.devices,
        this.memory,
        this.memorySwap,
        this.kernelMemory,
        this.memorySwappiness,
        this.memoryReservation,
        this.nanoCpus,
        this.cpuPeriod,
        this.cpuShares,
        this.cpusetCpus,
        this.cpusetMems,
        this.cpuQuota,
        this.cgroupParent,
        this.restartPolicy,
        this.logConfig,
        this.ipcMode,
        this.ulimits,
        this.pidMode,
        this.shmSize,
        value,
        this.oomScoreAdj,
        this.autoRemove,
        this.pidsLimit,
        this.tmpfs,
        this.readonlyRootfs,
        this.storageOpt,
        this.runtime,
        this.mounts,
        this.init,
        this.sysctls,
        this.deviceRequests));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link HostConfig#oomScoreAdj() oomScoreAdj} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for oomScoreAdj (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableHostConfig withOomScoreAdj(@Nullable Integer value) {
    if (Objects.equals(this.oomScoreAdj, value)) return this;
    return validate(new ImmutableHostConfig(
        this.binds,
        this.blkioWeight,
        this.blkioWeightDevice,
        this.blkioDeviceReadBps,
        this.blkioDeviceWriteBps,
        this.blkioDeviceReadIOps,
        this.blkioDeviceWriteIOps,
        this.containerIdFile,
        this.lxcConf,
        this.privileged,
        this.portBindings,
        this.links,
        this.publishAllPorts,
        this.dns,
        this.dnsOptions,
        this.dnsSearch,
        this.extraHosts,
        this.groupAdd,
        this.volumesFrom,
        this.capAdd,
        this.capDrop,
        this.networkMode,
        this.securityOpt,
        this.devices,
        this.memory,
        this.memorySwap,
        this.kernelMemory,
        this.memorySwappiness,
        this.memoryReservation,
        this.nanoCpus,
        this.cpuPeriod,
        this.cpuShares,
        this.cpusetCpus,
        this.cpusetMems,
        this.cpuQuota,
        this.cgroupParent,
        this.restartPolicy,
        this.logConfig,
        this.ipcMode,
        this.ulimits,
        this.pidMode,
        this.shmSize,
        this.oomKillDisable,
        value,
        this.autoRemove,
        this.pidsLimit,
        this.tmpfs,
        this.readonlyRootfs,
        this.storageOpt,
        this.runtime,
        this.mounts,
        this.init,
        this.sysctls,
        this.deviceRequests));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link HostConfig#autoRemove() autoRemove} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for autoRemove (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableHostConfig withAutoRemove(@Nullable Boolean value) {
    if (Objects.equals(this.autoRemove, value)) return this;
    return validate(new ImmutableHostConfig(
        this.binds,
        this.blkioWeight,
        this.blkioWeightDevice,
        this.blkioDeviceReadBps,
        this.blkioDeviceWriteBps,
        this.blkioDeviceReadIOps,
        this.blkioDeviceWriteIOps,
        this.containerIdFile,
        this.lxcConf,
        this.privileged,
        this.portBindings,
        this.links,
        this.publishAllPorts,
        this.dns,
        this.dnsOptions,
        this.dnsSearch,
        this.extraHosts,
        this.groupAdd,
        this.volumesFrom,
        this.capAdd,
        this.capDrop,
        this.networkMode,
        this.securityOpt,
        this.devices,
        this.memory,
        this.memorySwap,
        this.kernelMemory,
        this.memorySwappiness,
        this.memoryReservation,
        this.nanoCpus,
        this.cpuPeriod,
        this.cpuShares,
        this.cpusetCpus,
        this.cpusetMems,
        this.cpuQuota,
        this.cgroupParent,
        this.restartPolicy,
        this.logConfig,
        this.ipcMode,
        this.ulimits,
        this.pidMode,
        this.shmSize,
        this.oomKillDisable,
        this.oomScoreAdj,
        value,
        this.pidsLimit,
        this.tmpfs,
        this.readonlyRootfs,
        this.storageOpt,
        this.runtime,
        this.mounts,
        this.init,
        this.sysctls,
        this.deviceRequests));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link HostConfig#pidsLimit() pidsLimit} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for pidsLimit (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableHostConfig withPidsLimit(@Nullable Integer value) {
    if (Objects.equals(this.pidsLimit, value)) return this;
    return validate(new ImmutableHostConfig(
        this.binds,
        this.blkioWeight,
        this.blkioWeightDevice,
        this.blkioDeviceReadBps,
        this.blkioDeviceWriteBps,
        this.blkioDeviceReadIOps,
        this.blkioDeviceWriteIOps,
        this.containerIdFile,
        this.lxcConf,
        this.privileged,
        this.portBindings,
        this.links,
        this.publishAllPorts,
        this.dns,
        this.dnsOptions,
        this.dnsSearch,
        this.extraHosts,
        this.groupAdd,
        this.volumesFrom,
        this.capAdd,
        this.capDrop,
        this.networkMode,
        this.securityOpt,
        this.devices,
        this.memory,
        this.memorySwap,
        this.kernelMemory,
        this.memorySwappiness,
        this.memoryReservation,
        this.nanoCpus,
        this.cpuPeriod,
        this.cpuShares,
        this.cpusetCpus,
        this.cpusetMems,
        this.cpuQuota,
        this.cgroupParent,
        this.restartPolicy,
        this.logConfig,
        this.ipcMode,
        this.ulimits,
        this.pidMode,
        this.shmSize,
        this.oomKillDisable,
        this.oomScoreAdj,
        this.autoRemove,
        value,
        this.tmpfs,
        this.readonlyRootfs,
        this.storageOpt,
        this.runtime,
        this.mounts,
        this.init,
        this.sysctls,
        this.deviceRequests));
  }

  /**
   * Copy the current immutable object by replacing the {@link HostConfig#tmpfs() tmpfs} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the tmpfs map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableHostConfig withTmpfs(@Nullable Map<String, ? extends String> entries) {
    if (this.tmpfs == entries) return this;
    @Nullable Map<String, String> newValue = entries == null ? null : createUnmodifiableMap(true, false, entries);
    return validate(new ImmutableHostConfig(
        this.binds,
        this.blkioWeight,
        this.blkioWeightDevice,
        this.blkioDeviceReadBps,
        this.blkioDeviceWriteBps,
        this.blkioDeviceReadIOps,
        this.blkioDeviceWriteIOps,
        this.containerIdFile,
        this.lxcConf,
        this.privileged,
        this.portBindings,
        this.links,
        this.publishAllPorts,
        this.dns,
        this.dnsOptions,
        this.dnsSearch,
        this.extraHosts,
        this.groupAdd,
        this.volumesFrom,
        this.capAdd,
        this.capDrop,
        this.networkMode,
        this.securityOpt,
        this.devices,
        this.memory,
        this.memorySwap,
        this.kernelMemory,
        this.memorySwappiness,
        this.memoryReservation,
        this.nanoCpus,
        this.cpuPeriod,
        this.cpuShares,
        this.cpusetCpus,
        this.cpusetMems,
        this.cpuQuota,
        this.cgroupParent,
        this.restartPolicy,
        this.logConfig,
        this.ipcMode,
        this.ulimits,
        this.pidMode,
        this.shmSize,
        this.oomKillDisable,
        this.oomScoreAdj,
        this.autoRemove,
        this.pidsLimit,
        newValue,
        this.readonlyRootfs,
        this.storageOpt,
        this.runtime,
        this.mounts,
        this.init,
        this.sysctls,
        this.deviceRequests));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link HostConfig#readonlyRootfs() readonlyRootfs} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for readonlyRootfs (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableHostConfig withReadonlyRootfs(@Nullable Boolean value) {
    if (Objects.equals(this.readonlyRootfs, value)) return this;
    return validate(new ImmutableHostConfig(
        this.binds,
        this.blkioWeight,
        this.blkioWeightDevice,
        this.blkioDeviceReadBps,
        this.blkioDeviceWriteBps,
        this.blkioDeviceReadIOps,
        this.blkioDeviceWriteIOps,
        this.containerIdFile,
        this.lxcConf,
        this.privileged,
        this.portBindings,
        this.links,
        this.publishAllPorts,
        this.dns,
        this.dnsOptions,
        this.dnsSearch,
        this.extraHosts,
        this.groupAdd,
        this.volumesFrom,
        this.capAdd,
        this.capDrop,
        this.networkMode,
        this.securityOpt,
        this.devices,
        this.memory,
        this.memorySwap,
        this.kernelMemory,
        this.memorySwappiness,
        this.memoryReservation,
        this.nanoCpus,
        this.cpuPeriod,
        this.cpuShares,
        this.cpusetCpus,
        this.cpusetMems,
        this.cpuQuota,
        this.cgroupParent,
        this.restartPolicy,
        this.logConfig,
        this.ipcMode,
        this.ulimits,
        this.pidMode,
        this.shmSize,
        this.oomKillDisable,
        this.oomScoreAdj,
        this.autoRemove,
        this.pidsLimit,
        this.tmpfs,
        value,
        this.storageOpt,
        this.runtime,
        this.mounts,
        this.init,
        this.sysctls,
        this.deviceRequests));
  }

  /**
   * Copy the current immutable object by replacing the {@link HostConfig#storageOpt() storageOpt} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the storageOpt map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableHostConfig withStorageOpt(@Nullable Map<String, ? extends String> entries) {
    if (this.storageOpt == entries) return this;
    @Nullable Map<String, String> newValue = entries == null ? null : createUnmodifiableMap(true, false, entries);
    return validate(new ImmutableHostConfig(
        this.binds,
        this.blkioWeight,
        this.blkioWeightDevice,
        this.blkioDeviceReadBps,
        this.blkioDeviceWriteBps,
        this.blkioDeviceReadIOps,
        this.blkioDeviceWriteIOps,
        this.containerIdFile,
        this.lxcConf,
        this.privileged,
        this.portBindings,
        this.links,
        this.publishAllPorts,
        this.dns,
        this.dnsOptions,
        this.dnsSearch,
        this.extraHosts,
        this.groupAdd,
        this.volumesFrom,
        this.capAdd,
        this.capDrop,
        this.networkMode,
        this.securityOpt,
        this.devices,
        this.memory,
        this.memorySwap,
        this.kernelMemory,
        this.memorySwappiness,
        this.memoryReservation,
        this.nanoCpus,
        this.cpuPeriod,
        this.cpuShares,
        this.cpusetCpus,
        this.cpusetMems,
        this.cpuQuota,
        this.cgroupParent,
        this.restartPolicy,
        this.logConfig,
        this.ipcMode,
        this.ulimits,
        this.pidMode,
        this.shmSize,
        this.oomKillDisable,
        this.oomScoreAdj,
        this.autoRemove,
        this.pidsLimit,
        this.tmpfs,
        this.readonlyRootfs,
        newValue,
        this.runtime,
        this.mounts,
        this.init,
        this.sysctls,
        this.deviceRequests));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link HostConfig#runtime() runtime} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for runtime (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableHostConfig withRuntime(@Nullable String value) {
    if (Objects.equals(this.runtime, value)) return this;
    return validate(new ImmutableHostConfig(
        this.binds,
        this.blkioWeight,
        this.blkioWeightDevice,
        this.blkioDeviceReadBps,
        this.blkioDeviceWriteBps,
        this.blkioDeviceReadIOps,
        this.blkioDeviceWriteIOps,
        this.containerIdFile,
        this.lxcConf,
        this.privileged,
        this.portBindings,
        this.links,
        this.publishAllPorts,
        this.dns,
        this.dnsOptions,
        this.dnsSearch,
        this.extraHosts,
        this.groupAdd,
        this.volumesFrom,
        this.capAdd,
        this.capDrop,
        this.networkMode,
        this.securityOpt,
        this.devices,
        this.memory,
        this.memorySwap,
        this.kernelMemory,
        this.memorySwappiness,
        this.memoryReservation,
        this.nanoCpus,
        this.cpuPeriod,
        this.cpuShares,
        this.cpusetCpus,
        this.cpusetMems,
        this.cpuQuota,
        this.cgroupParent,
        this.restartPolicy,
        this.logConfig,
        this.ipcMode,
        this.ulimits,
        this.pidMode,
        this.shmSize,
        this.oomKillDisable,
        this.oomScoreAdj,
        this.autoRemove,
        this.pidsLimit,
        this.tmpfs,
        this.readonlyRootfs,
        this.storageOpt,
        value,
        this.mounts,
        this.init,
        this.sysctls,
        this.deviceRequests));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link HostConfig#mounts() mounts}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableHostConfig withMounts(@Nullable Mount... elements) {
    if (elements == null) {
      return validate(new ImmutableHostConfig(
          this.binds,
          this.blkioWeight,
          this.blkioWeightDevice,
          this.blkioDeviceReadBps,
          this.blkioDeviceWriteBps,
          this.blkioDeviceReadIOps,
          this.blkioDeviceWriteIOps,
          this.containerIdFile,
          this.lxcConf,
          this.privileged,
          this.portBindings,
          this.links,
          this.publishAllPorts,
          this.dns,
          this.dnsOptions,
          this.dnsSearch,
          this.extraHosts,
          this.groupAdd,
          this.volumesFrom,
          this.capAdd,
          this.capDrop,
          this.networkMode,
          this.securityOpt,
          this.devices,
          this.memory,
          this.memorySwap,
          this.kernelMemory,
          this.memorySwappiness,
          this.memoryReservation,
          this.nanoCpus,
          this.cpuPeriod,
          this.cpuShares,
          this.cpusetCpus,
          this.cpusetMems,
          this.cpuQuota,
          this.cgroupParent,
          this.restartPolicy,
          this.logConfig,
          this.ipcMode,
          this.ulimits,
          this.pidMode,
          this.shmSize,
          this.oomKillDisable,
          this.oomScoreAdj,
          this.autoRemove,
          this.pidsLimit,
          this.tmpfs,
          this.readonlyRootfs,
          this.storageOpt,
          this.runtime,
          null,
          this.init,
          this.sysctls,
          this.deviceRequests));
    }
    @Nullable List<Mount> newValue = Arrays.asList(elements) == null ? null : createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return validate(new ImmutableHostConfig(
        this.binds,
        this.blkioWeight,
        this.blkioWeightDevice,
        this.blkioDeviceReadBps,
        this.blkioDeviceWriteBps,
        this.blkioDeviceReadIOps,
        this.blkioDeviceWriteIOps,
        this.containerIdFile,
        this.lxcConf,
        this.privileged,
        this.portBindings,
        this.links,
        this.publishAllPorts,
        this.dns,
        this.dnsOptions,
        this.dnsSearch,
        this.extraHosts,
        this.groupAdd,
        this.volumesFrom,
        this.capAdd,
        this.capDrop,
        this.networkMode,
        this.securityOpt,
        this.devices,
        this.memory,
        this.memorySwap,
        this.kernelMemory,
        this.memorySwappiness,
        this.memoryReservation,
        this.nanoCpus,
        this.cpuPeriod,
        this.cpuShares,
        this.cpusetCpus,
        this.cpusetMems,
        this.cpuQuota,
        this.cgroupParent,
        this.restartPolicy,
        this.logConfig,
        this.ipcMode,
        this.ulimits,
        this.pidMode,
        this.shmSize,
        this.oomKillDisable,
        this.oomScoreAdj,
        this.autoRemove,
        this.pidsLimit,
        this.tmpfs,
        this.readonlyRootfs,
        this.storageOpt,
        this.runtime,
        newValue,
        this.init,
        this.sysctls,
        this.deviceRequests));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link HostConfig#mounts() mounts}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of mounts elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableHostConfig withMounts(@Nullable Iterable<? extends Mount> elements) {
    if (this.mounts == elements) return this;
    @Nullable List<Mount> newValue = elements == null ? null : createUnmodifiableList(false, createSafeList(elements, true, false));
    return validate(new ImmutableHostConfig(
        this.binds,
        this.blkioWeight,
        this.blkioWeightDevice,
        this.blkioDeviceReadBps,
        this.blkioDeviceWriteBps,
        this.blkioDeviceReadIOps,
        this.blkioDeviceWriteIOps,
        this.containerIdFile,
        this.lxcConf,
        this.privileged,
        this.portBindings,
        this.links,
        this.publishAllPorts,
        this.dns,
        this.dnsOptions,
        this.dnsSearch,
        this.extraHosts,
        this.groupAdd,
        this.volumesFrom,
        this.capAdd,
        this.capDrop,
        this.networkMode,
        this.securityOpt,
        this.devices,
        this.memory,
        this.memorySwap,
        this.kernelMemory,
        this.memorySwappiness,
        this.memoryReservation,
        this.nanoCpus,
        this.cpuPeriod,
        this.cpuShares,
        this.cpusetCpus,
        this.cpusetMems,
        this.cpuQuota,
        this.cgroupParent,
        this.restartPolicy,
        this.logConfig,
        this.ipcMode,
        this.ulimits,
        this.pidMode,
        this.shmSize,
        this.oomKillDisable,
        this.oomScoreAdj,
        this.autoRemove,
        this.pidsLimit,
        this.tmpfs,
        this.readonlyRootfs,
        this.storageOpt,
        this.runtime,
        newValue,
        this.init,
        this.sysctls,
        this.deviceRequests));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link HostConfig#init() init} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for init (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableHostConfig withInit(@Nullable Boolean value) {
    if (Objects.equals(this.init, value)) return this;
    return validate(new ImmutableHostConfig(
        this.binds,
        this.blkioWeight,
        this.blkioWeightDevice,
        this.blkioDeviceReadBps,
        this.blkioDeviceWriteBps,
        this.blkioDeviceReadIOps,
        this.blkioDeviceWriteIOps,
        this.containerIdFile,
        this.lxcConf,
        this.privileged,
        this.portBindings,
        this.links,
        this.publishAllPorts,
        this.dns,
        this.dnsOptions,
        this.dnsSearch,
        this.extraHosts,
        this.groupAdd,
        this.volumesFrom,
        this.capAdd,
        this.capDrop,
        this.networkMode,
        this.securityOpt,
        this.devices,
        this.memory,
        this.memorySwap,
        this.kernelMemory,
        this.memorySwappiness,
        this.memoryReservation,
        this.nanoCpus,
        this.cpuPeriod,
        this.cpuShares,
        this.cpusetCpus,
        this.cpusetMems,
        this.cpuQuota,
        this.cgroupParent,
        this.restartPolicy,
        this.logConfig,
        this.ipcMode,
        this.ulimits,
        this.pidMode,
        this.shmSize,
        this.oomKillDisable,
        this.oomScoreAdj,
        this.autoRemove,
        this.pidsLimit,
        this.tmpfs,
        this.readonlyRootfs,
        this.storageOpt,
        this.runtime,
        this.mounts,
        value,
        this.sysctls,
        this.deviceRequests));
  }

  /**
   * Copy the current immutable object by replacing the {@link HostConfig#sysctls() sysctls} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the sysctls map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableHostConfig withSysctls(Map<String, ? extends String> entries) {
    if (this.sysctls == entries) return this;
    Map<String, String> newValue = createUnmodifiableMap(true, false, entries);
    return validate(new ImmutableHostConfig(
        this.binds,
        this.blkioWeight,
        this.blkioWeightDevice,
        this.blkioDeviceReadBps,
        this.blkioDeviceWriteBps,
        this.blkioDeviceReadIOps,
        this.blkioDeviceWriteIOps,
        this.containerIdFile,
        this.lxcConf,
        this.privileged,
        this.portBindings,
        this.links,
        this.publishAllPorts,
        this.dns,
        this.dnsOptions,
        this.dnsSearch,
        this.extraHosts,
        this.groupAdd,
        this.volumesFrom,
        this.capAdd,
        this.capDrop,
        this.networkMode,
        this.securityOpt,
        this.devices,
        this.memory,
        this.memorySwap,
        this.kernelMemory,
        this.memorySwappiness,
        this.memoryReservation,
        this.nanoCpus,
        this.cpuPeriod,
        this.cpuShares,
        this.cpusetCpus,
        this.cpusetMems,
        this.cpuQuota,
        this.cgroupParent,
        this.restartPolicy,
        this.logConfig,
        this.ipcMode,
        this.ulimits,
        this.pidMode,
        this.shmSize,
        this.oomKillDisable,
        this.oomScoreAdj,
        this.autoRemove,
        this.pidsLimit,
        this.tmpfs,
        this.readonlyRootfs,
        this.storageOpt,
        this.runtime,
        this.mounts,
        this.init,
        newValue,
        this.deviceRequests));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link HostConfig#deviceRequests() deviceRequests}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableHostConfig withDeviceRequests(@Nullable HostConfig.DeviceRequest... elements) {
    if (elements == null) {
      return validate(new ImmutableHostConfig(
          this.binds,
          this.blkioWeight,
          this.blkioWeightDevice,
          this.blkioDeviceReadBps,
          this.blkioDeviceWriteBps,
          this.blkioDeviceReadIOps,
          this.blkioDeviceWriteIOps,
          this.containerIdFile,
          this.lxcConf,
          this.privileged,
          this.portBindings,
          this.links,
          this.publishAllPorts,
          this.dns,
          this.dnsOptions,
          this.dnsSearch,
          this.extraHosts,
          this.groupAdd,
          this.volumesFrom,
          this.capAdd,
          this.capDrop,
          this.networkMode,
          this.securityOpt,
          this.devices,
          this.memory,
          this.memorySwap,
          this.kernelMemory,
          this.memorySwappiness,
          this.memoryReservation,
          this.nanoCpus,
          this.cpuPeriod,
          this.cpuShares,
          this.cpusetCpus,
          this.cpusetMems,
          this.cpuQuota,
          this.cgroupParent,
          this.restartPolicy,
          this.logConfig,
          this.ipcMode,
          this.ulimits,
          this.pidMode,
          this.shmSize,
          this.oomKillDisable,
          this.oomScoreAdj,
          this.autoRemove,
          this.pidsLimit,
          this.tmpfs,
          this.readonlyRootfs,
          this.storageOpt,
          this.runtime,
          this.mounts,
          this.init,
          this.sysctls,
          null));
    }
    @Nullable List<HostConfig.DeviceRequest> newValue = Arrays.asList(elements) == null ? null : createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return validate(new ImmutableHostConfig(
        this.binds,
        this.blkioWeight,
        this.blkioWeightDevice,
        this.blkioDeviceReadBps,
        this.blkioDeviceWriteBps,
        this.blkioDeviceReadIOps,
        this.blkioDeviceWriteIOps,
        this.containerIdFile,
        this.lxcConf,
        this.privileged,
        this.portBindings,
        this.links,
        this.publishAllPorts,
        this.dns,
        this.dnsOptions,
        this.dnsSearch,
        this.extraHosts,
        this.groupAdd,
        this.volumesFrom,
        this.capAdd,
        this.capDrop,
        this.networkMode,
        this.securityOpt,
        this.devices,
        this.memory,
        this.memorySwap,
        this.kernelMemory,
        this.memorySwappiness,
        this.memoryReservation,
        this.nanoCpus,
        this.cpuPeriod,
        this.cpuShares,
        this.cpusetCpus,
        this.cpusetMems,
        this.cpuQuota,
        this.cgroupParent,
        this.restartPolicy,
        this.logConfig,
        this.ipcMode,
        this.ulimits,
        this.pidMode,
        this.shmSize,
        this.oomKillDisable,
        this.oomScoreAdj,
        this.autoRemove,
        this.pidsLimit,
        this.tmpfs,
        this.readonlyRootfs,
        this.storageOpt,
        this.runtime,
        this.mounts,
        this.init,
        this.sysctls,
        newValue));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link HostConfig#deviceRequests() deviceRequests}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of deviceRequests elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableHostConfig withDeviceRequests(@Nullable Iterable<? extends HostConfig.DeviceRequest> elements) {
    if (this.deviceRequests == elements) return this;
    @Nullable List<HostConfig.DeviceRequest> newValue = elements == null ? null : createUnmodifiableList(false, createSafeList(elements, true, false));
    return validate(new ImmutableHostConfig(
        this.binds,
        this.blkioWeight,
        this.blkioWeightDevice,
        this.blkioDeviceReadBps,
        this.blkioDeviceWriteBps,
        this.blkioDeviceReadIOps,
        this.blkioDeviceWriteIOps,
        this.containerIdFile,
        this.lxcConf,
        this.privileged,
        this.portBindings,
        this.links,
        this.publishAllPorts,
        this.dns,
        this.dnsOptions,
        this.dnsSearch,
        this.extraHosts,
        this.groupAdd,
        this.volumesFrom,
        this.capAdd,
        this.capDrop,
        this.networkMode,
        this.securityOpt,
        this.devices,
        this.memory,
        this.memorySwap,
        this.kernelMemory,
        this.memorySwappiness,
        this.memoryReservation,
        this.nanoCpus,
        this.cpuPeriod,
        this.cpuShares,
        this.cpusetCpus,
        this.cpusetMems,
        this.cpuQuota,
        this.cgroupParent,
        this.restartPolicy,
        this.logConfig,
        this.ipcMode,
        this.ulimits,
        this.pidMode,
        this.shmSize,
        this.oomKillDisable,
        this.oomScoreAdj,
        this.autoRemove,
        this.pidsLimit,
        this.tmpfs,
        this.readonlyRootfs,
        this.storageOpt,
        this.runtime,
        this.mounts,
        this.init,
        this.sysctls,
        newValue));
  }

  /**
   * This instance is equal to all instances of {@code ImmutableHostConfig} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableHostConfig
        && equalTo(0, (ImmutableHostConfig) another);
  }

  private boolean equalTo(int synthetic, ImmutableHostConfig another) {
    return Objects.equals(binds, another.binds)
        && Objects.equals(blkioWeight, another.blkioWeight)
        && Objects.equals(blkioWeightDevice, another.blkioWeightDevice)
        && Objects.equals(blkioDeviceReadBps, another.blkioDeviceReadBps)
        && Objects.equals(blkioDeviceWriteBps, another.blkioDeviceWriteBps)
        && Objects.equals(blkioDeviceReadIOps, another.blkioDeviceReadIOps)
        && Objects.equals(blkioDeviceWriteIOps, another.blkioDeviceWriteIOps)
        && Objects.equals(containerIdFile, another.containerIdFile)
        && Objects.equals(lxcConf, another.lxcConf)
        && Objects.equals(privileged, another.privileged)
        && Objects.equals(portBindings, another.portBindings)
        && Objects.equals(links, another.links)
        && Objects.equals(publishAllPorts, another.publishAllPorts)
        && Objects.equals(dns, another.dns)
        && Objects.equals(dnsOptions, another.dnsOptions)
        && Objects.equals(dnsSearch, another.dnsSearch)
        && Objects.equals(extraHosts, another.extraHosts)
        && Objects.equals(groupAdd, another.groupAdd)
        && Objects.equals(volumesFrom, another.volumesFrom)
        && Objects.equals(capAdd, another.capAdd)
        && Objects.equals(capDrop, another.capDrop)
        && Objects.equals(networkMode, another.networkMode)
        && Objects.equals(securityOpt, another.securityOpt)
        && Objects.equals(devices, another.devices)
        && Objects.equals(memory, another.memory)
        && Objects.equals(memorySwap, another.memorySwap)
        && Objects.equals(kernelMemory, another.kernelMemory)
        && Objects.equals(memorySwappiness, another.memorySwappiness)
        && Objects.equals(memoryReservation, another.memoryReservation)
        && Objects.equals(nanoCpus, another.nanoCpus)
        && Objects.equals(cpuPeriod, another.cpuPeriod)
        && Objects.equals(cpuShares, another.cpuShares)
        && Objects.equals(cpusetCpus, another.cpusetCpus)
        && Objects.equals(cpusetMems, another.cpusetMems)
        && Objects.equals(cpuQuota, another.cpuQuota)
        && Objects.equals(cgroupParent, another.cgroupParent)
        && Objects.equals(restartPolicy, another.restartPolicy)
        && Objects.equals(logConfig, another.logConfig)
        && Objects.equals(ipcMode, another.ipcMode)
        && Objects.equals(ulimits, another.ulimits)
        && Objects.equals(pidMode, another.pidMode)
        && Objects.equals(shmSize, another.shmSize)
        && Objects.equals(oomKillDisable, another.oomKillDisable)
        && Objects.equals(oomScoreAdj, another.oomScoreAdj)
        && Objects.equals(autoRemove, another.autoRemove)
        && Objects.equals(pidsLimit, another.pidsLimit)
        && Objects.equals(tmpfs, another.tmpfs)
        && Objects.equals(readonlyRootfs, another.readonlyRootfs)
        && Objects.equals(storageOpt, another.storageOpt)
        && Objects.equals(runtime, another.runtime)
        && Objects.equals(mounts, another.mounts)
        && Objects.equals(init, another.init)
        && sysctls.equals(another.sysctls)
        && Objects.equals(deviceRequests, another.deviceRequests);
  }

  /**
   * Computes a hash code from attributes: {@code binds}, {@code blkioWeight}, {@code blkioWeightDevice}, {@code blkioDeviceReadBps}, {@code blkioDeviceWriteBps}, {@code blkioDeviceReadIOps}, {@code blkioDeviceWriteIOps}, {@code containerIdFile}, {@code lxcConf}, {@code privileged}, {@code portBindings}, {@code links}, {@code publishAllPorts}, {@code dns}, {@code dnsOptions}, {@code dnsSearch}, {@code extraHosts}, {@code groupAdd}, {@code volumesFrom}, {@code capAdd}, {@code capDrop}, {@code networkMode}, {@code securityOpt}, {@code devices}, {@code memory}, {@code memorySwap}, {@code kernelMemory}, {@code memorySwappiness}, {@code memoryReservation}, {@code nanoCpus}, {@code cpuPeriod}, {@code cpuShares}, {@code cpusetCpus}, {@code cpusetMems}, {@code cpuQuota}, {@code cgroupParent}, {@code restartPolicy}, {@code logConfig}, {@code ipcMode}, {@code ulimits}, {@code pidMode}, {@code shmSize}, {@code oomKillDisable}, {@code oomScoreAdj}, {@code autoRemove}, {@code pidsLimit}, {@code tmpfs}, {@code readonlyRootfs}, {@code storageOpt}, {@code runtime}, {@code mounts}, {@code init}, {@code sysctls}, {@code deviceRequests}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(binds);
    h += (h << 5) + Objects.hashCode(blkioWeight);
    h += (h << 5) + Objects.hashCode(blkioWeightDevice);
    h += (h << 5) + Objects.hashCode(blkioDeviceReadBps);
    h += (h << 5) + Objects.hashCode(blkioDeviceWriteBps);
    h += (h << 5) + Objects.hashCode(blkioDeviceReadIOps);
    h += (h << 5) + Objects.hashCode(blkioDeviceWriteIOps);
    h += (h << 5) + Objects.hashCode(containerIdFile);
    h += (h << 5) + Objects.hashCode(lxcConf);
    h += (h << 5) + Objects.hashCode(privileged);
    h += (h << 5) + Objects.hashCode(portBindings);
    h += (h << 5) + Objects.hashCode(links);
    h += (h << 5) + Objects.hashCode(publishAllPorts);
    h += (h << 5) + Objects.hashCode(dns);
    h += (h << 5) + Objects.hashCode(dnsOptions);
    h += (h << 5) + Objects.hashCode(dnsSearch);
    h += (h << 5) + Objects.hashCode(extraHosts);
    h += (h << 5) + Objects.hashCode(groupAdd);
    h += (h << 5) + Objects.hashCode(volumesFrom);
    h += (h << 5) + Objects.hashCode(capAdd);
    h += (h << 5) + Objects.hashCode(capDrop);
    h += (h << 5) + Objects.hashCode(networkMode);
    h += (h << 5) + Objects.hashCode(securityOpt);
    h += (h << 5) + Objects.hashCode(devices);
    h += (h << 5) + Objects.hashCode(memory);
    h += (h << 5) + Objects.hashCode(memorySwap);
    h += (h << 5) + Objects.hashCode(kernelMemory);
    h += (h << 5) + Objects.hashCode(memorySwappiness);
    h += (h << 5) + Objects.hashCode(memoryReservation);
    h += (h << 5) + Objects.hashCode(nanoCpus);
    h += (h << 5) + Objects.hashCode(cpuPeriod);
    h += (h << 5) + Objects.hashCode(cpuShares);
    h += (h << 5) + Objects.hashCode(cpusetCpus);
    h += (h << 5) + Objects.hashCode(cpusetMems);
    h += (h << 5) + Objects.hashCode(cpuQuota);
    h += (h << 5) + Objects.hashCode(cgroupParent);
    h += (h << 5) + Objects.hashCode(restartPolicy);
    h += (h << 5) + Objects.hashCode(logConfig);
    h += (h << 5) + Objects.hashCode(ipcMode);
    h += (h << 5) + Objects.hashCode(ulimits);
    h += (h << 5) + Objects.hashCode(pidMode);
    h += (h << 5) + Objects.hashCode(shmSize);
    h += (h << 5) + Objects.hashCode(oomKillDisable);
    h += (h << 5) + Objects.hashCode(oomScoreAdj);
    h += (h << 5) + Objects.hashCode(autoRemove);
    h += (h << 5) + Objects.hashCode(pidsLimit);
    h += (h << 5) + Objects.hashCode(tmpfs);
    h += (h << 5) + Objects.hashCode(readonlyRootfs);
    h += (h << 5) + Objects.hashCode(storageOpt);
    h += (h << 5) + Objects.hashCode(runtime);
    h += (h << 5) + Objects.hashCode(mounts);
    h += (h << 5) + Objects.hashCode(init);
    h += (h << 5) + sysctls.hashCode();
    h += (h << 5) + Objects.hashCode(deviceRequests);
    return h;
  }

  /**
   * Prints the immutable value {@code HostConfig} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "HostConfig{"
        + "binds=" + binds
        + ", blkioWeight=" + blkioWeight
        + ", blkioWeightDevice=" + blkioWeightDevice
        + ", blkioDeviceReadBps=" + blkioDeviceReadBps
        + ", blkioDeviceWriteBps=" + blkioDeviceWriteBps
        + ", blkioDeviceReadIOps=" + blkioDeviceReadIOps
        + ", blkioDeviceWriteIOps=" + blkioDeviceWriteIOps
        + ", containerIdFile=" + containerIdFile
        + ", lxcConf=" + lxcConf
        + ", privileged=" + privileged
        + ", portBindings=" + portBindings
        + ", links=" + links
        + ", publishAllPorts=" + publishAllPorts
        + ", dns=" + dns
        + ", dnsOptions=" + dnsOptions
        + ", dnsSearch=" + dnsSearch
        + ", extraHosts=" + extraHosts
        + ", groupAdd=" + groupAdd
        + ", volumesFrom=" + volumesFrom
        + ", capAdd=" + capAdd
        + ", capDrop=" + capDrop
        + ", networkMode=" + networkMode
        + ", securityOpt=" + securityOpt
        + ", devices=" + devices
        + ", memory=" + memory
        + ", memorySwap=" + memorySwap
        + ", kernelMemory=" + kernelMemory
        + ", memorySwappiness=" + memorySwappiness
        + ", memoryReservation=" + memoryReservation
        + ", nanoCpus=" + nanoCpus
        + ", cpuPeriod=" + cpuPeriod
        + ", cpuShares=" + cpuShares
        + ", cpusetCpus=" + cpusetCpus
        + ", cpusetMems=" + cpusetMems
        + ", cpuQuota=" + cpuQuota
        + ", cgroupParent=" + cgroupParent
        + ", restartPolicy=" + restartPolicy
        + ", logConfig=" + logConfig
        + ", ipcMode=" + ipcMode
        + ", ulimits=" + ulimits
        + ", pidMode=" + pidMode
        + ", shmSize=" + shmSize
        + ", oomKillDisable=" + oomKillDisable
        + ", oomScoreAdj=" + oomScoreAdj
        + ", autoRemove=" + autoRemove
        + ", pidsLimit=" + pidsLimit
        + ", tmpfs=" + tmpfs
        + ", readonlyRootfs=" + readonlyRootfs
        + ", storageOpt=" + storageOpt
        + ", runtime=" + runtime
        + ", mounts=" + mounts
        + ", init=" + init
        + ", sysctls=" + sysctls
        + ", deviceRequests=" + deviceRequests
        + "}";
  }

  private static ImmutableHostConfig validate(ImmutableHostConfig instance) {
    instance.check();
    return instance;
  }

  /**
   * Creates an immutable copy of a {@link HostConfig} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable HostConfig instance
   */
  public static ImmutableHostConfig copyOf(HostConfig instance) {
    if (instance instanceof ImmutableHostConfig) {
      return (ImmutableHostConfig) instance;
    }
    return ImmutableHostConfig.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableHostConfig ImmutableHostConfig}.
   * <pre>
   * ImmutableHostConfig.builder()
   *    .binds(List&amp;lt;String&amp;gt; | null) // nullable {@link HostConfig#binds() binds}
   *    .blkioWeight(Integer | null) // nullable {@link HostConfig#blkioWeight() blkioWeight}
   *    .blkioWeightDevice(List&amp;lt;org.mandas.docker.client.messages.HostConfig.BlkioWeightDevice&amp;gt; | null) // nullable {@link HostConfig#blkioWeightDevice() blkioWeightDevice}
   *    .blkioDeviceReadBps(List&amp;lt;org.mandas.docker.client.messages.HostConfig.BlkioDeviceRate&amp;gt; | null) // nullable {@link HostConfig#blkioDeviceReadBps() blkioDeviceReadBps}
   *    .blkioDeviceWriteBps(List&amp;lt;org.mandas.docker.client.messages.HostConfig.BlkioDeviceRate&amp;gt; | null) // nullable {@link HostConfig#blkioDeviceWriteBps() blkioDeviceWriteBps}
   *    .blkioDeviceReadIOps(List&amp;lt;org.mandas.docker.client.messages.HostConfig.BlkioDeviceRate&amp;gt; | null) // nullable {@link HostConfig#blkioDeviceReadIOps() blkioDeviceReadIOps}
   *    .blkioDeviceWriteIOps(List&amp;lt;org.mandas.docker.client.messages.HostConfig.BlkioDeviceRate&amp;gt; | null) // nullable {@link HostConfig#blkioDeviceWriteIOps() blkioDeviceWriteIOps}
   *    .containerIdFile(String | null) // nullable {@link HostConfig#containerIdFile() containerIdFile}
   *    .lxcConf(List&amp;lt;org.mandas.docker.client.messages.HostConfig.LxcConfParameter&amp;gt; | null) // nullable {@link HostConfig#lxcConf() lxcConf}
   *    .privileged(Boolean | null) // nullable {@link HostConfig#privileged() privileged}
   *    .portBindings(Map&amp;lt;String, List&amp;lt;org.mandas.docker.client.messages.PortBinding&amp;gt;&amp;gt; | null) // nullable {@link HostConfig#portBindings() portBindings}
   *    .links(List&amp;lt;String&amp;gt; | null) // nullable {@link HostConfig#links() links}
   *    .publishAllPorts(Boolean | null) // nullable {@link HostConfig#publishAllPorts() publishAllPorts}
   *    .dns(List&amp;lt;String&amp;gt; | null) // nullable {@link HostConfig#dns() dns}
   *    .dnsOptions(List&amp;lt;String&amp;gt; | null) // nullable {@link HostConfig#dnsOptions() dnsOptions}
   *    .dnsSearch(List&amp;lt;String&amp;gt; | null) // nullable {@link HostConfig#dnsSearch() dnsSearch}
   *    .extraHosts(List&amp;lt;String&amp;gt; | null) // nullable {@link HostConfig#extraHosts() extraHosts}
   *    .groupAdd(List&amp;lt;String&amp;gt; | null) // nullable {@link HostConfig#groupAdd() groupAdd}
   *    .volumesFrom(List&amp;lt;String&amp;gt; | null) // nullable {@link HostConfig#volumesFrom() volumesFrom}
   *    .capAdd(List&amp;lt;String&amp;gt; | null) // nullable {@link HostConfig#capAdd() capAdd}
   *    .capDrop(List&amp;lt;String&amp;gt; | null) // nullable {@link HostConfig#capDrop() capDrop}
   *    .networkMode(String | null) // nullable {@link HostConfig#networkMode() networkMode}
   *    .securityOpt(List&amp;lt;String&amp;gt; | null) // nullable {@link HostConfig#securityOpt() securityOpt}
   *    .devices(List&amp;lt;org.mandas.docker.client.messages.Device&amp;gt; | null) // nullable {@link HostConfig#devices() devices}
   *    .memory(Long | null) // nullable {@link HostConfig#memory() memory}
   *    .memorySwap(Long | null) // nullable {@link HostConfig#memorySwap() memorySwap}
   *    .kernelMemory(Long | null) // nullable {@link HostConfig#kernelMemory() kernelMemory}
   *    .memorySwappiness(Integer | null) // nullable {@link HostConfig#memorySwappiness() memorySwappiness}
   *    .memoryReservation(Long | null) // nullable {@link HostConfig#memoryReservation() memoryReservation}
   *    .nanoCpus(Long | null) // nullable {@link HostConfig#nanoCpus() nanoCpus}
   *    .cpuPeriod(Long | null) // nullable {@link HostConfig#cpuPeriod() cpuPeriod}
   *    .cpuShares(Long | null) // nullable {@link HostConfig#cpuShares() cpuShares}
   *    .cpusetCpus(String | null) // nullable {@link HostConfig#cpusetCpus() cpusetCpus}
   *    .cpusetMems(String | null) // nullable {@link HostConfig#cpusetMems() cpusetMems}
   *    .cpuQuota(Long | null) // nullable {@link HostConfig#cpuQuota() cpuQuota}
   *    .cgroupParent(String | null) // nullable {@link HostConfig#cgroupParent() cgroupParent}
   *    .restartPolicy(org.mandas.docker.client.messages.HostConfig.RestartPolicy | null) // nullable {@link HostConfig#restartPolicy() restartPolicy}
   *    .logConfig(org.mandas.docker.client.messages.LogConfig | null) // nullable {@link HostConfig#logConfig() logConfig}
   *    .ipcMode(String | null) // nullable {@link HostConfig#ipcMode() ipcMode}
   *    .ulimits(List&amp;lt;org.mandas.docker.client.messages.HostConfig.Ulimit&amp;gt; | null) // nullable {@link HostConfig#ulimits() ulimits}
   *    .pidMode(String | null) // nullable {@link HostConfig#pidMode() pidMode}
   *    .shmSize(Long | null) // nullable {@link HostConfig#shmSize() shmSize}
   *    .oomKillDisable(Boolean | null) // nullable {@link HostConfig#oomKillDisable() oomKillDisable}
   *    .oomScoreAdj(Integer | null) // nullable {@link HostConfig#oomScoreAdj() oomScoreAdj}
   *    .autoRemove(Boolean | null) // nullable {@link HostConfig#autoRemove() autoRemove}
   *    .pidsLimit(Integer | null) // nullable {@link HostConfig#pidsLimit() pidsLimit}
   *    .tmpfs(Map&amp;lt;String, String&amp;gt; | null) // nullable {@link HostConfig#tmpfs() tmpfs}
   *    .readonlyRootfs(Boolean | null) // nullable {@link HostConfig#readonlyRootfs() readonlyRootfs}
   *    .storageOpt(Map&amp;lt;String, String&amp;gt; | null) // nullable {@link HostConfig#storageOpt() storageOpt}
   *    .runtime(String | null) // nullable {@link HostConfig#runtime() runtime}
   *    .mounts(List&amp;lt;org.mandas.docker.client.messages.mount.Mount&amp;gt; | null) // nullable {@link HostConfig#mounts() mounts}
   *    .init(Boolean | null) // nullable {@link HostConfig#init() init}
   *    .addSysctl|putAllSysctls(String =&gt; String) // {@link HostConfig#sysctls() sysctls} mappings
   *    .deviceRequests(List&amp;lt;org.mandas.docker.client.messages.HostConfig.DeviceRequest&amp;gt; | null) // nullable {@link HostConfig#deviceRequests() deviceRequests}
   *    .build();
   * </pre>
   * @return A new ImmutableHostConfig builder
   */
  public static ImmutableHostConfig.Builder builder() {
    return new ImmutableHostConfig.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableHostConfig ImmutableHostConfig}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  static final class Builder implements HostConfig.Builder {
    private List<String> binds = null;
    private Integer blkioWeight;
    private List<HostConfig.BlkioWeightDevice> blkioWeightDevice = null;
    private List<HostConfig.BlkioDeviceRate> blkioDeviceReadBps = null;
    private List<HostConfig.BlkioDeviceRate> blkioDeviceWriteBps = null;
    private List<HostConfig.BlkioDeviceRate> blkioDeviceReadIOps = null;
    private List<HostConfig.BlkioDeviceRate> blkioDeviceWriteIOps = null;
    private String containerIdFile;
    private List<HostConfig.LxcConfParameter> lxcConf = null;
    private Boolean privileged;
    private Map<String, List<PortBinding>> portBindings = null;
    private List<String> links = null;
    private Boolean publishAllPorts;
    private List<String> dns = null;
    private List<String> dnsOptions = null;
    private List<String> dnsSearch = null;
    private List<String> extraHosts = null;
    private List<String> groupAdd = null;
    private List<String> volumesFrom = null;
    private List<String> capAdd = null;
    private List<String> capDrop = null;
    private String networkMode;
    private List<String> securityOpt = null;
    private List<Device> devices = null;
    private Long memory;
    private Long memorySwap;
    private Long kernelMemory;
    private Integer memorySwappiness;
    private Long memoryReservation;
    private Long nanoCpus;
    private Long cpuPeriod;
    private Long cpuShares;
    private String cpusetCpus;
    private String cpusetMems;
    private Long cpuQuota;
    private String cgroupParent;
    private HostConfig.RestartPolicy restartPolicy;
    private LogConfig logConfig;
    private String ipcMode;
    private List<HostConfig.Ulimit> ulimits = null;
    private String pidMode;
    private Long shmSize;
    private Boolean oomKillDisable;
    private Integer oomScoreAdj;
    private Boolean autoRemove;
    private Integer pidsLimit;
    private Map<String, String> tmpfs = null;
    private Boolean readonlyRootfs;
    private Map<String, String> storageOpt = null;
    private String runtime;
    private List<Mount> mounts = null;
    private Boolean init;
    private Map<String, String> sysctls = new LinkedHashMap<String, String>();
    private List<HostConfig.DeviceRequest> deviceRequests = null;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code HostConfig} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(HostConfig instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable List<String> bindsValue = instance.binds();
      if (bindsValue != null) {
        addAllBinds(bindsValue);
      }
      @Nullable Integer blkioWeightValue = instance.blkioWeight();
      if (blkioWeightValue != null) {
        blkioWeight(blkioWeightValue);
      }
      @Nullable List<HostConfig.BlkioWeightDevice> blkioWeightDeviceValue = instance.blkioWeightDevice();
      if (blkioWeightDeviceValue != null) {
        addAllBlkioWeightDevice(blkioWeightDeviceValue);
      }
      @Nullable List<HostConfig.BlkioDeviceRate> blkioDeviceReadBpsValue = instance.blkioDeviceReadBps();
      if (blkioDeviceReadBpsValue != null) {
        addAllBlkioDeviceReadBps(blkioDeviceReadBpsValue);
      }
      @Nullable List<HostConfig.BlkioDeviceRate> blkioDeviceWriteBpsValue = instance.blkioDeviceWriteBps();
      if (blkioDeviceWriteBpsValue != null) {
        addAllBlkioDeviceWriteBps(blkioDeviceWriteBpsValue);
      }
      @Nullable List<HostConfig.BlkioDeviceRate> blkioDeviceReadIOpsValue = instance.blkioDeviceReadIOps();
      if (blkioDeviceReadIOpsValue != null) {
        addAllBlkioDeviceReadIOps(blkioDeviceReadIOpsValue);
      }
      @Nullable List<HostConfig.BlkioDeviceRate> blkioDeviceWriteIOpsValue = instance.blkioDeviceWriteIOps();
      if (blkioDeviceWriteIOpsValue != null) {
        addAllBlkioDeviceWriteIOps(blkioDeviceWriteIOpsValue);
      }
      @Nullable String containerIdFileValue = instance.containerIdFile();
      if (containerIdFileValue != null) {
        containerIdFile(containerIdFileValue);
      }
      @Nullable List<HostConfig.LxcConfParameter> lxcConfValue = instance.lxcConf();
      if (lxcConfValue != null) {
        addAllLxcConf(lxcConfValue);
      }
      @Nullable Boolean privilegedValue = instance.privileged();
      if (privilegedValue != null) {
        privileged(privilegedValue);
      }
      @Nullable Map<String, List<PortBinding>> portBindingsValue = instance.portBindings();
      if (portBindingsValue != null) {
        putAllPortBindings(portBindingsValue);
      }
      @Nullable List<String> linksValue = instance.links();
      if (linksValue != null) {
        addAllLinks(linksValue);
      }
      @Nullable Boolean publishAllPortsValue = instance.publishAllPorts();
      if (publishAllPortsValue != null) {
        publishAllPorts(publishAllPortsValue);
      }
      @Nullable List<String> dnsValue = instance.dns();
      if (dnsValue != null) {
        addAllDns(dnsValue);
      }
      @Nullable List<String> dnsOptionsValue = instance.dnsOptions();
      if (dnsOptionsValue != null) {
        addAllDnsOptions(dnsOptionsValue);
      }
      @Nullable List<String> dnsSearchValue = instance.dnsSearch();
      if (dnsSearchValue != null) {
        addAllDnsSearch(dnsSearchValue);
      }
      @Nullable List<String> extraHostsValue = instance.extraHosts();
      if (extraHostsValue != null) {
        addAllExtraHosts(extraHostsValue);
      }
      @Nullable List<String> groupAddValue = instance.groupAdd();
      if (groupAddValue != null) {
        addAllGroupAdd(groupAddValue);
      }
      @Nullable List<String> volumesFromValue = instance.volumesFrom();
      if (volumesFromValue != null) {
        addAllVolumesFrom(volumesFromValue);
      }
      @Nullable List<String> capAddValue = instance.capAdd();
      if (capAddValue != null) {
        addAllCapAdd(capAddValue);
      }
      @Nullable List<String> capDropValue = instance.capDrop();
      if (capDropValue != null) {
        addAllCapDrop(capDropValue);
      }
      @Nullable String networkModeValue = instance.networkMode();
      if (networkModeValue != null) {
        networkMode(networkModeValue);
      }
      @Nullable List<String> securityOptValue = instance.securityOpt();
      if (securityOptValue != null) {
        addAllSecurityOpt(securityOptValue);
      }
      @Nullable List<Device> devicesValue = instance.devices();
      if (devicesValue != null) {
        addAllDevices(devicesValue);
      }
      @Nullable Long memoryValue = instance.memory();
      if (memoryValue != null) {
        memory(memoryValue);
      }
      @Nullable Long memorySwapValue = instance.memorySwap();
      if (memorySwapValue != null) {
        memorySwap(memorySwapValue);
      }
      @Nullable Long kernelMemoryValue = instance.kernelMemory();
      if (kernelMemoryValue != null) {
        kernelMemory(kernelMemoryValue);
      }
      @Nullable Integer memorySwappinessValue = instance.memorySwappiness();
      if (memorySwappinessValue != null) {
        memorySwappiness(memorySwappinessValue);
      }
      @Nullable Long memoryReservationValue = instance.memoryReservation();
      if (memoryReservationValue != null) {
        memoryReservation(memoryReservationValue);
      }
      @Nullable Long nanoCpusValue = instance.nanoCpus();
      if (nanoCpusValue != null) {
        nanoCpus(nanoCpusValue);
      }
      @Nullable Long cpuPeriodValue = instance.cpuPeriod();
      if (cpuPeriodValue != null) {
        cpuPeriod(cpuPeriodValue);
      }
      @Nullable Long cpuSharesValue = instance.cpuShares();
      if (cpuSharesValue != null) {
        cpuShares(cpuSharesValue);
      }
      @Nullable String cpusetCpusValue = instance.cpusetCpus();
      if (cpusetCpusValue != null) {
        cpusetCpus(cpusetCpusValue);
      }
      @Nullable String cpusetMemsValue = instance.cpusetMems();
      if (cpusetMemsValue != null) {
        cpusetMems(cpusetMemsValue);
      }
      @Nullable Long cpuQuotaValue = instance.cpuQuota();
      if (cpuQuotaValue != null) {
        cpuQuota(cpuQuotaValue);
      }
      @Nullable String cgroupParentValue = instance.cgroupParent();
      if (cgroupParentValue != null) {
        cgroupParent(cgroupParentValue);
      }
      @Nullable HostConfig.RestartPolicy restartPolicyValue = instance.restartPolicy();
      if (restartPolicyValue != null) {
        restartPolicy(restartPolicyValue);
      }
      @Nullable LogConfig logConfigValue = instance.logConfig();
      if (logConfigValue != null) {
        logConfig(logConfigValue);
      }
      @Nullable String ipcModeValue = instance.ipcMode();
      if (ipcModeValue != null) {
        ipcMode(ipcModeValue);
      }
      @Nullable List<HostConfig.Ulimit> ulimitsValue = instance.ulimits();
      if (ulimitsValue != null) {
        addAllUlimits(ulimitsValue);
      }
      @Nullable String pidModeValue = instance.pidMode();
      if (pidModeValue != null) {
        pidMode(pidModeValue);
      }
      @Nullable Long shmSizeValue = instance.shmSize();
      if (shmSizeValue != null) {
        shmSize(shmSizeValue);
      }
      @Nullable Boolean oomKillDisableValue = instance.oomKillDisable();
      if (oomKillDisableValue != null) {
        oomKillDisable(oomKillDisableValue);
      }
      @Nullable Integer oomScoreAdjValue = instance.oomScoreAdj();
      if (oomScoreAdjValue != null) {
        oomScoreAdj(oomScoreAdjValue);
      }
      @Nullable Boolean autoRemoveValue = instance.autoRemove();
      if (autoRemoveValue != null) {
        autoRemove(autoRemoveValue);
      }
      @Nullable Integer pidsLimitValue = instance.pidsLimit();
      if (pidsLimitValue != null) {
        pidsLimit(pidsLimitValue);
      }
      @Nullable Map<String, String> tmpfsValue = instance.tmpfs();
      if (tmpfsValue != null) {
        putAllTmpfs(tmpfsValue);
      }
      @Nullable Boolean readonlyRootfsValue = instance.readonlyRootfs();
      if (readonlyRootfsValue != null) {
        readonlyRootfs(readonlyRootfsValue);
      }
      @Nullable Map<String, String> storageOptValue = instance.storageOpt();
      if (storageOptValue != null) {
        putAllStorageOpt(storageOptValue);
      }
      @Nullable String runtimeValue = instance.runtime();
      if (runtimeValue != null) {
        runtime(runtimeValue);
      }
      @Nullable List<Mount> mountsValue = instance.mounts();
      if (mountsValue != null) {
        addAllMounts(mountsValue);
      }
      @Nullable Boolean initValue = instance.init();
      if (initValue != null) {
        init(initValue);
      }
      putAllSysctls(instance.sysctls());
      @Nullable List<HostConfig.DeviceRequest> deviceRequestsValue = instance.deviceRequests();
      if (deviceRequestsValue != null) {
        addAllDeviceRequests(deviceRequestsValue);
      }
      return this;
    }

    /**
     * Adds one element to {@link HostConfig#binds() binds} list.
     * @param element A binds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder bind(String element) {
      if (this.binds == null) {
        this.binds = new ArrayList<String>();
      }
      this.binds.add(Objects.requireNonNull(element, "binds element"));
      return this;
    }

    /**
     * Adds elements to {@link HostConfig#binds() binds} list.
     * @param elements An array of binds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder binds(String... elements) {
      if (this.binds == null) {
        this.binds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.binds.add(Objects.requireNonNull(element, "binds element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link HostConfig#binds() binds} list.
     * @param elements An iterable of binds elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("Binds")
    public final Builder binds(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.binds = null;
        return this;
      }
      this.binds = new ArrayList<String>();
      return addAllBinds(elements);
    }

    /**
     * Adds elements to {@link HostConfig#binds() binds} list.
     * @param elements An iterable of binds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllBinds(Iterable<String> elements) {
      Objects.requireNonNull(elements, "binds element");
      if (this.binds == null) {
        this.binds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.binds.add(Objects.requireNonNull(element, "binds element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link HostConfig#blkioWeight() blkioWeight} attribute.
     * @param blkioWeight The value for blkioWeight (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("BlkioWeight")
    public final Builder blkioWeight(@Nullable Integer blkioWeight) {
      this.blkioWeight = blkioWeight;
      return this;
    }

    /**
     * Adds one element to {@link HostConfig#blkioWeightDevice() blkioWeightDevice} list.
     * @param element A blkioWeightDevice element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder blkioWeightDevice(HostConfig.BlkioWeightDevice element) {
      if (this.blkioWeightDevice == null) {
        this.blkioWeightDevice = new ArrayList<HostConfig.BlkioWeightDevice>();
      }
      this.blkioWeightDevice.add(Objects.requireNonNull(element, "blkioWeightDevice element"));
      return this;
    }

    /**
     * Adds elements to {@link HostConfig#blkioWeightDevice() blkioWeightDevice} list.
     * @param elements An array of blkioWeightDevice elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder blkioWeightDevice(HostConfig.BlkioWeightDevice... elements) {
      if (this.blkioWeightDevice == null) {
        this.blkioWeightDevice = new ArrayList<HostConfig.BlkioWeightDevice>();
      }
      for (HostConfig.BlkioWeightDevice element : elements) {
        this.blkioWeightDevice.add(Objects.requireNonNull(element, "blkioWeightDevice element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link HostConfig#blkioWeightDevice() blkioWeightDevice} list.
     * @param elements An iterable of blkioWeightDevice elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("BlkioWeightDevice")
    public final Builder blkioWeightDevice(@Nullable Iterable<? extends HostConfig.BlkioWeightDevice> elements) {
      if (elements == null) {
        this.blkioWeightDevice = null;
        return this;
      }
      this.blkioWeightDevice = new ArrayList<HostConfig.BlkioWeightDevice>();
      return addAllBlkioWeightDevice(elements);
    }

    /**
     * Adds elements to {@link HostConfig#blkioWeightDevice() blkioWeightDevice} list.
     * @param elements An iterable of blkioWeightDevice elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllBlkioWeightDevice(Iterable<? extends HostConfig.BlkioWeightDevice> elements) {
      Objects.requireNonNull(elements, "blkioWeightDevice element");
      if (this.blkioWeightDevice == null) {
        this.blkioWeightDevice = new ArrayList<HostConfig.BlkioWeightDevice>();
      }
      for (HostConfig.BlkioWeightDevice element : elements) {
        this.blkioWeightDevice.add(Objects.requireNonNull(element, "blkioWeightDevice element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link HostConfig#blkioDeviceReadBps() blkioDeviceReadBps} list.
     * @param element A blkioDeviceReadBps element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder blkioDeviceReadBp(HostConfig.BlkioDeviceRate element) {
      if (this.blkioDeviceReadBps == null) {
        this.blkioDeviceReadBps = new ArrayList<HostConfig.BlkioDeviceRate>();
      }
      this.blkioDeviceReadBps.add(Objects.requireNonNull(element, "blkioDeviceReadBps element"));
      return this;
    }

    /**
     * Adds elements to {@link HostConfig#blkioDeviceReadBps() blkioDeviceReadBps} list.
     * @param elements An array of blkioDeviceReadBps elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder blkioDeviceReadBps(HostConfig.BlkioDeviceRate... elements) {
      if (this.blkioDeviceReadBps == null) {
        this.blkioDeviceReadBps = new ArrayList<HostConfig.BlkioDeviceRate>();
      }
      for (HostConfig.BlkioDeviceRate element : elements) {
        this.blkioDeviceReadBps.add(Objects.requireNonNull(element, "blkioDeviceReadBps element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link HostConfig#blkioDeviceReadBps() blkioDeviceReadBps} list.
     * @param elements An iterable of blkioDeviceReadBps elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("BlkioDeviceReadBps")
    public final Builder blkioDeviceReadBps(@Nullable Iterable<? extends HostConfig.BlkioDeviceRate> elements) {
      if (elements == null) {
        this.blkioDeviceReadBps = null;
        return this;
      }
      this.blkioDeviceReadBps = new ArrayList<HostConfig.BlkioDeviceRate>();
      return addAllBlkioDeviceReadBps(elements);
    }

    /**
     * Adds elements to {@link HostConfig#blkioDeviceReadBps() blkioDeviceReadBps} list.
     * @param elements An iterable of blkioDeviceReadBps elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllBlkioDeviceReadBps(Iterable<? extends HostConfig.BlkioDeviceRate> elements) {
      Objects.requireNonNull(elements, "blkioDeviceReadBps element");
      if (this.blkioDeviceReadBps == null) {
        this.blkioDeviceReadBps = new ArrayList<HostConfig.BlkioDeviceRate>();
      }
      for (HostConfig.BlkioDeviceRate element : elements) {
        this.blkioDeviceReadBps.add(Objects.requireNonNull(element, "blkioDeviceReadBps element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link HostConfig#blkioDeviceWriteBps() blkioDeviceWriteBps} list.
     * @param element A blkioDeviceWriteBps element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder blkioDeviceWriteBp(HostConfig.BlkioDeviceRate element) {
      if (this.blkioDeviceWriteBps == null) {
        this.blkioDeviceWriteBps = new ArrayList<HostConfig.BlkioDeviceRate>();
      }
      this.blkioDeviceWriteBps.add(Objects.requireNonNull(element, "blkioDeviceWriteBps element"));
      return this;
    }

    /**
     * Adds elements to {@link HostConfig#blkioDeviceWriteBps() blkioDeviceWriteBps} list.
     * @param elements An array of blkioDeviceWriteBps elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder blkioDeviceWriteBps(HostConfig.BlkioDeviceRate... elements) {
      if (this.blkioDeviceWriteBps == null) {
        this.blkioDeviceWriteBps = new ArrayList<HostConfig.BlkioDeviceRate>();
      }
      for (HostConfig.BlkioDeviceRate element : elements) {
        this.blkioDeviceWriteBps.add(Objects.requireNonNull(element, "blkioDeviceWriteBps element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link HostConfig#blkioDeviceWriteBps() blkioDeviceWriteBps} list.
     * @param elements An iterable of blkioDeviceWriteBps elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("BlkioDeviceWriteBps")
    public final Builder blkioDeviceWriteBps(@Nullable Iterable<? extends HostConfig.BlkioDeviceRate> elements) {
      if (elements == null) {
        this.blkioDeviceWriteBps = null;
        return this;
      }
      this.blkioDeviceWriteBps = new ArrayList<HostConfig.BlkioDeviceRate>();
      return addAllBlkioDeviceWriteBps(elements);
    }

    /**
     * Adds elements to {@link HostConfig#blkioDeviceWriteBps() blkioDeviceWriteBps} list.
     * @param elements An iterable of blkioDeviceWriteBps elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllBlkioDeviceWriteBps(Iterable<? extends HostConfig.BlkioDeviceRate> elements) {
      Objects.requireNonNull(elements, "blkioDeviceWriteBps element");
      if (this.blkioDeviceWriteBps == null) {
        this.blkioDeviceWriteBps = new ArrayList<HostConfig.BlkioDeviceRate>();
      }
      for (HostConfig.BlkioDeviceRate element : elements) {
        this.blkioDeviceWriteBps.add(Objects.requireNonNull(element, "blkioDeviceWriteBps element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link HostConfig#blkioDeviceReadIOps() blkioDeviceReadIOps} list.
     * @param element A blkioDeviceReadIOps element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder blkioDeviceReadIOp(HostConfig.BlkioDeviceRate element) {
      if (this.blkioDeviceReadIOps == null) {
        this.blkioDeviceReadIOps = new ArrayList<HostConfig.BlkioDeviceRate>();
      }
      this.blkioDeviceReadIOps.add(Objects.requireNonNull(element, "blkioDeviceReadIOps element"));
      return this;
    }

    /**
     * Adds elements to {@link HostConfig#blkioDeviceReadIOps() blkioDeviceReadIOps} list.
     * @param elements An array of blkioDeviceReadIOps elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder blkioDeviceReadIOps(HostConfig.BlkioDeviceRate... elements) {
      if (this.blkioDeviceReadIOps == null) {
        this.blkioDeviceReadIOps = new ArrayList<HostConfig.BlkioDeviceRate>();
      }
      for (HostConfig.BlkioDeviceRate element : elements) {
        this.blkioDeviceReadIOps.add(Objects.requireNonNull(element, "blkioDeviceReadIOps element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link HostConfig#blkioDeviceReadIOps() blkioDeviceReadIOps} list.
     * @param elements An iterable of blkioDeviceReadIOps elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("BlkioDeviceReadIOps")
    public final Builder blkioDeviceReadIOps(@Nullable Iterable<? extends HostConfig.BlkioDeviceRate> elements) {
      if (elements == null) {
        this.blkioDeviceReadIOps = null;
        return this;
      }
      this.blkioDeviceReadIOps = new ArrayList<HostConfig.BlkioDeviceRate>();
      return addAllBlkioDeviceReadIOps(elements);
    }

    /**
     * Adds elements to {@link HostConfig#blkioDeviceReadIOps() blkioDeviceReadIOps} list.
     * @param elements An iterable of blkioDeviceReadIOps elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllBlkioDeviceReadIOps(Iterable<? extends HostConfig.BlkioDeviceRate> elements) {
      Objects.requireNonNull(elements, "blkioDeviceReadIOps element");
      if (this.blkioDeviceReadIOps == null) {
        this.blkioDeviceReadIOps = new ArrayList<HostConfig.BlkioDeviceRate>();
      }
      for (HostConfig.BlkioDeviceRate element : elements) {
        this.blkioDeviceReadIOps.add(Objects.requireNonNull(element, "blkioDeviceReadIOps element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link HostConfig#blkioDeviceWriteIOps() blkioDeviceWriteIOps} list.
     * @param element A blkioDeviceWriteIOps element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder blkioDeviceWriteIOp(HostConfig.BlkioDeviceRate element) {
      if (this.blkioDeviceWriteIOps == null) {
        this.blkioDeviceWriteIOps = new ArrayList<HostConfig.BlkioDeviceRate>();
      }
      this.blkioDeviceWriteIOps.add(Objects.requireNonNull(element, "blkioDeviceWriteIOps element"));
      return this;
    }

    /**
     * Adds elements to {@link HostConfig#blkioDeviceWriteIOps() blkioDeviceWriteIOps} list.
     * @param elements An array of blkioDeviceWriteIOps elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder blkioDeviceWriteIOps(HostConfig.BlkioDeviceRate... elements) {
      if (this.blkioDeviceWriteIOps == null) {
        this.blkioDeviceWriteIOps = new ArrayList<HostConfig.BlkioDeviceRate>();
      }
      for (HostConfig.BlkioDeviceRate element : elements) {
        this.blkioDeviceWriteIOps.add(Objects.requireNonNull(element, "blkioDeviceWriteIOps element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link HostConfig#blkioDeviceWriteIOps() blkioDeviceWriteIOps} list.
     * @param elements An iterable of blkioDeviceWriteIOps elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("BlkioDeviceWriteIOps")
    public final Builder blkioDeviceWriteIOps(@Nullable Iterable<? extends HostConfig.BlkioDeviceRate> elements) {
      if (elements == null) {
        this.blkioDeviceWriteIOps = null;
        return this;
      }
      this.blkioDeviceWriteIOps = new ArrayList<HostConfig.BlkioDeviceRate>();
      return addAllBlkioDeviceWriteIOps(elements);
    }

    /**
     * Adds elements to {@link HostConfig#blkioDeviceWriteIOps() blkioDeviceWriteIOps} list.
     * @param elements An iterable of blkioDeviceWriteIOps elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllBlkioDeviceWriteIOps(Iterable<? extends HostConfig.BlkioDeviceRate> elements) {
      Objects.requireNonNull(elements, "blkioDeviceWriteIOps element");
      if (this.blkioDeviceWriteIOps == null) {
        this.blkioDeviceWriteIOps = new ArrayList<HostConfig.BlkioDeviceRate>();
      }
      for (HostConfig.BlkioDeviceRate element : elements) {
        this.blkioDeviceWriteIOps.add(Objects.requireNonNull(element, "blkioDeviceWriteIOps element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link HostConfig#containerIdFile() containerIdFile} attribute.
     * @param containerIdFile The value for containerIdFile (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("ContainerIDFile")
    public final Builder containerIdFile(@Nullable String containerIdFile) {
      this.containerIdFile = containerIdFile;
      return this;
    }

    /**
     * Adds one element to {@link HostConfig#lxcConf() lxcConf} list.
     * @param element A lxcConf element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder lxcConf(HostConfig.LxcConfParameter element) {
      if (this.lxcConf == null) {
        this.lxcConf = new ArrayList<HostConfig.LxcConfParameter>();
      }
      this.lxcConf.add(Objects.requireNonNull(element, "lxcConf element"));
      return this;
    }

    /**
     * Adds elements to {@link HostConfig#lxcConf() lxcConf} list.
     * @param elements An array of lxcConf elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder lxcConf(HostConfig.LxcConfParameter... elements) {
      if (this.lxcConf == null) {
        this.lxcConf = new ArrayList<HostConfig.LxcConfParameter>();
      }
      for (HostConfig.LxcConfParameter element : elements) {
        this.lxcConf.add(Objects.requireNonNull(element, "lxcConf element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link HostConfig#lxcConf() lxcConf} list.
     * @param elements An iterable of lxcConf elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("LxcConf")
    public final Builder lxcConf(@Nullable Iterable<? extends HostConfig.LxcConfParameter> elements) {
      if (elements == null) {
        this.lxcConf = null;
        return this;
      }
      this.lxcConf = new ArrayList<HostConfig.LxcConfParameter>();
      return addAllLxcConf(elements);
    }

    /**
     * Adds elements to {@link HostConfig#lxcConf() lxcConf} list.
     * @param elements An iterable of lxcConf elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllLxcConf(Iterable<? extends HostConfig.LxcConfParameter> elements) {
      Objects.requireNonNull(elements, "lxcConf element");
      if (this.lxcConf == null) {
        this.lxcConf = new ArrayList<HostConfig.LxcConfParameter>();
      }
      for (HostConfig.LxcConfParameter element : elements) {
        this.lxcConf.add(Objects.requireNonNull(element, "lxcConf element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link HostConfig#privileged() privileged} attribute.
     * @param privileged The value for privileged (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("Privileged")
    public final Builder privileged(@Nullable Boolean privileged) {
      this.privileged = privileged;
      return this;
    }

    /**
     * Put one entry to the {@link HostConfig#portBindings() portBindings} map.
     * @param key The key in the portBindings map
     * @param value The associated value in the portBindings map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addPortBinding(String key, List<PortBinding> value) {
      if (this.portBindings == null) {
        this.portBindings = new LinkedHashMap<String, List<PortBinding>>();
      }
      this.portBindings.put(
          Objects.requireNonNull(key, "portBindings key"),
          value == null ? Objects.requireNonNull(value, "portBindings value for key: " + key) : value);
      return this;
    }

    /**
     * Put one entry to the {@link HostConfig#portBindings() portBindings} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addPortBinding(Map.Entry<String, ? extends List<PortBinding>> entry) {
      if (this.portBindings == null) {
        this.portBindings = new LinkedHashMap<String, List<PortBinding>>();
      }
      String k = entry.getKey();
      List<PortBinding> v = entry.getValue();
      this.portBindings.put(
          Objects.requireNonNull(k, "portBindings key"),
          v == null ? Objects.requireNonNull(v, "portBindings value for key: " + k) : v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link HostConfig#portBindings() portBindings} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the portBindings map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("PortBindings")
    public final Builder portBindings(@Nullable Map<String, ? extends List<PortBinding>> entries) {
      if (entries == null) {
        this.portBindings = null;
        return this;
      }
      this.portBindings = new LinkedHashMap<String, List<PortBinding>>();
      return putAllPortBindings(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link HostConfig#portBindings() portBindings} map. Nulls are not permitted
     * @param entries The entries that will be added to the portBindings map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllPortBindings(Map<String, ? extends List<PortBinding>> entries) {
      if (this.portBindings == null) {
        this.portBindings = new LinkedHashMap<String, List<PortBinding>>();
      }
      for (Map.Entry<String, ? extends List<PortBinding>> e : entries.entrySet()) {
        String k = e.getKey();
        List<PortBinding> v = e.getValue();
        this.portBindings.put(
            Objects.requireNonNull(k, "portBindings key"),
            v == null ? Objects.requireNonNull(v, "portBindings value for key: " + k) : v);
      }
      return this;
    }

    /**
     * Adds one element to {@link HostConfig#links() links} list.
     * @param element A links element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder link(String element) {
      if (this.links == null) {
        this.links = new ArrayList<String>();
      }
      this.links.add(Objects.requireNonNull(element, "links element"));
      return this;
    }

    /**
     * Adds elements to {@link HostConfig#links() links} list.
     * @param elements An array of links elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder links(String... elements) {
      if (this.links == null) {
        this.links = new ArrayList<String>();
      }
      for (String element : elements) {
        this.links.add(Objects.requireNonNull(element, "links element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link HostConfig#links() links} list.
     * @param elements An iterable of links elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("Links")
    public final Builder links(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.links = null;
        return this;
      }
      this.links = new ArrayList<String>();
      return addAllLinks(elements);
    }

    /**
     * Adds elements to {@link HostConfig#links() links} list.
     * @param elements An iterable of links elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllLinks(Iterable<String> elements) {
      Objects.requireNonNull(elements, "links element");
      if (this.links == null) {
        this.links = new ArrayList<String>();
      }
      for (String element : elements) {
        this.links.add(Objects.requireNonNull(element, "links element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link HostConfig#publishAllPorts() publishAllPorts} attribute.
     * @param publishAllPorts The value for publishAllPorts (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("PublishAllPorts")
    public final Builder publishAllPorts(@Nullable Boolean publishAllPorts) {
      this.publishAllPorts = publishAllPorts;
      return this;
    }

    /**
     * Adds one element to {@link HostConfig#dns() dns} list.
     * @param element A dns element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder dn(String element) {
      if (this.dns == null) {
        this.dns = new ArrayList<String>();
      }
      this.dns.add(Objects.requireNonNull(element, "dns element"));
      return this;
    }

    /**
     * Adds elements to {@link HostConfig#dns() dns} list.
     * @param elements An array of dns elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder dns(String... elements) {
      if (this.dns == null) {
        this.dns = new ArrayList<String>();
      }
      for (String element : elements) {
        this.dns.add(Objects.requireNonNull(element, "dns element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link HostConfig#dns() dns} list.
     * @param elements An iterable of dns elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("Dns")
    public final Builder dns(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.dns = null;
        return this;
      }
      this.dns = new ArrayList<String>();
      return addAllDns(elements);
    }

    /**
     * Adds elements to {@link HostConfig#dns() dns} list.
     * @param elements An iterable of dns elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllDns(Iterable<String> elements) {
      Objects.requireNonNull(elements, "dns element");
      if (this.dns == null) {
        this.dns = new ArrayList<String>();
      }
      for (String element : elements) {
        this.dns.add(Objects.requireNonNull(element, "dns element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link HostConfig#dnsOptions() dnsOptions} list.
     * @param element A dnsOptions element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder dnsOption(String element) {
      if (this.dnsOptions == null) {
        this.dnsOptions = new ArrayList<String>();
      }
      this.dnsOptions.add(Objects.requireNonNull(element, "dnsOptions element"));
      return this;
    }

    /**
     * Adds elements to {@link HostConfig#dnsOptions() dnsOptions} list.
     * @param elements An array of dnsOptions elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder dnsOptions(String... elements) {
      if (this.dnsOptions == null) {
        this.dnsOptions = new ArrayList<String>();
      }
      for (String element : elements) {
        this.dnsOptions.add(Objects.requireNonNull(element, "dnsOptions element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link HostConfig#dnsOptions() dnsOptions} list.
     * @param elements An iterable of dnsOptions elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("DnsOptions")
    public final Builder dnsOptions(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.dnsOptions = null;
        return this;
      }
      this.dnsOptions = new ArrayList<String>();
      return addAllDnsOptions(elements);
    }

    /**
     * Adds elements to {@link HostConfig#dnsOptions() dnsOptions} list.
     * @param elements An iterable of dnsOptions elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllDnsOptions(Iterable<String> elements) {
      Objects.requireNonNull(elements, "dnsOptions element");
      if (this.dnsOptions == null) {
        this.dnsOptions = new ArrayList<String>();
      }
      for (String element : elements) {
        this.dnsOptions.add(Objects.requireNonNull(element, "dnsOptions element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link HostConfig#dnsSearch() dnsSearch} list.
     * @param element A dnsSearch element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder dnsSearch(String element) {
      if (this.dnsSearch == null) {
        this.dnsSearch = new ArrayList<String>();
      }
      this.dnsSearch.add(Objects.requireNonNull(element, "dnsSearch element"));
      return this;
    }

    /**
     * Adds elements to {@link HostConfig#dnsSearch() dnsSearch} list.
     * @param elements An array of dnsSearch elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder dnsSearch(String... elements) {
      if (this.dnsSearch == null) {
        this.dnsSearch = new ArrayList<String>();
      }
      for (String element : elements) {
        this.dnsSearch.add(Objects.requireNonNull(element, "dnsSearch element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link HostConfig#dnsSearch() dnsSearch} list.
     * @param elements An iterable of dnsSearch elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("DnsSearch")
    public final Builder dnsSearch(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.dnsSearch = null;
        return this;
      }
      this.dnsSearch = new ArrayList<String>();
      return addAllDnsSearch(elements);
    }

    /**
     * Adds elements to {@link HostConfig#dnsSearch() dnsSearch} list.
     * @param elements An iterable of dnsSearch elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllDnsSearch(Iterable<String> elements) {
      Objects.requireNonNull(elements, "dnsSearch element");
      if (this.dnsSearch == null) {
        this.dnsSearch = new ArrayList<String>();
      }
      for (String element : elements) {
        this.dnsSearch.add(Objects.requireNonNull(element, "dnsSearch element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link HostConfig#extraHosts() extraHosts} list.
     * @param element A extraHosts element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder extraHost(String element) {
      if (this.extraHosts == null) {
        this.extraHosts = new ArrayList<String>();
      }
      this.extraHosts.add(Objects.requireNonNull(element, "extraHosts element"));
      return this;
    }

    /**
     * Adds elements to {@link HostConfig#extraHosts() extraHosts} list.
     * @param elements An array of extraHosts elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder extraHosts(String... elements) {
      if (this.extraHosts == null) {
        this.extraHosts = new ArrayList<String>();
      }
      for (String element : elements) {
        this.extraHosts.add(Objects.requireNonNull(element, "extraHosts element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link HostConfig#extraHosts() extraHosts} list.
     * @param elements An iterable of extraHosts elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("ExtraHosts")
    public final Builder extraHosts(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.extraHosts = null;
        return this;
      }
      this.extraHosts = new ArrayList<String>();
      return addAllExtraHosts(elements);
    }

    /**
     * Adds elements to {@link HostConfig#extraHosts() extraHosts} list.
     * @param elements An iterable of extraHosts elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllExtraHosts(Iterable<String> elements) {
      Objects.requireNonNull(elements, "extraHosts element");
      if (this.extraHosts == null) {
        this.extraHosts = new ArrayList<String>();
      }
      for (String element : elements) {
        this.extraHosts.add(Objects.requireNonNull(element, "extraHosts element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link HostConfig#groupAdd() groupAdd} list.
     * @param element A groupAdd element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder groupAdd(String element) {
      if (this.groupAdd == null) {
        this.groupAdd = new ArrayList<String>();
      }
      this.groupAdd.add(Objects.requireNonNull(element, "groupAdd element"));
      return this;
    }

    /**
     * Adds elements to {@link HostConfig#groupAdd() groupAdd} list.
     * @param elements An array of groupAdd elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder groupAdd(String... elements) {
      if (this.groupAdd == null) {
        this.groupAdd = new ArrayList<String>();
      }
      for (String element : elements) {
        this.groupAdd.add(Objects.requireNonNull(element, "groupAdd element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link HostConfig#groupAdd() groupAdd} list.
     * @param elements An iterable of groupAdd elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("GroupAdd")
    public final Builder groupAdd(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.groupAdd = null;
        return this;
      }
      this.groupAdd = new ArrayList<String>();
      return addAllGroupAdd(elements);
    }

    /**
     * Adds elements to {@link HostConfig#groupAdd() groupAdd} list.
     * @param elements An iterable of groupAdd elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllGroupAdd(Iterable<String> elements) {
      Objects.requireNonNull(elements, "groupAdd element");
      if (this.groupAdd == null) {
        this.groupAdd = new ArrayList<String>();
      }
      for (String element : elements) {
        this.groupAdd.add(Objects.requireNonNull(element, "groupAdd element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link HostConfig#volumesFrom() volumesFrom} list.
     * @param element A volumesFrom element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder volumesFrom(String element) {
      if (this.volumesFrom == null) {
        this.volumesFrom = new ArrayList<String>();
      }
      this.volumesFrom.add(Objects.requireNonNull(element, "volumesFrom element"));
      return this;
    }

    /**
     * Adds elements to {@link HostConfig#volumesFrom() volumesFrom} list.
     * @param elements An array of volumesFrom elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder volumesFrom(String... elements) {
      if (this.volumesFrom == null) {
        this.volumesFrom = new ArrayList<String>();
      }
      for (String element : elements) {
        this.volumesFrom.add(Objects.requireNonNull(element, "volumesFrom element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link HostConfig#volumesFrom() volumesFrom} list.
     * @param elements An iterable of volumesFrom elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("VolumesFrom")
    public final Builder volumesFrom(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.volumesFrom = null;
        return this;
      }
      this.volumesFrom = new ArrayList<String>();
      return addAllVolumesFrom(elements);
    }

    /**
     * Adds elements to {@link HostConfig#volumesFrom() volumesFrom} list.
     * @param elements An iterable of volumesFrom elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllVolumesFrom(Iterable<String> elements) {
      Objects.requireNonNull(elements, "volumesFrom element");
      if (this.volumesFrom == null) {
        this.volumesFrom = new ArrayList<String>();
      }
      for (String element : elements) {
        this.volumesFrom.add(Objects.requireNonNull(element, "volumesFrom element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link HostConfig#capAdd() capAdd} list.
     * @param element A capAdd element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder capAdd(String element) {
      if (this.capAdd == null) {
        this.capAdd = new ArrayList<String>();
      }
      this.capAdd.add(Objects.requireNonNull(element, "capAdd element"));
      return this;
    }

    /**
     * Adds elements to {@link HostConfig#capAdd() capAdd} list.
     * @param elements An array of capAdd elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder capAdd(String... elements) {
      if (this.capAdd == null) {
        this.capAdd = new ArrayList<String>();
      }
      for (String element : elements) {
        this.capAdd.add(Objects.requireNonNull(element, "capAdd element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link HostConfig#capAdd() capAdd} list.
     * @param elements An iterable of capAdd elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("CapAdd")
    public final Builder capAdd(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.capAdd = null;
        return this;
      }
      this.capAdd = new ArrayList<String>();
      return addAllCapAdd(elements);
    }

    /**
     * Adds elements to {@link HostConfig#capAdd() capAdd} list.
     * @param elements An iterable of capAdd elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllCapAdd(Iterable<String> elements) {
      Objects.requireNonNull(elements, "capAdd element");
      if (this.capAdd == null) {
        this.capAdd = new ArrayList<String>();
      }
      for (String element : elements) {
        this.capAdd.add(Objects.requireNonNull(element, "capAdd element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link HostConfig#capDrop() capDrop} list.
     * @param element A capDrop element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder capDrop(String element) {
      if (this.capDrop == null) {
        this.capDrop = new ArrayList<String>();
      }
      this.capDrop.add(Objects.requireNonNull(element, "capDrop element"));
      return this;
    }

    /**
     * Adds elements to {@link HostConfig#capDrop() capDrop} list.
     * @param elements An array of capDrop elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder capDrop(String... elements) {
      if (this.capDrop == null) {
        this.capDrop = new ArrayList<String>();
      }
      for (String element : elements) {
        this.capDrop.add(Objects.requireNonNull(element, "capDrop element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link HostConfig#capDrop() capDrop} list.
     * @param elements An iterable of capDrop elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("CapDrop")
    public final Builder capDrop(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.capDrop = null;
        return this;
      }
      this.capDrop = new ArrayList<String>();
      return addAllCapDrop(elements);
    }

    /**
     * Adds elements to {@link HostConfig#capDrop() capDrop} list.
     * @param elements An iterable of capDrop elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllCapDrop(Iterable<String> elements) {
      Objects.requireNonNull(elements, "capDrop element");
      if (this.capDrop == null) {
        this.capDrop = new ArrayList<String>();
      }
      for (String element : elements) {
        this.capDrop.add(Objects.requireNonNull(element, "capDrop element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link HostConfig#networkMode() networkMode} attribute.
     * @param networkMode The value for networkMode (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("NetworkMode")
    public final Builder networkMode(@Nullable String networkMode) {
      this.networkMode = networkMode;
      return this;
    }

    /**
     * Adds one element to {@link HostConfig#securityOpt() securityOpt} list.
     * @param element A securityOpt element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder securityOpt(String element) {
      if (this.securityOpt == null) {
        this.securityOpt = new ArrayList<String>();
      }
      this.securityOpt.add(Objects.requireNonNull(element, "securityOpt element"));
      return this;
    }

    /**
     * Adds elements to {@link HostConfig#securityOpt() securityOpt} list.
     * @param elements An array of securityOpt elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder securityOpt(String... elements) {
      if (this.securityOpt == null) {
        this.securityOpt = new ArrayList<String>();
      }
      for (String element : elements) {
        this.securityOpt.add(Objects.requireNonNull(element, "securityOpt element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link HostConfig#securityOpt() securityOpt} list.
     * @param elements An iterable of securityOpt elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("SecurityOpt")
    public final Builder securityOpt(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.securityOpt = null;
        return this;
      }
      this.securityOpt = new ArrayList<String>();
      return addAllSecurityOpt(elements);
    }

    /**
     * Adds elements to {@link HostConfig#securityOpt() securityOpt} list.
     * @param elements An iterable of securityOpt elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllSecurityOpt(Iterable<String> elements) {
      Objects.requireNonNull(elements, "securityOpt element");
      if (this.securityOpt == null) {
        this.securityOpt = new ArrayList<String>();
      }
      for (String element : elements) {
        this.securityOpt.add(Objects.requireNonNull(element, "securityOpt element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link HostConfig#devices() devices} list.
     * @param element A devices element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder device(Device element) {
      if (this.devices == null) {
        this.devices = new ArrayList<Device>();
      }
      this.devices.add(Objects.requireNonNull(element, "devices element"));
      return this;
    }

    /**
     * Adds elements to {@link HostConfig#devices() devices} list.
     * @param elements An array of devices elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder devices(Device... elements) {
      if (this.devices == null) {
        this.devices = new ArrayList<Device>();
      }
      for (Device element : elements) {
        this.devices.add(Objects.requireNonNull(element, "devices element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link HostConfig#devices() devices} list.
     * @param elements An iterable of devices elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("Devices")
    public final Builder devices(@Nullable Iterable<? extends Device> elements) {
      if (elements == null) {
        this.devices = null;
        return this;
      }
      this.devices = new ArrayList<Device>();
      return addAllDevices(elements);
    }

    /**
     * Adds elements to {@link HostConfig#devices() devices} list.
     * @param elements An iterable of devices elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllDevices(Iterable<? extends Device> elements) {
      Objects.requireNonNull(elements, "devices element");
      if (this.devices == null) {
        this.devices = new ArrayList<Device>();
      }
      for (Device element : elements) {
        this.devices.add(Objects.requireNonNull(element, "devices element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link HostConfig#memory() memory} attribute.
     * @param memory The value for memory (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("Memory")
    public final Builder memory(@Nullable Long memory) {
      this.memory = memory;
      return this;
    }

    /**
     * Initializes the value for the {@link HostConfig#memorySwap() memorySwap} attribute.
     * @param memorySwap The value for memorySwap (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("MemorySwap")
    public final Builder memorySwap(@Nullable Long memorySwap) {
      this.memorySwap = memorySwap;
      return this;
    }

    /**
     * Initializes the value for the {@link HostConfig#kernelMemory() kernelMemory} attribute.
     * @param kernelMemory The value for kernelMemory (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("KernelMemory")
    @Deprecated
    public final Builder kernelMemory(@Nullable Long kernelMemory) {
      this.kernelMemory = kernelMemory;
      return this;
    }

    /**
     * Initializes the value for the {@link HostConfig#memorySwappiness() memorySwappiness} attribute.
     * @param memorySwappiness The value for memorySwappiness (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("MemorySwappiness")
    public final Builder memorySwappiness(@Nullable Integer memorySwappiness) {
      this.memorySwappiness = memorySwappiness;
      return this;
    }

    /**
     * Initializes the value for the {@link HostConfig#memoryReservation() memoryReservation} attribute.
     * @param memoryReservation The value for memoryReservation (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("MemoryReservation")
    public final Builder memoryReservation(@Nullable Long memoryReservation) {
      this.memoryReservation = memoryReservation;
      return this;
    }

    /**
     * Initializes the value for the {@link HostConfig#nanoCpus() nanoCpus} attribute.
     * @param nanoCpus The value for nanoCpus (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("NanoCpus")
    public final Builder nanoCpus(@Nullable Long nanoCpus) {
      this.nanoCpus = nanoCpus;
      return this;
    }

    /**
     * Initializes the value for the {@link HostConfig#cpuPeriod() cpuPeriod} attribute.
     * @param cpuPeriod The value for cpuPeriod (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("CpuPeriod")
    public final Builder cpuPeriod(@Nullable Long cpuPeriod) {
      this.cpuPeriod = cpuPeriod;
      return this;
    }

    /**
     * Initializes the value for the {@link HostConfig#cpuShares() cpuShares} attribute.
     * @param cpuShares The value for cpuShares (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("CpuShares")
    public final Builder cpuShares(@Nullable Long cpuShares) {
      this.cpuShares = cpuShares;
      return this;
    }

    /**
     * Initializes the value for the {@link HostConfig#cpusetCpus() cpusetCpus} attribute.
     * @param cpusetCpus The value for cpusetCpus (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("CpusetCpus")
    public final Builder cpusetCpus(@Nullable String cpusetCpus) {
      this.cpusetCpus = cpusetCpus;
      return this;
    }

    /**
     * Initializes the value for the {@link HostConfig#cpusetMems() cpusetMems} attribute.
     * @param cpusetMems The value for cpusetMems (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("CpusetMems")
    public final Builder cpusetMems(@Nullable String cpusetMems) {
      this.cpusetMems = cpusetMems;
      return this;
    }

    /**
     * Initializes the value for the {@link HostConfig#cpuQuota() cpuQuota} attribute.
     * @param cpuQuota The value for cpuQuota (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("CpuQuota")
    public final Builder cpuQuota(@Nullable Long cpuQuota) {
      this.cpuQuota = cpuQuota;
      return this;
    }

    /**
     * Initializes the value for the {@link HostConfig#cgroupParent() cgroupParent} attribute.
     * @param cgroupParent The value for cgroupParent (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("CgroupParent")
    public final Builder cgroupParent(@Nullable String cgroupParent) {
      this.cgroupParent = cgroupParent;
      return this;
    }

    /**
     * Initializes the value for the {@link HostConfig#restartPolicy() restartPolicy} attribute.
     * @param restartPolicy The value for restartPolicy (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("RestartPolicy")
    public final Builder restartPolicy(@Nullable HostConfig.RestartPolicy restartPolicy) {
      this.restartPolicy = restartPolicy;
      return this;
    }

    /**
     * Initializes the value for the {@link HostConfig#logConfig() logConfig} attribute.
     * @param logConfig The value for logConfig (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("LogConfig")
    public final Builder logConfig(@Nullable LogConfig logConfig) {
      this.logConfig = logConfig;
      return this;
    }

    /**
     * Initializes the value for the {@link HostConfig#ipcMode() ipcMode} attribute.
     * @param ipcMode The value for ipcMode (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("IpcMode")
    public final Builder ipcMode(@Nullable String ipcMode) {
      this.ipcMode = ipcMode;
      return this;
    }

    /**
     * Adds one element to {@link HostConfig#ulimits() ulimits} list.
     * @param element A ulimits element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder ulimit(HostConfig.Ulimit element) {
      if (this.ulimits == null) {
        this.ulimits = new ArrayList<HostConfig.Ulimit>();
      }
      this.ulimits.add(Objects.requireNonNull(element, "ulimits element"));
      return this;
    }

    /**
     * Adds elements to {@link HostConfig#ulimits() ulimits} list.
     * @param elements An array of ulimits elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder ulimits(HostConfig.Ulimit... elements) {
      if (this.ulimits == null) {
        this.ulimits = new ArrayList<HostConfig.Ulimit>();
      }
      for (HostConfig.Ulimit element : elements) {
        this.ulimits.add(Objects.requireNonNull(element, "ulimits element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link HostConfig#ulimits() ulimits} list.
     * @param elements An iterable of ulimits elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("Ulimits")
    public final Builder ulimits(@Nullable Iterable<? extends HostConfig.Ulimit> elements) {
      if (elements == null) {
        this.ulimits = null;
        return this;
      }
      this.ulimits = new ArrayList<HostConfig.Ulimit>();
      return addAllUlimits(elements);
    }

    /**
     * Adds elements to {@link HostConfig#ulimits() ulimits} list.
     * @param elements An iterable of ulimits elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllUlimits(Iterable<? extends HostConfig.Ulimit> elements) {
      Objects.requireNonNull(elements, "ulimits element");
      if (this.ulimits == null) {
        this.ulimits = new ArrayList<HostConfig.Ulimit>();
      }
      for (HostConfig.Ulimit element : elements) {
        this.ulimits.add(Objects.requireNonNull(element, "ulimits element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link HostConfig#pidMode() pidMode} attribute.
     * @param pidMode The value for pidMode (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("PidMode")
    public final Builder pidMode(@Nullable String pidMode) {
      this.pidMode = pidMode;
      return this;
    }

    /**
     * Initializes the value for the {@link HostConfig#shmSize() shmSize} attribute.
     * @param shmSize The value for shmSize (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("ShmSize")
    public final Builder shmSize(@Nullable Long shmSize) {
      this.shmSize = shmSize;
      return this;
    }

    /**
     * Initializes the value for the {@link HostConfig#oomKillDisable() oomKillDisable} attribute.
     * @param oomKillDisable The value for oomKillDisable (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("OomKillDisable")
    public final Builder oomKillDisable(@Nullable Boolean oomKillDisable) {
      this.oomKillDisable = oomKillDisable;
      return this;
    }

    /**
     * Initializes the value for the {@link HostConfig#oomScoreAdj() oomScoreAdj} attribute.
     * @param oomScoreAdj The value for oomScoreAdj (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("OomScoreAdj")
    public final Builder oomScoreAdj(@Nullable Integer oomScoreAdj) {
      this.oomScoreAdj = oomScoreAdj;
      return this;
    }

    /**
     * Initializes the value for the {@link HostConfig#autoRemove() autoRemove} attribute.
     * @param autoRemove The value for autoRemove (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("AutoRemove")
    public final Builder autoRemove(@Nullable Boolean autoRemove) {
      this.autoRemove = autoRemove;
      return this;
    }

    /**
     * Initializes the value for the {@link HostConfig#pidsLimit() pidsLimit} attribute.
     * @param pidsLimit The value for pidsLimit (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("PidsLimit")
    public final Builder pidsLimit(@Nullable Integer pidsLimit) {
      this.pidsLimit = pidsLimit;
      return this;
    }

    /**
     * Put one entry to the {@link HostConfig#tmpfs() tmpfs} map.
     * @param key The key in the tmpfs map
     * @param value The associated value in the tmpfs map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addTmpf(String key, String value) {
      if (this.tmpfs == null) {
        this.tmpfs = new LinkedHashMap<String, String>();
      }
      this.tmpfs.put(
          Objects.requireNonNull(key, "tmpfs key"),
          value == null ? Objects.requireNonNull(value, "tmpfs value for key: " + key) : value);
      return this;
    }

    /**
     * Put one entry to the {@link HostConfig#tmpfs() tmpfs} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addTmpf(Map.Entry<String, ? extends String> entry) {
      if (this.tmpfs == null) {
        this.tmpfs = new LinkedHashMap<String, String>();
      }
      String k = entry.getKey();
      String v = entry.getValue();
      this.tmpfs.put(
          Objects.requireNonNull(k, "tmpfs key"),
          v == null ? Objects.requireNonNull(v, "tmpfs value for key: " + k) : v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link HostConfig#tmpfs() tmpfs} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the tmpfs map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("Tmpfs")
    public final Builder tmpfs(@Nullable Map<String, ? extends String> entries) {
      if (entries == null) {
        this.tmpfs = null;
        return this;
      }
      this.tmpfs = new LinkedHashMap<String, String>();
      return putAllTmpfs(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link HostConfig#tmpfs() tmpfs} map. Nulls are not permitted
     * @param entries The entries that will be added to the tmpfs map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllTmpfs(Map<String, ? extends String> entries) {
      if (this.tmpfs == null) {
        this.tmpfs = new LinkedHashMap<String, String>();
      }
      for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
        String k = e.getKey();
        String v = e.getValue();
        this.tmpfs.put(
            Objects.requireNonNull(k, "tmpfs key"),
            v == null ? Objects.requireNonNull(v, "tmpfs value for key: " + k) : v);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link HostConfig#readonlyRootfs() readonlyRootfs} attribute.
     * @param readonlyRootfs The value for readonlyRootfs (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("ReadonlyRootfs")
    public final Builder readonlyRootfs(@Nullable Boolean readonlyRootfs) {
      this.readonlyRootfs = readonlyRootfs;
      return this;
    }

    /**
     * Put one entry to the {@link HostConfig#storageOpt() storageOpt} map.
     * @param key The key in the storageOpt map
     * @param value The associated value in the storageOpt map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addStorageOpt(String key, String value) {
      if (this.storageOpt == null) {
        this.storageOpt = new LinkedHashMap<String, String>();
      }
      this.storageOpt.put(
          Objects.requireNonNull(key, "storageOpt key"),
          value == null ? Objects.requireNonNull(value, "storageOpt value for key: " + key) : value);
      return this;
    }

    /**
     * Put one entry to the {@link HostConfig#storageOpt() storageOpt} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addStorageOpt(Map.Entry<String, ? extends String> entry) {
      if (this.storageOpt == null) {
        this.storageOpt = new LinkedHashMap<String, String>();
      }
      String k = entry.getKey();
      String v = entry.getValue();
      this.storageOpt.put(
          Objects.requireNonNull(k, "storageOpt key"),
          v == null ? Objects.requireNonNull(v, "storageOpt value for key: " + k) : v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link HostConfig#storageOpt() storageOpt} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the storageOpt map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("StorageOpt")
    public final Builder storageOpt(@Nullable Map<String, ? extends String> entries) {
      if (entries == null) {
        this.storageOpt = null;
        return this;
      }
      this.storageOpt = new LinkedHashMap<String, String>();
      return putAllStorageOpt(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link HostConfig#storageOpt() storageOpt} map. Nulls are not permitted
     * @param entries The entries that will be added to the storageOpt map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllStorageOpt(Map<String, ? extends String> entries) {
      if (this.storageOpt == null) {
        this.storageOpt = new LinkedHashMap<String, String>();
      }
      for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
        String k = e.getKey();
        String v = e.getValue();
        this.storageOpt.put(
            Objects.requireNonNull(k, "storageOpt key"),
            v == null ? Objects.requireNonNull(v, "storageOpt value for key: " + k) : v);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link HostConfig#runtime() runtime} attribute.
     * @param runtime The value for runtime (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("Runtime")
    public final Builder runtime(@Nullable String runtime) {
      this.runtime = runtime;
      return this;
    }

    /**
     * Adds one element to {@link HostConfig#mounts() mounts} list.
     * @param element A mounts element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder mount(Mount element) {
      if (this.mounts == null) {
        this.mounts = new ArrayList<Mount>();
      }
      this.mounts.add(Objects.requireNonNull(element, "mounts element"));
      return this;
    }

    /**
     * Adds elements to {@link HostConfig#mounts() mounts} list.
     * @param elements An array of mounts elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder mounts(Mount... elements) {
      if (this.mounts == null) {
        this.mounts = new ArrayList<Mount>();
      }
      for (Mount element : elements) {
        this.mounts.add(Objects.requireNonNull(element, "mounts element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link HostConfig#mounts() mounts} list.
     * @param elements An iterable of mounts elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("Mounts")
    public final Builder mounts(@Nullable Iterable<? extends Mount> elements) {
      if (elements == null) {
        this.mounts = null;
        return this;
      }
      this.mounts = new ArrayList<Mount>();
      return addAllMounts(elements);
    }

    /**
     * Adds elements to {@link HostConfig#mounts() mounts} list.
     * @param elements An iterable of mounts elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllMounts(Iterable<? extends Mount> elements) {
      Objects.requireNonNull(elements, "mounts element");
      if (this.mounts == null) {
        this.mounts = new ArrayList<Mount>();
      }
      for (Mount element : elements) {
        this.mounts.add(Objects.requireNonNull(element, "mounts element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link HostConfig#init() init} attribute.
     * @param init The value for init (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("Init")
    public final Builder init(@Nullable Boolean init) {
      this.init = init;
      return this;
    }

    /**
     * Put one entry to the {@link HostConfig#sysctls() sysctls} map.
     * @param key The key in the sysctls map
     * @param value The associated value in the sysctls map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addSysctl(String key, String value) {
      this.sysctls.put(
          Objects.requireNonNull(key, "sysctls key"),
          value == null ? Objects.requireNonNull(value, "sysctls value for key: " + key) : value);
      return this;
    }

    /**
     * Put one entry to the {@link HostConfig#sysctls() sysctls} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addSysctl(Map.Entry<String, ? extends String> entry) {
      String k = entry.getKey();
      String v = entry.getValue();
      this.sysctls.put(
          Objects.requireNonNull(k, "sysctls key"),
          v == null ? Objects.requireNonNull(v, "sysctls value for key: " + k) : v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link HostConfig#sysctls() sysctls} map. Nulls are not permitted
     * @param entries The entries that will be added to the sysctls map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("Sysctls")
    public final Builder sysctls(Map<String, ? extends String> entries) {
      this.sysctls.clear();
      return putAllSysctls(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link HostConfig#sysctls() sysctls} map. Nulls are not permitted
     * @param entries The entries that will be added to the sysctls map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllSysctls(Map<String, ? extends String> entries) {
      for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
        String k = e.getKey();
        String v = e.getValue();
        this.sysctls.put(
            Objects.requireNonNull(k, "sysctls key"),
            v == null ? Objects.requireNonNull(v, "sysctls value for key: " + k) : v);
      }
      return this;
    }

    /**
     * Adds one element to {@link HostConfig#deviceRequests() deviceRequests} list.
     * @param element A deviceRequests element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder deviceRequest(HostConfig.DeviceRequest element) {
      if (this.deviceRequests == null) {
        this.deviceRequests = new ArrayList<HostConfig.DeviceRequest>();
      }
      this.deviceRequests.add(Objects.requireNonNull(element, "deviceRequests element"));
      return this;
    }

    /**
     * Adds elements to {@link HostConfig#deviceRequests() deviceRequests} list.
     * @param elements An array of deviceRequests elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder deviceRequests(HostConfig.DeviceRequest... elements) {
      if (this.deviceRequests == null) {
        this.deviceRequests = new ArrayList<HostConfig.DeviceRequest>();
      }
      for (HostConfig.DeviceRequest element : elements) {
        this.deviceRequests.add(Objects.requireNonNull(element, "deviceRequests element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link HostConfig#deviceRequests() deviceRequests} list.
     * @param elements An iterable of deviceRequests elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("DeviceRequests")
    public final Builder deviceRequests(@Nullable Iterable<? extends HostConfig.DeviceRequest> elements) {
      if (elements == null) {
        this.deviceRequests = null;
        return this;
      }
      this.deviceRequests = new ArrayList<HostConfig.DeviceRequest>();
      return addAllDeviceRequests(elements);
    }

    /**
     * Adds elements to {@link HostConfig#deviceRequests() deviceRequests} list.
     * @param elements An iterable of deviceRequests elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllDeviceRequests(Iterable<? extends HostConfig.DeviceRequest> elements) {
      Objects.requireNonNull(elements, "deviceRequests element");
      if (this.deviceRequests == null) {
        this.deviceRequests = new ArrayList<HostConfig.DeviceRequest>();
      }
      for (HostConfig.DeviceRequest element : elements) {
        this.deviceRequests.add(Objects.requireNonNull(element, "deviceRequests element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableHostConfig ImmutableHostConfig}.
     * @return An immutable instance of HostConfig
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableHostConfig build() {
      return ImmutableHostConfig.validate(new ImmutableHostConfig(
          binds == null ? null : createUnmodifiableList(true, binds),
          blkioWeight,
          blkioWeightDevice == null ? null : createUnmodifiableList(true, blkioWeightDevice),
          blkioDeviceReadBps == null ? null : createUnmodifiableList(true, blkioDeviceReadBps),
          blkioDeviceWriteBps == null ? null : createUnmodifiableList(true, blkioDeviceWriteBps),
          blkioDeviceReadIOps == null ? null : createUnmodifiableList(true, blkioDeviceReadIOps),
          blkioDeviceWriteIOps == null ? null : createUnmodifiableList(true, blkioDeviceWriteIOps),
          containerIdFile,
          lxcConf == null ? null : createUnmodifiableList(true, lxcConf),
          privileged,
          portBindings == null ? null : createUnmodifiableMap(false, false, portBindings),
          links == null ? null : createUnmodifiableList(true, links),
          publishAllPorts,
          dns == null ? null : createUnmodifiableList(true, dns),
          dnsOptions == null ? null : createUnmodifiableList(true, dnsOptions),
          dnsSearch == null ? null : createUnmodifiableList(true, dnsSearch),
          extraHosts == null ? null : createUnmodifiableList(true, extraHosts),
          groupAdd == null ? null : createUnmodifiableList(true, groupAdd),
          volumesFrom == null ? null : createUnmodifiableList(true, volumesFrom),
          capAdd == null ? null : createUnmodifiableList(true, capAdd),
          capDrop == null ? null : createUnmodifiableList(true, capDrop),
          networkMode,
          securityOpt == null ? null : createUnmodifiableList(true, securityOpt),
          devices == null ? null : createUnmodifiableList(true, devices),
          memory,
          memorySwap,
          kernelMemory,
          memorySwappiness,
          memoryReservation,
          nanoCpus,
          cpuPeriod,
          cpuShares,
          cpusetCpus,
          cpusetMems,
          cpuQuota,
          cgroupParent,
          restartPolicy,
          logConfig,
          ipcMode,
          ulimits == null ? null : createUnmodifiableList(true, ulimits),
          pidMode,
          shmSize,
          oomKillDisable,
          oomScoreAdj,
          autoRemove,
          pidsLimit,
          tmpfs == null ? null : createUnmodifiableMap(false, false, tmpfs),
          readonlyRootfs,
          storageOpt == null ? null : createUnmodifiableMap(false, false, storageOpt),
          runtime,
          mounts == null ? null : createUnmodifiableList(true, mounts),
          init,
          createUnmodifiableMap(false, false, sysctls),
          deviceRequests == null ? null : createUnmodifiableList(true, deviceRequests)));
    }
  }

  /**
   * Immutable implementation of {@link HostConfig.LxcConfParameter}.
   * <p>
   * Use the builder to create immutable instances:
   * {@code ImmutableHostConfig.LxcConfParameter.builder()}.
   */
  static final class LxcConfParameter implements HostConfig.LxcConfParameter {
    private final String key;
    private final String value;

    private LxcConfParameter(String key, String value) {
      this.key = key;
      this.value = value;
    }

    /**
     * @return The value of the {@code key} attribute
     */
    @JsonProperty("Key")
    @Override
    public String key() {
      return key;
    }

    /**
     * @return The value of the {@code value} attribute
     */
    @JsonProperty("Value")
    @Override
    public String value() {
      return value;
    }

    /**
     * Copy the current immutable object by setting a value for the {@link HostConfig.LxcConfParameter#key() key} attribute.
     * An equals check used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for key
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableHostConfig.LxcConfParameter withKey(String value) {
      String newValue = Objects.requireNonNull(value, "key");
      if (this.key.equals(newValue)) return this;
      return new ImmutableHostConfig.LxcConfParameter(newValue, this.value);
    }

    /**
     * Copy the current immutable object by setting a value for the {@link HostConfig.LxcConfParameter#value() value} attribute.
     * An equals check used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for value
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableHostConfig.LxcConfParameter withValue(String value) {
      String newValue = Objects.requireNonNull(value, "value");
      if (this.value.equals(newValue)) return this;
      return new ImmutableHostConfig.LxcConfParameter(this.key, newValue);
    }

    /**
     * This instance is equal to all instances of {@code LxcConfParameter} that have equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(Object another) {
      if (this == another) return true;
      return another instanceof ImmutableHostConfig.LxcConfParameter
          && equalTo(0, (ImmutableHostConfig.LxcConfParameter) another);
    }

    private boolean equalTo(int synthetic, ImmutableHostConfig.LxcConfParameter another) {
      return key.equals(another.key)
          && value.equals(another.value);
    }

    /**
     * Computes a hash code from attributes: {@code key}, {@code value}.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      int h = 5381;
      h += (h << 5) + key.hashCode();
      h += (h << 5) + value.hashCode();
      return h;
    }

    /**
     * Prints the immutable value {@code LxcConfParameter} with attribute values.
     * @return A string representation of the value
     */
    @Override
    public String toString() {
      return "LxcConfParameter{"
          + "key=" + key
          + ", value=" + value
          + "}";
    }

    /**
     * Creates an immutable copy of a {@link HostConfig.LxcConfParameter} value.
     * Uses accessors to get values to initialize the new immutable instance.
     * If an instance is already immutable, it is returned as is.
     * @param instance The instance to copy
     * @return A copied immutable LxcConfParameter instance
     */
    public static ImmutableHostConfig.LxcConfParameter copyOf(HostConfig.LxcConfParameter instance) {
      if (instance instanceof ImmutableHostConfig.LxcConfParameter) {
        return (ImmutableHostConfig.LxcConfParameter) instance;
      }
      return ImmutableHostConfig.LxcConfParameter.builder()
          .from(instance)
          .build();
    }

    /**
     * Creates a builder for {@link ImmutableHostConfig.LxcConfParameter LxcConfParameter}.
     * <pre>
     * ImmutableHostConfig.LxcConfParameter.builder()
     *    .key(String) // required {@link HostConfig.LxcConfParameter#key() key}
     *    .value(String) // required {@link HostConfig.LxcConfParameter#value() value}
     *    .build();
     * </pre>
     * @return A new LxcConfParameter builder
     */
    public static ImmutableHostConfig.LxcConfParameter.Builder builder() {
      return new ImmutableHostConfig.LxcConfParameter.Builder();
    }

    /**
     * Builds instances of type {@link ImmutableHostConfig.LxcConfParameter LxcConfParameter}.
     * Initialize attributes and then invoke the {@link #build()} method to create an
     * immutable instance.
     * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
     * but instead used immediately to create instances.</em>
     */
    static final class Builder {
      private static final long INIT_BIT_KEY = 0x1L;
      private static final long INIT_BIT_VALUE = 0x2L;
      private long initBits = 0x3L;

      private String key;
      private String value;

      private Builder() {
      }

      /**
       * Fill a builder with attribute values from the provided {@code LxcConfParameter} instance.
       * Regular attribute values will be replaced with those from the given instance.
       * Absent optional values will not replace present values.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder from(HostConfig.LxcConfParameter instance) {
        Objects.requireNonNull(instance, "instance");
        key(instance.key());
        value(instance.value());
        return this;
      }

      /**
       * Initializes the value for the {@link HostConfig.LxcConfParameter#key() key} attribute.
       * @param key The value for key 
       * @return {@code this} builder for use in a chained invocation
       */
      @JsonProperty("Key")
      public final Builder key(String key) {
        this.key = Objects.requireNonNull(key, "key");
        initBits &= ~INIT_BIT_KEY;
        return this;
      }

      /**
       * Initializes the value for the {@link HostConfig.LxcConfParameter#value() value} attribute.
       * @param value The value for value 
       * @return {@code this} builder for use in a chained invocation
       */
      @JsonProperty("Value")
      public final Builder value(String value) {
        this.value = Objects.requireNonNull(value, "value");
        initBits &= ~INIT_BIT_VALUE;
        return this;
      }

      /**
       * Builds a new {@link ImmutableHostConfig.LxcConfParameter LxcConfParameter}.
       * @return An immutable instance of LxcConfParameter
       * @throws java.lang.IllegalStateException if any required attributes are missing
       */
      public ImmutableHostConfig.LxcConfParameter build() {
        if (initBits != 0) {
          throw new IllegalStateException(formatRequiredAttributesMessage());
        }
        return new ImmutableHostConfig.LxcConfParameter(key, value);
      }

      private String formatRequiredAttributesMessage() {
        List<String> attributes = new ArrayList<>();
        if ((initBits & INIT_BIT_KEY) != 0) attributes.add("key");
        if ((initBits & INIT_BIT_VALUE) != 0) attributes.add("value");
        return "Cannot build LxcConfParameter, some of required attributes are not set " + attributes;
      }
    }
  }

  /**
   * Immutable implementation of {@link HostConfig.RestartPolicy}.
   * <p>
   * Use the builder to create immutable instances:
   * {@code ImmutableHostConfig.RestartPolicy.builder()}.
   */
  static final class RestartPolicy implements HostConfig.RestartPolicy {
    private final String name;
    private final @Nullable Integer maxRetryCount;

    private RestartPolicy(String name, @Nullable Integer maxRetryCount) {
      this.name = name;
      this.maxRetryCount = maxRetryCount;
    }

    /**
     * @return The value of the {@code name} attribute
     */
    @JsonProperty("Name")
    @Override
    public String name() {
      return name;
    }

    /**
     * @return The value of the {@code maxRetryCount} attribute
     */
    @JsonProperty("MaximumRetryCount")
    @Override
    public @Nullable Integer maxRetryCount() {
      return maxRetryCount;
    }

    /**
     * Copy the current immutable object by setting a value for the {@link HostConfig.RestartPolicy#name() name} attribute.
     * An equals check used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for name
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableHostConfig.RestartPolicy withName(String value) {
      String newValue = Objects.requireNonNull(value, "name");
      if (this.name.equals(newValue)) return this;
      return new ImmutableHostConfig.RestartPolicy(newValue, this.maxRetryCount);
    }

    /**
     * Copy the current immutable object by setting a value for the {@link HostConfig.RestartPolicy#maxRetryCount() maxRetryCount} attribute.
     * An equals check used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for maxRetryCount (can be {@code null})
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableHostConfig.RestartPolicy withMaxRetryCount(@Nullable Integer value) {
      if (Objects.equals(this.maxRetryCount, value)) return this;
      return new ImmutableHostConfig.RestartPolicy(this.name, value);
    }

    /**
     * This instance is equal to all instances of {@code RestartPolicy} that have equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(Object another) {
      if (this == another) return true;
      return another instanceof ImmutableHostConfig.RestartPolicy
          && equalTo(0, (ImmutableHostConfig.RestartPolicy) another);
    }

    private boolean equalTo(int synthetic, ImmutableHostConfig.RestartPolicy another) {
      return name.equals(another.name)
          && Objects.equals(maxRetryCount, another.maxRetryCount);
    }

    /**
     * Computes a hash code from attributes: {@code name}, {@code maxRetryCount}.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      int h = 5381;
      h += (h << 5) + name.hashCode();
      h += (h << 5) + Objects.hashCode(maxRetryCount);
      return h;
    }

    /**
     * Prints the immutable value {@code RestartPolicy} with attribute values.
     * @return A string representation of the value
     */
    @Override
    public String toString() {
      return "RestartPolicy{"
          + "name=" + name
          + ", maxRetryCount=" + maxRetryCount
          + "}";
    }

    /**
     * Creates an immutable copy of a {@link HostConfig.RestartPolicy} value.
     * Uses accessors to get values to initialize the new immutable instance.
     * If an instance is already immutable, it is returned as is.
     * @param instance The instance to copy
     * @return A copied immutable RestartPolicy instance
     */
    public static ImmutableHostConfig.RestartPolicy copyOf(HostConfig.RestartPolicy instance) {
      if (instance instanceof ImmutableHostConfig.RestartPolicy) {
        return (ImmutableHostConfig.RestartPolicy) instance;
      }
      return ImmutableHostConfig.RestartPolicy.builder()
          .from(instance)
          .build();
    }

    /**
     * Creates a builder for {@link ImmutableHostConfig.RestartPolicy RestartPolicy}.
     * <pre>
     * ImmutableHostConfig.RestartPolicy.builder()
     *    .name(String) // required {@link HostConfig.RestartPolicy#name() name}
     *    .maxRetryCount(Integer | null) // nullable {@link HostConfig.RestartPolicy#maxRetryCount() maxRetryCount}
     *    .build();
     * </pre>
     * @return A new RestartPolicy builder
     */
    public static ImmutableHostConfig.RestartPolicy.Builder builder() {
      return new ImmutableHostConfig.RestartPolicy.Builder();
    }

    /**
     * Builds instances of type {@link ImmutableHostConfig.RestartPolicy RestartPolicy}.
     * Initialize attributes and then invoke the {@link #build()} method to create an
     * immutable instance.
     * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
     * but instead used immediately to create instances.</em>
     */
    static final class Builder {
      private static final long INIT_BIT_NAME = 0x1L;
      private long initBits = 0x1L;

      private String name;
      private Integer maxRetryCount;

      private Builder() {
      }

      /**
       * Fill a builder with attribute values from the provided {@code RestartPolicy} instance.
       * Regular attribute values will be replaced with those from the given instance.
       * Absent optional values will not replace present values.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder from(HostConfig.RestartPolicy instance) {
        Objects.requireNonNull(instance, "instance");
        name(instance.name());
        @Nullable Integer maxRetryCountValue = instance.maxRetryCount();
        if (maxRetryCountValue != null) {
          maxRetryCount(maxRetryCountValue);
        }
        return this;
      }

      /**
       * Initializes the value for the {@link HostConfig.RestartPolicy#name() name} attribute.
       * @param name The value for name 
       * @return {@code this} builder for use in a chained invocation
       */
      @JsonProperty("Name")
      public final Builder name(String name) {
        this.name = Objects.requireNonNull(name, "name");
        initBits &= ~INIT_BIT_NAME;
        return this;
      }

      /**
       * Initializes the value for the {@link HostConfig.RestartPolicy#maxRetryCount() maxRetryCount} attribute.
       * @param maxRetryCount The value for maxRetryCount (can be {@code null})
       * @return {@code this} builder for use in a chained invocation
       */
      @JsonProperty("MaximumRetryCount")
      public final Builder maxRetryCount(@Nullable Integer maxRetryCount) {
        this.maxRetryCount = maxRetryCount;
        return this;
      }

      /**
       * Builds a new {@link ImmutableHostConfig.RestartPolicy RestartPolicy}.
       * @return An immutable instance of RestartPolicy
       * @throws java.lang.IllegalStateException if any required attributes are missing
       */
      public ImmutableHostConfig.RestartPolicy build() {
        if (initBits != 0) {
          throw new IllegalStateException(formatRequiredAttributesMessage());
        }
        return new ImmutableHostConfig.RestartPolicy(name, maxRetryCount);
      }

      private String formatRequiredAttributesMessage() {
        List<String> attributes = new ArrayList<>();
        if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
        return "Cannot build RestartPolicy, some of required attributes are not set " + attributes;
      }
    }
  }

  /**
   * Immutable implementation of {@link HostConfig.Bind}.
   * <p>
   * Use the builder to create immutable instances:
   * {@code ImmutableHostConfig.Bind.builder()}.
   */
  static final class Bind implements HostConfig.Bind {
    private final String to;
    private final String from;
    private final boolean readOnly;
    private final @Nullable Boolean noCopy;
    private final @Nullable Boolean selinuxLabeling;
    private transient final String representation;

    private Bind(ImmutableHostConfig.Bind.Builder builder) {
      this.to = builder.to;
      this.from = builder.from;
      this.noCopy = builder.noCopy;
      this.selinuxLabeling = builder.selinuxLabeling;
      if (builder.readOnlyIsSet()) {
        initShim.readOnly(builder.readOnly);
      }
      this.readOnly = initShim.readOnly();
      this.representation = initShim.representation();
      this.initShim = null;
    }

    private Bind(
        String to,
        String from,
        boolean readOnly,
        @Nullable Boolean noCopy,
        @Nullable Boolean selinuxLabeling) {
      this.to = to;
      this.from = from;
      initShim.readOnly(readOnly);
      this.noCopy = noCopy;
      this.selinuxLabeling = selinuxLabeling;
      this.readOnly = initShim.readOnly();
      this.representation = initShim.representation();
      this.initShim = null;
    }

    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private transient volatile InitShim initShim = new InitShim();

    private final class InitShim {
      private byte readOnlyBuildStage = STAGE_UNINITIALIZED;
      private boolean readOnly;

      boolean readOnly() {
        if (readOnlyBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
        if (readOnlyBuildStage == STAGE_UNINITIALIZED) {
          readOnlyBuildStage = STAGE_INITIALIZING;
          this.readOnly = readOnlyInitialize();
          readOnlyBuildStage = STAGE_INITIALIZED;
        }
        return this.readOnly;
      }

      void readOnly(boolean readOnly) {
        this.readOnly = readOnly;
        readOnlyBuildStage = STAGE_INITIALIZED;
      }

      private byte representationBuildStage = STAGE_UNINITIALIZED;
      private String representation;

      String representation() {
        if (representationBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
        if (representationBuildStage == STAGE_UNINITIALIZED) {
          representationBuildStage = STAGE_INITIALIZING;
          this.representation = Objects.requireNonNull(representationInitialize(), "representation");
          representationBuildStage = STAGE_INITIALIZED;
        }
        return this.representation;
      }

      private String formatInitCycleMessage() {
        List<String> attributes = new ArrayList<>();
        if (readOnlyBuildStage == STAGE_INITIALIZING) attributes.add("readOnly");
        if (representationBuildStage == STAGE_INITIALIZING) attributes.add("representation");
        return "Cannot build Bind, attribute initializers form cycle " + attributes;
      }
    }

    private boolean readOnlyInitialize() {
      return HostConfig.Bind.super.readOnly();
    }

    private String representationInitialize() {
      return HostConfig.Bind.super.representation();
    }

    /**
     * @return The value of the {@code to} attribute
     */
    @JsonProperty("to")
    @Override
    public String to() {
      return to;
    }

    /**
     * @return The value of the {@code from} attribute
     */
    @JsonProperty("from")
    @Override
    public String from() {
      return from;
    }

    /**
     * @return The value of the {@code readOnly} attribute
     */
    @JsonProperty("readOnly")
    @Override
    public boolean readOnly() {
      InitShim shim = this.initShim;
      return shim != null
          ? shim.readOnly()
          : this.readOnly;
    }

    /**
     * @return The value of the {@code noCopy} attribute
     */
    @JsonProperty("noCopy")
    @Override
    public @Nullable Boolean noCopy() {
      return noCopy;
    }

    /**
     * @return The value of the {@code selinuxLabeling} attribute
     */
    @JsonProperty("selinuxLabeling")
    @Override
    public @Nullable Boolean selinuxLabeling() {
      return selinuxLabeling;
    }

    /**
     * @return The computed-at-construction value of the {@code representation} attribute
     */
    @JsonProperty("representation")
    @JsonIgnore
    @Override
    public String representation() {
      InitShim shim = this.initShim;
      return shim != null
          ? shim.representation()
          : this.representation;
    }

    /**
     * Copy the current immutable object by setting a value for the {@link HostConfig.Bind#to() to} attribute.
     * An equals check used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for to
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableHostConfig.Bind withTo(String value) {
      String newValue = Objects.requireNonNull(value, "to");
      if (this.to.equals(newValue)) return this;
      return new ImmutableHostConfig.Bind(newValue, this.from, this.readOnly, this.noCopy, this.selinuxLabeling);
    }

    /**
     * Copy the current immutable object by setting a value for the {@link HostConfig.Bind#from() from} attribute.
     * An equals check used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for from
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableHostConfig.Bind withFrom(String value) {
      String newValue = Objects.requireNonNull(value, "from");
      if (this.from.equals(newValue)) return this;
      return new ImmutableHostConfig.Bind(this.to, newValue, this.readOnly, this.noCopy, this.selinuxLabeling);
    }

    /**
     * Copy the current immutable object by setting a value for the {@link HostConfig.Bind#readOnly() readOnly} attribute.
     * A value equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for readOnly
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableHostConfig.Bind withReadOnly(boolean value) {
      if (this.readOnly == value) return this;
      return new ImmutableHostConfig.Bind(this.to, this.from, value, this.noCopy, this.selinuxLabeling);
    }

    /**
     * Copy the current immutable object by setting a value for the {@link HostConfig.Bind#noCopy() noCopy} attribute.
     * An equals check used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for noCopy (can be {@code null})
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableHostConfig.Bind withNoCopy(@Nullable Boolean value) {
      if (Objects.equals(this.noCopy, value)) return this;
      return new ImmutableHostConfig.Bind(this.to, this.from, this.readOnly, value, this.selinuxLabeling);
    }

    /**
     * Copy the current immutable object by setting a value for the {@link HostConfig.Bind#selinuxLabeling() selinuxLabeling} attribute.
     * An equals check used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for selinuxLabeling (can be {@code null})
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableHostConfig.Bind withSelinuxLabeling(@Nullable Boolean value) {
      if (Objects.equals(this.selinuxLabeling, value)) return this;
      return new ImmutableHostConfig.Bind(this.to, this.from, this.readOnly, this.noCopy, value);
    }

    /**
     * This instance is equal to all instances of {@code Bind} that have equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(Object another) {
      if (this == another) return true;
      return another instanceof ImmutableHostConfig.Bind
          && equalTo(0, (ImmutableHostConfig.Bind) another);
    }

    private boolean equalTo(int synthetic, ImmutableHostConfig.Bind another) {
      return to.equals(another.to)
          && from.equals(another.from)
          && readOnly == another.readOnly
          && Objects.equals(noCopy, another.noCopy)
          && Objects.equals(selinuxLabeling, another.selinuxLabeling)
          && representation.equals(another.representation);
    }

    /**
     * Computes a hash code from attributes: {@code to}, {@code from}, {@code readOnly}, {@code noCopy}, {@code selinuxLabeling}, {@code representation}.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      int h = 5381;
      h += (h << 5) + to.hashCode();
      h += (h << 5) + from.hashCode();
      h += (h << 5) + Boolean.hashCode(readOnly);
      h += (h << 5) + Objects.hashCode(noCopy);
      h += (h << 5) + Objects.hashCode(selinuxLabeling);
      h += (h << 5) + representation.hashCode();
      return h;
    }

    /**
     * Prints the immutable value {@code Bind} with attribute values.
     * @return A string representation of the value
     */
    @Override
    public String toString() {
      return "Bind{"
          + "to=" + to
          + ", from=" + from
          + ", readOnly=" + readOnly
          + ", noCopy=" + noCopy
          + ", selinuxLabeling=" + selinuxLabeling
          + ", representation=" + representation
          + "}";
    }

    /**
     * Creates an immutable copy of a {@link HostConfig.Bind} value.
     * Uses accessors to get values to initialize the new immutable instance.
     * If an instance is already immutable, it is returned as is.
     * @param instance The instance to copy
     * @return A copied immutable Bind instance
     */
    public static ImmutableHostConfig.Bind copyOf(HostConfig.Bind instance) {
      if (instance instanceof ImmutableHostConfig.Bind) {
        return (ImmutableHostConfig.Bind) instance;
      }
      return ImmutableHostConfig.Bind.builder()
          .to(instance.to())
          .from(instance.from())
          .readOnly(instance.readOnly())
          .noCopy(instance.noCopy())
          .selinuxLabeling(instance.selinuxLabeling())
          .build();
    }

    /**
     * Creates a builder for {@link ImmutableHostConfig.Bind Bind}.
     * <pre>
     * ImmutableHostConfig.Bind.builder()
     *    .to(String) // required {@link HostConfig.Bind#to() to}
     *    .from(String) // required {@link HostConfig.Bind#from() from}
     *    .readOnly(boolean) // optional {@link HostConfig.Bind#readOnly() readOnly}
     *    .noCopy(Boolean | null) // nullable {@link HostConfig.Bind#noCopy() noCopy}
     *    .selinuxLabeling(Boolean | null) // nullable {@link HostConfig.Bind#selinuxLabeling() selinuxLabeling}
     *    .build();
     * </pre>
     * @return A new Bind builder
     */
    public static ImmutableHostConfig.Bind.Builder builder() {
      return new ImmutableHostConfig.Bind.Builder();
    }

    /**
     * Builds instances of type {@link ImmutableHostConfig.Bind Bind}.
     * Initialize attributes and then invoke the {@link #build()} method to create an
     * immutable instance.
     * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
     * but instead used immediately to create instances.</em>
     */
    static final class Builder implements HostConfig.Bind.Builder {
      private static final long INIT_BIT_TO = 0x1L;
      private static final long INIT_BIT_FROM = 0x2L;
      private static final long OPT_BIT_READ_ONLY = 0x1L;
      private long initBits = 0x3L;
      private long optBits;

      private String to;
      private String from;
      private boolean readOnly;
      private Boolean noCopy;
      private Boolean selinuxLabeling;

      private Builder() {
      }

      /**
       * Initializes the value for the {@link HostConfig.Bind#to() to} attribute.
       * @param to The value for to 
       * @return {@code this} builder for use in a chained invocation
       */
      @JsonProperty("to")
      public final Builder to(String to) {
        this.to = Objects.requireNonNull(to, "to");
        initBits &= ~INIT_BIT_TO;
        return this;
      }

      /**
       * Initializes the value for the {@link HostConfig.Bind#from() from} attribute.
       * @param from The value for from 
       * @return {@code this} builder for use in a chained invocation
       */
      @JsonProperty("from")
      public final Builder from(String from) {
        this.from = Objects.requireNonNull(from, "from");
        initBits &= ~INIT_BIT_FROM;
        return this;
      }

      /**
       * Initializes the value for the {@link HostConfig.Bind#readOnly() readOnly} attribute.
       * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link HostConfig.Bind#readOnly() readOnly}.</em>
       * @param readOnly The value for readOnly 
       * @return {@code this} builder for use in a chained invocation
       */
      @JsonProperty("readOnly")
      public final Builder readOnly(boolean readOnly) {
        this.readOnly = readOnly;
        optBits |= OPT_BIT_READ_ONLY;
        return this;
      }

      /**
       * Initializes the value for the {@link HostConfig.Bind#noCopy() noCopy} attribute.
       * @param noCopy The value for noCopy (can be {@code null})
       * @return {@code this} builder for use in a chained invocation
       */
      @JsonProperty("noCopy")
      public final Builder noCopy(@Nullable Boolean noCopy) {
        this.noCopy = noCopy;
        return this;
      }

      /**
       * Initializes the value for the {@link HostConfig.Bind#selinuxLabeling() selinuxLabeling} attribute.
       * @param selinuxLabeling The value for selinuxLabeling (can be {@code null})
       * @return {@code this} builder for use in a chained invocation
       */
      @JsonProperty("selinuxLabeling")
      public final Builder selinuxLabeling(@Nullable Boolean selinuxLabeling) {
        this.selinuxLabeling = selinuxLabeling;
        return this;
      }

      /**
       * Builds a new {@link ImmutableHostConfig.Bind Bind}.
       * @return An immutable instance of Bind
       * @throws java.lang.IllegalStateException if any required attributes are missing
       */
      public ImmutableHostConfig.Bind build() {
        if (initBits != 0) {
          throw new IllegalStateException(formatRequiredAttributesMessage());
        }
        return new ImmutableHostConfig.Bind(this);
      }

      private boolean readOnlyIsSet() {
        return (optBits & OPT_BIT_READ_ONLY) != 0;
      }

      private String formatRequiredAttributesMessage() {
        List<String> attributes = new ArrayList<>();
        if ((initBits & INIT_BIT_TO) != 0) attributes.add("to");
        if ((initBits & INIT_BIT_FROM) != 0) attributes.add("from");
        return "Cannot build Bind, some of required attributes are not set " + attributes;
      }
    }
  }

  /**
   * Immutable implementation of {@link HostConfig.Ulimit}.
   * <p>
   * Use the builder to create immutable instances:
   * {@code ImmutableHostConfig.Ulimit.builder()}.
   */
  static final class Ulimit implements HostConfig.Ulimit {
    private final String name;
    private final Long soft;
    private final Long hard;

    private Ulimit(String name, Long soft, Long hard) {
      this.name = name;
      this.soft = soft;
      this.hard = hard;
    }

    /**
     * @return The value of the {@code name} attribute
     */
    @JsonProperty("Name")
    @Override
    public String name() {
      return name;
    }

    /**
     * @return The value of the {@code soft} attribute
     */
    @JsonProperty("Soft")
    @Override
    public Long soft() {
      return soft;
    }

    /**
     * @return The value of the {@code hard} attribute
     */
    @JsonProperty("Hard")
    @Override
    public Long hard() {
      return hard;
    }

    /**
     * Copy the current immutable object by setting a value for the {@link HostConfig.Ulimit#name() name} attribute.
     * An equals check used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for name
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableHostConfig.Ulimit withName(String value) {
      String newValue = Objects.requireNonNull(value, "name");
      if (this.name.equals(newValue)) return this;
      return new ImmutableHostConfig.Ulimit(newValue, this.soft, this.hard);
    }

    /**
     * Copy the current immutable object by setting a value for the {@link HostConfig.Ulimit#soft() soft} attribute.
     * An equals check used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for soft
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableHostConfig.Ulimit withSoft(Long value) {
      Long newValue = Objects.requireNonNull(value, "soft");
      if (this.soft.equals(newValue)) return this;
      return new ImmutableHostConfig.Ulimit(this.name, newValue, this.hard);
    }

    /**
     * Copy the current immutable object by setting a value for the {@link HostConfig.Ulimit#hard() hard} attribute.
     * An equals check used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for hard
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableHostConfig.Ulimit withHard(Long value) {
      Long newValue = Objects.requireNonNull(value, "hard");
      if (this.hard.equals(newValue)) return this;
      return new ImmutableHostConfig.Ulimit(this.name, this.soft, newValue);
    }

    /**
     * This instance is equal to all instances of {@code Ulimit} that have equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(Object another) {
      if (this == another) return true;
      return another instanceof ImmutableHostConfig.Ulimit
          && equalTo(0, (ImmutableHostConfig.Ulimit) another);
    }

    private boolean equalTo(int synthetic, ImmutableHostConfig.Ulimit another) {
      return name.equals(another.name)
          && soft.equals(another.soft)
          && hard.equals(another.hard);
    }

    /**
     * Computes a hash code from attributes: {@code name}, {@code soft}, {@code hard}.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      int h = 5381;
      h += (h << 5) + name.hashCode();
      h += (h << 5) + soft.hashCode();
      h += (h << 5) + hard.hashCode();
      return h;
    }

    /**
     * Prints the immutable value {@code Ulimit} with attribute values.
     * @return A string representation of the value
     */
    @Override
    public String toString() {
      return "Ulimit{"
          + "name=" + name
          + ", soft=" + soft
          + ", hard=" + hard
          + "}";
    }

    /**
     * Creates an immutable copy of a {@link HostConfig.Ulimit} value.
     * Uses accessors to get values to initialize the new immutable instance.
     * If an instance is already immutable, it is returned as is.
     * @param instance The instance to copy
     * @return A copied immutable Ulimit instance
     */
    public static ImmutableHostConfig.Ulimit copyOf(HostConfig.Ulimit instance) {
      if (instance instanceof ImmutableHostConfig.Ulimit) {
        return (ImmutableHostConfig.Ulimit) instance;
      }
      return ImmutableHostConfig.Ulimit.builder()
          .from(instance)
          .build();
    }

    /**
     * Creates a builder for {@link ImmutableHostConfig.Ulimit Ulimit}.
     * <pre>
     * ImmutableHostConfig.Ulimit.builder()
     *    .name(String) // required {@link HostConfig.Ulimit#name() name}
     *    .soft(Long) // required {@link HostConfig.Ulimit#soft() soft}
     *    .hard(Long) // required {@link HostConfig.Ulimit#hard() hard}
     *    .build();
     * </pre>
     * @return A new Ulimit builder
     */
    public static ImmutableHostConfig.Ulimit.Builder builder() {
      return new ImmutableHostConfig.Ulimit.Builder();
    }

    /**
     * Builds instances of type {@link ImmutableHostConfig.Ulimit Ulimit}.
     * Initialize attributes and then invoke the {@link #build()} method to create an
     * immutable instance.
     * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
     * but instead used immediately to create instances.</em>
     */
    static final class Builder implements HostConfig.Ulimit.Builder {
      private static final long INIT_BIT_NAME = 0x1L;
      private static final long INIT_BIT_SOFT = 0x2L;
      private static final long INIT_BIT_HARD = 0x4L;
      private long initBits = 0x7L;

      private String name;
      private Long soft;
      private Long hard;

      private Builder() {
      }

      /**
       * Fill a builder with attribute values from the provided {@code Ulimit} instance.
       * Regular attribute values will be replaced with those from the given instance.
       * Absent optional values will not replace present values.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder from(HostConfig.Ulimit instance) {
        Objects.requireNonNull(instance, "instance");
        name(instance.name());
        soft(instance.soft());
        hard(instance.hard());
        return this;
      }

      /**
       * Initializes the value for the {@link HostConfig.Ulimit#name() name} attribute.
       * @param name The value for name 
       * @return {@code this} builder for use in a chained invocation
       */
      @JsonProperty("Name")
      public final Builder name(String name) {
        this.name = Objects.requireNonNull(name, "name");
        initBits &= ~INIT_BIT_NAME;
        return this;
      }

      /**
       * Initializes the value for the {@link HostConfig.Ulimit#soft() soft} attribute.
       * @param soft The value for soft 
       * @return {@code this} builder for use in a chained invocation
       */
      @JsonProperty("Soft")
      public final Builder soft(Long soft) {
        this.soft = Objects.requireNonNull(soft, "soft");
        initBits &= ~INIT_BIT_SOFT;
        return this;
      }

      /**
       * Initializes the value for the {@link HostConfig.Ulimit#hard() hard} attribute.
       * @param hard The value for hard 
       * @return {@code this} builder for use in a chained invocation
       */
      @JsonProperty("Hard")
      public final Builder hard(Long hard) {
        this.hard = Objects.requireNonNull(hard, "hard");
        initBits &= ~INIT_BIT_HARD;
        return this;
      }

      /**
       * Builds a new {@link ImmutableHostConfig.Ulimit Ulimit}.
       * @return An immutable instance of Ulimit
       * @throws java.lang.IllegalStateException if any required attributes are missing
       */
      public ImmutableHostConfig.Ulimit build() {
        if (initBits != 0) {
          throw new IllegalStateException(formatRequiredAttributesMessage());
        }
        return new ImmutableHostConfig.Ulimit(name, soft, hard);
      }

      private String formatRequiredAttributesMessage() {
        List<String> attributes = new ArrayList<>();
        if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
        if ((initBits & INIT_BIT_SOFT) != 0) attributes.add("soft");
        if ((initBits & INIT_BIT_HARD) != 0) attributes.add("hard");
        return "Cannot build Ulimit, some of required attributes are not set " + attributes;
      }
    }
  }

  /**
   * Immutable implementation of {@link HostConfig.BlkioWeightDevice}.
   * <p>
   * Use the builder to create immutable instances:
   * {@code ImmutableHostConfig.BlkioWeightDevice.builder()}.
   */
  static final class BlkioWeightDevice
      implements HostConfig.BlkioWeightDevice {
    private final String path;
    private final Integer weight;

    private BlkioWeightDevice(String path, Integer weight) {
      this.path = path;
      this.weight = weight;
    }

    /**
     * @return The value of the {@code path} attribute
     */
    @JsonProperty("Path")
    @Override
    public String path() {
      return path;
    }

    /**
     * @return The value of the {@code weight} attribute
     */
    @JsonProperty("Weight")
    @Override
    public Integer weight() {
      return weight;
    }

    /**
     * Copy the current immutable object by setting a value for the {@link HostConfig.BlkioWeightDevice#path() path} attribute.
     * An equals check used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for path
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableHostConfig.BlkioWeightDevice withPath(String value) {
      String newValue = Objects.requireNonNull(value, "path");
      if (this.path.equals(newValue)) return this;
      return new ImmutableHostConfig.BlkioWeightDevice(newValue, this.weight);
    }

    /**
     * Copy the current immutable object by setting a value for the {@link HostConfig.BlkioWeightDevice#weight() weight} attribute.
     * An equals check used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for weight
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableHostConfig.BlkioWeightDevice withWeight(Integer value) {
      Integer newValue = Objects.requireNonNull(value, "weight");
      if (this.weight.equals(newValue)) return this;
      return new ImmutableHostConfig.BlkioWeightDevice(this.path, newValue);
    }

    /**
     * This instance is equal to all instances of {@code BlkioWeightDevice} that have equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(Object another) {
      if (this == another) return true;
      return another instanceof ImmutableHostConfig.BlkioWeightDevice
          && equalTo(0, (ImmutableHostConfig.BlkioWeightDevice) another);
    }

    private boolean equalTo(int synthetic, ImmutableHostConfig.BlkioWeightDevice another) {
      return path.equals(another.path)
          && weight.equals(another.weight);
    }

    /**
     * Computes a hash code from attributes: {@code path}, {@code weight}.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      int h = 5381;
      h += (h << 5) + path.hashCode();
      h += (h << 5) + weight.hashCode();
      return h;
    }

    /**
     * Prints the immutable value {@code BlkioWeightDevice} with attribute values.
     * @return A string representation of the value
     */
    @Override
    public String toString() {
      return "BlkioWeightDevice{"
          + "path=" + path
          + ", weight=" + weight
          + "}";
    }

    /**
     * Creates an immutable copy of a {@link HostConfig.BlkioWeightDevice} value.
     * Uses accessors to get values to initialize the new immutable instance.
     * If an instance is already immutable, it is returned as is.
     * @param instance The instance to copy
     * @return A copied immutable BlkioWeightDevice instance
     */
    public static ImmutableHostConfig.BlkioWeightDevice copyOf(HostConfig.BlkioWeightDevice instance) {
      if (instance instanceof ImmutableHostConfig.BlkioWeightDevice) {
        return (ImmutableHostConfig.BlkioWeightDevice) instance;
      }
      return ImmutableHostConfig.BlkioWeightDevice.builder()
          .from(instance)
          .build();
    }

    /**
     * Creates a builder for {@link ImmutableHostConfig.BlkioWeightDevice BlkioWeightDevice}.
     * <pre>
     * ImmutableHostConfig.BlkioWeightDevice.builder()
     *    .path(String) // required {@link HostConfig.BlkioWeightDevice#path() path}
     *    .weight(Integer) // required {@link HostConfig.BlkioWeightDevice#weight() weight}
     *    .build();
     * </pre>
     * @return A new BlkioWeightDevice builder
     */
    public static ImmutableHostConfig.BlkioWeightDevice.Builder builder() {
      return new ImmutableHostConfig.BlkioWeightDevice.Builder();
    }

    /**
     * Builds instances of type {@link ImmutableHostConfig.BlkioWeightDevice BlkioWeightDevice}.
     * Initialize attributes and then invoke the {@link #build()} method to create an
     * immutable instance.
     * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
     * but instead used immediately to create instances.</em>
     */
    static final class Builder implements HostConfig.BlkioWeightDevice.Builder {
      private static final long INIT_BIT_PATH = 0x1L;
      private static final long INIT_BIT_WEIGHT = 0x2L;
      private long initBits = 0x3L;

      private String path;
      private Integer weight;

      private Builder() {
      }

      /**
       * Fill a builder with attribute values from the provided {@code BlkioWeightDevice} instance.
       * Regular attribute values will be replaced with those from the given instance.
       * Absent optional values will not replace present values.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder from(HostConfig.BlkioWeightDevice instance) {
        Objects.requireNonNull(instance, "instance");
        path(instance.path());
        weight(instance.weight());
        return this;
      }

      /**
       * Initializes the value for the {@link HostConfig.BlkioWeightDevice#path() path} attribute.
       * @param path The value for path 
       * @return {@code this} builder for use in a chained invocation
       */
      @JsonProperty("Path")
      public final Builder path(String path) {
        this.path = Objects.requireNonNull(path, "path");
        initBits &= ~INIT_BIT_PATH;
        return this;
      }

      /**
       * Initializes the value for the {@link HostConfig.BlkioWeightDevice#weight() weight} attribute.
       * @param weight The value for weight 
       * @return {@code this} builder for use in a chained invocation
       */
      @JsonProperty("Weight")
      public final Builder weight(Integer weight) {
        this.weight = Objects.requireNonNull(weight, "weight");
        initBits &= ~INIT_BIT_WEIGHT;
        return this;
      }

      /**
       * Builds a new {@link ImmutableHostConfig.BlkioWeightDevice BlkioWeightDevice}.
       * @return An immutable instance of BlkioWeightDevice
       * @throws java.lang.IllegalStateException if any required attributes are missing
       */
      public ImmutableHostConfig.BlkioWeightDevice build() {
        if (initBits != 0) {
          throw new IllegalStateException(formatRequiredAttributesMessage());
        }
        return new ImmutableHostConfig.BlkioWeightDevice(path, weight);
      }

      private String formatRequiredAttributesMessage() {
        List<String> attributes = new ArrayList<>();
        if ((initBits & INIT_BIT_PATH) != 0) attributes.add("path");
        if ((initBits & INIT_BIT_WEIGHT) != 0) attributes.add("weight");
        return "Cannot build BlkioWeightDevice, some of required attributes are not set " + attributes;
      }
    }
  }

  /**
   * Immutable implementation of {@link HostConfig.BlkioDeviceRate}.
   * <p>
   * Use the builder to create immutable instances:
   * {@code ImmutableHostConfig.BlkioDeviceRate.builder()}.
   */
  static final class BlkioDeviceRate implements HostConfig.BlkioDeviceRate {
    private final String path;
    private final Integer rate;

    private BlkioDeviceRate(String path, Integer rate) {
      this.path = path;
      this.rate = rate;
    }

    /**
     * @return The value of the {@code path} attribute
     */
    @JsonProperty("Path")
    @Override
    public String path() {
      return path;
    }

    /**
     * @return The value of the {@code rate} attribute
     */
    @JsonProperty("Rate")
    @Override
    public Integer rate() {
      return rate;
    }

    /**
     * Copy the current immutable object by setting a value for the {@link HostConfig.BlkioDeviceRate#path() path} attribute.
     * An equals check used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for path
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableHostConfig.BlkioDeviceRate withPath(String value) {
      String newValue = Objects.requireNonNull(value, "path");
      if (this.path.equals(newValue)) return this;
      return new ImmutableHostConfig.BlkioDeviceRate(newValue, this.rate);
    }

    /**
     * Copy the current immutable object by setting a value for the {@link HostConfig.BlkioDeviceRate#rate() rate} attribute.
     * An equals check used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for rate
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableHostConfig.BlkioDeviceRate withRate(Integer value) {
      Integer newValue = Objects.requireNonNull(value, "rate");
      if (this.rate.equals(newValue)) return this;
      return new ImmutableHostConfig.BlkioDeviceRate(this.path, newValue);
    }

    /**
     * This instance is equal to all instances of {@code BlkioDeviceRate} that have equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(Object another) {
      if (this == another) return true;
      return another instanceof ImmutableHostConfig.BlkioDeviceRate
          && equalTo(0, (ImmutableHostConfig.BlkioDeviceRate) another);
    }

    private boolean equalTo(int synthetic, ImmutableHostConfig.BlkioDeviceRate another) {
      return path.equals(another.path)
          && rate.equals(another.rate);
    }

    /**
     * Computes a hash code from attributes: {@code path}, {@code rate}.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      int h = 5381;
      h += (h << 5) + path.hashCode();
      h += (h << 5) + rate.hashCode();
      return h;
    }

    /**
     * Prints the immutable value {@code BlkioDeviceRate} with attribute values.
     * @return A string representation of the value
     */
    @Override
    public String toString() {
      return "BlkioDeviceRate{"
          + "path=" + path
          + ", rate=" + rate
          + "}";
    }

    /**
     * Creates an immutable copy of a {@link HostConfig.BlkioDeviceRate} value.
     * Uses accessors to get values to initialize the new immutable instance.
     * If an instance is already immutable, it is returned as is.
     * @param instance The instance to copy
     * @return A copied immutable BlkioDeviceRate instance
     */
    public static ImmutableHostConfig.BlkioDeviceRate copyOf(HostConfig.BlkioDeviceRate instance) {
      if (instance instanceof ImmutableHostConfig.BlkioDeviceRate) {
        return (ImmutableHostConfig.BlkioDeviceRate) instance;
      }
      return ImmutableHostConfig.BlkioDeviceRate.builder()
          .from(instance)
          .build();
    }

    /**
     * Creates a builder for {@link ImmutableHostConfig.BlkioDeviceRate BlkioDeviceRate}.
     * <pre>
     * ImmutableHostConfig.BlkioDeviceRate.builder()
     *    .path(String) // required {@link HostConfig.BlkioDeviceRate#path() path}
     *    .rate(Integer) // required {@link HostConfig.BlkioDeviceRate#rate() rate}
     *    .build();
     * </pre>
     * @return A new BlkioDeviceRate builder
     */
    public static ImmutableHostConfig.BlkioDeviceRate.Builder builder() {
      return new ImmutableHostConfig.BlkioDeviceRate.Builder();
    }

    /**
     * Builds instances of type {@link ImmutableHostConfig.BlkioDeviceRate BlkioDeviceRate}.
     * Initialize attributes and then invoke the {@link #build()} method to create an
     * immutable instance.
     * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
     * but instead used immediately to create instances.</em>
     */
    static final class Builder implements HostConfig.BlkioDeviceRate.Builder {
      private static final long INIT_BIT_PATH = 0x1L;
      private static final long INIT_BIT_RATE = 0x2L;
      private long initBits = 0x3L;

      private String path;
      private Integer rate;

      private Builder() {
      }

      /**
       * Fill a builder with attribute values from the provided {@code BlkioDeviceRate} instance.
       * Regular attribute values will be replaced with those from the given instance.
       * Absent optional values will not replace present values.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder from(HostConfig.BlkioDeviceRate instance) {
        Objects.requireNonNull(instance, "instance");
        path(instance.path());
        rate(instance.rate());
        return this;
      }

      /**
       * Initializes the value for the {@link HostConfig.BlkioDeviceRate#path() path} attribute.
       * @param path The value for path 
       * @return {@code this} builder for use in a chained invocation
       */
      @JsonProperty("Path")
      public final Builder path(String path) {
        this.path = Objects.requireNonNull(path, "path");
        initBits &= ~INIT_BIT_PATH;
        return this;
      }

      /**
       * Initializes the value for the {@link HostConfig.BlkioDeviceRate#rate() rate} attribute.
       * @param rate The value for rate 
       * @return {@code this} builder for use in a chained invocation
       */
      @JsonProperty("Rate")
      public final Builder rate(Integer rate) {
        this.rate = Objects.requireNonNull(rate, "rate");
        initBits &= ~INIT_BIT_RATE;
        return this;
      }

      /**
       * Builds a new {@link ImmutableHostConfig.BlkioDeviceRate BlkioDeviceRate}.
       * @return An immutable instance of BlkioDeviceRate
       * @throws java.lang.IllegalStateException if any required attributes are missing
       */
      public ImmutableHostConfig.BlkioDeviceRate build() {
        if (initBits != 0) {
          throw new IllegalStateException(formatRequiredAttributesMessage());
        }
        return new ImmutableHostConfig.BlkioDeviceRate(path, rate);
      }

      private String formatRequiredAttributesMessage() {
        List<String> attributes = new ArrayList<>();
        if ((initBits & INIT_BIT_PATH) != 0) attributes.add("path");
        if ((initBits & INIT_BIT_RATE) != 0) attributes.add("rate");
        return "Cannot build BlkioDeviceRate, some of required attributes are not set " + attributes;
      }
    }
  }

  /**
   * Immutable implementation of {@link HostConfig.DeviceRequest}.
   * <p>
   * Use the builder to create immutable instances:
   * {@code ImmutableHostConfig.DeviceRequest.builder()}.
   */
  static final class DeviceRequest implements HostConfig.DeviceRequest {
    private final String driver;
    private final Integer count;
    private final List<String> deviceIds;
    private final List<List<String>> capabilities;
    private final Map<String, String> options;

    private DeviceRequest(
        String driver,
        Integer count,
        List<String> deviceIds,
        List<List<String>> capabilities,
        Map<String, String> options) {
      this.driver = driver;
      this.count = count;
      this.deviceIds = deviceIds;
      this.capabilities = capabilities;
      this.options = options;
    }

    /**
     * @return The value of the {@code driver} attribute
     */
    @JsonProperty("Driver")
    @Override
    public String driver() {
      return driver;
    }

    /**
     * @return The value of the {@code count} attribute
     */
    @JsonProperty("Count")
    @Override
    public Integer count() {
      return count;
    }

    /**
     * @return The value of the {@code deviceIds} attribute
     */
    @JsonProperty("DeviceIDs")
    @Override
    public List<String> deviceIds() {
      return deviceIds;
    }

    /**
     * @return The value of the {@code capabilities} attribute
     */
    @JsonProperty("Capabilities")
    @Override
    public List<List<String>> capabilities() {
      return capabilities;
    }

    /**
     * @return The value of the {@code options} attribute
     */
    @JsonProperty("Options")
    @Override
    public Map<String, String> options() {
      return options;
    }

    /**
     * Copy the current immutable object by setting a value for the {@link HostConfig.DeviceRequest#driver() driver} attribute.
     * An equals check used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for driver
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableHostConfig.DeviceRequest withDriver(String value) {
      String newValue = Objects.requireNonNull(value, "driver");
      if (this.driver.equals(newValue)) return this;
      return new ImmutableHostConfig.DeviceRequest(newValue, this.count, this.deviceIds, this.capabilities, this.options);
    }

    /**
     * Copy the current immutable object by setting a value for the {@link HostConfig.DeviceRequest#count() count} attribute.
     * An equals check used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for count
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableHostConfig.DeviceRequest withCount(Integer value) {
      Integer newValue = Objects.requireNonNull(value, "count");
      if (this.count.equals(newValue)) return this;
      return new ImmutableHostConfig.DeviceRequest(this.driver, newValue, this.deviceIds, this.capabilities, this.options);
    }

    /**
     * Copy the current immutable object with elements that replace the content of {@link HostConfig.DeviceRequest#deviceIds() deviceIds}.
     * @param elements The elements to set
     * @return A modified copy of {@code this} object
     */
    public final ImmutableHostConfig.DeviceRequest withDeviceIds(String... elements) {
      List<String> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
      return new ImmutableHostConfig.DeviceRequest(this.driver, this.count, newValue, this.capabilities, this.options);
    }

    /**
     * Copy the current immutable object with elements that replace the content of {@link HostConfig.DeviceRequest#deviceIds() deviceIds}.
     * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param elements An iterable of deviceIds elements to set
     * @return A modified copy of {@code this} object
     */
    public final ImmutableHostConfig.DeviceRequest withDeviceIds(Iterable<String> elements) {
      if (this.deviceIds == elements) return this;
      List<String> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
      return new ImmutableHostConfig.DeviceRequest(this.driver, this.count, newValue, this.capabilities, this.options);
    }

    /**
     * Copy the current immutable object with elements that replace the content of {@link HostConfig.DeviceRequest#capabilities() capabilities}.
     * @param elements The elements to set
     * @return A modified copy of {@code this} object
     */
    @SafeVarargs @SuppressWarnings("varargs")
    public final ImmutableHostConfig.DeviceRequest withCapabilities(List<String>... elements) {
      List<List<String>> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
      return new ImmutableHostConfig.DeviceRequest(this.driver, this.count, this.deviceIds, newValue, this.options);
    }

    /**
     * Copy the current immutable object with elements that replace the content of {@link HostConfig.DeviceRequest#capabilities() capabilities}.
     * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param elements An iterable of capabilities elements to set
     * @return A modified copy of {@code this} object
     */
    public final ImmutableHostConfig.DeviceRequest withCapabilities(Iterable<? extends List<String>> elements) {
      if (this.capabilities == elements) return this;
      List<List<String>> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
      return new ImmutableHostConfig.DeviceRequest(this.driver, this.count, this.deviceIds, newValue, this.options);
    }

    /**
     * Copy the current immutable object by replacing the {@link HostConfig.DeviceRequest#options() options} map with the specified map.
     * Nulls are not permitted as keys or values.
     * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param entries The entries to be added to the options map
     * @return A modified copy of {@code this} object
     */
    public final ImmutableHostConfig.DeviceRequest withOptions(Map<String, ? extends String> entries) {
      if (this.options == entries) return this;
      Map<String, String> newValue = createUnmodifiableMap(true, false, entries);
      return new ImmutableHostConfig.DeviceRequest(this.driver, this.count, this.deviceIds, this.capabilities, newValue);
    }

    /**
     * This instance is equal to all instances of {@code DeviceRequest} that have equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(Object another) {
      if (this == another) return true;
      return another instanceof ImmutableHostConfig.DeviceRequest
          && equalTo(0, (ImmutableHostConfig.DeviceRequest) another);
    }

    private boolean equalTo(int synthetic, ImmutableHostConfig.DeviceRequest another) {
      return driver.equals(another.driver)
          && count.equals(another.count)
          && deviceIds.equals(another.deviceIds)
          && capabilities.equals(another.capabilities)
          && options.equals(another.options);
    }

    /**
     * Computes a hash code from attributes: {@code driver}, {@code count}, {@code deviceIds}, {@code capabilities}, {@code options}.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      int h = 5381;
      h += (h << 5) + driver.hashCode();
      h += (h << 5) + count.hashCode();
      h += (h << 5) + deviceIds.hashCode();
      h += (h << 5) + capabilities.hashCode();
      h += (h << 5) + options.hashCode();
      return h;
    }

    /**
     * Prints the immutable value {@code DeviceRequest} with attribute values.
     * @return A string representation of the value
     */
    @Override
    public String toString() {
      return "DeviceRequest{"
          + "driver=" + driver
          + ", count=" + count
          + ", deviceIds=" + deviceIds
          + ", capabilities=" + capabilities
          + ", options=" + options
          + "}";
    }

    /**
     * Creates an immutable copy of a {@link HostConfig.DeviceRequest} value.
     * Uses accessors to get values to initialize the new immutable instance.
     * If an instance is already immutable, it is returned as is.
     * @param instance The instance to copy
     * @return A copied immutable DeviceRequest instance
     */
    public static ImmutableHostConfig.DeviceRequest copyOf(HostConfig.DeviceRequest instance) {
      if (instance instanceof ImmutableHostConfig.DeviceRequest) {
        return (ImmutableHostConfig.DeviceRequest) instance;
      }
      return ImmutableHostConfig.DeviceRequest.builder()
          .from(instance)
          .build();
    }

    /**
     * Creates a builder for {@link ImmutableHostConfig.DeviceRequest DeviceRequest}.
     * <pre>
     * ImmutableHostConfig.DeviceRequest.builder()
     *    .driver(String) // required {@link HostConfig.DeviceRequest#driver() driver}
     *    .count(Integer) // required {@link HostConfig.DeviceRequest#count() count}
     *    .deviceId|addAllDeviceIds(String) // {@link HostConfig.DeviceRequest#deviceIds() deviceIds} elements
     *    .capability|addAllCapabilities(List&amp;lt;String&amp;gt;) // {@link HostConfig.DeviceRequest#capabilities() capabilities} elements
     *    .addOption|putAllOptions(String =&gt; String) // {@link HostConfig.DeviceRequest#options() options} mappings
     *    .build();
     * </pre>
     * @return A new DeviceRequest builder
     */
    public static ImmutableHostConfig.DeviceRequest.Builder builder() {
      return new ImmutableHostConfig.DeviceRequest.Builder();
    }

    /**
     * Builds instances of type {@link ImmutableHostConfig.DeviceRequest DeviceRequest}.
     * Initialize attributes and then invoke the {@link #build()} method to create an
     * immutable instance.
     * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
     * but instead used immediately to create instances.</em>
     */
    static final class Builder implements HostConfig.DeviceRequest.Builder {
      private static final long INIT_BIT_DRIVER = 0x1L;
      private static final long INIT_BIT_COUNT = 0x2L;
      private long initBits = 0x3L;

      private String driver;
      private Integer count;
      private List<String> deviceIds = new ArrayList<String>();
      private List<List<String>> capabilities = new ArrayList<List<String>>();
      private Map<String, String> options = new LinkedHashMap<String, String>();

      private Builder() {
      }

      /**
       * Fill a builder with attribute values from the provided {@code DeviceRequest} instance.
       * Regular attribute values will be replaced with those from the given instance.
       * Absent optional values will not replace present values.
       * Collection elements and entries will be added, not replaced.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder from(HostConfig.DeviceRequest instance) {
        Objects.requireNonNull(instance, "instance");
        driver(instance.driver());
        count(instance.count());
        addAllDeviceIds(instance.deviceIds());
        addAllCapabilities(instance.capabilities());
        putAllOptions(instance.options());
        return this;
      }

      /**
       * Initializes the value for the {@link HostConfig.DeviceRequest#driver() driver} attribute.
       * @param driver The value for driver 
       * @return {@code this} builder for use in a chained invocation
       */
      @JsonProperty("Driver")
      public final Builder driver(String driver) {
        this.driver = Objects.requireNonNull(driver, "driver");
        initBits &= ~INIT_BIT_DRIVER;
        return this;
      }

      /**
       * Initializes the value for the {@link HostConfig.DeviceRequest#count() count} attribute.
       * @param count The value for count 
       * @return {@code this} builder for use in a chained invocation
       */
      @JsonProperty("Count")
      public final Builder count(Integer count) {
        this.count = Objects.requireNonNull(count, "count");
        initBits &= ~INIT_BIT_COUNT;
        return this;
      }

      /**
       * Adds one element to {@link HostConfig.DeviceRequest#deviceIds() deviceIds} list.
       * @param element A deviceIds element
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder deviceId(String element) {
        this.deviceIds.add(Objects.requireNonNull(element, "deviceIds element"));
        return this;
      }

      /**
       * Adds elements to {@link HostConfig.DeviceRequest#deviceIds() deviceIds} list.
       * @param elements An array of deviceIds elements
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder deviceIds(String... elements) {
        for (String element : elements) {
          this.deviceIds.add(Objects.requireNonNull(element, "deviceIds element"));
        }
        return this;
      }


      /**
       * Sets or replaces all elements for {@link HostConfig.DeviceRequest#deviceIds() deviceIds} list.
       * @param elements An iterable of deviceIds elements
       * @return {@code this} builder for use in a chained invocation
       */
      @JsonProperty("DeviceIDs")
      public final Builder deviceIds(Iterable<String> elements) {
        this.deviceIds.clear();
        return addAllDeviceIds(elements);
      }

      /**
       * Adds elements to {@link HostConfig.DeviceRequest#deviceIds() deviceIds} list.
       * @param elements An iterable of deviceIds elements
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder addAllDeviceIds(Iterable<String> elements) {
        for (String element : elements) {
          this.deviceIds.add(Objects.requireNonNull(element, "deviceIds element"));
        }
        return this;
      }

      /**
       * Adds one element to {@link HostConfig.DeviceRequest#capabilities() capabilities} list.
       * @param element A capabilities element
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder capability(List<String> element) {
        this.capabilities.add(Objects.requireNonNull(element, "capabilities element"));
        return this;
      }

      /**
       * Adds elements to {@link HostConfig.DeviceRequest#capabilities() capabilities} list.
       * @param elements An array of capabilities elements
       * @return {@code this} builder for use in a chained invocation
       */
      @SafeVarargs @SuppressWarnings("varargs")
      public final Builder capabilities(List<String>... elements) {
        for (List<String> element : elements) {
          this.capabilities.add(Objects.requireNonNull(element, "capabilities element"));
        }
        return this;
      }


      /**
       * Sets or replaces all elements for {@link HostConfig.DeviceRequest#capabilities() capabilities} list.
       * @param elements An iterable of capabilities elements
       * @return {@code this} builder for use in a chained invocation
       */
      @JsonProperty("Capabilities")
      public final Builder capabilities(Iterable<? extends List<String>> elements) {
        this.capabilities.clear();
        return addAllCapabilities(elements);
      }

      /**
       * Adds elements to {@link HostConfig.DeviceRequest#capabilities() capabilities} list.
       * @param elements An iterable of capabilities elements
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder addAllCapabilities(Iterable<? extends List<String>> elements) {
        for (List<String> element : elements) {
          this.capabilities.add(Objects.requireNonNull(element, "capabilities element"));
        }
        return this;
      }

      /**
       * Put one entry to the {@link HostConfig.DeviceRequest#options() options} map.
       * @param key The key in the options map
       * @param value The associated value in the options map
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder addOption(String key, String value) {
        this.options.put(
            Objects.requireNonNull(key, "options key"),
            value == null ? Objects.requireNonNull(value, "options value for key: " + key) : value);
        return this;
      }

      /**
       * Put one entry to the {@link HostConfig.DeviceRequest#options() options} map. Nulls are not permitted
       * @param entry The key and value entry
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder addOption(Map.Entry<String, ? extends String> entry) {
        String k = entry.getKey();
        String v = entry.getValue();
        this.options.put(
            Objects.requireNonNull(k, "options key"),
            v == null ? Objects.requireNonNull(v, "options value for key: " + k) : v);
        return this;
      }

      /**
       * Sets or replaces all mappings from the specified map as entries for the {@link HostConfig.DeviceRequest#options() options} map. Nulls are not permitted
       * @param entries The entries that will be added to the options map
       * @return {@code this} builder for use in a chained invocation
       */
      @JsonProperty("Options")
      public final Builder options(Map<String, ? extends String> entries) {
        this.options.clear();
        return putAllOptions(entries);
      }

      /**
       * Put all mappings from the specified map as entries to {@link HostConfig.DeviceRequest#options() options} map. Nulls are not permitted
       * @param entries The entries that will be added to the options map
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder putAllOptions(Map<String, ? extends String> entries) {
        for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
          String k = e.getKey();
          String v = e.getValue();
          this.options.put(
              Objects.requireNonNull(k, "options key"),
              v == null ? Objects.requireNonNull(v, "options value for key: " + k) : v);
        }
        return this;
      }

      /**
       * Builds a new {@link ImmutableHostConfig.DeviceRequest DeviceRequest}.
       * @return An immutable instance of DeviceRequest
       * @throws java.lang.IllegalStateException if any required attributes are missing
       */
      public ImmutableHostConfig.DeviceRequest build() {
        if (initBits != 0) {
          throw new IllegalStateException(formatRequiredAttributesMessage());
        }
        return new ImmutableHostConfig.DeviceRequest(
            driver,
            count,
            createUnmodifiableList(true, deviceIds),
            createUnmodifiableList(true, capabilities),
            createUnmodifiableMap(false, false, options));
      }

      private String formatRequiredAttributesMessage() {
        List<String> attributes = new ArrayList<>();
        if ((initBits & INIT_BIT_DRIVER) != 0) attributes.add("driver");
        if ((initBits & INIT_BIT_COUNT) != 0) attributes.add("count");
        return "Cannot build DeviceRequest, some of required attributes are not set " + attributes;
      }
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        if (v == null) Objects.requireNonNull(v, "value for key: " + k);
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            if (v == null) Objects.requireNonNull(v, "value for key: " + k);
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
