/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages.swarm;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.mandas.docker.Nullable;
import org.mandas.docker.client.messages.swarm.NodeSpec;

final class ImmutableNodeSpec
implements NodeSpec {
    @Nullable
    private final String name;
    @Nullable
    private final Map<String, String> labels;
    private final String role;
    private final String availability;

    private ImmutableNodeSpec(@Nullable String name, @Nullable Map<String, String> labels, String role, String availability) {
        this.name = name;
        this.labels = labels;
        this.role = role;
        this.availability = availability;
    }

    @Override
    @JsonProperty(value="Name")
    @Nullable
    public String name() {
        return this.name;
    }

    @Override
    @JsonProperty(value="Labels")
    @Nullable
    public Map<String, String> labels() {
        return this.labels;
    }

    @Override
    @JsonProperty(value="Role")
    public String role() {
        return this.role;
    }

    @Override
    @JsonProperty(value="Availability")
    public String availability() {
        return this.availability;
    }

    public final ImmutableNodeSpec withName(@Nullable String value) {
        if (Objects.equals(this.name, value)) {
            return this;
        }
        return new ImmutableNodeSpec(value, this.labels, this.role, this.availability);
    }

    public final ImmutableNodeSpec withLabels(@Nullable Map<String, ? extends String> entries) {
        if (this.labels == entries) {
            return this;
        }
        Map<String, String> newValue = entries == null ? null : ImmutableNodeSpec.createUnmodifiableMap(true, false, entries);
        return new ImmutableNodeSpec(this.name, newValue, this.role, this.availability);
    }

    public final ImmutableNodeSpec withRole(String value) {
        String newValue = Objects.requireNonNull(value, "role");
        if (this.role.equals(newValue)) {
            return this;
        }
        return new ImmutableNodeSpec(this.name, this.labels, newValue, this.availability);
    }

    public final ImmutableNodeSpec withAvailability(String value) {
        String newValue = Objects.requireNonNull(value, "availability");
        if (this.availability.equals(newValue)) {
            return this;
        }
        return new ImmutableNodeSpec(this.name, this.labels, this.role, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableNodeSpec && this.equalTo((ImmutableNodeSpec)another);
    }

    private boolean equalTo(ImmutableNodeSpec another) {
        return Objects.equals(this.name, another.name) && Objects.equals(this.labels, another.labels) && this.role.equals(another.role) && this.availability.equals(another.availability);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.name);
        h += (h << 5) + Objects.hashCode(this.labels);
        h += (h << 5) + this.role.hashCode();
        h += (h << 5) + this.availability.hashCode();
        return h;
    }

    public String toString() {
        return "NodeSpec{name=" + this.name + ", labels=" + this.labels + ", role=" + this.role + ", availability=" + this.availability + "}";
    }

    public static ImmutableNodeSpec copyOf(NodeSpec instance) {
        if (instance instanceof ImmutableNodeSpec) {
            return (ImmutableNodeSpec)instance;
        }
        return ImmutableNodeSpec.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    static final class Builder
    implements NodeSpec.Builder {
        private static final long INIT_BIT_ROLE = 1L;
        private static final long INIT_BIT_AVAILABILITY = 2L;
        private long initBits = 3L;
        private String name;
        private Map<String, String> labels = null;
        private String role;
        private String availability;

        private Builder() {
        }

        public final Builder from(NodeSpec instance) {
            Map<String, String> labelsValue;
            Objects.requireNonNull(instance, "instance");
            String nameValue = instance.name();
            if (nameValue != null) {
                this.name(nameValue);
            }
            if ((labelsValue = instance.labels()) != null) {
                this.putAllLabels(labelsValue);
            }
            this.role(instance.role());
            this.availability(instance.availability());
            return this;
        }

        @Override
        @JsonProperty(value="Name")
        public final Builder name(@Nullable String name) {
            this.name = name;
            return this;
        }

        @Override
        public final Builder addLabel(String key, String value) {
            if (this.labels == null) {
                this.labels = new LinkedHashMap<String, String>();
            }
            this.labels.put(Objects.requireNonNull(key, "labels key"), Objects.requireNonNull(value, "labels value"));
            return this;
        }

        public final Builder addLabel(Map.Entry<String, ? extends String> entry) {
            if (this.labels == null) {
                this.labels = new LinkedHashMap<String, String>();
            }
            String k = entry.getKey();
            String v = entry.getValue();
            this.labels.put(Objects.requireNonNull(k, "labels key"), Objects.requireNonNull(v, "labels value"));
            return this;
        }

        @Override
        @JsonProperty(value="Labels")
        public final Builder labels(@Nullable Map<String, ? extends String> entries) {
            if (entries == null) {
                this.labels = null;
                return this;
            }
            this.labels = new LinkedHashMap<String, String>();
            return this.putAllLabels(entries);
        }

        public final Builder putAllLabels(Map<String, ? extends String> entries) {
            if (this.labels == null) {
                this.labels = new LinkedHashMap<String, String>();
            }
            for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
                String k = e.getKey();
                String v = e.getValue();
                this.labels.put(Objects.requireNonNull(k, "labels key"), Objects.requireNonNull(v, "labels value"));
            }
            return this;
        }

        @Override
        @JsonProperty(value="Role")
        public final Builder role(String role) {
            this.role = Objects.requireNonNull(role, "role");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @Override
        @JsonProperty(value="Availability")
        public final Builder availability(String availability) {
            this.availability = Objects.requireNonNull(availability, "availability");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @Override
        public ImmutableNodeSpec build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableNodeSpec(this.name, this.labels == null ? null : ImmutableNodeSpec.createUnmodifiableMap(false, false, this.labels), this.role, this.availability);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("role");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("availability");
            }
            return "Cannot build NodeSpec, some of required attributes are not set " + attributes;
        }
    }
}

