package org.mandas.docker.client.messages.swarm;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import org.mandas.docker.Nullable;

/**
 * Immutable implementation of {@link ContainerStatus}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableContainerStatus.builder()}.
 */
@SuppressWarnings({"all"})
final class ImmutableContainerStatus implements ContainerStatus {
  private final @Nullable String containerId;
  private final @Nullable Integer pid;
  private final @Nullable Long exitCode;

  private ImmutableContainerStatus(
      @Nullable String containerId,
      @Nullable Integer pid,
      @Nullable Long exitCode) {
    this.containerId = containerId;
    this.pid = pid;
    this.exitCode = exitCode;
  }

  /**
   * @return The value of the {@code containerId} attribute
   */
  @JsonProperty("ContainerID")
  @Override
  public @Nullable String containerId() {
    return containerId;
  }

  /**
   * @return The value of the {@code pid} attribute
   */
  @JsonProperty("PID")
  @Override
  public @Nullable Integer pid() {
    return pid;
  }

  /**
   * @return The value of the {@code exitCode} attribute
   */
  @JsonProperty("ExitCode")
  @Override
  public @Nullable Long exitCode() {
    return exitCode;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ContainerStatus#containerId() containerId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for containerId (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableContainerStatus withContainerId(@Nullable String value) {
    if (Objects.equals(this.containerId, value)) return this;
    return new ImmutableContainerStatus(value, this.pid, this.exitCode);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ContainerStatus#pid() pid} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for pid (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableContainerStatus withPid(@Nullable Integer value) {
    if (Objects.equals(this.pid, value)) return this;
    return new ImmutableContainerStatus(this.containerId, value, this.exitCode);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ContainerStatus#exitCode() exitCode} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for exitCode (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableContainerStatus withExitCode(@Nullable Long value) {
    if (Objects.equals(this.exitCode, value)) return this;
    return new ImmutableContainerStatus(this.containerId, this.pid, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableContainerStatus} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableContainerStatus
        && equalTo((ImmutableContainerStatus) another);
  }

  private boolean equalTo(ImmutableContainerStatus another) {
    return Objects.equals(containerId, another.containerId)
        && Objects.equals(pid, another.pid)
        && Objects.equals(exitCode, another.exitCode);
  }

  /**
   * Computes a hash code from attributes: {@code containerId}, {@code pid}, {@code exitCode}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(containerId);
    h += (h << 5) + Objects.hashCode(pid);
    h += (h << 5) + Objects.hashCode(exitCode);
    return h;
  }

  /**
   * Prints the immutable value {@code ContainerStatus} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ContainerStatus{"
        + "containerId=" + containerId
        + ", pid=" + pid
        + ", exitCode=" + exitCode
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link ContainerStatus} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ContainerStatus instance
   */
  public static ImmutableContainerStatus copyOf(ContainerStatus instance) {
    if (instance instanceof ImmutableContainerStatus) {
      return (ImmutableContainerStatus) instance;
    }
    return ImmutableContainerStatus.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableContainerStatus ImmutableContainerStatus}.
   * <pre>
   * ImmutableContainerStatus.builder()
   *    .containerId(String | null) // nullable {@link ContainerStatus#containerId() containerId}
   *    .pid(Integer | null) // nullable {@link ContainerStatus#pid() pid}
   *    .exitCode(Long | null) // nullable {@link ContainerStatus#exitCode() exitCode}
   *    .build();
   * </pre>
   * @return A new ImmutableContainerStatus builder
   */
  public static ImmutableContainerStatus.Builder builder() {
    return new ImmutableContainerStatus.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableContainerStatus ImmutableContainerStatus}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  static final class Builder {
    private String containerId;
    private Integer pid;
    private Long exitCode;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ContainerStatus} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ContainerStatus instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable String containerIdValue = instance.containerId();
      if (containerIdValue != null) {
        containerId(containerIdValue);
      }
      @Nullable Integer pidValue = instance.pid();
      if (pidValue != null) {
        pid(pidValue);
      }
      @Nullable Long exitCodeValue = instance.exitCode();
      if (exitCodeValue != null) {
        exitCode(exitCodeValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ContainerStatus#containerId() containerId} attribute.
     * @param containerId The value for containerId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("ContainerID")
    public final Builder containerId(@Nullable String containerId) {
      this.containerId = containerId;
      return this;
    }

    /**
     * Initializes the value for the {@link ContainerStatus#pid() pid} attribute.
     * @param pid The value for pid (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("PID")
    public final Builder pid(@Nullable Integer pid) {
      this.pid = pid;
      return this;
    }

    /**
     * Initializes the value for the {@link ContainerStatus#exitCode() exitCode} attribute.
     * @param exitCode The value for exitCode (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("ExitCode")
    public final Builder exitCode(@Nullable Long exitCode) {
      this.exitCode = exitCode;
      return this;
    }

    /**
     * Builds a new {@link ImmutableContainerStatus ImmutableContainerStatus}.
     * @return An immutable instance of ContainerStatus
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableContainerStatus build() {
      return new ImmutableContainerStatus(containerId, pid, exitCode);
    }
  }
}
