package org.mandas.docker.client.messages.mount;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import org.mandas.docker.Nullable;

/**
 * Immutable implementation of {@link TmpfsOptions}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableTmpfsOptions.builder()}.
 */
@SuppressWarnings({"all"})
final class ImmutableTmpfsOptions implements TmpfsOptions {
  private final @Nullable Long sizeBytes;
  private final @Nullable Integer mode;

  private ImmutableTmpfsOptions(
      @Nullable Long sizeBytes,
      @Nullable Integer mode) {
    this.sizeBytes = sizeBytes;
    this.mode = mode;
  }

  /**
   * @return The value of the {@code sizeBytes} attribute
   */
  @JsonProperty("SizeBytes")
  @Override
  public @Nullable Long sizeBytes() {
    return sizeBytes;
  }

  /**
   * @return The value of the {@code mode} attribute
   */
  @JsonProperty("Mode")
  @Override
  public @Nullable Integer mode() {
    return mode;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TmpfsOptions#sizeBytes() sizeBytes} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for sizeBytes (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTmpfsOptions withSizeBytes(@Nullable Long value) {
    if (Objects.equals(this.sizeBytes, value)) return this;
    return new ImmutableTmpfsOptions(value, this.mode);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TmpfsOptions#mode() mode} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for mode (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTmpfsOptions withMode(@Nullable Integer value) {
    if (Objects.equals(this.mode, value)) return this;
    return new ImmutableTmpfsOptions(this.sizeBytes, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableTmpfsOptions} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableTmpfsOptions
        && equalTo((ImmutableTmpfsOptions) another);
  }

  private boolean equalTo(ImmutableTmpfsOptions another) {
    return Objects.equals(sizeBytes, another.sizeBytes)
        && Objects.equals(mode, another.mode);
  }

  /**
   * Computes a hash code from attributes: {@code sizeBytes}, {@code mode}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(sizeBytes);
    h += (h << 5) + Objects.hashCode(mode);
    return h;
  }

  /**
   * Prints the immutable value {@code TmpfsOptions} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "TmpfsOptions{"
        + "sizeBytes=" + sizeBytes
        + ", mode=" + mode
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link TmpfsOptions} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable TmpfsOptions instance
   */
  public static ImmutableTmpfsOptions copyOf(TmpfsOptions instance) {
    if (instance instanceof ImmutableTmpfsOptions) {
      return (ImmutableTmpfsOptions) instance;
    }
    return ImmutableTmpfsOptions.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableTmpfsOptions ImmutableTmpfsOptions}.
   * <pre>
   * ImmutableTmpfsOptions.builder()
   *    .sizeBytes(Long | null) // nullable {@link TmpfsOptions#sizeBytes() sizeBytes}
   *    .mode(Integer | null) // nullable {@link TmpfsOptions#mode() mode}
   *    .build();
   * </pre>
   * @return A new ImmutableTmpfsOptions builder
   */
  public static ImmutableTmpfsOptions.Builder builder() {
    return new ImmutableTmpfsOptions.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableTmpfsOptions ImmutableTmpfsOptions}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  static final class Builder implements TmpfsOptions.Builder {
    private Long sizeBytes;
    private Integer mode;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code TmpfsOptions} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(TmpfsOptions instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable Long sizeBytesValue = instance.sizeBytes();
      if (sizeBytesValue != null) {
        sizeBytes(sizeBytesValue);
      }
      @Nullable Integer modeValue = instance.mode();
      if (modeValue != null) {
        mode(modeValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link TmpfsOptions#sizeBytes() sizeBytes} attribute.
     * @param sizeBytes The value for sizeBytes (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("SizeBytes")
    public final Builder sizeBytes(@Nullable Long sizeBytes) {
      this.sizeBytes = sizeBytes;
      return this;
    }

    /**
     * Initializes the value for the {@link TmpfsOptions#mode() mode} attribute.
     * @param mode The value for mode (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("Mode")
    public final Builder mode(@Nullable Integer mode) {
      this.mode = mode;
      return this;
    }

    /**
     * Builds a new {@link ImmutableTmpfsOptions ImmutableTmpfsOptions}.
     * @return An immutable instance of TmpfsOptions
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableTmpfsOptions build() {
      return new ImmutableTmpfsOptions(sizeBytes, mode);
    }
  }
}
