package org.mandas.docker.client.messages;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.mandas.docker.Nullable;
import org.mandas.docker.client.messages.swarm.SwarmInfo;

/**
 * Immutable implementation of {@link Info}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableInfo.builder()}.
 */
@SuppressWarnings({"all", "deprecation"})
final class ImmutableInfo implements Info {
  private final @Nullable String architecture;
  private final @Nullable String clusterStore;
  private final @Nullable String cgroupDriver;
  private final @Nullable String cgroupVersion;
  private final Integer containers;
  private final @Nullable Integer containersRunning;
  private final @Nullable Integer containersStopped;
  private final @Nullable Integer containersPaused;
  private final @Nullable Boolean cpuCfsPeriod;
  private final @Nullable Boolean cpuCfsQuota;
  private final Boolean debug;
  private final String dockerRootDir;
  private final String storageDriver;
  private final List<List<String>> driverStatus;
  private final @Nullable Boolean experimentalBuild;
  private final @Nullable String httpProxy;
  private final @Nullable String httpsProxy;
  private final String id;
  private final Boolean ipv4Forwarding;
  private final Integer images;
  private final String indexServerAddress;
  private final @Nullable String initPath;
  private final @Nullable String initSha1;
  private final @Nullable Boolean kernelMemory;
  private final String kernelVersion;
  private final List<String> labels;
  private final Long memTotal;
  private final Boolean memoryLimit;
  private final Integer cpus;
  private final Integer eventsListener;
  private final Integer fileDescriptors;
  private final Integer goroutines;
  private final String name;
  private final @Nullable String noProxy;
  private final @Nullable Boolean oomKillDisable;
  private final String operatingSystem;
  private final @Nullable String osType;
  private final @Nullable String osVersion;
  private final @Nullable Info.Plugins plugins;
  private final Info.RegistryConfig registryConfig;
  private final @Nullable String serverVersion;
  private final Boolean swapLimit;
  private final @Nullable SwarmInfo swarm;
  private final @Nullable List<List<String>> systemStatus;
  private final Date systemTime;

  private ImmutableInfo(
      @Nullable String architecture,
      @Nullable String clusterStore,
      @Nullable String cgroupDriver,
      @Nullable String cgroupVersion,
      Integer containers,
      @Nullable Integer containersRunning,
      @Nullable Integer containersStopped,
      @Nullable Integer containersPaused,
      @Nullable Boolean cpuCfsPeriod,
      @Nullable Boolean cpuCfsQuota,
      Boolean debug,
      String dockerRootDir,
      String storageDriver,
      List<List<String>> driverStatus,
      @Nullable Boolean experimentalBuild,
      @Nullable String httpProxy,
      @Nullable String httpsProxy,
      String id,
      Boolean ipv4Forwarding,
      Integer images,
      String indexServerAddress,
      @Nullable String initPath,
      @Nullable String initSha1,
      @Nullable Boolean kernelMemory,
      String kernelVersion,
      List<String> labels,
      Long memTotal,
      Boolean memoryLimit,
      Integer cpus,
      Integer eventsListener,
      Integer fileDescriptors,
      Integer goroutines,
      String name,
      @Nullable String noProxy,
      @Nullable Boolean oomKillDisable,
      String operatingSystem,
      @Nullable String osType,
      @Nullable String osVersion,
      @Nullable Info.Plugins plugins,
      Info.RegistryConfig registryConfig,
      @Nullable String serverVersion,
      Boolean swapLimit,
      @Nullable SwarmInfo swarm,
      @Nullable List<List<String>> systemStatus,
      Date systemTime) {
    this.architecture = architecture;
    this.clusterStore = clusterStore;
    this.cgroupDriver = cgroupDriver;
    this.cgroupVersion = cgroupVersion;
    this.containers = containers;
    this.containersRunning = containersRunning;
    this.containersStopped = containersStopped;
    this.containersPaused = containersPaused;
    this.cpuCfsPeriod = cpuCfsPeriod;
    this.cpuCfsQuota = cpuCfsQuota;
    this.debug = debug;
    this.dockerRootDir = dockerRootDir;
    this.storageDriver = storageDriver;
    this.driverStatus = driverStatus;
    this.experimentalBuild = experimentalBuild;
    this.httpProxy = httpProxy;
    this.httpsProxy = httpsProxy;
    this.id = id;
    this.ipv4Forwarding = ipv4Forwarding;
    this.images = images;
    this.indexServerAddress = indexServerAddress;
    this.initPath = initPath;
    this.initSha1 = initSha1;
    this.kernelMemory = kernelMemory;
    this.kernelVersion = kernelVersion;
    this.labels = labels;
    this.memTotal = memTotal;
    this.memoryLimit = memoryLimit;
    this.cpus = cpus;
    this.eventsListener = eventsListener;
    this.fileDescriptors = fileDescriptors;
    this.goroutines = goroutines;
    this.name = name;
    this.noProxy = noProxy;
    this.oomKillDisable = oomKillDisable;
    this.operatingSystem = operatingSystem;
    this.osType = osType;
    this.osVersion = osVersion;
    this.plugins = plugins;
    this.registryConfig = registryConfig;
    this.serverVersion = serverVersion;
    this.swapLimit = swapLimit;
    this.swarm = swarm;
    this.systemStatus = systemStatus;
    this.systemTime = systemTime;
  }

  /**
   * @return The value of the {@code architecture} attribute
   */
  @JsonProperty("Architecture")
  @Override
  public @Nullable String architecture() {
    return architecture;
  }

  /**
   * @return The value of the {@code clusterStore} attribute
   */
  @JsonProperty("ClusterStore")
  @Deprecated
  @Override
  public @Nullable String clusterStore() {
    return clusterStore;
  }

  /**
   * @return The value of the {@code cgroupDriver} attribute
   */
  @JsonProperty("CgroupDriver")
  @Override
  public @Nullable String cgroupDriver() {
    return cgroupDriver;
  }

  /**
   * @return The value of the {@code cgroupVersion} attribute
   */
  @JsonProperty("CgroupVersion")
  @Override
  public @Nullable String cgroupVersion() {
    return cgroupVersion;
  }

  /**
   * @return The value of the {@code containers} attribute
   */
  @JsonProperty("Containers")
  @Override
  public Integer containers() {
    return containers;
  }

  /**
   * @return The value of the {@code containersRunning} attribute
   */
  @JsonProperty("ContainersRunning")
  @Override
  public @Nullable Integer containersRunning() {
    return containersRunning;
  }

  /**
   * @return The value of the {@code containersStopped} attribute
   */
  @JsonProperty("ContainersStopped")
  @Override
  public @Nullable Integer containersStopped() {
    return containersStopped;
  }

  /**
   * @return The value of the {@code containersPaused} attribute
   */
  @JsonProperty("ContainersPaused")
  @Override
  public @Nullable Integer containersPaused() {
    return containersPaused;
  }

  /**
   * @return The value of the {@code cpuCfsPeriod} attribute
   */
  @JsonProperty("CpuCfsPeriod")
  @Override
  public @Nullable Boolean cpuCfsPeriod() {
    return cpuCfsPeriod;
  }

  /**
   * @return The value of the {@code cpuCfsQuota} attribute
   */
  @JsonProperty("CpuCfsQuota")
  @Override
  public @Nullable Boolean cpuCfsQuota() {
    return cpuCfsQuota;
  }

  /**
   * @return The value of the {@code debug} attribute
   */
  @JsonProperty("Debug")
  @Override
  public Boolean debug() {
    return debug;
  }

  /**
   * @return The value of the {@code dockerRootDir} attribute
   */
  @JsonProperty("DockerRootDir")
  @Override
  public String dockerRootDir() {
    return dockerRootDir;
  }

  /**
   * @return The value of the {@code storageDriver} attribute
   */
  @JsonProperty("Driver")
  @Override
  public String storageDriver() {
    return storageDriver;
  }

  /**
   * @return The value of the {@code driverStatus} attribute
   */
  @JsonProperty("DriverStatus")
  @Override
  public List<List<String>> driverStatus() {
    return driverStatus;
  }

  /**
   * @return The value of the {@code experimentalBuild} attribute
   */
  @JsonProperty("ExperimentalBuild")
  @Override
  public @Nullable Boolean experimentalBuild() {
    return experimentalBuild;
  }

  /**
   * @return The value of the {@code httpProxy} attribute
   */
  @JsonProperty("HttpProxy")
  @Override
  public @Nullable String httpProxy() {
    return httpProxy;
  }

  /**
   * @return The value of the {@code httpsProxy} attribute
   */
  @JsonProperty("HttpsProxy")
  @Override
  public @Nullable String httpsProxy() {
    return httpsProxy;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty("ID")
  @Override
  public String id() {
    return id;
  }

  /**
   * @return The value of the {@code ipv4Forwarding} attribute
   */
  @JsonProperty("IPv4Forwarding")
  @Override
  public Boolean ipv4Forwarding() {
    return ipv4Forwarding;
  }

  /**
   * @return The value of the {@code images} attribute
   */
  @JsonProperty("Images")
  @Override
  public Integer images() {
    return images;
  }

  /**
   * @return The value of the {@code indexServerAddress} attribute
   */
  @JsonProperty("IndexServerAddress")
  @Override
  public String indexServerAddress() {
    return indexServerAddress;
  }

  /**
   * @return The value of the {@code initPath} attribute
   */
  @JsonProperty("InitPath")
  @Override
  public @Nullable String initPath() {
    return initPath;
  }

  /**
   * @return The value of the {@code initSha1} attribute
   */
  @JsonProperty("InitSha1")
  @Override
  public @Nullable String initSha1() {
    return initSha1;
  }

  /**
   * @return The value of the {@code kernelMemory} attribute
   */
  @JsonProperty("KernelMemory")
  @Deprecated
  @Override
  public @Nullable Boolean kernelMemory() {
    return kernelMemory;
  }

  /**
   * @return The value of the {@code kernelVersion} attribute
   */
  @JsonProperty("KernelVersion")
  @Override
  public String kernelVersion() {
    return kernelVersion;
  }

  /**
   * @return The value of the {@code labels} attribute
   */
  @JsonProperty("Labels")
  @JsonSetter(nulls = Nulls.AS_EMPTY)
  @Override
  public List<String> labels() {
    return labels;
  }

  /**
   * @return The value of the {@code memTotal} attribute
   */
  @JsonProperty("MemTotal")
  @Override
  public Long memTotal() {
    return memTotal;
  }

  /**
   * @return The value of the {@code memoryLimit} attribute
   */
  @JsonProperty("MemoryLimit")
  @Override
  public Boolean memoryLimit() {
    return memoryLimit;
  }

  /**
   * @return The value of the {@code cpus} attribute
   */
  @JsonProperty("NCPU")
  @Override
  public Integer cpus() {
    return cpus;
  }

  /**
   * @return The value of the {@code eventsListener} attribute
   */
  @JsonProperty("NEventsListener")
  @Override
  public Integer eventsListener() {
    return eventsListener;
  }

  /**
   * @return The value of the {@code fileDescriptors} attribute
   */
  @JsonProperty("NFd")
  @Override
  public Integer fileDescriptors() {
    return fileDescriptors;
  }

  /**
   * @return The value of the {@code goroutines} attribute
   */
  @JsonProperty("NGoroutines")
  @Override
  public Integer goroutines() {
    return goroutines;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty("Name")
  @Override
  public String name() {
    return name;
  }

  /**
   * @return The value of the {@code noProxy} attribute
   */
  @JsonProperty("NoProxy")
  @Override
  public @Nullable String noProxy() {
    return noProxy;
  }

  /**
   * @return The value of the {@code oomKillDisable} attribute
   */
  @JsonProperty("OomKillDisable")
  @Override
  public @Nullable Boolean oomKillDisable() {
    return oomKillDisable;
  }

  /**
   * @return The value of the {@code operatingSystem} attribute
   */
  @JsonProperty("OperatingSystem")
  @Override
  public String operatingSystem() {
    return operatingSystem;
  }

  /**
   * @return The value of the {@code osType} attribute
   */
  @JsonProperty("OSType")
  @Override
  public @Nullable String osType() {
    return osType;
  }

  /**
   * @return The value of the {@code osVersion} attribute
   */
  @JsonProperty("OSVersion")
  @Override
  public @Nullable String osVersion() {
    return osVersion;
  }

  /**
   * @return The value of the {@code plugins} attribute
   */
  @JsonProperty("Plugins")
  @Override
  public @Nullable Info.Plugins plugins() {
    return plugins;
  }

  /**
   * @return The value of the {@code registryConfig} attribute
   */
  @JsonProperty("RegistryConfig")
  @Override
  public Info.RegistryConfig registryConfig() {
    return registryConfig;
  }

  /**
   * @return The value of the {@code serverVersion} attribute
   */
  @JsonProperty("ServerVersion")
  @Override
  public @Nullable String serverVersion() {
    return serverVersion;
  }

  /**
   * @return The value of the {@code swapLimit} attribute
   */
  @JsonProperty("SwapLimit")
  @Override
  public Boolean swapLimit() {
    return swapLimit;
  }

  /**
   * @return The value of the {@code swarm} attribute
   */
  @JsonProperty("Swarm")
  @Override
  public @Nullable SwarmInfo swarm() {
    return swarm;
  }

  /**
   * @return The value of the {@code systemStatus} attribute
   */
  @JsonProperty("SystemStatus")
  @Override
  public @Nullable List<List<String>> systemStatus() {
    return systemStatus;
  }

  /**
   * @return The value of the {@code systemTime} attribute
   */
  @JsonProperty("SystemTime")
  @Override
  public Date systemTime() {
    return systemTime;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Info#architecture() architecture} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for architecture (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableInfo withArchitecture(@Nullable String value) {
    if (Objects.equals(this.architecture, value)) return this;
    return new ImmutableInfo(
        value,
        this.clusterStore,
        this.cgroupDriver,
        this.cgroupVersion,
        this.containers,
        this.containersRunning,
        this.containersStopped,
        this.containersPaused,
        this.cpuCfsPeriod,
        this.cpuCfsQuota,
        this.debug,
        this.dockerRootDir,
        this.storageDriver,
        this.driverStatus,
        this.experimentalBuild,
        this.httpProxy,
        this.httpsProxy,
        this.id,
        this.ipv4Forwarding,
        this.images,
        this.indexServerAddress,
        this.initPath,
        this.initSha1,
        this.kernelMemory,
        this.kernelVersion,
        this.labels,
        this.memTotal,
        this.memoryLimit,
        this.cpus,
        this.eventsListener,
        this.fileDescriptors,
        this.goroutines,
        this.name,
        this.noProxy,
        this.oomKillDisable,
        this.operatingSystem,
        this.osType,
        this.osVersion,
        this.plugins,
        this.registryConfig,
        this.serverVersion,
        this.swapLimit,
        this.swarm,
        this.systemStatus,
        this.systemTime);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Info#clusterStore() clusterStore} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for clusterStore (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  @Deprecated
  public final ImmutableInfo withClusterStore(@Nullable String value) {
    if (Objects.equals(this.clusterStore, value)) return this;
    return new ImmutableInfo(
        this.architecture,
        value,
        this.cgroupDriver,
        this.cgroupVersion,
        this.containers,
        this.containersRunning,
        this.containersStopped,
        this.containersPaused,
        this.cpuCfsPeriod,
        this.cpuCfsQuota,
        this.debug,
        this.dockerRootDir,
        this.storageDriver,
        this.driverStatus,
        this.experimentalBuild,
        this.httpProxy,
        this.httpsProxy,
        this.id,
        this.ipv4Forwarding,
        this.images,
        this.indexServerAddress,
        this.initPath,
        this.initSha1,
        this.kernelMemory,
        this.kernelVersion,
        this.labels,
        this.memTotal,
        this.memoryLimit,
        this.cpus,
        this.eventsListener,
        this.fileDescriptors,
        this.goroutines,
        this.name,
        this.noProxy,
        this.oomKillDisable,
        this.operatingSystem,
        this.osType,
        this.osVersion,
        this.plugins,
        this.registryConfig,
        this.serverVersion,
        this.swapLimit,
        this.swarm,
        this.systemStatus,
        this.systemTime);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Info#cgroupDriver() cgroupDriver} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for cgroupDriver (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableInfo withCgroupDriver(@Nullable String value) {
    if (Objects.equals(this.cgroupDriver, value)) return this;
    return new ImmutableInfo(
        this.architecture,
        this.clusterStore,
        value,
        this.cgroupVersion,
        this.containers,
        this.containersRunning,
        this.containersStopped,
        this.containersPaused,
        this.cpuCfsPeriod,
        this.cpuCfsQuota,
        this.debug,
        this.dockerRootDir,
        this.storageDriver,
        this.driverStatus,
        this.experimentalBuild,
        this.httpProxy,
        this.httpsProxy,
        this.id,
        this.ipv4Forwarding,
        this.images,
        this.indexServerAddress,
        this.initPath,
        this.initSha1,
        this.kernelMemory,
        this.kernelVersion,
        this.labels,
        this.memTotal,
        this.memoryLimit,
        this.cpus,
        this.eventsListener,
        this.fileDescriptors,
        this.goroutines,
        this.name,
        this.noProxy,
        this.oomKillDisable,
        this.operatingSystem,
        this.osType,
        this.osVersion,
        this.plugins,
        this.registryConfig,
        this.serverVersion,
        this.swapLimit,
        this.swarm,
        this.systemStatus,
        this.systemTime);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Info#cgroupVersion() cgroupVersion} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for cgroupVersion (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableInfo withCgroupVersion(@Nullable String value) {
    if (Objects.equals(this.cgroupVersion, value)) return this;
    return new ImmutableInfo(
        this.architecture,
        this.clusterStore,
        this.cgroupDriver,
        value,
        this.containers,
        this.containersRunning,
        this.containersStopped,
        this.containersPaused,
        this.cpuCfsPeriod,
        this.cpuCfsQuota,
        this.debug,
        this.dockerRootDir,
        this.storageDriver,
        this.driverStatus,
        this.experimentalBuild,
        this.httpProxy,
        this.httpsProxy,
        this.id,
        this.ipv4Forwarding,
        this.images,
        this.indexServerAddress,
        this.initPath,
        this.initSha1,
        this.kernelMemory,
        this.kernelVersion,
        this.labels,
        this.memTotal,
        this.memoryLimit,
        this.cpus,
        this.eventsListener,
        this.fileDescriptors,
        this.goroutines,
        this.name,
        this.noProxy,
        this.oomKillDisable,
        this.operatingSystem,
        this.osType,
        this.osVersion,
        this.plugins,
        this.registryConfig,
        this.serverVersion,
        this.swapLimit,
        this.swarm,
        this.systemStatus,
        this.systemTime);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Info#containers() containers} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for containers
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableInfo withContainers(Integer value) {
    Integer newValue = Objects.requireNonNull(value, "containers");
    if (this.containers.equals(newValue)) return this;
    return new ImmutableInfo(
        this.architecture,
        this.clusterStore,
        this.cgroupDriver,
        this.cgroupVersion,
        newValue,
        this.containersRunning,
        this.containersStopped,
        this.containersPaused,
        this.cpuCfsPeriod,
        this.cpuCfsQuota,
        this.debug,
        this.dockerRootDir,
        this.storageDriver,
        this.driverStatus,
        this.experimentalBuild,
        this.httpProxy,
        this.httpsProxy,
        this.id,
        this.ipv4Forwarding,
        this.images,
        this.indexServerAddress,
        this.initPath,
        this.initSha1,
        this.kernelMemory,
        this.kernelVersion,
        this.labels,
        this.memTotal,
        this.memoryLimit,
        this.cpus,
        this.eventsListener,
        this.fileDescriptors,
        this.goroutines,
        this.name,
        this.noProxy,
        this.oomKillDisable,
        this.operatingSystem,
        this.osType,
        this.osVersion,
        this.plugins,
        this.registryConfig,
        this.serverVersion,
        this.swapLimit,
        this.swarm,
        this.systemStatus,
        this.systemTime);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Info#containersRunning() containersRunning} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for containersRunning (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableInfo withContainersRunning(@Nullable Integer value) {
    if (Objects.equals(this.containersRunning, value)) return this;
    return new ImmutableInfo(
        this.architecture,
        this.clusterStore,
        this.cgroupDriver,
        this.cgroupVersion,
        this.containers,
        value,
        this.containersStopped,
        this.containersPaused,
        this.cpuCfsPeriod,
        this.cpuCfsQuota,
        this.debug,
        this.dockerRootDir,
        this.storageDriver,
        this.driverStatus,
        this.experimentalBuild,
        this.httpProxy,
        this.httpsProxy,
        this.id,
        this.ipv4Forwarding,
        this.images,
        this.indexServerAddress,
        this.initPath,
        this.initSha1,
        this.kernelMemory,
        this.kernelVersion,
        this.labels,
        this.memTotal,
        this.memoryLimit,
        this.cpus,
        this.eventsListener,
        this.fileDescriptors,
        this.goroutines,
        this.name,
        this.noProxy,
        this.oomKillDisable,
        this.operatingSystem,
        this.osType,
        this.osVersion,
        this.plugins,
        this.registryConfig,
        this.serverVersion,
        this.swapLimit,
        this.swarm,
        this.systemStatus,
        this.systemTime);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Info#containersStopped() containersStopped} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for containersStopped (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableInfo withContainersStopped(@Nullable Integer value) {
    if (Objects.equals(this.containersStopped, value)) return this;
    return new ImmutableInfo(
        this.architecture,
        this.clusterStore,
        this.cgroupDriver,
        this.cgroupVersion,
        this.containers,
        this.containersRunning,
        value,
        this.containersPaused,
        this.cpuCfsPeriod,
        this.cpuCfsQuota,
        this.debug,
        this.dockerRootDir,
        this.storageDriver,
        this.driverStatus,
        this.experimentalBuild,
        this.httpProxy,
        this.httpsProxy,
        this.id,
        this.ipv4Forwarding,
        this.images,
        this.indexServerAddress,
        this.initPath,
        this.initSha1,
        this.kernelMemory,
        this.kernelVersion,
        this.labels,
        this.memTotal,
        this.memoryLimit,
        this.cpus,
        this.eventsListener,
        this.fileDescriptors,
        this.goroutines,
        this.name,
        this.noProxy,
        this.oomKillDisable,
        this.operatingSystem,
        this.osType,
        this.osVersion,
        this.plugins,
        this.registryConfig,
        this.serverVersion,
        this.swapLimit,
        this.swarm,
        this.systemStatus,
        this.systemTime);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Info#containersPaused() containersPaused} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for containersPaused (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableInfo withContainersPaused(@Nullable Integer value) {
    if (Objects.equals(this.containersPaused, value)) return this;
    return new ImmutableInfo(
        this.architecture,
        this.clusterStore,
        this.cgroupDriver,
        this.cgroupVersion,
        this.containers,
        this.containersRunning,
        this.containersStopped,
        value,
        this.cpuCfsPeriod,
        this.cpuCfsQuota,
        this.debug,
        this.dockerRootDir,
        this.storageDriver,
        this.driverStatus,
        this.experimentalBuild,
        this.httpProxy,
        this.httpsProxy,
        this.id,
        this.ipv4Forwarding,
        this.images,
        this.indexServerAddress,
        this.initPath,
        this.initSha1,
        this.kernelMemory,
        this.kernelVersion,
        this.labels,
        this.memTotal,
        this.memoryLimit,
        this.cpus,
        this.eventsListener,
        this.fileDescriptors,
        this.goroutines,
        this.name,
        this.noProxy,
        this.oomKillDisable,
        this.operatingSystem,
        this.osType,
        this.osVersion,
        this.plugins,
        this.registryConfig,
        this.serverVersion,
        this.swapLimit,
        this.swarm,
        this.systemStatus,
        this.systemTime);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Info#cpuCfsPeriod() cpuCfsPeriod} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for cpuCfsPeriod (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableInfo withCpuCfsPeriod(@Nullable Boolean value) {
    if (Objects.equals(this.cpuCfsPeriod, value)) return this;
    return new ImmutableInfo(
        this.architecture,
        this.clusterStore,
        this.cgroupDriver,
        this.cgroupVersion,
        this.containers,
        this.containersRunning,
        this.containersStopped,
        this.containersPaused,
        value,
        this.cpuCfsQuota,
        this.debug,
        this.dockerRootDir,
        this.storageDriver,
        this.driverStatus,
        this.experimentalBuild,
        this.httpProxy,
        this.httpsProxy,
        this.id,
        this.ipv4Forwarding,
        this.images,
        this.indexServerAddress,
        this.initPath,
        this.initSha1,
        this.kernelMemory,
        this.kernelVersion,
        this.labels,
        this.memTotal,
        this.memoryLimit,
        this.cpus,
        this.eventsListener,
        this.fileDescriptors,
        this.goroutines,
        this.name,
        this.noProxy,
        this.oomKillDisable,
        this.operatingSystem,
        this.osType,
        this.osVersion,
        this.plugins,
        this.registryConfig,
        this.serverVersion,
        this.swapLimit,
        this.swarm,
        this.systemStatus,
        this.systemTime);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Info#cpuCfsQuota() cpuCfsQuota} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for cpuCfsQuota (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableInfo withCpuCfsQuota(@Nullable Boolean value) {
    if (Objects.equals(this.cpuCfsQuota, value)) return this;
    return new ImmutableInfo(
        this.architecture,
        this.clusterStore,
        this.cgroupDriver,
        this.cgroupVersion,
        this.containers,
        this.containersRunning,
        this.containersStopped,
        this.containersPaused,
        this.cpuCfsPeriod,
        value,
        this.debug,
        this.dockerRootDir,
        this.storageDriver,
        this.driverStatus,
        this.experimentalBuild,
        this.httpProxy,
        this.httpsProxy,
        this.id,
        this.ipv4Forwarding,
        this.images,
        this.indexServerAddress,
        this.initPath,
        this.initSha1,
        this.kernelMemory,
        this.kernelVersion,
        this.labels,
        this.memTotal,
        this.memoryLimit,
        this.cpus,
        this.eventsListener,
        this.fileDescriptors,
        this.goroutines,
        this.name,
        this.noProxy,
        this.oomKillDisable,
        this.operatingSystem,
        this.osType,
        this.osVersion,
        this.plugins,
        this.registryConfig,
        this.serverVersion,
        this.swapLimit,
        this.swarm,
        this.systemStatus,
        this.systemTime);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Info#debug() debug} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for debug
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableInfo withDebug(Boolean value) {
    Boolean newValue = Objects.requireNonNull(value, "debug");
    if (this.debug.equals(newValue)) return this;
    return new ImmutableInfo(
        this.architecture,
        this.clusterStore,
        this.cgroupDriver,
        this.cgroupVersion,
        this.containers,
        this.containersRunning,
        this.containersStopped,
        this.containersPaused,
        this.cpuCfsPeriod,
        this.cpuCfsQuota,
        newValue,
        this.dockerRootDir,
        this.storageDriver,
        this.driverStatus,
        this.experimentalBuild,
        this.httpProxy,
        this.httpsProxy,
        this.id,
        this.ipv4Forwarding,
        this.images,
        this.indexServerAddress,
        this.initPath,
        this.initSha1,
        this.kernelMemory,
        this.kernelVersion,
        this.labels,
        this.memTotal,
        this.memoryLimit,
        this.cpus,
        this.eventsListener,
        this.fileDescriptors,
        this.goroutines,
        this.name,
        this.noProxy,
        this.oomKillDisable,
        this.operatingSystem,
        this.osType,
        this.osVersion,
        this.plugins,
        this.registryConfig,
        this.serverVersion,
        this.swapLimit,
        this.swarm,
        this.systemStatus,
        this.systemTime);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Info#dockerRootDir() dockerRootDir} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for dockerRootDir
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableInfo withDockerRootDir(String value) {
    String newValue = Objects.requireNonNull(value, "dockerRootDir");
    if (this.dockerRootDir.equals(newValue)) return this;
    return new ImmutableInfo(
        this.architecture,
        this.clusterStore,
        this.cgroupDriver,
        this.cgroupVersion,
        this.containers,
        this.containersRunning,
        this.containersStopped,
        this.containersPaused,
        this.cpuCfsPeriod,
        this.cpuCfsQuota,
        this.debug,
        newValue,
        this.storageDriver,
        this.driverStatus,
        this.experimentalBuild,
        this.httpProxy,
        this.httpsProxy,
        this.id,
        this.ipv4Forwarding,
        this.images,
        this.indexServerAddress,
        this.initPath,
        this.initSha1,
        this.kernelMemory,
        this.kernelVersion,
        this.labels,
        this.memTotal,
        this.memoryLimit,
        this.cpus,
        this.eventsListener,
        this.fileDescriptors,
        this.goroutines,
        this.name,
        this.noProxy,
        this.oomKillDisable,
        this.operatingSystem,
        this.osType,
        this.osVersion,
        this.plugins,
        this.registryConfig,
        this.serverVersion,
        this.swapLimit,
        this.swarm,
        this.systemStatus,
        this.systemTime);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Info#storageDriver() storageDriver} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for storageDriver
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableInfo withStorageDriver(String value) {
    String newValue = Objects.requireNonNull(value, "storageDriver");
    if (this.storageDriver.equals(newValue)) return this;
    return new ImmutableInfo(
        this.architecture,
        this.clusterStore,
        this.cgroupDriver,
        this.cgroupVersion,
        this.containers,
        this.containersRunning,
        this.containersStopped,
        this.containersPaused,
        this.cpuCfsPeriod,
        this.cpuCfsQuota,
        this.debug,
        this.dockerRootDir,
        newValue,
        this.driverStatus,
        this.experimentalBuild,
        this.httpProxy,
        this.httpsProxy,
        this.id,
        this.ipv4Forwarding,
        this.images,
        this.indexServerAddress,
        this.initPath,
        this.initSha1,
        this.kernelMemory,
        this.kernelVersion,
        this.labels,
        this.memTotal,
        this.memoryLimit,
        this.cpus,
        this.eventsListener,
        this.fileDescriptors,
        this.goroutines,
        this.name,
        this.noProxy,
        this.oomKillDisable,
        this.operatingSystem,
        this.osType,
        this.osVersion,
        this.plugins,
        this.registryConfig,
        this.serverVersion,
        this.swapLimit,
        this.swarm,
        this.systemStatus,
        this.systemTime);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Info#driverStatus() driverStatus}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  @SafeVarargs @SuppressWarnings("varargs")
  public final ImmutableInfo withDriverStatus(List<String>... elements) {
    List<List<String>> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableInfo(
        this.architecture,
        this.clusterStore,
        this.cgroupDriver,
        this.cgroupVersion,
        this.containers,
        this.containersRunning,
        this.containersStopped,
        this.containersPaused,
        this.cpuCfsPeriod,
        this.cpuCfsQuota,
        this.debug,
        this.dockerRootDir,
        this.storageDriver,
        newValue,
        this.experimentalBuild,
        this.httpProxy,
        this.httpsProxy,
        this.id,
        this.ipv4Forwarding,
        this.images,
        this.indexServerAddress,
        this.initPath,
        this.initSha1,
        this.kernelMemory,
        this.kernelVersion,
        this.labels,
        this.memTotal,
        this.memoryLimit,
        this.cpus,
        this.eventsListener,
        this.fileDescriptors,
        this.goroutines,
        this.name,
        this.noProxy,
        this.oomKillDisable,
        this.operatingSystem,
        this.osType,
        this.osVersion,
        this.plugins,
        this.registryConfig,
        this.serverVersion,
        this.swapLimit,
        this.swarm,
        this.systemStatus,
        this.systemTime);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Info#driverStatus() driverStatus}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of driverStatus elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableInfo withDriverStatus(Iterable<? extends List<String>> elements) {
    if (this.driverStatus == elements) return this;
    List<List<String>> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableInfo(
        this.architecture,
        this.clusterStore,
        this.cgroupDriver,
        this.cgroupVersion,
        this.containers,
        this.containersRunning,
        this.containersStopped,
        this.containersPaused,
        this.cpuCfsPeriod,
        this.cpuCfsQuota,
        this.debug,
        this.dockerRootDir,
        this.storageDriver,
        newValue,
        this.experimentalBuild,
        this.httpProxy,
        this.httpsProxy,
        this.id,
        this.ipv4Forwarding,
        this.images,
        this.indexServerAddress,
        this.initPath,
        this.initSha1,
        this.kernelMemory,
        this.kernelVersion,
        this.labels,
        this.memTotal,
        this.memoryLimit,
        this.cpus,
        this.eventsListener,
        this.fileDescriptors,
        this.goroutines,
        this.name,
        this.noProxy,
        this.oomKillDisable,
        this.operatingSystem,
        this.osType,
        this.osVersion,
        this.plugins,
        this.registryConfig,
        this.serverVersion,
        this.swapLimit,
        this.swarm,
        this.systemStatus,
        this.systemTime);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Info#experimentalBuild() experimentalBuild} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for experimentalBuild (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableInfo withExperimentalBuild(@Nullable Boolean value) {
    if (Objects.equals(this.experimentalBuild, value)) return this;
    return new ImmutableInfo(
        this.architecture,
        this.clusterStore,
        this.cgroupDriver,
        this.cgroupVersion,
        this.containers,
        this.containersRunning,
        this.containersStopped,
        this.containersPaused,
        this.cpuCfsPeriod,
        this.cpuCfsQuota,
        this.debug,
        this.dockerRootDir,
        this.storageDriver,
        this.driverStatus,
        value,
        this.httpProxy,
        this.httpsProxy,
        this.id,
        this.ipv4Forwarding,
        this.images,
        this.indexServerAddress,
        this.initPath,
        this.initSha1,
        this.kernelMemory,
        this.kernelVersion,
        this.labels,
        this.memTotal,
        this.memoryLimit,
        this.cpus,
        this.eventsListener,
        this.fileDescriptors,
        this.goroutines,
        this.name,
        this.noProxy,
        this.oomKillDisable,
        this.operatingSystem,
        this.osType,
        this.osVersion,
        this.plugins,
        this.registryConfig,
        this.serverVersion,
        this.swapLimit,
        this.swarm,
        this.systemStatus,
        this.systemTime);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Info#httpProxy() httpProxy} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for httpProxy (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableInfo withHttpProxy(@Nullable String value) {
    if (Objects.equals(this.httpProxy, value)) return this;
    return new ImmutableInfo(
        this.architecture,
        this.clusterStore,
        this.cgroupDriver,
        this.cgroupVersion,
        this.containers,
        this.containersRunning,
        this.containersStopped,
        this.containersPaused,
        this.cpuCfsPeriod,
        this.cpuCfsQuota,
        this.debug,
        this.dockerRootDir,
        this.storageDriver,
        this.driverStatus,
        this.experimentalBuild,
        value,
        this.httpsProxy,
        this.id,
        this.ipv4Forwarding,
        this.images,
        this.indexServerAddress,
        this.initPath,
        this.initSha1,
        this.kernelMemory,
        this.kernelVersion,
        this.labels,
        this.memTotal,
        this.memoryLimit,
        this.cpus,
        this.eventsListener,
        this.fileDescriptors,
        this.goroutines,
        this.name,
        this.noProxy,
        this.oomKillDisable,
        this.operatingSystem,
        this.osType,
        this.osVersion,
        this.plugins,
        this.registryConfig,
        this.serverVersion,
        this.swapLimit,
        this.swarm,
        this.systemStatus,
        this.systemTime);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Info#httpsProxy() httpsProxy} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for httpsProxy (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableInfo withHttpsProxy(@Nullable String value) {
    if (Objects.equals(this.httpsProxy, value)) return this;
    return new ImmutableInfo(
        this.architecture,
        this.clusterStore,
        this.cgroupDriver,
        this.cgroupVersion,
        this.containers,
        this.containersRunning,
        this.containersStopped,
        this.containersPaused,
        this.cpuCfsPeriod,
        this.cpuCfsQuota,
        this.debug,
        this.dockerRootDir,
        this.storageDriver,
        this.driverStatus,
        this.experimentalBuild,
        this.httpProxy,
        value,
        this.id,
        this.ipv4Forwarding,
        this.images,
        this.indexServerAddress,
        this.initPath,
        this.initSha1,
        this.kernelMemory,
        this.kernelVersion,
        this.labels,
        this.memTotal,
        this.memoryLimit,
        this.cpus,
        this.eventsListener,
        this.fileDescriptors,
        this.goroutines,
        this.name,
        this.noProxy,
        this.oomKillDisable,
        this.operatingSystem,
        this.osType,
        this.osVersion,
        this.plugins,
        this.registryConfig,
        this.serverVersion,
        this.swapLimit,
        this.swarm,
        this.systemStatus,
        this.systemTime);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Info#id() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableInfo withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return new ImmutableInfo(
        this.architecture,
        this.clusterStore,
        this.cgroupDriver,
        this.cgroupVersion,
        this.containers,
        this.containersRunning,
        this.containersStopped,
        this.containersPaused,
        this.cpuCfsPeriod,
        this.cpuCfsQuota,
        this.debug,
        this.dockerRootDir,
        this.storageDriver,
        this.driverStatus,
        this.experimentalBuild,
        this.httpProxy,
        this.httpsProxy,
        newValue,
        this.ipv4Forwarding,
        this.images,
        this.indexServerAddress,
        this.initPath,
        this.initSha1,
        this.kernelMemory,
        this.kernelVersion,
        this.labels,
        this.memTotal,
        this.memoryLimit,
        this.cpus,
        this.eventsListener,
        this.fileDescriptors,
        this.goroutines,
        this.name,
        this.noProxy,
        this.oomKillDisable,
        this.operatingSystem,
        this.osType,
        this.osVersion,
        this.plugins,
        this.registryConfig,
        this.serverVersion,
        this.swapLimit,
        this.swarm,
        this.systemStatus,
        this.systemTime);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Info#ipv4Forwarding() ipv4Forwarding} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for ipv4Forwarding
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableInfo withIpv4Forwarding(Boolean value) {
    Boolean newValue = Objects.requireNonNull(value, "ipv4Forwarding");
    if (this.ipv4Forwarding.equals(newValue)) return this;
    return new ImmutableInfo(
        this.architecture,
        this.clusterStore,
        this.cgroupDriver,
        this.cgroupVersion,
        this.containers,
        this.containersRunning,
        this.containersStopped,
        this.containersPaused,
        this.cpuCfsPeriod,
        this.cpuCfsQuota,
        this.debug,
        this.dockerRootDir,
        this.storageDriver,
        this.driverStatus,
        this.experimentalBuild,
        this.httpProxy,
        this.httpsProxy,
        this.id,
        newValue,
        this.images,
        this.indexServerAddress,
        this.initPath,
        this.initSha1,
        this.kernelMemory,
        this.kernelVersion,
        this.labels,
        this.memTotal,
        this.memoryLimit,
        this.cpus,
        this.eventsListener,
        this.fileDescriptors,
        this.goroutines,
        this.name,
        this.noProxy,
        this.oomKillDisable,
        this.operatingSystem,
        this.osType,
        this.osVersion,
        this.plugins,
        this.registryConfig,
        this.serverVersion,
        this.swapLimit,
        this.swarm,
        this.systemStatus,
        this.systemTime);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Info#images() images} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for images
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableInfo withImages(Integer value) {
    Integer newValue = Objects.requireNonNull(value, "images");
    if (this.images.equals(newValue)) return this;
    return new ImmutableInfo(
        this.architecture,
        this.clusterStore,
        this.cgroupDriver,
        this.cgroupVersion,
        this.containers,
        this.containersRunning,
        this.containersStopped,
        this.containersPaused,
        this.cpuCfsPeriod,
        this.cpuCfsQuota,
        this.debug,
        this.dockerRootDir,
        this.storageDriver,
        this.driverStatus,
        this.experimentalBuild,
        this.httpProxy,
        this.httpsProxy,
        this.id,
        this.ipv4Forwarding,
        newValue,
        this.indexServerAddress,
        this.initPath,
        this.initSha1,
        this.kernelMemory,
        this.kernelVersion,
        this.labels,
        this.memTotal,
        this.memoryLimit,
        this.cpus,
        this.eventsListener,
        this.fileDescriptors,
        this.goroutines,
        this.name,
        this.noProxy,
        this.oomKillDisable,
        this.operatingSystem,
        this.osType,
        this.osVersion,
        this.plugins,
        this.registryConfig,
        this.serverVersion,
        this.swapLimit,
        this.swarm,
        this.systemStatus,
        this.systemTime);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Info#indexServerAddress() indexServerAddress} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for indexServerAddress
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableInfo withIndexServerAddress(String value) {
    String newValue = Objects.requireNonNull(value, "indexServerAddress");
    if (this.indexServerAddress.equals(newValue)) return this;
    return new ImmutableInfo(
        this.architecture,
        this.clusterStore,
        this.cgroupDriver,
        this.cgroupVersion,
        this.containers,
        this.containersRunning,
        this.containersStopped,
        this.containersPaused,
        this.cpuCfsPeriod,
        this.cpuCfsQuota,
        this.debug,
        this.dockerRootDir,
        this.storageDriver,
        this.driverStatus,
        this.experimentalBuild,
        this.httpProxy,
        this.httpsProxy,
        this.id,
        this.ipv4Forwarding,
        this.images,
        newValue,
        this.initPath,
        this.initSha1,
        this.kernelMemory,
        this.kernelVersion,
        this.labels,
        this.memTotal,
        this.memoryLimit,
        this.cpus,
        this.eventsListener,
        this.fileDescriptors,
        this.goroutines,
        this.name,
        this.noProxy,
        this.oomKillDisable,
        this.operatingSystem,
        this.osType,
        this.osVersion,
        this.plugins,
        this.registryConfig,
        this.serverVersion,
        this.swapLimit,
        this.swarm,
        this.systemStatus,
        this.systemTime);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Info#initPath() initPath} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for initPath (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableInfo withInitPath(@Nullable String value) {
    if (Objects.equals(this.initPath, value)) return this;
    return new ImmutableInfo(
        this.architecture,
        this.clusterStore,
        this.cgroupDriver,
        this.cgroupVersion,
        this.containers,
        this.containersRunning,
        this.containersStopped,
        this.containersPaused,
        this.cpuCfsPeriod,
        this.cpuCfsQuota,
        this.debug,
        this.dockerRootDir,
        this.storageDriver,
        this.driverStatus,
        this.experimentalBuild,
        this.httpProxy,
        this.httpsProxy,
        this.id,
        this.ipv4Forwarding,
        this.images,
        this.indexServerAddress,
        value,
        this.initSha1,
        this.kernelMemory,
        this.kernelVersion,
        this.labels,
        this.memTotal,
        this.memoryLimit,
        this.cpus,
        this.eventsListener,
        this.fileDescriptors,
        this.goroutines,
        this.name,
        this.noProxy,
        this.oomKillDisable,
        this.operatingSystem,
        this.osType,
        this.osVersion,
        this.plugins,
        this.registryConfig,
        this.serverVersion,
        this.swapLimit,
        this.swarm,
        this.systemStatus,
        this.systemTime);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Info#initSha1() initSha1} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for initSha1 (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableInfo withInitSha1(@Nullable String value) {
    if (Objects.equals(this.initSha1, value)) return this;
    return new ImmutableInfo(
        this.architecture,
        this.clusterStore,
        this.cgroupDriver,
        this.cgroupVersion,
        this.containers,
        this.containersRunning,
        this.containersStopped,
        this.containersPaused,
        this.cpuCfsPeriod,
        this.cpuCfsQuota,
        this.debug,
        this.dockerRootDir,
        this.storageDriver,
        this.driverStatus,
        this.experimentalBuild,
        this.httpProxy,
        this.httpsProxy,
        this.id,
        this.ipv4Forwarding,
        this.images,
        this.indexServerAddress,
        this.initPath,
        value,
        this.kernelMemory,
        this.kernelVersion,
        this.labels,
        this.memTotal,
        this.memoryLimit,
        this.cpus,
        this.eventsListener,
        this.fileDescriptors,
        this.goroutines,
        this.name,
        this.noProxy,
        this.oomKillDisable,
        this.operatingSystem,
        this.osType,
        this.osVersion,
        this.plugins,
        this.registryConfig,
        this.serverVersion,
        this.swapLimit,
        this.swarm,
        this.systemStatus,
        this.systemTime);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Info#kernelMemory() kernelMemory} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for kernelMemory (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  @Deprecated
  public final ImmutableInfo withKernelMemory(@Nullable Boolean value) {
    if (Objects.equals(this.kernelMemory, value)) return this;
    return new ImmutableInfo(
        this.architecture,
        this.clusterStore,
        this.cgroupDriver,
        this.cgroupVersion,
        this.containers,
        this.containersRunning,
        this.containersStopped,
        this.containersPaused,
        this.cpuCfsPeriod,
        this.cpuCfsQuota,
        this.debug,
        this.dockerRootDir,
        this.storageDriver,
        this.driverStatus,
        this.experimentalBuild,
        this.httpProxy,
        this.httpsProxy,
        this.id,
        this.ipv4Forwarding,
        this.images,
        this.indexServerAddress,
        this.initPath,
        this.initSha1,
        value,
        this.kernelVersion,
        this.labels,
        this.memTotal,
        this.memoryLimit,
        this.cpus,
        this.eventsListener,
        this.fileDescriptors,
        this.goroutines,
        this.name,
        this.noProxy,
        this.oomKillDisable,
        this.operatingSystem,
        this.osType,
        this.osVersion,
        this.plugins,
        this.registryConfig,
        this.serverVersion,
        this.swapLimit,
        this.swarm,
        this.systemStatus,
        this.systemTime);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Info#kernelVersion() kernelVersion} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for kernelVersion
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableInfo withKernelVersion(String value) {
    String newValue = Objects.requireNonNull(value, "kernelVersion");
    if (this.kernelVersion.equals(newValue)) return this;
    return new ImmutableInfo(
        this.architecture,
        this.clusterStore,
        this.cgroupDriver,
        this.cgroupVersion,
        this.containers,
        this.containersRunning,
        this.containersStopped,
        this.containersPaused,
        this.cpuCfsPeriod,
        this.cpuCfsQuota,
        this.debug,
        this.dockerRootDir,
        this.storageDriver,
        this.driverStatus,
        this.experimentalBuild,
        this.httpProxy,
        this.httpsProxy,
        this.id,
        this.ipv4Forwarding,
        this.images,
        this.indexServerAddress,
        this.initPath,
        this.initSha1,
        this.kernelMemory,
        newValue,
        this.labels,
        this.memTotal,
        this.memoryLimit,
        this.cpus,
        this.eventsListener,
        this.fileDescriptors,
        this.goroutines,
        this.name,
        this.noProxy,
        this.oomKillDisable,
        this.operatingSystem,
        this.osType,
        this.osVersion,
        this.plugins,
        this.registryConfig,
        this.serverVersion,
        this.swapLimit,
        this.swarm,
        this.systemStatus,
        this.systemTime);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Info#labels() labels}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableInfo withLabels(String... elements) {
    List<String> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableInfo(
        this.architecture,
        this.clusterStore,
        this.cgroupDriver,
        this.cgroupVersion,
        this.containers,
        this.containersRunning,
        this.containersStopped,
        this.containersPaused,
        this.cpuCfsPeriod,
        this.cpuCfsQuota,
        this.debug,
        this.dockerRootDir,
        this.storageDriver,
        this.driverStatus,
        this.experimentalBuild,
        this.httpProxy,
        this.httpsProxy,
        this.id,
        this.ipv4Forwarding,
        this.images,
        this.indexServerAddress,
        this.initPath,
        this.initSha1,
        this.kernelMemory,
        this.kernelVersion,
        newValue,
        this.memTotal,
        this.memoryLimit,
        this.cpus,
        this.eventsListener,
        this.fileDescriptors,
        this.goroutines,
        this.name,
        this.noProxy,
        this.oomKillDisable,
        this.operatingSystem,
        this.osType,
        this.osVersion,
        this.plugins,
        this.registryConfig,
        this.serverVersion,
        this.swapLimit,
        this.swarm,
        this.systemStatus,
        this.systemTime);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Info#labels() labels}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of labels elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableInfo withLabels(Iterable<String> elements) {
    if (this.labels == elements) return this;
    List<String> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableInfo(
        this.architecture,
        this.clusterStore,
        this.cgroupDriver,
        this.cgroupVersion,
        this.containers,
        this.containersRunning,
        this.containersStopped,
        this.containersPaused,
        this.cpuCfsPeriod,
        this.cpuCfsQuota,
        this.debug,
        this.dockerRootDir,
        this.storageDriver,
        this.driverStatus,
        this.experimentalBuild,
        this.httpProxy,
        this.httpsProxy,
        this.id,
        this.ipv4Forwarding,
        this.images,
        this.indexServerAddress,
        this.initPath,
        this.initSha1,
        this.kernelMemory,
        this.kernelVersion,
        newValue,
        this.memTotal,
        this.memoryLimit,
        this.cpus,
        this.eventsListener,
        this.fileDescriptors,
        this.goroutines,
        this.name,
        this.noProxy,
        this.oomKillDisable,
        this.operatingSystem,
        this.osType,
        this.osVersion,
        this.plugins,
        this.registryConfig,
        this.serverVersion,
        this.swapLimit,
        this.swarm,
        this.systemStatus,
        this.systemTime);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Info#memTotal() memTotal} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for memTotal
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableInfo withMemTotal(Long value) {
    Long newValue = Objects.requireNonNull(value, "memTotal");
    if (this.memTotal.equals(newValue)) return this;
    return new ImmutableInfo(
        this.architecture,
        this.clusterStore,
        this.cgroupDriver,
        this.cgroupVersion,
        this.containers,
        this.containersRunning,
        this.containersStopped,
        this.containersPaused,
        this.cpuCfsPeriod,
        this.cpuCfsQuota,
        this.debug,
        this.dockerRootDir,
        this.storageDriver,
        this.driverStatus,
        this.experimentalBuild,
        this.httpProxy,
        this.httpsProxy,
        this.id,
        this.ipv4Forwarding,
        this.images,
        this.indexServerAddress,
        this.initPath,
        this.initSha1,
        this.kernelMemory,
        this.kernelVersion,
        this.labels,
        newValue,
        this.memoryLimit,
        this.cpus,
        this.eventsListener,
        this.fileDescriptors,
        this.goroutines,
        this.name,
        this.noProxy,
        this.oomKillDisable,
        this.operatingSystem,
        this.osType,
        this.osVersion,
        this.plugins,
        this.registryConfig,
        this.serverVersion,
        this.swapLimit,
        this.swarm,
        this.systemStatus,
        this.systemTime);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Info#memoryLimit() memoryLimit} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for memoryLimit
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableInfo withMemoryLimit(Boolean value) {
    Boolean newValue = Objects.requireNonNull(value, "memoryLimit");
    if (this.memoryLimit.equals(newValue)) return this;
    return new ImmutableInfo(
        this.architecture,
        this.clusterStore,
        this.cgroupDriver,
        this.cgroupVersion,
        this.containers,
        this.containersRunning,
        this.containersStopped,
        this.containersPaused,
        this.cpuCfsPeriod,
        this.cpuCfsQuota,
        this.debug,
        this.dockerRootDir,
        this.storageDriver,
        this.driverStatus,
        this.experimentalBuild,
        this.httpProxy,
        this.httpsProxy,
        this.id,
        this.ipv4Forwarding,
        this.images,
        this.indexServerAddress,
        this.initPath,
        this.initSha1,
        this.kernelMemory,
        this.kernelVersion,
        this.labels,
        this.memTotal,
        newValue,
        this.cpus,
        this.eventsListener,
        this.fileDescriptors,
        this.goroutines,
        this.name,
        this.noProxy,
        this.oomKillDisable,
        this.operatingSystem,
        this.osType,
        this.osVersion,
        this.plugins,
        this.registryConfig,
        this.serverVersion,
        this.swapLimit,
        this.swarm,
        this.systemStatus,
        this.systemTime);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Info#cpus() cpus} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for cpus
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableInfo withCpus(Integer value) {
    Integer newValue = Objects.requireNonNull(value, "cpus");
    if (this.cpus.equals(newValue)) return this;
    return new ImmutableInfo(
        this.architecture,
        this.clusterStore,
        this.cgroupDriver,
        this.cgroupVersion,
        this.containers,
        this.containersRunning,
        this.containersStopped,
        this.containersPaused,
        this.cpuCfsPeriod,
        this.cpuCfsQuota,
        this.debug,
        this.dockerRootDir,
        this.storageDriver,
        this.driverStatus,
        this.experimentalBuild,
        this.httpProxy,
        this.httpsProxy,
        this.id,
        this.ipv4Forwarding,
        this.images,
        this.indexServerAddress,
        this.initPath,
        this.initSha1,
        this.kernelMemory,
        this.kernelVersion,
        this.labels,
        this.memTotal,
        this.memoryLimit,
        newValue,
        this.eventsListener,
        this.fileDescriptors,
        this.goroutines,
        this.name,
        this.noProxy,
        this.oomKillDisable,
        this.operatingSystem,
        this.osType,
        this.osVersion,
        this.plugins,
        this.registryConfig,
        this.serverVersion,
        this.swapLimit,
        this.swarm,
        this.systemStatus,
        this.systemTime);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Info#eventsListener() eventsListener} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for eventsListener
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableInfo withEventsListener(Integer value) {
    Integer newValue = Objects.requireNonNull(value, "eventsListener");
    if (this.eventsListener.equals(newValue)) return this;
    return new ImmutableInfo(
        this.architecture,
        this.clusterStore,
        this.cgroupDriver,
        this.cgroupVersion,
        this.containers,
        this.containersRunning,
        this.containersStopped,
        this.containersPaused,
        this.cpuCfsPeriod,
        this.cpuCfsQuota,
        this.debug,
        this.dockerRootDir,
        this.storageDriver,
        this.driverStatus,
        this.experimentalBuild,
        this.httpProxy,
        this.httpsProxy,
        this.id,
        this.ipv4Forwarding,
        this.images,
        this.indexServerAddress,
        this.initPath,
        this.initSha1,
        this.kernelMemory,
        this.kernelVersion,
        this.labels,
        this.memTotal,
        this.memoryLimit,
        this.cpus,
        newValue,
        this.fileDescriptors,
        this.goroutines,
        this.name,
        this.noProxy,
        this.oomKillDisable,
        this.operatingSystem,
        this.osType,
        this.osVersion,
        this.plugins,
        this.registryConfig,
        this.serverVersion,
        this.swapLimit,
        this.swarm,
        this.systemStatus,
        this.systemTime);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Info#fileDescriptors() fileDescriptors} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for fileDescriptors
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableInfo withFileDescriptors(Integer value) {
    Integer newValue = Objects.requireNonNull(value, "fileDescriptors");
    if (this.fileDescriptors.equals(newValue)) return this;
    return new ImmutableInfo(
        this.architecture,
        this.clusterStore,
        this.cgroupDriver,
        this.cgroupVersion,
        this.containers,
        this.containersRunning,
        this.containersStopped,
        this.containersPaused,
        this.cpuCfsPeriod,
        this.cpuCfsQuota,
        this.debug,
        this.dockerRootDir,
        this.storageDriver,
        this.driverStatus,
        this.experimentalBuild,
        this.httpProxy,
        this.httpsProxy,
        this.id,
        this.ipv4Forwarding,
        this.images,
        this.indexServerAddress,
        this.initPath,
        this.initSha1,
        this.kernelMemory,
        this.kernelVersion,
        this.labels,
        this.memTotal,
        this.memoryLimit,
        this.cpus,
        this.eventsListener,
        newValue,
        this.goroutines,
        this.name,
        this.noProxy,
        this.oomKillDisable,
        this.operatingSystem,
        this.osType,
        this.osVersion,
        this.plugins,
        this.registryConfig,
        this.serverVersion,
        this.swapLimit,
        this.swarm,
        this.systemStatus,
        this.systemTime);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Info#goroutines() goroutines} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for goroutines
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableInfo withGoroutines(Integer value) {
    Integer newValue = Objects.requireNonNull(value, "goroutines");
    if (this.goroutines.equals(newValue)) return this;
    return new ImmutableInfo(
        this.architecture,
        this.clusterStore,
        this.cgroupDriver,
        this.cgroupVersion,
        this.containers,
        this.containersRunning,
        this.containersStopped,
        this.containersPaused,
        this.cpuCfsPeriod,
        this.cpuCfsQuota,
        this.debug,
        this.dockerRootDir,
        this.storageDriver,
        this.driverStatus,
        this.experimentalBuild,
        this.httpProxy,
        this.httpsProxy,
        this.id,
        this.ipv4Forwarding,
        this.images,
        this.indexServerAddress,
        this.initPath,
        this.initSha1,
        this.kernelMemory,
        this.kernelVersion,
        this.labels,
        this.memTotal,
        this.memoryLimit,
        this.cpus,
        this.eventsListener,
        this.fileDescriptors,
        newValue,
        this.name,
        this.noProxy,
        this.oomKillDisable,
        this.operatingSystem,
        this.osType,
        this.osVersion,
        this.plugins,
        this.registryConfig,
        this.serverVersion,
        this.swapLimit,
        this.swarm,
        this.systemStatus,
        this.systemTime);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Info#name() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableInfo withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new ImmutableInfo(
        this.architecture,
        this.clusterStore,
        this.cgroupDriver,
        this.cgroupVersion,
        this.containers,
        this.containersRunning,
        this.containersStopped,
        this.containersPaused,
        this.cpuCfsPeriod,
        this.cpuCfsQuota,
        this.debug,
        this.dockerRootDir,
        this.storageDriver,
        this.driverStatus,
        this.experimentalBuild,
        this.httpProxy,
        this.httpsProxy,
        this.id,
        this.ipv4Forwarding,
        this.images,
        this.indexServerAddress,
        this.initPath,
        this.initSha1,
        this.kernelMemory,
        this.kernelVersion,
        this.labels,
        this.memTotal,
        this.memoryLimit,
        this.cpus,
        this.eventsListener,
        this.fileDescriptors,
        this.goroutines,
        newValue,
        this.noProxy,
        this.oomKillDisable,
        this.operatingSystem,
        this.osType,
        this.osVersion,
        this.plugins,
        this.registryConfig,
        this.serverVersion,
        this.swapLimit,
        this.swarm,
        this.systemStatus,
        this.systemTime);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Info#noProxy() noProxy} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for noProxy (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableInfo withNoProxy(@Nullable String value) {
    if (Objects.equals(this.noProxy, value)) return this;
    return new ImmutableInfo(
        this.architecture,
        this.clusterStore,
        this.cgroupDriver,
        this.cgroupVersion,
        this.containers,
        this.containersRunning,
        this.containersStopped,
        this.containersPaused,
        this.cpuCfsPeriod,
        this.cpuCfsQuota,
        this.debug,
        this.dockerRootDir,
        this.storageDriver,
        this.driverStatus,
        this.experimentalBuild,
        this.httpProxy,
        this.httpsProxy,
        this.id,
        this.ipv4Forwarding,
        this.images,
        this.indexServerAddress,
        this.initPath,
        this.initSha1,
        this.kernelMemory,
        this.kernelVersion,
        this.labels,
        this.memTotal,
        this.memoryLimit,
        this.cpus,
        this.eventsListener,
        this.fileDescriptors,
        this.goroutines,
        this.name,
        value,
        this.oomKillDisable,
        this.operatingSystem,
        this.osType,
        this.osVersion,
        this.plugins,
        this.registryConfig,
        this.serverVersion,
        this.swapLimit,
        this.swarm,
        this.systemStatus,
        this.systemTime);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Info#oomKillDisable() oomKillDisable} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for oomKillDisable (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableInfo withOomKillDisable(@Nullable Boolean value) {
    if (Objects.equals(this.oomKillDisable, value)) return this;
    return new ImmutableInfo(
        this.architecture,
        this.clusterStore,
        this.cgroupDriver,
        this.cgroupVersion,
        this.containers,
        this.containersRunning,
        this.containersStopped,
        this.containersPaused,
        this.cpuCfsPeriod,
        this.cpuCfsQuota,
        this.debug,
        this.dockerRootDir,
        this.storageDriver,
        this.driverStatus,
        this.experimentalBuild,
        this.httpProxy,
        this.httpsProxy,
        this.id,
        this.ipv4Forwarding,
        this.images,
        this.indexServerAddress,
        this.initPath,
        this.initSha1,
        this.kernelMemory,
        this.kernelVersion,
        this.labels,
        this.memTotal,
        this.memoryLimit,
        this.cpus,
        this.eventsListener,
        this.fileDescriptors,
        this.goroutines,
        this.name,
        this.noProxy,
        value,
        this.operatingSystem,
        this.osType,
        this.osVersion,
        this.plugins,
        this.registryConfig,
        this.serverVersion,
        this.swapLimit,
        this.swarm,
        this.systemStatus,
        this.systemTime);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Info#operatingSystem() operatingSystem} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for operatingSystem
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableInfo withOperatingSystem(String value) {
    String newValue = Objects.requireNonNull(value, "operatingSystem");
    if (this.operatingSystem.equals(newValue)) return this;
    return new ImmutableInfo(
        this.architecture,
        this.clusterStore,
        this.cgroupDriver,
        this.cgroupVersion,
        this.containers,
        this.containersRunning,
        this.containersStopped,
        this.containersPaused,
        this.cpuCfsPeriod,
        this.cpuCfsQuota,
        this.debug,
        this.dockerRootDir,
        this.storageDriver,
        this.driverStatus,
        this.experimentalBuild,
        this.httpProxy,
        this.httpsProxy,
        this.id,
        this.ipv4Forwarding,
        this.images,
        this.indexServerAddress,
        this.initPath,
        this.initSha1,
        this.kernelMemory,
        this.kernelVersion,
        this.labels,
        this.memTotal,
        this.memoryLimit,
        this.cpus,
        this.eventsListener,
        this.fileDescriptors,
        this.goroutines,
        this.name,
        this.noProxy,
        this.oomKillDisable,
        newValue,
        this.osType,
        this.osVersion,
        this.plugins,
        this.registryConfig,
        this.serverVersion,
        this.swapLimit,
        this.swarm,
        this.systemStatus,
        this.systemTime);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Info#osType() osType} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for osType (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableInfo withOsType(@Nullable String value) {
    if (Objects.equals(this.osType, value)) return this;
    return new ImmutableInfo(
        this.architecture,
        this.clusterStore,
        this.cgroupDriver,
        this.cgroupVersion,
        this.containers,
        this.containersRunning,
        this.containersStopped,
        this.containersPaused,
        this.cpuCfsPeriod,
        this.cpuCfsQuota,
        this.debug,
        this.dockerRootDir,
        this.storageDriver,
        this.driverStatus,
        this.experimentalBuild,
        this.httpProxy,
        this.httpsProxy,
        this.id,
        this.ipv4Forwarding,
        this.images,
        this.indexServerAddress,
        this.initPath,
        this.initSha1,
        this.kernelMemory,
        this.kernelVersion,
        this.labels,
        this.memTotal,
        this.memoryLimit,
        this.cpus,
        this.eventsListener,
        this.fileDescriptors,
        this.goroutines,
        this.name,
        this.noProxy,
        this.oomKillDisable,
        this.operatingSystem,
        value,
        this.osVersion,
        this.plugins,
        this.registryConfig,
        this.serverVersion,
        this.swapLimit,
        this.swarm,
        this.systemStatus,
        this.systemTime);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Info#osVersion() osVersion} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for osVersion (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableInfo withOsVersion(@Nullable String value) {
    if (Objects.equals(this.osVersion, value)) return this;
    return new ImmutableInfo(
        this.architecture,
        this.clusterStore,
        this.cgroupDriver,
        this.cgroupVersion,
        this.containers,
        this.containersRunning,
        this.containersStopped,
        this.containersPaused,
        this.cpuCfsPeriod,
        this.cpuCfsQuota,
        this.debug,
        this.dockerRootDir,
        this.storageDriver,
        this.driverStatus,
        this.experimentalBuild,
        this.httpProxy,
        this.httpsProxy,
        this.id,
        this.ipv4Forwarding,
        this.images,
        this.indexServerAddress,
        this.initPath,
        this.initSha1,
        this.kernelMemory,
        this.kernelVersion,
        this.labels,
        this.memTotal,
        this.memoryLimit,
        this.cpus,
        this.eventsListener,
        this.fileDescriptors,
        this.goroutines,
        this.name,
        this.noProxy,
        this.oomKillDisable,
        this.operatingSystem,
        this.osType,
        value,
        this.plugins,
        this.registryConfig,
        this.serverVersion,
        this.swapLimit,
        this.swarm,
        this.systemStatus,
        this.systemTime);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Info#plugins() plugins} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for plugins (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableInfo withPlugins(@Nullable Info.Plugins value) {
    if (this.plugins == value) return this;
    return new ImmutableInfo(
        this.architecture,
        this.clusterStore,
        this.cgroupDriver,
        this.cgroupVersion,
        this.containers,
        this.containersRunning,
        this.containersStopped,
        this.containersPaused,
        this.cpuCfsPeriod,
        this.cpuCfsQuota,
        this.debug,
        this.dockerRootDir,
        this.storageDriver,
        this.driverStatus,
        this.experimentalBuild,
        this.httpProxy,
        this.httpsProxy,
        this.id,
        this.ipv4Forwarding,
        this.images,
        this.indexServerAddress,
        this.initPath,
        this.initSha1,
        this.kernelMemory,
        this.kernelVersion,
        this.labels,
        this.memTotal,
        this.memoryLimit,
        this.cpus,
        this.eventsListener,
        this.fileDescriptors,
        this.goroutines,
        this.name,
        this.noProxy,
        this.oomKillDisable,
        this.operatingSystem,
        this.osType,
        this.osVersion,
        value,
        this.registryConfig,
        this.serverVersion,
        this.swapLimit,
        this.swarm,
        this.systemStatus,
        this.systemTime);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Info#registryConfig() registryConfig} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for registryConfig
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableInfo withRegistryConfig(Info.RegistryConfig value) {
    if (this.registryConfig == value) return this;
    Info.RegistryConfig newValue = Objects.requireNonNull(value, "registryConfig");
    return new ImmutableInfo(
        this.architecture,
        this.clusterStore,
        this.cgroupDriver,
        this.cgroupVersion,
        this.containers,
        this.containersRunning,
        this.containersStopped,
        this.containersPaused,
        this.cpuCfsPeriod,
        this.cpuCfsQuota,
        this.debug,
        this.dockerRootDir,
        this.storageDriver,
        this.driverStatus,
        this.experimentalBuild,
        this.httpProxy,
        this.httpsProxy,
        this.id,
        this.ipv4Forwarding,
        this.images,
        this.indexServerAddress,
        this.initPath,
        this.initSha1,
        this.kernelMemory,
        this.kernelVersion,
        this.labels,
        this.memTotal,
        this.memoryLimit,
        this.cpus,
        this.eventsListener,
        this.fileDescriptors,
        this.goroutines,
        this.name,
        this.noProxy,
        this.oomKillDisable,
        this.operatingSystem,
        this.osType,
        this.osVersion,
        this.plugins,
        newValue,
        this.serverVersion,
        this.swapLimit,
        this.swarm,
        this.systemStatus,
        this.systemTime);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Info#serverVersion() serverVersion} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for serverVersion (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableInfo withServerVersion(@Nullable String value) {
    if (Objects.equals(this.serverVersion, value)) return this;
    return new ImmutableInfo(
        this.architecture,
        this.clusterStore,
        this.cgroupDriver,
        this.cgroupVersion,
        this.containers,
        this.containersRunning,
        this.containersStopped,
        this.containersPaused,
        this.cpuCfsPeriod,
        this.cpuCfsQuota,
        this.debug,
        this.dockerRootDir,
        this.storageDriver,
        this.driverStatus,
        this.experimentalBuild,
        this.httpProxy,
        this.httpsProxy,
        this.id,
        this.ipv4Forwarding,
        this.images,
        this.indexServerAddress,
        this.initPath,
        this.initSha1,
        this.kernelMemory,
        this.kernelVersion,
        this.labels,
        this.memTotal,
        this.memoryLimit,
        this.cpus,
        this.eventsListener,
        this.fileDescriptors,
        this.goroutines,
        this.name,
        this.noProxy,
        this.oomKillDisable,
        this.operatingSystem,
        this.osType,
        this.osVersion,
        this.plugins,
        this.registryConfig,
        value,
        this.swapLimit,
        this.swarm,
        this.systemStatus,
        this.systemTime);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Info#swapLimit() swapLimit} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for swapLimit
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableInfo withSwapLimit(Boolean value) {
    Boolean newValue = Objects.requireNonNull(value, "swapLimit");
    if (this.swapLimit.equals(newValue)) return this;
    return new ImmutableInfo(
        this.architecture,
        this.clusterStore,
        this.cgroupDriver,
        this.cgroupVersion,
        this.containers,
        this.containersRunning,
        this.containersStopped,
        this.containersPaused,
        this.cpuCfsPeriod,
        this.cpuCfsQuota,
        this.debug,
        this.dockerRootDir,
        this.storageDriver,
        this.driverStatus,
        this.experimentalBuild,
        this.httpProxy,
        this.httpsProxy,
        this.id,
        this.ipv4Forwarding,
        this.images,
        this.indexServerAddress,
        this.initPath,
        this.initSha1,
        this.kernelMemory,
        this.kernelVersion,
        this.labels,
        this.memTotal,
        this.memoryLimit,
        this.cpus,
        this.eventsListener,
        this.fileDescriptors,
        this.goroutines,
        this.name,
        this.noProxy,
        this.oomKillDisable,
        this.operatingSystem,
        this.osType,
        this.osVersion,
        this.plugins,
        this.registryConfig,
        this.serverVersion,
        newValue,
        this.swarm,
        this.systemStatus,
        this.systemTime);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Info#swarm() swarm} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for swarm (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableInfo withSwarm(@Nullable SwarmInfo value) {
    if (this.swarm == value) return this;
    return new ImmutableInfo(
        this.architecture,
        this.clusterStore,
        this.cgroupDriver,
        this.cgroupVersion,
        this.containers,
        this.containersRunning,
        this.containersStopped,
        this.containersPaused,
        this.cpuCfsPeriod,
        this.cpuCfsQuota,
        this.debug,
        this.dockerRootDir,
        this.storageDriver,
        this.driverStatus,
        this.experimentalBuild,
        this.httpProxy,
        this.httpsProxy,
        this.id,
        this.ipv4Forwarding,
        this.images,
        this.indexServerAddress,
        this.initPath,
        this.initSha1,
        this.kernelMemory,
        this.kernelVersion,
        this.labels,
        this.memTotal,
        this.memoryLimit,
        this.cpus,
        this.eventsListener,
        this.fileDescriptors,
        this.goroutines,
        this.name,
        this.noProxy,
        this.oomKillDisable,
        this.operatingSystem,
        this.osType,
        this.osVersion,
        this.plugins,
        this.registryConfig,
        this.serverVersion,
        this.swapLimit,
        value,
        this.systemStatus,
        this.systemTime);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Info#systemStatus() systemStatus}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  @SafeVarargs @SuppressWarnings("varargs")
  public final ImmutableInfo withSystemStatus(@Nullable List<String>... elements) {
    if (elements == null) {
      return new ImmutableInfo(
          this.architecture,
          this.clusterStore,
          this.cgroupDriver,
          this.cgroupVersion,
          this.containers,
          this.containersRunning,
          this.containersStopped,
          this.containersPaused,
          this.cpuCfsPeriod,
          this.cpuCfsQuota,
          this.debug,
          this.dockerRootDir,
          this.storageDriver,
          this.driverStatus,
          this.experimentalBuild,
          this.httpProxy,
          this.httpsProxy,
          this.id,
          this.ipv4Forwarding,
          this.images,
          this.indexServerAddress,
          this.initPath,
          this.initSha1,
          this.kernelMemory,
          this.kernelVersion,
          this.labels,
          this.memTotal,
          this.memoryLimit,
          this.cpus,
          this.eventsListener,
          this.fileDescriptors,
          this.goroutines,
          this.name,
          this.noProxy,
          this.oomKillDisable,
          this.operatingSystem,
          this.osType,
          this.osVersion,
          this.plugins,
          this.registryConfig,
          this.serverVersion,
          this.swapLimit,
          this.swarm,
          null,
          this.systemTime);
    }
    @Nullable List<List<String>> newValue = Arrays.asList(elements) == null ? null : createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableInfo(
        this.architecture,
        this.clusterStore,
        this.cgroupDriver,
        this.cgroupVersion,
        this.containers,
        this.containersRunning,
        this.containersStopped,
        this.containersPaused,
        this.cpuCfsPeriod,
        this.cpuCfsQuota,
        this.debug,
        this.dockerRootDir,
        this.storageDriver,
        this.driverStatus,
        this.experimentalBuild,
        this.httpProxy,
        this.httpsProxy,
        this.id,
        this.ipv4Forwarding,
        this.images,
        this.indexServerAddress,
        this.initPath,
        this.initSha1,
        this.kernelMemory,
        this.kernelVersion,
        this.labels,
        this.memTotal,
        this.memoryLimit,
        this.cpus,
        this.eventsListener,
        this.fileDescriptors,
        this.goroutines,
        this.name,
        this.noProxy,
        this.oomKillDisable,
        this.operatingSystem,
        this.osType,
        this.osVersion,
        this.plugins,
        this.registryConfig,
        this.serverVersion,
        this.swapLimit,
        this.swarm,
        newValue,
        this.systemTime);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Info#systemStatus() systemStatus}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of systemStatus elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableInfo withSystemStatus(@Nullable Iterable<? extends List<String>> elements) {
    if (this.systemStatus == elements) return this;
    @Nullable List<List<String>> newValue = elements == null ? null : createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableInfo(
        this.architecture,
        this.clusterStore,
        this.cgroupDriver,
        this.cgroupVersion,
        this.containers,
        this.containersRunning,
        this.containersStopped,
        this.containersPaused,
        this.cpuCfsPeriod,
        this.cpuCfsQuota,
        this.debug,
        this.dockerRootDir,
        this.storageDriver,
        this.driverStatus,
        this.experimentalBuild,
        this.httpProxy,
        this.httpsProxy,
        this.id,
        this.ipv4Forwarding,
        this.images,
        this.indexServerAddress,
        this.initPath,
        this.initSha1,
        this.kernelMemory,
        this.kernelVersion,
        this.labels,
        this.memTotal,
        this.memoryLimit,
        this.cpus,
        this.eventsListener,
        this.fileDescriptors,
        this.goroutines,
        this.name,
        this.noProxy,
        this.oomKillDisable,
        this.operatingSystem,
        this.osType,
        this.osVersion,
        this.plugins,
        this.registryConfig,
        this.serverVersion,
        this.swapLimit,
        this.swarm,
        newValue,
        this.systemTime);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Info#systemTime() systemTime} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for systemTime
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableInfo withSystemTime(Date value) {
    if (this.systemTime == value) return this;
    Date newValue = Objects.requireNonNull(value, "systemTime");
    return new ImmutableInfo(
        this.architecture,
        this.clusterStore,
        this.cgroupDriver,
        this.cgroupVersion,
        this.containers,
        this.containersRunning,
        this.containersStopped,
        this.containersPaused,
        this.cpuCfsPeriod,
        this.cpuCfsQuota,
        this.debug,
        this.dockerRootDir,
        this.storageDriver,
        this.driverStatus,
        this.experimentalBuild,
        this.httpProxy,
        this.httpsProxy,
        this.id,
        this.ipv4Forwarding,
        this.images,
        this.indexServerAddress,
        this.initPath,
        this.initSha1,
        this.kernelMemory,
        this.kernelVersion,
        this.labels,
        this.memTotal,
        this.memoryLimit,
        this.cpus,
        this.eventsListener,
        this.fileDescriptors,
        this.goroutines,
        this.name,
        this.noProxy,
        this.oomKillDisable,
        this.operatingSystem,
        this.osType,
        this.osVersion,
        this.plugins,
        this.registryConfig,
        this.serverVersion,
        this.swapLimit,
        this.swarm,
        this.systemStatus,
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableInfo} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableInfo
        && equalTo((ImmutableInfo) another);
  }

  private boolean equalTo(ImmutableInfo another) {
    return Objects.equals(architecture, another.architecture)
        && Objects.equals(clusterStore, another.clusterStore)
        && Objects.equals(cgroupDriver, another.cgroupDriver)
        && Objects.equals(cgroupVersion, another.cgroupVersion)
        && containers.equals(another.containers)
        && Objects.equals(containersRunning, another.containersRunning)
        && Objects.equals(containersStopped, another.containersStopped)
        && Objects.equals(containersPaused, another.containersPaused)
        && Objects.equals(cpuCfsPeriod, another.cpuCfsPeriod)
        && Objects.equals(cpuCfsQuota, another.cpuCfsQuota)
        && debug.equals(another.debug)
        && dockerRootDir.equals(another.dockerRootDir)
        && storageDriver.equals(another.storageDriver)
        && driverStatus.equals(another.driverStatus)
        && Objects.equals(experimentalBuild, another.experimentalBuild)
        && Objects.equals(httpProxy, another.httpProxy)
        && Objects.equals(httpsProxy, another.httpsProxy)
        && id.equals(another.id)
        && ipv4Forwarding.equals(another.ipv4Forwarding)
        && images.equals(another.images)
        && indexServerAddress.equals(another.indexServerAddress)
        && Objects.equals(initPath, another.initPath)
        && Objects.equals(initSha1, another.initSha1)
        && Objects.equals(kernelMemory, another.kernelMemory)
        && kernelVersion.equals(another.kernelVersion)
        && labels.equals(another.labels)
        && memTotal.equals(another.memTotal)
        && memoryLimit.equals(another.memoryLimit)
        && cpus.equals(another.cpus)
        && eventsListener.equals(another.eventsListener)
        && fileDescriptors.equals(another.fileDescriptors)
        && goroutines.equals(another.goroutines)
        && name.equals(another.name)
        && Objects.equals(noProxy, another.noProxy)
        && Objects.equals(oomKillDisable, another.oomKillDisable)
        && operatingSystem.equals(another.operatingSystem)
        && Objects.equals(osType, another.osType)
        && Objects.equals(osVersion, another.osVersion)
        && Objects.equals(plugins, another.plugins)
        && registryConfig.equals(another.registryConfig)
        && Objects.equals(serverVersion, another.serverVersion)
        && swapLimit.equals(another.swapLimit)
        && Objects.equals(swarm, another.swarm)
        && Objects.equals(systemStatus, another.systemStatus)
        && systemTime.equals(another.systemTime);
  }

  /**
   * Computes a hash code from attributes: {@code architecture}, {@code clusterStore}, {@code cgroupDriver}, {@code cgroupVersion}, {@code containers}, {@code containersRunning}, {@code containersStopped}, {@code containersPaused}, {@code cpuCfsPeriod}, {@code cpuCfsQuota}, {@code debug}, {@code dockerRootDir}, {@code storageDriver}, {@code driverStatus}, {@code experimentalBuild}, {@code httpProxy}, {@code httpsProxy}, {@code id}, {@code ipv4Forwarding}, {@code images}, {@code indexServerAddress}, {@code initPath}, {@code initSha1}, {@code kernelMemory}, {@code kernelVersion}, {@code labels}, {@code memTotal}, {@code memoryLimit}, {@code cpus}, {@code eventsListener}, {@code fileDescriptors}, {@code goroutines}, {@code name}, {@code noProxy}, {@code oomKillDisable}, {@code operatingSystem}, {@code osType}, {@code osVersion}, {@code plugins}, {@code registryConfig}, {@code serverVersion}, {@code swapLimit}, {@code swarm}, {@code systemStatus}, {@code systemTime}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(architecture);
    h += (h << 5) + Objects.hashCode(clusterStore);
    h += (h << 5) + Objects.hashCode(cgroupDriver);
    h += (h << 5) + Objects.hashCode(cgroupVersion);
    h += (h << 5) + containers.hashCode();
    h += (h << 5) + Objects.hashCode(containersRunning);
    h += (h << 5) + Objects.hashCode(containersStopped);
    h += (h << 5) + Objects.hashCode(containersPaused);
    h += (h << 5) + Objects.hashCode(cpuCfsPeriod);
    h += (h << 5) + Objects.hashCode(cpuCfsQuota);
    h += (h << 5) + debug.hashCode();
    h += (h << 5) + dockerRootDir.hashCode();
    h += (h << 5) + storageDriver.hashCode();
    h += (h << 5) + driverStatus.hashCode();
    h += (h << 5) + Objects.hashCode(experimentalBuild);
    h += (h << 5) + Objects.hashCode(httpProxy);
    h += (h << 5) + Objects.hashCode(httpsProxy);
    h += (h << 5) + id.hashCode();
    h += (h << 5) + ipv4Forwarding.hashCode();
    h += (h << 5) + images.hashCode();
    h += (h << 5) + indexServerAddress.hashCode();
    h += (h << 5) + Objects.hashCode(initPath);
    h += (h << 5) + Objects.hashCode(initSha1);
    h += (h << 5) + Objects.hashCode(kernelMemory);
    h += (h << 5) + kernelVersion.hashCode();
    h += (h << 5) + labels.hashCode();
    h += (h << 5) + memTotal.hashCode();
    h += (h << 5) + memoryLimit.hashCode();
    h += (h << 5) + cpus.hashCode();
    h += (h << 5) + eventsListener.hashCode();
    h += (h << 5) + fileDescriptors.hashCode();
    h += (h << 5) + goroutines.hashCode();
    h += (h << 5) + name.hashCode();
    h += (h << 5) + Objects.hashCode(noProxy);
    h += (h << 5) + Objects.hashCode(oomKillDisable);
    h += (h << 5) + operatingSystem.hashCode();
    h += (h << 5) + Objects.hashCode(osType);
    h += (h << 5) + Objects.hashCode(osVersion);
    h += (h << 5) + Objects.hashCode(plugins);
    h += (h << 5) + registryConfig.hashCode();
    h += (h << 5) + Objects.hashCode(serverVersion);
    h += (h << 5) + swapLimit.hashCode();
    h += (h << 5) + Objects.hashCode(swarm);
    h += (h << 5) + Objects.hashCode(systemStatus);
    h += (h << 5) + systemTime.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Info} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Info{"
        + "architecture=" + architecture
        + ", clusterStore=" + clusterStore
        + ", cgroupDriver=" + cgroupDriver
        + ", cgroupVersion=" + cgroupVersion
        + ", containers=" + containers
        + ", containersRunning=" + containersRunning
        + ", containersStopped=" + containersStopped
        + ", containersPaused=" + containersPaused
        + ", cpuCfsPeriod=" + cpuCfsPeriod
        + ", cpuCfsQuota=" + cpuCfsQuota
        + ", debug=" + debug
        + ", dockerRootDir=" + dockerRootDir
        + ", storageDriver=" + storageDriver
        + ", driverStatus=" + driverStatus
        + ", experimentalBuild=" + experimentalBuild
        + ", httpProxy=" + httpProxy
        + ", httpsProxy=" + httpsProxy
        + ", id=" + id
        + ", ipv4Forwarding=" + ipv4Forwarding
        + ", images=" + images
        + ", indexServerAddress=" + indexServerAddress
        + ", initPath=" + initPath
        + ", initSha1=" + initSha1
        + ", kernelMemory=" + kernelMemory
        + ", kernelVersion=" + kernelVersion
        + ", labels=" + labels
        + ", memTotal=" + memTotal
        + ", memoryLimit=" + memoryLimit
        + ", cpus=" + cpus
        + ", eventsListener=" + eventsListener
        + ", fileDescriptors=" + fileDescriptors
        + ", goroutines=" + goroutines
        + ", name=" + name
        + ", noProxy=" + noProxy
        + ", oomKillDisable=" + oomKillDisable
        + ", operatingSystem=" + operatingSystem
        + ", osType=" + osType
        + ", osVersion=" + osVersion
        + ", plugins=" + plugins
        + ", registryConfig=" + registryConfig
        + ", serverVersion=" + serverVersion
        + ", swapLimit=" + swapLimit
        + ", swarm=" + swarm
        + ", systemStatus=" + systemStatus
        + ", systemTime=" + systemTime
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link Info} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Info instance
   */
  public static ImmutableInfo copyOf(Info instance) {
    if (instance instanceof ImmutableInfo) {
      return (ImmutableInfo) instance;
    }
    return ImmutableInfo.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableInfo ImmutableInfo}.
   * <pre>
   * ImmutableInfo.builder()
   *    .architecture(String | null) // nullable {@link Info#architecture() architecture}
   *    .clusterStore(String | null) // nullable {@link Info#clusterStore() clusterStore}
   *    .cgroupDriver(String | null) // nullable {@link Info#cgroupDriver() cgroupDriver}
   *    .cgroupVersion(String | null) // nullable {@link Info#cgroupVersion() cgroupVersion}
   *    .containers(Integer) // required {@link Info#containers() containers}
   *    .containersRunning(Integer | null) // nullable {@link Info#containersRunning() containersRunning}
   *    .containersStopped(Integer | null) // nullable {@link Info#containersStopped() containersStopped}
   *    .containersPaused(Integer | null) // nullable {@link Info#containersPaused() containersPaused}
   *    .cpuCfsPeriod(Boolean | null) // nullable {@link Info#cpuCfsPeriod() cpuCfsPeriod}
   *    .cpuCfsQuota(Boolean | null) // nullable {@link Info#cpuCfsQuota() cpuCfsQuota}
   *    .debug(Boolean) // required {@link Info#debug() debug}
   *    .dockerRootDir(String) // required {@link Info#dockerRootDir() dockerRootDir}
   *    .storageDriver(String) // required {@link Info#storageDriver() storageDriver}
   *    .driverStatu|addAllDriverStatus(List&amp;lt;String&amp;gt;) // {@link Info#driverStatus() driverStatus} elements
   *    .experimentalBuild(Boolean | null) // nullable {@link Info#experimentalBuild() experimentalBuild}
   *    .httpProxy(String | null) // nullable {@link Info#httpProxy() httpProxy}
   *    .httpsProxy(String | null) // nullable {@link Info#httpsProxy() httpsProxy}
   *    .id(String) // required {@link Info#id() id}
   *    .ipv4Forwarding(Boolean) // required {@link Info#ipv4Forwarding() ipv4Forwarding}
   *    .images(Integer) // required {@link Info#images() images}
   *    .indexServerAddress(String) // required {@link Info#indexServerAddress() indexServerAddress}
   *    .initPath(String | null) // nullable {@link Info#initPath() initPath}
   *    .initSha1(String | null) // nullable {@link Info#initSha1() initSha1}
   *    .kernelMemory(Boolean | null) // nullable {@link Info#kernelMemory() kernelMemory}
   *    .kernelVersion(String) // required {@link Info#kernelVersion() kernelVersion}
   *    .label|addAllLabels(String) // {@link Info#labels() labels} elements
   *    .memTotal(Long) // required {@link Info#memTotal() memTotal}
   *    .memoryLimit(Boolean) // required {@link Info#memoryLimit() memoryLimit}
   *    .cpus(Integer) // required {@link Info#cpus() cpus}
   *    .eventsListener(Integer) // required {@link Info#eventsListener() eventsListener}
   *    .fileDescriptors(Integer) // required {@link Info#fileDescriptors() fileDescriptors}
   *    .goroutines(Integer) // required {@link Info#goroutines() goroutines}
   *    .name(String) // required {@link Info#name() name}
   *    .noProxy(String | null) // nullable {@link Info#noProxy() noProxy}
   *    .oomKillDisable(Boolean | null) // nullable {@link Info#oomKillDisable() oomKillDisable}
   *    .operatingSystem(String) // required {@link Info#operatingSystem() operatingSystem}
   *    .osType(String | null) // nullable {@link Info#osType() osType}
   *    .osVersion(String | null) // nullable {@link Info#osVersion() osVersion}
   *    .plugins(org.mandas.docker.client.messages.Info.Plugins | null) // nullable {@link Info#plugins() plugins}
   *    .registryConfig(org.mandas.docker.client.messages.Info.RegistryConfig) // required {@link Info#registryConfig() registryConfig}
   *    .serverVersion(String | null) // nullable {@link Info#serverVersion() serverVersion}
   *    .swapLimit(Boolean) // required {@link Info#swapLimit() swapLimit}
   *    .swarm(org.mandas.docker.client.messages.swarm.SwarmInfo | null) // nullable {@link Info#swarm() swarm}
   *    .systemStatus(List&amp;lt;List&amp;lt;String&amp;gt;&amp;gt; | null) // nullable {@link Info#systemStatus() systemStatus}
   *    .systemTime(Date) // required {@link Info#systemTime() systemTime}
   *    .build();
   * </pre>
   * @return A new ImmutableInfo builder
   */
  public static ImmutableInfo.Builder builder() {
    return new ImmutableInfo.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableInfo ImmutableInfo}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  static final class Builder {
    private static final long INIT_BIT_CONTAINERS = 0x1L;
    private static final long INIT_BIT_DEBUG = 0x2L;
    private static final long INIT_BIT_DOCKER_ROOT_DIR = 0x4L;
    private static final long INIT_BIT_STORAGE_DRIVER = 0x8L;
    private static final long INIT_BIT_ID = 0x10L;
    private static final long INIT_BIT_IPV4_FORWARDING = 0x20L;
    private static final long INIT_BIT_IMAGES = 0x40L;
    private static final long INIT_BIT_INDEX_SERVER_ADDRESS = 0x80L;
    private static final long INIT_BIT_KERNEL_VERSION = 0x100L;
    private static final long INIT_BIT_MEM_TOTAL = 0x200L;
    private static final long INIT_BIT_MEMORY_LIMIT = 0x400L;
    private static final long INIT_BIT_CPUS = 0x800L;
    private static final long INIT_BIT_EVENTS_LISTENER = 0x1000L;
    private static final long INIT_BIT_FILE_DESCRIPTORS = 0x2000L;
    private static final long INIT_BIT_GOROUTINES = 0x4000L;
    private static final long INIT_BIT_NAME = 0x8000L;
    private static final long INIT_BIT_OPERATING_SYSTEM = 0x10000L;
    private static final long INIT_BIT_REGISTRY_CONFIG = 0x20000L;
    private static final long INIT_BIT_SWAP_LIMIT = 0x40000L;
    private static final long INIT_BIT_SYSTEM_TIME = 0x80000L;
    private long initBits = 0xfffffL;

    private String architecture;
    private String clusterStore;
    private String cgroupDriver;
    private String cgroupVersion;
    private Integer containers;
    private Integer containersRunning;
    private Integer containersStopped;
    private Integer containersPaused;
    private Boolean cpuCfsPeriod;
    private Boolean cpuCfsQuota;
    private Boolean debug;
    private String dockerRootDir;
    private String storageDriver;
    private List<List<String>> driverStatus = new ArrayList<List<String>>();
    private Boolean experimentalBuild;
    private String httpProxy;
    private String httpsProxy;
    private String id;
    private Boolean ipv4Forwarding;
    private Integer images;
    private String indexServerAddress;
    private String initPath;
    private String initSha1;
    private Boolean kernelMemory;
    private String kernelVersion;
    private List<String> labels = new ArrayList<String>();
    private Long memTotal;
    private Boolean memoryLimit;
    private Integer cpus;
    private Integer eventsListener;
    private Integer fileDescriptors;
    private Integer goroutines;
    private String name;
    private String noProxy;
    private Boolean oomKillDisable;
    private String operatingSystem;
    private String osType;
    private String osVersion;
    private Info.Plugins plugins;
    private Info.RegistryConfig registryConfig;
    private String serverVersion;
    private Boolean swapLimit;
    private SwarmInfo swarm;
    private List<List<String>> systemStatus = null;
    private Date systemTime;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Info} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Info instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable String architectureValue = instance.architecture();
      if (architectureValue != null) {
        architecture(architectureValue);
      }
      @Nullable String clusterStoreValue = instance.clusterStore();
      if (clusterStoreValue != null) {
        clusterStore(clusterStoreValue);
      }
      @Nullable String cgroupDriverValue = instance.cgroupDriver();
      if (cgroupDriverValue != null) {
        cgroupDriver(cgroupDriverValue);
      }
      @Nullable String cgroupVersionValue = instance.cgroupVersion();
      if (cgroupVersionValue != null) {
        cgroupVersion(cgroupVersionValue);
      }
      containers(instance.containers());
      @Nullable Integer containersRunningValue = instance.containersRunning();
      if (containersRunningValue != null) {
        containersRunning(containersRunningValue);
      }
      @Nullable Integer containersStoppedValue = instance.containersStopped();
      if (containersStoppedValue != null) {
        containersStopped(containersStoppedValue);
      }
      @Nullable Integer containersPausedValue = instance.containersPaused();
      if (containersPausedValue != null) {
        containersPaused(containersPausedValue);
      }
      @Nullable Boolean cpuCfsPeriodValue = instance.cpuCfsPeriod();
      if (cpuCfsPeriodValue != null) {
        cpuCfsPeriod(cpuCfsPeriodValue);
      }
      @Nullable Boolean cpuCfsQuotaValue = instance.cpuCfsQuota();
      if (cpuCfsQuotaValue != null) {
        cpuCfsQuota(cpuCfsQuotaValue);
      }
      debug(instance.debug());
      dockerRootDir(instance.dockerRootDir());
      storageDriver(instance.storageDriver());
      addAllDriverStatus(instance.driverStatus());
      @Nullable Boolean experimentalBuildValue = instance.experimentalBuild();
      if (experimentalBuildValue != null) {
        experimentalBuild(experimentalBuildValue);
      }
      @Nullable String httpProxyValue = instance.httpProxy();
      if (httpProxyValue != null) {
        httpProxy(httpProxyValue);
      }
      @Nullable String httpsProxyValue = instance.httpsProxy();
      if (httpsProxyValue != null) {
        httpsProxy(httpsProxyValue);
      }
      id(instance.id());
      ipv4Forwarding(instance.ipv4Forwarding());
      images(instance.images());
      indexServerAddress(instance.indexServerAddress());
      @Nullable String initPathValue = instance.initPath();
      if (initPathValue != null) {
        initPath(initPathValue);
      }
      @Nullable String initSha1Value = instance.initSha1();
      if (initSha1Value != null) {
        initSha1(initSha1Value);
      }
      @Nullable Boolean kernelMemoryValue = instance.kernelMemory();
      if (kernelMemoryValue != null) {
        kernelMemory(kernelMemoryValue);
      }
      kernelVersion(instance.kernelVersion());
      addAllLabels(instance.labels());
      memTotal(instance.memTotal());
      memoryLimit(instance.memoryLimit());
      cpus(instance.cpus());
      eventsListener(instance.eventsListener());
      fileDescriptors(instance.fileDescriptors());
      goroutines(instance.goroutines());
      name(instance.name());
      @Nullable String noProxyValue = instance.noProxy();
      if (noProxyValue != null) {
        noProxy(noProxyValue);
      }
      @Nullable Boolean oomKillDisableValue = instance.oomKillDisable();
      if (oomKillDisableValue != null) {
        oomKillDisable(oomKillDisableValue);
      }
      operatingSystem(instance.operatingSystem());
      @Nullable String osTypeValue = instance.osType();
      if (osTypeValue != null) {
        osType(osTypeValue);
      }
      @Nullable String osVersionValue = instance.osVersion();
      if (osVersionValue != null) {
        osVersion(osVersionValue);
      }
      @Nullable Info.Plugins pluginsValue = instance.plugins();
      if (pluginsValue != null) {
        plugins(pluginsValue);
      }
      registryConfig(instance.registryConfig());
      @Nullable String serverVersionValue = instance.serverVersion();
      if (serverVersionValue != null) {
        serverVersion(serverVersionValue);
      }
      swapLimit(instance.swapLimit());
      @Nullable SwarmInfo swarmValue = instance.swarm();
      if (swarmValue != null) {
        swarm(swarmValue);
      }
      @Nullable List<List<String>> systemStatusValue = instance.systemStatus();
      if (systemStatusValue != null) {
        addAllSystemStatus(systemStatusValue);
      }
      systemTime(instance.systemTime());
      return this;
    }

    /**
     * Initializes the value for the {@link Info#architecture() architecture} attribute.
     * @param architecture The value for architecture (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("Architecture")
    public final Builder architecture(@Nullable String architecture) {
      this.architecture = architecture;
      return this;
    }

    /**
     * Initializes the value for the {@link Info#clusterStore() clusterStore} attribute.
     * @param clusterStore The value for clusterStore (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("ClusterStore")
    @Deprecated
    public final Builder clusterStore(@Nullable String clusterStore) {
      this.clusterStore = clusterStore;
      return this;
    }

    /**
     * Initializes the value for the {@link Info#cgroupDriver() cgroupDriver} attribute.
     * @param cgroupDriver The value for cgroupDriver (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("CgroupDriver")
    public final Builder cgroupDriver(@Nullable String cgroupDriver) {
      this.cgroupDriver = cgroupDriver;
      return this;
    }

    /**
     * Initializes the value for the {@link Info#cgroupVersion() cgroupVersion} attribute.
     * @param cgroupVersion The value for cgroupVersion (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("CgroupVersion")
    public final Builder cgroupVersion(@Nullable String cgroupVersion) {
      this.cgroupVersion = cgroupVersion;
      return this;
    }

    /**
     * Initializes the value for the {@link Info#containers() containers} attribute.
     * @param containers The value for containers 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("Containers")
    public final Builder containers(Integer containers) {
      this.containers = Objects.requireNonNull(containers, "containers");
      initBits &= ~INIT_BIT_CONTAINERS;
      return this;
    }

    /**
     * Initializes the value for the {@link Info#containersRunning() containersRunning} attribute.
     * @param containersRunning The value for containersRunning (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("ContainersRunning")
    public final Builder containersRunning(@Nullable Integer containersRunning) {
      this.containersRunning = containersRunning;
      return this;
    }

    /**
     * Initializes the value for the {@link Info#containersStopped() containersStopped} attribute.
     * @param containersStopped The value for containersStopped (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("ContainersStopped")
    public final Builder containersStopped(@Nullable Integer containersStopped) {
      this.containersStopped = containersStopped;
      return this;
    }

    /**
     * Initializes the value for the {@link Info#containersPaused() containersPaused} attribute.
     * @param containersPaused The value for containersPaused (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("ContainersPaused")
    public final Builder containersPaused(@Nullable Integer containersPaused) {
      this.containersPaused = containersPaused;
      return this;
    }

    /**
     * Initializes the value for the {@link Info#cpuCfsPeriod() cpuCfsPeriod} attribute.
     * @param cpuCfsPeriod The value for cpuCfsPeriod (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("CpuCfsPeriod")
    public final Builder cpuCfsPeriod(@Nullable Boolean cpuCfsPeriod) {
      this.cpuCfsPeriod = cpuCfsPeriod;
      return this;
    }

    /**
     * Initializes the value for the {@link Info#cpuCfsQuota() cpuCfsQuota} attribute.
     * @param cpuCfsQuota The value for cpuCfsQuota (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("CpuCfsQuota")
    public final Builder cpuCfsQuota(@Nullable Boolean cpuCfsQuota) {
      this.cpuCfsQuota = cpuCfsQuota;
      return this;
    }

    /**
     * Initializes the value for the {@link Info#debug() debug} attribute.
     * @param debug The value for debug 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("Debug")
    public final Builder debug(Boolean debug) {
      this.debug = Objects.requireNonNull(debug, "debug");
      initBits &= ~INIT_BIT_DEBUG;
      return this;
    }

    /**
     * Initializes the value for the {@link Info#dockerRootDir() dockerRootDir} attribute.
     * @param dockerRootDir The value for dockerRootDir 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("DockerRootDir")
    public final Builder dockerRootDir(String dockerRootDir) {
      this.dockerRootDir = Objects.requireNonNull(dockerRootDir, "dockerRootDir");
      initBits &= ~INIT_BIT_DOCKER_ROOT_DIR;
      return this;
    }

    /**
     * Initializes the value for the {@link Info#storageDriver() storageDriver} attribute.
     * @param storageDriver The value for storageDriver 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("Driver")
    public final Builder storageDriver(String storageDriver) {
      this.storageDriver = Objects.requireNonNull(storageDriver, "storageDriver");
      initBits &= ~INIT_BIT_STORAGE_DRIVER;
      return this;
    }

    /**
     * Adds one element to {@link Info#driverStatus() driverStatus} list.
     * @param element A driverStatus element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder driverStatu(List<String> element) {
      this.driverStatus.add(Objects.requireNonNull(element, "driverStatus element"));
      return this;
    }

    /**
     * Adds elements to {@link Info#driverStatus() driverStatus} list.
     * @param elements An array of driverStatus elements
     * @return {@code this} builder for use in a chained invocation
     */
    @SafeVarargs @SuppressWarnings("varargs")
    public final Builder driverStatus(List<String>... elements) {
      for (List<String> element : elements) {
        this.driverStatus.add(Objects.requireNonNull(element, "driverStatus element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Info#driverStatus() driverStatus} list.
     * @param elements An iterable of driverStatus elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("DriverStatus")
    public final Builder driverStatus(Iterable<? extends List<String>> elements) {
      this.driverStatus.clear();
      return addAllDriverStatus(elements);
    }

    /**
     * Adds elements to {@link Info#driverStatus() driverStatus} list.
     * @param elements An iterable of driverStatus elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllDriverStatus(Iterable<? extends List<String>> elements) {
      for (List<String> element : elements) {
        this.driverStatus.add(Objects.requireNonNull(element, "driverStatus element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Info#experimentalBuild() experimentalBuild} attribute.
     * @param experimentalBuild The value for experimentalBuild (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("ExperimentalBuild")
    public final Builder experimentalBuild(@Nullable Boolean experimentalBuild) {
      this.experimentalBuild = experimentalBuild;
      return this;
    }

    /**
     * Initializes the value for the {@link Info#httpProxy() httpProxy} attribute.
     * @param httpProxy The value for httpProxy (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("HttpProxy")
    public final Builder httpProxy(@Nullable String httpProxy) {
      this.httpProxy = httpProxy;
      return this;
    }

    /**
     * Initializes the value for the {@link Info#httpsProxy() httpsProxy} attribute.
     * @param httpsProxy The value for httpsProxy (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("HttpsProxy")
    public final Builder httpsProxy(@Nullable String httpsProxy) {
      this.httpsProxy = httpsProxy;
      return this;
    }

    /**
     * Initializes the value for the {@link Info#id() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("ID")
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link Info#ipv4Forwarding() ipv4Forwarding} attribute.
     * @param ipv4Forwarding The value for ipv4Forwarding 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("IPv4Forwarding")
    public final Builder ipv4Forwarding(Boolean ipv4Forwarding) {
      this.ipv4Forwarding = Objects.requireNonNull(ipv4Forwarding, "ipv4Forwarding");
      initBits &= ~INIT_BIT_IPV4_FORWARDING;
      return this;
    }

    /**
     * Initializes the value for the {@link Info#images() images} attribute.
     * @param images The value for images 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("Images")
    public final Builder images(Integer images) {
      this.images = Objects.requireNonNull(images, "images");
      initBits &= ~INIT_BIT_IMAGES;
      return this;
    }

    /**
     * Initializes the value for the {@link Info#indexServerAddress() indexServerAddress} attribute.
     * @param indexServerAddress The value for indexServerAddress 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("IndexServerAddress")
    public final Builder indexServerAddress(String indexServerAddress) {
      this.indexServerAddress = Objects.requireNonNull(indexServerAddress, "indexServerAddress");
      initBits &= ~INIT_BIT_INDEX_SERVER_ADDRESS;
      return this;
    }

    /**
     * Initializes the value for the {@link Info#initPath() initPath} attribute.
     * @param initPath The value for initPath (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("InitPath")
    public final Builder initPath(@Nullable String initPath) {
      this.initPath = initPath;
      return this;
    }

    /**
     * Initializes the value for the {@link Info#initSha1() initSha1} attribute.
     * @param initSha1 The value for initSha1 (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("InitSha1")
    public final Builder initSha1(@Nullable String initSha1) {
      this.initSha1 = initSha1;
      return this;
    }

    /**
     * Initializes the value for the {@link Info#kernelMemory() kernelMemory} attribute.
     * @param kernelMemory The value for kernelMemory (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("KernelMemory")
    @Deprecated
    public final Builder kernelMemory(@Nullable Boolean kernelMemory) {
      this.kernelMemory = kernelMemory;
      return this;
    }

    /**
     * Initializes the value for the {@link Info#kernelVersion() kernelVersion} attribute.
     * @param kernelVersion The value for kernelVersion 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("KernelVersion")
    public final Builder kernelVersion(String kernelVersion) {
      this.kernelVersion = Objects.requireNonNull(kernelVersion, "kernelVersion");
      initBits &= ~INIT_BIT_KERNEL_VERSION;
      return this;
    }

    /**
     * Adds one element to {@link Info#labels() labels} list.
     * @param element A labels element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder label(String element) {
      this.labels.add(Objects.requireNonNull(element, "labels element"));
      return this;
    }

    /**
     * Adds elements to {@link Info#labels() labels} list.
     * @param elements An array of labels elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder labels(String... elements) {
      for (String element : elements) {
        this.labels.add(Objects.requireNonNull(element, "labels element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Info#labels() labels} list.
     * @param elements An iterable of labels elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("Labels")
    @JsonSetter(nulls = Nulls.AS_EMPTY)
    public final Builder labels(Iterable<String> elements) {
      this.labels.clear();
      return addAllLabels(elements);
    }

    /**
     * Adds elements to {@link Info#labels() labels} list.
     * @param elements An iterable of labels elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllLabels(Iterable<String> elements) {
      for (String element : elements) {
        this.labels.add(Objects.requireNonNull(element, "labels element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Info#memTotal() memTotal} attribute.
     * @param memTotal The value for memTotal 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("MemTotal")
    public final Builder memTotal(Long memTotal) {
      this.memTotal = Objects.requireNonNull(memTotal, "memTotal");
      initBits &= ~INIT_BIT_MEM_TOTAL;
      return this;
    }

    /**
     * Initializes the value for the {@link Info#memoryLimit() memoryLimit} attribute.
     * @param memoryLimit The value for memoryLimit 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("MemoryLimit")
    public final Builder memoryLimit(Boolean memoryLimit) {
      this.memoryLimit = Objects.requireNonNull(memoryLimit, "memoryLimit");
      initBits &= ~INIT_BIT_MEMORY_LIMIT;
      return this;
    }

    /**
     * Initializes the value for the {@link Info#cpus() cpus} attribute.
     * @param cpus The value for cpus 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("NCPU")
    public final Builder cpus(Integer cpus) {
      this.cpus = Objects.requireNonNull(cpus, "cpus");
      initBits &= ~INIT_BIT_CPUS;
      return this;
    }

    /**
     * Initializes the value for the {@link Info#eventsListener() eventsListener} attribute.
     * @param eventsListener The value for eventsListener 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("NEventsListener")
    public final Builder eventsListener(Integer eventsListener) {
      this.eventsListener = Objects.requireNonNull(eventsListener, "eventsListener");
      initBits &= ~INIT_BIT_EVENTS_LISTENER;
      return this;
    }

    /**
     * Initializes the value for the {@link Info#fileDescriptors() fileDescriptors} attribute.
     * @param fileDescriptors The value for fileDescriptors 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("NFd")
    public final Builder fileDescriptors(Integer fileDescriptors) {
      this.fileDescriptors = Objects.requireNonNull(fileDescriptors, "fileDescriptors");
      initBits &= ~INIT_BIT_FILE_DESCRIPTORS;
      return this;
    }

    /**
     * Initializes the value for the {@link Info#goroutines() goroutines} attribute.
     * @param goroutines The value for goroutines 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("NGoroutines")
    public final Builder goroutines(Integer goroutines) {
      this.goroutines = Objects.requireNonNull(goroutines, "goroutines");
      initBits &= ~INIT_BIT_GOROUTINES;
      return this;
    }

    /**
     * Initializes the value for the {@link Info#name() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("Name")
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link Info#noProxy() noProxy} attribute.
     * @param noProxy The value for noProxy (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("NoProxy")
    public final Builder noProxy(@Nullable String noProxy) {
      this.noProxy = noProxy;
      return this;
    }

    /**
     * Initializes the value for the {@link Info#oomKillDisable() oomKillDisable} attribute.
     * @param oomKillDisable The value for oomKillDisable (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("OomKillDisable")
    public final Builder oomKillDisable(@Nullable Boolean oomKillDisable) {
      this.oomKillDisable = oomKillDisable;
      return this;
    }

    /**
     * Initializes the value for the {@link Info#operatingSystem() operatingSystem} attribute.
     * @param operatingSystem The value for operatingSystem 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("OperatingSystem")
    public final Builder operatingSystem(String operatingSystem) {
      this.operatingSystem = Objects.requireNonNull(operatingSystem, "operatingSystem");
      initBits &= ~INIT_BIT_OPERATING_SYSTEM;
      return this;
    }

    /**
     * Initializes the value for the {@link Info#osType() osType} attribute.
     * @param osType The value for osType (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("OSType")
    public final Builder osType(@Nullable String osType) {
      this.osType = osType;
      return this;
    }

    /**
     * Initializes the value for the {@link Info#osVersion() osVersion} attribute.
     * @param osVersion The value for osVersion (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("OSVersion")
    public final Builder osVersion(@Nullable String osVersion) {
      this.osVersion = osVersion;
      return this;
    }

    /**
     * Initializes the value for the {@link Info#plugins() plugins} attribute.
     * @param plugins The value for plugins (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("Plugins")
    public final Builder plugins(@Nullable Info.Plugins plugins) {
      this.plugins = plugins;
      return this;
    }

    /**
     * Initializes the value for the {@link Info#registryConfig() registryConfig} attribute.
     * @param registryConfig The value for registryConfig 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("RegistryConfig")
    public final Builder registryConfig(Info.RegistryConfig registryConfig) {
      this.registryConfig = Objects.requireNonNull(registryConfig, "registryConfig");
      initBits &= ~INIT_BIT_REGISTRY_CONFIG;
      return this;
    }

    /**
     * Initializes the value for the {@link Info#serverVersion() serverVersion} attribute.
     * @param serverVersion The value for serverVersion (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("ServerVersion")
    public final Builder serverVersion(@Nullable String serverVersion) {
      this.serverVersion = serverVersion;
      return this;
    }

    /**
     * Initializes the value for the {@link Info#swapLimit() swapLimit} attribute.
     * @param swapLimit The value for swapLimit 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("SwapLimit")
    public final Builder swapLimit(Boolean swapLimit) {
      this.swapLimit = Objects.requireNonNull(swapLimit, "swapLimit");
      initBits &= ~INIT_BIT_SWAP_LIMIT;
      return this;
    }

    /**
     * Initializes the value for the {@link Info#swarm() swarm} attribute.
     * @param swarm The value for swarm (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("Swarm")
    public final Builder swarm(@Nullable SwarmInfo swarm) {
      this.swarm = swarm;
      return this;
    }

    /**
     * Adds one element to {@link Info#systemStatus() systemStatus} list.
     * @param element A systemStatus element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder systemStatu(List<String> element) {
      if (this.systemStatus == null) {
        this.systemStatus = new ArrayList<List<String>>();
      }
      this.systemStatus.add(Objects.requireNonNull(element, "systemStatus element"));
      return this;
    }

    /**
     * Adds elements to {@link Info#systemStatus() systemStatus} list.
     * @param elements An array of systemStatus elements
     * @return {@code this} builder for use in a chained invocation
     */
    @SafeVarargs @SuppressWarnings("varargs")
    public final Builder systemStatus(List<String>... elements) {
      if (this.systemStatus == null) {
        this.systemStatus = new ArrayList<List<String>>();
      }
      for (List<String> element : elements) {
        this.systemStatus.add(Objects.requireNonNull(element, "systemStatus element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Info#systemStatus() systemStatus} list.
     * @param elements An iterable of systemStatus elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("SystemStatus")
    public final Builder systemStatus(@Nullable Iterable<? extends List<String>> elements) {
      if (elements == null) {
        this.systemStatus = null;
        return this;
      }
      this.systemStatus = new ArrayList<List<String>>();
      return addAllSystemStatus(elements);
    }

    /**
     * Adds elements to {@link Info#systemStatus() systemStatus} list.
     * @param elements An iterable of systemStatus elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllSystemStatus(Iterable<? extends List<String>> elements) {
      Objects.requireNonNull(elements, "systemStatus element");
      if (this.systemStatus == null) {
        this.systemStatus = new ArrayList<List<String>>();
      }
      for (List<String> element : elements) {
        this.systemStatus.add(Objects.requireNonNull(element, "systemStatus element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Info#systemTime() systemTime} attribute.
     * @param systemTime The value for systemTime 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("SystemTime")
    public final Builder systemTime(Date systemTime) {
      this.systemTime = Objects.requireNonNull(systemTime, "systemTime");
      initBits &= ~INIT_BIT_SYSTEM_TIME;
      return this;
    }

    /**
     * Builds a new {@link ImmutableInfo ImmutableInfo}.
     * @return An immutable instance of Info
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableInfo build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableInfo(
          architecture,
          clusterStore,
          cgroupDriver,
          cgroupVersion,
          containers,
          containersRunning,
          containersStopped,
          containersPaused,
          cpuCfsPeriod,
          cpuCfsQuota,
          debug,
          dockerRootDir,
          storageDriver,
          createUnmodifiableList(true, driverStatus),
          experimentalBuild,
          httpProxy,
          httpsProxy,
          id,
          ipv4Forwarding,
          images,
          indexServerAddress,
          initPath,
          initSha1,
          kernelMemory,
          kernelVersion,
          createUnmodifiableList(true, labels),
          memTotal,
          memoryLimit,
          cpus,
          eventsListener,
          fileDescriptors,
          goroutines,
          name,
          noProxy,
          oomKillDisable,
          operatingSystem,
          osType,
          osVersion,
          plugins,
          registryConfig,
          serverVersion,
          swapLimit,
          swarm,
          systemStatus == null ? null : createUnmodifiableList(true, systemStatus),
          systemTime);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_CONTAINERS) != 0) attributes.add("containers");
      if ((initBits & INIT_BIT_DEBUG) != 0) attributes.add("debug");
      if ((initBits & INIT_BIT_DOCKER_ROOT_DIR) != 0) attributes.add("dockerRootDir");
      if ((initBits & INIT_BIT_STORAGE_DRIVER) != 0) attributes.add("storageDriver");
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_IPV4_FORWARDING) != 0) attributes.add("ipv4Forwarding");
      if ((initBits & INIT_BIT_IMAGES) != 0) attributes.add("images");
      if ((initBits & INIT_BIT_INDEX_SERVER_ADDRESS) != 0) attributes.add("indexServerAddress");
      if ((initBits & INIT_BIT_KERNEL_VERSION) != 0) attributes.add("kernelVersion");
      if ((initBits & INIT_BIT_MEM_TOTAL) != 0) attributes.add("memTotal");
      if ((initBits & INIT_BIT_MEMORY_LIMIT) != 0) attributes.add("memoryLimit");
      if ((initBits & INIT_BIT_CPUS) != 0) attributes.add("cpus");
      if ((initBits & INIT_BIT_EVENTS_LISTENER) != 0) attributes.add("eventsListener");
      if ((initBits & INIT_BIT_FILE_DESCRIPTORS) != 0) attributes.add("fileDescriptors");
      if ((initBits & INIT_BIT_GOROUTINES) != 0) attributes.add("goroutines");
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_OPERATING_SYSTEM) != 0) attributes.add("operatingSystem");
      if ((initBits & INIT_BIT_REGISTRY_CONFIG) != 0) attributes.add("registryConfig");
      if ((initBits & INIT_BIT_SWAP_LIMIT) != 0) attributes.add("swapLimit");
      if ((initBits & INIT_BIT_SYSTEM_TIME) != 0) attributes.add("systemTime");
      return "Cannot build Info, some of required attributes are not set " + attributes;
    }
  }

  /**
   * Immutable implementation of {@link Info.Plugins}.
   * <p>
   * Use the builder to create immutable instances:
   * {@code ImmutableInfo.Plugins.builder()}.
   */
  static final class Plugins implements Info.Plugins {
    private final List<String> volumes;
    private final List<String> networks;

    private Plugins(List<String> volumes, List<String> networks) {
      this.volumes = volumes;
      this.networks = networks;
    }

    /**
     * @return The value of the {@code volumes} attribute
     */
    @JsonProperty("Volume")
    @JsonSetter(nulls = Nulls.AS_EMPTY)
    @Override
    public List<String> volumes() {
      return volumes;
    }

    /**
     * @return The value of the {@code networks} attribute
     */
    @JsonProperty("Network")
    @JsonSetter(nulls = Nulls.AS_EMPTY)
    @Override
    public List<String> networks() {
      return networks;
    }

    /**
     * Copy the current immutable object with elements that replace the content of {@link Info.Plugins#volumes() volumes}.
     * @param elements The elements to set
     * @return A modified copy of {@code this} object
     */
    public final ImmutableInfo.Plugins withVolumes(String... elements) {
      List<String> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
      return new ImmutableInfo.Plugins(newValue, this.networks);
    }

    /**
     * Copy the current immutable object with elements that replace the content of {@link Info.Plugins#volumes() volumes}.
     * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param elements An iterable of volumes elements to set
     * @return A modified copy of {@code this} object
     */
    public final ImmutableInfo.Plugins withVolumes(Iterable<String> elements) {
      if (this.volumes == elements) return this;
      List<String> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
      return new ImmutableInfo.Plugins(newValue, this.networks);
    }

    /**
     * Copy the current immutable object with elements that replace the content of {@link Info.Plugins#networks() networks}.
     * @param elements The elements to set
     * @return A modified copy of {@code this} object
     */
    public final ImmutableInfo.Plugins withNetworks(String... elements) {
      List<String> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
      return new ImmutableInfo.Plugins(this.volumes, newValue);
    }

    /**
     * Copy the current immutable object with elements that replace the content of {@link Info.Plugins#networks() networks}.
     * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param elements An iterable of networks elements to set
     * @return A modified copy of {@code this} object
     */
    public final ImmutableInfo.Plugins withNetworks(Iterable<String> elements) {
      if (this.networks == elements) return this;
      List<String> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
      return new ImmutableInfo.Plugins(this.volumes, newValue);
    }

    /**
     * This instance is equal to all instances of {@code Plugins} that have equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(Object another) {
      if (this == another) return true;
      return another instanceof ImmutableInfo.Plugins
          && equalTo((ImmutableInfo.Plugins) another);
    }

    private boolean equalTo(ImmutableInfo.Plugins another) {
      return volumes.equals(another.volumes)
          && networks.equals(another.networks);
    }

    /**
     * Computes a hash code from attributes: {@code volumes}, {@code networks}.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      int h = 5381;
      h += (h << 5) + volumes.hashCode();
      h += (h << 5) + networks.hashCode();
      return h;
    }

    /**
     * Prints the immutable value {@code Plugins} with attribute values.
     * @return A string representation of the value
     */
    @Override
    public String toString() {
      return "Plugins{"
          + "volumes=" + volumes
          + ", networks=" + networks
          + "}";
    }

    /**
     * Creates an immutable copy of a {@link Info.Plugins} value.
     * Uses accessors to get values to initialize the new immutable instance.
     * If an instance is already immutable, it is returned as is.
     * @param instance The instance to copy
     * @return A copied immutable Plugins instance
     */
    public static ImmutableInfo.Plugins copyOf(Info.Plugins instance) {
      if (instance instanceof ImmutableInfo.Plugins) {
        return (ImmutableInfo.Plugins) instance;
      }
      return ImmutableInfo.Plugins.builder()
          .from(instance)
          .build();
    }

    /**
     * Creates a builder for {@link ImmutableInfo.Plugins Plugins}.
     * <pre>
     * ImmutableInfo.Plugins.builder()
     *    .volume|addAllVolumes(String) // {@link Info.Plugins#volumes() volumes} elements
     *    .network|addAllNetworks(String) // {@link Info.Plugins#networks() networks} elements
     *    .build();
     * </pre>
     * @return A new Plugins builder
     */
    public static ImmutableInfo.Plugins.Builder builder() {
      return new ImmutableInfo.Plugins.Builder();
    }

    /**
     * Builds instances of type {@link ImmutableInfo.Plugins Plugins}.
     * Initialize attributes and then invoke the {@link #build()} method to create an
     * immutable instance.
     * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
     * but instead used immediately to create instances.</em>
     */
    static final class Builder {
      private List<String> volumes = new ArrayList<String>();
      private List<String> networks = new ArrayList<String>();

      private Builder() {
      }

      /**
       * Fill a builder with attribute values from the provided {@code Plugins} instance.
       * Regular attribute values will be replaced with those from the given instance.
       * Absent optional values will not replace present values.
       * Collection elements and entries will be added, not replaced.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder from(Info.Plugins instance) {
        Objects.requireNonNull(instance, "instance");
        addAllVolumes(instance.volumes());
        addAllNetworks(instance.networks());
        return this;
      }

      /**
       * Adds one element to {@link Info.Plugins#volumes() volumes} list.
       * @param element A volumes element
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder volume(String element) {
        this.volumes.add(Objects.requireNonNull(element, "volumes element"));
        return this;
      }

      /**
       * Adds elements to {@link Info.Plugins#volumes() volumes} list.
       * @param elements An array of volumes elements
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder volumes(String... elements) {
        for (String element : elements) {
          this.volumes.add(Objects.requireNonNull(element, "volumes element"));
        }
        return this;
      }


      /**
       * Sets or replaces all elements for {@link Info.Plugins#volumes() volumes} list.
       * @param elements An iterable of volumes elements
       * @return {@code this} builder for use in a chained invocation
       */
      @JsonProperty("Volume")
      @JsonSetter(nulls = Nulls.AS_EMPTY)
      public final Builder volumes(Iterable<String> elements) {
        this.volumes.clear();
        return addAllVolumes(elements);
      }

      /**
       * Adds elements to {@link Info.Plugins#volumes() volumes} list.
       * @param elements An iterable of volumes elements
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder addAllVolumes(Iterable<String> elements) {
        for (String element : elements) {
          this.volumes.add(Objects.requireNonNull(element, "volumes element"));
        }
        return this;
      }

      /**
       * Adds one element to {@link Info.Plugins#networks() networks} list.
       * @param element A networks element
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder network(String element) {
        this.networks.add(Objects.requireNonNull(element, "networks element"));
        return this;
      }

      /**
       * Adds elements to {@link Info.Plugins#networks() networks} list.
       * @param elements An array of networks elements
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder networks(String... elements) {
        for (String element : elements) {
          this.networks.add(Objects.requireNonNull(element, "networks element"));
        }
        return this;
      }


      /**
       * Sets or replaces all elements for {@link Info.Plugins#networks() networks} list.
       * @param elements An iterable of networks elements
       * @return {@code this} builder for use in a chained invocation
       */
      @JsonProperty("Network")
      @JsonSetter(nulls = Nulls.AS_EMPTY)
      public final Builder networks(Iterable<String> elements) {
        this.networks.clear();
        return addAllNetworks(elements);
      }

      /**
       * Adds elements to {@link Info.Plugins#networks() networks} list.
       * @param elements An iterable of networks elements
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder addAllNetworks(Iterable<String> elements) {
        for (String element : elements) {
          this.networks.add(Objects.requireNonNull(element, "networks element"));
        }
        return this;
      }

      /**
       * Builds a new {@link ImmutableInfo.Plugins Plugins}.
       * @return An immutable instance of Plugins
       * @throws java.lang.IllegalStateException if any required attributes are missing
       */
      public ImmutableInfo.Plugins build() {
        return new ImmutableInfo.Plugins(createUnmodifiableList(true, volumes), createUnmodifiableList(true, networks));
      }
    }
  }

  /**
   * Immutable implementation of {@link Info.RegistryConfig}.
   * <p>
   * Use the builder to create immutable instances:
   * {@code ImmutableInfo.RegistryConfig.builder()}.
   */
  static final class RegistryConfig implements Info.RegistryConfig {
    private final Map<String, Info.IndexConfig> indexConfigs;
    private final List<String> insecureRegistryCidrs;

    private RegistryConfig(
        Map<String, Info.IndexConfig> indexConfigs,
        List<String> insecureRegistryCidrs) {
      this.indexConfigs = indexConfigs;
      this.insecureRegistryCidrs = insecureRegistryCidrs;
    }

    /**
     * @return The value of the {@code indexConfigs} attribute
     */
    @JsonProperty("IndexConfigs")
    @JsonSetter(nulls = Nulls.AS_EMPTY)
    @Override
    public Map<String, Info.IndexConfig> indexConfigs() {
      return indexConfigs;
    }

    /**
     * @return The value of the {@code insecureRegistryCidrs} attribute
     */
    @JsonProperty("InsecureRegistryCIDRs")
    @JsonSetter(nulls = Nulls.AS_EMPTY)
    @Override
    public List<String> insecureRegistryCidrs() {
      return insecureRegistryCidrs;
    }

    /**
     * Copy the current immutable object by replacing the {@link Info.RegistryConfig#indexConfigs() indexConfigs} map with the specified map.
     * Nulls are not permitted as keys or values.
     * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param entries The entries to be added to the indexConfigs map
     * @return A modified copy of {@code this} object
     */
    public final ImmutableInfo.RegistryConfig withIndexConfigs(Map<String, ? extends Info.IndexConfig> entries) {
      if (this.indexConfigs == entries) return this;
      Map<String, Info.IndexConfig> newValue = createUnmodifiableMap(true, false, entries);
      return new ImmutableInfo.RegistryConfig(newValue, this.insecureRegistryCidrs);
    }

    /**
     * Copy the current immutable object with elements that replace the content of {@link Info.RegistryConfig#insecureRegistryCidrs() insecureRegistryCidrs}.
     * @param elements The elements to set
     * @return A modified copy of {@code this} object
     */
    public final ImmutableInfo.RegistryConfig withInsecureRegistryCidrs(String... elements) {
      List<String> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
      return new ImmutableInfo.RegistryConfig(this.indexConfigs, newValue);
    }

    /**
     * Copy the current immutable object with elements that replace the content of {@link Info.RegistryConfig#insecureRegistryCidrs() insecureRegistryCidrs}.
     * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param elements An iterable of insecureRegistryCidrs elements to set
     * @return A modified copy of {@code this} object
     */
    public final ImmutableInfo.RegistryConfig withInsecureRegistryCidrs(Iterable<String> elements) {
      if (this.insecureRegistryCidrs == elements) return this;
      List<String> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
      return new ImmutableInfo.RegistryConfig(this.indexConfigs, newValue);
    }

    /**
     * This instance is equal to all instances of {@code RegistryConfig} that have equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(Object another) {
      if (this == another) return true;
      return another instanceof ImmutableInfo.RegistryConfig
          && equalTo((ImmutableInfo.RegistryConfig) another);
    }

    private boolean equalTo(ImmutableInfo.RegistryConfig another) {
      return indexConfigs.equals(another.indexConfigs)
          && insecureRegistryCidrs.equals(another.insecureRegistryCidrs);
    }

    /**
     * Computes a hash code from attributes: {@code indexConfigs}, {@code insecureRegistryCidrs}.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      int h = 5381;
      h += (h << 5) + indexConfigs.hashCode();
      h += (h << 5) + insecureRegistryCidrs.hashCode();
      return h;
    }

    /**
     * Prints the immutable value {@code RegistryConfig} with attribute values.
     * @return A string representation of the value
     */
    @Override
    public String toString() {
      return "RegistryConfig{"
          + "indexConfigs=" + indexConfigs
          + ", insecureRegistryCidrs=" + insecureRegistryCidrs
          + "}";
    }

    /**
     * Creates an immutable copy of a {@link Info.RegistryConfig} value.
     * Uses accessors to get values to initialize the new immutable instance.
     * If an instance is already immutable, it is returned as is.
     * @param instance The instance to copy
     * @return A copied immutable RegistryConfig instance
     */
    public static ImmutableInfo.RegistryConfig copyOf(Info.RegistryConfig instance) {
      if (instance instanceof ImmutableInfo.RegistryConfig) {
        return (ImmutableInfo.RegistryConfig) instance;
      }
      return ImmutableInfo.RegistryConfig.builder()
          .from(instance)
          .build();
    }

    /**
     * Creates a builder for {@link ImmutableInfo.RegistryConfig RegistryConfig}.
     * <pre>
     * ImmutableInfo.RegistryConfig.builder()
     *    .addIndexConfig|putAllIndexConfigs(String =&gt; org.mandas.docker.client.messages.Info.IndexConfig) // {@link Info.RegistryConfig#indexConfigs() indexConfigs} mappings
     *    .insecureRegistryCidr|addAllInsecureRegistryCidrs(String) // {@link Info.RegistryConfig#insecureRegistryCidrs() insecureRegistryCidrs} elements
     *    .build();
     * </pre>
     * @return A new RegistryConfig builder
     */
    public static ImmutableInfo.RegistryConfig.Builder builder() {
      return new ImmutableInfo.RegistryConfig.Builder();
    }

    /**
     * Builds instances of type {@link ImmutableInfo.RegistryConfig RegistryConfig}.
     * Initialize attributes and then invoke the {@link #build()} method to create an
     * immutable instance.
     * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
     * but instead used immediately to create instances.</em>
     */
    static final class Builder {
      private Map<String, Info.IndexConfig> indexConfigs = new LinkedHashMap<String, Info.IndexConfig>();
      private List<String> insecureRegistryCidrs = new ArrayList<String>();

      private Builder() {
      }

      /**
       * Fill a builder with attribute values from the provided {@code RegistryConfig} instance.
       * Regular attribute values will be replaced with those from the given instance.
       * Absent optional values will not replace present values.
       * Collection elements and entries will be added, not replaced.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder from(Info.RegistryConfig instance) {
        Objects.requireNonNull(instance, "instance");
        putAllIndexConfigs(instance.indexConfigs());
        addAllInsecureRegistryCidrs(instance.insecureRegistryCidrs());
        return this;
      }

      /**
       * Put one entry to the {@link Info.RegistryConfig#indexConfigs() indexConfigs} map.
       * @param key The key in the indexConfigs map
       * @param value The associated value in the indexConfigs map
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder addIndexConfig(String key, Info.IndexConfig value) {
        this.indexConfigs.put(
            Objects.requireNonNull(key, "indexConfigs key"),
            Objects.requireNonNull(value, "indexConfigs value"));
        return this;
      }

      /**
       * Put one entry to the {@link Info.RegistryConfig#indexConfigs() indexConfigs} map. Nulls are not permitted
       * @param entry The key and value entry
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder addIndexConfig(Map.Entry<String, ? extends Info.IndexConfig> entry) {
        String k = entry.getKey();
        Info.IndexConfig v = entry.getValue();
        this.indexConfigs.put(
            Objects.requireNonNull(k, "indexConfigs key"),
            Objects.requireNonNull(v, "indexConfigs value"));
        return this;
      }

      /**
       * Sets or replaces all mappings from the specified map as entries for the {@link Info.RegistryConfig#indexConfigs() indexConfigs} map. Nulls are not permitted
       * @param entries The entries that will be added to the indexConfigs map
       * @return {@code this} builder for use in a chained invocation
       */
      @JsonProperty("IndexConfigs")
      @JsonSetter(nulls = Nulls.AS_EMPTY)
      public final Builder indexConfigs(Map<String, ? extends Info.IndexConfig> entries) {
        this.indexConfigs.clear();
        return putAllIndexConfigs(entries);
      }

      /**
       * Put all mappings from the specified map as entries to {@link Info.RegistryConfig#indexConfigs() indexConfigs} map. Nulls are not permitted
       * @param entries The entries that will be added to the indexConfigs map
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder putAllIndexConfigs(Map<String, ? extends Info.IndexConfig> entries) {
        for (Map.Entry<String, ? extends Info.IndexConfig> e : entries.entrySet()) {
          String k = e.getKey();
          Info.IndexConfig v = e.getValue();
          this.indexConfigs.put(
              Objects.requireNonNull(k, "indexConfigs key"),
              Objects.requireNonNull(v, "indexConfigs value"));
        }
        return this;
      }

      /**
       * Adds one element to {@link Info.RegistryConfig#insecureRegistryCidrs() insecureRegistryCidrs} list.
       * @param element A insecureRegistryCidrs element
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder insecureRegistryCidr(String element) {
        this.insecureRegistryCidrs.add(Objects.requireNonNull(element, "insecureRegistryCidrs element"));
        return this;
      }

      /**
       * Adds elements to {@link Info.RegistryConfig#insecureRegistryCidrs() insecureRegistryCidrs} list.
       * @param elements An array of insecureRegistryCidrs elements
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder insecureRegistryCidrs(String... elements) {
        for (String element : elements) {
          this.insecureRegistryCidrs.add(Objects.requireNonNull(element, "insecureRegistryCidrs element"));
        }
        return this;
      }


      /**
       * Sets or replaces all elements for {@link Info.RegistryConfig#insecureRegistryCidrs() insecureRegistryCidrs} list.
       * @param elements An iterable of insecureRegistryCidrs elements
       * @return {@code this} builder for use in a chained invocation
       */
      @JsonProperty("InsecureRegistryCIDRs")
      @JsonSetter(nulls = Nulls.AS_EMPTY)
      public final Builder insecureRegistryCidrs(Iterable<String> elements) {
        this.insecureRegistryCidrs.clear();
        return addAllInsecureRegistryCidrs(elements);
      }

      /**
       * Adds elements to {@link Info.RegistryConfig#insecureRegistryCidrs() insecureRegistryCidrs} list.
       * @param elements An iterable of insecureRegistryCidrs elements
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder addAllInsecureRegistryCidrs(Iterable<String> elements) {
        for (String element : elements) {
          this.insecureRegistryCidrs.add(Objects.requireNonNull(element, "insecureRegistryCidrs element"));
        }
        return this;
      }

      /**
       * Builds a new {@link ImmutableInfo.RegistryConfig RegistryConfig}.
       * @return An immutable instance of RegistryConfig
       * @throws java.lang.IllegalStateException if any required attributes are missing
       */
      public ImmutableInfo.RegistryConfig build() {
        return new ImmutableInfo.RegistryConfig(
            createUnmodifiableMap(false, false, indexConfigs),
            createUnmodifiableList(true, insecureRegistryCidrs));
      }
    }
  }

  /**
   * Immutable implementation of {@link Info.IndexConfig}.
   * <p>
   * Use the builder to create immutable instances:
   * {@code ImmutableInfo.IndexConfig.builder()}.
   */
  static final class IndexConfig implements Info.IndexConfig {
    private final String name;
    private final List<String> mirrors;
    private final Boolean secure;
    private final Boolean official;

    private IndexConfig(
        String name,
        List<String> mirrors,
        Boolean secure,
        Boolean official) {
      this.name = name;
      this.mirrors = mirrors;
      this.secure = secure;
      this.official = official;
    }

    /**
     * @return The value of the {@code name} attribute
     */
    @JsonProperty("Name")
    @Override
    public String name() {
      return name;
    }

    /**
     * @return The value of the {@code mirrors} attribute
     */
    @JsonProperty("Mirrors")
    @JsonSetter(nulls = Nulls.AS_EMPTY)
    @Override
    public List<String> mirrors() {
      return mirrors;
    }

    /**
     * @return The value of the {@code secure} attribute
     */
    @JsonProperty("Secure")
    @Override
    public Boolean secure() {
      return secure;
    }

    /**
     * @return The value of the {@code official} attribute
     */
    @JsonProperty("Official")
    @Override
    public Boolean official() {
      return official;
    }

    /**
     * Copy the current immutable object by setting a value for the {@link Info.IndexConfig#name() name} attribute.
     * An equals check used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for name
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableInfo.IndexConfig withName(String value) {
      String newValue = Objects.requireNonNull(value, "name");
      if (this.name.equals(newValue)) return this;
      return new ImmutableInfo.IndexConfig(newValue, this.mirrors, this.secure, this.official);
    }

    /**
     * Copy the current immutable object with elements that replace the content of {@link Info.IndexConfig#mirrors() mirrors}.
     * @param elements The elements to set
     * @return A modified copy of {@code this} object
     */
    public final ImmutableInfo.IndexConfig withMirrors(String... elements) {
      List<String> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
      return new ImmutableInfo.IndexConfig(this.name, newValue, this.secure, this.official);
    }

    /**
     * Copy the current immutable object with elements that replace the content of {@link Info.IndexConfig#mirrors() mirrors}.
     * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param elements An iterable of mirrors elements to set
     * @return A modified copy of {@code this} object
     */
    public final ImmutableInfo.IndexConfig withMirrors(Iterable<String> elements) {
      if (this.mirrors == elements) return this;
      List<String> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
      return new ImmutableInfo.IndexConfig(this.name, newValue, this.secure, this.official);
    }

    /**
     * Copy the current immutable object by setting a value for the {@link Info.IndexConfig#secure() secure} attribute.
     * An equals check used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for secure
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableInfo.IndexConfig withSecure(Boolean value) {
      Boolean newValue = Objects.requireNonNull(value, "secure");
      if (this.secure.equals(newValue)) return this;
      return new ImmutableInfo.IndexConfig(this.name, this.mirrors, newValue, this.official);
    }

    /**
     * Copy the current immutable object by setting a value for the {@link Info.IndexConfig#official() official} attribute.
     * An equals check used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for official
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableInfo.IndexConfig withOfficial(Boolean value) {
      Boolean newValue = Objects.requireNonNull(value, "official");
      if (this.official.equals(newValue)) return this;
      return new ImmutableInfo.IndexConfig(this.name, this.mirrors, this.secure, newValue);
    }

    /**
     * This instance is equal to all instances of {@code IndexConfig} that have equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(Object another) {
      if (this == another) return true;
      return another instanceof ImmutableInfo.IndexConfig
          && equalTo((ImmutableInfo.IndexConfig) another);
    }

    private boolean equalTo(ImmutableInfo.IndexConfig another) {
      return name.equals(another.name)
          && mirrors.equals(another.mirrors)
          && secure.equals(another.secure)
          && official.equals(another.official);
    }

    /**
     * Computes a hash code from attributes: {@code name}, {@code mirrors}, {@code secure}, {@code official}.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      int h = 5381;
      h += (h << 5) + name.hashCode();
      h += (h << 5) + mirrors.hashCode();
      h += (h << 5) + secure.hashCode();
      h += (h << 5) + official.hashCode();
      return h;
    }

    /**
     * Prints the immutable value {@code IndexConfig} with attribute values.
     * @return A string representation of the value
     */
    @Override
    public String toString() {
      return "IndexConfig{"
          + "name=" + name
          + ", mirrors=" + mirrors
          + ", secure=" + secure
          + ", official=" + official
          + "}";
    }

    /**
     * Creates an immutable copy of a {@link Info.IndexConfig} value.
     * Uses accessors to get values to initialize the new immutable instance.
     * If an instance is already immutable, it is returned as is.
     * @param instance The instance to copy
     * @return A copied immutable IndexConfig instance
     */
    public static ImmutableInfo.IndexConfig copyOf(Info.IndexConfig instance) {
      if (instance instanceof ImmutableInfo.IndexConfig) {
        return (ImmutableInfo.IndexConfig) instance;
      }
      return ImmutableInfo.IndexConfig.builder()
          .from(instance)
          .build();
    }

    /**
     * Creates a builder for {@link ImmutableInfo.IndexConfig IndexConfig}.
     * <pre>
     * ImmutableInfo.IndexConfig.builder()
     *    .name(String) // required {@link Info.IndexConfig#name() name}
     *    .mirror|addAllMirrors(String) // {@link Info.IndexConfig#mirrors() mirrors} elements
     *    .secure(Boolean) // required {@link Info.IndexConfig#secure() secure}
     *    .official(Boolean) // required {@link Info.IndexConfig#official() official}
     *    .build();
     * </pre>
     * @return A new IndexConfig builder
     */
    public static ImmutableInfo.IndexConfig.Builder builder() {
      return new ImmutableInfo.IndexConfig.Builder();
    }

    /**
     * Builds instances of type {@link ImmutableInfo.IndexConfig IndexConfig}.
     * Initialize attributes and then invoke the {@link #build()} method to create an
     * immutable instance.
     * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
     * but instead used immediately to create instances.</em>
     */
    static final class Builder {
      private static final long INIT_BIT_NAME = 0x1L;
      private static final long INIT_BIT_SECURE = 0x2L;
      private static final long INIT_BIT_OFFICIAL = 0x4L;
      private long initBits = 0x7L;

      private String name;
      private List<String> mirrors = new ArrayList<String>();
      private Boolean secure;
      private Boolean official;

      private Builder() {
      }

      /**
       * Fill a builder with attribute values from the provided {@code IndexConfig} instance.
       * Regular attribute values will be replaced with those from the given instance.
       * Absent optional values will not replace present values.
       * Collection elements and entries will be added, not replaced.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder from(Info.IndexConfig instance) {
        Objects.requireNonNull(instance, "instance");
        name(instance.name());
        addAllMirrors(instance.mirrors());
        secure(instance.secure());
        official(instance.official());
        return this;
      }

      /**
       * Initializes the value for the {@link Info.IndexConfig#name() name} attribute.
       * @param name The value for name 
       * @return {@code this} builder for use in a chained invocation
       */
      @JsonProperty("Name")
      public final Builder name(String name) {
        this.name = Objects.requireNonNull(name, "name");
        initBits &= ~INIT_BIT_NAME;
        return this;
      }

      /**
       * Adds one element to {@link Info.IndexConfig#mirrors() mirrors} list.
       * @param element A mirrors element
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder mirror(String element) {
        this.mirrors.add(Objects.requireNonNull(element, "mirrors element"));
        return this;
      }

      /**
       * Adds elements to {@link Info.IndexConfig#mirrors() mirrors} list.
       * @param elements An array of mirrors elements
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder mirrors(String... elements) {
        for (String element : elements) {
          this.mirrors.add(Objects.requireNonNull(element, "mirrors element"));
        }
        return this;
      }


      /**
       * Sets or replaces all elements for {@link Info.IndexConfig#mirrors() mirrors} list.
       * @param elements An iterable of mirrors elements
       * @return {@code this} builder for use in a chained invocation
       */
      @JsonProperty("Mirrors")
      @JsonSetter(nulls = Nulls.AS_EMPTY)
      public final Builder mirrors(Iterable<String> elements) {
        this.mirrors.clear();
        return addAllMirrors(elements);
      }

      /**
       * Adds elements to {@link Info.IndexConfig#mirrors() mirrors} list.
       * @param elements An iterable of mirrors elements
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder addAllMirrors(Iterable<String> elements) {
        for (String element : elements) {
          this.mirrors.add(Objects.requireNonNull(element, "mirrors element"));
        }
        return this;
      }

      /**
       * Initializes the value for the {@link Info.IndexConfig#secure() secure} attribute.
       * @param secure The value for secure 
       * @return {@code this} builder for use in a chained invocation
       */
      @JsonProperty("Secure")
      public final Builder secure(Boolean secure) {
        this.secure = Objects.requireNonNull(secure, "secure");
        initBits &= ~INIT_BIT_SECURE;
        return this;
      }

      /**
       * Initializes the value for the {@link Info.IndexConfig#official() official} attribute.
       * @param official The value for official 
       * @return {@code this} builder for use in a chained invocation
       */
      @JsonProperty("Official")
      public final Builder official(Boolean official) {
        this.official = Objects.requireNonNull(official, "official");
        initBits &= ~INIT_BIT_OFFICIAL;
        return this;
      }

      /**
       * Builds a new {@link ImmutableInfo.IndexConfig IndexConfig}.
       * @return An immutable instance of IndexConfig
       * @throws java.lang.IllegalStateException if any required attributes are missing
       */
      public ImmutableInfo.IndexConfig build() {
        if (initBits != 0) {
          throw new IllegalStateException(formatRequiredAttributesMessage());
        }
        return new ImmutableInfo.IndexConfig(name, createUnmodifiableList(true, mirrors), secure, official);
      }

      private String formatRequiredAttributesMessage() {
        List<String> attributes = new ArrayList<>();
        if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
        if ((initBits & INIT_BIT_SECURE) != 0) attributes.add("secure");
        if ((initBits & INIT_BIT_OFFICIAL) != 0) attributes.add("official");
        return "Cannot build IndexConfig, some of required attributes are not set " + attributes;
      }
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, "value");
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, "value");
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
