/*
 * Decompiled with CFR 0.152.
 */
package org.magicwerk.brownies.collections.primitive;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import org.magicwerk.brownies.collections.GapList;
import org.magicwerk.brownies.collections.IList;
import org.magicwerk.brownies.collections.primitive.DoubleObjBigList;
import org.magicwerk.brownies.collections.primitive.DoubleObjGapList;

public abstract class IDoubleList
implements Cloneable,
Serializable {
    private static final int TRANSFER_COPY = 0;
    private static final int TRANSFER_MOVE = 1;
    private static final int TRANSFER_REMOVE = 2;

    static double[] toArray(Collection<Double> coll) {
        Object[] values = coll.toArray();
        double[] v = new double[values.length];
        for (int i = 0; i < values.length; ++i) {
            v[i] = (Double)values[i];
        }
        return v;
    }

    public IDoubleList copy() {
        return (IDoubleList)this.clone();
    }

    public abstract IDoubleList unmodifiableList();

    public Object clone() {
        try {
            IDoubleList list = (IDoubleList)super.clone();
            list.doClone(this);
            return list;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    protected abstract void doClone(IDoubleList var1);

    public void clear() {
        this.doClear();
    }

    protected void doClear() {
        this.doRemoveAll(0, this.size());
    }

    public void resize(int len, double elem) {
        this.checkLength(len);
        int size = this.size();
        if (len < size) {
            this.remove(len, size - len);
        } else {
            for (int i = size; i < len; ++i) {
                this.add(elem);
            }
        }
        assert (this.size() == len);
    }

    public abstract int size();

    public abstract int capacity();

    public double get(int index) {
        this.checkIndex(index);
        return this.doGet(index);
    }

    protected abstract double doGet(int var1);

    protected abstract double doSet(int var1, double var2);

    public double set(int index, double elem) {
        this.checkIndex(index);
        return this.doSet(index, elem);
    }

    public double put(int index, double elem) {
        this.checkIndexAdd(index);
        if (index < this.size()) {
            return this.doSet(index, elem);
        }
        this.doAdd(-1, elem);
        return 0.0;
    }

    protected abstract double doReSet(int var1, double var2);

    protected abstract double getDefaultElem();

    protected void doModify() {
    }

    public boolean add(double elem) {
        return this.doAdd(-1, elem);
    }

    public void add(int index, double elem) {
        this.checkIndexAdd(index);
        this.doAdd(index, elem);
    }

    protected abstract boolean doAdd(int var1, double var2);

    public double remove(int index) {
        this.checkIndex(index);
        return this.doRemove(index);
    }

    protected abstract double doRemove(int var1);

    public void ensureCapacity(int minCapacity) {
        this.doModify();
        this.doEnsureCapacity(minCapacity);
    }

    protected abstract void doEnsureCapacity(int var1);

    public abstract void trimToSize();

    public boolean equals(Object obj) {
        if (obj == null) {
            return true;
        }
        if (obj instanceof DoubleObjGapList) {
            obj = ((DoubleObjGapList)obj).list;
        } else if (obj instanceof DoubleObjBigList) {
            obj = ((DoubleObjBigList)obj).list;
        }
        if (!(obj instanceof IDoubleList)) {
            return false;
        }
        IDoubleList list = (IDoubleList)obj;
        int size = this.size();
        if (size != list.size()) {
            return false;
        }
        for (int i = 0; i < size; ++i) {
            if (IDoubleList.equalsElem(this.doGet(i), list.get(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 1;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            double elem = this.doGet(i);
            hashCode = 31 * hashCode + IDoubleList.hashCodeElem(elem);
        }
        return hashCode;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[");
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(this.doGet(i));
        }
        buf.append("]");
        return buf.toString();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    static boolean equalsElem(double elem1, double elem2) {
        return Double.doubleToLongBits(elem1) == Double.doubleToLongBits(elem2);
    }

    static int hashCodeElem(double elem) {
        return (int)elem;
    }

    public int getCount(double elem) {
        int count = 0;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            if (!IDoubleList.equalsElem(this.doGet(i), elem)) continue;
            ++count;
        }
        return count;
    }

    public double getSingle() {
        if (this.size() != 1) {
            throw new NoSuchElementException();
        }
        return this.doGet(0);
    }

    public double getSingleOrEmpty() {
        int size = this.size();
        if (size == 0) {
            return 0.0;
        }
        if (size == 1) {
            return this.doGet(0);
        }
        throw new NoSuchElementException();
    }

    public IDoubleList getAll(double elem) {
        IDoubleList list = this.doCreate(-1);
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            double e = this.doGet(i);
            if (!IDoubleList.equalsElem(e, elem)) continue;
            list.add(e);
        }
        return list;
    }

    public IDoubleList getIf(Predicate predicate) {
        IDoubleList list = this.doCreate(-1);
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            double e = this.doGet(i);
            if (!predicate.test(e)) continue;
            list.add(e);
        }
        return list;
    }

    public boolean removeIf(Predicate<Double> predicate) {
        boolean removed = false;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            double e = this.doGet(i);
            if (!predicate.test(e)) continue;
            this.doRemove(i);
            --size;
            --i;
            removed = true;
        }
        return removed;
    }

    public boolean retainIf(Predicate<Double> predicate) {
        boolean modified = false;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            double e = this.doGet(i);
            if (predicate.test(e)) continue;
            this.doRemove(i);
            --size;
            --i;
            modified = true;
        }
        return modified;
    }

    public IDoubleList extractIf(Predicate<Double> predicate) {
        IDoubleList list = this.doCreate(-1);
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            double e = this.doGet(i);
            if (!predicate.test(e)) continue;
            list.add(e);
            this.doRemove(i);
            --size;
            --i;
        }
        return list;
    }

    public Set getDistinct() {
        HashSet<Double> set = new HashSet<Double>();
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            set.add(this.doGet(i));
        }
        return set;
    }

    public <R> IList<R> mappedList(Function<Double, R> func) {
        int size = this.size();
        GapList<R> list = new GapList<R>(size);
        for (int i = 0; i < size; ++i) {
            double e = this.doGet(i);
            ((IList)list).add(func.apply(e));
        }
        return list;
    }

    public IDoubleList transformedList(UnaryOperator<Double> op) {
        int size = this.size();
        IDoubleList list = this.doCreate(size);
        for (int i = 0; i < size; ++i) {
            double e = this.doGet(i);
            list.add((Double)op.apply(e));
        }
        return list;
    }

    public void transform(UnaryOperator<Double> op) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            double e = this.doGet(i);
            e = (Double)op.apply(e);
            this.doSet(i, e);
        }
    }

    public IDoubleList filteredList(Predicate<Double> predicate) {
        IDoubleList list = this.doCreate(-1);
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            double e = this.doGet(i);
            if (!predicate.test(e)) continue;
            list.add(e);
        }
        return list;
    }

    public void filter(Predicate<Double> predicate) {
        IDoubleList list = this.filteredList(predicate);
        this.doAssign(list);
    }

    public int indexOf(double elem) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            if (!IDoubleList.equalsElem(this.doGet(i), elem)) continue;
            return i;
        }
        return -1;
    }

    public int indexOfIf(Predicate<Double> predicate) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            if (!predicate.test(this.doGet(i))) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(double elem) {
        for (int i = this.size() - 1; i >= 0; --i) {
            if (!IDoubleList.equalsElem(this.doGet(i), elem)) continue;
            return i;
        }
        return -1;
    }

    public int indexOf(double elem, int fromIndex) {
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        int size = this.size();
        for (int i = fromIndex; i < size; ++i) {
            if (!IDoubleList.equalsElem(this.doGet(i), elem)) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(double elem, int fromIndex) {
        int size = this.size();
        if (fromIndex >= size) {
            fromIndex = size - 1;
        }
        for (int i = fromIndex; i >= 0; --i) {
            if (!IDoubleList.equalsElem(this.doGet(i), elem)) continue;
            return i;
        }
        return -1;
    }

    public boolean removeElem(double elem) {
        int index = this.indexOf(elem);
        if (index == -1) {
            return false;
        }
        this.doRemove(index);
        return true;
    }

    public boolean contains(double elem) {
        return this.indexOf(elem) != -1;
    }

    public boolean containsIf(Predicate<Double> predicate) {
        return this.indexOfIf(predicate) != -1;
    }

    public boolean addIfAbsent(double elem) {
        if (this.contains(elem)) {
            return false;
        }
        return this.add(elem);
    }

    public boolean containsAny(Collection<Double> coll) {
        for (double elem : coll) {
            if (!this.contains(elem)) continue;
            return true;
        }
        return false;
    }

    public boolean containsAll(Collection<Double> coll) {
        for (double elem : coll) {
            if (this.contains(elem)) continue;
            return false;
        }
        return true;
    }

    public IDoubleList removeAll(double elem) {
        IDoubleList list = this.doCreate(-1);
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            double e = this.doGet(i);
            if (!IDoubleList.equalsElem(elem, e)) continue;
            list.add(e);
            this.doRemove(i);
            --size;
            --i;
        }
        return list;
    }

    public boolean removeAll(Collection<Double> coll) {
        this.checkNonNull(coll);
        boolean modified = false;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            if (!coll.contains(this.doGet(i))) continue;
            this.doRemove(i);
            --size;
            --i;
            modified = true;
        }
        return modified;
    }

    public boolean removeAll(IDoubleList coll) {
        this.checkNonNull(coll);
        boolean modified = false;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            if (!coll.contains(this.doGet(i))) continue;
            this.doRemove(i);
            --size;
            --i;
            modified = true;
        }
        return modified;
    }

    public boolean retainAll(Collection<Double> coll) {
        this.checkNonNull(coll);
        boolean modified = false;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            if (coll.contains(this.doGet(i))) continue;
            this.doRemove(i);
            --size;
            --i;
            modified = true;
        }
        return modified;
    }

    public boolean retainAll(IDoubleList coll) {
        this.checkNonNull(coll);
        boolean modified = false;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            if (coll.contains(this.doGet(i))) continue;
            this.doRemove(i);
            --size;
            --i;
            modified = true;
        }
        return modified;
    }

    public double[] toArray() {
        return this.toArray(0, this.size());
    }

    public double[] toArray(double[] array) {
        return this.toArray(array, 0, this.size());
    }

    public double[] toArray(Class clazz) {
        return this.toArray(clazz, 0, this.size());
    }

    public double[] toArray(int index, int len) {
        double[] array = new double[len];
        this.doGetAll(array, index, len);
        return array;
    }

    public double[] toArray(double[] array, int index, int len) {
        if (array.length < len) {
            array = this.doCreateArray(array.getClass().getComponentType(), len);
        }
        this.doGetAll(array, index, len);
        if (array.length > len) {
            array[len] = 0.0;
        }
        return array;
    }

    public double[] toArray(Class clazz, int index, int len) {
        double[] array = this.doCreateArray(clazz, len);
        this.doGetAll(array, index, len);
        return array;
    }

    protected double[] doCreateArray(Class clazz, int len) {
        return (double[])Array.newInstance(clazz, len);
    }

    protected void doGetAll(double[] array, int index, int len) {
        for (int i = 0; i < len; ++i) {
            array[i] = this.doGet(index + i);
        }
    }

    protected boolean doAddAll(int index, IDoubleList list) {
        int listSize = list.size();
        this.doEnsureCapacity(this.size() + listSize);
        if (listSize == 0) {
            return false;
        }
        boolean changed = false;
        int prevSize = this.size();
        for (int i = 0; i < listSize; ++i) {
            double elem = list.get(i);
            if (!this.doAdd(index, elem)) continue;
            changed = true;
            if (index == -1 || prevSize == this.size()) continue;
            prevSize = this.size();
            ++index;
        }
        return changed;
    }

    public double peek() {
        if (this.size() == 0) {
            return 0.0;
        }
        return this.getFirst();
    }

    public double element() {
        if (this.size() == 0) {
            throw new NoSuchElementException();
        }
        return this.doGet(0);
    }

    public double poll() {
        if (this.size() == 0) {
            return 0.0;
        }
        return this.doRemove(0);
    }

    public double remove() {
        if (this.size() == 0) {
            throw new NoSuchElementException();
        }
        return this.doRemove(0);
    }

    public boolean offer(double elem) {
        return this.doAdd(-1, elem);
    }

    public double getFirst() {
        if (this.size() == 0) {
            throw new NoSuchElementException();
        }
        return this.doGet(0);
    }

    public double getLast() {
        int size = this.size();
        if (size == 0) {
            throw new NoSuchElementException();
        }
        return this.doGet(size - 1);
    }

    public void addFirst(double elem) {
        this.doAdd(0, elem);
    }

    public void addLast(double elem) {
        this.doAdd(-1, elem);
    }

    public double removeFirst() {
        if (this.size() == 0) {
            throw new NoSuchElementException();
        }
        return this.doRemove(0);
    }

    public double removeLast() {
        int size = this.size();
        if (size == 0) {
            throw new NoSuchElementException();
        }
        return this.doRemove(size - 1);
    }

    public boolean offerFirst(double elem) {
        this.doAdd(0, elem);
        return true;
    }

    public boolean offerLast(double elem) {
        this.doAdd(-1, elem);
        return true;
    }

    public double peekFirst() {
        if (this.size() == 0) {
            return 0.0;
        }
        return this.doGet(0);
    }

    public double peekLast() {
        int size = this.size();
        if (size == 0) {
            return 0.0;
        }
        return this.doGet(size - 1);
    }

    public double pollFirst() {
        if (this.size() == 0) {
            return 0.0;
        }
        return this.doRemove(0);
    }

    public double pollLast() {
        int size = this.size();
        if (size == 0) {
            return 0.0;
        }
        return this.doRemove(size - 1);
    }

    public double pop() {
        if (this.size() == 0) {
            throw new NoSuchElementException();
        }
        return this.doRemove(0);
    }

    public void push(double elem) {
        this.doAdd(0, elem);
    }

    public boolean removeFirstOccurrence(double elem) {
        int index = this.indexOf(elem);
        if (index == -1) {
            return false;
        }
        this.doRemove(index);
        return true;
    }

    public boolean removeLastOccurrence(double elem) {
        int index = this.lastIndexOf(elem);
        if (index == -1) {
            return false;
        }
        this.doRemove(index);
        return true;
    }

    public static void transferCopy(IDoubleList src, int srcIndex, int srcLen, IDoubleList dst, int dstIndex, int dstLen) {
        if (src == dst) {
            src.checkLengths(srcLen, dstLen);
            src.copy(srcIndex, dstIndex, srcLen);
        } else {
            src.doTransfer(0, srcIndex, srcLen, dst, dstIndex, dstLen);
        }
    }

    public static void transferMove(IDoubleList src, int srcIndex, int srcLen, IDoubleList dst, int dstIndex, int dstLen) {
        if (src == dst) {
            src.checkLengths(srcLen, dstLen);
            src.move(srcIndex, dstIndex, srcLen);
        } else {
            src.doTransfer(1, srcIndex, srcLen, dst, dstIndex, dstLen);
        }
    }

    public static void transferRemove(IDoubleList src, int srcIndex, int srcLen, IDoubleList dst, int dstIndex, int dstLen) {
        if (src == dst) {
            src.checkLengths(srcLen, dstLen);
            src.drag(srcIndex, dstIndex, srcLen);
        } else {
            src.doTransfer(2, srcIndex, srcLen, dst, dstIndex, dstLen);
        }
    }

    void doTransfer(int transferMode, int srcIndex, int srcLen, IDoubleList dst, int dstIndex, int dstLen) {
        if (srcLen == -1) {
            srcLen = this.size() - srcIndex;
        }
        this.checkRange(srcIndex, srcLen);
        if (dstIndex == -1) {
            dstIndex = dst.size();
        } else {
            dst.checkIndexAdd(dstIndex);
        }
        if (dstLen == -1) {
            dstLen = dst.size() - dstIndex;
        } else {
            dst.checkLength(dstLen);
        }
        double defaultElem = this.getDefaultElem();
        if (dstLen > srcLen) {
            dst.remove(dstIndex, dstLen - srcLen);
        } else if (srcLen > dstLen) {
            dst.addMult(dstIndex, srcLen - dstLen, defaultElem);
        }
        if (transferMode == 1) {
            for (int i = 0; i < srcLen; ++i) {
                double elem = this.doReSet(srcIndex + i, defaultElem);
                dst.doSet(dstIndex + i, elem);
            }
        } else {
            for (int i = 0; i < srcLen; ++i) {
                double elem = this.doGet(srcIndex + i);
                dst.doSet(dstIndex + i, elem);
            }
            if (transferMode == 2) {
                this.remove(srcIndex, srcLen);
            }
        }
    }

    public static void transferSwap(IDoubleList src, int srcIndex, IDoubleList dst, int dstIndex, int len) {
        if (src == dst) {
            src.swap(srcIndex, dstIndex, len);
        } else {
            src.doTransferSwap(srcIndex, dst, dstIndex, len);
        }
    }

    void doTransferSwap(int srcIndex, IDoubleList dst, int dstIndex, int len) {
        this.checkRange(srcIndex, len);
        dst.checkRange(dstIndex, len);
        for (int i = 0; i < len; ++i) {
            double swap = this.doGet(srcIndex + i);
            swap = dst.doSet(dstIndex + i, swap);
            this.doSet(srcIndex + i, swap);
        }
    }

    protected abstract IDoubleList doCreate(int var1);

    protected abstract void doAssign(IDoubleList var1);

    public IDoubleList getAll(int index, int len) {
        this.checkRange(index, len);
        IDoubleList list = this.doCreate(len);
        for (int i = 0; i < len; ++i) {
            list.add(this.doGet(index + i));
        }
        return list;
    }

    public IDoubleList extract(int index, int len) {
        this.checkRange(index, len);
        IDoubleList list = this.doCreate(len);
        for (int i = 0; i < len; ++i) {
            list.add(this.doGet(index + i));
        }
        this.remove(index, len);
        return list;
    }

    public void remove(int index, int len) {
        this.checkRange(index, len);
        this.doRemoveAll(index, len);
    }

    protected void doRemoveAll(int index, int len) {
        for (int i = index + len - 1; i >= index; --i) {
            this.doRemove(i);
        }
    }

    public boolean addAll(IDoubleList list) {
        return this.doAddAll(-1, list);
    }

    public boolean addAll(int index, IDoubleList list) {
        this.checkIndexAdd(index);
        return this.doAddAll(index, list);
    }

    public boolean addAll(Collection<Double> coll) {
        if (coll instanceof List) {
            return this.doAddAll(-1, new IReadOnlyDoubleListFromList((List)coll));
        }
        return this.doAddAll(-1, new IReadOnlyDoubleListFromCollection(coll));
    }

    public boolean addAll(int index, Collection<Double> coll) {
        this.checkIndexAdd(index);
        if (coll instanceof List) {
            return this.doAddAll(index, new IReadOnlyDoubleListFromList((List)coll));
        }
        return this.doAddAll(index, new IReadOnlyDoubleListFromCollection(coll));
    }

    public boolean addArray(double ... elems) {
        return this.doAddAll(-1, new IReadOnlyDoubleListFromArray(elems));
    }

    public boolean addArray(double[] elems, int offset, int length) {
        return this.doAddAll(-1, new IReadOnlyDoubleListFromArray(elems, offset, length));
    }

    public boolean addArray(int index, double[] elems, int offset, int length) {
        return this.doAddAll(index, new IReadOnlyDoubleListFromArray(elems, offset, length));
    }

    public boolean addArray(int index, double ... elems) {
        this.checkIndexAdd(index);
        return this.doAddAll(index, new IReadOnlyDoubleListFromArray(elems));
    }

    public boolean addMult(int len, double elem) {
        return this.doAddAll(-1, new IReadOnlyDoubleListFromMult(len, elem));
    }

    public boolean addMult(int index, int len, double elem) {
        this.checkIndexAdd(index);
        return this.doAddAll(index, new IReadOnlyDoubleListFromMult(len, elem));
    }

    public void setAll(int index, IDoubleList list) {
        int listSize = list.size();
        this.checkRange(index, listSize);
        this.doReplaceAll(index, listSize, list);
    }

    public void setAll(int index, Collection<Double> coll) {
        int collSize = coll.size();
        this.checkRange(index, collSize);
        if (coll instanceof List) {
            this.doReplaceAll(index, collSize, new IReadOnlyDoubleListFromList((List)coll));
        } else {
            this.doReplaceAll(index, collSize, new IReadOnlyDoubleListFromCollection(coll));
        }
    }

    public void setArray(int index, double ... elems) {
        int arrayLen = elems.length;
        this.checkRange(index, arrayLen);
        this.doReplaceAll(index, arrayLen, new IReadOnlyDoubleListFromArray(elems));
    }

    public void setArray(int index, double[] elems, int offset, int length) {
        int arrayLen = elems.length;
        this.checkRange(index, arrayLen);
        this.doReplaceAll(index, arrayLen, new IReadOnlyDoubleListFromArray(elems, offset, length));
    }

    public void setMult(int index, int len, double elem) {
        this.checkRange(index, len);
        this.doReplaceAll(index, len, new IReadOnlyDoubleListFromMult(len, elem));
    }

    public void putAll(int index, IDoubleList list) {
        this.checkIndexAdd(index);
        this.checkNonNull(list);
        int len = this.size() - index;
        if (list != null && list.size() < len) {
            len = list.size();
        }
        this.doReplaceAll(index, len, list);
    }

    public void putAll(int index, Collection<Double> coll) {
        if (coll instanceof IDoubleList) {
            this.putAll(index, (IDoubleList)((Object)coll));
        } else if (coll instanceof List) {
            this.putAll(index, new IReadOnlyDoubleListFromList((List)coll));
        } else {
            this.putAll(index, new IReadOnlyDoubleListFromCollection(coll));
        }
    }

    public void putArray(int index, double ... elems) {
        this.putAll(index, new IReadOnlyDoubleListFromArray(elems));
    }

    public void putMult(int index, int len, double elem) {
        this.putAll(index, new IReadOnlyDoubleListFromMult(len, elem));
    }

    public void initAll(IDoubleList list) {
        this.checkNonNull(list);
        this.doReplaceAll(0, this.size(), list);
    }

    public void initAll(Collection<Double> coll) {
        if (coll instanceof IDoubleList) {
            this.initAll((IDoubleList)((Object)coll));
        } else if (coll instanceof List) {
            this.initAll(new IReadOnlyDoubleListFromList((List)coll));
        } else {
            this.initAll(new IReadOnlyDoubleListFromCollection(coll));
        }
    }

    public void initArray(double ... elems) {
        this.initAll(new IReadOnlyDoubleListFromArray(elems));
    }

    public void initMult(int len, double elem) {
        this.checkLength(len);
        this.initAll(new IReadOnlyDoubleListFromMult(len, elem));
    }

    public void replaceAll(int index, int len, Collection<Double> coll) {
        if (coll instanceof IDoubleList) {
            this.replaceAll(index, len, (IDoubleList)((Object)coll));
        } else if (coll instanceof List) {
            this.replaceAll(index, len, new IReadOnlyDoubleListFromList((List)coll));
        } else {
            this.replaceAll(index, len, new IReadOnlyDoubleListFromCollection(coll));
        }
    }

    public void replaceArray(int index, int len, double ... elems) {
        this.replaceAll(index, len, new IReadOnlyDoubleListFromArray(elems));
    }

    public void replaceMult(int index, int len, int numElems, double elem) {
        this.replaceAll(index, len, new IReadOnlyDoubleListFromMult(numElems, elem));
    }

    public void replaceAll(int index, int len, IDoubleList list) {
        if (index == -1) {
            index = this.size();
        } else {
            this.checkIndexAdd(index);
        }
        if (len == -1) {
            len = this.size() - index;
            if (list != null && list.size() < len) {
                len = list.size();
            }
        } else {
            this.checkRange(index, len);
        }
        this.doReplaceAll(index, len, list);
    }

    protected boolean doReplaceAll(int index, int len, IDoubleList list) {
        assert (index >= 0 && index <= this.size());
        assert (len >= 0 && index + len <= this.size());
        int srcLen = 0;
        if (list != null) {
            srcLen = list.size();
        }
        this.doEnsureCapacity(this.size() - len + srcLen);
        this.doRemoveAll(index, len);
        for (int i = 0; i < srcLen; ++i) {
            if (this.doAdd(index + i, list.doGet(i))) continue;
            --index;
        }
        return len > 0 || srcLen > 0;
    }

    public void fill(double elem) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            this.doSet(i, elem);
        }
    }

    public void copy(int srcIndex, int dstIndex, int len) {
        block3: {
            block2: {
                this.checkRange(srcIndex, len);
                this.checkRange(dstIndex, len);
                if (srcIndex >= dstIndex) break block2;
                for (int i = len - 1; i >= 0; --i) {
                    this.doReSet(dstIndex + i, this.doGet(srcIndex + i));
                }
                break block3;
            }
            if (srcIndex <= dstIndex) break block3;
            for (int i = 0; i < len; ++i) {
                this.doReSet(dstIndex + i, this.doGet(srcIndex + i));
            }
        }
    }

    public void move(int srcIndex, int dstIndex, int len) {
        int fill;
        int i;
        this.checkRange(srcIndex, len);
        this.checkRange(dstIndex, len);
        if (srcIndex < dstIndex) {
            for (i = len - 1; i >= 0; --i) {
                this.doReSet(dstIndex + i, this.doGet(srcIndex + i));
            }
        } else if (srcIndex > dstIndex) {
            for (i = 0; i < len; ++i) {
                this.doReSet(dstIndex + i, this.doGet(srcIndex + i));
            }
        }
        if (srcIndex < dstIndex) {
            fill = Math.min(len, dstIndex - srcIndex);
            this.setMult(srcIndex, fill, 0.0);
        } else if (srcIndex > dstIndex) {
            fill = Math.min(len, srcIndex - dstIndex);
            this.setMult(srcIndex + len - fill, fill, 0.0);
        }
    }

    public void drag(int srcIndex, int dstIndex, int len) {
        this.checkRange(srcIndex, len);
        this.checkRange(dstIndex, len);
        if (srcIndex < dstIndex) {
            this.doRotate(srcIndex, len + (dstIndex - srcIndex), dstIndex - srcIndex);
        } else if (srcIndex > dstIndex) {
            this.doRotate(dstIndex, len + (srcIndex - dstIndex), dstIndex - srcIndex);
        }
    }

    public void swap(int index1, int index2, int len) {
        this.checkRange(index1, len);
        this.checkRange(index2, len);
        if (index1 < index2 && index1 + len > index2 || index1 > index2 && index2 + len > index1) {
            throw new IndexOutOfBoundsException("Swap ranges overlap");
        }
        for (int i = 0; i < len; ++i) {
            double swap = this.doGet(index1 + i);
            swap = this.doReSet(index2 + i, swap);
            this.doReSet(index1 + i, swap);
        }
    }

    public void reverse() {
        this.reverse(0, this.size());
    }

    public void reverse(int index, int len) {
        this.checkRange(index, len);
        int pos1 = index;
        int pos2 = index + len - 1;
        int mid = len / 2;
        for (int i = 0; i < mid; ++i) {
            double swap = this.doGet(pos1);
            swap = this.doReSet(pos2, swap);
            this.doReSet(pos1, swap);
            ++pos1;
            --pos2;
        }
    }

    public void rotate(int distance) {
        this.rotate(0, this.size(), distance);
    }

    public void rotate(int index, int len, int distance) {
        this.checkRange(index, len);
        this.doRotate(index, len, distance);
    }

    protected void doRotate(int index, int len, int distance) {
        if ((distance %= len) < 0) {
            distance += len;
        }
        if (distance == 0) {
            return;
        }
        assert (distance >= 0 && distance < len);
        int num = 0;
        int start = 0;
        while (num != len) {
            double elem = this.doGet(index + start);
            int i = start;
            do {
                if ((i += distance) >= len) {
                    i -= len;
                }
                elem = this.doReSet(index + i, elem);
                ++num;
            } while (i != start);
            ++start;
        }
    }

    public void sort() {
        this.sort(0, this.size());
    }

    public abstract void sort(int var1, int var2);

    public int binarySearch(double key) {
        return this.binarySearch(0, this.size(), key);
    }

    public abstract int binarySearch(int var1, int var2, double var3);

    protected void checkIndex(int index) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException("Invalid index: " + index + " (size: " + this.size() + ")");
        }
    }

    protected void checkIndexAdd(int index) {
        if (index < 0 || index > this.size()) {
            throw new IndexOutOfBoundsException("Invalid index: " + index + " (size: " + this.size() + ")");
        }
    }

    protected void checkRange(int index, int len) {
        if (index < 0 || len < 0 || index + len > this.size()) {
            throw new IndexOutOfBoundsException("Invalid range: " + index + "/" + len + " (size: " + this.size() + ")");
        }
    }

    protected void checkLength(int len) {
        if (len < 0) {
            throw new IndexOutOfBoundsException("Invalid length: " + len);
        }
    }

    protected void checkLengths(int len1, int len2) {
        if (len1 != len2) {
            throw new IndexOutOfBoundsException("Invalid lengths: " + len1 + ", " + len2);
        }
        if (len1 < 0) {
            throw new IndexOutOfBoundsException("Invalid length: " + len1);
        }
        if (len2 < 0) {
            throw new IndexOutOfBoundsException("Invalid length: " + len2);
        }
    }

    protected void checkNonNull(Object obj) {
        if (obj == null) {
            throw new NullPointerException("Argument may not be 0");
        }
    }

    protected static class IReadOnlyDoubleListFromList
    extends IReadOnlyDoubleList {
        List<Double> list2;

        IReadOnlyDoubleListFromList(List<Double> list) {
            this.list2 = list;
        }

        @Override
        public int size() {
            return this.list2.size();
        }

        @Override
        protected double doGet(int index) {
            return this.list2.get(index);
        }
    }

    protected static class IReadOnlyDoubleListFromCollection
    extends IReadOnlyDoubleList {
        double[] array;

        IReadOnlyDoubleListFromCollection(Collection<Double> coll) {
            this.array = IReadOnlyDoubleListFromCollection.toArray(coll);
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        protected double doGet(int index) {
            return this.array[index];
        }
    }

    protected static class IReadOnlyDoubleListFromMult
    extends IReadOnlyDoubleList {
        int len;
        double elem;

        IReadOnlyDoubleListFromMult(int len, double elem) {
            this.checkLength(len);
            this.len = len;
            this.elem = elem;
        }

        @Override
        public int size() {
            return this.len;
        }

        @Override
        protected double doGet(int index) {
            return this.elem;
        }
    }

    protected static class IReadOnlyDoubleListFromArray
    extends IReadOnlyDoubleList {
        double[] array;
        int offset;
        int length;

        IReadOnlyDoubleListFromArray(double[] array) {
            this.array = array;
            this.offset = 0;
            this.length = array.length;
        }

        IReadOnlyDoubleListFromArray(double[] array, int offset, int length) {
            this.array = array;
            this.offset = offset;
            this.length = length;
        }

        @Override
        public int size() {
            return this.length;
        }

        @Override
        protected double doGet(int index) {
            return this.array[this.offset + index];
        }
    }

    protected static abstract class IReadOnlyDoubleList
    extends IDoubleList {
        protected IReadOnlyDoubleList() {
        }

        @Override
        public IDoubleList unmodifiableList() {
            this.error();
            return null;
        }

        @Override
        protected void doClone(IDoubleList that) {
            this.error();
        }

        @Override
        public int capacity() {
            this.error();
            return 0;
        }

        @Override
        protected double doSet(int index, double elem) {
            this.error();
            return 0.0;
        }

        @Override
        protected double doReSet(int index, double elem) {
            this.error();
            return 0.0;
        }

        @Override
        protected double getDefaultElem() {
            this.error();
            return 0.0;
        }

        @Override
        protected boolean doAdd(int index, double elem) {
            this.error();
            return false;
        }

        @Override
        protected double doRemove(int index) {
            this.error();
            return 0.0;
        }

        @Override
        protected void doEnsureCapacity(int minCapacity) {
            this.error();
        }

        @Override
        public void trimToSize() {
            this.error();
        }

        @Override
        protected IDoubleList doCreate(int capacity) {
            this.error();
            return null;
        }

        @Override
        protected void doAssign(IDoubleList that) {
            this.error();
        }

        @Override
        public void sort(int index, int len) {
            this.error();
        }

        @Override
        public int binarySearch(int index, int len, double key) {
            this.error();
            return 0;
        }

        private void error() {
            throw new UnsupportedOperationException("list is read-only");
        }
    }
}

