/*
 * Decompiled with CFR 0.152.
 */
package org.magicwerk.brownies.collections.primitive;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.magicwerk.brownies.collections.helper.primitive.FloatBinarySearch;
import org.magicwerk.brownies.collections.helper.primitive.FloatMergeSort;
import org.magicwerk.brownies.collections.primitive.FloatGapList;
import org.magicwerk.brownies.collections.primitive.IFloatList;

public class FloatBigList
extends IFloatList {
    private static final long serialVersionUID = 3715838828540564836L;
    private static final int DEFAULT_BLOCK_SIZE = 1000;
    private static final float MERGE_THRESHOLD = 0.35f;
    private static final float FILL_THRESHOLD = 0.95f;
    private static final boolean CHECK = false;
    private static final FloatBigList EMPTY = FloatBigList.create().unmodifiableList();
    private int blockSize;
    private int size;
    private FloatBlockNode rootNode;
    private FloatBlockNode currNode;
    private int currFloatBlockStart;
    private int currFloatBlockEnd;
    private int currModify;

    public static IFloatList of(float[] values) {
        return new ImmutableFloatListArrayPrimitive(values);
    }

    public static IFloatList of(Float[] values) {
        return new ImmutableFloatListArrayWrapper(values);
    }

    public static IFloatList of(List<Float> values) {
        return new ImmutableFloatListList(values);
    }

    public static FloatBigList EMPTY() {
        return EMPTY;
    }

    protected FloatBigList(boolean copy, FloatBigList that) {
        if (copy) {
            this.blockSize = that.blockSize;
            this.currFloatBlockStart = that.currFloatBlockStart;
            this.currFloatBlockEnd = that.currFloatBlockEnd;
            this.currNode = that.currNode;
            this.rootNode = that.rootNode;
            this.size = that.size;
        }
    }

    public static FloatBigList create() {
        return new FloatBigList();
    }

    public static FloatBigList create(Collection<Float> coll) {
        return new FloatBigList(coll != null ? coll : Collections.emptyList());
    }

    public static FloatBigList create(float ... elems) {
        FloatBigList list = new FloatBigList();
        if (elems != null) {
            for (float elem : elems) {
                list.add(elem);
            }
        }
        return list;
    }

    public FloatBigList() {
        this(1000);
    }

    public FloatBigList(int blockSize) {
        if (blockSize < 2) {
            throw new IndexOutOfBoundsException("Invalid blockSize: " + blockSize);
        }
        this.doInit(blockSize, -1);
    }

    public FloatBigList(Collection<Float> coll) {
        if (coll instanceof FloatBigList) {
            this.doAssign((FloatBigList)((Object)coll));
            this.doClone((FloatBigList)((Object)coll));
        } else {
            this.blockSize = 1000;
            this.addFloatBlock(0, new FloatBlock());
            for (Object obj : coll.toArray()) {
                this.add(((Float)obj).floatValue());
            }
            assert (this.size() == coll.size());
        }
    }

    public int blockSize() {
        return this.blockSize;
    }

    private FloatBigList(int blockSize, int firstFloatBlockSize) {
        this.doInit(blockSize, firstFloatBlockSize);
    }

    private void doInit(int blockSize, int firstFloatBlockSize) {
        this.blockSize = blockSize;
        FloatBlock block = firstFloatBlockSize <= 1 ? new FloatBlock() : new FloatBlock(firstFloatBlockSize);
        this.addFloatBlock(0, block);
    }

    @Override
    public FloatBigList copy() {
        return (FloatBigList)super.copy();
    }

    @Override
    public Object clone() {
        return super.clone();
    }

    @Override
    protected void doAssign(IFloatList that) {
        FloatBigList list = (FloatBigList)that;
        this.blockSize = list.blockSize;
        this.currFloatBlockEnd = list.currFloatBlockEnd;
        this.currFloatBlockStart = list.currFloatBlockStart;
        this.currNode = list.currNode;
        this.rootNode = list.rootNode;
        this.size = list.size;
    }

    @Override
    protected void doClone(IFloatList that) {
        FloatBigList bigList = (FloatBigList)that;
        bigList.releaseFloatBlock();
        this.rootNode = this.copy(bigList.rootNode);
        this.currNode = null;
        this.currModify = 0;
    }

    private FloatBlockNode copy(FloatBlockNode node) {
        FloatBlockNode newNode = node.min();
        int index = newNode.block.size();
        FloatBlockNode newRoot = new FloatBlockNode(null, index, newNode.block.ref(), null, null);
        while ((newNode = newNode.next()) != null) {
            newRoot = newRoot.insert(index += newNode.block.size(), newNode.block.ref());
            newRoot.parent = null;
        }
        return newRoot;
    }

    @Override
    public float getDefaultElem() {
        return 0.0f;
    }

    protected void finalize() {
        FloatBlockNode node = this.rootNode.min();
        while (node != null) {
            node.block.unref();
            node = node.next();
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public int capacity() {
        return -1;
    }

    @Override
    protected float doGet(int index) {
        int pos = this.getFloatBlockIndex(index, false, 0);
        return this.currNode.block.doGet(pos);
    }

    @Override
    protected float doSet(int index, float elem) {
        int pos = this.getFloatBlockIndex(index, true, 0);
        float oldElem = this.currNode.block.doGet(pos);
        this.currNode.block.doSet(pos, elem);
        return oldElem;
    }

    @Override
    protected float doReSet(int index, float elem) {
        int pos = this.getFloatBlockIndex(index, true, 0);
        float oldElem = this.currNode.block.doGet(pos);
        this.currNode.block.doSet(pos, elem);
        return oldElem;
    }

    private void releaseFloatBlock() {
        if (this.currModify != 0) {
            int modify = this.currModify;
            this.currModify = 0;
            this.modify(this.currNode, modify);
        }
        this.currNode = null;
    }

    private int getFloatBlockIndex(int index, boolean write, int modify) {
        if (this.currNode != null) {
            if (index >= this.currFloatBlockStart && (index < this.currFloatBlockEnd || index == this.currFloatBlockEnd && this.size == index)) {
                if (write && this.currNode.block.isShared()) {
                    this.currNode.block.unref();
                    this.currNode.setFloatBlock(new FloatBlock(this.currNode.block));
                }
                this.currModify += modify;
                return index - this.currFloatBlockStart;
            }
            this.releaseFloatBlock();
        }
        if (index == this.size) {
            if (this.currNode == null || this.currFloatBlockEnd != this.size) {
                this.currNode = this.rootNode.max();
                this.currFloatBlockEnd = this.size;
                this.currFloatBlockStart = this.size - this.currNode.block.size();
            }
            if (modify != 0) {
                this.currNode.relPos += modify;
                FloatBlockNode leftNode = this.currNode.getLeftSubTree();
                if (leftNode != null) {
                    leftNode.relPos -= modify;
                }
            }
        } else if (index == 0) {
            if (this.currNode == null || this.currFloatBlockStart != 0) {
                this.currNode = this.rootNode.min();
                this.currFloatBlockEnd = this.currNode.block.size();
                this.currFloatBlockStart = 0;
            }
            if (modify != 0) {
                this.rootNode.relPos += modify;
            }
        }
        if (this.currNode == null) {
            this.doGetFloatBlock(index, modify);
        }
        assert (index >= this.currFloatBlockStart && index <= this.currFloatBlockEnd);
        if (write && this.currNode.block.isShared()) {
            this.currNode.block.unref();
            this.currNode.setFloatBlock(new FloatBlock(this.currNode.block));
        }
        return index - this.currFloatBlockStart;
    }

    private boolean isOnlyRootFloatBlock() {
        return this.rootNode.left == null && this.rootNode.right == null;
    }

    private void doGetFloatBlock(int index, int modify) {
        this.currNode = this.rootNode;
        this.currFloatBlockEnd = this.rootNode.relPos;
        if (this.currNode.relPos == 0) {
            if (modify != 0) {
                this.currNode.relPos += modify;
            }
        } else {
            boolean wasLeft = false;
            while (true) {
                FloatBlockNode nextNode;
                assert (index >= 0);
                int leftIndex = this.currFloatBlockEnd - this.currNode.block.size();
                assert (leftIndex >= 0);
                if (index >= leftIndex && index < this.currFloatBlockEnd) {
                    if (modify == 0) break;
                    FloatBlockNode leftNode = this.currNode.getLeftSubTree();
                    if (this.currNode.relPos > 0) {
                        this.currNode.relPos += modify;
                        if (leftNode == null) break;
                        leftNode.relPos -= modify;
                        break;
                    }
                    if (leftNode == null) break;
                    leftNode.relPos -= modify;
                    break;
                }
                if (index < this.currFloatBlockEnd) {
                    nextNode = this.currNode.getLeftSubTree();
                    if (!(modify == 0 || nextNode != null && wasLeft)) {
                        this.currNode.relPos = this.currNode.relPos > 0 ? (this.currNode.relPos += modify) : (this.currNode.relPos -= modify);
                        wasLeft = true;
                    }
                    if (nextNode == null) {
                        break;
                    }
                } else {
                    nextNode = this.currNode.getRightSubTree();
                    if (modify != 0 && (nextNode == null || wasLeft)) {
                        if (this.currNode.relPos > 0) {
                            this.currNode.relPos += modify;
                            FloatBlockNode left = this.currNode.getLeftSubTree();
                            if (left != null) {
                                left.relPos -= modify;
                            }
                        } else {
                            this.currNode.relPos -= modify;
                        }
                        wasLeft = false;
                    }
                    if (nextNode == null) break;
                }
                this.currFloatBlockEnd += nextNode.relPos;
                this.currNode = nextNode;
            }
        }
        this.currFloatBlockStart = this.currFloatBlockEnd - this.currNode.block.size();
    }

    private void addFloatBlock(int index, FloatBlock obj) {
        if (this.rootNode == null) {
            this.rootNode = new FloatBlockNode(null, index, obj, null, null);
        } else {
            this.rootNode = this.rootNode.insert(index, obj);
            this.rootNode.parent = null;
        }
    }

    @Override
    protected boolean doAdd(int index, float element) {
        int maxSize;
        if (index == -1) {
            index = this.size;
        }
        int pos = this.getFloatBlockIndex(index, true, 1);
        int n = maxSize = index == this.size || index == 0 ? (int)((float)this.blockSize * 0.95f) : this.blockSize;
        if (this.currNode.block.size() < maxSize || this.currNode.block.size() == 1 && this.currNode.block.size() < this.blockSize) {
            this.currNode.block.doAdd(pos, element);
            ++this.currFloatBlockEnd;
        } else {
            FloatBlock newFloatBlock = new FloatBlock(this.blockSize);
            if (index == this.size) {
                FloatBlockNode lastNode;
                newFloatBlock.doAdd(0, element);
                this.modify(this.currNode, -1);
                this.addFloatBlock(this.size + 1, newFloatBlock);
                this.currNode = lastNode = this.currNode.next();
                this.currFloatBlockStart = this.currFloatBlockEnd++;
            } else if (index == 0) {
                FloatBlockNode firstNode;
                newFloatBlock.doAdd(0, element);
                this.modify(this.currNode, -1);
                this.addFloatBlock(1, newFloatBlock);
                this.currNode = firstNode = this.currNode.previous();
                this.currFloatBlockStart = 0;
                this.currFloatBlockEnd = 1;
            } else {
                int nextFloatBlockLen = this.blockSize / 2;
                int blockLen = this.blockSize - nextFloatBlockLen;
                FloatGapList.transferRemove(this.currNode.block, blockLen, nextFloatBlockLen, newFloatBlock, 0, 0);
                this.modify(this.currNode, -nextFloatBlockLen - 1);
                this.addFloatBlock(this.currFloatBlockEnd - nextFloatBlockLen, newFloatBlock);
                if (pos < blockLen) {
                    this.currNode.block.doAdd(pos, element);
                    this.currFloatBlockEnd = this.currFloatBlockStart + blockLen + 1;
                    this.modify(this.currNode, 1);
                } else {
                    this.currNode = this.currNode.next();
                    this.modify(this.currNode, 1);
                    this.currNode.block.doAdd(pos - blockLen, element);
                    this.currFloatBlockStart += blockLen;
                    ++this.currFloatBlockEnd;
                }
            }
        }
        ++this.size;
        return true;
    }

    private void modify(FloatBlockNode node, int modify) {
        if (node == this.currNode) {
            modify += this.currModify;
            this.currModify = 0;
        } else {
            this.releaseFloatBlock();
        }
        if (modify == 0) {
            return;
        }
        if (node.relPos < 0) {
            FloatBlockNode p;
            FloatBlockNode leftNode = node.getLeftSubTree();
            if (leftNode != null) {
                leftNode.relPos -= modify;
            }
            FloatBlockNode pp = node.parent;
            assert (pp.getLeftSubTree() == node);
            boolean parentRight = true;
            while ((p = pp.parent) != null) {
                boolean pRight;
                boolean bl = pRight = p.getLeftSubTree() == pp;
                if (parentRight != pRight) {
                    pp.relPos = pp.relPos > 0 ? (pp.relPos += modify) : (pp.relPos -= modify);
                }
                pp = p;
                parentRight = pRight;
            }
            if (parentRight) {
                this.rootNode.relPos += modify;
            }
        } else {
            FloatBlockNode parent;
            node.relPos += modify;
            FloatBlockNode leftNode = node.getLeftSubTree();
            if (leftNode != null) {
                leftNode.relPos -= modify;
            }
            if ((parent = node.parent) != null) {
                FloatBlockNode p;
                assert (parent.getRightSubTree() == node);
                boolean parentLeft = true;
                while ((p = parent.parent) != null) {
                    boolean pLeft;
                    boolean bl = pLeft = p.getRightSubTree() == parent;
                    if (parentLeft != pLeft) {
                        parent.relPos = parent.relPos > 0 ? (parent.relPos += modify) : (parent.relPos -= modify);
                    }
                    parent = p;
                    parentLeft = pLeft;
                }
                if (!parentLeft) {
                    this.rootNode.relPos += modify;
                }
            }
        }
    }

    private FloatBlockNode doRemove(FloatBlockNode node) {
        FloatBlockNode newNode;
        FloatBlockNode p = node.parent;
        FloatBlockNode n = newNode = node.removeSelf();
        while (p != null) {
            assert (p.left == node || p.right == node);
            if (p.left == node) {
                p.left = newNode;
            } else {
                p.right = newNode;
            }
            node = p;
            node.recalcHeight();
            newNode = node.balance();
            p = newNode.parent;
        }
        this.rootNode = newNode;
        return n;
    }

    @Override
    protected boolean doAddAll(int index, IFloatList list) {
        if (list.size() == 0) {
            return false;
        }
        if (index == -1) {
            index = this.size;
        }
        int oldSize = this.size;
        if (list.size() == 1) {
            return this.doAdd(index, list.get(0));
        }
        int addPos = this.getFloatBlockIndex(index, true, 0);
        FloatBlock addFloatBlock = this.currNode.block;
        int space = this.blockSize - addFloatBlock.size();
        int addLen = list.size();
        if (addLen <= space) {
            this.currNode.block.addAll(addPos, list);
            this.modify(this.currNode, addLen);
            this.size += addLen;
            this.currFloatBlockEnd += addLen;
        } else if (index == this.size) {
            int add;
            for (int i = 0; i < space; ++i) {
                this.currNode.block.add(addPos + i, list.get(i));
            }
            this.modify(this.currNode, space);
            int done = space;
            for (int todo = addLen - space; todo > 0; todo -= add) {
                FloatBlock nextFloatBlock = new FloatBlock(this.blockSize);
                add = Math.min(todo, this.blockSize);
                for (int i = 0; i < add; ++i) {
                    nextFloatBlock.add(i, list.get(done + i));
                }
                this.addFloatBlock(this.size + (done += add), nextFloatBlock);
                this.currNode = this.currNode.next();
            }
            this.size += addLen;
            this.currFloatBlockEnd = this.size;
            this.currFloatBlockStart = this.currFloatBlockEnd - this.currNode.block.size();
        } else if (index == 0) {
            int add;
            assert (addPos == 0);
            for (int i = 0; i < space; ++i) {
                this.currNode.block.add(addPos + i, list.get(addLen - space + i));
            }
            this.modify(this.currNode, space);
            int done = space;
            for (int todo = addLen - space; todo > 0; todo -= add) {
                FloatBlock nextFloatBlock = new FloatBlock(this.blockSize);
                add = Math.min(todo, this.blockSize);
                for (int i = 0; i < add; ++i) {
                    nextFloatBlock.add(i, list.get(addLen - done - add + i));
                }
                done += add;
                this.addFloatBlock(0, nextFloatBlock);
                this.currNode = this.currNode.previous();
            }
            this.size += addLen;
            this.currFloatBlockStart = 0;
            this.currFloatBlockEnd = this.currNode.block.size();
        } else {
            FloatGapList sublist;
            int add;
            FloatGapList list2 = FloatGapList.create();
            list2.addAll(list);
            int remove = this.currNode.block.size() - addPos;
            if (remove > 0) {
                list2.addAll(this.currNode.block.getAll(addPos, remove));
                this.currNode.block.remove(addPos, remove);
                this.modify(this.currNode, -remove);
                this.size -= remove;
                this.currFloatBlockEnd -= remove;
            }
            int numElems = this.currNode.block.size() + list2.size();
            int numFloatBlocks = (numElems - 1) / this.blockSize + 1;
            assert (numFloatBlocks > 1);
            int has = this.currNode.block.size();
            int should = numElems / numFloatBlocks;
            int listPos = 0;
            if (has < should) {
                add = should - has;
                sublist = list2.getAll(0, add);
                listPos += add;
                this.currNode.block.addAll(addPos, sublist);
                this.modify(this.currNode, add);
                assert (this.currNode.block.size() == should);
                numElems -= should;
                --numFloatBlocks;
                this.size += add;
                this.currFloatBlockEnd += add;
            } else if (has > should) {
                FloatBlock nextFloatBlock = new FloatBlock(this.blockSize);
                int move = has - should;
                nextFloatBlock.addAll(this.currNode.block.getAll(this.currNode.block.size() - move, move));
                this.currNode.block.remove(this.currNode.block.size() - move, move);
                this.modify(this.currNode, -move);
                assert (this.currNode.block.size() == should);
                numElems -= should;
                this.currFloatBlockEnd -= move;
                should = numElems / --numFloatBlocks;
                int add2 = should - move;
                assert (add2 >= 0);
                FloatGapList sublist2 = list2.getAll(0, add2);
                nextFloatBlock.addAll(move, sublist2);
                listPos += add2;
                assert (nextFloatBlock.size() == should);
                numElems -= should;
                --numFloatBlocks;
                this.size += add2;
                this.addFloatBlock(this.currFloatBlockEnd, nextFloatBlock);
                this.currNode = this.currNode.next();
                assert (this.currNode.block == nextFloatBlock);
                assert (this.currNode.block.size() == add2 + move);
                this.currFloatBlockStart = this.currFloatBlockEnd;
                this.currFloatBlockEnd += add2 + move;
            } else {
                numElems -= should;
                --numFloatBlocks;
            }
            while (numFloatBlocks > 0) {
                add = numElems / numFloatBlocks;
                assert (add > 0);
                sublist = list2.getAll(listPos, add);
                listPos += add;
                FloatBlock nextFloatBlock = new FloatBlock();
                nextFloatBlock.addAll(sublist);
                assert (nextFloatBlock.size() == add);
                numElems -= add;
                this.addFloatBlock(this.currFloatBlockEnd, nextFloatBlock);
                this.currNode = this.currNode.next();
                assert (this.currNode.block == nextFloatBlock);
                assert (this.currNode.block.size() == add);
                this.currFloatBlockStart = this.currFloatBlockEnd;
                this.currFloatBlockEnd += add;
                this.size += add;
                --numFloatBlocks;
            }
        }
        assert (oldSize + addLen == this.size);
        return true;
    }

    @Override
    protected void doClear() {
        this.finalize();
        this.rootNode = null;
        this.currFloatBlockStart = 0;
        this.currFloatBlockEnd = 0;
        this.currModify = 0;
        this.currNode = null;
        this.size = 0;
        this.doInit(this.blockSize, 0);
    }

    @Override
    protected void doRemoveAll(int index, int len) {
        if (len == 0) {
            return;
        }
        if (index == 0 && len == this.size) {
            this.doClear();
            return;
        }
        if (len == 1) {
            this.doRemove(index);
            return;
        }
        int startPos = this.getFloatBlockIndex(index, true, 0);
        FloatBlockNode startNode = this.currNode;
        int endPos = this.getFloatBlockIndex(index + len - 1, true, 0);
        FloatBlockNode endNode = this.currNode;
        if (startNode == endNode) {
            this.getFloatBlockIndex(index, true, -len);
            this.currNode.block.remove(startPos, len);
            if (this.currNode.block.isEmpty()) {
                FloatBlockNode oldCurrNode = this.currNode;
                this.releaseFloatBlock();
                FloatBlockNode node = this.doRemove(oldCurrNode);
                this.merge(node);
            } else {
                this.currFloatBlockEnd -= len;
                this.merge(this.currNode);
            }
            this.size -= len;
        } else {
            int startLen = startNode.block.size() - startPos;
            this.getFloatBlockIndex(index, true, -startLen);
            startNode.block.remove(startPos, startLen);
            assert (startNode == this.currNode);
            if (this.currNode.block.isEmpty()) {
                this.releaseFloatBlock();
                this.doRemove(startNode);
                startNode = null;
            }
            len -= startLen;
            this.size -= startLen;
            while (len > 0) {
                this.currNode = null;
                this.getFloatBlockIndex(index, true, 0);
                int s = this.currNode.block.size();
                if (s <= len) {
                    this.modify(this.currNode, -s);
                    FloatBlockNode oldCurrNode = this.currNode;
                    this.releaseFloatBlock();
                    this.doRemove(oldCurrNode);
                    if (oldCurrNode == endNode) {
                        endNode = null;
                    }
                    len -= s;
                    this.size -= s;
                    continue;
                }
                this.modify(this.currNode, -len);
                this.currNode.block.remove(0, len);
                this.size -= len;
                break;
            }
            this.releaseFloatBlock();
            this.getFloatBlockIndex(index, false, 0);
            this.merge(this.currNode);
        }
    }

    private void merge(FloatBlockNode node) {
        if (node == null) {
            return;
        }
        int minFloatBlockSize = Math.max((int)((float)this.blockSize * 0.35f), 1);
        if (node.block.size() >= minFloatBlockSize) {
            return;
        }
        FloatBlockNode oldCurrNode = node;
        FloatBlockNode leftNode = node.previous();
        if (leftNode != null && leftNode.block.size() < minFloatBlockSize) {
            int len = node.block.size();
            int dstSize = leftNode.getFloatBlock().size();
            for (int i = 0; i < len; ++i) {
                leftNode.block.add(0.0f);
            }
            FloatGapList.transferCopy(node.block, 0, len, leftNode.block, dstSize, len);
            assert (leftNode.block.size() <= this.blockSize);
            this.modify(leftNode, len);
            this.modify(oldCurrNode, -len);
            this.releaseFloatBlock();
            this.doRemove(oldCurrNode);
        } else {
            FloatBlockNode rightNode = node.next();
            if (rightNode != null && rightNode.block.size() < minFloatBlockSize) {
                int len = node.block.size();
                for (int i = 0; i < len; ++i) {
                    rightNode.block.add(0, 0.0f);
                }
                FloatGapList.transferCopy(node.block, 0, len, rightNode.block, 0, len);
                assert (rightNode.block.size() <= this.blockSize);
                this.modify(rightNode, len);
                this.modify(oldCurrNode, -len);
                this.releaseFloatBlock();
                this.doRemove(oldCurrNode);
            }
        }
    }

    @Override
    protected float doRemove(int index) {
        int pos = this.getFloatBlockIndex(index, true, -1);
        float oldElem = this.currNode.block.doRemove(pos);
        --this.currFloatBlockEnd;
        int minFloatBlockSize = Math.max(this.blockSize / 3, 1);
        if (this.currNode.block.size() < minFloatBlockSize) {
            if (this.currNode.block.size() == 0) {
                if (!this.isOnlyRootFloatBlock()) {
                    FloatBlockNode oldCurrNode = this.currNode;
                    this.releaseFloatBlock();
                    this.doRemove(oldCurrNode);
                }
            } else if (index != 0 && index != this.size - 1) {
                this.merge(this.currNode);
            }
        }
        --this.size;
        return oldElem;
    }

    @Override
    public FloatBigList unmodifiableList() {
        return new ImmutableFloatBigList(this);
    }

    @Override
    protected void doEnsureCapacity(int minCapacity) {
        if (this.isOnlyRootFloatBlock()) {
            if (minCapacity > this.blockSize) {
                minCapacity = this.blockSize;
            }
            this.rootNode.block.doEnsureCapacity(minCapacity);
        }
    }

    @Override
    public void trimToSize() {
        this.doModify();
        if (this.isOnlyRootFloatBlock()) {
            this.rootNode.block.trimToSize();
        } else {
            FloatBigList newList = new FloatBigList(this.blockSize);
            FloatBlockNode node = this.rootNode.min();
            while (node != null) {
                newList.addAll(node.block);
                this.remove(0, node.block.size());
                node = node.next();
            }
            this.doAssign(newList);
        }
    }

    @Override
    protected IFloatList doCreate(int capacity) {
        if (capacity <= this.blockSize) {
            return new FloatBigList(this.blockSize);
        }
        return new FloatBigList(this.blockSize, capacity);
    }

    @Override
    public void sort(int index, int len) {
        this.checkRange(index, len);
        if (this.isOnlyRootFloatBlock()) {
            this.rootNode.block.sort(index, len);
        } else {
            FloatMergeSort.sort(this, index, index + len);
        }
    }

    @Override
    public int binarySearch(int index, int len, float key) {
        this.checkRange(index, len);
        if (this.isOnlyRootFloatBlock()) {
            return this.rootNode.block.binarySearch(key);
        }
        return FloatBinarySearch.binarySearch(this, key, 0, this.size());
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.writeInt(this.blockSize);
        int size = this.size();
        oos.writeInt(size);
        for (int i = 0; i < size; ++i) {
            oos.writeFloat(this.doGet(i));
        }
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        int blockSize = ois.readInt();
        int size = ois.readInt();
        int firstFloatBlockSize = size <= blockSize ? size : -1;
        this.doInit(blockSize, firstFloatBlockSize);
        for (int i = 0; i < size; ++i) {
            this.add(ois.readFloat());
        }
    }

    private void checkNode(FloatBlockNode node) {
        assert ((node.block.size() > 0 || node == this.rootNode) && node.block.size() <= this.blockSize);
        FloatBlockNode child = node.getLeftSubTree();
        assert (child == null || child.parent == node);
        child = node.getRightSubTree();
        assert (child == null || child.parent == node);
    }

    private void checkHeight(FloatBlockNode node) {
        FloatBlockNode left = node.getLeftSubTree();
        FloatBlockNode right = node.getRightSubTree();
        if (left == null) {
            if (right == null) {
                assert (node.height == 0);
            } else {
                assert (right.height == node.height - 1);
                this.checkHeight(right);
            }
        } else {
            if (right == null) {
                assert (left.height == node.height - 1);
            } else {
                assert (left.height == node.height - 1 || left.height == node.height - 2);
                assert (right.height == node.height - 1 || right.height == node.height - 2);
                assert (right.height == node.height - 1 || left.height == node.height - 1);
            }
            this.checkHeight(left);
        }
    }

    private void check() {
        if (this.currNode != null) {
            assert (this.currFloatBlockStart >= 0 && this.currFloatBlockEnd <= this.size && this.currFloatBlockStart <= this.currFloatBlockEnd);
            assert (this.currFloatBlockStart + this.currNode.block.size() == this.currFloatBlockEnd);
        }
        if (this.rootNode == null) {
            assert (this.size == 0);
            return;
        }
        this.checkHeight(this.rootNode);
        FloatBlockNode oldCurrNode = this.currNode;
        int oldCurrModify = this.currModify;
        if (this.currModify != 0) {
            this.currNode = null;
            this.currModify = 0;
            this.modify(oldCurrNode, oldCurrModify);
        }
        FloatBlockNode node = this.rootNode;
        this.checkNode(node);
        int index = node.relPos;
        while (node.left != null) {
            node = node.left;
            this.checkNode(node);
            assert (node.relPos < 0);
            index += node.relPos;
        }
        FloatBlock block = node.getFloatBlock();
        assert (block.size() == index);
        int lastIndex = index;
        while (lastIndex < this.size()) {
            node = this.rootNode;
            index = node.relPos;
            int searchIndex = lastIndex + 1;
            while (true) {
                this.checkNode(node);
                block = node.getFloatBlock();
                assert (block.size() > 0);
                if (searchIndex > index - block.size() && searchIndex <= index) break;
                if (searchIndex < index) {
                    if (node.left == null || node.left.height >= node.height) break;
                    node = node.left;
                } else {
                    if (node.right == null || node.right.height >= node.height) break;
                    node = node.right;
                }
                index += node.relPos;
            }
            block = node.getFloatBlock();
            assert (block.size() == index - lastIndex);
            lastIndex = index;
        }
        assert (index == this.size());
        if (oldCurrModify != 0) {
            this.modify(oldCurrNode, -oldCurrModify);
        }
        this.currNode = oldCurrNode;
        this.currModify = oldCurrModify;
    }

    protected static class ImmutableFloatBigList
    extends FloatBigList {
        private static final long serialVersionUID = -1352274047348922584L;

        protected ImmutableFloatBigList(FloatBigList that) {
            super(true, that);
        }

        @Override
        protected boolean doAdd(int index, float elem) {
            this.error();
            return false;
        }

        @Override
        protected float doSet(int index, float elem) {
            this.error();
            return 0.0f;
        }

        @Override
        protected float doReSet(int index, float elem) {
            this.error();
            return 0.0f;
        }

        @Override
        protected float doRemove(int index) {
            this.error();
            return 0.0f;
        }

        @Override
        protected void doRemoveAll(int index, int len) {
            this.error();
        }

        @Override
        protected void doClear() {
            this.error();
        }

        @Override
        protected void doModify() {
            this.error();
        }

        private void error() {
            throw new UnsupportedOperationException("list is immutable");
        }
    }

    static class FloatBlockNode {
        FloatBlockNode parent;
        FloatBlockNode left;
        boolean leftIsPrevious;
        FloatBlockNode right;
        boolean rightIsNext;
        int height;
        int relPos;
        FloatBlock block;

        private FloatBlockNode(FloatBlockNode parent, int relPos, FloatBlock block, FloatBlockNode rightFollower, FloatBlockNode leftFollower) {
            this.parent = parent;
            this.relPos = relPos;
            this.block = block;
            this.rightIsNext = true;
            this.leftIsPrevious = true;
            this.right = rightFollower;
            this.left = leftFollower;
        }

        private FloatBlock getFloatBlock() {
            return this.block;
        }

        private void setFloatBlock(FloatBlock block) {
            this.block = block;
        }

        private FloatBlockNode next() {
            if (this.rightIsNext || this.right == null) {
                return this.right;
            }
            return this.right.min();
        }

        private FloatBlockNode previous() {
            if (this.leftIsPrevious || this.left == null) {
                return this.left;
            }
            return this.left.max();
        }

        private FloatBlockNode insert(int index, FloatBlock obj) {
            assert (this.relPos != 0);
            int relIndex = index - this.relPos;
            if (relIndex < 0) {
                return this.insertOnLeft(relIndex, obj);
            }
            return this.insertOnRight(relIndex, obj);
        }

        private FloatBlockNode insertOnLeft(int relIndex, FloatBlock obj) {
            if (this.getLeftSubTree() == null) {
                int pos = this.relPos >= 0 ? -this.relPos : -this.block.size();
                this.setLeft(new FloatBlockNode(this, pos, obj, this, this.left), null);
            } else {
                this.setLeft(this.left.insert(relIndex, obj), null);
            }
            if (this.relPos >= 0) {
                this.relPos += obj.size();
            }
            FloatBlockNode ret = this.balance();
            this.recalcHeight();
            return ret;
        }

        private FloatBlockNode insertOnRight(int relIndex, FloatBlock obj) {
            if (this.getRightSubTree() == null) {
                this.setRight(new FloatBlockNode(this, obj.size(), obj, this.right, this), null);
            } else {
                this.setRight(this.right.insert(relIndex, obj), null);
            }
            if (this.relPos < 0) {
                this.relPos -= obj.size();
            }
            FloatBlockNode ret = this.balance();
            this.recalcHeight();
            return ret;
        }

        private FloatBlockNode getLeftSubTree() {
            return this.leftIsPrevious ? null : this.left;
        }

        private FloatBlockNode getRightSubTree() {
            return this.rightIsNext ? null : this.right;
        }

        private FloatBlockNode max() {
            return this.getRightSubTree() == null ? this : this.right.max();
        }

        private FloatBlockNode min() {
            return this.getLeftSubTree() == null ? this : this.left.min();
        }

        private FloatBlockNode removeMax() {
            if (this.getRightSubTree() == null) {
                return this.removeSelf();
            }
            this.setRight(this.right.removeMax(), this.right.right);
            this.recalcHeight();
            return this.balance();
        }

        private FloatBlockNode removeMin(int size) {
            if (this.getLeftSubTree() == null) {
                return this.removeSelf();
            }
            this.setLeft(this.left.removeMin(size), this.left.left);
            if (this.relPos > 0) {
                this.relPos -= size;
            }
            this.recalcHeight();
            return this.balance();
        }

        private FloatBlockNode removeSelf() {
            FloatBlockNode p = this.parent;
            FloatBlockNode n = this.doRemoveSelf();
            if (n != null) {
                assert (p != n);
                n.parent = p;
            }
            return n;
        }

        private FloatBlockNode doRemoveSelf() {
            if (this.getRightSubTree() == null && this.getLeftSubTree() == null) {
                return null;
            }
            if (this.getRightSubTree() == null) {
                this.left.relPos = this.relPos > 0 ? this.left.relPos + (this.relPos + (this.relPos > 0 ? 0 : 1)) : (this.left.relPos += this.relPos);
                this.left.max().setRight(null, this.right);
                return this.left;
            }
            if (this.getLeftSubTree() == null) {
                if (this.relPos < 0) {
                    this.right.relPos = this.right.relPos + (this.relPos - (this.relPos < 0 ? 0 : 1));
                }
                this.right.min().setLeft(null, this.left);
                return this.right;
            }
            if (this.heightRightMinusLeft() > 0) {
                FloatBlockNode rightMin = this.right.min();
                this.block = rightMin.block;
                int bs = this.block.size();
                if (this.leftIsPrevious) {
                    this.left = rightMin.left;
                }
                this.right = this.right.removeMin(bs);
                this.relPos += bs;
                this.left.relPos -= bs;
            } else {
                FloatBlockNode leftMax = this.left.max();
                this.block = leftMax.block;
                if (this.rightIsNext) {
                    this.right = leftMax.right;
                }
                FloatBlockNode leftPrevious = this.left.left;
                this.left = this.left.removeMax();
                if (this.left == null) {
                    this.left = leftPrevious;
                    this.leftIsPrevious = true;
                } else if (this.left.relPos == 0) {
                    this.left.relPos = -1;
                }
            }
            this.recalcHeight();
            return this;
        }

        private FloatBlockNode balance() {
            switch (this.heightRightMinusLeft()) {
                case -1: 
                case 0: 
                case 1: {
                    return this;
                }
                case -2: {
                    if (this.left.heightRightMinusLeft() > 0) {
                        this.setLeft(this.left.rotateLeft(), null);
                    }
                    return this.rotateRight();
                }
                case 2: {
                    if (this.right.heightRightMinusLeft() < 0) {
                        this.setRight(this.right.rotateRight(), null);
                    }
                    return this.rotateLeft();
                }
            }
            throw new RuntimeException("tree inconsistent!");
        }

        private int getOffset(FloatBlockNode node) {
            if (node == null) {
                return 0;
            }
            return node.relPos;
        }

        private int setOffset(FloatBlockNode node, int newOffest) {
            if (node == null) {
                return 0;
            }
            int oldOffset = this.getOffset(node);
            node.relPos = newOffest;
            return oldOffset;
        }

        private void recalcHeight() {
            this.height = Math.max(this.getLeftSubTree() == null ? -1 : this.getLeftSubTree().height, this.getRightSubTree() == null ? -1 : this.getRightSubTree().height) + 1;
        }

        private int getHeight(FloatBlockNode node) {
            return node == null ? -1 : node.height;
        }

        private int heightRightMinusLeft() {
            return this.getHeight(this.getRightSubTree()) - this.getHeight(this.getLeftSubTree());
        }

        private FloatBlockNode rotateLeft() {
            assert (!this.rightIsNext);
            FloatBlockNode newTop = this.right;
            FloatBlockNode movedNode = this.getRightSubTree().getLeftSubTree();
            int newTopPosition = this.relPos + this.getOffset(newTop);
            int myNewPosition = -newTop.relPos;
            int movedPosition = this.getOffset(newTop) + this.getOffset(movedNode);
            FloatBlockNode p = this.parent;
            this.setRight(movedNode, newTop);
            newTop.setLeft(this, null);
            newTop.parent = p;
            this.parent = newTop;
            this.setOffset(newTop, newTopPosition);
            this.setOffset(this, myNewPosition);
            this.setOffset(movedNode, movedPosition);
            assert (newTop.getLeftSubTree() == null || newTop.getLeftSubTree().relPos < 0);
            assert (newTop.getRightSubTree() == null || newTop.getRightSubTree().relPos > 0);
            return newTop;
        }

        private FloatBlockNode rotateRight() {
            assert (!this.leftIsPrevious);
            FloatBlockNode newTop = this.left;
            FloatBlockNode movedNode = this.getLeftSubTree().getRightSubTree();
            int newTopPosition = this.relPos + this.getOffset(newTop);
            int myNewPosition = -newTop.relPos;
            int movedPosition = this.getOffset(newTop) + this.getOffset(movedNode);
            FloatBlockNode p = this.parent;
            this.setLeft(movedNode, newTop);
            newTop.setRight(this, null);
            newTop.parent = p;
            this.parent = newTop;
            this.setOffset(newTop, newTopPosition);
            this.setOffset(this, myNewPosition);
            this.setOffset(movedNode, movedPosition);
            assert (newTop.getLeftSubTree() == null || newTop.getLeftSubTree().relPos < 0);
            assert (newTop.getRightSubTree() == null || newTop.getRightSubTree().relPos > 0);
            return newTop;
        }

        private void setLeft(FloatBlockNode node, FloatBlockNode previous) {
            assert (node != this && previous != this);
            boolean bl = this.leftIsPrevious = node == null;
            if (this.leftIsPrevious) {
                this.left = previous;
            } else {
                this.left = node;
                this.left.parent = this;
            }
            this.recalcHeight();
        }

        private void setRight(FloatBlockNode node, FloatBlockNode next) {
            assert (node != this && next != this);
            boolean bl = this.rightIsNext = node == null;
            if (this.rightIsNext) {
                this.right = next;
            } else {
                this.right = node;
                this.right.parent = this;
            }
            this.recalcHeight();
        }

        public String toString() {
            return "FloatBlockNode(" + this.relPos + ',' + (this.getRightSubTree() != null) + ',' + this.block + ',' + (this.getRightSubTree() != null) + ", height " + this.height + " )";
        }
    }

    static class FloatBlock
    extends FloatGapList {
        private AtomicInteger refCount = new AtomicInteger(1);

        public FloatBlock() {
        }

        public FloatBlock(int capacity) {
            super(capacity);
        }

        public FloatBlock(FloatBlock that) {
            super(that.capacity());
            this.addAll(that);
        }

        public boolean isShared() {
            return this.refCount.get() > 1;
        }

        public FloatBlock ref() {
            this.refCount.incrementAndGet();
            return this;
        }

        public void unref() {
            this.refCount.decrementAndGet();
        }
    }

    protected static abstract class ImmutableFloatList
    extends IFloatList {
        protected ImmutableFloatList() {
        }

        @Override
        public int capacity() {
            return this.size();
        }

        @Override
        public int binarySearch(int index, int len, float key) {
            return FloatBinarySearch.binarySearch(this, key, index, index + len);
        }

        @Override
        public IFloatList unmodifiableList() {
            return this;
        }

        @Override
        protected float getDefaultElem() {
            return 0.0f;
        }

        private void error() {
            throw new UnsupportedOperationException("list is immutable");
        }

        @Override
        protected void doRemoveAll(int index, int len) {
            this.error();
        }

        @Override
        protected void doClear() {
            this.error();
        }

        @Override
        protected void doModify() {
            this.error();
        }

        @Override
        protected void doClone(IFloatList that) {
            this.error();
        }

        @Override
        protected float doSet(int index, float elem) {
            this.error();
            return 0.0f;
        }

        @Override
        protected float doReSet(int index, float elem) {
            this.error();
            return 0.0f;
        }

        @Override
        protected boolean doAdd(int index, float elem) {
            this.error();
            return false;
        }

        @Override
        protected void doEnsureCapacity(int minCapacity) {
            this.error();
        }

        @Override
        public void trimToSize() {
            this.error();
        }

        @Override
        protected IFloatList doCreate(int capacity) {
            this.error();
            return null;
        }

        @Override
        protected void doAssign(IFloatList that) {
            this.error();
        }

        @Override
        protected float doRemove(int index) {
            this.error();
            return 0.0f;
        }

        @Override
        public void sort(int index, int len) {
            this.error();
        }
    }

    static class ImmutableFloatListList
    extends ImmutableFloatList {
        List<Float> values;

        public ImmutableFloatListList(List<Float> values) {
            this.values = values;
        }

        @Override
        public int size() {
            return this.values.size();
        }

        @Override
        protected float doGet(int index) {
            return this.values.get(index).floatValue();
        }
    }

    static class ImmutableFloatListArrayWrapper
    extends ImmutableFloatList {
        Float[] values;

        public ImmutableFloatListArrayWrapper(Float[] values) {
            this.values = values;
        }

        @Override
        public int size() {
            return this.values.length;
        }

        @Override
        protected float doGet(int index) {
            return this.values[index].floatValue();
        }
    }

    static class ImmutableFloatListArrayPrimitive
    extends ImmutableFloatList {
        float[] values;

        public ImmutableFloatListArrayPrimitive(float[] values) {
            this.values = values;
        }

        @Override
        public int size() {
            return this.values.length;
        }

        @Override
        protected float doGet(int index) {
            return this.values[index];
        }
    }
}

