/*
 * Decompiled with CFR 0.152.
 */
package org.magicwerk.brownies.collections.primitive;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.magicwerk.brownies.collections.helper.primitive.DoubleBinarySearch;
import org.magicwerk.brownies.collections.helper.primitive.DoubleMergeSort;
import org.magicwerk.brownies.collections.primitive.DoubleGapList;
import org.magicwerk.brownies.collections.primitive.IDoubleList;

public class DoubleBigList
extends IDoubleList {
    private static final long serialVersionUID = 3715838828540564836L;
    private static final int DEFAULT_BLOCK_SIZE = 1000;
    private static final float MERGE_THRESHOLD = 0.35f;
    private static final float FILL_THRESHOLD = 0.95f;
    private static final boolean CHECK = false;
    private static final DoubleBigList EMPTY = DoubleBigList.create().unmodifiableList();
    private int blockSize;
    private int size;
    private DoubleBlockNode rootNode;
    private DoubleBlockNode currNode;
    private int currDoubleBlockStart;
    private int currDoubleBlockEnd;
    private int currModify;

    public static IDoubleList of(double[] values) {
        return new ImmutableDoubleListArrayPrimitive(values);
    }

    public static IDoubleList of(Double[] values) {
        return new ImmutableDoubleListArrayWrapper(values);
    }

    public static IDoubleList of(List<Double> values) {
        return new ImmutableDoubleListList(values);
    }

    public static DoubleBigList EMPTY() {
        return EMPTY;
    }

    protected DoubleBigList(boolean copy, DoubleBigList that) {
        if (copy) {
            this.blockSize = that.blockSize;
            this.currDoubleBlockStart = that.currDoubleBlockStart;
            this.currDoubleBlockEnd = that.currDoubleBlockEnd;
            this.currNode = that.currNode;
            this.rootNode = that.rootNode;
            this.size = that.size;
        }
    }

    public static DoubleBigList create() {
        return new DoubleBigList();
    }

    public static DoubleBigList create(Collection<Double> coll) {
        return new DoubleBigList(coll != null ? coll : Collections.emptyList());
    }

    public static DoubleBigList create(double ... elems) {
        DoubleBigList list = new DoubleBigList();
        if (elems != null) {
            for (double elem : elems) {
                list.add(elem);
            }
        }
        return list;
    }

    public DoubleBigList() {
        this(1000);
    }

    public DoubleBigList(int blockSize) {
        if (blockSize < 2) {
            throw new IndexOutOfBoundsException("Invalid blockSize: " + blockSize);
        }
        this.doInit(blockSize, -1);
    }

    public DoubleBigList(Collection<Double> coll) {
        if (coll instanceof DoubleBigList) {
            this.doAssign((DoubleBigList)((Object)coll));
            this.doClone((DoubleBigList)((Object)coll));
        } else {
            this.blockSize = 1000;
            this.addDoubleBlock(0, new DoubleBlock());
            for (Object obj : coll.toArray()) {
                this.add((Double)obj);
            }
            assert (this.size() == coll.size());
        }
    }

    public int blockSize() {
        return this.blockSize;
    }

    private DoubleBigList(int blockSize, int firstDoubleBlockSize) {
        this.doInit(blockSize, firstDoubleBlockSize);
    }

    private void doInit(int blockSize, int firstDoubleBlockSize) {
        this.blockSize = blockSize;
        DoubleBlock block = firstDoubleBlockSize <= 1 ? new DoubleBlock() : new DoubleBlock(firstDoubleBlockSize);
        this.addDoubleBlock(0, block);
    }

    @Override
    public DoubleBigList copy() {
        return (DoubleBigList)super.copy();
    }

    @Override
    public Object clone() {
        return super.clone();
    }

    @Override
    protected void doAssign(IDoubleList that) {
        DoubleBigList list = (DoubleBigList)that;
        this.blockSize = list.blockSize;
        this.currDoubleBlockEnd = list.currDoubleBlockEnd;
        this.currDoubleBlockStart = list.currDoubleBlockStart;
        this.currNode = list.currNode;
        this.rootNode = list.rootNode;
        this.size = list.size;
    }

    @Override
    protected void doClone(IDoubleList that) {
        DoubleBigList bigList = (DoubleBigList)that;
        bigList.releaseDoubleBlock();
        this.rootNode = this.copy(bigList.rootNode);
        this.currNode = null;
        this.currModify = 0;
    }

    private DoubleBlockNode copy(DoubleBlockNode node) {
        DoubleBlockNode newNode = node.min();
        int index = newNode.block.size();
        DoubleBlockNode newRoot = new DoubleBlockNode(null, index, newNode.block.ref(), null, null);
        while ((newNode = newNode.next()) != null) {
            newRoot = newRoot.insert(index += newNode.block.size(), newNode.block.ref());
            newRoot.parent = null;
        }
        return newRoot;
    }

    @Override
    public double getDefaultElem() {
        return 0.0;
    }

    protected void finalize() {
        DoubleBlockNode node = this.rootNode.min();
        while (node != null) {
            node.block.unref();
            node = node.next();
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public int capacity() {
        return -1;
    }

    @Override
    protected double doGet(int index) {
        int pos = this.getDoubleBlockIndex(index, false, 0);
        return this.currNode.block.doGet(pos);
    }

    @Override
    protected double doSet(int index, double elem) {
        int pos = this.getDoubleBlockIndex(index, true, 0);
        double oldElem = this.currNode.block.doGet(pos);
        this.currNode.block.doSet(pos, elem);
        return oldElem;
    }

    @Override
    protected double doReSet(int index, double elem) {
        int pos = this.getDoubleBlockIndex(index, true, 0);
        double oldElem = this.currNode.block.doGet(pos);
        this.currNode.block.doSet(pos, elem);
        return oldElem;
    }

    private void releaseDoubleBlock() {
        if (this.currModify != 0) {
            int modify = this.currModify;
            this.currModify = 0;
            this.modify(this.currNode, modify);
        }
        this.currNode = null;
    }

    private int getDoubleBlockIndex(int index, boolean write, int modify) {
        if (this.currNode != null) {
            if (index >= this.currDoubleBlockStart && (index < this.currDoubleBlockEnd || index == this.currDoubleBlockEnd && this.size == index)) {
                if (write && this.currNode.block.isShared()) {
                    this.currNode.block.unref();
                    this.currNode.setDoubleBlock(new DoubleBlock(this.currNode.block));
                }
                this.currModify += modify;
                return index - this.currDoubleBlockStart;
            }
            this.releaseDoubleBlock();
        }
        if (index == this.size) {
            if (this.currNode == null || this.currDoubleBlockEnd != this.size) {
                this.currNode = this.rootNode.max();
                this.currDoubleBlockEnd = this.size;
                this.currDoubleBlockStart = this.size - this.currNode.block.size();
            }
            if (modify != 0) {
                this.currNode.relPos += modify;
                DoubleBlockNode leftNode = this.currNode.getLeftSubTree();
                if (leftNode != null) {
                    leftNode.relPos -= modify;
                }
            }
        } else if (index == 0) {
            if (this.currNode == null || this.currDoubleBlockStart != 0) {
                this.currNode = this.rootNode.min();
                this.currDoubleBlockEnd = this.currNode.block.size();
                this.currDoubleBlockStart = 0;
            }
            if (modify != 0) {
                this.rootNode.relPos += modify;
            }
        }
        if (this.currNode == null) {
            this.doGetDoubleBlock(index, modify);
        }
        assert (index >= this.currDoubleBlockStart && index <= this.currDoubleBlockEnd);
        if (write && this.currNode.block.isShared()) {
            this.currNode.block.unref();
            this.currNode.setDoubleBlock(new DoubleBlock(this.currNode.block));
        }
        return index - this.currDoubleBlockStart;
    }

    private boolean isOnlyRootDoubleBlock() {
        return this.rootNode.left == null && this.rootNode.right == null;
    }

    private void doGetDoubleBlock(int index, int modify) {
        this.currNode = this.rootNode;
        this.currDoubleBlockEnd = this.rootNode.relPos;
        if (this.currNode.relPos == 0) {
            if (modify != 0) {
                this.currNode.relPos += modify;
            }
        } else {
            boolean wasLeft = false;
            while (true) {
                DoubleBlockNode nextNode;
                assert (index >= 0);
                int leftIndex = this.currDoubleBlockEnd - this.currNode.block.size();
                assert (leftIndex >= 0);
                if (index >= leftIndex && index < this.currDoubleBlockEnd) {
                    if (modify == 0) break;
                    DoubleBlockNode leftNode = this.currNode.getLeftSubTree();
                    if (this.currNode.relPos > 0) {
                        this.currNode.relPos += modify;
                        if (leftNode == null) break;
                        leftNode.relPos -= modify;
                        break;
                    }
                    if (leftNode == null) break;
                    leftNode.relPos -= modify;
                    break;
                }
                if (index < this.currDoubleBlockEnd) {
                    nextNode = this.currNode.getLeftSubTree();
                    if (!(modify == 0 || nextNode != null && wasLeft)) {
                        this.currNode.relPos = this.currNode.relPos > 0 ? (this.currNode.relPos += modify) : (this.currNode.relPos -= modify);
                        wasLeft = true;
                    }
                    if (nextNode == null) {
                        break;
                    }
                } else {
                    nextNode = this.currNode.getRightSubTree();
                    if (modify != 0 && (nextNode == null || wasLeft)) {
                        if (this.currNode.relPos > 0) {
                            this.currNode.relPos += modify;
                            DoubleBlockNode left = this.currNode.getLeftSubTree();
                            if (left != null) {
                                left.relPos -= modify;
                            }
                        } else {
                            this.currNode.relPos -= modify;
                        }
                        wasLeft = false;
                    }
                    if (nextNode == null) break;
                }
                this.currDoubleBlockEnd += nextNode.relPos;
                this.currNode = nextNode;
            }
        }
        this.currDoubleBlockStart = this.currDoubleBlockEnd - this.currNode.block.size();
    }

    private void addDoubleBlock(int index, DoubleBlock obj) {
        if (this.rootNode == null) {
            this.rootNode = new DoubleBlockNode(null, index, obj, null, null);
        } else {
            this.rootNode = this.rootNode.insert(index, obj);
            this.rootNode.parent = null;
        }
    }

    @Override
    protected boolean doAdd(int index, double element) {
        int maxSize;
        if (index == -1) {
            index = this.size;
        }
        int pos = this.getDoubleBlockIndex(index, true, 1);
        int n = maxSize = index == this.size || index == 0 ? (int)((float)this.blockSize * 0.95f) : this.blockSize;
        if (this.currNode.block.size() < maxSize || this.currNode.block.size() == 1 && this.currNode.block.size() < this.blockSize) {
            this.currNode.block.doAdd(pos, element);
            ++this.currDoubleBlockEnd;
        } else {
            DoubleBlock newDoubleBlock = new DoubleBlock(this.blockSize);
            if (index == this.size) {
                DoubleBlockNode lastNode;
                newDoubleBlock.doAdd(0, element);
                this.modify(this.currNode, -1);
                this.addDoubleBlock(this.size + 1, newDoubleBlock);
                this.currNode = lastNode = this.currNode.next();
                this.currDoubleBlockStart = this.currDoubleBlockEnd++;
            } else if (index == 0) {
                DoubleBlockNode firstNode;
                newDoubleBlock.doAdd(0, element);
                this.modify(this.currNode, -1);
                this.addDoubleBlock(1, newDoubleBlock);
                this.currNode = firstNode = this.currNode.previous();
                this.currDoubleBlockStart = 0;
                this.currDoubleBlockEnd = 1;
            } else {
                int nextDoubleBlockLen = this.blockSize / 2;
                int blockLen = this.blockSize - nextDoubleBlockLen;
                DoubleGapList.transferRemove(this.currNode.block, blockLen, nextDoubleBlockLen, newDoubleBlock, 0, 0);
                this.modify(this.currNode, -nextDoubleBlockLen - 1);
                this.addDoubleBlock(this.currDoubleBlockEnd - nextDoubleBlockLen, newDoubleBlock);
                if (pos < blockLen) {
                    this.currNode.block.doAdd(pos, element);
                    this.currDoubleBlockEnd = this.currDoubleBlockStart + blockLen + 1;
                    this.modify(this.currNode, 1);
                } else {
                    this.currNode = this.currNode.next();
                    this.modify(this.currNode, 1);
                    this.currNode.block.doAdd(pos - blockLen, element);
                    this.currDoubleBlockStart += blockLen;
                    ++this.currDoubleBlockEnd;
                }
            }
        }
        ++this.size;
        return true;
    }

    private void modify(DoubleBlockNode node, int modify) {
        if (node == this.currNode) {
            modify += this.currModify;
            this.currModify = 0;
        } else {
            this.releaseDoubleBlock();
        }
        if (modify == 0) {
            return;
        }
        if (node.relPos < 0) {
            DoubleBlockNode p;
            DoubleBlockNode leftNode = node.getLeftSubTree();
            if (leftNode != null) {
                leftNode.relPos -= modify;
            }
            DoubleBlockNode pp = node.parent;
            assert (pp.getLeftSubTree() == node);
            boolean parentRight = true;
            while ((p = pp.parent) != null) {
                boolean pRight;
                boolean bl = pRight = p.getLeftSubTree() == pp;
                if (parentRight != pRight) {
                    pp.relPos = pp.relPos > 0 ? (pp.relPos += modify) : (pp.relPos -= modify);
                }
                pp = p;
                parentRight = pRight;
            }
            if (parentRight) {
                this.rootNode.relPos += modify;
            }
        } else {
            DoubleBlockNode parent;
            node.relPos += modify;
            DoubleBlockNode leftNode = node.getLeftSubTree();
            if (leftNode != null) {
                leftNode.relPos -= modify;
            }
            if ((parent = node.parent) != null) {
                DoubleBlockNode p;
                assert (parent.getRightSubTree() == node);
                boolean parentLeft = true;
                while ((p = parent.parent) != null) {
                    boolean pLeft;
                    boolean bl = pLeft = p.getRightSubTree() == parent;
                    if (parentLeft != pLeft) {
                        parent.relPos = parent.relPos > 0 ? (parent.relPos += modify) : (parent.relPos -= modify);
                    }
                    parent = p;
                    parentLeft = pLeft;
                }
                if (!parentLeft) {
                    this.rootNode.relPos += modify;
                }
            }
        }
    }

    private DoubleBlockNode doRemove(DoubleBlockNode node) {
        DoubleBlockNode newNode;
        DoubleBlockNode p = node.parent;
        DoubleBlockNode n = newNode = node.removeSelf();
        while (p != null) {
            assert (p.left == node || p.right == node);
            if (p.left == node) {
                p.left = newNode;
            } else {
                p.right = newNode;
            }
            node = p;
            node.recalcHeight();
            newNode = node.balance();
            p = newNode.parent;
        }
        this.rootNode = newNode;
        return n;
    }

    @Override
    protected boolean doAddAll(int index, IDoubleList list) {
        if (list.size() == 0) {
            return false;
        }
        if (index == -1) {
            index = this.size;
        }
        int oldSize = this.size;
        if (list.size() == 1) {
            return this.doAdd(index, list.get(0));
        }
        int addPos = this.getDoubleBlockIndex(index, true, 0);
        DoubleBlock addDoubleBlock = this.currNode.block;
        int space = this.blockSize - addDoubleBlock.size();
        int addLen = list.size();
        if (addLen <= space) {
            this.currNode.block.addAll(addPos, list);
            this.modify(this.currNode, addLen);
            this.size += addLen;
            this.currDoubleBlockEnd += addLen;
        } else if (index == this.size) {
            int add;
            for (int i = 0; i < space; ++i) {
                this.currNode.block.add(addPos + i, list.get(i));
            }
            this.modify(this.currNode, space);
            int done = space;
            for (int todo = addLen - space; todo > 0; todo -= add) {
                DoubleBlock nextDoubleBlock = new DoubleBlock(this.blockSize);
                add = Math.min(todo, this.blockSize);
                for (int i = 0; i < add; ++i) {
                    nextDoubleBlock.add(i, list.get(done + i));
                }
                this.addDoubleBlock(this.size + (done += add), nextDoubleBlock);
                this.currNode = this.currNode.next();
            }
            this.size += addLen;
            this.currDoubleBlockEnd = this.size;
            this.currDoubleBlockStart = this.currDoubleBlockEnd - this.currNode.block.size();
        } else if (index == 0) {
            int add;
            assert (addPos == 0);
            for (int i = 0; i < space; ++i) {
                this.currNode.block.add(addPos + i, list.get(addLen - space + i));
            }
            this.modify(this.currNode, space);
            int done = space;
            for (int todo = addLen - space; todo > 0; todo -= add) {
                DoubleBlock nextDoubleBlock = new DoubleBlock(this.blockSize);
                add = Math.min(todo, this.blockSize);
                for (int i = 0; i < add; ++i) {
                    nextDoubleBlock.add(i, list.get(addLen - done - add + i));
                }
                done += add;
                this.addDoubleBlock(0, nextDoubleBlock);
                this.currNode = this.currNode.previous();
            }
            this.size += addLen;
            this.currDoubleBlockStart = 0;
            this.currDoubleBlockEnd = this.currNode.block.size();
        } else {
            DoubleGapList sublist;
            int add;
            DoubleGapList list2 = DoubleGapList.create();
            list2.addAll(list);
            int remove = this.currNode.block.size() - addPos;
            if (remove > 0) {
                list2.addAll(this.currNode.block.getAll(addPos, remove));
                this.currNode.block.remove(addPos, remove);
                this.modify(this.currNode, -remove);
                this.size -= remove;
                this.currDoubleBlockEnd -= remove;
            }
            int numElems = this.currNode.block.size() + list2.size();
            int numDoubleBlocks = (numElems - 1) / this.blockSize + 1;
            assert (numDoubleBlocks > 1);
            int has = this.currNode.block.size();
            int should = numElems / numDoubleBlocks;
            int listPos = 0;
            if (has < should) {
                add = should - has;
                sublist = list2.getAll(0, add);
                listPos += add;
                this.currNode.block.addAll(addPos, sublist);
                this.modify(this.currNode, add);
                assert (this.currNode.block.size() == should);
                numElems -= should;
                --numDoubleBlocks;
                this.size += add;
                this.currDoubleBlockEnd += add;
            } else if (has > should) {
                DoubleBlock nextDoubleBlock = new DoubleBlock(this.blockSize);
                int move = has - should;
                nextDoubleBlock.addAll(this.currNode.block.getAll(this.currNode.block.size() - move, move));
                this.currNode.block.remove(this.currNode.block.size() - move, move);
                this.modify(this.currNode, -move);
                assert (this.currNode.block.size() == should);
                numElems -= should;
                this.currDoubleBlockEnd -= move;
                should = numElems / --numDoubleBlocks;
                int add2 = should - move;
                assert (add2 >= 0);
                DoubleGapList sublist2 = list2.getAll(0, add2);
                nextDoubleBlock.addAll(move, sublist2);
                listPos += add2;
                assert (nextDoubleBlock.size() == should);
                numElems -= should;
                --numDoubleBlocks;
                this.size += add2;
                this.addDoubleBlock(this.currDoubleBlockEnd, nextDoubleBlock);
                this.currNode = this.currNode.next();
                assert (this.currNode.block == nextDoubleBlock);
                assert (this.currNode.block.size() == add2 + move);
                this.currDoubleBlockStart = this.currDoubleBlockEnd;
                this.currDoubleBlockEnd += add2 + move;
            } else {
                numElems -= should;
                --numDoubleBlocks;
            }
            while (numDoubleBlocks > 0) {
                add = numElems / numDoubleBlocks;
                assert (add > 0);
                sublist = list2.getAll(listPos, add);
                listPos += add;
                DoubleBlock nextDoubleBlock = new DoubleBlock();
                nextDoubleBlock.addAll(sublist);
                assert (nextDoubleBlock.size() == add);
                numElems -= add;
                this.addDoubleBlock(this.currDoubleBlockEnd, nextDoubleBlock);
                this.currNode = this.currNode.next();
                assert (this.currNode.block == nextDoubleBlock);
                assert (this.currNode.block.size() == add);
                this.currDoubleBlockStart = this.currDoubleBlockEnd;
                this.currDoubleBlockEnd += add;
                this.size += add;
                --numDoubleBlocks;
            }
        }
        assert (oldSize + addLen == this.size);
        return true;
    }

    @Override
    protected void doClear() {
        this.finalize();
        this.rootNode = null;
        this.currDoubleBlockStart = 0;
        this.currDoubleBlockEnd = 0;
        this.currModify = 0;
        this.currNode = null;
        this.size = 0;
        this.doInit(this.blockSize, 0);
    }

    @Override
    protected void doRemoveAll(int index, int len) {
        if (len == 0) {
            return;
        }
        if (index == 0 && len == this.size) {
            this.doClear();
            return;
        }
        if (len == 1) {
            this.doRemove(index);
            return;
        }
        int startPos = this.getDoubleBlockIndex(index, true, 0);
        DoubleBlockNode startNode = this.currNode;
        int endPos = this.getDoubleBlockIndex(index + len - 1, true, 0);
        DoubleBlockNode endNode = this.currNode;
        if (startNode == endNode) {
            this.getDoubleBlockIndex(index, true, -len);
            this.currNode.block.remove(startPos, len);
            if (this.currNode.block.isEmpty()) {
                DoubleBlockNode oldCurrNode = this.currNode;
                this.releaseDoubleBlock();
                DoubleBlockNode node = this.doRemove(oldCurrNode);
                this.merge(node);
            } else {
                this.currDoubleBlockEnd -= len;
                this.merge(this.currNode);
            }
            this.size -= len;
        } else {
            int startLen = startNode.block.size() - startPos;
            this.getDoubleBlockIndex(index, true, -startLen);
            startNode.block.remove(startPos, startLen);
            assert (startNode == this.currNode);
            if (this.currNode.block.isEmpty()) {
                this.releaseDoubleBlock();
                this.doRemove(startNode);
                startNode = null;
            }
            len -= startLen;
            this.size -= startLen;
            while (len > 0) {
                this.currNode = null;
                this.getDoubleBlockIndex(index, true, 0);
                int s = this.currNode.block.size();
                if (s <= len) {
                    this.modify(this.currNode, -s);
                    DoubleBlockNode oldCurrNode = this.currNode;
                    this.releaseDoubleBlock();
                    this.doRemove(oldCurrNode);
                    if (oldCurrNode == endNode) {
                        endNode = null;
                    }
                    len -= s;
                    this.size -= s;
                    continue;
                }
                this.modify(this.currNode, -len);
                this.currNode.block.remove(0, len);
                this.size -= len;
                break;
            }
            this.releaseDoubleBlock();
            this.getDoubleBlockIndex(index, false, 0);
            this.merge(this.currNode);
        }
    }

    private void merge(DoubleBlockNode node) {
        if (node == null) {
            return;
        }
        int minDoubleBlockSize = Math.max((int)((float)this.blockSize * 0.35f), 1);
        if (node.block.size() >= minDoubleBlockSize) {
            return;
        }
        DoubleBlockNode oldCurrNode = node;
        DoubleBlockNode leftNode = node.previous();
        if (leftNode != null && leftNode.block.size() < minDoubleBlockSize) {
            int len = node.block.size();
            int dstSize = leftNode.getDoubleBlock().size();
            for (int i = 0; i < len; ++i) {
                leftNode.block.add(0.0);
            }
            DoubleGapList.transferCopy(node.block, 0, len, leftNode.block, dstSize, len);
            assert (leftNode.block.size() <= this.blockSize);
            this.modify(leftNode, len);
            this.modify(oldCurrNode, -len);
            this.releaseDoubleBlock();
            this.doRemove(oldCurrNode);
        } else {
            DoubleBlockNode rightNode = node.next();
            if (rightNode != null && rightNode.block.size() < minDoubleBlockSize) {
                int len = node.block.size();
                for (int i = 0; i < len; ++i) {
                    rightNode.block.add(0, 0.0);
                }
                DoubleGapList.transferCopy(node.block, 0, len, rightNode.block, 0, len);
                assert (rightNode.block.size() <= this.blockSize);
                this.modify(rightNode, len);
                this.modify(oldCurrNode, -len);
                this.releaseDoubleBlock();
                this.doRemove(oldCurrNode);
            }
        }
    }

    @Override
    protected double doRemove(int index) {
        int pos = this.getDoubleBlockIndex(index, true, -1);
        double oldElem = this.currNode.block.doRemove(pos);
        --this.currDoubleBlockEnd;
        int minDoubleBlockSize = Math.max(this.blockSize / 3, 1);
        if (this.currNode.block.size() < minDoubleBlockSize) {
            if (this.currNode.block.size() == 0) {
                if (!this.isOnlyRootDoubleBlock()) {
                    DoubleBlockNode oldCurrNode = this.currNode;
                    this.releaseDoubleBlock();
                    this.doRemove(oldCurrNode);
                }
            } else if (index != 0 && index != this.size - 1) {
                this.merge(this.currNode);
            }
        }
        --this.size;
        return oldElem;
    }

    @Override
    public DoubleBigList unmodifiableList() {
        return new ImmutableDoubleBigList(this);
    }

    @Override
    protected void doEnsureCapacity(int minCapacity) {
        if (this.isOnlyRootDoubleBlock()) {
            if (minCapacity > this.blockSize) {
                minCapacity = this.blockSize;
            }
            this.rootNode.block.doEnsureCapacity(minCapacity);
        }
    }

    @Override
    public void trimToSize() {
        this.doModify();
        if (this.isOnlyRootDoubleBlock()) {
            this.rootNode.block.trimToSize();
        } else {
            DoubleBigList newList = new DoubleBigList(this.blockSize);
            DoubleBlockNode node = this.rootNode.min();
            while (node != null) {
                newList.addAll(node.block);
                this.remove(0, node.block.size());
                node = node.next();
            }
            this.doAssign(newList);
        }
    }

    @Override
    protected IDoubleList doCreate(int capacity) {
        if (capacity <= this.blockSize) {
            return new DoubleBigList(this.blockSize);
        }
        return new DoubleBigList(this.blockSize, capacity);
    }

    @Override
    public void sort(int index, int len) {
        this.checkRange(index, len);
        if (this.isOnlyRootDoubleBlock()) {
            this.rootNode.block.sort(index, len);
        } else {
            DoubleMergeSort.sort(this, index, index + len);
        }
    }

    @Override
    public int binarySearch(int index, int len, double key) {
        this.checkRange(index, len);
        if (this.isOnlyRootDoubleBlock()) {
            return this.rootNode.block.binarySearch(key);
        }
        return DoubleBinarySearch.binarySearch(this, key, 0, this.size());
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.writeInt(this.blockSize);
        int size = this.size();
        oos.writeInt(size);
        for (int i = 0; i < size; ++i) {
            oos.writeDouble(this.doGet(i));
        }
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        int blockSize = ois.readInt();
        int size = ois.readInt();
        int firstDoubleBlockSize = size <= blockSize ? size : -1;
        this.doInit(blockSize, firstDoubleBlockSize);
        for (int i = 0; i < size; ++i) {
            this.add(ois.readDouble());
        }
    }

    private void checkNode(DoubleBlockNode node) {
        assert ((node.block.size() > 0 || node == this.rootNode) && node.block.size() <= this.blockSize);
        DoubleBlockNode child = node.getLeftSubTree();
        assert (child == null || child.parent == node);
        child = node.getRightSubTree();
        assert (child == null || child.parent == node);
    }

    private void checkHeight(DoubleBlockNode node) {
        DoubleBlockNode left = node.getLeftSubTree();
        DoubleBlockNode right = node.getRightSubTree();
        if (left == null) {
            if (right == null) {
                assert (node.height == 0);
            } else {
                assert (right.height == node.height - 1);
                this.checkHeight(right);
            }
        } else {
            if (right == null) {
                assert (left.height == node.height - 1);
            } else {
                assert (left.height == node.height - 1 || left.height == node.height - 2);
                assert (right.height == node.height - 1 || right.height == node.height - 2);
                assert (right.height == node.height - 1 || left.height == node.height - 1);
            }
            this.checkHeight(left);
        }
    }

    private void check() {
        if (this.currNode != null) {
            assert (this.currDoubleBlockStart >= 0 && this.currDoubleBlockEnd <= this.size && this.currDoubleBlockStart <= this.currDoubleBlockEnd);
            assert (this.currDoubleBlockStart + this.currNode.block.size() == this.currDoubleBlockEnd);
        }
        if (this.rootNode == null) {
            assert (this.size == 0);
            return;
        }
        this.checkHeight(this.rootNode);
        DoubleBlockNode oldCurrNode = this.currNode;
        int oldCurrModify = this.currModify;
        if (this.currModify != 0) {
            this.currNode = null;
            this.currModify = 0;
            this.modify(oldCurrNode, oldCurrModify);
        }
        DoubleBlockNode node = this.rootNode;
        this.checkNode(node);
        int index = node.relPos;
        while (node.left != null) {
            node = node.left;
            this.checkNode(node);
            assert (node.relPos < 0);
            index += node.relPos;
        }
        DoubleBlock block = node.getDoubleBlock();
        assert (block.size() == index);
        int lastIndex = index;
        while (lastIndex < this.size()) {
            node = this.rootNode;
            index = node.relPos;
            int searchIndex = lastIndex + 1;
            while (true) {
                this.checkNode(node);
                block = node.getDoubleBlock();
                assert (block.size() > 0);
                if (searchIndex > index - block.size() && searchIndex <= index) break;
                if (searchIndex < index) {
                    if (node.left == null || node.left.height >= node.height) break;
                    node = node.left;
                } else {
                    if (node.right == null || node.right.height >= node.height) break;
                    node = node.right;
                }
                index += node.relPos;
            }
            block = node.getDoubleBlock();
            assert (block.size() == index - lastIndex);
            lastIndex = index;
        }
        assert (index == this.size());
        if (oldCurrModify != 0) {
            this.modify(oldCurrNode, -oldCurrModify);
        }
        this.currNode = oldCurrNode;
        this.currModify = oldCurrModify;
    }

    protected static class ImmutableDoubleBigList
    extends DoubleBigList {
        private static final long serialVersionUID = -1352274047348922584L;

        protected ImmutableDoubleBigList(DoubleBigList that) {
            super(true, that);
        }

        @Override
        protected boolean doAdd(int index, double elem) {
            this.error();
            return false;
        }

        @Override
        protected double doSet(int index, double elem) {
            this.error();
            return 0.0;
        }

        @Override
        protected double doReSet(int index, double elem) {
            this.error();
            return 0.0;
        }

        @Override
        protected double doRemove(int index) {
            this.error();
            return 0.0;
        }

        @Override
        protected void doRemoveAll(int index, int len) {
            this.error();
        }

        @Override
        protected void doClear() {
            this.error();
        }

        @Override
        protected void doModify() {
            this.error();
        }

        private void error() {
            throw new UnsupportedOperationException("list is immutable");
        }
    }

    static class DoubleBlockNode {
        DoubleBlockNode parent;
        DoubleBlockNode left;
        boolean leftIsPrevious;
        DoubleBlockNode right;
        boolean rightIsNext;
        int height;
        int relPos;
        DoubleBlock block;

        private DoubleBlockNode(DoubleBlockNode parent, int relPos, DoubleBlock block, DoubleBlockNode rightFollower, DoubleBlockNode leftFollower) {
            this.parent = parent;
            this.relPos = relPos;
            this.block = block;
            this.rightIsNext = true;
            this.leftIsPrevious = true;
            this.right = rightFollower;
            this.left = leftFollower;
        }

        private DoubleBlock getDoubleBlock() {
            return this.block;
        }

        private void setDoubleBlock(DoubleBlock block) {
            this.block = block;
        }

        private DoubleBlockNode next() {
            if (this.rightIsNext || this.right == null) {
                return this.right;
            }
            return this.right.min();
        }

        private DoubleBlockNode previous() {
            if (this.leftIsPrevious || this.left == null) {
                return this.left;
            }
            return this.left.max();
        }

        private DoubleBlockNode insert(int index, DoubleBlock obj) {
            assert (this.relPos != 0);
            int relIndex = index - this.relPos;
            if (relIndex < 0) {
                return this.insertOnLeft(relIndex, obj);
            }
            return this.insertOnRight(relIndex, obj);
        }

        private DoubleBlockNode insertOnLeft(int relIndex, DoubleBlock obj) {
            if (this.getLeftSubTree() == null) {
                int pos = this.relPos >= 0 ? -this.relPos : -this.block.size();
                this.setLeft(new DoubleBlockNode(this, pos, obj, this, this.left), null);
            } else {
                this.setLeft(this.left.insert(relIndex, obj), null);
            }
            if (this.relPos >= 0) {
                this.relPos += obj.size();
            }
            DoubleBlockNode ret = this.balance();
            this.recalcHeight();
            return ret;
        }

        private DoubleBlockNode insertOnRight(int relIndex, DoubleBlock obj) {
            if (this.getRightSubTree() == null) {
                this.setRight(new DoubleBlockNode(this, obj.size(), obj, this.right, this), null);
            } else {
                this.setRight(this.right.insert(relIndex, obj), null);
            }
            if (this.relPos < 0) {
                this.relPos -= obj.size();
            }
            DoubleBlockNode ret = this.balance();
            this.recalcHeight();
            return ret;
        }

        private DoubleBlockNode getLeftSubTree() {
            return this.leftIsPrevious ? null : this.left;
        }

        private DoubleBlockNode getRightSubTree() {
            return this.rightIsNext ? null : this.right;
        }

        private DoubleBlockNode max() {
            return this.getRightSubTree() == null ? this : this.right.max();
        }

        private DoubleBlockNode min() {
            return this.getLeftSubTree() == null ? this : this.left.min();
        }

        private DoubleBlockNode removeMax() {
            if (this.getRightSubTree() == null) {
                return this.removeSelf();
            }
            this.setRight(this.right.removeMax(), this.right.right);
            this.recalcHeight();
            return this.balance();
        }

        private DoubleBlockNode removeMin(int size) {
            if (this.getLeftSubTree() == null) {
                return this.removeSelf();
            }
            this.setLeft(this.left.removeMin(size), this.left.left);
            if (this.relPos > 0) {
                this.relPos -= size;
            }
            this.recalcHeight();
            return this.balance();
        }

        private DoubleBlockNode removeSelf() {
            DoubleBlockNode p = this.parent;
            DoubleBlockNode n = this.doRemoveSelf();
            if (n != null) {
                assert (p != n);
                n.parent = p;
            }
            return n;
        }

        private DoubleBlockNode doRemoveSelf() {
            if (this.getRightSubTree() == null && this.getLeftSubTree() == null) {
                return null;
            }
            if (this.getRightSubTree() == null) {
                this.left.relPos = this.relPos > 0 ? this.left.relPos + (this.relPos + (this.relPos > 0 ? 0 : 1)) : (this.left.relPos += this.relPos);
                this.left.max().setRight(null, this.right);
                return this.left;
            }
            if (this.getLeftSubTree() == null) {
                if (this.relPos < 0) {
                    this.right.relPos = this.right.relPos + (this.relPos - (this.relPos < 0 ? 0 : 1));
                }
                this.right.min().setLeft(null, this.left);
                return this.right;
            }
            if (this.heightRightMinusLeft() > 0) {
                DoubleBlockNode rightMin = this.right.min();
                this.block = rightMin.block;
                int bs = this.block.size();
                if (this.leftIsPrevious) {
                    this.left = rightMin.left;
                }
                this.right = this.right.removeMin(bs);
                this.relPos += bs;
                this.left.relPos -= bs;
            } else {
                DoubleBlockNode leftMax = this.left.max();
                this.block = leftMax.block;
                if (this.rightIsNext) {
                    this.right = leftMax.right;
                }
                DoubleBlockNode leftPrevious = this.left.left;
                this.left = this.left.removeMax();
                if (this.left == null) {
                    this.left = leftPrevious;
                    this.leftIsPrevious = true;
                } else if (this.left.relPos == 0) {
                    this.left.relPos = -1;
                }
            }
            this.recalcHeight();
            return this;
        }

        private DoubleBlockNode balance() {
            switch (this.heightRightMinusLeft()) {
                case -1: 
                case 0: 
                case 1: {
                    return this;
                }
                case -2: {
                    if (this.left.heightRightMinusLeft() > 0) {
                        this.setLeft(this.left.rotateLeft(), null);
                    }
                    return this.rotateRight();
                }
                case 2: {
                    if (this.right.heightRightMinusLeft() < 0) {
                        this.setRight(this.right.rotateRight(), null);
                    }
                    return this.rotateLeft();
                }
            }
            throw new RuntimeException("tree inconsistent!");
        }

        private int getOffset(DoubleBlockNode node) {
            if (node == null) {
                return 0;
            }
            return node.relPos;
        }

        private int setOffset(DoubleBlockNode node, int newOffest) {
            if (node == null) {
                return 0;
            }
            int oldOffset = this.getOffset(node);
            node.relPos = newOffest;
            return oldOffset;
        }

        private void recalcHeight() {
            this.height = Math.max(this.getLeftSubTree() == null ? -1 : this.getLeftSubTree().height, this.getRightSubTree() == null ? -1 : this.getRightSubTree().height) + 1;
        }

        private int getHeight(DoubleBlockNode node) {
            return node == null ? -1 : node.height;
        }

        private int heightRightMinusLeft() {
            return this.getHeight(this.getRightSubTree()) - this.getHeight(this.getLeftSubTree());
        }

        private DoubleBlockNode rotateLeft() {
            assert (!this.rightIsNext);
            DoubleBlockNode newTop = this.right;
            DoubleBlockNode movedNode = this.getRightSubTree().getLeftSubTree();
            int newTopPosition = this.relPos + this.getOffset(newTop);
            int myNewPosition = -newTop.relPos;
            int movedPosition = this.getOffset(newTop) + this.getOffset(movedNode);
            DoubleBlockNode p = this.parent;
            this.setRight(movedNode, newTop);
            newTop.setLeft(this, null);
            newTop.parent = p;
            this.parent = newTop;
            this.setOffset(newTop, newTopPosition);
            this.setOffset(this, myNewPosition);
            this.setOffset(movedNode, movedPosition);
            assert (newTop.getLeftSubTree() == null || newTop.getLeftSubTree().relPos < 0);
            assert (newTop.getRightSubTree() == null || newTop.getRightSubTree().relPos > 0);
            return newTop;
        }

        private DoubleBlockNode rotateRight() {
            assert (!this.leftIsPrevious);
            DoubleBlockNode newTop = this.left;
            DoubleBlockNode movedNode = this.getLeftSubTree().getRightSubTree();
            int newTopPosition = this.relPos + this.getOffset(newTop);
            int myNewPosition = -newTop.relPos;
            int movedPosition = this.getOffset(newTop) + this.getOffset(movedNode);
            DoubleBlockNode p = this.parent;
            this.setLeft(movedNode, newTop);
            newTop.setRight(this, null);
            newTop.parent = p;
            this.parent = newTop;
            this.setOffset(newTop, newTopPosition);
            this.setOffset(this, myNewPosition);
            this.setOffset(movedNode, movedPosition);
            assert (newTop.getLeftSubTree() == null || newTop.getLeftSubTree().relPos < 0);
            assert (newTop.getRightSubTree() == null || newTop.getRightSubTree().relPos > 0);
            return newTop;
        }

        private void setLeft(DoubleBlockNode node, DoubleBlockNode previous) {
            assert (node != this && previous != this);
            boolean bl = this.leftIsPrevious = node == null;
            if (this.leftIsPrevious) {
                this.left = previous;
            } else {
                this.left = node;
                this.left.parent = this;
            }
            this.recalcHeight();
        }

        private void setRight(DoubleBlockNode node, DoubleBlockNode next) {
            assert (node != this && next != this);
            boolean bl = this.rightIsNext = node == null;
            if (this.rightIsNext) {
                this.right = next;
            } else {
                this.right = node;
                this.right.parent = this;
            }
            this.recalcHeight();
        }

        public String toString() {
            return "DoubleBlockNode(" + this.relPos + ',' + (this.getRightSubTree() != null) + ',' + this.block + ',' + (this.getRightSubTree() != null) + ", height " + this.height + " )";
        }
    }

    static class DoubleBlock
    extends DoubleGapList {
        private AtomicInteger refCount = new AtomicInteger(1);

        public DoubleBlock() {
        }

        public DoubleBlock(int capacity) {
            super(capacity);
        }

        public DoubleBlock(DoubleBlock that) {
            super(that.capacity());
            this.addAll(that);
        }

        public boolean isShared() {
            return this.refCount.get() > 1;
        }

        public DoubleBlock ref() {
            this.refCount.incrementAndGet();
            return this;
        }

        public void unref() {
            this.refCount.decrementAndGet();
        }
    }

    protected static abstract class ImmutableDoubleList
    extends IDoubleList {
        protected ImmutableDoubleList() {
        }

        @Override
        public int capacity() {
            return this.size();
        }

        @Override
        public int binarySearch(int index, int len, double key) {
            return DoubleBinarySearch.binarySearch(this, key, index, index + len);
        }

        @Override
        public IDoubleList unmodifiableList() {
            return this;
        }

        @Override
        protected double getDefaultElem() {
            return 0.0;
        }

        private void error() {
            throw new UnsupportedOperationException("list is immutable");
        }

        @Override
        protected void doRemoveAll(int index, int len) {
            this.error();
        }

        @Override
        protected void doClear() {
            this.error();
        }

        @Override
        protected void doModify() {
            this.error();
        }

        @Override
        protected void doClone(IDoubleList that) {
            this.error();
        }

        @Override
        protected double doSet(int index, double elem) {
            this.error();
            return 0.0;
        }

        @Override
        protected double doReSet(int index, double elem) {
            this.error();
            return 0.0;
        }

        @Override
        protected boolean doAdd(int index, double elem) {
            this.error();
            return false;
        }

        @Override
        protected void doEnsureCapacity(int minCapacity) {
            this.error();
        }

        @Override
        public void trimToSize() {
            this.error();
        }

        @Override
        protected IDoubleList doCreate(int capacity) {
            this.error();
            return null;
        }

        @Override
        protected void doAssign(IDoubleList that) {
            this.error();
        }

        @Override
        protected double doRemove(int index) {
            this.error();
            return 0.0;
        }

        @Override
        public void sort(int index, int len) {
            this.error();
        }
    }

    static class ImmutableDoubleListList
    extends ImmutableDoubleList {
        List<Double> values;

        public ImmutableDoubleListList(List<Double> values) {
            this.values = values;
        }

        @Override
        public int size() {
            return this.values.size();
        }

        @Override
        protected double doGet(int index) {
            return this.values.get(index);
        }
    }

    static class ImmutableDoubleListArrayWrapper
    extends ImmutableDoubleList {
        Double[] values;

        public ImmutableDoubleListArrayWrapper(Double[] values) {
            this.values = values;
        }

        @Override
        public int size() {
            return this.values.length;
        }

        @Override
        protected double doGet(int index) {
            return this.values[index];
        }
    }

    static class ImmutableDoubleListArrayPrimitive
    extends ImmutableDoubleList {
        double[] values;

        public ImmutableDoubleListArrayPrimitive(double[] values) {
            this.values = values;
        }

        @Override
        public int size() {
            return this.values.length;
        }

        @Override
        protected double doGet(int index) {
            return this.values[index];
        }
    }
}

