/*
 * Decompiled with CFR 0.152.
 */
package org.magicwerk.brownies.collections.helper;

import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import org.magicwerk.brownies.collections.GapList;
import org.magicwerk.brownies.collections.IList;
import org.magicwerk.brownies.collections.primitive.BooleanObjGapList;
import org.magicwerk.brownies.collections.primitive.ByteObjGapList;
import org.magicwerk.brownies.collections.primitive.CharObjGapList;
import org.magicwerk.brownies.collections.primitive.DoubleObjGapList;
import org.magicwerk.brownies.collections.primitive.FloatObjGapList;
import org.magicwerk.brownies.collections.primitive.IntObjGapList;
import org.magicwerk.brownies.collections.primitive.LongObjGapList;
import org.magicwerk.brownies.collections.primitive.ShortObjGapList;

public class GapLists {
    public static IList<?> createWrapperList(Class<?> type) {
        if (type == Integer.TYPE) {
            return new IntObjGapList();
        }
        if (type == Long.TYPE) {
            return new LongObjGapList();
        }
        if (type == Double.TYPE) {
            return new DoubleObjGapList();
        }
        if (type == Float.TYPE) {
            return new FloatObjGapList();
        }
        if (type == Boolean.TYPE) {
            return new BooleanObjGapList();
        }
        if (type == Byte.TYPE) {
            return new ByteObjGapList();
        }
        if (type == Character.TYPE) {
            return new CharObjGapList();
        }
        if (type == Short.TYPE) {
            return new ShortObjGapList();
        }
        throw new IllegalArgumentException("Primitive type expected: " + type);
    }

    public static IList<?> createWrapperList(Class<?> type, int capacity) {
        if (type == Integer.TYPE) {
            return new IntObjGapList(capacity);
        }
        if (type == Long.TYPE) {
            return new LongObjGapList(capacity);
        }
        if (type == Double.TYPE) {
            return new DoubleObjGapList(capacity);
        }
        if (type == Float.TYPE) {
            return new FloatObjGapList(capacity);
        }
        if (type == Boolean.TYPE) {
            return new BooleanObjGapList(capacity);
        }
        if (type == Byte.TYPE) {
            return new ByteObjGapList(capacity);
        }
        if (type == Character.TYPE) {
            return new CharObjGapList(capacity);
        }
        if (type == Short.TYPE) {
            return new ShortObjGapList(capacity);
        }
        throw new IllegalArgumentException("Primitive type expected: " + type);
    }

    public static <T> Collector<T, ?, IList<T>> toGapList() {
        return new CollectorImpl(GapList::new, List::add, (left, right) -> {
            left.addAll(right);
            return left;
        }, CollectorImpl.CH_ID);
    }

    private static class CollectorImpl<T, A, R>
    implements Collector<T, A, R> {
        private final Supplier<A> supplier;
        private final BiConsumer<A, T> accumulator;
        private final BinaryOperator<A> combiner;
        private final Function<A, R> finisher;
        private final Set<Collector.Characteristics> characteristics;
        static final Set<Collector.Characteristics> CH_ID = Collections.unmodifiableSet(EnumSet.of(Collector.Characteristics.IDENTITY_FINISH));

        CollectorImpl(Supplier<A> supplier, BiConsumer<A, T> accumulator, BinaryOperator<A> combiner, Function<A, R> finisher, Set<Collector.Characteristics> characteristics) {
            this.supplier = supplier;
            this.accumulator = accumulator;
            this.combiner = combiner;
            this.finisher = finisher;
            this.characteristics = characteristics;
        }

        CollectorImpl(Supplier<A> supplier, BiConsumer<A, T> accumulator, BinaryOperator<A> combiner, Set<Collector.Characteristics> characteristics) {
            this(supplier, accumulator, combiner, CollectorImpl.castingIdentity(), characteristics);
        }

        @Override
        public BiConsumer<A, T> accumulator() {
            return this.accumulator;
        }

        @Override
        public Supplier<A> supplier() {
            return this.supplier;
        }

        @Override
        public BinaryOperator<A> combiner() {
            return this.combiner;
        }

        @Override
        public Function<A, R> finisher() {
            return this.finisher;
        }

        @Override
        public Set<Collector.Characteristics> characteristics() {
            return this.characteristics;
        }

        private static <I, R> Function<I, R> castingIdentity() {
            return i -> i;
        }
    }
}

