/*
 * Decompiled with CFR 0.152.
 */
package org.magicwerk.brownies.collections;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.magicwerk.brownies.collections.CollectionAsSet;
import org.magicwerk.brownies.collections.GapList;
import org.magicwerk.brownies.collections.ImmutableMapEntry;
import org.magicwerk.brownies.collections.KeyCollectionImpl;
import org.magicwerk.brownies.collections.KeyListImpl;

public class KeyCollectionAsMap<K, E>
implements Map<K, E>,
Serializable {
    KeyCollectionImpl<E> coll;
    KeyListImpl<E> list;
    int keyIndex;
    boolean immutable;

    public KeyCollectionAsMap(KeyCollectionImpl<E> coll, int keyIndex, boolean immutable) {
        if (coll == null) {
            throw new IllegalArgumentException("Collection may not be null");
        }
        coll.checkAsMap(keyIndex);
        this.coll = coll;
        this.keyIndex = keyIndex;
        this.immutable = immutable;
    }

    public KeyCollectionAsMap(KeyListImpl<E> list, int keyIndex, boolean immutable) {
        if (list == null) {
            throw new IllegalArgumentException("List may not be null");
        }
        list.keyColl.checkAsMap(keyIndex);
        this.list = list;
        this.keyIndex = keyIndex;
        this.immutable = immutable;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map m = (Map)o;
        if (m.size() != this.size()) {
            return false;
        }
        try {
            for (Map.Entry<K, E> e : this.entrySet()) {
                K key = e.getKey();
                E value = e.getValue();
                if (!(value == null ? m.get(key) != null || !m.containsKey(key) : !value.equals(m.get(key)))) continue;
                return false;
            }
        }
        catch (ClassCastException unused) {
            return false;
        }
        catch (NullPointerException unused) {
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        if (this.coll != null) {
            return this.coll.hashCode();
        }
        return this.list.hashCode();
    }

    public String toString() {
        if (this.coll != null) {
            return this.coll.toString();
        }
        return this.list.toString();
    }

    @Override
    public int size() {
        if (this.coll != null) {
            return this.coll.size();
        }
        return this.list.size();
    }

    @Override
    public boolean isEmpty() {
        if (this.coll != null) {
            return this.coll.isEmpty();
        }
        return this.list.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        if (this.coll != null) {
            return this.coll.containsKey(this.keyIndex, key);
        }
        return this.list.containsKey(this.keyIndex, key);
    }

    @Override
    public boolean containsValue(Object value) {
        if (this.coll != null) {
            return this.coll.contains(value);
        }
        return this.list.contains(value);
    }

    @Override
    public E get(Object key) {
        if (this.coll != null) {
            return this.coll.getByKey(this.keyIndex, key);
        }
        return this.list.getByKey(this.keyIndex, key);
    }

    @Override
    public Set<K> keySet() {
        if (this.coll != null) {
            return new CollectionAsSet(this.coll.getDistinctKeys(this.keyIndex), true);
        }
        return new CollectionAsSet(this.list.getDistinctKeys(this.keyIndex), true);
    }

    @Override
    public Set<Map.Entry<K, E>> entrySet() {
        if (this.coll != null) {
            Set<?> keys = this.coll.getDistinctKeys(this.keyIndex);
            GapList entries = new GapList(keys.size());
            for (Object key : keys) {
                E elem = this.coll.getByKey(this.keyIndex, key);
                entries.add(new ImmutableMapEntry(key, elem));
            }
            return new CollectionAsSet<Map.Entry<K, E>>(entries, true);
        }
        Set<?> keys = this.list.getDistinctKeys(this.keyIndex);
        GapList entries = new GapList(keys.size());
        for (Object key : keys) {
            E elem = this.list.getByKey(this.keyIndex, key);
            entries.add(new ImmutableMapEntry(key, elem));
        }
        return new CollectionAsSet<Map.Entry<K, E>>(entries, true);
    }

    @Override
    public Collection<E> values() {
        if (this.coll != null) {
            if (this.immutable) {
                return Collections.unmodifiableCollection(this.coll);
            }
            return this.coll;
        }
        if (this.immutable) {
            return Collections.unmodifiableCollection(this.list);
        }
        return this.list;
    }

    void checkMutable() {
        if (this.immutable) {
            throw new UnsupportedOperationException("Map is immutable");
        }
    }

    @Override
    public void clear() {
        this.checkMutable();
        if (this.coll != null) {
            this.coll.clear();
        } else {
            this.list.clear();
        }
    }

    @Override
    public E put(K key, E elem) {
        this.checkMutable();
        if (this.coll != null) {
            if (!GapList.equalsElem(key, this.coll.getKey(this.keyIndex, elem))) {
                KeyCollectionImpl.errorInvalidData();
            }
            return this.coll.putByKey(this.keyIndex, elem);
        }
        if (!GapList.equalsElem(key, this.list.keyColl.getKey(this.keyIndex, elem))) {
            KeyCollectionImpl.errorInvalidData();
        }
        return this.list.putByKey(this.keyIndex, elem, true);
    }

    @Override
    public E remove(Object key) {
        this.checkMutable();
        if (this.coll != null) {
            return this.coll.removeByKey(this.keyIndex, key);
        }
        return this.list.removeByKey(this.keyIndex, key);
    }

    @Override
    public void putAll(Map<? extends K, ? extends E> map) {
        for (Map.Entry<K, E> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }
}

