/*
 * Decompiled with CFR 0.152.
 */
package org.magicwerk.brownies.collections;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;

public class CollectionAsSet<K>
implements Set<K> {
    Collection<K> coll;
    boolean immutable;

    public CollectionAsSet(Collection<K> coll, boolean immutable) {
        if (coll == null) {
            throw new IllegalArgumentException("Collection may not be null");
        }
        this.coll = coll;
        this.immutable = immutable;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof Set)) {
            return false;
        }
        return this.coll.equals(obj);
    }

    @Override
    public int hashCode() {
        return this.coll.hashCode();
    }

    public String toString() {
        return this.coll.toString();
    }

    @Override
    public int size() {
        return this.coll.size();
    }

    @Override
    public boolean isEmpty() {
        return this.coll.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.coll.contains(o);
    }

    @Override
    public Object[] toArray() {
        return this.coll.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.coll.toArray(a);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.coll.containsAll(c);
    }

    @Override
    public Iterator<K> iterator() {
        if (this.immutable) {
            return Collections.unmodifiableCollection(this.coll).iterator();
        }
        return this.coll.iterator();
    }

    void checkMutable() {
        if (this.immutable) {
            throw new UnsupportedOperationException("Set is immutable");
        }
    }

    @Override
    public boolean add(K e) {
        this.checkMutable();
        try {
            return this.coll.add(e);
        }
        catch (Exception ex) {
            return false;
        }
    }

    @Override
    public boolean addAll(Collection<? extends K> c) {
        this.checkMutable();
        boolean changed = false;
        for (K e : c) {
            changed = this.add(e) || changed;
        }
        return changed;
    }

    @Override
    public void clear() {
        this.checkMutable();
        this.coll.clear();
    }

    @Override
    public boolean remove(Object o) {
        this.checkMutable();
        return this.coll.remove(o);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        this.checkMutable();
        return this.coll.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        this.checkMutable();
        return this.coll.retainAll(c);
    }
}

