/*
 * Decompiled with CFR 0.152.
 */
package com.lynx.service.log;

import android.util.Log;
import androidx.annotation.Keep;
import com.lynx.tasm.service.ILynxLogService;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\bH\u0016J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016J\u0010\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/lynx/service/log/LynxLogService;", "Lcom/lynx/tasm/service/ILynxLogService;", "()V", "logOutputChannel", "Lcom/lynx/tasm/service/ILynxLogService$LogOutputChannelType;", "getDefaultWriteFunction", "", "getLogToSystemStatus", "", "isLogOutputByPlatform", "logByPlatform", "", "level", "", "tag", "", "msg", "switchLogToSystem", "enableSystemLog", "lynx_service_log_release"})
@Keep
public final class LynxLogService
implements ILynxLogService {
    @NotNull
    public static final LynxLogService INSTANCE = new LynxLogService();
    @NotNull
    private static ILynxLogService.LogOutputChannelType logOutputChannel = ILynxLogService.LogOutputChannelType.Platform;

    private LynxLogService() {
    }

    public void logByPlatform(int level, @NotNull String tag, @NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        switch (level) {
            case 0: {
                Log.v((String)tag, (String)msg);
                break;
            }
            case 1: {
                Log.d((String)tag, (String)msg);
                break;
            }
            case 2: {
                Log.i((String)tag, (String)msg);
                break;
            }
            case 3: {
                Log.w((String)tag, (String)msg);
                break;
            }
            case 4: {
                Log.e((String)tag, (String)msg);
                break;
            }
            default: {
                Log.i((String)tag, (String)msg);
            }
        }
    }

    public boolean isLogOutputByPlatform() {
        return logOutputChannel == ILynxLogService.LogOutputChannelType.Platform;
    }

    public long getDefaultWriteFunction() {
        return 0L;
    }

    public void switchLogToSystem(boolean enableSystemLog) {
    }

    public boolean getLogToSystemStatus() {
        return false;
    }
}

