/*
 * Decompiled with CFR 0.152.
 */
package com.lynx.service.devtool;

import android.content.Context;
import androidx.annotation.Keep;
import com.lynx.devtool.LynxDevtoolEnv;
import com.lynx.devtool.LynxGlobalDebugBridge;
import com.lynx.devtool.LynxInspectorOwner;
import com.lynx.devtool.logbox.LynxLogBoxProxy;
import com.lynx.devtool.module.LynxDevToolSetModule;
import com.lynx.devtool.module.LynxTrailModule;
import com.lynx.devtool.module.LynxWebSocketModule;
import com.lynx.devtoolwrapper.LynxBaseInspectorOwnerNG;
import com.lynx.devtoolwrapper.LynxBaseLogBoxProxy;
import com.lynx.devtoolwrapper.LynxDevtool;
import com.lynx.devtoolwrapper.LynxDevtoolCardListener;
import com.lynx.jsbridge.LynxModule;
import com.lynx.tasm.INativeLibraryLoader;
import com.lynx.tasm.LynxView;
import com.lynx.tasm.base.LLog;
import com.lynx.tasm.service.ILynxDevToolService;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010#\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0012\u0010\u0011\u001a\u00020\u000e2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\u0012\u0010\u0014\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0016\u0018\u00010\u0015H\u0016J\u0012\u0010\u0017\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0016\u0018\u00010\u0015H\u0016J!\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u00042\b\u0010\u001b\u001a\u0004\u0018\u00010\u0019H\u0016\u00a2\u0006\u0002\u0010\u001cJ\u0018\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00040\u001e2\b\u0010\u001a\u001a\u0004\u0018\u00010\u0004H\u0016J!\u0010\u001f\u001a\u00020 2\b\u0010\u001a\u001a\u0004\u0018\u00010\u00042\b\u0010\u001b\u001a\u0004\u0018\u00010 H\u0016\u00a2\u0006\u0002\u0010!J\u0012\u0010\"\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0016\u0018\u00010\u0015H\u0016J\"\u0010#\u001a\u00020\u000e2\b\u0010$\u001a\u0004\u0018\u00010\u00042\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020 H\u0016J\u0015\u0010(\u001a\u00020\u00192\u0006\u0010)\u001a\u00020\u0004H\u0016\u00a2\u0006\u0002\u0010*J\u0012\u0010+\u001a\u00020\u000e2\b\u0010,\u001a\u0004\u0018\u00010-H\u0016J(\u0010.\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0014\u0010/\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0018\u000100H\u0016J\u0012\u00101\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J\u0015\u00102\u001a\u00020\u00192\u0006\u00103\u001a\u00020\u0004H\u0016\u00a2\u0006\u0002\u0010*J\b\u00104\u001a\u00020\u000eH\u0016J\b\u00105\u001a\u00020\u0019H\u0016J\u001c\u00106\u001a\u00020\u000e2\b\u0010\u001a\u001a\u0004\u0018\u00010\u00042\b\u00107\u001a\u0004\u0018\u000108H\u0016J\"\u00109\u001a\u00020\u000e2\b\u0010:\u001a\u0004\u0018\u00010\u00042\u000e\u0010;\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u001eH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Lcom/lynx/service/devtool/LynxDevToolService;", "Lcom/lynx/tasm/service/ILynxDevToolService;", "()V", "TAG", "", "createInspectorOwner", "Lcom/lynx/devtoolwrapper/LynxBaseInspectorOwnerNG;", "view", "Lcom/lynx/tasm/LynxView;", "createLogBoxProxy", "Lcom/lynx/devtoolwrapper/LynxBaseLogBoxProxy;", "devtool", "Lcom/lynx/devtoolwrapper/LynxDevtool;", "devtoolEnvInit", "", "ctx", "Landroid/content/Context;", "devtoolEnvSetDevToolLibraryLoader", "loader", "Lcom/lynx/tasm/INativeLibraryLoader;", "getDevToolSetModuleClass", "Ljava/lang/Class;", "Lcom/lynx/jsbridge/LynxModule;", "getDevToolWebSocketModuleClass", "getDevtoolBooleanEnv", "", "key", "defaultValue", "(Ljava/lang/String;Ljava/lang/Boolean;)Z", "getDevtoolGroupEnv", "", "getDevtoolIntEnv", "", "(Ljava/lang/String;Ljava/lang/Integer;)Ljava/lang/Integer;", "getLynxTrailModule", "globalDebugBridgeOnPerfMetricsEvent", "eventName", "data", "Lorg/json/JSONObject;", "instanceId", "globalDebugBridgePrepareRemoteDebug", "scheme", "(Ljava/lang/String;)Ljava/lang/Boolean;", "globalDebugBridgeRegisterCardListener", "listener", "Lcom/lynx/devtoolwrapper/LynxDevtoolCardListener;", "globalDebugBridgeSetAppInfo", "appInfo", "", "globalDebugBridgeSetContext", "globalDebugBridgeShouldPrepareRemoteDebug", "url", "globalDebugBridgeStartRecord", "isDevtoolAttached", "setDevtoolEnv", "value", "", "setDevtoolGroupEnv", "groupKey", "newGroupValues", "lynx_service_devtool_release"})
@Keep
public final class LynxDevToolService
implements ILynxDevToolService {
    @NotNull
    public static final LynxDevToolService INSTANCE = new LynxDevToolService();
    @NotNull
    private static final String TAG = "LynxDevToolService";

    private LynxDevToolService() {
    }

    @Nullable
    public LynxBaseInspectorOwnerNG createInspectorOwner(@Nullable LynxView view) {
        try {
            return (LynxBaseInspectorOwnerNG)new LynxInspectorOwner(view);
        }
        catch (ClassNotFoundException e) {
            LLog.e((String)TAG, (String)("createInspectorOwner failed, " + e.getMessage()));
            return null;
        }
        catch (NoClassDefFoundError e) {
            LLog.e((String)TAG, (String)("createInspectorOwner failed, " + e.getMessage()));
            return null;
        }
    }

    @Nullable
    public LynxBaseLogBoxProxy createLogBoxProxy(@NotNull LynxDevtool devtool) {
        Intrinsics.checkNotNullParameter((Object)devtool, (String)"devtool");
        try {
            return (LynxBaseLogBoxProxy)new LynxLogBoxProxy(devtool);
        }
        catch (ClassNotFoundException e) {
            LLog.e((String)TAG, (String)("createLogBoxProxy failed, " + e.getMessage()));
            return null;
        }
        catch (NoClassDefFoundError e) {
            LLog.e((String)TAG, (String)("createLogBoxProxy failed, " + e.getMessage()));
            return null;
        }
    }

    @Nullable
    public Class<? extends LynxModule> getDevToolSetModuleClass() {
        try {
            return LynxDevToolSetModule.class;
        }
        catch (ClassNotFoundException e) {
            LLog.e((String)TAG, (String)("getDevToolSetModuleClass failed, " + e.getMessage()));
            return null;
        }
        catch (NoClassDefFoundError e) {
            LLog.e((String)TAG, (String)("getDevToolSetModuleClass failed, " + e.getMessage()));
            return null;
        }
    }

    @Nullable
    public Class<? extends LynxModule> getDevToolWebSocketModuleClass() {
        try {
            return LynxWebSocketModule.class;
        }
        catch (ClassNotFoundException e) {
            LLog.e((String)TAG, (String)("getDevToolWebSocketModuleClass failed, " + e.getMessage()));
            return null;
        }
        catch (NoClassDefFoundError e) {
            LLog.e((String)TAG, (String)("getDevToolWebSocketModuleClass failed, " + e.getMessage()));
            return null;
        }
    }

    @Nullable
    public Class<? extends LynxModule> getLynxTrailModule() {
        try {
            return LynxTrailModule.class;
        }
        catch (ClassNotFoundException e) {
            LLog.e((String)TAG, (String)("getLynxTrailModule failed, " + e.getMessage()));
            return null;
        }
        catch (NoClassDefFoundError e) {
            LLog.e((String)TAG, (String)("getLynxTrailModule failed, " + e.getMessage()));
            return null;
        }
    }

    @NotNull
    public Boolean globalDebugBridgeShouldPrepareRemoteDebug(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        try {
            return LynxGlobalDebugBridge.getInstance().shouldPrepareRemoteDebug(url);
        }
        catch (ClassNotFoundException e) {
            LLog.e((String)TAG, (String)("globalDebugBridgeShouldPrepareRemoteDebug failed, " + e.getMessage()));
            return false;
        }
        catch (NoClassDefFoundError e) {
            LLog.e((String)TAG, (String)("globalDebugBridgeShouldPrepareRemoteDebug failed, " + e.getMessage()));
            return false;
        }
    }

    @NotNull
    public Boolean globalDebugBridgePrepareRemoteDebug(@NotNull String scheme) {
        Intrinsics.checkNotNullParameter((Object)scheme, (String)"scheme");
        try {
            return LynxGlobalDebugBridge.getInstance().prepareRemoteDebug(scheme);
        }
        catch (ClassNotFoundException e) {
            LLog.e((String)TAG, (String)("globalDebugBridgePrepareRemoteDebug failed, " + e.getMessage()));
            return false;
        }
        catch (NoClassDefFoundError e) {
            LLog.e((String)TAG, (String)("globalDebugBridgePrepareRemoteDebug failed, " + e.getMessage()));
            return false;
        }
    }

    public void globalDebugBridgeSetContext(@Nullable Context ctx) {
        try {
            LynxGlobalDebugBridge.getInstance().setContext(ctx);
        }
        catch (ClassNotFoundException e) {
            LLog.e((String)TAG, (String)("globalDebugBridgeSetContext failed, " + e.getMessage()));
        }
        catch (NoClassDefFoundError e) {
            LLog.e((String)TAG, (String)("globalDebugBridgeSetContext failed, " + e.getMessage()));
        }
    }

    public void globalDebugBridgeRegisterCardListener(@Nullable LynxDevtoolCardListener listener) {
        try {
            LynxGlobalDebugBridge.getInstance().registerCardListener(listener);
        }
        catch (ClassNotFoundException e) {
            LLog.e((String)TAG, (String)("globalDebugBridgeRegisterCardListener failed, " + e.getMessage()));
        }
        catch (NoClassDefFoundError e) {
            LLog.e((String)TAG, (String)("globalDebugBridgeRegisterCardListener failed, " + e.getMessage()));
        }
    }

    public void globalDebugBridgeSetAppInfo(@Nullable Context ctx, @Nullable Map<String, String> appInfo) {
        try {
            LynxGlobalDebugBridge.getInstance().setAppInfo(ctx, appInfo);
        }
        catch (ClassNotFoundException e) {
            LLog.e((String)TAG, (String)("globalDebugBridgeSetAppInfo failed, " + e.getMessage()));
        }
        catch (NoClassDefFoundError e) {
            LLog.e((String)TAG, (String)("globalDebugBridgeSetAppInfo failed, " + e.getMessage()));
        }
    }

    public void globalDebugBridgeOnPerfMetricsEvent(@Nullable String eventName, @NotNull JSONObject data, int instanceId) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        try {
            LynxGlobalDebugBridge.getInstance().onPerfMetricsEvent(eventName, data, instanceId);
        }
        catch (ClassNotFoundException e) {
            LLog.e((String)TAG, (String)("globalDebugBridgeOnPerfMetricsEvent failed, " + e.getMessage()));
        }
        catch (NoClassDefFoundError e) {
            LLog.e((String)TAG, (String)("globalDebugBridgeOnPerfMetricsEvent failed, " + e.getMessage()));
        }
    }

    public void globalDebugBridgeStartRecord() {
        try {
            LynxGlobalDebugBridge.getInstance().startRecord();
        }
        catch (ClassNotFoundException e) {
            LLog.e((String)TAG, (String)("globalDebugBridgeStartRecord failed, " + e.getMessage()));
        }
        catch (NoClassDefFoundError e) {
            LLog.e((String)TAG, (String)("globalDebugBridgeStartRecord failed, " + e.getMessage()));
        }
    }

    public void devtoolEnvSetDevToolLibraryLoader(@Nullable INativeLibraryLoader loader) {
        try {
            LynxDevtoolEnv.inst().setDevToolLibraryLoader(loader);
        }
        catch (ClassNotFoundException e) {
            LLog.e((String)TAG, (String)("devtoolEnvSetDevToolLibraryLoader failed, " + e.getMessage()));
        }
        catch (NoClassDefFoundError e) {
            LLog.e((String)TAG, (String)("devtoolEnvSetDevToolLibraryLoader failed, " + e.getMessage()));
        }
    }

    public void setDevtoolEnv(@Nullable String key, @Nullable Object value) {
        try {
            LynxDevtoolEnv.inst().setDevtoolEnv(key, value);
        }
        catch (ClassNotFoundException e) {
            LLog.e((String)TAG, (String)("setDevtoolEnv failed, " + e.getMessage()));
        }
        catch (NoClassDefFoundError e) {
            LLog.e((String)TAG, (String)("setDevtoolEnv failed, " + e.getMessage()));
        }
    }

    public void setDevtoolGroupEnv(@Nullable String groupKey, @Nullable Set<String> newGroupValues) {
        try {
            LynxDevtoolEnv.inst().setDevtoolEnv(groupKey, newGroupValues);
        }
        catch (ClassNotFoundException e) {
            LLog.e((String)TAG, (String)("setDevtoolGroupEnv failed, " + e.getMessage()));
        }
        catch (NoClassDefFoundError e) {
            LLog.e((String)TAG, (String)("setDevtoolGroupEnv failed, " + e.getMessage()));
        }
    }

    public boolean getDevtoolBooleanEnv(@Nullable String key, @Nullable Boolean defaultValue) {
        try {
            Boolean bl = LynxDevtoolEnv.inst().getDevtoolEnv(key, defaultValue);
            Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"inst().getDevtoolEnv(key, defaultValue)");
            return bl;
        }
        catch (ClassNotFoundException e) {
            LLog.e((String)TAG, (String)("getDevtoolBooleanEnv failed, " + e.getMessage()));
            Boolean bl = defaultValue;
            return bl != null ? bl : false;
        }
        catch (NoClassDefFoundError e) {
            LLog.e((String)TAG, (String)("getDevtoolBooleanEnv failed, " + e.getMessage()));
            Boolean bl = defaultValue;
            return bl != null ? bl : false;
        }
    }

    @NotNull
    public Integer getDevtoolIntEnv(@Nullable String key, @Nullable Integer defaultValue) {
        try {
            Integer n = LynxDevtoolEnv.inst().getDevtoolEnv(key, defaultValue);
            Intrinsics.checkNotNullExpressionValue((Object)n, (String)"inst().getDevtoolEnv(key, defaultValue)");
            return n;
        }
        catch (ClassNotFoundException e) {
            LLog.e((String)TAG, (String)("getDevtoolIntEnv failed, " + e.getMessage()));
            Integer n = defaultValue;
            return n != null ? n : 0;
        }
        catch (NoClassDefFoundError e) {
            LLog.e((String)TAG, (String)("getDevtoolIntEnv failed, " + e.getMessage()));
            Integer n = defaultValue;
            return n != null ? n : 0;
        }
    }

    @NotNull
    public Set<String> getDevtoolGroupEnv(@Nullable String key) {
        try {
            Set set = LynxDevtoolEnv.inst().getDevtoolEnv(key);
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"inst().getDevtoolEnv(key)");
            return set;
        }
        catch (ClassNotFoundException e) {
            LLog.e((String)TAG, (String)("getDevtoolGroupEnv failed, " + e.getMessage()));
            return new LinkedHashSet();
        }
        catch (NoClassDefFoundError e) {
            LLog.e((String)TAG, (String)("getDevtoolGroupEnv failed, " + e.getMessage()));
            return new LinkedHashSet();
        }
    }

    public void devtoolEnvInit(@NotNull Context ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        try {
            LynxDevtoolEnv.inst().init(ctx);
        }
        catch (ClassNotFoundException e) {
            LLog.e((String)TAG, (String)("devtoolEnvInit failed, " + e.getMessage()));
        }
        catch (NoClassDefFoundError e) {
            LLog.e((String)TAG, (String)("devtoolEnvInit failed, " + e.getMessage()));
        }
    }

    public boolean isDevtoolAttached() {
        try {
            return LynxDevtoolEnv.inst().isAttached();
        }
        catch (ClassNotFoundException e) {
            LLog.e((String)TAG, (String)("isDevtoolAttached failed, " + e.getMessage()));
            return false;
        }
        catch (NoClassDefFoundError e) {
            LLog.e((String)TAG, (String)("isDevtoolAttached failed, " + e.getMessage()));
            return false;
        }
    }
}

