/*
 * Decompiled with CFR 0.152.
 */
package com.lynx.basedevtool.logbox;

import android.app.Activity;
import android.content.Context;
import android.util.Log;
import com.lynx.basedevtool.logbox.LogBoxLogLevel;
import com.lynx.basedevtool.logbox.LogBoxManager;
import com.lynx.basedevtool.logbox.LogBoxProxy;
import java.util.WeakHashMap;

public class LogBoxOwner {
    private static final String TAG = "LogBoxOwner";
    private WeakHashMap<Context, LogBoxManager> mLogBoxManagers = new WeakHashMap();

    public static LogBoxOwner getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private LogBoxOwner() {
    }

    public void dispatch(String msg, LogBoxLogLevel level, Context activity, LogBoxProxy logBoxProxy) {
        LogBoxManager manager = this.findManagerByActivity(activity);
        if (manager != null) {
            manager.onNewLog(msg, level, logBoxProxy);
        }
    }

    public void onProxyReset(Context activity, LogBoxProxy logBoxProxy) {
        LogBoxManager manager = this.findManagerByActivityIfExist(activity);
        if (manager != null) {
            manager.onProxyReset(logBoxProxy);
        }
    }

    private LogBoxManager findManagerByActivity(Context activity) {
        if (!(activity instanceof Activity)) {
            Log.e((String)TAG, (String)"param activity is null or not a Activity");
            return null;
        }
        if (((Activity)activity).isFinishing()) {
            Log.i((String)TAG, (String)"activity is finishing");
            return null;
        }
        LogBoxManager manager = this.mLogBoxManagers.get(activity);
        if (manager == null) {
            Log.i((String)TAG, (String)"new activity");
            manager = new LogBoxManager(activity);
            this.mLogBoxManagers.put(activity, manager);
        }
        return manager;
    }

    protected LogBoxManager findManagerByActivityIfExist(Context activity) {
        if (activity == null) {
            Log.e((String)TAG, (String)"activity is null");
            return null;
        }
        return this.mLogBoxManagers.get(activity);
    }

    private static class SingletonHolder {
        private static final LogBoxOwner INSTANCE = new LogBoxOwner();

        private SingletonHolder() {
        }
    }
}

