/*
 * Decompiled with CFR 0.152.
 */
package com.lynx.basedevtool.logbox;

import android.app.Dialog;
import android.content.Context;
import android.content.res.AssetManager;
import android.graphics.Color;
import android.os.Build;
import android.text.TextUtils;
import android.util.Base64;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.JavascriptInterface;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebResourceResponse;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.LinearLayout;
import com.lynx.basedevtool.utils.DevToolDownloader;
import com.lynx.basedevtool.utils.DownloadCallback;
import com.lynx.basedevtool.utils.UIThreadUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class LogBoxDialogBase
extends Dialog {
    private static final String TAG = "LogBoxDialogBase";
    protected static final String LOCAL_URL = "file:///android_asset/logbox/index.html";
    private static final float CONTENT_HEIGHT_PERCENT = 0.6f;
    private static final String BRIDGE_JS = "if (!window.logbox) {" + "  (function () {" + "    var id = 0, callbacks = {}, eventListeners = {};" + "    var nativeBridge = window.nativeBridge || window.webkit.messageHandlers.nativeBridge;" + "    window.logbox = {" + "      call: function(bridgeName, callback, data) {" + "        var thisId = id++;" + "        callbacks[thisId] = callback;" + "        nativeBridge.postMessage(JSON.stringify({" + "          bridgeName: bridgeName," + "          data: data ? JSON.stringify(data) : {}," + "          callbackId: thisId" + "        }));" + "      }," + "      on: function(event, handler) {" + "        eventListeners[event] = handler;" + "      }," + "      sendResult: function(msg) {" + "        var callbackId = msg.callbackId;" + "        if (callbacks[callbackId]) {" + "          callbacks[callbackId](msg.data);" + "        }" + "      }," + "      sendEvent: function(msg) {" + "        if (eventListeners[msg.event]) {" + "          eventListeners[msg.event](msg.data);" + "        }" + "      }" + "    };" + "  })();" + "  setTimeout(function(){document.dispatchEvent(new Event('LogBoxReady'))}, 0);" + "};";
    private WebView mWebView;
    protected Map<String, Object> mJsSource;
    private LinearLayout mRootLayout;

    protected LogBoxDialogBase(Context context) {
        super(context);
        this.requestWindowFeature(1);
        this.mRootLayout = new LinearLayout(context);
        this.mRootLayout.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1));
        this.mRootLayout.setBackgroundColor(Color.alpha((int)80));
        this.mRootLayout.setOrientation(1);
        this.setContentView((View)this.mRootLayout);
        this.mRootLayout.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                LogBoxDialogBase.this.reset();
                LogBoxDialogBase.this.dismiss();
            }
        });
        this.mWebView = new WebView(context);
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-1, -1);
        int screenHeight = context.getResources().getDisplayMetrics().heightPixels;
        layoutParams.setMargins(0, Math.round((float)screenHeight * 0.39999998f), 0, 0);
        this.mRootLayout.addView((View)this.mWebView, (ViewGroup.LayoutParams)layoutParams);
        if (this.getWindow() != null) {
            this.getWindow().setBackgroundDrawableResource(17170445);
            this.getWindow().setLayout(-1, -1);
        }
    }

    public void initWebView(Callback callbacks) {
        this.mWebView.getSettings().setJavaScriptEnabled(true);
        this.mWebView.getSettings().setUserAgentString(this.mWebView.getSettings().getUserAgentString() + " Lynx LogBox");
        this.mWebView.setWebViewClient(new WebViewClient(){

            public void onReceivedError(WebView view, WebResourceRequest request, WebResourceError error) {
                super.onReceivedError(view, request, error);
                if (!LogBoxDialogBase.this.isLoadingFinished()) {
                    Log.i((String)LogBoxDialogBase.TAG, (String)"onReceivedError when load log box");
                }
            }

            public void onPageFinished(WebView view, String url) {
                super.onPageFinished(view, url);
                LogBoxDialogBase.this.evaluateJs(BRIDGE_JS);
            }

            public void onReceivedHttpError(WebView view, WebResourceRequest request, WebResourceResponse errorResponse) {
                super.onReceivedHttpError(view, request, errorResponse);
                if (!LogBoxDialogBase.this.isLoadingFinished()) {
                    Log.i((String)LogBoxDialogBase.TAG, (String)"onReceivedHttpError when load log box");
                }
            }
        });
        this.mWebView.setWebChromeClient(new WebChromeClient(){

            public void onReceivedTitle(WebView view, String title) {
                super.onReceivedTitle(view, title);
                LogBoxDialogBase.this.evaluateJs(BRIDGE_JS);
            }
        });
        this.mWebView.addJavascriptInterface((Object)callbacks, "nativeBridge");
        if (Build.VERSION.SDK_INT >= 19) {
            WebView.setWebContentsDebuggingEnabled((boolean)true);
        }
        this.mWebView.loadUrl(LOCAL_URL);
    }

    public void setJSSource(Map<String, Object> jsSource) {
        this.mJsSource = jsSource;
    }

    protected void evaluateJs(final String js) {
        UIThreadUtils.runOnUiThreadImmediately(new Runnable(){

            @Override
            public void run() {
                if (Build.VERSION.SDK_INT >= 19) {
                    LogBoxDialogBase.this.mWebView.evaluateJavascript(js, null);
                } else {
                    LogBoxDialogBase.this.mWebView.loadUrl(js);
                }
            }
        });
    }

    protected void sendEvent(JSONObject event) {
        String js = "javascript: window.logbox.sendEvent(" + event.toString() + ");";
        this.evaluateJs(js);
    }

    protected void sendEvent(String event) {
        String js = "javascript: window.logbox.sendEvent({event: \"" + event + "\"});";
        this.evaluateJs(js);
    }

    public void destroyWebView() {
        this.mWebView.destroy();
    }

    public abstract void reset();

    public abstract boolean isLoadingFinished();

    public class Callback {
        @JavascriptInterface
        public void on(String event, Object handler) {
            Log.e((String)LogBoxDialogBase.TAG, (String)("onEvent " + event));
        }

        public void sendResult(int callbackId, Object result) {
            if (result == null) {
                return;
            }
            JSONObject obj = new JSONObject();
            try {
                obj.put("callbackId", callbackId);
                obj.put("data", result);
            }
            catch (JSONException e) {
                Log.e((String)LogBoxDialogBase.TAG, (String)e.getMessage());
                return;
            }
            StringBuilder strBuilder = new StringBuilder();
            strBuilder.append("javascript: window.logbox.sendResult(").append(obj.toString()).append(");");
            LogBoxDialogBase.this.evaluateJs(strBuilder.toString());
        }

        public void download(String url, DownloadCallback callback) {
            if (callback != null && !TextUtils.isEmpty((CharSequence)url) && url.startsWith("http")) {
                DevToolDownloader devToolDownloader = new DevToolDownloader(url, callback);
            }
        }

        public void loadMappingsWasm() {
            AssetManager manager = LogBoxDialogBase.this.getContext().getAssets();
            try {
                int readBytes;
                InputStream stream = manager.open("logbox/mappings.wasm");
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                byte[] buf = new byte[8192];
                while ((readBytes = stream.read(buf)) != -1) {
                    buffer.write(buf, 0, readBytes);
                }
                stream.close();
                String base64Data = Base64.encodeToString((byte[])buffer.toByteArray(), (int)0);
                JSONObject event = new JSONObject();
                event.put("event", (Object)"loadFile");
                JSONObject dataObject = new JSONObject();
                dataObject.putOpt("type", (Object)"mappings.wasm");
                dataObject.putOpt("data", (Object)base64Data);
                event.putOpt("data", (Object)dataObject);
                LogBoxDialogBase.this.sendEvent(event);
            }
            catch (IOException | JSONException e) {
                Log.w((String)"Failed to load mappings.wasm: ", (String)e.getMessage());
            }
        }
    }
}

