/*
 * Decompiled with CFR 0.152.
 */
package com.lynx.basedevtool;

import androidx.annotation.Keep;
import com.lynx.basedevtool.BaseDevToolLoadSoUtils;
import com.lynx.basedevtool.CalledByNative;
import com.lynx.debugrouter.DebugRouterSlot;
import com.lynx.debugrouter.DebugRouterSlotDelegate;

@Keep
public class DevToolSlot
implements DebugRouterSlotDelegate {
    private static final int STATUS_UNINITIALIZED = -1;
    private long mNativeHandler = -1L;
    private DebugRouterSlot mDebugRouterSlot = null;
    private String mTemplateUrl = "";

    @CalledByNative
    public static DevToolSlot createInstance(long nativeHandler) {
        return new DevToolSlot(nativeHandler);
    }

    private DevToolSlot(long mNativeHandler) {
        this.mNativeHandler = mNativeHandler;
        this.mDebugRouterSlot = new DebugRouterSlot((DebugRouterSlotDelegate)this);
    }

    public String getTemplateUrl() {
        return this.mTemplateUrl;
    }

    public void onMessage(String type, String message) {
        this.nativeOnSlotMessage(this.mNativeHandler, type, message);
    }

    private native void nativeOnSlotMessage(long var1, String var3, String var4);

    @CalledByNative
    public int plug(String url) {
        this.mTemplateUrl = url;
        return this.mDebugRouterSlot.plug();
    }

    @CalledByNative
    public void pull() {
        this.mDebugRouterSlot.pull();
    }

    @CalledByNative
    public void sendMessage(String type, String msg) {
        this.mDebugRouterSlot.sendDataAsync(type, msg);
    }

    static {
        BaseDevToolLoadSoUtils.loadSo();
    }
}

