/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.zstd;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.util.zstd.ZSTDAllocFunction;
import org.lwjgl.util.zstd.ZSTDAllocFunctionI;
import org.lwjgl.util.zstd.ZSTDFreeFunction;
import org.lwjgl.util.zstd.ZSTDFreeFunctionI;

@NativeType(value="struct ZSTD_customMem")
public class ZSTDCustomMem
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int CUSTOMALLOC;
    public static final int CUSTOMFREE;
    public static final int OPAQUE;

    public ZSTDCustomMem(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), ZSTDCustomMem.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="ZSTD_allocFunction")
    public ZSTDAllocFunction customAlloc() {
        return ZSTDCustomMem.ncustomAlloc(this.address());
    }

    @NativeType(value="ZSTD_freeFunction")
    public ZSTDFreeFunction customFree() {
        return ZSTDCustomMem.ncustomFree(this.address());
    }

    @NativeType(value="void *")
    public long opaque() {
        return ZSTDCustomMem.nopaque(this.address());
    }

    public ZSTDCustomMem customAlloc(@NativeType(value="ZSTD_allocFunction") ZSTDAllocFunctionI value) {
        ZSTDCustomMem.ncustomAlloc(this.address(), value);
        return this;
    }

    public ZSTDCustomMem customFree(@NativeType(value="ZSTD_freeFunction") ZSTDFreeFunctionI value) {
        ZSTDCustomMem.ncustomFree(this.address(), value);
        return this;
    }

    public ZSTDCustomMem opaque(@NativeType(value="void *") long value) {
        ZSTDCustomMem.nopaque(this.address(), value);
        return this;
    }

    public ZSTDCustomMem set(ZSTDAllocFunctionI customAlloc, ZSTDFreeFunctionI customFree, long opaque) {
        this.customAlloc(customAlloc);
        this.customFree(customFree);
        this.opaque(opaque);
        return this;
    }

    public ZSTDCustomMem set(ZSTDCustomMem src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static ZSTDCustomMem malloc() {
        return (ZSTDCustomMem)ZSTDCustomMem.wrap(ZSTDCustomMem.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static ZSTDCustomMem calloc() {
        return (ZSTDCustomMem)ZSTDCustomMem.wrap(ZSTDCustomMem.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static ZSTDCustomMem create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (ZSTDCustomMem)ZSTDCustomMem.wrap(ZSTDCustomMem.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static ZSTDCustomMem create(long address) {
        return (ZSTDCustomMem)ZSTDCustomMem.wrap(ZSTDCustomMem.class, (long)address);
    }

    @Nullable
    public static ZSTDCustomMem createSafe(long address) {
        return address == 0L ? null : (ZSTDCustomMem)ZSTDCustomMem.wrap(ZSTDCustomMem.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)ZSTDCustomMem.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)ZSTDCustomMem.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)ZSTDCustomMem.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = ZSTDCustomMem.__create((int)capacity, (int)SIZEOF);
        return (Buffer)ZSTDCustomMem.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)ZSTDCustomMem.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)ZSTDCustomMem.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Deprecated
    public static ZSTDCustomMem mallocStack() {
        return ZSTDCustomMem.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static ZSTDCustomMem callocStack() {
        return ZSTDCustomMem.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static ZSTDCustomMem mallocStack(MemoryStack stack) {
        return ZSTDCustomMem.malloc(stack);
    }

    @Deprecated
    public static ZSTDCustomMem callocStack(MemoryStack stack) {
        return ZSTDCustomMem.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return ZSTDCustomMem.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return ZSTDCustomMem.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return ZSTDCustomMem.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return ZSTDCustomMem.calloc(capacity, stack);
    }

    public static ZSTDCustomMem malloc(MemoryStack stack) {
        return (ZSTDCustomMem)ZSTDCustomMem.wrap(ZSTDCustomMem.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static ZSTDCustomMem calloc(MemoryStack stack) {
        return (ZSTDCustomMem)ZSTDCustomMem.wrap(ZSTDCustomMem.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)ZSTDCustomMem.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)ZSTDCustomMem.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static ZSTDAllocFunction ncustomAlloc(long struct) {
        return ZSTDAllocFunction.create(MemoryUtil.memGetAddress((long)(struct + (long)CUSTOMALLOC)));
    }

    public static ZSTDFreeFunction ncustomFree(long struct) {
        return ZSTDFreeFunction.create(MemoryUtil.memGetAddress((long)(struct + (long)CUSTOMFREE)));
    }

    public static long nopaque(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)OPAQUE));
    }

    public static void ncustomAlloc(long struct, ZSTDAllocFunctionI value) {
        MemoryUtil.memPutAddress((long)(struct + (long)CUSTOMALLOC), (long)value.address());
    }

    public static void ncustomFree(long struct, ZSTDFreeFunctionI value) {
        MemoryUtil.memPutAddress((long)(struct + (long)CUSTOMFREE), (long)value.address());
    }

    public static void nopaque(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)OPAQUE), (long)Checks.check((long)value));
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)CUSTOMALLOC)));
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)CUSTOMFREE)));
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)OPAQUE)));
    }

    static {
        Struct.Layout layout = ZSTDCustomMem.__struct((Struct.Member[])new Struct.Member[]{ZSTDCustomMem.__member((int)POINTER_SIZE), ZSTDCustomMem.__member((int)POINTER_SIZE), ZSTDCustomMem.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        CUSTOMALLOC = layout.offsetof(0);
        CUSTOMFREE = layout.offsetof(1);
        OPAQUE = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<ZSTDCustomMem, Buffer>
    implements NativeResource {
        private static final ZSTDCustomMem ELEMENT_FACTORY = ZSTDCustomMem.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected ZSTDCustomMem getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="ZSTD_allocFunction")
        public ZSTDAllocFunction customAlloc() {
            return ZSTDCustomMem.ncustomAlloc(this.address());
        }

        @NativeType(value="ZSTD_freeFunction")
        public ZSTDFreeFunction customFree() {
            return ZSTDCustomMem.ncustomFree(this.address());
        }

        @NativeType(value="void *")
        public long opaque() {
            return ZSTDCustomMem.nopaque(this.address());
        }

        public Buffer customAlloc(@NativeType(value="ZSTD_allocFunction") ZSTDAllocFunctionI value) {
            ZSTDCustomMem.ncustomAlloc(this.address(), value);
            return this;
        }

        public Buffer customFree(@NativeType(value="ZSTD_freeFunction") ZSTDFreeFunctionI value) {
            ZSTDCustomMem.ncustomFree(this.address(), value);
            return this;
        }

        public Buffer opaque(@NativeType(value="void *") long value) {
            ZSTDCustomMem.nopaque(this.address(), value);
            return this;
        }
    }
}

