/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.zstd;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.util.zstd.ZDICTParams;

@NativeType(value="struct ZDICT_cover_params_t")
public class ZDICTCoverParams
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int K;
    public static final int D;
    public static final int STEPS;
    public static final int NBTHREADS;
    public static final int SPLITPOINT;
    public static final int ZPARAMS;

    public ZDICTCoverParams(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), ZDICTCoverParams.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="unsigned")
    public int k() {
        return ZDICTCoverParams.nk(this.address());
    }

    @NativeType(value="unsigned")
    public int d() {
        return ZDICTCoverParams.nd(this.address());
    }

    @NativeType(value="unsigned")
    public int steps() {
        return ZDICTCoverParams.nsteps(this.address());
    }

    @NativeType(value="unsigned")
    public int nbThreads() {
        return ZDICTCoverParams.nnbThreads(this.address());
    }

    public double splitPoint() {
        return ZDICTCoverParams.nsplitPoint(this.address());
    }

    @NativeType(value="ZDICT_params_t")
    public ZDICTParams zParams() {
        return ZDICTCoverParams.nzParams(this.address());
    }

    public ZDICTCoverParams k(@NativeType(value="unsigned") int value) {
        ZDICTCoverParams.nk(this.address(), value);
        return this;
    }

    public ZDICTCoverParams d(@NativeType(value="unsigned") int value) {
        ZDICTCoverParams.nd(this.address(), value);
        return this;
    }

    public ZDICTCoverParams steps(@NativeType(value="unsigned") int value) {
        ZDICTCoverParams.nsteps(this.address(), value);
        return this;
    }

    public ZDICTCoverParams nbThreads(@NativeType(value="unsigned") int value) {
        ZDICTCoverParams.nnbThreads(this.address(), value);
        return this;
    }

    public ZDICTCoverParams splitPoint(double value) {
        ZDICTCoverParams.nsplitPoint(this.address(), value);
        return this;
    }

    public ZDICTCoverParams zParams(@NativeType(value="ZDICT_params_t") ZDICTParams value) {
        ZDICTCoverParams.nzParams(this.address(), value);
        return this;
    }

    public ZDICTCoverParams zParams(Consumer<ZDICTParams> consumer) {
        consumer.accept(this.zParams());
        return this;
    }

    public ZDICTCoverParams set(int k, int d, int steps, int nbThreads, double splitPoint, ZDICTParams zParams) {
        this.k(k);
        this.d(d);
        this.steps(steps);
        this.nbThreads(nbThreads);
        this.splitPoint(splitPoint);
        this.zParams(zParams);
        return this;
    }

    public ZDICTCoverParams set(ZDICTCoverParams src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static ZDICTCoverParams malloc() {
        return (ZDICTCoverParams)ZDICTCoverParams.wrap(ZDICTCoverParams.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static ZDICTCoverParams calloc() {
        return (ZDICTCoverParams)ZDICTCoverParams.wrap(ZDICTCoverParams.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static ZDICTCoverParams create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (ZDICTCoverParams)ZDICTCoverParams.wrap(ZDICTCoverParams.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static ZDICTCoverParams create(long address) {
        return (ZDICTCoverParams)ZDICTCoverParams.wrap(ZDICTCoverParams.class, (long)address);
    }

    @Nullable
    public static ZDICTCoverParams createSafe(long address) {
        return address == 0L ? null : (ZDICTCoverParams)ZDICTCoverParams.wrap(ZDICTCoverParams.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)ZDICTCoverParams.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)ZDICTCoverParams.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)ZDICTCoverParams.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = ZDICTCoverParams.__create((int)capacity, (int)SIZEOF);
        return (Buffer)ZDICTCoverParams.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)ZDICTCoverParams.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)ZDICTCoverParams.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Deprecated
    public static ZDICTCoverParams mallocStack() {
        return ZDICTCoverParams.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static ZDICTCoverParams callocStack() {
        return ZDICTCoverParams.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static ZDICTCoverParams mallocStack(MemoryStack stack) {
        return ZDICTCoverParams.malloc(stack);
    }

    @Deprecated
    public static ZDICTCoverParams callocStack(MemoryStack stack) {
        return ZDICTCoverParams.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return ZDICTCoverParams.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return ZDICTCoverParams.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return ZDICTCoverParams.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return ZDICTCoverParams.calloc(capacity, stack);
    }

    public static ZDICTCoverParams malloc(MemoryStack stack) {
        return (ZDICTCoverParams)ZDICTCoverParams.wrap(ZDICTCoverParams.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static ZDICTCoverParams calloc(MemoryStack stack) {
        return (ZDICTCoverParams)ZDICTCoverParams.wrap(ZDICTCoverParams.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)ZDICTCoverParams.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)ZDICTCoverParams.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nk(long struct) {
        return UNSAFE.getInt(null, struct + (long)K);
    }

    public static int nd(long struct) {
        return UNSAFE.getInt(null, struct + (long)D);
    }

    public static int nsteps(long struct) {
        return UNSAFE.getInt(null, struct + (long)STEPS);
    }

    public static int nnbThreads(long struct) {
        return UNSAFE.getInt(null, struct + (long)NBTHREADS);
    }

    public static double nsplitPoint(long struct) {
        return UNSAFE.getDouble(null, struct + (long)SPLITPOINT);
    }

    public static ZDICTParams nzParams(long struct) {
        return ZDICTParams.create(struct + (long)ZPARAMS);
    }

    public static void nk(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)K, value);
    }

    public static void nd(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)D, value);
    }

    public static void nsteps(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STEPS, value);
    }

    public static void nnbThreads(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)NBTHREADS, value);
    }

    public static void nsplitPoint(long struct, double value) {
        UNSAFE.putDouble(null, struct + (long)SPLITPOINT, value);
    }

    public static void nzParams(long struct, ZDICTParams value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)ZPARAMS), (long)ZDICTParams.SIZEOF);
    }

    static {
        Struct.Layout layout = ZDICTCoverParams.__struct((Struct.Member[])new Struct.Member[]{ZDICTCoverParams.__member((int)4), ZDICTCoverParams.__member((int)4), ZDICTCoverParams.__member((int)4), ZDICTCoverParams.__member((int)4), ZDICTCoverParams.__member((int)8), ZDICTCoverParams.__member((int)ZDICTParams.SIZEOF, (int)ZDICTParams.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        K = layout.offsetof(0);
        D = layout.offsetof(1);
        STEPS = layout.offsetof(2);
        NBTHREADS = layout.offsetof(3);
        SPLITPOINT = layout.offsetof(4);
        ZPARAMS = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<ZDICTCoverParams, Buffer>
    implements NativeResource {
        private static final ZDICTCoverParams ELEMENT_FACTORY = ZDICTCoverParams.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected ZDICTCoverParams getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="unsigned")
        public int k() {
            return ZDICTCoverParams.nk(this.address());
        }

        @NativeType(value="unsigned")
        public int d() {
            return ZDICTCoverParams.nd(this.address());
        }

        @NativeType(value="unsigned")
        public int steps() {
            return ZDICTCoverParams.nsteps(this.address());
        }

        @NativeType(value="unsigned")
        public int nbThreads() {
            return ZDICTCoverParams.nnbThreads(this.address());
        }

        public double splitPoint() {
            return ZDICTCoverParams.nsplitPoint(this.address());
        }

        @NativeType(value="ZDICT_params_t")
        public ZDICTParams zParams() {
            return ZDICTCoverParams.nzParams(this.address());
        }

        public Buffer k(@NativeType(value="unsigned") int value) {
            ZDICTCoverParams.nk(this.address(), value);
            return this;
        }

        public Buffer d(@NativeType(value="unsigned") int value) {
            ZDICTCoverParams.nd(this.address(), value);
            return this;
        }

        public Buffer steps(@NativeType(value="unsigned") int value) {
            ZDICTCoverParams.nsteps(this.address(), value);
            return this;
        }

        public Buffer nbThreads(@NativeType(value="unsigned") int value) {
            ZDICTCoverParams.nnbThreads(this.address(), value);
            return this;
        }

        public Buffer splitPoint(double value) {
            ZDICTCoverParams.nsplitPoint(this.address(), value);
            return this;
        }

        public Buffer zParams(@NativeType(value="ZDICT_params_t") ZDICTParams value) {
            ZDICTCoverParams.nzParams(this.address(), value);
            return this;
        }

        public Buffer zParams(Consumer<ZDICTParams> consumer) {
            consumer.accept(this.zParams());
            return this;
        }
    }
}

