/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.zstd;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct ZSTD_Sequence")
public class ZSTDSequence
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int OFFSET;
    public static final int LITLENGTH;
    public static final int MATCHLENGTH;
    public static final int REP;

    public ZSTDSequence(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), ZSTDSequence.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="unsigned int")
    public int offset() {
        return ZSTDSequence.noffset(this.address());
    }

    @NativeType(value="unsigned int")
    public int litLength() {
        return ZSTDSequence.nlitLength(this.address());
    }

    @NativeType(value="unsigned int")
    public int matchLength() {
        return ZSTDSequence.nmatchLength(this.address());
    }

    @NativeType(value="unsigned int")
    public int rep() {
        return ZSTDSequence.nrep(this.address());
    }

    public static ZSTDSequence malloc() {
        return (ZSTDSequence)ZSTDSequence.wrap(ZSTDSequence.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static ZSTDSequence calloc() {
        return (ZSTDSequence)ZSTDSequence.wrap(ZSTDSequence.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static ZSTDSequence create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (ZSTDSequence)ZSTDSequence.wrap(ZSTDSequence.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static ZSTDSequence create(long address) {
        return (ZSTDSequence)ZSTDSequence.wrap(ZSTDSequence.class, (long)address);
    }

    @Nullable
    public static ZSTDSequence createSafe(long address) {
        return address == 0L ? null : (ZSTDSequence)ZSTDSequence.wrap(ZSTDSequence.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)ZSTDSequence.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)ZSTDSequence.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)ZSTDSequence.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = ZSTDSequence.__create((int)capacity, (int)SIZEOF);
        return (Buffer)ZSTDSequence.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)ZSTDSequence.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)ZSTDSequence.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static ZSTDSequence malloc(MemoryStack stack) {
        return (ZSTDSequence)ZSTDSequence.wrap(ZSTDSequence.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static ZSTDSequence calloc(MemoryStack stack) {
        return (ZSTDSequence)ZSTDSequence.wrap(ZSTDSequence.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)ZSTDSequence.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)ZSTDSequence.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int noffset(long struct) {
        return UNSAFE.getInt(null, struct + (long)OFFSET);
    }

    public static int nlitLength(long struct) {
        return UNSAFE.getInt(null, struct + (long)LITLENGTH);
    }

    public static int nmatchLength(long struct) {
        return UNSAFE.getInt(null, struct + (long)MATCHLENGTH);
    }

    public static int nrep(long struct) {
        return UNSAFE.getInt(null, struct + (long)REP);
    }

    static {
        Struct.Layout layout = ZSTDSequence.__struct((Struct.Member[])new Struct.Member[]{ZSTDSequence.__member((int)4), ZSTDSequence.__member((int)4), ZSTDSequence.__member((int)4), ZSTDSequence.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        OFFSET = layout.offsetof(0);
        LITLENGTH = layout.offsetof(1);
        MATCHLENGTH = layout.offsetof(2);
        REP = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<ZSTDSequence, Buffer>
    implements NativeResource {
        private static final ZSTDSequence ELEMENT_FACTORY = ZSTDSequence.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected ZSTDSequence getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="unsigned int")
        public int offset() {
            return ZSTDSequence.noffset(this.address());
        }

        @NativeType(value="unsigned int")
        public int litLength() {
            return ZSTDSequence.nlitLength(this.address());
        }

        @NativeType(value="unsigned int")
        public int matchLength() {
            return ZSTDSequence.nmatchLength(this.address());
        }

        @NativeType(value="unsigned int")
        public int rep() {
            return ZSTDSequence.nrep(this.address());
        }
    }
}

