/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.zstd;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct ZSTD_inBuffer")
public class ZSTDInBuffer
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int SRC;
    public static final int SIZE;
    public static final int POS;

    public ZSTDInBuffer(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), ZSTDInBuffer.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="void const *")
    public ByteBuffer src() {
        return ZSTDInBuffer.nsrc(this.address());
    }

    @NativeType(value="size_t")
    public long size() {
        return ZSTDInBuffer.nsize(this.address());
    }

    @NativeType(value="size_t")
    public long pos() {
        return ZSTDInBuffer.npos(this.address());
    }

    public ZSTDInBuffer src(@NativeType(value="void const *") ByteBuffer value) {
        ZSTDInBuffer.nsrc(this.address(), value);
        return this;
    }

    public ZSTDInBuffer pos(@NativeType(value="size_t") long value) {
        ZSTDInBuffer.npos(this.address(), value);
        return this;
    }

    public ZSTDInBuffer set(ByteBuffer src, long pos) {
        this.src(src);
        this.pos(pos);
        return this;
    }

    public ZSTDInBuffer set(ZSTDInBuffer src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static ZSTDInBuffer malloc() {
        return (ZSTDInBuffer)ZSTDInBuffer.wrap(ZSTDInBuffer.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static ZSTDInBuffer calloc() {
        return (ZSTDInBuffer)ZSTDInBuffer.wrap(ZSTDInBuffer.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static ZSTDInBuffer create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (ZSTDInBuffer)ZSTDInBuffer.wrap(ZSTDInBuffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static ZSTDInBuffer create(long address) {
        return (ZSTDInBuffer)ZSTDInBuffer.wrap(ZSTDInBuffer.class, (long)address);
    }

    @Nullable
    public static ZSTDInBuffer createSafe(long address) {
        return address == 0L ? null : (ZSTDInBuffer)ZSTDInBuffer.wrap(ZSTDInBuffer.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)ZSTDInBuffer.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)ZSTDInBuffer.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)ZSTDInBuffer.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = ZSTDInBuffer.__create((int)capacity, (int)SIZEOF);
        return (Buffer)ZSTDInBuffer.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)ZSTDInBuffer.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)ZSTDInBuffer.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Deprecated
    public static ZSTDInBuffer mallocStack() {
        return ZSTDInBuffer.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static ZSTDInBuffer callocStack() {
        return ZSTDInBuffer.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static ZSTDInBuffer mallocStack(MemoryStack stack) {
        return ZSTDInBuffer.malloc(stack);
    }

    @Deprecated
    public static ZSTDInBuffer callocStack(MemoryStack stack) {
        return ZSTDInBuffer.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return ZSTDInBuffer.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return ZSTDInBuffer.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return ZSTDInBuffer.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return ZSTDInBuffer.calloc(capacity, stack);
    }

    public static ZSTDInBuffer malloc(MemoryStack stack) {
        return (ZSTDInBuffer)ZSTDInBuffer.wrap(ZSTDInBuffer.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static ZSTDInBuffer calloc(MemoryStack stack) {
        return (ZSTDInBuffer)ZSTDInBuffer.wrap(ZSTDInBuffer.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)ZSTDInBuffer.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)ZSTDInBuffer.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static ByteBuffer nsrc(long struct) {
        return MemoryUtil.memByteBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)SRC)), (int)((int)ZSTDInBuffer.nsize(struct)));
    }

    public static long nsize(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)SIZE));
    }

    public static long npos(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)POS));
    }

    public static void nsrc(long struct, ByteBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)SRC), (long)MemoryUtil.memAddress((ByteBuffer)value));
        ZSTDInBuffer.nsize(struct, value.remaining());
    }

    public static void nsize(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)SIZE), (long)value);
    }

    public static void npos(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)POS), (long)value);
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)SRC)));
    }

    static {
        Struct.Layout layout = ZSTDInBuffer.__struct((Struct.Member[])new Struct.Member[]{ZSTDInBuffer.__member((int)POINTER_SIZE), ZSTDInBuffer.__member((int)POINTER_SIZE), ZSTDInBuffer.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        SRC = layout.offsetof(0);
        SIZE = layout.offsetof(1);
        POS = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<ZSTDInBuffer, Buffer>
    implements NativeResource {
        private static final ZSTDInBuffer ELEMENT_FACTORY = ZSTDInBuffer.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected ZSTDInBuffer getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="void const *")
        public ByteBuffer src() {
            return ZSTDInBuffer.nsrc(this.address());
        }

        @NativeType(value="size_t")
        public long size() {
            return ZSTDInBuffer.nsize(this.address());
        }

        @NativeType(value="size_t")
        public long pos() {
            return ZSTDInBuffer.npos(this.address());
        }

        public Buffer src(@NativeType(value="void const *") ByteBuffer value) {
            ZSTDInBuffer.nsrc(this.address(), value);
            return this;
        }

        public Buffer pos(@NativeType(value="size_t") long value) {
            ZSTDInBuffer.npos(this.address(), value);
            return this;
        }
    }
}

