/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.zstd;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct ZSTD_frameProgression")
public class ZSTDFrameProgression
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int INGESTED;
    public static final int CONSUMED;
    public static final int PRODUCED;
    public static final int FLUSHED;
    public static final int CURRENTJOBID;
    public static final int NBACTIVEWORKERS;

    public ZSTDFrameProgression(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), ZSTDFrameProgression.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="unsigned long long")
    public long ingested() {
        return ZSTDFrameProgression.ningested(this.address());
    }

    @NativeType(value="unsigned long long")
    public long consumed() {
        return ZSTDFrameProgression.nconsumed(this.address());
    }

    @NativeType(value="unsigned long long")
    public long produced() {
        return ZSTDFrameProgression.nproduced(this.address());
    }

    @NativeType(value="unsigned long long")
    public long flushed() {
        return ZSTDFrameProgression.nflushed(this.address());
    }

    @NativeType(value="unsigned int")
    public int currentJobID() {
        return ZSTDFrameProgression.ncurrentJobID(this.address());
    }

    @NativeType(value="unsigned int")
    public int nbActiveWorkers() {
        return ZSTDFrameProgression.nnbActiveWorkers(this.address());
    }

    public static ZSTDFrameProgression malloc() {
        return (ZSTDFrameProgression)ZSTDFrameProgression.wrap(ZSTDFrameProgression.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static ZSTDFrameProgression calloc() {
        return (ZSTDFrameProgression)ZSTDFrameProgression.wrap(ZSTDFrameProgression.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static ZSTDFrameProgression create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (ZSTDFrameProgression)ZSTDFrameProgression.wrap(ZSTDFrameProgression.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static ZSTDFrameProgression create(long address) {
        return (ZSTDFrameProgression)ZSTDFrameProgression.wrap(ZSTDFrameProgression.class, (long)address);
    }

    @Nullable
    public static ZSTDFrameProgression createSafe(long address) {
        return address == 0L ? null : (ZSTDFrameProgression)ZSTDFrameProgression.wrap(ZSTDFrameProgression.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)ZSTDFrameProgression.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)ZSTDFrameProgression.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)ZSTDFrameProgression.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = ZSTDFrameProgression.__create((int)capacity, (int)SIZEOF);
        return (Buffer)ZSTDFrameProgression.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)ZSTDFrameProgression.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)ZSTDFrameProgression.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Deprecated
    public static ZSTDFrameProgression mallocStack() {
        return ZSTDFrameProgression.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static ZSTDFrameProgression callocStack() {
        return ZSTDFrameProgression.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static ZSTDFrameProgression mallocStack(MemoryStack stack) {
        return ZSTDFrameProgression.malloc(stack);
    }

    @Deprecated
    public static ZSTDFrameProgression callocStack(MemoryStack stack) {
        return ZSTDFrameProgression.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return ZSTDFrameProgression.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return ZSTDFrameProgression.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return ZSTDFrameProgression.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return ZSTDFrameProgression.calloc(capacity, stack);
    }

    public static ZSTDFrameProgression malloc(MemoryStack stack) {
        return (ZSTDFrameProgression)ZSTDFrameProgression.wrap(ZSTDFrameProgression.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static ZSTDFrameProgression calloc(MemoryStack stack) {
        return (ZSTDFrameProgression)ZSTDFrameProgression.wrap(ZSTDFrameProgression.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)ZSTDFrameProgression.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)ZSTDFrameProgression.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static long ningested(long struct) {
        return UNSAFE.getLong(null, struct + (long)INGESTED);
    }

    public static long nconsumed(long struct) {
        return UNSAFE.getLong(null, struct + (long)CONSUMED);
    }

    public static long nproduced(long struct) {
        return UNSAFE.getLong(null, struct + (long)PRODUCED);
    }

    public static long nflushed(long struct) {
        return UNSAFE.getLong(null, struct + (long)FLUSHED);
    }

    public static int ncurrentJobID(long struct) {
        return UNSAFE.getInt(null, struct + (long)CURRENTJOBID);
    }

    public static int nnbActiveWorkers(long struct) {
        return UNSAFE.getInt(null, struct + (long)NBACTIVEWORKERS);
    }

    static {
        Struct.Layout layout = ZSTDFrameProgression.__struct((Struct.Member[])new Struct.Member[]{ZSTDFrameProgression.__member((int)8), ZSTDFrameProgression.__member((int)8), ZSTDFrameProgression.__member((int)8), ZSTDFrameProgression.__member((int)8), ZSTDFrameProgression.__member((int)4), ZSTDFrameProgression.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        INGESTED = layout.offsetof(0);
        CONSUMED = layout.offsetof(1);
        PRODUCED = layout.offsetof(2);
        FLUSHED = layout.offsetof(3);
        CURRENTJOBID = layout.offsetof(4);
        NBACTIVEWORKERS = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<ZSTDFrameProgression, Buffer>
    implements NativeResource {
        private static final ZSTDFrameProgression ELEMENT_FACTORY = ZSTDFrameProgression.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected ZSTDFrameProgression getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="unsigned long long")
        public long ingested() {
            return ZSTDFrameProgression.ningested(this.address());
        }

        @NativeType(value="unsigned long long")
        public long consumed() {
            return ZSTDFrameProgression.nconsumed(this.address());
        }

        @NativeType(value="unsigned long long")
        public long produced() {
            return ZSTDFrameProgression.nproduced(this.address());
        }

        @NativeType(value="unsigned long long")
        public long flushed() {
            return ZSTDFrameProgression.nflushed(this.address());
        }

        @NativeType(value="unsigned int")
        public int currentJobID() {
            return ZSTDFrameProgression.ncurrentJobID(this.address());
        }

        @NativeType(value="unsigned int")
        public int nbActiveWorkers() {
            return ZSTDFrameProgression.nnbActiveWorkers(this.address());
        }
    }
}

