/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.zstd;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct ZSTD_frameParameters")
public class ZSTDFrameParameters
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int CONTENTSIZEFLAG;
    public static final int CHECKSUMFLAG;
    public static final int NODICTIDFLAG;

    public ZSTDFrameParameters(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), ZSTDFrameParameters.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public int contentSizeFlag() {
        return ZSTDFrameParameters.ncontentSizeFlag(this.address());
    }

    public int checksumFlag() {
        return ZSTDFrameParameters.nchecksumFlag(this.address());
    }

    public int noDictIDFlag() {
        return ZSTDFrameParameters.nnoDictIDFlag(this.address());
    }

    public ZSTDFrameParameters contentSizeFlag(int value) {
        ZSTDFrameParameters.ncontentSizeFlag(this.address(), value);
        return this;
    }

    public ZSTDFrameParameters checksumFlag(int value) {
        ZSTDFrameParameters.nchecksumFlag(this.address(), value);
        return this;
    }

    public ZSTDFrameParameters noDictIDFlag(int value) {
        ZSTDFrameParameters.nnoDictIDFlag(this.address(), value);
        return this;
    }

    public ZSTDFrameParameters set(int contentSizeFlag, int checksumFlag, int noDictIDFlag) {
        this.contentSizeFlag(contentSizeFlag);
        this.checksumFlag(checksumFlag);
        this.noDictIDFlag(noDictIDFlag);
        return this;
    }

    public ZSTDFrameParameters set(ZSTDFrameParameters src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static ZSTDFrameParameters malloc() {
        return (ZSTDFrameParameters)ZSTDFrameParameters.wrap(ZSTDFrameParameters.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static ZSTDFrameParameters calloc() {
        return (ZSTDFrameParameters)ZSTDFrameParameters.wrap(ZSTDFrameParameters.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static ZSTDFrameParameters create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (ZSTDFrameParameters)ZSTDFrameParameters.wrap(ZSTDFrameParameters.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static ZSTDFrameParameters create(long address) {
        return (ZSTDFrameParameters)ZSTDFrameParameters.wrap(ZSTDFrameParameters.class, (long)address);
    }

    @Nullable
    public static ZSTDFrameParameters createSafe(long address) {
        return address == 0L ? null : (ZSTDFrameParameters)ZSTDFrameParameters.wrap(ZSTDFrameParameters.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)ZSTDFrameParameters.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)ZSTDFrameParameters.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)ZSTDFrameParameters.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = ZSTDFrameParameters.__create((int)capacity, (int)SIZEOF);
        return (Buffer)ZSTDFrameParameters.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)ZSTDFrameParameters.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)ZSTDFrameParameters.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Deprecated
    public static ZSTDFrameParameters mallocStack() {
        return ZSTDFrameParameters.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static ZSTDFrameParameters callocStack() {
        return ZSTDFrameParameters.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static ZSTDFrameParameters mallocStack(MemoryStack stack) {
        return ZSTDFrameParameters.malloc(stack);
    }

    @Deprecated
    public static ZSTDFrameParameters callocStack(MemoryStack stack) {
        return ZSTDFrameParameters.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return ZSTDFrameParameters.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return ZSTDFrameParameters.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return ZSTDFrameParameters.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return ZSTDFrameParameters.calloc(capacity, stack);
    }

    public static ZSTDFrameParameters malloc(MemoryStack stack) {
        return (ZSTDFrameParameters)ZSTDFrameParameters.wrap(ZSTDFrameParameters.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static ZSTDFrameParameters calloc(MemoryStack stack) {
        return (ZSTDFrameParameters)ZSTDFrameParameters.wrap(ZSTDFrameParameters.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)ZSTDFrameParameters.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)ZSTDFrameParameters.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int ncontentSizeFlag(long struct) {
        return UNSAFE.getInt(null, struct + (long)CONTENTSIZEFLAG);
    }

    public static int nchecksumFlag(long struct) {
        return UNSAFE.getInt(null, struct + (long)CHECKSUMFLAG);
    }

    public static int nnoDictIDFlag(long struct) {
        return UNSAFE.getInt(null, struct + (long)NODICTIDFLAG);
    }

    public static void ncontentSizeFlag(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)CONTENTSIZEFLAG, value);
    }

    public static void nchecksumFlag(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)CHECKSUMFLAG, value);
    }

    public static void nnoDictIDFlag(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)NODICTIDFLAG, value);
    }

    static {
        Struct.Layout layout = ZSTDFrameParameters.__struct((Struct.Member[])new Struct.Member[]{ZSTDFrameParameters.__member((int)4), ZSTDFrameParameters.__member((int)4), ZSTDFrameParameters.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        CONTENTSIZEFLAG = layout.offsetof(0);
        CHECKSUMFLAG = layout.offsetof(1);
        NODICTIDFLAG = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<ZSTDFrameParameters, Buffer>
    implements NativeResource {
        private static final ZSTDFrameParameters ELEMENT_FACTORY = ZSTDFrameParameters.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected ZSTDFrameParameters getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public int contentSizeFlag() {
            return ZSTDFrameParameters.ncontentSizeFlag(this.address());
        }

        public int checksumFlag() {
            return ZSTDFrameParameters.nchecksumFlag(this.address());
        }

        public int noDictIDFlag() {
            return ZSTDFrameParameters.nnoDictIDFlag(this.address());
        }

        public Buffer contentSizeFlag(int value) {
            ZSTDFrameParameters.ncontentSizeFlag(this.address(), value);
            return this;
        }

        public Buffer checksumFlag(int value) {
            ZSTDFrameParameters.nchecksumFlag(this.address(), value);
            return this;
        }

        public Buffer noDictIDFlag(int value) {
            ZSTDFrameParameters.nnoDictIDFlag(this.address(), value);
            return this;
        }
    }
}

